/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic.test;

import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.mosaic.SimplePlot;
import edu.mines.jtk.util.Array;
import javax.swing.SwingUtilities;

public class SimplePlotTest {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SimplePlotTest.plot0();
                SimplePlotTest.plot1();
                SimplePlotTest.plot2();
                SimplePlotTest.plot3();
            }
        });
    }

    private static void plot0() {
        float[] f = Array.sin(Array.rampfloat(0.0f, 0.1f, 63));
        SimplePlot.asSequence(f);
    }

    private static void plot1() {
        int nx = 301;
        float dx = 0.1f;
        float fx = 0.0f;
        Sampling sx = new Sampling(nx, dx, fx);
        float[] x = Array.rampfloat(fx, dx, nx);
        float[] f = Array.sub(Array.mul(x, Array.sin(x)), 1.0f);
        SimplePlot.asPoints(sx, f);
    }

    private static void plot2() {
        float[][] f = Array.sin(Array.rampfloat(0.0f, 0.1f, 0.1f, 101, 101));
        SimplePlot.asPixels(f).addColorBar();
    }

    private static void plot3() {
        SimplePlot plot = new SimplePlot();
        plot.addGrid("H-.V-.");
        float[] f = Array.sin(Array.rampfloat(0.0f, 0.1f, 63));
        plot.addPoints(f).setStyle("r-o");
        float[] g = Array.cos(Array.rampfloat(0.0f, 0.1f, 63));
        plot.addPoints(g).setStyle("b-x");
        plot.setTitle("A simple plot of two arrays");
        plot.setVLabel("array value");
        plot.setHLabel("array index");
    }
}

