/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.mosaic.Projector;
import edu.mines.jtk.util.Check;

public class Transcaler {
    private static final double DMIN = -32768.0;
    private static final double DMAX = 32767.0;
    private double _x1u;
    private double _y1u;
    private double _x2u;
    private double _y2u;
    private int _x1d;
    private int _y1d;
    private int _x2d;
    private int _y2d;
    private double _xushift;
    private double _xuscale;
    private double _yushift;
    private double _yuscale;
    private double _xdshift;
    private double _xdscale;
    private double _ydshift;
    private double _ydscale;

    public Transcaler() {
        this(0.0, 0.0, 1.0, 1.0, 0, 0, 1, 1);
    }

    public Transcaler(int width, int height) {
        this(0.0, 0.0, 1.0, 1.0, 0, 0, width - 1, height - 1);
        Check.argument(width > 0, "width>0");
        Check.argument(height > 0, "height>0");
    }

    public Transcaler(double x1u, double y1u, double x2u, double y2u, int x1d, int y1d, int x2d, int y2d) {
        this.setMapping(x1u, y1u, x2u, y2u, x1d, y1d, x2d, y2d);
    }

    public void setMapping(double x1u, double y1u, double x2u, double y2u, int x1d, int y1d, int x2d, int y2d) {
        this._x1u = x1u;
        this._x2u = x2u;
        this._y1u = y1u;
        this._y2u = y2u;
        this._x1d = x1d;
        this._x2d = x2d;
        this._y1d = y1d;
        this._y2d = y2d;
        this.computeShiftAndScale();
    }

    public void setMapping(double x1u, double y1u, double x2u, double y2u) {
        this._x1u = x1u;
        this._x2u = x2u;
        this._y1u = y1u;
        this._y2u = y2u;
        this.computeShiftAndScale();
    }

    public void setMapping(int x1d, int y1d, int x2d, int y2d) {
        this._x1d = x1d;
        this._x2d = x2d;
        this._y1d = y1d;
        this._y2d = y2d;
        this.computeShiftAndScale();
    }

    public void setMapping(int width, int height) {
        Check.argument(width > 0, "width>0");
        Check.argument(height > 0, "height>0");
        this.setMapping(0, 0, width - 1, height - 1);
    }

    public Transcaler combineWith(Projector xp, Projector yp) {
        double x1v = xp.v(this._x1u);
        double y1v = yp.v(this._y1u);
        double x2v = xp.v(this._x2u);
        double y2v = yp.v(this._y2u);
        return new Transcaler(x1v, y1v, x2v, y2v, this._x1d, this._y1d, this._x2d, this._y2d);
    }

    public int x(double xu) {
        double xd = this._xushift + this._xuscale * xu;
        if (xd < -32768.0) {
            xd = -32768.0;
        } else if (xd > 32767.0) {
            xd = 32767.0;
        }
        return (int)xd;
    }

    public int y(double yu) {
        double yd = this._yushift + this._yuscale * yu;
        if (yd < -32768.0) {
            yd = -32768.0;
        } else if (yd > 32767.0) {
            yd = 32767.0;
        }
        return (int)yd;
    }

    public int width(double wu) {
        double wd = this._xuscale * wu;
        if (wd < -32768.0) {
            wd = -32768.0;
        } else if (wd > 32767.0) {
            wd = 32767.0;
        }
        return (int)(wd + 1.5);
    }

    public int height(double hu) {
        double hd = this._yuscale * hu;
        if (hd < -32768.0) {
            hd = -32768.0;
        } else if (hd > 32767.0) {
            hd = 32767.0;
        }
        return (int)(hd + 1.5);
    }

    public double x(int xd) {
        return this._xdshift + this._xdscale * (double)xd;
    }

    public double y(int yd) {
        return this._ydshift + this._ydscale * (double)yd;
    }

    public double width(int wd) {
        return this._xdscale * (double)(wd - 1);
    }

    public double height(int hd) {
        return this._ydscale * (double)(hd - 1);
    }

    private void computeShiftAndScale() {
        if (this._x1u != this._x2u) {
            this._xuscale = (double)(this._x2d - this._x1d) / (this._x2u - this._x1u);
            this._xushift = (double)this._x1d - this._x1u * this._xuscale + 0.5;
        } else {
            this._xushift = 0.5 * (double)(this._x1d + this._x2d) + 0.5;
            this._xuscale = 0.0;
        }
        if (this._x1d != this._x2d) {
            this._xdscale = (this._x2u - this._x1u) / (double)(this._x2d - this._x1d);
            this._xdshift = this._x1u - (double)this._x1d * this._xdscale;
        } else {
            this._xdshift = 0.5 * (this._x1u + this._x2u);
            this._xdscale = 0.0;
        }
        if (this._y1u != this._y2u) {
            this._yuscale = (double)(this._y2d - this._y1d) / (this._y2u - this._y1u);
            this._yushift = (double)this._y1d - this._y1u * this._yuscale + 0.5;
        } else {
            this._yushift = 0.5 * (double)(this._y1d + this._y2d) + 0.5;
            this._yuscale = 0.0;
        }
        if (this._y1d != this._y2d) {
            this._ydscale = (this._y2u - this._y1u) / (double)(this._y2d - this._y1d);
            this._ydshift = this._y1u - (double)this._y1d * this._ydscale;
        } else {
            this._ydshift = 0.5 * (this._y1u + this._y2u);
            this._ydscale = 0.0;
        }
    }
}

