/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.awt.Mode;
import edu.mines.jtk.awt.ModeManager;
import edu.mines.jtk.mosaic.DRectangle;
import edu.mines.jtk.mosaic.Mosaic;
import edu.mines.jtk.mosaic.Tile;
import edu.mines.jtk.mosaic.TileAxis;
import edu.mines.jtk.mosaic.Transcaler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class TileZoomMode
extends Mode {
    private static final long serialVersionUID = 1L;
    private Tile _tile;
    private TileAxis _axis;
    private int _xbegin;
    private int _ybegin;
    private int _xdraw;
    private int _ydraw;
    private MouseListener _ml = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            TileZoomMode.this.beginZoom(e);
        }

        public void mouseReleased(MouseEvent e) {
            TileZoomMode.this.endZoom(e);
        }
    };
    private MouseMotionListener _mml = new MouseMotionAdapter(){

        public void mouseDragged(MouseEvent e) {
            TileZoomMode.this.duringZoom(e);
        }
    };

    public TileZoomMode(ModeManager modeManager) {
        super(modeManager);
        this.setName("Zoom");
        this.setIcon(TileZoomMode.loadIcon(TileZoomMode.class, "resources/ZoomIn16.gif"));
        this.setMnemonicKey(90);
        this.setAcceleratorKey(KeyStroke.getKeyStroke(90, 0));
        this.setShortDescription("Zoom in tile or axis");
    }

    protected void setActive(Component component, boolean active) {
        if (component instanceof Tile || component instanceof TileAxis) {
            if (active) {
                component.addMouseListener(this._ml);
            } else {
                component.removeMouseListener(this._ml);
            }
        }
    }

    private void beginZoom(MouseEvent e) {
        this._xbegin = e.getX();
        this._ybegin = e.getY();
        Object source = e.getSource();
        if (source instanceof Tile) {
            Tile tile = this._tile = (Tile)source;
            this.drawZoom(tile, this._xbegin, this._ybegin, true, true);
            tile.addMouseMotionListener(this._mml);
        } else if (source instanceof TileAxis) {
            TileAxis axis = this._axis = (TileAxis)source;
            this.drawZoom(axis, this._xbegin, this._ybegin, this._axis.isHorizontal(), this._axis.isVertical());
            axis.addMouseMotionListener(this._mml);
        }
    }

    private void duringZoom(MouseEvent e) {
        int xdraw = e.getX();
        int ydraw = e.getY();
        if (this._tile != null) {
            this.drawZoom(this._tile, this._xdraw, this._ydraw, true, true);
            this.drawZoom(this._tile, xdraw, ydraw, true, true);
        } else if (this._axis != null) {
            this.drawZoom(this._axis, this._xdraw, this._ydraw, this._axis.isHorizontal(), this._axis.isVertical());
            this.drawZoom(this._axis, xdraw, ydraw, this._axis.isHorizontal(), this._axis.isVertical());
        }
    }

    private void endZoom(MouseEvent e) {
        Tile tile = null;
        boolean zx = false;
        boolean zy = false;
        if (this._tile != null) {
            tile = this._tile;
            zx = true;
            zy = true;
            this.drawZoom(this._tile, this._xdraw, this._ydraw, zx, zy);
            this._tile.removeMouseMotionListener(this._mml);
            this._tile = null;
        } else if (this._axis != null) {
            tile = this._axis.getTile();
            zx = this._axis.isHorizontal();
            zy = this._axis.isVertical();
            this.drawZoom(this._axis, this._xdraw, this._ydraw, zx, zy);
            this._axis.removeMouseMotionListener(this._mml);
            this._axis = null;
        }
        if (tile != null && (zx || zy)) {
            double tiny;
            int xmin = Math.min(this._xbegin, this._xdraw);
            int xmax = Math.max(this._xbegin, this._xdraw);
            int ymin = Math.min(this._ybegin, this._ydraw);
            int ymax = Math.max(this._ybegin, this._ydraw);
            Transcaler ts = tile.getTranscaler();
            DRectangle vr = tile.getViewRectangle();
            if (zx) {
                vr.x = xmin < xmax ? ts.x(xmin) : 0.0;
                double d = vr.width = xmin < xmax ? ts.x(xmax) - vr.x : 1.0;
            }
            if (zy) {
                vr.y = ymin < ymax ? ts.y(ymin) : 0.0;
                double d = vr.height = ymin < ymax ? ts.y(ymax) - vr.y : 1.0;
            }
            if (vr.width < (tiny = 1.0E-4)) {
                vr.x -= (tiny - vr.width) / 2.0;
                vr.width = tiny;
            }
            if (vr.height < tiny) {
                vr.y -= (tiny - vr.height) / 2.0;
                vr.height = tiny;
            }
            vr.x = Math.min(1.0 - vr.width, vr.x);
            vr.y = Math.min(1.0 - vr.height, vr.y);
            tile.setViewRectangle(vr);
        }
    }

    private void drawZoom(Tile tile, int x, int y, boolean bx, boolean by) {
        if (tile == null) {
            return;
        }
        if (tile == this._tile) {
            x = Math.max(0, Math.min(tile.getWidth() - 1, x));
            y = Math.max(0, Math.min(tile.getHeight() - 1, y));
            this.drawRect(tile, x, y, bx, by);
            Mosaic mosaic = tile.getMosaic();
            int jrow = tile.getRowIndex();
            int jcol = tile.getColumnIndex();
            int nrow = mosaic.countRows();
            int ncol = mosaic.countColumns();
            for (int irow = 0; irow < nrow; ++irow) {
                if (irow == jrow) continue;
                this.drawZoom(mosaic.getTile(irow, jcol), x, y, true, false);
            }
            for (int icol = 0; icol < ncol; ++icol) {
                if (icol == jcol) continue;
                this.drawZoom(mosaic.getTile(jrow, icol), x, y, false, true);
            }
            this.drawZoom(mosaic.getTileAxisTop(jcol), x, y, true, false);
            this.drawZoom(mosaic.getTileAxisLeft(jrow), x, y, false, true);
            this.drawZoom(mosaic.getTileAxisBottom(jcol), x, y, true, false);
            this.drawZoom(mosaic.getTileAxisRight(jrow), x, y, false, true);
        } else {
            this.drawRect(tile, x, y, bx, by);
        }
    }

    private void drawZoom(TileAxis axis, int x, int y, boolean bx, boolean by) {
        if (axis == null) {
            return;
        }
        if (axis == this._axis) {
            x = Math.max(0, Math.min(axis.getWidth() - 1, x));
            y = Math.max(0, Math.min(axis.getHeight() - 1, y));
            this.drawRect(axis, x, y, bx, by);
            Mosaic mosaic = axis.getMosaic();
            if (axis.isHorizontal()) {
                int jcol = axis.getIndex();
                int nrow = mosaic.countRows();
                for (int irow = 0; irow < nrow; ++irow) {
                    this.drawZoom(mosaic.getTile(irow, jcol), x, y, true, false);
                }
                if (axis.isTop()) {
                    this.drawZoom(mosaic.getTileAxisBottom(jcol), x, y, true, false);
                } else {
                    this.drawZoom(mosaic.getTileAxisTop(jcol), x, y, true, false);
                }
            } else {
                int jrow = axis.getIndex();
                int ncol = mosaic.countColumns();
                for (int icol = 0; icol < ncol; ++icol) {
                    this.drawZoom(mosaic.getTile(jrow, icol), x, y, false, true);
                }
                if (axis.isLeft()) {
                    this.drawZoom(mosaic.getTileAxisRight(jrow), x, y, false, true);
                } else {
                    this.drawZoom(mosaic.getTileAxisLeft(jrow), x, y, false, true);
                }
            }
        } else {
            this.drawRect(axis, x, y, bx, by);
        }
    }

    private void drawRect(JComponent c, int x, int y, boolean bx, boolean by) {
        this._xdraw = x;
        this._ydraw = y;
        int xmin = bx ? Math.min(this._xbegin, this._xdraw) : -1;
        int xmax = bx ? Math.max(this._xbegin, this._xdraw) : c.getWidth();
        int ymin = by ? Math.min(this._ybegin, this._ydraw) : -1;
        int ymax = by ? Math.max(this._ybegin, this._ydraw) : c.getHeight();
        Graphics g = c.getGraphics();
        g.setColor(Color.RED);
        g.setXORMode(c.getBackground());
        g.drawRect(xmin, ymin, xmax - xmin, ymax - ymin);
        g.dispose();
    }
}

