/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.mosaic.IPanel;
import edu.mines.jtk.mosaic.Mosaic;
import edu.mines.jtk.mosaic.Projector;
import edu.mines.jtk.mosaic.Tile;
import edu.mines.jtk.mosaic.Transcaler;
import edu.mines.jtk.util.AxisTics;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class TileAxis
extends IPanel {
    private static final long serialVersionUID = 1L;
    private int _widthMinimum;
    private Mosaic _mosaic;
    private Placement _placement;
    private int _index;
    private String _label;
    private String _format = "%1.4G";
    private int _xtrack;
    private int _ytrack;
    private boolean _tracking;
    private double _interval;
    private int _ticLabelWidth;
    private int _ticLabelHeight;
    private AxisTics _axisTics;

    public Mosaic getMosaic() {
        return this._mosaic;
    }

    public int getIndex() {
        return this._index;
    }

    public Placement getPlacement() {
        return this._placement;
    }

    public Tile getTile() {
        if (this.isTop()) {
            return this._mosaic.getTile(0, this._index);
        }
        if (this.isLeft()) {
            return this._mosaic.getTile(this._index, 0);
        }
        if (this.isBottom()) {
            int irow = this._mosaic.countRows() - 1;
            return this._mosaic.getTile(irow, this._index);
        }
        if (this.isRight()) {
            int icol = this._mosaic.countColumns() - 1;
            return this._mosaic.getTile(this._index, icol);
        }
        return null;
    }

    public boolean isTop() {
        return this._placement == Placement.TOP;
    }

    public boolean isLeft() {
        return this._placement == Placement.LEFT;
    }

    public boolean isBottom() {
        return this._placement == Placement.BOTTOM;
    }

    public boolean isRight() {
        return this._placement == Placement.RIGHT;
    }

    public boolean isHorizontal() {
        return this._placement == Placement.TOP || this._placement == Placement.BOTTOM;
    }

    public boolean isVertical() {
        return this._placement == Placement.LEFT || this._placement == Placement.RIGHT;
    }

    public void setInterval(double interval) {
        this._interval = interval;
        this.updateAxisTics();
        this.repaint();
    }

    public void setLabel(String label) {
        this._label = label;
        this.updateAxisTics();
        this.repaint();
    }

    public void setFormat(String format) {
        this._format = format;
        this.updateAxisTics();
        this.repaint();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.updateAxisTics();
        this.repaint();
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.updateAxisTics();
        this.repaint();
    }

    public AxisTics getAxisTics() {
        return this._axisTics;
    }

    public void paintToRect(Graphics2D g2d, int x, int y, int w, int h) {
        if (this._axisTics == null) {
            return;
        }
        Tile tile = this.getTile();
        if (tile == null) {
            return;
        }
        g2d = this.createGraphics(g2d, x, y, w, h);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Projector p = this.isHorizontal() ? tile.getHorizontalProjector() : tile.getVerticalProjector();
        Transcaler t = tile.getTranscaler(w, h);
        Font font = g2d.getFont();
        FontMetrics fm = g2d.getFontMetrics();
        FontRenderContext frc = g2d.getFontRenderContext();
        LineMetrics lm = font.getLineMetrics("0.123456789", frc);
        int fh = Math.round(lm.getHeight());
        int fa = Math.round(lm.getAscent());
        int fd = Math.round(lm.getDescent());
        int fl = Math.round(lm.getLeading());
        int tl = 2 * fa / 3;
        boolean isHorizontal = this.isHorizontal();
        boolean isTop = this.isTop();
        boolean isLeft = this.isLeft();
        int nticMajor = this._axisTics.getCountMajor();
        double dticMajor = this._axisTics.getDeltaMajor();
        double fticMajor = this._axisTics.getFirstMajor();
        int nticMinor = this._axisTics.getCountMinor();
        double dticMinor = this._axisTics.getDeltaMinor();
        double fticMinor = this._axisTics.getFirstMinor();
        int mtic = this._axisTics.getMultiple();
        int ktic = (int)Math.round((fticMajor - fticMinor) / dticMinor);
        for (int itic = 0; itic < nticMinor; ++itic) {
            if (itic == ktic) {
                ktic += mtic;
                continue;
            }
            double vtic = fticMinor + (double)itic * dticMinor;
            double utic = p.u(vtic);
            if (isHorizontal) {
                x = t.x(utic);
                if (isTop) {
                    g2d.drawLine(x, h - 1, x, h - 1 - tl / 2);
                    continue;
                }
                g2d.drawLine(x, 0, x, tl / 2);
                continue;
            }
            y = t.y(utic);
            if (isLeft) {
                g2d.drawLine(w - 1, y, w - 1 - tl / 2, y);
                continue;
            }
            g2d.drawLine(0, y, tl / 2, y);
        }
        int wsmax = 0;
        double tiny = 1.0E-6 * Math.abs(dticMajor);
        for (int itic = 0; itic < nticMajor; ++itic) {
            int ys;
            int xs;
            int ws;
            double vtic = fticMajor + (double)itic * dticMajor;
            double utic = p.u(vtic);
            if (Math.abs(vtic) < tiny) {
                vtic = 0.0;
            }
            String stic = this.formatTic(vtic);
            if (isHorizontal) {
                x = t.x(utic);
                if (isTop) {
                    y = h - 1;
                    g2d.drawLine(x, y, x, y - tl);
                    y -= tl + fd;
                } else {
                    y = 0;
                    g2d.drawLine(x, y, x, y + tl);
                    y += tl + fa;
                }
                ws = fm.stringWidth(stic);
                xs = Math.max(0, Math.min(w - ws, x - ws / 2));
                ys = y;
                g2d.drawString(stic, xs, ys);
                continue;
            }
            y = t.y(utic);
            if (isLeft) {
                x = w - 1;
                g2d.drawLine(x, y, x - tl, y);
                x -= tl + fd;
            } else {
                x = 0;
                g2d.drawLine(x, y, x + tl, y);
                x += tl + fd;
            }
            ws = fm.stringWidth(stic);
            if (ws > wsmax) {
                wsmax = ws;
            }
            xs = isLeft ? x - ws : x;
            ys = Math.max(fa, Math.min(h - 1, y + (int)Math.round(0.3 * (double)fa)));
            g2d.drawString(stic, xs, ys);
        }
        if (this._label != null) {
            int wl;
            if (isHorizontal) {
                wl = fm.stringWidth(this._label);
                int xl = Math.max(0, Math.min(w - wl, (w - wl) / 2));
                int yl = isTop ? h - 1 - tl - fh - fd : tl + fh + fa;
                g2d.drawString(this._label, xl, yl);
            } else {
                wl = fm.stringWidth(this._label);
                int xl = isLeft ? fa + fd : w - 1 - fd - fd - fl;
                int yl = Math.max(wl, Math.min(h, (h + wl) / 2));
                g2d.translate(xl, yl);
                g2d.rotate(-1.5707963267948966);
                g2d.drawString(this._label, 0, 0);
                g2d.rotate(1.5707963267948966);
                g2d.translate(-xl, -yl);
            }
        }
        g2d.dispose();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.endTracking();
        this.paintToRect((Graphics2D)g, 0, 0, this.getWidth(), this.getHeight());
    }

    TileAxis(Mosaic mosaic, Placement placement, int index) {
        this._mosaic = mosaic;
        this._placement = placement;
        this._index = index;
        mosaic.add(this);
    }

    int getWidthMinimum() {
        if (this._widthMinimum != 0) {
            return this._widthMinimum;
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int ticLabelWidth = this._ticLabelWidth;
        if (ticLabelWidth == 0) {
            ticLabelWidth = this.maxTicLabelWidth(fm);
        }
        int width = 0;
        if (this.isVertical()) {
            width = ticLabelWidth + fm.getHeight();
            if (this._label != null) {
                width += fm.getHeight();
            }
        } else {
            width = 50;
            if (this._label != null) {
                width = Math.max(width, fm.stringWidth(this._label));
            }
        }
        return width;
    }

    void setWidthMinimum(int widthMinimum) {
        this._widthMinimum = widthMinimum;
    }

    int getHeightMinimum() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int height = 0;
        if (this.isHorizontal()) {
            height = fm.getHeight() + fm.getAscent();
            if (this._label != null) {
                height += fm.getHeight();
            }
        } else {
            height = 50;
            if (this._label != null) {
                height = Math.max(height, fm.stringWidth(this._label));
            }
        }
        return height;
    }

    void updateAxisTics() {
        double du;
        double u1;
        double u0;
        Tile tile = this.getTile();
        if (tile == null) {
            return;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        if (w == 0 || h == 0) {
            return;
        }
        Projector p = this.isHorizontal() ? tile.getHorizontalProjector() : tile.getVerticalProjector();
        Transcaler t = tile.getTranscaler(w, h);
        Font font = this.getFont();
        FontRenderContext frc = new FontRenderContext(null, true, false);
        boolean isHorizontal = this.isHorizontal();
        double umin = p.u0();
        double umax = p.u1();
        double vmin = Math.min(p.v0(), p.v1());
        double vmax = Math.max(p.v0(), p.v1());
        if (isHorizontal) {
            u0 = Math.max(umin, t.x(0));
            u1 = Math.min(umax, t.x(w - 1));
            du = Math.min(umax - umin, t.width(w));
        } else {
            u0 = Math.max(umin, t.y(0));
            u1 = Math.min(umax, t.y(h - 1));
            du = Math.min(umax - umin, t.height(h));
        }
        double v0 = Math.max(vmin, Math.min(vmax, p.v(u0)));
        double v1 = Math.max(vmin, Math.min(vmax, p.v(u1)));
        double dv = Math.abs(p.v(u0 + du) - p.v(u0));
        int ticLabelWidth = 0;
        int ticLabelHeight = 0;
        int ntic = 0;
        double dtic = 0.0;
        int nmax = 20;
        while (nmax >= 2) {
            AxisTics at = this._interval == 0.0 ? new AxisTics(vmin, vmin + dv, nmax) : new AxisTics(vmin, vmin + dv, this._interval);
            ntic = at.getCountMajor();
            dtic = at.getDeltaMajor();
            double va = Math.ceil(vmin / dtic) * dtic;
            double vb = Math.floor(vmax / dtic) * dtic;
            Rectangle2D.Double r = new Rectangle2D.Double();
            Rectangle2D.union(font.getStringBounds(this.formatTic(va), frc), r, r);
            Rectangle2D.union(font.getStringBounds(this.formatTic(va + dtic), frc), r, r);
            Rectangle2D.union(font.getStringBounds(this.formatTic(vb - dtic), frc), r, r);
            Rectangle2D.union(font.getStringBounds(this.formatTic(vb), frc), r, r);
            ticLabelWidth = (int)Math.ceil(r.width);
            ticLabelHeight = (int)Math.ceil(r.height);
            if (this._interval != 0.0 || (isHorizontal ? (double)(ticLabelWidth * ntic) < 0.7 * (double)w : (double)(ticLabelHeight * ntic) < 0.6 * (double)h)) break;
            nmax = ntic - 1;
        }
        this._axisTics = new AxisTics(v0, v1, dtic);
        if (this._ticLabelWidth != ticLabelWidth || this._ticLabelHeight != ticLabelHeight) {
            this._ticLabelWidth = ticLabelWidth;
            this._ticLabelHeight = ticLabelHeight;
            this.revalidateLater();
            return;
        }
    }

    void beginTracking(int x, int y) {
        if (!this._tracking) {
            this._xtrack = x;
            this._ytrack = y;
            this._tracking = true;
            this.paintTrack(x, y);
        }
    }

    void duringTracking(int x, int y) {
        if (this._tracking) {
            this.paintTrack(this._xtrack, this._ytrack);
        }
        this._xtrack = x;
        this._ytrack = y;
        this._tracking = true;
        this.paintTrack(this._xtrack, this._ytrack);
    }

    void endTracking() {
        if (this._tracking) {
            this.paintTrack(this._xtrack, this._ytrack);
            this._tracking = false;
        }
    }

    private void paintTrack(int x, int y) {
        int w = this.getWidth();
        int h = this.getHeight();
        Graphics g = this.getGraphics();
        g.setColor(Color.BLUE);
        g.setXORMode(this.getBackground());
        if (this.isHorizontal()) {
            g.drawLine(x, -1, x, h);
        } else {
            g.drawLine(-1, y, w, y);
        }
        g.dispose();
    }

    private int maxTicLabelWidth(FontMetrics fm) {
        double vtic = -0.0123456789;
        return fm.stringWidth(this.formatTic(vtic));
    }

    private String formatTic(double v) {
        int ibeg;
        String s = String.format(this._format, v);
        int len = s.length();
        int iend = s.indexOf(101);
        if (iend < 0) {
            iend = s.indexOf(69);
        }
        if (iend < 0) {
            iend = len;
        }
        if (s.indexOf(46) > 0) {
            for (ibeg = iend; ibeg > 0 && s.charAt(ibeg - 1) == '0'; --ibeg) {
            }
            if (ibeg > 0 && s.charAt(ibeg - 1) == '.') {
                --ibeg;
            }
        }
        if (ibeg < iend) {
            String sb = s.substring(0, ibeg);
            s = iend < len ? sb + s.substring(iend, len) : sb;
        }
        return s;
    }

    private void revalidateLater() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TileAxis.this.invalidate();
                RepaintManager.currentManager(TileAxis.this).addInvalidComponent(TileAxis.this);
                RepaintManager.currentManager(TileAxis.this).validateInvalidComponents();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Placement {
        TOP,
        LEFT,
        BOTTOM,
        RIGHT;

    }
}

