/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.mosaic.DRectangle;
import edu.mines.jtk.mosaic.IPanel;
import edu.mines.jtk.mosaic.Mosaic;
import edu.mines.jtk.mosaic.Projector;
import edu.mines.jtk.mosaic.TileAxis;
import edu.mines.jtk.mosaic.TiledView;
import edu.mines.jtk.mosaic.Transcaler;
import edu.mines.jtk.util.Check;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tile
extends IPanel {
    private static final long serialVersionUID = 1L;
    private Mosaic _mosaic;
    private int _irow;
    private int _icol;
    private ArrayList<TiledView> _tvs = new ArrayList();
    private Projector _hp = new Projector(0.0, 1.0, 0.0, 1.0);
    private Projector _vp = new Projector(0.0, 1.0, 0.0, 1.0);
    private Projector _bhp;
    private Projector _bvp;
    private Projector _shp;
    private Projector _svp;
    private Transcaler _ts = new Transcaler();
    private DRectangle _vr = new DRectangle(0.0, 0.0, 1.0, 1.0);

    public Mosaic getMosaic() {
        return this._mosaic;
    }

    public int getRowIndex() {
        return this._irow;
    }

    public int getColumnIndex() {
        return this._icol;
    }

    public void setBestHorizontalProjector(Projector bhp) {
        this._shp = bhp;
        this.alignProjectors();
    }

    public void setBestVerticalProjector(Projector bvp) {
        this._svp = bvp;
        this.alignProjectors();
    }

    public Projector getHorizontalProjector() {
        return this._hp;
    }

    public Projector getVerticalProjector() {
        return this._vp;
    }

    public Transcaler getTranscaler() {
        return this._ts;
    }

    public boolean addTiledView(TiledView tv) {
        boolean removed = this._tvs.remove(tv);
        this._tvs.add(tv);
        tv.setTile(this);
        this.alignProjectors();
        return !removed;
    }

    public boolean removeTiledView(TiledView tv) {
        if (this._tvs.remove(tv)) {
            tv.setTile(null);
            this.alignProjectors();
            return true;
        }
        return false;
    }

    public int countTiledViews() {
        return this._tvs.size();
    }

    public TiledView getTiledView(int index) {
        return this._tvs.get(index);
    }

    public Iterator<TiledView> getTiledViews() {
        return this._tvs.iterator();
    }

    public DRectangle getViewRectangle() {
        return new DRectangle(this._vr);
    }

    public void setViewRectangle(DRectangle vr) {
        this._mosaic.setViewRect(this, vr);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this._ts.setMapping(width, height);
    }

    public TileAxis getTileAxisTop() {
        return this._mosaic.getTileAxisTop(this._icol);
    }

    public TileAxis getTileAxisLeft() {
        return this._mosaic.getTileAxisLeft(this._irow);
    }

    public TileAxis getTileAxisBottom() {
        return this._mosaic.getTileAxisBottom(this._icol);
    }

    public TileAxis getTileAxisRight() {
        return this._mosaic.getTileAxisRight(this._irow);
    }

    @Override
    public void paintToRect(Graphics2D g2d, int x, int y, int w, int h) {
        g2d = this.createGraphics(g2d, x, y, w, h);
        Transcaler tsPanel = this._ts;
        this._ts = this.getTranscaler(w, h);
        for (TiledView tv : this._tvs) {
            Graphics2D gtv = (Graphics2D)g2d.create();
            tv.paint(gtv);
            gtv.dispose();
        }
        this._ts = tsPanel;
        g2d.dispose();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintToRect((Graphics2D)g, 0, 0, this.getWidth(), this.getHeight());
    }

    Tile(Mosaic mosaic, int irow, int icol) {
        this._mosaic = mosaic;
        this._irow = irow;
        this._icol = icol;
        mosaic.add(this);
    }

    Projector getBestHorizontalProjector() {
        return this._bhp;
    }

    Projector getBestVerticalProjector() {
        return this._bvp;
    }

    void setProjectors(Projector hp, Projector vp) {
        Check.argument(hp != null, "horizontal projector not null");
        Check.argument(vp != null, "vertical projector not null");
        this._hp = hp;
        this._vp = vp;
        this.repaint();
    }

    void setHorizontalProjector(Projector hp) {
        Check.argument(hp != null, "horizontal projector not null");
        this._hp = hp;
        this.repaint();
    }

    void setVerticalProjector(Projector vp) {
        Check.argument(vp != null, "vertical projector not null");
        this._vp = vp;
        this.repaint();
    }

    void alignProjectors() {
        this.updateBestProjectors();
        this._mosaic.alignProjectors(this);
    }

    void setViewRect(DRectangle vr) {
        this._vr = new DRectangle(vr);
        this._vr.x = Math.max(0.0, Math.min(1.0, this._vr.x));
        this._vr.y = Math.max(0.0, Math.min(1.0, this._vr.y));
        this._vr.width = Math.max(0.0, Math.min(1.0 - this._vr.x, this._vr.width));
        this._vr.height = Math.max(0.0, Math.min(1.0 - this._vr.y, this._vr.height));
        this._ts.setMapping(this._vr.x, this._vr.y, this._vr.x + this._vr.width, this._vr.y + this._vr.height);
        this.repaint();
    }

    Transcaler getTranscaler(int w, int h) {
        return new Transcaler(this._vr.x, this._vr.y, this._vr.x + this._vr.width, this._vr.y + this._vr.height, 0, 0, w - 1, h - 1);
    }

    private void updateBestProjectors() {
        TiledView tv;
        int itv;
        Projector bhp = null;
        Projector bvp = null;
        int ntv = this._tvs.size();
        if (this._shp == null) {
            for (itv = ntv - 1; bhp == null && itv >= 0; --itv) {
                tv = this._tvs.get(itv);
                bhp = tv.getBestHorizontalProjector();
            }
            while (itv >= 0) {
                tv = this._tvs.get(itv);
                bhp.merge(tv.getBestHorizontalProjector());
                --itv;
            }
        }
        if (this._svp == null) {
            for (itv = ntv - 1; bvp == null && itv >= 0; --itv) {
                tv = this._tvs.get(itv);
                bvp = tv.getBestVerticalProjector();
            }
            while (itv >= 0) {
                tv = this._tvs.get(itv);
                bvp.merge(tv.getBestVerticalProjector());
                --itv;
            }
        }
        this._bhp = this._shp != null ? this._shp : bhp;
        this._bvp = this._svp != null ? this._svp : bvp;
    }
}

