/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.util.Check;
import edu.mines.jtk.util.MathPlus;

public class Projector {
    private double _u0;
    private double _u1;
    private double _v0;
    private double _v1;
    private double _ushift;
    private double _uscale;
    private double _vshift;
    private double _vscale;

    public Projector(double v0, double v1) {
        this(v0, v1, 0.0, 1.0);
    }

    public Projector(double v0, double v1, double u0, double u1) {
        Check.argument(0.0 <= u0, "0.0 <= u0");
        Check.argument(u0 < u1, "u0 < u1");
        Check.argument(u1 <= 1.0, "u1 <= 1.0");
        Check.argument(v0 != v1, "v0 != v1");
        this._u0 = u0;
        this._u1 = u1;
        this._v0 = v0;
        this._v1 = v1;
        this.computeShiftsAndScales();
    }

    public Projector(Projector p) {
        this(p._v0, p._v1, p._u0, p._u1);
    }

    public double u(double v) {
        return this._vshift + this._vscale * v;
    }

    public double v(double u) {
        return this._ushift + this._uscale * u;
    }

    public double u0() {
        return this._u0;
    }

    public double u1() {
        return this._u1;
    }

    public double v0() {
        return this._v0;
    }

    public double v1() {
        return this._v1;
    }

    public void merge(Projector p) {
        if (p == null) {
            return;
        }
        double u0a = this._u0;
        double u1a = this._u1;
        double v0a = this._v0;
        double v1a = this._v1;
        double u0b = p._u0;
        double u1b = p._u1;
        double v0b = p._v0;
        double v1b = p._v1;
        double vmin = MathPlus.min(MathPlus.min(v0a, v1a), MathPlus.min(v0b, v1b));
        double vmax = MathPlus.max(MathPlus.max(v0a, v1a), MathPlus.max(v0b, v1b));
        this._v0 = v0a < v1a ? vmin : vmax;
        this._v1 = v0a < v1a ? vmax : vmin;
        double r0a = (v0a - this._v0) / (this._v1 - this._v0);
        double r0b = (v0b - this._v0) / (this._v1 - this._v0);
        double r1a = (v1a - this._v0) / (this._v1 - this._v0);
        double r1b = (v1b - this._v0) / (this._v1 - this._v0);
        if (r1b < 0.0) {
            r0b = -r0b;
            r1b = -r1b;
            double u0t = u0b;
            u0b = 1.0 - u1b;
            u1b = 1.0 - u0t;
            double v0t = v0b;
            v0b = v1b;
            v1b = v0t;
        }
        double u0 = 0.0;
        double u1 = 1.0;
        int niter = 0;
        do {
            this._u0 = u0;
            this._u1 = u1;
            u0 = MathPlus.max((u0a - r0a * this._u1) / (1.0 - r0a), (u0b - r0b * this._u1) / (1.0 - r0b));
            u1 = MathPlus.min((u1a - (1.0 - r1a) * this._u0) / r1a, (u1b - (1.0 - r1b) * this._u0) / r1b);
        } while ((this._u0 < u0 || u1 < this._u1) && ++niter < 10);
        assert (niter < 10) : "niter<10";
        assert (0.0 <= this._u0 && this._u0 < this._u1 && this._u1 <= 1.0) : "_u0 and _u1 valid";
        this.computeShiftsAndScales();
    }

    public double getScaleRatio(Projector p) {
        return this._vscale / p._vscale;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Projector that = (Projector)obj;
        return this._u0 == that._u0 && this._u1 == that._u1 && this._v0 == that._v0 && this._v1 == that._v1;
    }

    public int hashCode() {
        long u0bits = Double.doubleToLongBits(this._u0);
        long u1bits = Double.doubleToLongBits(this._u1);
        long v0bits = Double.doubleToLongBits(this._v0);
        long v1bits = Double.doubleToLongBits(this._v1);
        return (int)(u0bits ^ u0bits >>> 32 ^ u1bits ^ u1bits >>> 32 ^ v0bits ^ v0bits >>> 32 ^ v1bits ^ v1bits >>> 32);
    }

    private void computeShiftsAndScales() {
        this._uscale = (this._v1 - this._v0) / (this._u1 - this._u0);
        this._ushift = this._v0 - this._uscale * this._u0;
        this._vscale = (this._u1 - this._u0) / (this._v1 - this._v0);
        this._vshift = this._u0 - this._vscale * this._v0;
    }
}

