/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.mosaic.Projector;
import edu.mines.jtk.mosaic.TiledView;
import edu.mines.jtk.mosaic.Transcaler;
import edu.mines.jtk.util.Array;
import edu.mines.jtk.util.Check;
import edu.mines.jtk.util.MathPlus;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.ArrayList;

public class PointsView
extends TiledView {
    int _ns;
    ArrayList<Integer> _nx = new ArrayList();
    ArrayList<float[]> _x1 = new ArrayList();
    ArrayList<float[]> _x2 = new ArrayList();
    int _nxmax;
    private Orientation _orientation = Orientation.X1RIGHT_X2UP;
    private Line _lineStyle = Line.SOLID;
    private float _lineWidth = 0.0f;
    private Color _lineColor = null;
    private Mark _markStyle = Mark.NONE;
    private float _markSize = -1.0f;
    private Color _markColor = null;

    public PointsView(float[] x2) {
        float[] x1 = Array.rampfloat(0.0f, 1.0f, x2.length);
        this.set(x1, x2);
    }

    public PointsView(Sampling s1, float[] x2) {
        this.set(s1, x2);
    }

    public PointsView(float[] x1, float[] x2) {
        this.set(x1, x2);
    }

    public PointsView(float[][] x1, float[][] x2) {
        this.set(x1, x2);
    }

    public void set(Sampling s1, float[] x2) {
        Check.argument(s1.getCount() == x2.length, "s1 count equals x2 length");
        int n1 = x2.length;
        float[] x1 = new float[n1];
        for (int i1 = 0; i1 < n1; ++i1) {
            x1[i1] = (float)s1.getValue(i1);
        }
        this.set(x1, x2);
    }

    public void set(float[] x1, float[] x2) {
        Check.argument(x1.length == x2.length, "x1.length equals x2.length");
        this._ns = 1;
        this._nx.clear();
        this._x1.clear();
        this._x2.clear();
        this._nxmax = x1.length;
        this._nx.add(x1.length);
        this._x1.add(Array.copy(x1));
        this._x2.add(Array.copy(x2));
        this.updateBestProjectors();
        this.repaint();
    }

    public void set(float[][] x1, float[][] x2) {
        Check.argument(x1.length == x2.length, "x1.length equals x2.length");
        this._ns = x1.length;
        this._nx.clear();
        this._x1.clear();
        this._x2.clear();
        this._nxmax = 0;
        for (int is = 0; is < this._ns; ++is) {
            Check.argument(x1[is].length == x2[is].length, "x1[i].length equals x2[i].length");
            this._nxmax = MathPlus.max(this._nxmax, x1[is].length);
            this._nx.add(x1[is].length);
            this._x1.add(Array.copy(x1[is]));
            this._x2.add(Array.copy(x2[is]));
        }
        this.updateBestProjectors();
        this.repaint();
    }

    public void setOrientation(Orientation orientation) {
        if (this._orientation != orientation) {
            this._orientation = orientation;
            this.updateBestProjectors();
            this.repaint();
        }
    }

    public Orientation getOrientation() {
        return this._orientation;
    }

    public void setStyle(String style) {
        if (style.contains("r")) {
            this.setLineColor(Color.RED);
            this.setMarkColor(Color.RED);
        } else if (style.contains("g")) {
            this.setLineColor(Color.GREEN);
            this.setMarkColor(Color.GREEN);
        } else if (style.contains("b")) {
            this.setLineColor(Color.BLUE);
            this.setMarkColor(Color.BLUE);
        } else if (style.contains("c")) {
            this.setLineColor(Color.CYAN);
            this.setMarkColor(Color.CYAN);
        } else if (style.contains("m")) {
            this.setLineColor(Color.MAGENTA);
            this.setMarkColor(Color.MAGENTA);
        } else if (style.contains("y")) {
            this.setLineColor(Color.YELLOW);
            this.setMarkColor(Color.YELLOW);
        } else if (style.contains("k")) {
            this.setLineColor(Color.BLACK);
            this.setMarkColor(Color.BLACK);
        } else if (style.contains("w")) {
            this.setLineColor(Color.WHITE);
            this.setMarkColor(Color.WHITE);
        } else {
            this.setLineColor(null);
            this.setMarkColor(null);
        }
        if (style.contains("--.")) {
            this.setLineStyle(Line.DASH_DOT);
        } else if (style.contains("--")) {
            this.setLineStyle(Line.DASH);
        } else if (style.contains("-.")) {
            this.setLineStyle(Line.DOT);
        } else if (style.contains("-")) {
            this.setLineStyle(Line.SOLID);
        } else {
            this.setLineStyle(Line.NONE);
        }
        if (style.contains("+")) {
            this.setMarkStyle(Mark.PLUS);
        } else if (style.contains("x")) {
            this.setMarkStyle(Mark.CROSS);
        } else if (style.contains("o")) {
            this.setMarkStyle(Mark.HOLLOW_CIRCLE);
        } else if (style.contains("O")) {
            this.setMarkStyle(Mark.FILLED_CIRCLE);
        } else if (style.contains("s")) {
            this.setMarkStyle(Mark.HOLLOW_SQUARE);
        } else if (style.contains("S")) {
            this.setMarkStyle(Mark.FILLED_SQUARE);
        } else if (style.contains(".")) {
            int i = style.indexOf(".");
            if (i == 0 || style.charAt(i - 1) != '-') {
                this.setMarkStyle(Mark.POINT);
            }
        } else {
            this.setMarkStyle(Mark.NONE);
        }
    }

    public void setLineStyle(Line style) {
        this._lineStyle = style;
        this.repaint();
    }

    public void setLineWidth(float width) {
        if (this._lineWidth != width) {
            this._lineWidth = width;
            this.updateBestProjectors();
            this.repaint();
        }
    }

    public void setLineColor(Color color) {
        if (!this.equalColors(this._lineColor, color)) {
            this._lineColor = color;
            this.repaint();
        }
    }

    public void setMarkStyle(Mark style) {
        if (this._markStyle != style) {
            this._markStyle = style;
            this.updateBestProjectors();
            this.repaint();
        }
    }

    public void setMarkSize(float size) {
        if (this._markSize != size) {
            this._markSize = size;
            this.updateBestProjectors();
            this.repaint();
        }
    }

    public void setMarkColor(Color color) {
        if (!this.equalColors(this._markColor, color)) {
            this._markColor = color;
            this.repaint();
        }
    }

    public void paint(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Projector hp = this.getHorizontalProjector();
        Projector vp = this.getVerticalProjector();
        Transcaler ts = this.getTranscaler();
        float fontSize = g2d.getFont().getSize2D();
        float lineWidth = 1.0f;
        Stroke stroke = g2d.getStroke();
        if (stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)stroke;
            lineWidth = bs.getLineWidth();
        }
        Graphics2D gline = null;
        if (this._lineStyle != Line.NONE) {
            gline = (Graphics2D)g2d.create();
            float[] dash = null;
            if (this._lineStyle != Line.SOLID) {
                float dotLength = lineWidth;
                float dashLength = 5.0f * lineWidth;
                float gapLength = 5.0f * lineWidth;
                if (this._lineStyle == Line.DASH) {
                    dash = new float[]{dashLength, gapLength};
                } else if (this._lineStyle == Line.DOT) {
                    dash = new float[]{dotLength, gapLength};
                } else if (this._lineStyle == Line.DASH_DOT) {
                    dash = new float[]{dashLength, gapLength, dotLength, gapLength};
                }
            }
            float width = lineWidth;
            if (this._lineWidth != 0.0f) {
                width *= this._lineWidth;
            }
            BasicStroke bs = null;
            if (dash != null) {
                int cap = 1;
                int join = 1;
                float miter = 10.0f;
                float phase = 0.0f;
                bs = new BasicStroke(width, cap, join, miter, dash, phase);
            } else {
                bs = new BasicStroke(width);
            }
            gline.setStroke(bs);
            if (this._lineColor != null) {
                gline.setColor(this._lineColor);
            }
        }
        Graphics2D gmark = null;
        int markSize = MathPlus.round(fontSize / 2.0f);
        if (this._markStyle != Mark.NONE) {
            gmark = (Graphics2D)g2d.create();
            if (this._markSize >= 0.0f) {
                markSize = MathPlus.round(this._markSize * lineWidth);
            }
            if (this._markColor != null) {
                gmark.setColor(this._markColor);
            }
            float width = lineWidth;
            if (this._lineWidth != 0.0f) {
                width *= this._lineWidth;
            }
            BasicStroke bs = new BasicStroke(width);
            gmark.setStroke(bs);
        }
        int[] x = new int[this._nxmax];
        int[] y = new int[this._nxmax];
        for (int is = 0; is < this._ns; ++is) {
            int n = this._nx.get(is);
            float[] x1 = this._x1.get(is);
            float[] x2 = this._x2.get(is);
            this.computeXY(hp, vp, ts, n, x1, x2, x, y);
            if (gline != null) {
                gline.drawPolyline(x, y, n);
            }
            if (gmark == null) continue;
            if (this._markStyle == Mark.POINT) {
                this.paintPoint(gmark, n, x, y);
                continue;
            }
            if (this._markStyle == Mark.PLUS) {
                this.paintPlus(gmark, markSize, n, x, y);
                continue;
            }
            if (this._markStyle == Mark.CROSS) {
                this.paintCross(gmark, markSize, n, x, y);
                continue;
            }
            if (this._markStyle == Mark.FILLED_CIRCLE) {
                this.paintFilledCircle(gmark, markSize, n, x, y);
                continue;
            }
            if (this._markStyle == Mark.HOLLOW_CIRCLE) {
                this.paintHollowCircle(gmark, markSize, n, x, y);
                continue;
            }
            if (this._markStyle == Mark.FILLED_SQUARE) {
                this.paintFilledSquare(gmark, markSize, n, x, y);
                continue;
            }
            if (this._markStyle != Mark.HOLLOW_SQUARE) continue;
            this.paintHollowSquare(gmark, markSize, n, x, y);
        }
    }

    private void updateBestProjectors() {
        float x1min = Float.MAX_VALUE;
        float x2min = Float.MAX_VALUE;
        float x1max = -3.4028235E38f;
        float x2max = -3.4028235E38f;
        for (int is = 0; is < this._ns; ++is) {
            int nx = this._nx.get(is);
            float[] x1 = this._x1.get(is);
            float[] x2 = this._x2.get(is);
            for (int ix = 0; ix < nx; ++ix) {
                float x1i = x1[ix];
                float x2i = x2[ix];
                x1min = MathPlus.min(x1min, x1i);
                x2min = MathPlus.min(x2min, x2i);
                x1max = MathPlus.max(x1max, x1i);
                x2max = MathPlus.max(x2max, x2i);
            }
        }
        double u0 = 0.0;
        double u1 = 1.0;
        if (this._markStyle != Mark.NONE || this._lineWidth > 1.0f) {
            u0 = 0.01;
            u1 = 0.99;
        }
        Projector bhp = null;
        Projector bvp = null;
        if (this._orientation == Orientation.X1RIGHT_X2UP) {
            bhp = x1min < x1max ? new Projector(x1min, x1max, u0, u1) : null;
            bvp = x2min < x2max ? new Projector(x2max, x2min, u0, u1) : null;
        } else if (this._orientation == Orientation.X1DOWN_X2RIGHT) {
            bhp = x2min < x2max ? new Projector(x2min, x2max, u0, u1) : null;
            bvp = x1min < x1max ? new Projector(x1min, x1max, u0, u1) : null;
        }
        this.setBestProjectors(bhp, bvp);
    }

    private boolean equalColors(Color ca, Color cb) {
        return ca == null ? cb == null : ca.equals(cb);
    }

    private void computeXY(Projector hp, Projector vp, Transcaler ts, int n, float[] x1, float[] x2, int[] x, int[] y) {
        ts = ts.combineWith(hp, vp);
        float[] xv = null;
        float[] yv = null;
        if (this._orientation == Orientation.X1RIGHT_X2UP) {
            xv = x1;
            yv = x2;
        } else if (this._orientation == Orientation.X1DOWN_X2RIGHT) {
            xv = x2;
            yv = x1;
        }
        for (int i = 0; i < n; ++i) {
            x[i] = ts.x(xv[i]);
            y[i] = ts.y(yv[i]);
        }
    }

    private void paintPoint(Graphics2D g2d, int n, int[] x, int[] y) {
        for (int i = 0; i < n; ++i) {
            int xi = x[i];
            int yi = y[i];
            g2d.drawLine(xi, yi, xi, yi);
        }
    }

    private void paintPlus(Graphics2D g2d, int s, int n, int[] x, int[] y) {
        int wh = 2 * (s / 2);
        int xy = wh / 2;
        for (int i = 0; i < n; ++i) {
            int xi = x[i];
            int yi = y[i];
            g2d.drawLine(xi - xy, yi, xi + xy, yi);
            g2d.drawLine(xi, yi - xy, xi, yi + xy);
        }
    }

    private void paintCross(Graphics2D g2d, int s, int n, int[] x, int[] y) {
        int wh = 2 * (s / 2);
        int xy = wh / 2;
        for (int i = 0; i < n; ++i) {
            int xi = x[i];
            int yi = y[i];
            g2d.drawLine(xi - xy, yi - xy, xi + xy, yi + xy);
            g2d.drawLine(xi + xy, yi - xy, xi - xy, yi + xy);
        }
    }

    private void paintFilledCircle(Graphics2D g2d, int s, int n, int[] x, int[] y) {
        int wh = 1 + 2 * (s / 2);
        int xy = wh / 2;
        for (int i = 0; i < n; ++i) {
            g2d.fillOval(x[i] - xy, y[i] - xy, wh, wh);
        }
    }

    private void paintHollowCircle(Graphics2D g2d, int s, int n, int[] x, int[] y) {
        int wh = 1 + 2 * (s / 2);
        int xy = wh / 2;
        for (int i = 0; i < n; ++i) {
            g2d.drawOval(x[i] - xy, y[i] - xy, wh - 1, wh - 1);
        }
    }

    private void paintFilledSquare(Graphics2D g2d, int s, int n, int[] x, int[] y) {
        int wh = 1 + 2 * (s / 2);
        int xy = wh / 2;
        for (int i = 0; i < n; ++i) {
            g2d.fillRect(x[i] - xy, y[i] - xy, wh, wh);
        }
    }

    private void paintHollowSquare(Graphics2D g2d, int s, int n, int[] x, int[] y) {
        int wh = 1 + 2 * (s / 2);
        int xy = wh / 2;
        for (int i = 0; i < n; ++i) {
            g2d.drawRect(x[i] - xy, y[i] - xy, wh - 1, wh - 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Line {
        NONE,
        SOLID,
        DASH,
        DOT,
        DASH_DOT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mark {
        NONE,
        POINT,
        PLUS,
        CROSS,
        ASTERISK,
        HOLLOW_CIRCLE,
        HOLLOW_SQUARE,
        FILLED_CIRCLE,
        FILLED_SQUARE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Orientation {
        X1RIGHT_X2UP,
        X1DOWN_X2RIGHT;

    }
}

