/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.mosaic.ColorBar;
import edu.mines.jtk.mosaic.GridView;
import edu.mines.jtk.mosaic.IPanel;
import edu.mines.jtk.mosaic.Mosaic;
import edu.mines.jtk.mosaic.PixelsView;
import edu.mines.jtk.mosaic.PointsView;
import edu.mines.jtk.mosaic.Projector;
import edu.mines.jtk.mosaic.SequenceView;
import edu.mines.jtk.mosaic.Tile;
import edu.mines.jtk.mosaic.TiledView;
import edu.mines.jtk.util.Check;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.util.EnumSet;

public class PlotPanel
extends IPanel {
    private static final long serialVersionUID = 1L;
    private int _colorBarWidthMinimum = 0;
    private Mosaic _mosaic;
    private ColorBar _colorBar;
    private String _colorBarFormat;
    private String _colorBarLabel;
    private PixelsView _colorBarPixelsView;
    private Title _title;
    private Orientation _orientation;
    private AxesPlacement _axesPlacement;

    public PlotPanel() {
        this(1, 1, Orientation.X1RIGHT_X2UP);
    }

    public PlotPanel(int nrow, int ncol) {
        this(nrow, ncol, Orientation.X1RIGHT_X2UP);
    }

    public PlotPanel(Orientation orientation) {
        this(1, 1, orientation);
    }

    public PlotPanel(int nrow, int ncol, Orientation orientation) {
        this(nrow, ncol, orientation, PlotPanel.axesPlacement(orientation));
    }

    private static AxesPlacement axesPlacement(Orientation orientation) {
        AxesPlacement axesPlacement = orientation == Orientation.X1DOWN_X2RIGHT ? AxesPlacement.LEFT_TOP : AxesPlacement.LEFT_BOTTOM;
        return axesPlacement;
    }

    public PlotPanel(int nrow, int ncol, Orientation orientation, AxesPlacement axesPlacement) {
        this._orientation = orientation;
        this._axesPlacement = axesPlacement;
        this.setLayout(new GridBagLayout());
        EnumSet<Mosaic.AxesPlacement> axesPlacementSet = axesPlacement == AxesPlacement.LEFT_TOP ? EnumSet.of(Mosaic.AxesPlacement.LEFT, Mosaic.AxesPlacement.TOP) : (axesPlacement == AxesPlacement.LEFT_BOTTOM ? EnumSet.of(Mosaic.AxesPlacement.LEFT, Mosaic.AxesPlacement.BOTTOM) : EnumSet.noneOf(Mosaic.AxesPlacement.class));
        this._mosaic = new Mosaic(nrow, ncol, axesPlacementSet);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.fill = 1;
        this.add((Component)this._mosaic, gbc);
        this.setPreferredSize(new Dimension(200 + 300 * ncol, 100 + 300 * nrow));
        this.revalidate();
    }

    public Mosaic getMosaic() {
        return this._mosaic;
    }

    public Tile getTile(int irow, int icol) {
        return this._mosaic.getTile(irow, icol);
    }

    public ColorBar addColorBar() {
        return this.addColorBar(null);
    }

    public ColorBar addColorBar(String label) {
        this._colorBarLabel = label;
        if (this._colorBar == null) {
            this._colorBar = new ColorBar(label);
            this._colorBar.setFont(this.getFont());
            this._colorBar.setForeground(this.getForeground());
            this._colorBar.setBackground(this.getBackground());
            if (this._colorBarFormat != null) {
                this._colorBar.setFormat(this._colorBarFormat);
            }
            if (this._colorBarWidthMinimum != 0) {
                this._colorBar.setWidthMinimum(this._colorBarWidthMinimum);
            }
            if (this._colorBarPixelsView != null) {
                this._colorBarPixelsView.addColorMapListener(this._colorBar);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 1;
                gbc.gridwidth = 1;
                gbc.gridheight = 1;
                gbc.weightx = 0.0;
                gbc.weighty = 0.0;
                gbc.fill = 3;
                gbc.anchor = 17;
                int top = this._mosaic.getHeightAxesTop();
                int left = 25;
                int bottom = this._mosaic.getHeightAxesBottom();
                int right = 0;
                gbc.insets = new Insets(top, left, bottom, right);
                this.add((Component)this._colorBar, gbc);
                this.revalidate();
            }
        } else {
            this._colorBar.setLabel(label);
            this.revalidate();
        }
        return this._colorBar;
    }

    public void setColorBarWidthMinimum(int widthMinimum) {
        this._colorBarWidthMinimum = widthMinimum;
        if (this._colorBar != null) {
            this._colorBar.setWidthMinimum(widthMinimum);
            this.revalidate();
        }
    }

    public void setColorBarFormat(String format) {
        this._colorBarFormat = format;
        if (this._colorBar != null) {
            this._colorBar.setFormat(format);
            this.revalidate();
        }
    }

    public void removeColorBar() {
        if (this._colorBar != null) {
            if (this._colorBarPixelsView != null) {
                this._colorBarPixelsView.removeColorMapListener(this._colorBar);
            }
            this.remove(this._colorBar);
            this.revalidate();
            this._colorBar = null;
        }
    }

    public void addTitle(String title) {
        this.setTitle(title);
    }

    public void setTitle(String title) {
        if (title != null) {
            if (this._title == null) {
                this._title = new Title(title);
                Font font = this.getFont();
                font.deriveFont(1.5f * font.getSize2D());
                this._title.setFont(this.getFont());
                this._title.setForeground(this.getForeground());
                this._title.setBackground(this.getBackground());
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.gridwidth = 1;
                gbc.gridheight = 1;
                gbc.weightx = 0.0;
                gbc.weighty = 0.0;
                gbc.fill = 1;
                int top = 0;
                int left = this._mosaic.getWidthAxesLeft();
                int bottom = 0;
                int right = this._mosaic.getWidthAxesRight();
                gbc.insets = new Insets(top, left, bottom, right);
                this.add((Component)this._title, gbc);
                this.revalidate();
            } else {
                this._title.set(title);
            }
        } else if (this._title != null) {
            this.remove(this._title);
            this.revalidate();
            this._title = null;
        }
    }

    public void removeTitle() {
        this.setTitle(null);
    }

    public void setLimits(double hmin, double vmin, double hmax, double vmax) {
        this.setHLimits(hmin, hmax);
        this.setVLimits(vmin, vmax);
    }

    public void setHLimits(double hmin, double hmax) {
        this.setHLimits(0, hmin, hmax);
    }

    public void setVLimits(double vmin, double vmax) {
        this.setVLimits(0, vmin, vmax);
    }

    public void setHLimits(int icol, double hmin, double hmax) {
        Check.argument(hmin < hmax, "hmin<hmax");
        this.setBestHorizontalProjector(icol, new Projector(hmin, hmax));
    }

    public void setVLimits(int irow, double vmin, double vmax) {
        Check.argument(vmin < vmax, "vmin<vmax");
        if (this._orientation == Orientation.X1RIGHT_X2UP) {
            this.setBestVerticalProjector(irow, new Projector(vmax, vmin));
        } else {
            this.setBestVerticalProjector(irow, new Projector(vmin, vmax));
        }
    }

    public void setLimitsDefault() {
        this.setHLimitsDefault();
        this.setVLimitsDefault();
    }

    public void setHLimitsDefault() {
        this.setHLimitsDefault(0);
    }

    public void setVLimitsDefault() {
        this.setVLimitsDefault(0);
    }

    public void setHLimitsDefault(int icol) {
        this.setBestHorizontalProjector(icol, null);
    }

    public void setVLimitsDefault(int irow) {
        this.setBestVerticalProjector(irow, null);
    }

    public void setHLabel(String label) {
        this.setHLabel(0, label);
    }

    public void setVLabel(String label) {
        this.setVLabel(0, label);
    }

    public void setHLabel(int icol, String label) {
        if (this._axesPlacement == AxesPlacement.LEFT_TOP) {
            this._mosaic.getTileAxisTop(icol).setLabel(label);
        } else {
            this._mosaic.getTileAxisBottom(icol).setLabel(label);
        }
        this.adjustColorBar();
    }

    public void setVLabel(int irow, String label) {
        this._mosaic.getTileAxisLeft(irow).setLabel(label);
    }

    public void setHFormat(String format) {
        this.setHFormat(0, format);
    }

    public void setVFormat(String format) {
        this.setVFormat(0, format);
    }

    public void setHFormat(int icol, String format) {
        if (this._orientation == Orientation.X1DOWN_X2RIGHT) {
            this._mosaic.getTileAxisTop(icol).setFormat(format);
        } else {
            this._mosaic.getTileAxisBottom(icol).setFormat(format);
        }
    }

    public void setVFormat(int irow, String format) {
        this._mosaic.getTileAxisLeft(irow).setFormat(format);
    }

    public GridView addGrid() {
        return this.addGrid(0, 0);
    }

    public GridView addGrid(String parameters) {
        return this.addGrid(0, 0, parameters);
    }

    public GridView addGrid(int irow, int icol) {
        GridView gv = new GridView();
        return this.addGridView(irow, icol, gv);
    }

    public GridView addGrid(int irow, int icol, String parameters) {
        GridView gv = new GridView(parameters);
        return this.addGridView(irow, icol, gv);
    }

    public PixelsView addPixels(float[][] f) {
        return this.addPixels(0, 0, f);
    }

    public PixelsView addPixels(Sampling s1, Sampling s2, float[][] f) {
        return this.addPixels(0, 0, s1, s2, f);
    }

    public PixelsView addPixels(int irow, int icol, float[][] f) {
        PixelsView pv = new PixelsView(f);
        return this.addPixelsView(irow, icol, pv);
    }

    public PixelsView addPixels(int irow, int icol, Sampling s1, Sampling s2, float[][] f) {
        PixelsView pv = new PixelsView(s1, s2, f);
        return this.addPixelsView(irow, icol, pv);
    }

    public PointsView addPoints(float[] x1, float[] x2) {
        return this.addPoints(0, 0, x1, x2);
    }

    public PointsView addPoints(float[] x2) {
        return this.addPoints(0, 0, x2);
    }

    public PointsView addPoints(Sampling s1, float[] x2) {
        return this.addPoints(0, 0, s1, x2);
    }

    public PointsView addPoints(float[][] x1, float[][] x2) {
        return this.addPoints(0, 0, x1, x2);
    }

    public PointsView addPoints(int irow, int icol, float[] x1, float[] x2) {
        PointsView pv = new PointsView(x1, x2);
        return this.addPointsView(irow, icol, pv);
    }

    public PointsView addPoints(int irow, int icol, float[] x2) {
        PointsView pv = new PointsView(x2);
        return this.addPointsView(irow, icol, pv);
    }

    public PointsView addPoints(int irow, int icol, Sampling s1, float[] x2) {
        PointsView pv = new PointsView(s1, x2);
        return this.addPointsView(irow, icol, pv);
    }

    public PointsView addPoints(int irow, int icol, float[][] x1, float[][] x2) {
        PointsView pv = new PointsView(x1, x2);
        return this.addPointsView(irow, icol, pv);
    }

    public SequenceView addSequence(float[] f) {
        return this.addSequence(0, 0, f);
    }

    public SequenceView addSequence(Sampling sx, float[] f) {
        return this.addSequence(0, 0, sx, f);
    }

    public SequenceView addSequence(int irow, int icol, float[] f) {
        SequenceView sv = new SequenceView(f);
        return this.addSequenceView(irow, icol, sv);
    }

    public SequenceView addSequence(int irow, int icol, Sampling sx, float[] f) {
        SequenceView sv = new SequenceView(sx, f);
        return this.addSequenceView(irow, icol, sv);
    }

    public boolean addTiledView(TiledView tv) {
        return this.addTiledView(0, 0, tv);
    }

    public boolean addTiledView(int irow, int icol, TiledView tv) {
        return this._mosaic.getTile(irow, icol).addTiledView(tv);
    }

    public boolean remove(TiledView tv) {
        int nrow = this._mosaic.countRows();
        int ncol = this._mosaic.countColumns();
        for (int irow = 0; irow < nrow; ++irow) {
            for (int icol = 0; icol < ncol; ++icol) {
                if (!this.getTile(irow, icol).removeTiledView(tv)) continue;
                return true;
            }
        }
        return false;
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this._mosaic != null) {
            this._mosaic.setFont(font);
        }
        if (this._colorBar != null) {
            this._colorBar.setFont(font);
        }
        if (this._title != null) {
            this._title.setFont(font.deriveFont(1.5f * font.getSize2D()));
        }
        this.adjustColorBar();
        this.revalidate();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this._mosaic != null) {
            this._mosaic.setForeground(color);
        }
        if (this._colorBar != null) {
            this._colorBar.setForeground(color);
        }
        if (this._title != null) {
            this._title.setForeground(color);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this._mosaic != null) {
            this._mosaic.setBackground(color);
        }
        if (this._colorBar != null) {
            this._colorBar.setBackground(color);
        }
        if (this._title != null) {
            this._title.setBackground(color);
        }
    }

    private GridView addGridView(int irow, int icol, GridView gv) {
        this._mosaic.getTile(irow, icol).addTiledView(gv);
        return gv;
    }

    private PixelsView addPixelsView(int irow, int icol, PixelsView pv) {
        if (this._colorBar != null && this._colorBarPixelsView != null) {
            this._colorBarPixelsView.removeColorMapListener(this._colorBar);
        }
        this._colorBarPixelsView = pv;
        if (this._orientation == Orientation.X1RIGHT_X2UP) {
            this._colorBarPixelsView.setOrientation(PixelsView.Orientation.X1RIGHT_X2UP);
        } else if (this._orientation == Orientation.X1DOWN_X2RIGHT) {
            this._colorBarPixelsView.setOrientation(PixelsView.Orientation.X1DOWN_X2RIGHT);
        }
        if (this._colorBar != null) {
            this._colorBarPixelsView.addColorMapListener(this._colorBar);
        }
        this._mosaic.getTile(irow, icol).addTiledView(this._colorBarPixelsView);
        return this._colorBarPixelsView;
    }

    private PointsView addPointsView(int irow, int icol, PointsView pv) {
        if (this._orientation == Orientation.X1RIGHT_X2UP) {
            pv.setOrientation(PointsView.Orientation.X1RIGHT_X2UP);
        } else if (this._orientation == Orientation.X1DOWN_X2RIGHT) {
            pv.setOrientation(PointsView.Orientation.X1DOWN_X2RIGHT);
        }
        this._mosaic.getTile(irow, icol).addTiledView(pv);
        return pv;
    }

    private SequenceView addSequenceView(int irow, int icol, SequenceView sv) {
        this._mosaic.getTile(irow, icol).addTiledView(sv);
        return sv;
    }

    private void setBestHorizontalProjector(int icol, Projector p) {
        int nrow = this.getMosaic().countRows();
        for (int irow = 0; irow < nrow; ++irow) {
            this.getTile(irow, icol).setBestHorizontalProjector(p);
        }
    }

    private void setBestVerticalProjector(int irow, Projector p) {
        int ncol = this.getMosaic().countColumns();
        for (int icol = 0; icol < ncol; ++icol) {
            this.getTile(irow, icol).setBestVerticalProjector(p);
        }
    }

    private void adjustColorBar() {
        if (this._colorBar != null) {
            this.removeColorBar();
            this.addColorBar(this._colorBarLabel);
        }
    }

    private class Title
    extends IPanel {
        private static final long serialVersionUID = 1L;
        String text;

        Title(String text) {
            this.text = text;
        }

        void set(String text) {
            this.text = text;
            this.repaint();
        }

        public void paintToRect(Graphics2D g2d, int x, int y, int w, int h) {
            g2d = this.createGraphics(g2d, x, y, w, h);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Font font = g2d.getFont();
            FontMetrics fm = g2d.getFontMetrics();
            FontRenderContext frc = g2d.getFontRenderContext();
            LineMetrics lm = font.getLineMetrics(this.text, frc);
            int fd = Math.round(lm.getDescent());
            int wt = fm.stringWidth(this.text);
            int xt = Math.max(0, Math.min(w - wt, (w - wt) / 2));
            int yt = h - 1 - 2 * fd;
            g2d.drawString(this.text, xt, yt);
            g2d.dispose();
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.paintToRect((Graphics2D)g, 0, 0, this.getWidth(), this.getHeight());
        }

        public Dimension getMinimumSize() {
            if (this.isMinimumSizeSet()) {
                return super.getMinimumSize();
            }
            Font font = this.getFont();
            FontMetrics fm = this.getFontMetrics(font);
            int fh = fm.getHeight();
            int fd = fm.getDescent();
            int wt = fm.stringWidth(this.text);
            return new Dimension(wt, fd + fh);
        }

        public Dimension getPreferredSize() {
            if (this.isPreferredSizeSet()) {
                return super.getPreferredSize();
            }
            return this.getMinimumSize();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Orientation {
        X1RIGHT_X2UP,
        X1DOWN_X2RIGHT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AxesPlacement {
        LEFT_TOP,
        LEFT_BOTTOM,
        NONE;

    }
}

