/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.awt.ModeManager;
import edu.mines.jtk.mosaic.IPanel;
import edu.mines.jtk.mosaic.MouseTrackMode;
import edu.mines.jtk.mosaic.PlotPanel;
import edu.mines.jtk.mosaic.TileZoomMode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class PlotFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private PlotPanel _panelTL;
    private PlotPanel _panelBR;
    private Split _split;
    private JSplitPane _splitPane;
    private MainPanel _panelMain;
    private ModeManager _modeManager;
    private TileZoomMode _tileZoomMode;
    private MouseTrackMode _mouseTrackMode;

    public PlotFrame(PlotPanel panel) {
        this._panelTL = panel;
        this._panelBR = panel;
        this._panelMain = new MainPanel();
        this._panelMain.setLayout(new BorderLayout());
        this._panelMain.add((Component)this._panelTL, "Center");
        this.setSize(this._panelMain.getPreferredSize());
        this.add((Component)this._panelMain, "Center");
        this.setBackground(Color.WHITE);
        this.addModeManager();
    }

    public PlotFrame(PlotPanel panelTL, PlotPanel panelBR, Split split) {
        this._panelTL = panelTL;
        this._panelBR = panelBR;
        this._split = split;
        this._panelMain = new MainPanel();
        this._panelMain.setLayout(new BorderLayout());
        double resizeWeight = 0.5;
        if (this._split == Split.HORIZONTAL) {
            this._splitPane = new JSplitPane(1, this._panelTL, this._panelBR);
            double colTL = this._panelTL.getMosaic().countColumns();
            double colBR = this._panelBR.getMosaic().countColumns();
            resizeWeight = colTL / (colTL + colBR);
        } else {
            this._splitPane = new JSplitPane(0, this._panelTL, this._panelBR);
            double rowTL = this._panelTL.getMosaic().countRows();
            double rowBR = this._panelBR.getMosaic().countRows();
            resizeWeight = rowTL / (rowTL + rowBR);
        }
        this._splitPane.setResizeWeight(resizeWeight);
        this._splitPane.setOneTouchExpandable(true);
        this._panelMain.add((Component)this._splitPane, "Center");
        this.setSize(this._panelMain.getPreferredSize());
        this.add((Component)this._panelMain, "Center");
        this.setBackground(Color.WHITE);
        this.addModeManager();
    }

    public PlotPanel getPlotPanel() {
        return this._panelTL;
    }

    public PlotPanel getPlotPanelTopLeft() {
        return this._panelTL;
    }

    public PlotPanel getPlotPanelBottomRight() {
        return this._panelBR;
    }

    public ModeManager getModeManager() {
        return this._modeManager;
    }

    public TileZoomMode getTileZoomMode() {
        return this._tileZoomMode;
    }

    public MouseTrackMode getMouseTrackMode() {
        return this._mouseTrackMode;
    }

    public void paintToPng(final double dpi, final double win, final String fileName) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    PlotFrame.this._panelMain.paintToPng(dpi, win, fileName);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        });
    }

    public void setFontSize(int size) {
        Font font = this.getFont();
        if (font == null) {
            font = UIManager.getFont("Panel.font");
        }
        if (font != null) {
            this.setFont(font.deriveFont((float)size));
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this._panelMain != null) {
            this._panelMain.setFont(font);
        }
        if (this._panelTL != null) {
            this._panelTL.setFont(font);
        }
        if (this._panelBR != null && this._panelBR != this._panelTL) {
            this._panelBR.setFont(font);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this._panelMain != null) {
            this._panelMain.setForeground(color);
        }
        if (this._panelTL != null) {
            this._panelTL.setForeground(color);
        }
        if (this._panelBR != null && this._panelBR != this._panelTL) {
            this._panelBR.setForeground(color);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this._panelMain != null) {
            this._panelMain.setBackground(color);
        }
        if (this._panelTL != null) {
            this._panelTL.setBackground(color);
        }
        if (this._panelBR != null && this._panelBR != this._panelTL) {
            this._panelBR.setBackground(color);
        }
    }

    private void addModeManager() {
        this._modeManager = new ModeManager();
        this._panelTL.getMosaic().setModeManager(this._modeManager);
        if (this._panelBR != this._panelTL) {
            this._panelBR.getMosaic().setModeManager(this._modeManager);
        }
        this._tileZoomMode = new TileZoomMode(this._modeManager);
        this._mouseTrackMode = new MouseTrackMode(this._modeManager);
        this._tileZoomMode.setActive(true);
        this._mouseTrackMode.setActive(true);
    }

    private class MainPanel
    extends IPanel {
        private static final long serialVersionUID = 1L;

        private MainPanel() {
        }

        public void paintToRect(Graphics2D g2d, int x, int y, int w, int h) {
            if (PlotFrame.this._split == null) {
                PlotFrame.this._panelTL.paintToRect(g2d, x, y, w, h);
            } else {
                double ws = (double)w / (double)PlotFrame.this._splitPane.getWidth();
                double hs = (double)h / (double)PlotFrame.this._splitPane.getHeight();
                int nc = PlotFrame.this._splitPane.getComponentCount();
                for (int ic = 0; ic < nc; ++ic) {
                    Component c = PlotFrame.this._splitPane.getComponent(ic);
                    int xc = c.getX();
                    int yc = c.getY();
                    int wc = c.getWidth();
                    int hc = c.getHeight();
                    xc = (int)Math.round((double)xc * ws);
                    yc = (int)Math.round((double)yc * hs);
                    wc = (int)Math.round((double)wc * ws);
                    hc = (int)Math.round((double)hc * hs);
                    if (!(c instanceof IPanel)) continue;
                    IPanel ip = (IPanel)c;
                    ip.paintToRect(g2d, xc, yc, wc, hc);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Split {
        HORIZONTAL,
        VERTICAL;

    }
}

