/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.awt.ColorMap;
import edu.mines.jtk.awt.ColorMapListener;
import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.mosaic.Projector;
import edu.mines.jtk.mosaic.TiledView;
import edu.mines.jtk.mosaic.Transcaler;
import edu.mines.jtk.util.Array;
import edu.mines.jtk.util.Check;
import edu.mines.jtk.util.MathPlus;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

public class PixelsView
extends TiledView {
    private Sampling _s1;
    private Sampling _s2;
    private float[][] _f;
    private Orientation _orientation = Orientation.X1RIGHT_X2UP;
    private Interpolation _interpolation = Interpolation.LINEAR;
    private float _clipMin;
    private float _clipMax;
    private float _percMin = 0.0f;
    private float _percMax = 100.0f;
    private boolean _usePercentiles = true;
    private ColorMap _colorMap;
    private boolean _transposed;
    private boolean _xflipped;
    private boolean _yflipped;
    private int _nx;
    private double _dx;
    private double _fx;
    private int _ny;
    private double _dy;
    private double _fy;

    public PixelsView(float[][] f) {
        this.init();
        this.set(f);
    }

    public PixelsView(Sampling s1, Sampling s2, float[][] f) {
        this.init();
        this.set(s1, s2, f);
    }

    public void set(float[][] f) {
        this.set(new Sampling(f[0].length), new Sampling(f.length), f);
    }

    public void set(Sampling s1, Sampling s2, float[][] f) {
        Check.argument(s1.isUniform(), "s1 is uniform");
        Check.argument(s2.isUniform(), "s2 is uniform");
        Check.argument(Array.isRegular(f), "f is regular");
        Check.argument(s1.getCount() == f[0].length, "s1 consistent with f");
        Check.argument(s2.getCount() == f.length, "s2 consistent with f");
        this._s1 = s1;
        this._s2 = s2;
        this._f = Array.copy(f);
        this.updateClips();
        this.updateSampling();
    }

    public void setOrientation(Orientation orientation) {
        if (this._orientation != orientation) {
            this._orientation = orientation;
            this.updateSampling();
            this.repaint();
        }
    }

    public Orientation getOrientation() {
        return this._orientation;
    }

    public void setInterpolation(Interpolation interpolation) {
        if (this._interpolation != interpolation) {
            this._interpolation = interpolation;
            this.updateBestProjectors();
            this.repaint();
        }
    }

    public Interpolation getInterpolation() {
        return this._interpolation;
    }

    public void setColorModel(IndexColorModel colorModel) {
        this._colorMap.setColorModel(colorModel);
        this.repaint();
    }

    public IndexColorModel getColorModel() {
        return this._colorMap.getColorModel();
    }

    public void setClips(float clipMin, float clipMax) {
        Check.argument(clipMin < clipMax, "clipMin<clipMax");
        if (this._clipMin != clipMin || this._clipMax != clipMax) {
            this._usePercentiles = false;
            this._clipMin = clipMin;
            this._clipMax = clipMax;
            this._colorMap.setValueRange(this._clipMin, this._clipMax);
            this.repaint();
        }
    }

    public float getClipMin() {
        return this._clipMin;
    }

    public float getClipMax() {
        return this._clipMax;
    }

    public void setPercentiles(float percMin, float percMax) {
        Check.argument(0.0f <= percMin, "0<=percMin");
        Check.argument(percMin < percMax, "percMin<percMax");
        Check.argument(percMax <= 100.0f, "percMax<=100");
        if (this._percMin != percMin || this._percMax != percMax) {
            this._percMin = percMin;
            this._percMax = percMax;
            this._usePercentiles = true;
            this.updateClips();
            this.repaint();
        }
    }

    public float getPercentileMin() {
        return this._percMin;
    }

    public float getPercentileMax() {
        return this._percMax;
    }

    public void addColorMapListener(ColorMapListener cml) {
        this._colorMap.addListener(cml);
    }

    public void removeColorMapListener(ColorMapListener cml) {
        this._colorMap.removeListener(cml);
    }

    public void paint(Graphics2D g2d) {
        Projector hp = this.getHorizontalProjector();
        Projector vp = this.getVerticalProjector();
        Transcaler ts = this.getTranscaler();
        double vx0 = this._fx - 0.5 * this._dx;
        double vx1 = this._fx + this._dx * ((double)this._nx - 0.5);
        double vy0 = this._fy - 0.5 * this._dy;
        double vy1 = this._fy + this._dy * ((double)this._ny - 0.5);
        double ux0 = hp.u(vx0);
        double ux1 = hp.u(vx1);
        double uy0 = vp.u(vy0);
        double uy1 = vp.u(vy1);
        double uxmin = MathPlus.min(ux0, ux1);
        double uxmax = MathPlus.max(ux0, ux1);
        double uymin = MathPlus.min(uy0, uy1);
        double uymax = MathPlus.max(uy0, uy1);
        int xd = ts.x(uxmin);
        int yd = ts.y(uymin);
        int wd = ts.width(uxmax - uxmin);
        int hd = ts.height(uymax - uymin);
        Rectangle viewRect = new Rectangle(xd, yd, wd, hd);
        Rectangle clipRect = g2d.getClipBounds();
        if (clipRect == null) {
            clipRect = viewRect;
        }
        if ((clipRect = clipRect.intersection(viewRect)).isEmpty()) {
            return;
        }
        int xc = clipRect.x;
        int yc = clipRect.y;
        int wc = clipRect.width;
        int hc = clipRect.height;
        double xu = ts.x(xc);
        double yu = ts.y(yc);
        double wu = ts.width(wc);
        double hu = ts.height(hc);
        double x0 = hp.v(xu);
        double y0 = vp.v(yu);
        double x1 = hp.v(xu + wu);
        double y1 = vp.v(yu + hu);
        int nx = wc;
        int ny = hc;
        double dx = (x1 - x0) / (double)MathPlus.max(1, nx - 1);
        double dy = (y1 - y0) / (double)MathPlus.max(1, ny - 1);
        double fx = x0;
        double fy = y0;
        byte[] b = this._interpolation == Interpolation.LINEAR ? this.interpolateImageBytesLinear(nx, dx, fx, ny, dy, fy) : this.interpolateImageBytesNearest(nx, dx, fx, ny, dy, fy);
        IndexColorModel colorModel = this._colorMap.getColorModel();
        DataBufferByte db = new DataBufferByte(b, nx * ny, 0);
        int dataType = 0;
        int[] bitMasks = new int[]{255};
        SinglePixelPackedSampleModel sm = new SinglePixelPackedSampleModel(dataType, nx, ny, bitMasks);
        WritableRaster wr = Raster.createWritableRaster(sm, db, null);
        BufferedImage bi = new BufferedImage(colorModel, wr, false, null);
        g2d.drawImage((Image)bi, xc, yc, null);
    }

    private void init() {
        this._colorMap = new ColorMap(0.0, 1.0, ColorMap.GRAY);
    }

    private void updateClips() {
        if (this._usePercentiles) {
            int kmin;
            int n1 = this._s1.getCount();
            int n2 = this._s2.getCount();
            int n = n1 * n2;
            float[] a = null;
            if (this._percMin != 0.0f || this._percMax != 100.0f) {
                a = Array.flatten(this._f);
            }
            if ((kmin = (int)MathPlus.rint((double)this._percMin * 0.01 * (double)(n - 1))) <= 0) {
                this._clipMin = Array.min(this._f);
            } else {
                Array.quickPartialSort(kmin, a);
                this._clipMin = a[kmin];
            }
            int kmax = (int)MathPlus.rint((double)this._percMax * 0.01 * (double)(n - 1));
            if (kmax >= n - 1) {
                this._clipMax = Array.max(this._f);
            } else {
                Array.quickPartialSort(kmax, a);
                this._clipMax = a[kmax];
            }
            if (this._clipMin == this._clipMax) {
                double tiny = MathPlus.max(1.0, (double)(Math.ulp(1.0f) * MathPlus.abs(this._clipMin)));
                this._clipMin = (float)((double)this._clipMin - tiny);
                this._clipMax = (float)((double)this._clipMax + tiny);
            }
            this._colorMap.setValueRange(this._clipMin, this._clipMax);
        }
    }

    private void updateSampling() {
        int n1 = this._s1.getCount();
        int n2 = this._s2.getCount();
        double d1 = this._s1.getDelta();
        double d2 = this._s2.getDelta();
        double f1 = this._s1.getFirst();
        double f2 = this._s2.getFirst();
        if (this._orientation == Orientation.X1DOWN_X2RIGHT) {
            this._transposed = true;
            this._xflipped = false;
            this._yflipped = false;
            this._nx = n2;
            this._dx = d2;
            this._fx = f2;
            this._ny = n1;
            this._dy = d1;
            this._fy = f1;
        } else if (this._orientation == Orientation.X1RIGHT_X2UP) {
            this._transposed = false;
            this._xflipped = false;
            this._yflipped = true;
            this._nx = n1;
            this._dx = d1;
            this._fx = f1;
            this._ny = n2;
            this._dy = d2;
            this._fy = f2;
        }
        this.updateBestProjectors();
    }

    private void updateBestProjectors() {
        double tiny;
        double x0 = this._fx;
        double x1 = this._fx + this._dx * (double)(this._nx - 1);
        double y0 = this._fy;
        double y1 = this._fy + this._dy * (double)(this._ny - 1);
        if (this._xflipped) {
            double xt = y0;
            x0 = x1;
            x1 = xt;
        }
        if (this._yflipped) {
            double yt = y0;
            y0 = y1;
            y1 = yt;
        }
        if (x0 == x1) {
            tiny = MathPlus.max(0.5, 1.1920928955078125E-7 * MathPlus.abs(x0));
            x0 -= tiny;
            x1 += tiny;
        }
        if (y0 == y1) {
            tiny = MathPlus.max(0.5, 1.1920928955078125E-7 * MathPlus.abs(y0));
            y0 -= tiny;
            y1 += tiny;
        }
        double uxMargin = this._nx > 1 ? 0.5 / (double)this._nx : 0.0;
        double uyMargin = this._ny > 1 ? 0.5 / (double)this._ny : 0.0;
        double ux0 = uxMargin;
        double uy0 = uyMargin;
        double ux1 = 1.0 - uxMargin;
        double uy1 = 1.0 - uyMargin;
        Projector bhp = new Projector(x0, x1, ux0, ux1);
        Projector bvp = new Projector(y0, y1, uy0, uy1);
        this.setBestProjectors(bhp, bvp);
    }

    private byte[] interpolateImageBytesLinear(int nx, double dx, double fx, int ny, double dy, double fy) {
        byte[] b = new byte[nx * ny];
        float[] temp1 = new float[nx];
        float[] temp2 = new float[nx];
        int jy1 = -2;
        int[] kf = new int[nx];
        float[] wf = new float[nx];
        for (int ix = 0; ix < nx; ++ix) {
            double xi = fx + (double)ix * dx;
            double xn = (xi - this._fx) / this._dx;
            if (xn <= 0.0) {
                kf[ix] = 0;
                wf[ix] = 0.0f;
                continue;
            }
            if (xn >= (double)(this._nx - 1)) {
                kf[ix] = this._nx - 2;
                wf[ix] = 1.0f;
                continue;
            }
            kf[ix] = (int)xn;
            wf[ix] = (float)(xn - (double)((int)xn));
        }
        for (int iy = 0; iy < ny; ++iy) {
            double yi = fy + (double)iy * dy;
            double yn = MathPlus.max(0.0, MathPlus.min((double)(this._ny - 1), (yi - this._fy) / this._dy));
            int jy = MathPlus.max(0, MathPlus.min(this._ny - 2, (int)yn));
            if (jy != jy1 || iy == 0) {
                if (jy == jy1 + 1 && iy != 0) {
                    float[] temp = temp1;
                    temp1 = temp2;
                    temp2 = temp;
                    this.interpx(MathPlus.min(jy + 1, this._ny - 1), nx, kf, wf, temp2);
                } else if (jy == jy1 - 1 && iy != 0) {
                    float[] temp = temp1;
                    temp1 = temp2;
                    temp2 = temp;
                    this.interpx(jy, nx, kf, wf, temp1);
                } else {
                    this.interpx(jy, nx, kf, wf, temp1);
                    this.interpx(MathPlus.min(jy + 1, this._ny - 1), nx, kf, wf, temp2);
                }
                jy1 = jy;
            }
            double frac = yn - (double)jy;
            this.interpy(nx, frac, temp1, temp2, iy * nx, b);
        }
        return b;
    }

    private void interpx(int jy, int nx, int[] kf, float[] wf, float[] t) {
        float fscale = 255.0f / (this._clipMax - this._clipMin);
        float fshift = this._clipMin;
        if (this._transposed) {
            if (this._nx == 1) {
                float fc = (this._f[0][jy] - fshift) * fscale;
                for (int ix = 0; ix < nx; ++ix) {
                    t[ix] = fc;
                }
            } else {
                for (int ix = 0; ix < nx; ++ix) {
                    int kx = kf[ix];
                    float wx = wf[ix];
                    float f1 = (this._f[kx][jy] - fshift) * fscale;
                    float f2 = (this._f[kx + 1][jy] - fshift) * fscale;
                    t[ix] = (1.0f - wx) * f1 + wx * f2;
                }
            }
        } else {
            float[] fjy = this._f[jy];
            if (this._nx == 1) {
                float fc = (fjy[0] - fshift) * fscale;
                for (int ix = 0; ix < nx; ++ix) {
                    t[ix] = fc;
                }
            } else {
                for (int ix = 0; ix < nx; ++ix) {
                    int kx = kf[ix];
                    float wx = wf[ix];
                    float f1 = (fjy[kx] - fshift) * fscale;
                    float f2 = (fjy[kx + 1] - fshift) * fscale;
                    t[ix] = (1.0f - wx) * f1 + wx * f2;
                }
            }
        }
    }

    private void interpy(int nx, double frac, float[] temp1, float[] temp2, int kb, byte[] b) {
        float w2 = (float)frac;
        float w1 = 1.0f - w2;
        int ix = 0;
        int ib = kb;
        while (ix < nx) {
            float ti = w1 * temp1[ix] + w2 * temp2[ix];
            if (ti < 0.0f) {
                ti = 0.0f;
            }
            if (ti > 255.0f) {
                ti = 255.0f;
            }
            b[ib] = (byte)(ti + 0.5f);
            ++ix;
            ++ib;
        }
    }

    private byte[] interpolateImageBytesNearest(int nx, double dx, double fx, int ny, double dy, double fy) {
        byte[] b = new byte[nx * ny];
        byte[] temp = new byte[nx];
        int jytemp = -1;
        int[] kf = new int[nx];
        for (int ix = 0; ix < nx; ++ix) {
            double xi = fx + (double)ix * dx;
            double xn = (xi - this._fx) / this._dx;
            kf[ix] = xn <= 0.0 ? 0 : (xn >= (double)(this._nx - 1) ? this._nx - 1 : (int)(xn + 0.5));
        }
        for (int iy = 0; iy < ny; ++iy) {
            double yi = fy + (double)iy * dy;
            double yn = MathPlus.max(0.0, MathPlus.min((double)(this._ny - 1), (yi - this._fy) / this._dy));
            int jy = MathPlus.max(0, MathPlus.min(this._ny - 1, (int)(yn + 0.5)));
            if (jy != jytemp) {
                this.interpx(jy, nx, kf, temp);
                jytemp = jy;
            }
            int i = 0;
            int j = iy * nx;
            while (i < nx) {
                b[j] = temp[i];
                ++i;
                ++j;
            }
        }
        return b;
    }

    private void interpx(int jy, int nx, int[] kf, byte[] b) {
        float fscale = 255.0f / (this._clipMax - this._clipMin);
        float fshift = this._clipMin;
        if (this._transposed) {
            for (int ix = 0; ix < nx; ++ix) {
                int kx = kf[ix];
                float fi = (this._f[kx][jy] - fshift) * fscale;
                if (fi < 0.0f) {
                    fi = 0.0f;
                }
                if (fi > 255.0f) {
                    fi = 255.0f;
                }
                b[ix] = (byte)(fi + 0.5f);
            }
        } else {
            float[] fjy = this._f[jy];
            for (int ix = 0; ix < nx; ++ix) {
                int kx = kf[ix];
                float fi = (fjy[kx] - fshift) * fscale;
                if (fi < 0.0f) {
                    fi = 0.0f;
                }
                if (fi > 255.0f) {
                    fi = 255.0f;
                }
                b[ix] = (byte)(fi + 0.5f);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Interpolation {
        NEAREST,
        LINEAR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Orientation {
        X1RIGHT_X2UP,
        X1DOWN_X2RIGHT;

    }
}

