/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.awt.Mode;
import edu.mines.jtk.awt.ModeManager;
import edu.mines.jtk.mosaic.Tile;
import edu.mines.jtk.mosaic.TileAxis;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.KeyStroke;

public class MouseTrackMode
extends Mode {
    private static final long serialVersionUID = 1L;
    private Tile _tile;
    private int _xmouse;
    private int _ymouse;
    private MouseListener _ml = new MouseAdapter(){

        public void mouseEntered(MouseEvent e) {
            MouseTrackMode.this.beginTracking(e);
        }

        public void mouseExited(MouseEvent e) {
            MouseTrackMode.this.endTracking(e);
        }
    };
    private MouseMotionListener _mml = new MouseMotionAdapter(){

        public void mouseDragged(MouseEvent e) {
            MouseTrackMode.this.duringTracking(e);
        }

        public void mouseMoved(MouseEvent e) {
            MouseTrackMode.this.duringTracking(e);
        }
    };

    public MouseTrackMode(ModeManager modeManager) {
        super(modeManager);
        this.setName("Track");
        this.setIcon(MouseTrackMode.loadIcon(MouseTrackMode.class, "resources/Track24.gif"));
        this.setMnemonicKey(90);
        this.setAcceleratorKey(KeyStroke.getKeyStroke(84, 0));
        this.setShortDescription("Track mouse in tile");
    }

    public boolean isExclusive() {
        return false;
    }

    protected void setActive(Component component, boolean active) {
        if (component instanceof Tile) {
            if (active) {
                component.addMouseListener(this._ml);
            } else {
                component.removeMouseListener(this._ml);
            }
        }
    }

    private void beginTracking(MouseEvent e) {
        this._xmouse = e.getX();
        this._ymouse = e.getY();
        this._tile = (Tile)e.getSource();
        this.beginTracking(this._tile.getTileAxisTop(), this._xmouse, this._ymouse);
        this.beginTracking(this._tile.getTileAxisLeft(), this._xmouse, this._ymouse);
        this.beginTracking(this._tile.getTileAxisBottom(), this._xmouse, this._ymouse);
        this.beginTracking(this._tile.getTileAxisRight(), this._xmouse, this._ymouse);
        this.fireTrack();
        this._tile.addMouseMotionListener(this._mml);
    }

    private void beginTracking(TileAxis ta, int x, int y) {
        if (ta != null) {
            ta.beginTracking(x, y);
        }
    }

    private void duringTracking(MouseEvent e) {
        this._xmouse = e.getX();
        this._ymouse = e.getY();
        this._tile = (Tile)e.getSource();
        this.duringTracking(this._tile.getTileAxisTop(), this._xmouse, this._ymouse);
        this.duringTracking(this._tile.getTileAxisLeft(), this._xmouse, this._ymouse);
        this.duringTracking(this._tile.getTileAxisBottom(), this._xmouse, this._ymouse);
        this.duringTracking(this._tile.getTileAxisRight(), this._xmouse, this._ymouse);
        this.fireTrack();
    }

    private void duringTracking(TileAxis ta, int x, int y) {
        if (ta != null) {
            ta.duringTracking(x, y);
        }
    }

    private void endTracking(MouseEvent e) {
        this._tile.removeMouseMotionListener(this._mml);
        this.endTracking(this._tile.getTileAxisTop());
        this.endTracking(this._tile.getTileAxisLeft());
        this.endTracking(this._tile.getTileAxisBottom());
        this.endTracking(this._tile.getTileAxisRight());
        this.fireTrack();
        this._tile = null;
    }

    private void endTracking(TileAxis ta) {
        if (ta != null) {
            ta.endTracking();
        }
    }

    private void fireTrack() {
    }
}

