/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.awt.ModeManager;
import edu.mines.jtk.mosaic.DRectangle;
import edu.mines.jtk.mosaic.IPanel;
import edu.mines.jtk.mosaic.Projector;
import edu.mines.jtk.mosaic.Tile;
import edu.mines.jtk.mosaic.TileAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JScrollBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mosaic
extends IPanel {
    private static final long serialVersionUID = 1L;
    private int _nrow;
    private int _ncol;
    private Tile[][] _tiles;
    private TileAxis[] _axesTop;
    private TileAxis[] _axesLeft;
    private TileAxis[] _axesBottom;
    private TileAxis[] _axesRight;
    private ArrayList<Tile> _tileList;
    private ArrayList<TileAxis> _axisList;
    private HScrollBar[] _hsb;
    private VScrollBar[] _vsb;
    private int[] _wm;
    private int[] _we;
    private int[] _hm;
    private int[] _he;
    private ModeManager _modeManager;
    private static final int SCROLL_MAX = 1000000000;
    private static final double SCROLL_SCL = 1.0E-9;

    public Mosaic(int nrow, int ncol, Set<AxesPlacement> axesPlacement) {
        int icol;
        int irow;
        this._nrow = nrow;
        this._ncol = ncol;
        this._tiles = new Tile[nrow][ncol];
        this._tileList = new ArrayList();
        for (irow = 0; irow < nrow; ++irow) {
            for (int icol2 = 0; icol2 < ncol; ++icol2) {
                Tile tile = new Tile(this, irow, icol2);
                this._tiles[irow][icol2] = tile;
                Tile tile2 = tile;
                this._tileList.add(tile2);
                this.add(tile2);
            }
        }
        this._axisList = new ArrayList();
        if (axesPlacement.contains((Object)AxesPlacement.TOP)) {
            this._axesTop = new TileAxis[ncol];
            for (icol = 0; icol < ncol; ++icol) {
                TileAxis axis = this._axesTop[icol] = new TileAxis(this, TileAxis.Placement.TOP, icol);
                this._axisList.add(axis);
                this.add(axis);
            }
        }
        if (axesPlacement.contains((Object)AxesPlacement.LEFT)) {
            this._axesLeft = new TileAxis[nrow];
            for (irow = 0; irow < nrow; ++irow) {
                TileAxis axis = this._axesLeft[irow] = new TileAxis(this, TileAxis.Placement.LEFT, irow);
                this._axisList.add(axis);
                this.add(axis);
            }
        }
        if (axesPlacement.contains((Object)AxesPlacement.BOTTOM)) {
            this._axesBottom = new TileAxis[ncol];
            for (icol = 0; icol < ncol; ++icol) {
                TileAxis axis = this._axesBottom[icol] = new TileAxis(this, TileAxis.Placement.BOTTOM, icol);
                this._axisList.add(axis);
                this.add(axis);
            }
        }
        if (axesPlacement.contains((Object)AxesPlacement.RIGHT)) {
            this._axesRight = new TileAxis[nrow];
            for (irow = 0; irow < nrow; ++irow) {
                TileAxis axis = this._axesRight[irow] = new TileAxis(this, TileAxis.Placement.RIGHT, irow);
                this._axisList.add(axis);
                this.add(axis);
            }
        }
        this._vsb = new VScrollBar[this._nrow];
        this._hsb = new HScrollBar[this._ncol];
        for (irow = 0; irow < this._nrow; ++irow) {
            VScrollBar vsb = this._vsb[irow] = new VScrollBar(irow);
            this.add(vsb);
        }
        for (icol = 0; icol < this._ncol; ++icol) {
            HScrollBar hsb = this._hsb[icol] = new HScrollBar(icol);
            this.add(hsb);
        }
        this._we = new int[ncol];
        this._wm = new int[ncol];
        for (icol = 0; icol < ncol; ++icol) {
            this._we[icol] = 100;
            this._wm[icol] = 100;
        }
        this._he = new int[nrow];
        this._hm = new int[nrow];
        for (irow = 0; irow < nrow; ++irow) {
            this._he[irow] = 100;
            this._hm[irow] = 100;
        }
        this._modeManager = new ModeManager();
        for (Tile tile : this._tileList) {
            this._modeManager.add(tile);
        }
        for (TileAxis axis : this._axisList) {
            this._modeManager.add(axis);
        }
    }

    public void setModeManager(ModeManager modeManager) {
        if (this._modeManager != null) {
            for (Tile tile : this._tileList) {
                this._modeManager.remove(tile);
            }
            for (TileAxis axis : this._axisList) {
                this._modeManager.remove(axis);
            }
        }
        this._modeManager = modeManager;
        if (this._modeManager != null) {
            for (Tile tile : this._tileList) {
                this._modeManager.add(tile);
            }
            for (TileAxis axis : this._axisList) {
                this._modeManager.add(axis);
            }
        }
    }

    public int countRows() {
        return this._nrow;
    }

    public int countColumns() {
        return this._ncol;
    }

    public Tile getTile(int irow, int icol) {
        return this._tiles[irow][icol];
    }

    public TileAxis getTileAxisTop(int icol) {
        return this._axesTop != null ? this._axesTop[icol] : null;
    }

    public TileAxis getTileAxisLeft(int irow) {
        return this._axesLeft != null ? this._axesLeft[irow] : null;
    }

    public TileAxis getTileAxisBottom(int icol) {
        return this._axesBottom != null ? this._axesBottom[icol] : null;
    }

    public TileAxis getTileAxisRight(int irow) {
        return this._axesRight != null ? this._axesRight[irow] : null;
    }

    public void setWidthMinimum(int icol, int widthMinimum) {
        this._wm[icol] = widthMinimum;
    }

    public void setWidthElastic(int icol, int widthElastic) {
        this._we[icol] = widthElastic;
    }

    public void setHeightMinimum(int irow, int heightMinimum) {
        this._hm[irow] = heightMinimum;
    }

    public void setHeightElastic(int irow, int heightElastic) {
        this._he[irow] = heightElastic;
    }

    public ModeManager getModeManager() {
        return this._modeManager;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this._tileList != null) {
            for (Tile tile : this._tileList) {
                tile.setFont(font);
            }
            for (TileAxis axis : this._axisList) {
                axis.setFont(font);
            }
        }
        this.revalidate();
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this._tileList != null) {
            for (Tile tile : this._tileList) {
                tile.setForeground(color);
            }
            for (TileAxis axis : this._axisList) {
                axis.setForeground(color);
            }
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this._tileList != null) {
            for (Tile tile : this._tileList) {
                tile.setBackground(color);
            }
            for (TileAxis axis : this._axisList) {
                axis.setBackground(color);
            }
        }
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        return new Dimension(this.widthMinimum(), this.heightMinimum());
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        return this.getMinimumSize();
    }

    @Override
    public void doLayout() {
        int wvsb;
        int hhsb;
        int icol;
        int yaxis;
        int xaxis;
        int haxis;
        int waxis;
        int yaxis2;
        int xaxis2;
        this.updateScrollBars();
        int w = this.getWidth();
        int h = this.getHeight();
        int wf = this.widthFixed();
        int hf = this.heightFixed();
        int wfill = Math.max(0, w - wf);
        int hfill = Math.max(0, h - hf);
        int wesum = 0;
        for (int icol2 = 0; icol2 < this._ncol; ++icol2) {
            wesum += this._we[icol2];
        }
        int hesum = 0;
        for (int irow = 0; irow < this._nrow; ++irow) {
            hesum += this._he[irow];
        }
        wesum = Math.max(1, wesum);
        hesum = Math.max(1, hesum);
        int[] wcol = new int[this._ncol];
        int wleft = wfill;
        for (int icol3 = 0; icol3 < this._ncol; ++icol3) {
            int we;
            int n = we = icol3 < this._ncol - 1 ? wfill * this._we[icol3] / wesum : wleft;
            if (this._we[icol3] == 0) {
                we = 0;
            }
            wcol[icol3] = Math.max(this._wm[icol3], we);
            wleft -= wcol[icol3];
        }
        int[] hrow = new int[this._nrow];
        int hleft = hfill;
        for (int irow = 0; irow < this._nrow; ++irow) {
            int he;
            int n = he = irow < this._nrow - 1 ? hfill * this._he[irow] / hesum : hleft;
            if (this._he[irow] == 0) {
                he = 0;
            }
            hrow[irow] = Math.max(this._hm[irow], he);
            hleft -= hrow[irow];
        }
        int wab = this.widthAxesBorder();
        int wtb = this.widthTileBorder();
        int wts = this.widthTileSpacing();
        if (this._axesTop != null) {
            int haxis2 = this.heightMinimumAxesTop() - wab - wab;
            xaxis2 = this.widthMinimumAxesLeft() + wtb;
            yaxis2 = wab;
            for (int icol4 = 0; icol4 < this._ncol; ++icol4) {
                waxis = wcol[icol4];
                this._axesTop[icol4].setBounds(xaxis2, yaxis2, waxis, haxis2);
                xaxis2 += waxis + wtb + wts + wtb;
            }
        }
        if (this._axesLeft != null) {
            int waxis2 = this.widthMinimumAxesLeft() - wab - wab;
            xaxis2 = wab;
            yaxis2 = this.heightMinimumAxesTop() + wtb;
            for (int irow = 0; irow < this._nrow; ++irow) {
                haxis = hrow[irow];
                this._axesLeft[irow].setBounds(xaxis2, yaxis2, waxis2, haxis);
                yaxis2 += haxis + wtb + wts + wtb;
            }
        }
        int xtile0 = wtb;
        int ytile0 = wtb;
        if (this._axesLeft != null) {
            xtile0 += this.widthMinimumAxesLeft();
        }
        if (this._axesTop != null) {
            ytile0 += this.heightMinimumAxesTop();
        }
        int xtile = xtile0;
        int ytile = ytile0;
        for (int irow = 0; irow < this._nrow; ++irow) {
            int htile = hrow[irow];
            xtile = xtile0;
            for (int icol5 = 0; icol5 < this._ncol; ++icol5) {
                int wtile = wcol[icol5];
                this._tiles[irow][icol5].setBounds(xtile, ytile, wtile, htile);
                xtile += wtile + wtb + wts + wtb;
            }
            ytile += htile + wtb + wts + wtb;
        }
        xtile -= wts + wtb;
        ytile -= wts + wtb;
        if (this._axesBottom != null) {
            haxis = this.heightMinimumAxesBottom() - wab - wab;
            xaxis = this.widthMinimumAxesLeft() + wtb;
            yaxis = ytile + wab;
            for (icol = 0; icol < this._ncol; ++icol) {
                int waxis3 = wcol[icol];
                this._axesBottom[icol].setBounds(xaxis, yaxis, waxis3, haxis);
                xaxis += waxis3 + wtb + wts + wtb;
            }
        }
        if (this._axesRight != null) {
            waxis = this.widthMinimumAxesRight() - wab - wab;
            xaxis = xtile + wab;
            yaxis = this.heightMinimumAxesTop() + wtb;
            for (int irow = 0; irow < this._nrow; ++irow) {
                int haxis3 = hrow[irow];
                this._axesRight[irow].setBounds(xaxis, yaxis, waxis, haxis3);
                yaxis += haxis3 + wtb + wts + wtb;
            }
        }
        if ((hhsb = this.heightHScrollBars()) > 0) {
            int xhsb = this.widthMinimumAxesLeft() + wtb;
            int yhsb = ytile;
            if (this._axesBottom != null) {
                yhsb += this.heightMinimumAxesBottom() - wab;
            }
            for (icol = 0; icol < this._ncol; ++icol) {
                int whsb = wcol[icol];
                this._hsb[icol].setBounds(xhsb, yhsb, whsb, hhsb);
                xhsb += whsb + wtb + wts + wtb;
            }
        }
        if ((wvsb = this.widthVScrollBars()) > 0) {
            int xvsb = xtile;
            if (this._axesRight != null) {
                xvsb += this.widthMinimumAxesRight() - wab;
            }
            int yvsb = this.heightMinimumAxesTop() + wtb;
            for (int irow = 0; irow < this._nrow; ++irow) {
                int hvsb = hrow[irow];
                this._vsb[irow].setBounds(xvsb, yvsb, wvsb, hvsb);
                yvsb += hvsb + wtb + wts + wtb;
            }
        }
    }

    @Override
    public void paintToRect(Graphics2D g2d, int x, int y, int w, int h) {
        g2d = this.createGraphics(g2d, x, y, w, h);
        double ws = (double)w / (double)this.getWidth();
        double hs = (double)h / (double)this.getHeight();
        float lineWidth = this.getLineWidth(g2d);
        float wtb = lineWidth * (float)this.widthTileBorder();
        float wab = lineWidth * (float)this.widthAxesBorder();
        int itb = 1 + (int)(wtb / 2.0f);
        int iab = 1 + (int)(wab / 2.0f);
        BasicStroke stb = new BasicStroke(wtb);
        BasicStroke sab = new BasicStroke(wab);
        int nc = this.getComponentCount();
        for (int ic = 0; ic < nc; ++ic) {
            Component c = this.getComponent(ic);
            int xc = c.getX();
            int yc = c.getY();
            int wc = c.getWidth();
            int hc = c.getHeight();
            xc = (int)Math.round((double)xc * ws);
            yc = (int)Math.round((double)yc * hs);
            wc = (int)Math.round((double)wc * ws);
            hc = (int)Math.round((double)hc * hs);
            if (!(c instanceof IPanel)) continue;
            IPanel ip = (IPanel)c;
            ip.paintToRect(g2d, xc, yc, wc, hc);
            if (wtb > 0.0f && ip instanceof Tile) {
                Tile tile = (Tile)ip;
                if (tile.countTiledViews() <= 0) continue;
                g2d.setStroke(stb);
                g2d.drawRect(xc - itb, yc - itb, wc + itb + itb - 1, hc + itb + itb - 1);
                continue;
            }
            if (!(wab > 0.0f) || !(ip instanceof TileAxis)) continue;
            g2d.setStroke(sab);
            g2d.drawRect(xc - iab, yc - iab, wc + iab + iab - 1, hc + iab + iab - 1);
        }
        g2d.dispose();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintToRect((Graphics2D)g, 0, 0, this.getWidth(), this.getHeight());
    }

    void alignProjectors(Tile tile) {
        int icol;
        Projector bvp;
        int jrow = tile.getRowIndex();
        int jcol = tile.getColumnIndex();
        Projector bhp = tile.getBestHorizontalProjector();
        if (bhp != null) {
            bhp = new Projector(bhp);
            for (int irow = 0; irow < this._nrow; ++irow) {
                if (irow == jrow) continue;
                bhp.merge(this._tiles[irow][jcol].getBestHorizontalProjector());
            }
        }
        if ((bvp = tile.getBestVerticalProjector()) != null) {
            bvp = new Projector(bvp);
            for (icol = 0; icol < this._ncol; ++icol) {
                if (icol == jcol) continue;
                bvp.merge(this._tiles[jrow][icol].getBestVerticalProjector());
            }
        }
        if (bhp != null && bvp != null) {
            tile.setProjectors(bhp, bvp);
        } else if (bhp != null) {
            tile.setHorizontalProjector(bhp);
        } else if (bvp != null) {
            tile.setVerticalProjector(bvp);
        }
        bhp = tile.getHorizontalProjector();
        bvp = tile.getVerticalProjector();
        for (int irow = 0; irow < this._nrow; ++irow) {
            if (irow == jrow) continue;
            this._tiles[irow][jcol].setHorizontalProjector(bhp);
        }
        for (icol = 0; icol < this._ncol; ++icol) {
            if (icol == jcol) continue;
            this._tiles[jrow][icol].setVerticalProjector(bvp);
        }
        this.repaintAxis(this._axesTop, jcol);
        this.repaintAxis(this._axesBottom, jcol);
        this.repaintAxis(this._axesLeft, jrow);
        this.repaintAxis(this._axesRight, jrow);
    }

    void setViewRect(Tile tile, DRectangle vr) {
        DRectangle dr;
        Tile ti;
        int wvsb = this.widthVScrollBars();
        int hhsb = this.heightHScrollBars();
        double x = Math.max(0.0, Math.min(1.0, vr.x));
        double y = Math.max(0.0, Math.min(1.0, vr.y));
        double w = Math.max(0.0, Math.min(1.0 - vr.x, vr.width));
        double h = Math.max(0.0, Math.min(1.0 - vr.y, vr.height));
        DRectangle tr = new DRectangle(x, y, w, h);
        tile.setViewRect(tr);
        int jrow = tile.getRowIndex();
        int jcol = tile.getColumnIndex();
        for (int irow = 0; irow < this._nrow; ++irow) {
            if (irow == jrow) continue;
            ti = this._tiles[irow][jcol];
            dr = ti.getViewRectangle();
            dr.x = tr.x;
            dr.width = tr.width;
            ti.setViewRect(dr);
        }
        for (int icol = 0; icol < this._ncol; ++icol) {
            if (icol == jcol) continue;
            ti = this._tiles[jrow][icol];
            dr = ti.getViewRectangle();
            dr.y = tr.y;
            dr.height = tr.height;
            ti.setViewRect(dr);
        }
        this.repaintAxis(this._axesTop, jcol);
        this.repaintAxis(this._axesBottom, jcol);
        this.repaintAxis(this._axesLeft, jrow);
        this.repaintAxis(this._axesRight, jrow);
        this._hsb[jcol].update();
        this._vsb[jrow].update();
        if (wvsb != this.widthVScrollBars() || hhsb != this.heightHScrollBars()) {
            this.revalidate();
        }
    }

    int getHeightAxesTop() {
        return this.heightMinimumAxesTop();
    }

    int getHeightAxesBottom() {
        return this.heightMinimumAxesBottom();
    }

    int getWidthAxesLeft() {
        return this.widthMinimumAxesLeft();
    }

    int getWidthAxesRight() {
        return this.widthMinimumAxesRight();
    }

    private void repaintAxis(TileAxis[] axes, int index) {
        if (axes != null) {
            this.repaintAxis(axes[index]);
        }
    }

    private void repaintAxis(TileAxis axis) {
        axis.repaint();
        axis.updateAxisTics();
    }

    private int widthAxesBorder() {
        return 0;
    }

    private int widthTileBorder() {
        return 1;
    }

    private int widthTileSpacing() {
        return 2;
    }

    private int widthFixed() {
        int width = this.widthMinimumAxesLeft();
        width += (this._ncol - 1) * this.widthTileSpacing();
        width += 2 * this._ncol * this.widthTileBorder();
        width += this.widthMinimumAxesRight();
        return width += this.widthVScrollBars();
    }

    private int widthMinimum() {
        int width = this.widthMinimumAxesLeft();
        for (int icol = 0; icol < this._ncol; ++icol) {
            width += this.widthMinimumColumn(icol);
        }
        width += this.widthMinimumAxesRight();
        width += (this._ncol - 1) * this.widthTileSpacing();
        return width += this.widthMinimumVScrollBars();
    }

    private int widthMinimumColumn(int icol) {
        int width = 0;
        if (this._axesTop != null) {
            width = Math.max(width, this._axesTop[icol].getWidthMinimum());
        }
        width = Math.max(width, this.widthMinimumTiles(icol));
        if (this._axesBottom != null) {
            width = Math.max(width, this._axesBottom[icol].getWidthMinimum());
        }
        return width;
    }

    private int widthMinimumTiles(int icol) {
        int width = this.widthTileBorder();
        width += this._wm[icol];
        return width += this.widthTileBorder();
    }

    private int widthMinimumAxesLeft() {
        int width = 0;
        if (this._axesLeft != null) {
            for (int irow = 0; irow < this._nrow; ++irow) {
                width = Math.max(width, this._axesLeft[irow].getWidthMinimum());
            }
            width += 2 * this.widthAxesBorder();
        }
        return width;
    }

    private int widthMinimumAxesRight() {
        int width = 0;
        if (this._axesRight != null) {
            for (int irow = 0; irow < this._nrow; ++irow) {
                width = Math.max(width, this._axesRight[irow].getWidthMinimum());
            }
            width += 2 * this.widthAxesBorder();
        }
        return width;
    }

    private int widthMinimumVScrollBars() {
        return 0;
    }

    private int widthVScrollBars() {
        for (int irow = 0; irow < this._nrow; ++irow) {
            if (!this._vsb[irow].isVisible()) continue;
            return this._vsb[irow].getMinimumSize().width;
        }
        return 0;
    }

    private int heightFixed() {
        int height = this.heightMinimumAxesTop();
        height += (this._nrow - 1) * this.widthTileSpacing();
        height += 2 * this._nrow * this.widthTileBorder();
        height += this.heightMinimumAxesBottom();
        return height += this.heightHScrollBars();
    }

    private int heightMinimum() {
        int height = this.heightMinimumAxesTop();
        for (int irow = 0; irow < this._nrow; ++irow) {
            height += this.heightMinimumRow(irow);
        }
        height += this.heightMinimumAxesBottom();
        height += (this._nrow - 1) * this.widthTileSpacing();
        return height += this.heightMinimumHScrollBars();
    }

    private int heightMinimumRow(int irow) {
        int height = 0;
        if (this._axesLeft != null) {
            height = Math.max(height, this._axesLeft[irow].getHeightMinimum());
        }
        height = Math.max(height, this.heightMinimumTiles(irow));
        if (this._axesRight != null) {
            height = Math.max(height, this._axesRight[irow].getHeightMinimum());
        }
        return height;
    }

    private int heightMinimumTiles(int irow) {
        int height = this.widthTileBorder();
        height += this._hm[irow];
        return height += this.widthTileBorder();
    }

    private int heightMinimumAxesTop() {
        int height = 0;
        if (this._axesTop != null) {
            for (int icol = 0; icol < this._ncol; ++icol) {
                height = Math.max(height, this._axesTop[icol].getHeightMinimum());
            }
            height += 2 * this.widthAxesBorder();
        }
        return height;
    }

    private int heightMinimumAxesBottom() {
        int height = 0;
        if (this._axesBottom != null) {
            for (int icol = 0; icol < this._ncol; ++icol) {
                height = Math.max(height, this._axesBottom[icol].getHeightMinimum());
            }
            height += 2 * this.widthAxesBorder();
        }
        return height;
    }

    private int heightMinimumHScrollBars() {
        return 0;
    }

    private int heightHScrollBars() {
        for (int icol = 0; icol < this._ncol; ++icol) {
            if (!this._hsb[icol].isVisible()) continue;
            return this._hsb[icol].getMinimumSize().height;
        }
        return 0;
    }

    private void updateScrollBars() {
        for (int icol = 0; icol < this._ncol; ++icol) {
            this._hsb[icol].update();
        }
        for (int irow = 0; irow < this._nrow; ++irow) {
            this._vsb[irow].update();
        }
    }

    private class VScrollBar
    extends TileScrollBar {
        private static final long serialVersionUID = 1L;
        int irow;

        VScrollBar(int irow) {
            super(1, Mosaic.this._tiles[irow][0]);
            this.irow = irow;
        }
    }

    private class HScrollBar
    extends TileScrollBar {
        private static final long serialVersionUID = 1L;
        int icol;

        HScrollBar(int icol) {
            super(0, Mosaic.this._tiles[0][icol]);
            this.icol = icol;
        }
    }

    private class TileScrollBar
    extends JScrollBar {
        private static final long serialVersionUID = 1L;
        Tile tile;
        private boolean _settingInternal;

        TileScrollBar(int orientation, final Tile tile) {
            super(orientation, 0, 1000000000, 0, 1000000000);
            this.setVisible(false);
            this.tile = tile;
            this.addAdjustmentListener(new AdjustmentListener(){

                public void adjustmentValueChanged(AdjustmentEvent ae) {
                    if (TileScrollBar.this._settingInternal) {
                        return;
                    }
                    DRectangle vr = tile.getViewRectangle();
                    if (TileScrollBar.this.getOrientation() == 0) {
                        vr.x = TileScrollBar.this.getV();
                        vr.width = TileScrollBar.this.getE();
                    } else {
                        vr.y = TileScrollBar.this.getV();
                        vr.height = TileScrollBar.this.getE();
                    }
                    tile.setViewRectangle(vr);
                }
            });
        }

        void setV(double v) {
            this._settingInternal = true;
            this.setValue((int)(v * 1.0E9 + 0.5));
            this._settingInternal = false;
        }

        void setE(double e) {
            this._settingInternal = true;
            this.setVisibleAmount((int)(e * 1.0E9 + 0.5));
            this.setVisible(this.getVisibleAmount() < 1000000000);
            this.setUnitIncrement((int)(0.05 * e * 1.0E9 + 0.5));
            this.setBlockIncrement((int)(0.5 * e * 1.0E9 + 0.5));
            this._settingInternal = false;
        }

        double getV() {
            return 1.0E-9 * (double)this.getValue();
        }

        double getE() {
            return 1.0E-9 * (double)this.getVisibleAmount();
        }

        void update() {
            DRectangle vr = this.tile.getViewRectangle();
            if (this.getOrientation() == 0) {
                this.setV(vr.x);
                this.setE(vr.width);
            } else {
                this.setV(vr.y);
                this.setE(vr.height);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AxesPlacement {
        TOP,
        LEFT,
        BOTTOM,
        RIGHT;

    }
}

