/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.mosaic.DRectangle;
import edu.mines.jtk.mosaic.Projector;
import edu.mines.jtk.mosaic.Tile;
import edu.mines.jtk.mosaic.TileAxis;
import edu.mines.jtk.mosaic.TiledView;
import edu.mines.jtk.mosaic.Transcaler;
import edu.mines.jtk.util.AxisTics;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;

public class GridView
extends TiledView {
    private Horizontal _horizontal = Horizontal.MAJOR;
    private Vertical _vertical = Vertical.MAJOR;
    private Style _style = Style.SOLID;
    private Color _color = null;

    public GridView() {
    }

    public GridView(Horizontal horizontal, Vertical vertical) {
        this.setHorizontal(horizontal);
        this.setVertical(vertical);
    }

    public GridView(Style style) {
        this.setStyle(style);
    }

    public GridView(Color color) {
        this.setColor(color);
    }

    public GridView(Horizontal horizontal, Vertical vertical, Color color) {
        this.setHorizontal(horizontal);
        this.setVertical(vertical);
        this.setColor(color);
    }

    public GridView(Horizontal horizontal, Vertical vertical, Color color, Style style) {
        this.setHorizontal(horizontal);
        this.setVertical(vertical);
        this.setColor(color);
        this.setStyle(style);
    }

    public GridView(String parameters) {
        this.setParameters(parameters);
    }

    public void setHorizontal(Horizontal horizontal) {
        if (this._horizontal != horizontal) {
            this._horizontal = horizontal;
            this.repaint();
        }
    }

    public void setVertical(Vertical vertical) {
        if (this._vertical != vertical) {
            this._vertical = vertical;
            this.repaint();
        }
    }

    public void setColor(Color color) {
        if (!this.equalColors(this._color, color)) {
            this._color = color;
            this.repaint();
        }
    }

    public void setStyle(Style style) {
        if (this._style != style) {
            this._style = style;
            this.repaint();
        }
    }

    public void setParameters(String parameters) {
        if (parameters.contains("H0")) {
            this.setHorizontal(Horizontal.ZERO);
        } else if (parameters.contains("H")) {
            this.setHorizontal(Horizontal.MAJOR);
        } else {
            this.setHorizontal(Horizontal.NONE);
        }
        if (parameters.contains("V0")) {
            this.setVertical(Vertical.ZERO);
        } else if (parameters.contains("V")) {
            this.setVertical(Vertical.MAJOR);
        } else {
            this.setVertical(Vertical.NONE);
        }
        if (parameters.contains("r")) {
            this.setColor(Color.RED);
        } else if (parameters.contains("g")) {
            this.setColor(Color.GREEN);
        } else if (parameters.contains("b")) {
            this.setColor(Color.BLUE);
        } else if (parameters.contains("c")) {
            this.setColor(Color.CYAN);
        } else if (parameters.contains("m")) {
            this.setColor(Color.MAGENTA);
        } else if (parameters.contains("y")) {
            this.setColor(Color.YELLOW);
        } else if (parameters.contains("k")) {
            this.setColor(Color.BLACK);
        } else if (parameters.contains("w")) {
            this.setColor(Color.WHITE);
        } else {
            this.setColor(null);
        }
        if (parameters.contains("--.")) {
            this.setStyle(Style.DASH_DOT);
        } else if (parameters.contains("--")) {
            this.setStyle(Style.DASH);
        } else if (parameters.contains("-.")) {
            this.setStyle(Style.DOT);
        } else if (parameters.contains("-")) {
            this.setStyle(Style.SOLID);
        } else {
            this.setStyle(Style.NONE);
        }
    }

    public void paint(Graphics2D g2d) {
        double utic;
        double vtic;
        int itic;
        double fticMajor;
        double dticMajor;
        int nticMajor;
        TileAxis axisTopBottom;
        if (this._horizontal == Horizontal.NONE && this._vertical == Vertical.NONE) {
            return;
        }
        if (this._style == Style.NONE) {
            return;
        }
        Tile tile = this.getTile();
        TileAxis axisTop = tile.getTileAxisTop();
        TileAxis axisLeft = tile.getTileAxisLeft();
        TileAxis axisBottom = tile.getTileAxisBottom();
        TileAxis axisRight = tile.getTileAxisRight();
        TileAxis axisLeftRight = axisLeft != null ? axisLeft : axisRight;
        TileAxis tileAxis = axisTopBottom = axisTop != null ? axisTop : axisBottom;
        if (axisLeftRight == null && axisTopBottom == null) {
            return;
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float lineWidth = 1.0f;
        Stroke stroke = g2d.getStroke();
        if (stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)stroke;
            lineWidth = bs.getLineWidth();
        }
        float[] dash = null;
        if (this._style != Style.SOLID) {
            float dotLength = lineWidth;
            float dashLength = 5.0f * lineWidth;
            float gapLength = 5.0f * lineWidth;
            if (this._style == Style.DASH) {
                dash = new float[]{dashLength, gapLength};
            } else if (this._style == Style.DOT) {
                dash = new float[]{dotLength, gapLength};
            } else if (this._style == Style.DASH_DOT) {
                dash = new float[]{dashLength, gapLength, dotLength, gapLength};
            }
        }
        float width = lineWidth;
        BasicStroke bs = null;
        if (dash != null) {
            int cap = 1;
            int join = 1;
            float miter = 10.0f;
            float phase = 0.0f;
            bs = new BasicStroke(width, cap, join, miter, dash, phase);
        } else {
            bs = new BasicStroke(width);
        }
        g2d.setStroke(bs);
        if (this._color != null) {
            g2d.setColor(this._color);
        }
        Projector hp = this.getHorizontalProjector();
        Projector vp = this.getVerticalProjector();
        Transcaler ts = this.getTranscaler();
        DRectangle vr = tile.getViewRectangle();
        int w = ts.width(vr.width);
        int h = ts.height(vr.height);
        if (this._horizontal == Horizontal.ZERO) {
            int y = ts.y(vp.u(0.0));
            g2d.drawLine(0, y, w - 1, y);
        } else if (this._horizontal == Horizontal.MAJOR && axisLeftRight != null) {
            AxisTics at = axisLeftRight.getAxisTics();
            nticMajor = at.getCountMajor();
            dticMajor = at.getDeltaMajor();
            fticMajor = at.getFirstMajor();
            for (itic = 0; itic < nticMajor; ++itic) {
                vtic = fticMajor + (double)itic * dticMajor;
                utic = vp.u(vtic);
                int y = ts.y(utic);
                g2d.drawLine(0, y, w - 1, y);
            }
        }
        if (this._vertical == Vertical.ZERO) {
            int x = ts.x(hp.u(0.0));
            g2d.drawLine(x, 0, x, h - 1);
        } else if (this._vertical == Vertical.MAJOR && axisTopBottom != null) {
            AxisTics at = axisTopBottom.getAxisTics();
            nticMajor = at.getCountMajor();
            dticMajor = at.getDeltaMajor();
            fticMajor = at.getFirstMajor();
            for (itic = 0; itic < nticMajor; ++itic) {
                vtic = fticMajor + (double)itic * dticMajor;
                utic = hp.u(vtic);
                int x = ts.x(utic);
                g2d.drawLine(x, 0, x, h - 1);
            }
        }
    }

    private boolean equalColors(Color ca, Color cb) {
        return ca == null ? cb == null : ca.equals(cb);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        NONE,
        SOLID,
        DASH,
        DOT,
        DASH_DOT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Vertical {
        NONE,
        ZERO,
        MAJOR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Horizontal {
        NONE,
        ZERO,
        MAJOR;

    }
}

