/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.mosaic.Projector;
import edu.mines.jtk.mosaic.TiledView;
import edu.mines.jtk.util.Array;
import edu.mines.jtk.util.Check;
import edu.mines.jtk.util.MathPlus;
import java.awt.Graphics2D;
import java.util.ArrayList;

public class ContoursView
extends TiledView {
    private Sampling _s1;
    private Sampling _s2;
    private float[][] _f;
    private Orientation _orientation = Orientation.X1RIGHT_X2UP;
    private float _clipMin;
    private float _clipMax;
    private float _percMin = 0.0f;
    private float _percMax = 100.0f;
    private boolean _usePercentiles = true;
    private boolean _xflipped;
    private boolean _yflipped;
    private int _nx;
    private double _dx;
    private double _fx;
    private int _ny;
    private double _dy;
    private double _fy;
    private Sampling _cs;
    private ArrayList<Contour> _cl;
    private static final byte WEST = 1;
    private static final byte SOUTH = 2;
    private static final byte NOT_WEST = -2;
    private static final byte NOT_SOUTH = -3;

    public ContoursView(float[][] f) {
        this.set(f);
    }

    public ContoursView(Sampling s1, Sampling s2, float[][] f) {
        this.set(s1, s2, f);
    }

    public void set(float[][] f) {
        this.set(new Sampling(f[0].length), new Sampling(f.length), f);
    }

    public void set(Sampling s1, Sampling s2, float[][] f) {
        Check.argument(s1.isUniform(), "s1 is uniform");
        Check.argument(s2.isUniform(), "s2 is uniform");
        Check.argument(Array.isRegular(f), "f is regular");
        Check.argument(s1.getCount() == f[0].length, "s1 consistent with f");
        Check.argument(s2.getCount() == f.length, "s2 consistent with f");
        this._s1 = s1;
        this._s2 = s2;
        this._f = Array.copy(f);
        this.updateClips();
        this.updateSampling();
        this.updateContours();
    }

    public void setOrientation(Orientation orientation) {
        if (this._orientation != orientation) {
            this._orientation = orientation;
            this.updateSampling();
            this.repaint();
        }
    }

    public Orientation getOrientation() {
        return this._orientation;
    }

    public void setClips(float clipMin, float clipMax) {
        Check.argument(clipMin < clipMax, "clipMin<clipMax");
        if (this._clipMin != clipMin || this._clipMax != clipMax) {
            this._clipMin = clipMin;
            this._clipMax = clipMax;
            this._usePercentiles = false;
            this.repaint();
        }
    }

    public float getClipMin() {
        return this._clipMin;
    }

    public float getClipMax() {
        return this._clipMax;
    }

    public void setPercentiles(float percMin, float percMax) {
        Check.argument(0.0f <= percMin, "0<=percMin");
        Check.argument(percMin < percMax, "percMin<percMax");
        Check.argument(percMax <= 100.0f, "percMax<=100");
        if (this._percMin != percMin || this._percMax != percMax) {
            this._percMin = percMin;
            this._percMax = percMax;
            this._usePercentiles = true;
            this.updateClips();
            this.repaint();
        }
    }

    public float getPercentileMin() {
        return this._percMin;
    }

    public float getPercentileMax() {
        return this._percMax;
    }

    public void paint(Graphics2D g2d) {
    }

    private void updateClips() {
        if (this._usePercentiles) {
            float[] a = (float[])(this._percMin != 0.0f || this._percMax != 0.0f ? Array.flatten(this._f) : null);
            int n = a != null ? a.length : 0;
            int kmin = (int)MathPlus.rint((double)this._percMin * 0.01 * (double)(n - 1));
            if (kmin <= 0) {
                this._clipMin = Array.min(this._f);
            } else {
                Array.quickPartialSort(kmin, a);
                this._clipMin = a[kmin];
            }
            int kmax = (int)MathPlus.rint((double)this._percMax * 0.01 * (double)(n - 1));
            if (kmax >= n - 1) {
                this._clipMax = Array.max(this._f);
            } else {
                Array.quickPartialSort(kmax, a);
                this._clipMax = a[kmax];
            }
        }
    }

    private void updateSampling() {
        int n1 = this._s1.getCount();
        int n2 = this._s2.getCount();
        double d1 = this._s1.getDelta();
        double d2 = this._s2.getDelta();
        double f1 = this._s1.getFirst();
        double f2 = this._s2.getFirst();
        if (this._orientation == Orientation.X1DOWN_X2RIGHT) {
            this._xflipped = false;
            this._yflipped = false;
            this._nx = n2;
            this._dx = d2;
            this._fx = f2;
            this._ny = n1;
            this._dy = d1;
            this._fy = f1;
        } else if (this._orientation == Orientation.X1RIGHT_X2UP) {
            this._xflipped = false;
            this._yflipped = true;
            this._nx = n1;
            this._dx = d1;
            this._fx = f1;
            this._ny = n2;
            this._dy = d2;
            this._fy = f2;
        }
        this.updateBestProjectors();
    }

    private void updateBestProjectors() {
        double tiny;
        double x0 = this._fx;
        double x1 = this._fx + this._dx * (double)(this._nx - 1);
        double y0 = this._fy;
        double y1 = this._fy + this._dy * (double)(this._ny - 1);
        if (this._xflipped) {
            double xt = y0;
            x0 = x1;
            x1 = xt;
        }
        if (this._yflipped) {
            double yt = y0;
            y0 = y1;
            y1 = yt;
        }
        if (x0 == x1) {
            tiny = MathPlus.max(0.5, 1.1920928955078125E-7 * MathPlus.abs(x0));
            x0 -= tiny;
            x1 += tiny;
        }
        if (y0 == y1) {
            tiny = MathPlus.max(0.5, 1.1920928955078125E-7 * MathPlus.abs(y0));
            y0 -= tiny;
            y1 += tiny;
        }
        double uxMargin = this._nx > 1 ? 0.5 / (double)this._nx : 0.0;
        double uyMargin = this._ny > 1 ? 0.5 / (double)this._ny : 0.0;
        double ux0 = uxMargin;
        double uy0 = uyMargin;
        double ux1 = 1.0 - uxMargin;
        double uy1 = 1.0 - uyMargin;
        Projector bhp = new Projector(x0, x1, ux0, ux1);
        Projector bvp = new Projector(y0, y1, uy0, uy1);
        this.setBestProjectors(bhp, bvp);
    }

    private void updateContours() {
        int nc = this._cs.getCount();
        this._cl = new ArrayList();
        for (int ic = 0; ic < nc; ++ic) {
            float fc = (float)this._cs.getValue(ic);
            Contour c = ContoursView.makeContour(fc, this._s1, this._s2, this._f);
            this._cl.add(c);
        }
    }

    private static Contour makeContour(float fc, Sampling s1, Sampling s2, float[][] f) {
        int i;
        FloatList x2;
        FloatList x1;
        float d;
        int i1;
        int i2;
        int n1 = s1.getCount();
        double d1 = s1.getDelta();
        double f1 = s1.getFirst();
        int n2 = s2.getCount();
        double d2 = s2.getDelta();
        double f2 = s2.getFirst();
        int n1m1 = n1 - 1;
        int n2m1 = n2 - 1;
        byte[][] flags = new byte[n2][n1];
        int ni = 0;
        for (i2 = 0; i2 < n2; ++i2) {
            for (i1 = 0; i1 < n1; ++i1) {
                if (i2 < n2m1 && ContoursView.between(fc, f[i2][i1], f[i2 + 1][i1])) {
                    ContoursView.setw(i1, i2, flags);
                    ++ni;
                }
                if (i1 >= n1m1 || !ContoursView.between(fc, f[i2][i1], f[i2][i1 + 1])) continue;
                ContoursView.sets(i1, i2, flags);
                ++ni;
            }
        }
        Contour c = new Contour(fc);
        i2 = n2m1;
        i1 = 0;
        int is = i1 + i2 * n1;
        while (i1 < n1m1 && ni > 0) {
            if (ContoursView.sset(i1, i2, flags)) {
                d = ContoursView.delta(fc, f[i2][i1], f[i2][i1 + 1]);
                x1 = new FloatList();
                x2 = new FloatList();
                x1.add(f1 + (double)((float)i1 + d) * d1);
                x2.add(f2 + (double)i2 * d2);
                ContoursView.clrs(i1, i2, flags);
                i = is - n1;
                while (i >= 0) {
                    --ni;
                    i = ContoursView.connect(i, fc, n1, d1, f1, n2, d2, f2, f, flags, x1, x2);
                }
                c.append(x1, x2);
            }
            ++i1;
            ++is;
        }
        i1 = n1m1;
        i2 = 0;
        is = i1 + i2 * n1;
        while (i2 < n2m1 && ni > 0) {
            if (ContoursView.wset(i1, i2, flags)) {
                d = ContoursView.delta(fc, f[i2][i1], f[i2 + 1][i1]);
                x1 = new FloatList();
                x2 = new FloatList();
                x1.add(f1 + (double)i1 * d1);
                x2.add(f2 + (double)((float)i2 + d) * d2);
                ContoursView.clrw(i1, i2, flags);
                i = is - 1;
                while (i >= 0) {
                    --ni;
                    i = ContoursView.connect(i, fc, n1, d1, f1, n2, d2, f2, f, flags, x1, x2);
                }
                c.append(x1, x2);
            }
            ++i2;
            is += n1;
        }
        i2 = 0;
        i1 = 0;
        is = i1 + i2 * n1;
        while (i1 < n1m1 && ni > 0) {
            if (ContoursView.sset(i1, i2, flags)) {
                d = ContoursView.delta(fc, f[i2][i1], f[i2][i1 + 1]);
                x1 = new FloatList();
                x2 = new FloatList();
                x1.add(f1 + (double)((float)i1 + d) * d1);
                x2.add(f2 + (double)i2 * d2);
                ContoursView.clrs(i1, i2, flags);
                i = is;
                while (i >= 0) {
                    --ni;
                    i = ContoursView.connect(i, fc, n1, d1, f1, n2, d2, f2, f, flags, x1, x2);
                }
                c.append(x1, x2);
            }
            ++i1;
            ++is;
        }
        i1 = 0;
        i2 = 0;
        is = i1 + i2 * n1;
        while (i2 < n2m1 && ni > 0) {
            if (ContoursView.wset(i1, i2, flags)) {
                d = ContoursView.delta(fc, f[i2][i1], f[i2 + 1][i1]);
                x1 = new FloatList();
                x2 = new FloatList();
                x1.add(f1 + (double)i1 * d1);
                x2.add(f2 + (double)((float)i2 + d) * d2);
                ContoursView.clrw(i1, i2, flags);
                i = is;
                while (i >= 0) {
                    --ni;
                    i = ContoursView.connect(i, fc, n1, d1, f1, n2, d2, f2, f, flags, x1, x2);
                }
                c.append(x1, x2);
            }
            ++i2;
            is += n1;
        }
        for (i2 = 1; i2 < n2m1 && ni > 0; ++i2) {
            i1 = 0;
            is = i1 + i2 * n1;
            while (i1 < n1m1 && ni > 0) {
                if (ContoursView.sset(i1, i2, flags)) {
                    d = ContoursView.delta(fc, f[i2][i1], f[i2][i1 + 1]);
                    x1 = new FloatList();
                    x2 = new FloatList();
                    x1.add(f1 + (double)((float)i1 + d) * d1);
                    x2.add(f2 + (double)i2 * d2);
                    ContoursView.clrs(i1, i2, flags);
                    i = is;
                    while (i >= 0) {
                        --ni;
                        i = ContoursView.connect(i, fc, n1, d1, f1, n2, d2, f2, f, flags, x1, x2);
                    }
                    c.append(x1, x2);
                }
                ++i1;
                ++is;
            }
        }
        return c;
    }

    private static int connect(int index, float fc, int n1, double d1, double f1, int n2, double d2, double f2, float[][] f, byte[][] flags, FloatList x1, FloatList x2) {
        int i1 = index % n1;
        int i2 = index / n1;
        if (ContoursView.sset(i1, i2 + 1, flags)) {
            float d = ContoursView.delta(fc, f[i2][i1], f[i2][i1 + 1]);
            x1.add(f1 + (double)((float)i1 + d) * d1);
            x2.add(f2 + (double)(i2 + 1) * d2);
            ContoursView.clrs(i1, ++i2, flags);
            return i2 < n2 - 1 ? index + n1 : -1;
        }
        if (ContoursView.wset(i1 + 1, i2, flags)) {
            float d = ContoursView.delta(fc, f[i2][i1], f[i2 + 1][i1]);
            x1.add(f1 + (double)(i1 + 1) * d1);
            x2.add(f2 + (double)((float)i2 + d) * d2);
            ContoursView.clrw(++i1, i2, flags);
            return i1 < n1 - 1 ? index + 1 : -1;
        }
        if (ContoursView.sset(i1, i2, flags)) {
            float d = ContoursView.delta(fc, f[i2][i1], f[i2][i1 + 1]);
            x1.add(f1 + (double)((float)i1 + d) * d1);
            x2.add(f2 + (double)i2 * d2);
            ContoursView.clrs(i1, i2, flags);
            return i2 > 0 ? index - n1 : -1;
        }
        if (ContoursView.wset(i1, i2, flags)) {
            float d = ContoursView.delta(fc, f[i2][i1], f[i2 + 1][i1]);
            x1.add(f1 + (double)i1 * d1);
            x2.add(f2 + (double)((float)i2 + d) * d2);
            ContoursView.clrw(i1, i2, flags);
            return i1 > 0 ? index - 1 : -1;
        }
        return -1;
    }

    private static void sets(int i1, int i2, byte[][] flags) {
        byte[] byArray = flags[i2];
        int n = i1;
        byArray[n] = (byte)(byArray[n] | 2);
    }

    private static void setw(int i1, int i2, byte[][] flags) {
        byte[] byArray = flags[i2];
        int n = i1;
        byArray[n] = (byte)(byArray[n] | 1);
    }

    private static void clrs(int i1, int i2, byte[][] flags) {
        byte[] byArray = flags[i2];
        int n = i1;
        byArray[n] = (byte)(byArray[n] & 0xFFFFFFFD);
    }

    private static void clrw(int i1, int i2, byte[][] flags) {
        byte[] byArray = flags[i2];
        int n = i1;
        byArray[n] = (byte)(byArray[n] & 0xFFFFFFFE);
    }

    private static boolean sset(int i1, int i2, byte[][] flags) {
        return (flags[i2][i1] & 2) != 0;
    }

    private static boolean wset(int i1, int i2, byte[][] flags) {
        return (flags[i2][i1] & 1) != 0;
    }

    private static boolean between(float fc, float f1, float f2) {
        return f1 <= f2 ? f1 <= fc && fc < f2 : f2 <= fc && fc < f1;
    }

    private static float delta(float fc, float f1, float f2) {
        return f1 != f2 ? (fc - f1) / (f2 - f1) : 1.0f;
    }

    private static class FloatList {
        public int n;
        public float[] a = new float[64];

        private FloatList() {
        }

        public void add(double f) {
            if (this.n == this.a.length) {
                float[] t = new float[2 * this.a.length];
                for (int i = 0; i < this.n; ++i) {
                    t[i] = this.a[i];
                }
                this.a = t;
            }
            this.a[this.n++] = (float)f;
        }

        public float[] trim() {
            float[] t = new float[this.n];
            for (int i = 0; i < this.n; ++i) {
                t[i] = this.a[i];
            }
            return t;
        }
    }

    private static class Contour {
        float fc;
        int ns = 0;
        ArrayList<float[]> x1 = new ArrayList();
        ArrayList<float[]> x2 = new ArrayList();

        Contour(float fc) {
            this.fc = fc;
        }

        void append(FloatList x1List, FloatList x2List) {
            ++this.ns;
            this.x1.add(x1List.trim());
            this.x2.add(x2List.trim());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Orientation {
        X1RIGHT_X2UP,
        X1DOWN_X2RIGHT;

    }
}

