/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mesh.test;

import edu.mines.jtk.mesh.TriMesh;
import edu.mines.jtk.util.Stopwatch;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TriMeshTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(TriMeshTest.class);
        TestRunner.run((Test)suite);
    }

    public void testNabors() {
        TriMesh tm = new TriMesh();
        TriMesh.Node n0 = new TriMesh.Node(1.0f, 0.0f);
        TriMesh.Node n1 = new TriMesh.Node(0.0f, 1.0f);
        TriMesh.Node n2 = new TriMesh.Node(0.0f, 0.0f);
        TriMesh.Node n3 = new TriMesh.Node(1.1f, 1.1f);
        tm.addNode(n0);
        tm.addNode(n1);
        tm.addNode(n2);
        tm.addNode(n3);
        TriMeshTest.assertEquals((int)2, (int)tm.getTriNabors(n0).length);
        TriMeshTest.assertEquals((int)2, (int)tm.getTriNabors(n1).length);
        TriMeshTest.assertEquals((int)1, (int)tm.getTriNabors(n2).length);
        TriMeshTest.assertEquals((int)1, (int)tm.getTriNabors(n3).length);
        TriMeshTest.assertEquals((int)2, (int)tm.getTriNabors(tm.findEdge(n0, n1)).length);
        TriMeshTest.assertEquals((int)1, (int)tm.getTriNabors(tm.findEdge(n0, n2)).length);
        TriMeshTest.assertEquals((int)1, (int)tm.getTriNabors(tm.findEdge(n1, n2)).length);
        TriMeshTest.assertEquals((int)1, (int)tm.getTriNabors(tm.findEdge(n0, n3)).length);
        TriMeshTest.assertEquals((int)1, (int)tm.getTriNabors(tm.findEdge(n1, n3)).length);
        TriMeshTest.assertEquals((int)3, (int)tm.getEdgeNabors(n0).length);
        TriMeshTest.assertEquals((int)3, (int)tm.getEdgeNabors(n1).length);
        TriMeshTest.assertEquals((int)2, (int)tm.getEdgeNabors(n2).length);
        TriMeshTest.assertEquals((int)2, (int)tm.getEdgeNabors(n3).length);
        TriMeshTest.assertEquals((int)3, (int)tm.getNodeNabors(n0).length);
        TriMeshTest.assertEquals((int)3, (int)tm.getNodeNabors(n1).length);
        TriMeshTest.assertEquals((int)2, (int)tm.getNodeNabors(n2).length);
        TriMeshTest.assertEquals((int)2, (int)tm.getNodeNabors(n3).length);
    }

    public void testIO() throws IOException, ClassNotFoundException {
        TriMesh.Node n00 = new TriMesh.Node(0.0f, 0.0f);
        TriMesh.Node n01 = new TriMesh.Node(0.0f, 1.0f);
        TriMesh.Node n10 = new TriMesh.Node(1.0f, 0.0f);
        TriMesh.Node n11 = new TriMesh.Node(1.0f, 1.0f);
        TriMesh tm = new TriMesh();
        tm.addNode(n00);
        tm.addNode(n01);
        tm.addNode(n10);
        tm.addNode(n11);
        int nnode = tm.countNodes();
        int ntri = tm.countTris();
        TriMeshTest.assertEquals((int)4, (int)nnode);
        TriMesh.NodePropertyMap map = tm.getNodePropertyMap("foo");
        map.put(n00, new Integer(0));
        map.put(n01, new Integer(1));
        map.put(n10, new Integer(2));
        map.put(n11, new Integer(3));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(tm);
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        tm = (TriMesh)ois.readObject();
        bais.close();
        TriMeshTest.assertEquals((int)nnode, (int)tm.countNodes());
        TriMeshTest.assertEquals((int)ntri, (int)tm.countTris());
        String name = tm.getNodePropertyMapNames()[0];
        TriMeshTest.assertEquals((String)"foo", (String)name);
        map = tm.getNodePropertyMap(name);
        n00 = tm.findNodeNearest(0.0f, 0.0f);
        n01 = tm.findNodeNearest(0.0f, 1.0f);
        n10 = tm.findNodeNearest(1.0f, 0.0f);
        n11 = tm.findNodeNearest(1.0f, 1.0f);
        TriMeshTest.assertEquals((int)0, (int)((Integer)map.get(n00)));
        TriMeshTest.assertEquals((int)1, (int)((Integer)map.get(n01)));
        TriMeshTest.assertEquals((int)2, (int)((Integer)map.get(n10)));
        TriMeshTest.assertEquals((int)3, (int)((Integer)map.get(n11)));
    }

    public void testTriListener() {
        TriMesh tm = new TriMesh();
        tm.addNode(new TriMesh.Node(0.0f, 0.0f));
        tm.addNode(new TriMesh.Node(1.0f, 0.0f));
        tm.addNode(new TriMesh.Node(0.0f, 1.0f));
        TriListener tl = new TriListener();
        tm.addTriListener(tl);
        TriMesh.Node node = new TriMesh.Node(0.1f, 0.1f);
        tm.addNode(node);
        TriMeshTest.assertEquals((int)3, (int)tl.countAdded());
        TriMeshTest.assertEquals((int)1, (int)tl.countRemoved());
        tm.removeNode(node);
        TriMeshTest.assertEquals((int)4, (int)tl.countAdded());
        TriMeshTest.assertEquals((int)4, (int)tl.countRemoved());
    }

    public void testSimple() {
        TriMesh tm = new TriMesh();
        TriMesh.Node n0 = new TriMesh.Node(0.0f, 0.0f);
        TriMesh.Node n1 = new TriMesh.Node(1.0f, 0.0f);
        TriMesh.Node n2 = new TriMesh.Node(0.0f, 1.0f);
        TriMesh.Node n3 = new TriMesh.Node(0.3f, 0.3f);
        tm.addNode(n0);
        tm.addNode(n1);
        tm.addNode(n2);
        tm.addNode(n3);
        tm.removeNode(n3);
        tm.validate();
    }

    public void testSquare() {
        TriMesh tm = new TriMesh();
        TriMesh.Node n0 = new TriMesh.Node(0.0f, 0.0f);
        TriMesh.Node n1 = new TriMesh.Node(1.0f, 0.0f);
        TriMesh.Node n2 = new TriMesh.Node(0.0f, 1.0f);
        TriMesh.Node n3 = new TriMesh.Node(1.0f, 1.0f);
        tm.addNode(n0);
        tm.addNode(n1);
        tm.addNode(n2);
        tm.addNode(n3);
        tm.removeNode(n3);
        tm.removeNode(n2);
        tm.removeNode(n1);
        tm.removeNode(n0);
        tm.validate();
    }

    public void testAddFindRemove() {
        Random random = new Random();
        TriMesh tm = new TriMesh();
        int nadd = 0;
        int nremove = 0;
        for (int niter = 0; niter < 1000; ++niter) {
            TriMesh.Node node;
            float x = random.nextFloat();
            float y = random.nextFloat();
            if (tm.countNodes() < 10 || random.nextFloat() > 0.5f) {
                node = new TriMesh.Node(x, y);
                boolean ok = tm.addNode(node);
                TriMeshTest.assertTrue((boolean)ok);
                tm.validate();
                ++nadd;
                continue;
            }
            if (tm.countNodes() <= 0) continue;
            node = tm.findNodeNearest(x, y);
            TriMeshTest.assertTrue((node != null ? 1 : 0) != 0);
            TriMesh.Node nodeSlow = tm.findNodeNearestSlow(x, y);
            TriMeshTest.assertTrue((node == nodeSlow ? 1 : 0) != 0);
            tm.removeNode(node);
            tm.validate();
            ++nremove;
        }
    }

    public void benchAddNode() {
        Random random = new Random();
        for (int itest = 0; itest < 3; ++itest) {
            for (int nnode = 1000; nnode <= 64000; nnode *= 2) {
                Stopwatch sw = new Stopwatch();
                sw.restart();
                TriMesh tm = new TriMesh();
                for (int inode = 0; inode < nnode; ++inode) {
                    float x = random.nextFloat();
                    float y = random.nextFloat();
                    TriMesh.Node node = new TriMesh.Node(x, y);
                    tm.addNode(node);
                }
                sw.stop();
                System.out.println("Added " + nnode + " nodes to make " + tm.countTris() + " tris in " + sw.time() + " seconds.");
                tm.validate();
            }
            try {
                System.out.println("Sleeping");
                Thread.sleep(5000L, 0);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void benchFind() {
        int nnode = 1000;
        int nfind = 10000;
        int ntest = 3;
        Random random = new Random();
        Stopwatch sw = new Stopwatch();
        TriMesh tm = new TriMesh();
        for (int inode = 0; inode < nnode; ++inode) {
            float x = random.nextFloat();
            float y = random.nextFloat();
            TriMesh.Node node = new TriMesh.Node(x, y);
            tm.addNode(node);
        }
        for (int itest = 0; itest < ntest; ++itest) {
            float[] x = new float[nfind];
            float[] y = new float[nfind];
            for (int ifind = 0; ifind < nfind; ++ifind) {
                x[ifind] = random.nextFloat();
                y[ifind] = random.nextFloat();
            }
            TriMesh.Node[] nfast = new TriMesh.Node[nfind];
            sw.reset();
            sw.start();
            for (int ifind = 0; ifind < nfind; ++ifind) {
                nfast[ifind] = tm.findNodeNearest(x[ifind], y[ifind]);
            }
            sw.stop();
            int sfast = (int)((double)nfind / sw.time());
            TriMesh.Node[] nslow = new TriMesh.Node[nfind];
            sw.reset();
            sw.start();
            for (int ifind = 0; ifind < nfind; ++ifind) {
                nslow[ifind] = tm.findNodeNearestSlow(x[ifind], y[ifind]);
            }
            sw.stop();
            int sslow = (int)((double)nfind / sw.time());
            for (int ifind = 0; ifind < nfind; ++ifind) {
                if (nfast[ifind] != nslow[ifind]) {
                    float xfast = nfast[ifind].x();
                    float yfast = nfast[ifind].y();
                    float xslow = nslow[ifind].x();
                    float yslow = nslow[ifind].y();
                    float dxfast = xfast - x[ifind];
                    float dyfast = yfast - y[ifind];
                    float dxslow = xslow - x[ifind];
                    float dyslow = yslow - y[ifind];
                    float dsfast = dxfast * dxfast + dyfast * dyfast;
                    float dsslow = dxslow * dxslow + dyslow * dyslow;
                    System.out.println("ifind=" + ifind + " fast/slow=" + dsfast + "/" + dsslow);
                }
                TriMeshTest.assertTrue((nfast[ifind] == nslow[ifind] ? 1 : 0) != 0);
            }
            System.out.println("Find fast/slow nodes per sec = " + sfast + "/" + sslow);
        }
    }

    private static class TriListener
    implements TriMesh.TriListener {
        private int _nadded;
        private int _nremoved;

        private TriListener() {
        }

        public void triAdded(TriMesh mesh, TriMesh.Tri tri) {
            ++this._nadded;
        }

        public void triRemoved(TriMesh mesh, TriMesh.Tri tri) {
            ++this._nremoved;
        }

        public int countAdded() {
            return this._nadded;
        }

        public int countRemoved() {
            return this._nremoved;
        }
    }
}

