/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mesh.test;

import edu.mines.jtk.mesh.Geometry;
import edu.mines.jtk.util.Stopwatch;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GeometryTest
extends TestCase {
    private static final int X = 0;
    private static final int Y = 1;
    private static final int Z = 2;
    private static final boolean TRACE = false;

    public static void main(String[] args) {
        TestSuite suite = new TestSuite(GeometryTest.class);
        TestRunner.run((Test)suite);
    }

    public void testInCircle() {
        float xxxx = 3.14159f;
        float yyyy = 1.0E15f;
        float[] pa = new float[]{xxxx, 0.0f};
        float[] pb = new float[]{0.0f, yyyy};
        float[] pc = new float[]{0.0f, 0.0f};
        float[] pd = new float[]{xxxx, yyyy};
        GeometryTest.trace("");
        double ra = Geometry.inCircle(pa, pb, pc, pd);
        double rf = Geometry.inCircleFast(pa, pb, pc, pd);
        GeometryTest.trace("0 inCircle:     " + String.format("%26.18e", ra));
        GeometryTest.trace("0 inCircleFast: " + String.format("%26.18e", rf));
        GeometryTest.assertTrue((ra == 0.0 ? 1 : 0) != 0);
        pd[0] = xxxx * 0.9999999f;
        ra = Geometry.inCircle(pa, pb, pc, pd);
        rf = Geometry.inCircleFast(pa, pb, pc, pd);
        GeometryTest.trace("+ inCircle:     " + String.format("%26.18e", ra));
        GeometryTest.trace("+ inCircleFast: " + String.format("%26.18e", rf));
        GeometryTest.assertTrue((ra > 0.0 ? 1 : 0) != 0);
        pd[0] = xxxx * 1.0000001f;
        ra = Geometry.inCircle(pa, pb, pc, pd);
        rf = Geometry.inCircleFast(pa, pb, pc, pd);
        GeometryTest.trace("- inCircle:     " + String.format("%26.18e", ra));
        GeometryTest.trace("- inCircleFast: " + String.format("%26.18e", rf));
        GeometryTest.assertTrue((ra < 0.0 ? 1 : 0) != 0);
    }

    public void testInSphere() {
        float xxxx = 1.0f;
        float yyyy = (float)Math.PI;
        float zzzz = 1000000.0f;
        float[] pa = new float[]{xxxx, 0.0f, 0.0f};
        float[] pb = new float[]{0.0f, yyyy, 0.0f};
        float[] pc = new float[]{0.0f, 0.0f, zzzz};
        float[] pd = new float[]{0.0f, 0.0f, 0.0f};
        float[] pe = new float[]{xxxx, yyyy, zzzz};
        GeometryTest.trace("");
        double ra = Geometry.inSphere(pa, pb, pc, pd, pe);
        double rf = Geometry.inSphereFast(pa, pb, pc, pd, pe);
        GeometryTest.trace("0 inSphere:     " + String.format("%26.18e", ra));
        GeometryTest.trace("0 inSphereFast: " + String.format("%26.18e", rf));
        GeometryTest.assertTrue((ra == 0.0 ? 1 : 0) != 0);
        pe[0] = xxxx * 0.9999999f;
        ra = Geometry.inSphere(pa, pb, pc, pd, pe);
        rf = Geometry.inSphereFast(pa, pb, pc, pd, pe);
        GeometryTest.trace("+ inSphere:     " + String.format("%26.18e", ra));
        GeometryTest.trace("+ inSphereFast: " + String.format("%26.18e", rf));
        GeometryTest.assertTrue((ra > 0.0 ? 1 : 0) != 0);
        pe[0] = xxxx * 1.0000001f;
        ra = Geometry.inSphere(pa, pb, pc, pd, pe);
        rf = Geometry.inSphereFast(pa, pb, pc, pd, pe);
        GeometryTest.trace("- inSphere:     " + String.format("%26.18e", ra));
        GeometryTest.trace("- inSphereFast: " + String.format("%26.18e", rf));
        GeometryTest.assertTrue((ra < 0.0 ? 1 : 0) != 0);
    }

    public void testLeftOfLine() {
        float xxxx = 2.0f;
        float yyyy = 1.0f;
        float aaaa = 1.0E15f;
        float[] pa = new float[]{1.0f * xxxx, 1.0f * yyyy};
        float[] pb = new float[]{2.0f * xxxx, 2.0f * yyyy};
        float[] pc = new float[]{aaaa * xxxx, aaaa * yyyy};
        GeometryTest.trace("");
        double ra = Geometry.leftOfLine(pa, pb, pc);
        double rf = Geometry.leftOfLineFast(pa, pb, pc);
        GeometryTest.trace("0 leftOfLine:     " + String.format("%26.18e", ra));
        GeometryTest.trace("0 leftOfLineFast: " + String.format("%26.18e", rf));
        GeometryTest.assertTrue((ra == 0.0 ? 1 : 0) != 0);
        pc[0] = aaaa * xxxx * 0.9999999f;
        ra = Geometry.leftOfLine(pa, pb, pc);
        rf = Geometry.leftOfLineFast(pa, pb, pc);
        GeometryTest.trace("+ leftOfLine:     " + String.format("%26.18e", ra));
        GeometryTest.trace("+ leftOfLineFast: " + String.format("%26.18e", rf));
        GeometryTest.assertTrue((ra > 0.0 ? 1 : 0) != 0);
        pc[0] = aaaa * xxxx * 1.0000001f;
        ra = Geometry.leftOfLine(pa, pb, pc);
        rf = Geometry.leftOfLineFast(pa, pb, pc);
        GeometryTest.trace("- leftOfLine:     " + String.format("%26.18e", ra));
        GeometryTest.trace("- leftOfLineFast: " + String.format("%26.18e", rf));
        GeometryTest.assertTrue((ra < 0.0 ? 1 : 0) != 0);
    }

    public void testLeftOfPlane() {
        float xxxx = 1.0f;
        float yyyy = 1.0f;
        float zzzz = 1.0E15f;
        float[] pa = new float[]{xxxx, 0.0f, 0.1f};
        float[] pb = new float[]{0.0f, yyyy, 3.3f};
        float[] pc = new float[]{0.0f, yyyy, 6.7f};
        float[] pd = new float[]{xxxx, 0.0f, zzzz};
        GeometryTest.trace("");
        double ra = Geometry.leftOfPlane(pa, pb, pc, pd);
        double rf = Geometry.leftOfPlaneFast(pa, pb, pc, pd);
        GeometryTest.trace("0 leftOfPlane:     " + String.format("%26.18e", ra));
        GeometryTest.trace("0 leftOfPlaneFast: " + String.format("%26.18e", rf));
        GeometryTest.assertTrue((ra == 0.0 ? 1 : 0) != 0);
        pd[0] = xxxx * 0.9999999f;
        ra = Geometry.leftOfPlane(pa, pb, pc, pd);
        rf = Geometry.leftOfPlaneFast(pa, pb, pc, pd);
        GeometryTest.trace("+ leftOfPlane:     " + String.format("%26.18e", ra));
        GeometryTest.trace("+ leftOfPlaneFast: " + String.format("%26.18e", rf));
        GeometryTest.assertTrue((ra > 0.0 ? 1 : 0) != 0);
        pd[0] = xxxx * 1.0000001f;
        ra = Geometry.leftOfPlane(pa, pb, pc, pd);
        rf = Geometry.leftOfPlaneFast(pa, pb, pc, pd);
        GeometryTest.trace("- leftOfPlane:     " + String.format("%26.18e", ra));
        GeometryTest.trace("- leftOfPlaneFast: " + String.format("%26.18e", rf));
        GeometryTest.assertTrue((ra < 0.0 ? 1 : 0) != 0);
    }

    public void testLeftOfPlaneSpecial() {
        double[] pa = new double[]{99.50000003392293, 125.85383672388726, 4.712236446160304};
        double[] pb = new double[]{91.50000003119546, 125.85383641401195, 4.712236443259705};
        double[] pc = new double[]{107.5000000366504, 125.85383703376256, 4.712236449060903};
        double[] pd = new double[]{27.50000030246409, 125.8538208916998, 122.28777353807229};
        double ra = Geometry.leftOfPlane(pa, pb, pc, pd);
        double rf = Geometry.leftOfPlaneFast(pa, pb, pc, pd);
        GeometryTest.assertTrue((ra == 0.0 ? 1 : 0) != 0);
        GeometryTest.assertTrue((rf != 0.0 ? 1 : 0) != 0);
    }

    public void testLeftOfPlaneSpecial2() {
        double[] pa = new double[]{111.50000056515266, 125.85385176546224, 4.712249324321081};
        double[] pb = new double[]{123.50000062597627, 125.8538522971668, 4.712249325708733};
        double[] pc = new double[]{105.50000053474086, 125.85385224976321, 4.712249323627476};
        double[] pd = new double[]{93.50000047391725, 125.85385171805865, 4.712249322239824};
        double ra = Geometry.leftOfPlane(pa, pb, pc, pd);
        double rf = Geometry.leftOfPlaneFast(pa, pb, pc, pd);
        GeometryTest.assertTrue((ra == 0.0 ? 1 : 0) != 0);
        GeometryTest.assertTrue((rf != 0.0 ? 1 : 0) != 0);
    }

    public void xtestInSphereSpeed() {
        float[] pa = new float[]{1.0f, 0.0f, 0.0f};
        float[] pb = new float[]{0.0f, 1.0f, 0.0f};
        float[] pc = new float[]{0.0f, 0.0f, 1.0f};
        float[] pd = new float[]{0.0f, 0.0f, 0.0f};
        float[] pe = new float[]{0.5f, 0.5f, 0.5f};
        float xa = pa[0];
        float ya = pa[1];
        float za = pa[2];
        float xb = pb[0];
        float yb = pb[1];
        float zb = pb[2];
        float xc = pc[0];
        float yc = pc[1];
        float zc = pc[2];
        float xd = pd[0];
        float yd = pd[1];
        float zd = pd[2];
        float xe = pe[0];
        float ye = pe[1];
        float ze = pe[2];
        GeometryTest.trace("");
        Stopwatch sw = new Stopwatch();
        int nsphere = 0;
        int niter = 100;
        double maxtime = 2.0;
        while (true) {
            int iter;
            sw.reset();
            sw.start();
            nsphere = 0;
            while (sw.time() < maxtime) {
                for (iter = 0; iter < niter; ++iter) {
                    Geometry.inSphere(xa, ya, za, xb, yb, zb, xc, yc, zc, xd, yd, zd, xe, ye, ze);
                }
                nsphere += niter;
            }
            sw.stop();
            GeometryTest.trace("inSphere:     sphere/s = " + (int)((double)nsphere / sw.time()));
            sw.reset();
            sw.start();
            nsphere = 0;
            while (sw.time() < maxtime) {
                for (iter = 0; iter < niter; ++iter) {
                    Geometry.inSphereFast(xa, ya, za, xb, yb, zb, xc, yc, zc, xd, yd, zd, xe, ye, ze);
                }
                nsphere += niter;
            }
            sw.stop();
            GeometryTest.trace("inSphereFast: sphere/s = " + (int)((double)nsphere / sw.time()));
            try {
                Thread.sleep(1000L, 0);
            }
            catch (InterruptedException e) {
            }
        }
    }

    public void xtestLeftOfPlaneSpeed() {
        int iter;
        float[] pa = new float[]{1.0f, 0.0f, 0.0f};
        float[] pb = new float[]{0.0f, 1.0f, 0.0f};
        float[] pc = new float[]{0.0f, 0.0f, 1.0f};
        float[] pd = new float[]{0.0f, 0.0f, 0.0f};
        float xa = pa[0];
        float ya = pa[1];
        float za = pa[2];
        float xb = pb[0];
        float yb = pb[1];
        float zb = pb[2];
        float xc = pc[0];
        float yc = pc[1];
        float zc = pc[2];
        float xd = pd[0];
        float yd = pd[1];
        float zd = pd[2];
        GeometryTest.trace("");
        Stopwatch sw = new Stopwatch();
        int nplane = 0;
        int niter = 100;
        double maxtime = 2.0;
        sw.reset();
        sw.start();
        nplane = 0;
        while (sw.time() < maxtime) {
            for (iter = 0; iter < niter; ++iter) {
                Geometry.leftOfPlane(xa, ya, za, xb, yb, zb, xc, yc, zc, xd, yd, zd);
            }
            nplane += niter;
        }
        sw.stop();
        GeometryTest.trace("leftOfPlane:     plane/s = " + (int)((double)nplane / sw.time()));
        sw.reset();
        sw.start();
        nplane = 0;
        while (sw.time() < maxtime) {
            for (iter = 0; iter < niter; ++iter) {
                Geometry.leftOfPlaneFast(xa, ya, za, xb, yb, zb, xc, yc, zc, xd, yd, zd);
            }
            nplane += niter;
        }
        sw.stop();
        GeometryTest.trace("leftOfPlaneFast: plane/s = " + (int)((double)nplane / sw.time()));
    }

    public void testCenterCircle3D() {
        double[] po = new double[]{0.0, 0.0, 0.0};
        Geometry.centerCircle3D(0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, po);
        GeometryTest.assertTrue((po[0] == 0.0 ? 1 : 0) != 0);
        GeometryTest.assertTrue((po[1] == 0.5 ? 1 : 0) != 0);
        GeometryTest.assertTrue((po[2] == 0.5 ? 1 : 0) != 0);
        Geometry.centerCircle3D(0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, po);
        GeometryTest.assertTrue((po[0] == 0.5 ? 1 : 0) != 0);
        GeometryTest.assertTrue((po[1] == 0.0 ? 1 : 0) != 0);
        GeometryTest.assertTrue((po[2] == 0.5 ? 1 : 0) != 0);
        Geometry.centerCircle3D(1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, po);
        GeometryTest.assertTrue((po[0] == 0.5 ? 1 : 0) != 0);
        GeometryTest.assertTrue((po[1] == 0.5 ? 1 : 0) != 0);
        GeometryTest.assertTrue((po[2] == 0.0 ? 1 : 0) != 0);
        Geometry.centerCircle3D(1.0, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 1.0, po);
        GeometryTest.assertTrue((po[0] == 1.0 ? 1 : 0) != 0);
        GeometryTest.assertTrue((po[1] == 0.5 ? 1 : 0) != 0);
        GeometryTest.assertTrue((po[2] == 0.5 ? 1 : 0) != 0);
        Geometry.centerCircle3D(0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, po);
        GeometryTest.assertTrue((po[0] == 0.5 ? 1 : 0) != 0);
        GeometryTest.assertTrue((po[1] == 1.0 ? 1 : 0) != 0);
        GeometryTest.assertTrue((po[2] == 0.5 ? 1 : 0) != 0);
        Geometry.centerCircle3D(1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 1.0, 1.0, po);
        GeometryTest.assertTrue((po[0] == 0.5 ? 1 : 0) != 0);
        GeometryTest.assertTrue((po[1] == 0.5 ? 1 : 0) != 0);
        GeometryTest.assertTrue((po[2] == 1.0 ? 1 : 0) != 0);
    }

    private static void trace(String s) {
    }
}

