/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mesh;

import edu.mines.jtk.mesh.Geometry;
import edu.mines.jtk.util.Check;
import edu.mines.jtk.util.MathPlus;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TetMesh
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int NODE_MARK_MAX = 0x7FFFFFFE;
    private static final int TET_MARK_MAX = 0x7FFFFFFE;
    private long _version;
    private int _nnode;
    private int _ntet;
    private Node _nroot = null;
    private Tet _troot = null;
    private HashSet<Node> _sampledNodes;
    private int _tetMarkRed;
    private int _tetMarkBlue;
    private int _nodeMarkRed;
    private int _nodeMarkBlue;
    private FaceSet _faceSet;
    private EdgeSet _edgeSet;
    private NodeList _nodeList;
    private Node _nmin;
    private double _dmin;
    private TetList _deadTets;
    private int _nnodeListeners;
    private int _ntetListeners;
    private EventListenerList _listeners;
    private boolean _outerEnabled;
    private double _xminOuter;
    private double _yminOuter;
    private double _zminOuter;
    private double _xmaxOuter;
    private double _ymaxOuter;
    private double _zmaxOuter;
    private int _nnodeValues;
    private int _lnodeValues;
    private Map<String, NodePropertyMap> _nodePropertyMaps;
    static final boolean DEBUG = false;
    static final boolean TRACE = false;

    public TetMesh() {
        this.init();
    }

    public int countNodes() {
        return this._nnode;
    }

    public int countTets() {
        return this._ntet;
    }

    public long getVersion() {
        return this._version;
    }

    public synchronized boolean addNode(Node node) {
        PointLocation pl = this.locatePoint(node._x, node._y, node._z);
        if (pl.isOnNode()) {
            return false;
        }
        this.fireNodeWillBeAdded(node);
        if (this._nroot == null) {
            this._nroot = node;
            this._nroot._prev = (this._nroot._next = this._nroot);
        } else {
            node._next = this._nroot;
            node._prev = this._nroot._prev;
            this._nroot._prev._next = node;
            this._nroot._prev = node;
            this._nroot = node;
        }
        ++this._nnode;
        this.updatePropertyValues(node);
        double factor = 0.5 * (double)this._sampledNodes.size();
        if (factor * factor * factor * factor < (double)this._nnode) {
            this._sampledNodes.add(node);
        }
        if (pl.isOutside() && this._nnode <= 4) {
            if (this._nnode == 4) {
                this.createFirstTet();
            }
        } else {
            this.clearTetMarks();
            this._faceSet.clear();
            if (pl.isInside()) {
                this.getDelaunayFacesInside(node, pl.tet());
            } else {
                this.getDelaunayFacesOutside(node, pl.tet());
            }
            this._edgeSet.clear();
            boolean more = this._faceSet.first();
            while (more) {
                Node a = this._faceSet.a;
                Node b = this._faceSet.b;
                Node c = this._faceSet.c;
                Node d = this._faceSet.d;
                Tet abcd = this._faceSet.abcd;
                Tet nabc = this.makeTet(node, a, b, c);
                this.linkTets(nabc, node, abcd, d);
                if (!this._edgeSet.add(a, b, c, nabc)) {
                    this.linkTets(this._edgeSet.nabc, this._edgeSet.c, nabc, c);
                }
                if (!this._edgeSet.add(b, c, a, nabc)) {
                    this.linkTets(this._edgeSet.nabc, this._edgeSet.c, nabc, a);
                }
                if (!this._edgeSet.add(c, a, b, nabc)) {
                    this.linkTets(this._edgeSet.nabc, this._edgeSet.c, nabc, b);
                }
                more = this._faceSet.next();
            }
        }
        this.fireNodeAdded(node);
        return true;
    }

    public synchronized boolean removeNode(Node node) {
        Tet tet = node._tet;
        if (tet == null) {
            return false;
        }
        this.fireNodeWillBeRemoved(node);
        this.unlinkNode(node);
        if (this._nnode < 4) {
            if (this._nnode == 3) {
                Node n0 = this._nroot;
                Node n1 = n0._next;
                Node n2 = n1._next;
                n0._tet = null;
                n1._tet = null;
                n2._tet = null;
                this.killTet(this._troot);
                this._troot = null;
            }
        } else {
            this._faceSet.clear();
            this._nodeList.clear();
            this.clearTetMarks();
            this.clearNodeMarks();
            this.getDelaunayFacesOpposite(node, tet);
            int nnode = this._nodeList.nnode();
            Node[] nodes = this._nodeList.nodes();
            boolean more = this._faceSet.remove();
            while (more) {
                Node a = this._faceSet.a;
                Node b = this._faceSet.b;
                Node c = this._faceSet.c;
                Node d = this._faceSet.d;
                Tet abcd = this._faceSet.abcd;
                Node n = null;
                for (int inode = 0; inode < nnode; ++inode) {
                    Node m = nodes[inode];
                    if (m == a || m == b || m == c || TetMesh.leftOfPlane(a, b, c, m) || n != null && !TetMesh.inSphere(n, a, b, c, m)) continue;
                    n = m;
                }
                if (n != null) {
                    Tet nabc = this.makeTet(n, a, b, c);
                    this.linkTets(nabc, n, abcd, d);
                    if (!this._faceSet.add(nabc, a)) {
                        this.linkTets(this._faceSet.abcd, this._faceSet.d, nabc, a);
                    }
                    if (!this._faceSet.add(nabc, b)) {
                        this.linkTets(this._faceSet.abcd, this._faceSet.d, nabc, b);
                    }
                    if (!this._faceSet.add(nabc, c)) {
                        this.linkTets(this._faceSet.abcd, this._faceSet.d, nabc, c);
                    }
                } else {
                    this.linkTets(abcd, d, null, null);
                    a._tet = abcd;
                    b._tet = abcd;
                    c._tet = abcd;
                    this._troot = abcd;
                }
                more = this._faceSet.remove();
            }
        }
        this.fireNodeRemoved(node);
        return true;
    }

    public synchronized boolean moveNode(Node node, float x, float y, float z) {
        Node nodeNearest;
        if (!(x == node.x() && y == node.y() && z == node.z() || node != (nodeNearest = this.findNodeNearest(x, y, z)) && x == nodeNearest.x() && y == nodeNearest.y() && z == nodeNearest.z())) {
            boolean nodeInMesh = this.removeNode(node);
            node.setPosition(x, y, z);
            if (nodeInMesh) {
                boolean addedNode = this.addNode(node);
                assert (addedNode);
            }
            return true;
        }
        return false;
    }

    public synchronized Node findNodeNearest(float x, float y, float z) {
        return this.findNodeNearest((double)x, (double)y, (double)z);
    }

    public synchronized Edge findEdge(Node na, Node nb) {
        Tet tet = this.findTet(na, nb);
        if (tet != null) {
            return TetMesh.edgeOfTet(tet, na, nb);
        }
        return null;
    }

    public synchronized Face findFace(Node na, Node nb, Node nc) {
        Tet tet = this.findTet(na, nb, nc);
        if (tet != null) {
            return TetMesh.faceOfTet(tet, na, nb, nc);
        }
        return null;
    }

    public Tet findTet(Node node) {
        return node._tet;
    }

    public synchronized Tet findTet(Node na, Node nb) {
        Tet tet = this.findTet(na);
        if (tet != null) {
            this.clearTetMarks();
            tet = this.findTet(tet, na, nb);
        }
        return tet;
    }

    public synchronized Tet findTet(Node na, Node nb, Node nc) {
        Tet tet = this.findTet(na, nb);
        if (tet != null) {
            this.clearTetMarks();
            tet = this.findTet(tet, na, nb, nc);
        }
        return tet;
    }

    public synchronized Tet findTet(Node na, Node nb, Node nc, Node nd) {
        Tet tet = this.findTet(na, nb, nc);
        if (tet != null) {
            this.clearTetMarks();
            tet = this.findTet(tet, na, nb, nc, nd);
        }
        return tet;
    }

    public synchronized PointLocation locatePoint(float x, float y, float z) {
        return this.locatePoint((double)x, (double)y, (double)z);
    }

    public synchronized NodeIterator getNodes() {
        return new NodeIterator(){
            private Node _nroot;
            private Node _nnext;
            {
                this._nnext = this._nroot = TetMesh.this._nroot;
            }

            public boolean hasNext() {
                return this._nnext != null;
            }

            public Node next() {
                if (this._nnext == null) {
                    throw new NoSuchElementException();
                }
                Node node = this._nnext;
                this._nnext = node._next;
                if (this._nnext == this._nroot) {
                    this._nnext = null;
                }
                return node;
            }
        };
    }

    public synchronized TetIterator getTets() {
        return new TetIterator(){
            private Iterator<Tet> _i;
            {
                TetIterator i = TetMesh.this.getTetsInternal();
                ArrayList<Tet> list = new ArrayList<Tet>(TetMesh.this._ntet);
                while (i.hasNext()) {
                    list.add(i.next());
                }
                this._i = list.iterator();
            }

            public final boolean hasNext() {
                return this._i.hasNext();
            }

            public final Tet next() {
                return this._i.next();
            }
        };
    }

    public synchronized EdgeIterator getEdges() {
        return new EdgeIterator(){
            private Iterator _i;
            {
                EdgeSet edgeSet = new EdgeSet(16 * TetMesh.this.countNodes(), 0.5);
                ArrayList<Edge> edgeList = new ArrayList<Edge>(8 * TetMesh.this.countNodes());
                NodeIterator inode = TetMesh.this.getNodes();
                while (inode.hasNext()) {
                    Node na = inode.next();
                    for (Node nb : TetMesh.this.getNodeNabors(na)) {
                        if (!edgeSet.add(na, nb, null, null)) continue;
                        Tet tet = TetMesh.this.findTet(na, nb);
                        Edge edge = new Edge(tet, na, nb);
                        edgeList.add(edge);
                    }
                }
                assert (edgeSet.size() == 0) : "edges matched, size=" + edgeSet.size();
                edgeList.trimToSize();
                this._i = edgeList.iterator();
            }

            public final boolean hasNext() {
                return this._i.hasNext();
            }

            public final Edge next() {
                return (Edge)this._i.next();
            }
        };
    }

    public synchronized TetIterator getTetsInPlane(final double a, final double b, final double c, final double d) {
        return new TetIterator(){
            private Tet _tnext = null;
            private ArrayList<Tet> _tets = new ArrayList(128);
            {
                this._tnext = TetMesh.this.findTetInPlane(a, b, c, d);
                if (this._tnext != null) {
                    TetMesh.this.clearTetMarks();
                    TetMesh.this.mark(this._tnext);
                }
            }

            public final boolean hasNext() {
                return this._tnext != null;
            }

            public final Tet next() {
                if (this._tnext == null) {
                    throw new NoSuchElementException();
                }
                Tet tet = this._tnext;
                this.addTet(tet._t0);
                this.addTet(tet._t1);
                this.addTet(tet._t2);
                this.addTet(tet._t3);
                int ntet = this._tets.size();
                this._tnext = ntet == 0 ? null : this._tets.remove(ntet - 1);
                return tet;
            }

            private final void addTet(Tet tet) {
                if (tet != null && !TetMesh.this.isMarked(tet)) {
                    TetMesh.this.mark(tet);
                    if (tet.intersectsPlane(a, b, c, d)) {
                        this._tets.add(tet);
                    }
                }
            }
        };
    }

    public synchronized NodeIterator getNodesNearestPlane(final double a, final double b, final double c, final double d) {
        return new NodeIterator(){
            private Iterator _iterator = null;
            {
                Node node = TetMesh.this.findNodeNearestPlane(a, b, c, d);
                Tet[] tets = TetMesh.this.getTetNabors(node);
                ArrayList<Tet> tetStack = new ArrayList<Tet>(512);
                int ntet = tets.length;
                for (int itet = 0; itet < ntet; ++itet) {
                    tetStack.add(tets[itet]);
                }
                TetMesh.this.clearNodeMarks();
                TetMesh.this.clearTetMarks();
                ArrayList<Node> nodeList = new ArrayList<Node>(512);
                nodeList.add(node);
                TetMesh.this.mark(node);
                while (!tetStack.isEmpty()) {
                    Tet tet = (Tet)tetStack.remove(tetStack.size() - 1);
                    TetMesh.this.mark(tet);
                    Node n0 = tet._n0;
                    Node n1 = tet._n1;
                    Node n2 = tet._n2;
                    Node n3 = tet._n3;
                    boolean m0 = TetMesh.this.isMarked(n0);
                    boolean m1 = TetMesh.this.isMarked(n1);
                    boolean m2 = TetMesh.this.isMarked(n2);
                    boolean m3 = TetMesh.this.isMarked(n3);
                    if (m0 && m1 && m2 && m3) continue;
                    double x0 = n0._x;
                    double y0 = n0._y;
                    double z0 = n0._z;
                    double x1 = n1._x;
                    double y1 = n1._y;
                    double z1 = n1._z;
                    double x2 = n2._x;
                    double y2 = n2._y;
                    double z2 = n2._z;
                    double x3 = n3._x;
                    double y3 = n3._y;
                    double z3 = n3._z;
                    double[] po = new double[3];
                    Geometry.centerSphere(x0, y0, z0, x1, y1, z1, x2, y2, z2, x3, y3, z3, po);
                    double xo = po[0];
                    double yo = po[1];
                    double zo = po[2];
                    double so = a * xo + b * yo + c * zo + d;
                    double s0 = a * x0 + b * y0 + c * z0 + d;
                    double s1 = a * x1 + b * y1 + c * z1 + d;
                    double s2 = a * x2 + b * y2 + c * z2 + d;
                    double s3 = a * x3 + b * y3 + c * z3 + d;
                    boolean intersects = false;
                    if (so * s0 <= 0.0) {
                        intersects = true;
                        if (!m0) {
                            nodeList.add(n0);
                            TetMesh.this.mark(n0);
                        }
                    }
                    if (so * s1 <= 0.0) {
                        intersects = true;
                        if (!m1) {
                            nodeList.add(n1);
                            TetMesh.this.mark(n1);
                        }
                    }
                    if (so * s2 <= 0.0) {
                        intersects = true;
                        if (!m2) {
                            nodeList.add(n2);
                            TetMesh.this.mark(n2);
                        }
                    }
                    if (so * s3 <= 0.0) {
                        intersects = true;
                        if (!m3) {
                            nodeList.add(n3);
                            TetMesh.this.mark(n3);
                        }
                    }
                    if (!intersects) continue;
                    Tet t0 = tet._t0;
                    Tet t1 = tet._t1;
                    Tet t2 = tet._t2;
                    Tet t3 = tet._t3;
                    if (t0 != null && !TetMesh.this.isMarked(t0)) {
                        tetStack.add(t0);
                    }
                    if (t1 != null && !TetMesh.this.isMarked(t1)) {
                        tetStack.add(t1);
                    }
                    if (t2 != null && !TetMesh.this.isMarked(t2)) {
                        tetStack.add(t2);
                    }
                    if (t3 == null || TetMesh.this.isMarked(t3)) continue;
                    tetStack.add(t3);
                }
                this._iterator = nodeList.iterator();
            }

            public final boolean hasNext() {
                return this._iterator.hasNext();
            }

            public final Node next() {
                return (Node)this._iterator.next();
            }
        };
    }

    public Tet findTetInPlane(double a, double b, double c, double d) {
        Node node = this.findNodeNearestPlane(a, b, c, d);
        Tet[] tet = this.getTetNabors(node);
        for (int i = 0; i < tet.length; ++i) {
            if (!tet[i].intersectsPlane(a, b, c, d)) continue;
            return tet[i];
        }
        return null;
    }

    public synchronized FaceIterator getFacesOnHull() {
        this.clearTetMarks();
        Face face = this.getFaceOnHull(this._troot);
        final HashSet<Face> faces = new HashSet<Face>(128);
        this.getFacesOnHull(face, faces);
        return new FaceIterator(){
            private Iterator<Face> i;
            {
                this.i = faces.iterator();
            }

            public final boolean hasNext() {
                return this.i.hasNext();
            }

            public final Face next() {
                return this.i.next();
            }
        };
    }

    public synchronized Node[] getNodeNabors(Node node) {
        NodeList nabors = new NodeList();
        this.getNodeNabors(node, nabors);
        return nabors.trim();
    }

    public synchronized void getNodeNabors(Node node, NodeList nabors) {
        Tet tet = node._tet;
        if (tet == null) {
            return;
        }
        this.clearNodeMarks();
        this.clearTetMarks();
        this.getNodeNabors(node, tet, nabors);
    }

    public synchronized NodeStepList getNodeNabors(Node node, int stepMax) {
        Check.argument(stepMax <= 256, "stepMax <= 256");
        this.clearNodeMarks();
        this.mark(node);
        NodeStepList list = new NodeStepList();
        int nnabor1 = 0;
        for (int step = 1; step <= stepMax; ++step) {
            if (step == 1) {
                this.getNodeNabors(node, step, list);
                continue;
            }
            int nnabor2 = list.nnode();
            Node[] naborNodes = list.nodes();
            for (int inabor = nnabor1; inabor < nnabor2; ++inabor) {
                node = naborNodes[inabor];
                this.getNodeNabors(node, step, list);
            }
            nnabor1 = nnabor2;
        }
        return list;
    }

    public synchronized Tet[] getTetNabors(Node node) {
        TetList nabors = new TetList();
        this.getTetNabors(node, nabors);
        return nabors.trim();
    }

    public synchronized void getTetNabors(Node node, TetList nabors) {
        this.clearTetMarks();
        this.getTetNabors(node, node._tet, nabors);
    }

    public synchronized Tet[] getTetNabors(Edge edge) {
        TetList nabors = new TetList();
        this.getTetNabors(edge, nabors);
        return nabors.trim();
    }

    public synchronized void getTetNabors(Edge edge, TetList nabors) {
        Node na = edge.nodeA();
        Node nb = edge.nodeB();
        Tet tet = edge.tet();
        if (tet == null) {
            tet = this.findTet(na, nb);
        }
        if (tet == null) {
            return;
        }
        this.clearTetMarks();
        this.getTetNabors(na, nb, tet, nabors);
    }

    public synchronized Tet[] getTetNabors(Face face) {
        TetList nabors = new TetList();
        this.getTetNabors(face, nabors);
        return nabors.trim();
    }

    public synchronized void getTetNabors(Face face, TetList nabors) {
        Tet tetLeft = face.tetLeft();
        Tet tetRight = face.tetRight();
        if (tetLeft == null && tetRight == null) {
            Node na = face.nodeA();
            Node nb = face.nodeB();
            Node nc = face.nodeC();
            face = this.findFace(na, nb, nc);
            tetLeft = face.tetLeft();
            tetRight = face.tetRight();
        }
        if (tetLeft != null) {
            nabors.add(tetLeft);
        }
        if (tetRight != null) {
            nabors.add(tetRight);
        }
    }

    public synchronized Edge[] getEdgeNabors(Node node) {
        EdgeList nabors = new EdgeList();
        this.getEdgeNabors(node, nabors);
        return nabors.trim();
    }

    public synchronized void getEdgeNabors(Node node, EdgeList nabors) {
        Tet[] tets = this.getTetNabors(node);
        int ntet = tets.length;
        this.clearNodeMarks();
        for (int itet = 0; itet < ntet; ++itet) {
            Tet tet = tets[itet];
            Node n0 = tet._n0;
            Node n1 = tet._n1;
            Node n2 = tet._n2;
            Node n3 = tet._n3;
            if (node == n0) {
                if (!this.isMarked(n1)) {
                    this.mark(n1);
                    nabors.add(new Edge(tet, n1, node));
                }
                if (!this.isMarked(n2)) {
                    this.mark(n2);
                    nabors.add(new Edge(tet, n2, node));
                }
                if (this.isMarked(n3)) continue;
                this.mark(n3);
                nabors.add(new Edge(tet, n3, node));
                continue;
            }
            if (node == n1) {
                if (!this.isMarked(n0)) {
                    this.mark(n0);
                    nabors.add(new Edge(tet, n0, node));
                }
                if (!this.isMarked(n2)) {
                    this.mark(n2);
                    nabors.add(new Edge(tet, n2, node));
                }
                if (this.isMarked(n3)) continue;
                this.mark(n3);
                nabors.add(new Edge(tet, n3, node));
                continue;
            }
            if (node == n2) {
                if (!this.isMarked(n0)) {
                    this.mark(n0);
                    nabors.add(new Edge(tet, n0, node));
                }
                if (!this.isMarked(n1)) {
                    this.mark(n1);
                    nabors.add(new Edge(tet, n1, node));
                }
                if (this.isMarked(n3)) continue;
                this.mark(n3);
                nabors.add(new Edge(tet, n3, node));
                continue;
            }
            if (node != n3) continue;
            if (!this.isMarked(n0)) {
                this.mark(n0);
                nabors.add(new Edge(tet, n0, node));
            }
            if (!this.isMarked(n1)) {
                this.mark(n1);
                nabors.add(new Edge(tet, n1, node));
            }
            if (this.isMarked(n2)) continue;
            this.mark(n2);
            nabors.add(new Edge(tet, n2, node));
        }
    }

    public synchronized Face[] getFaceNabors(Edge edge) {
        FaceList nabors = new FaceList();
        this.getFaceNabors(edge, nabors);
        return nabors.trim();
    }

    public synchronized void getFaceNabors(Edge edge, FaceList nabors) {
        Node ea = edge.nodeA();
        Node eb = edge.nodeB();
        Tet tet = edge.tet();
        if (tet == null) {
            tet = this.findTet(ea, eb);
        }
        if (tet == null) {
            return;
        }
        Node ta = tet.nodeA();
        Node tb = tet.nodeB();
        Node tc = tet.nodeC();
        Node td = tet.nodeD();
        Face face = null;
        if (ea == ta && eb == tb || ea == tb && eb == tc || ea == tc && eb == ta) {
            face = new Face(ta, tb, tc, tet);
        } else if (ea == tb && eb == td || ea == td && eb == tc || ea == tc && eb == tb) {
            face = new Face(tb, td, tc, tet);
        } else if (ea == tc && eb == td || ea == td && eb == ta || ea == ta && eb == tc) {
            face = new Face(tc, td, ta, tet);
        } else if (ea == td && eb == tb || ea == tb && eb == ta || ea == ta && eb == td) {
            face = new Face(td, tb, ta, tet);
        } else assert (false) : "tet references edge";
        Face firstFace = face;
        do {
            nabors.add(face);
            Node fa = face.nodeA();
            Node fb = face.nodeB();
            Node fc = face.nodeC();
            Node node = null;
            if (ea == fa && eb == fb) {
                node = fc;
            } else if (ea == fb && eb == fc) {
                node = fa;
            } else if (ea == fc && eb == fa) {
                node = fb;
            } else assert (false) : "edge is aligned with face";
            tet = face.tetRight();
            if (tet == null) {
                tet = face.tetLeft();
                Node nodeBack = face.nodeLeft();
                Tet tetBack = tet.tetNabor(node);
                while (tetBack != null) {
                    node = nodeBack;
                    nodeBack = tet.nodeNabor(tetBack);
                    tet = tetBack;
                    tetBack = tet.tetNabor(node);
                }
                face = new Face(null, null, tet, node);
                continue;
            }
            face = new Face(tet, node);
        } while (!face.equals(firstFace));
    }

    public synchronized void setOuterBox(float xmin, float ymin, float zmin, float xmax, float ymax, float zmax) {
        Check.argument(xmin < xmax, "outer box is valid");
        Check.argument(ymin < ymax, "outer box is valid");
        Check.argument(zmin < zmax, "outer box is valid");
        if ((double)xmin != this._xminOuter || (double)xmax != this._xmaxOuter || (double)ymin != this._yminOuter || (double)ymax != this._ymaxOuter || (double)zmin != this._zminOuter || (double)zmax != this._zmaxOuter) {
            this._xminOuter = xmin;
            this._yminOuter = ymin;
            this._zminOuter = zmin;
            this._xmaxOuter = xmax;
            this._ymaxOuter = ymax;
            this._zmaxOuter = zmax;
            TetIterator ti = this.getTets();
            while (ti.hasNext()) {
                Tet tet = ti.next();
                tet.clearInner();
                tet.clearOuter();
            }
        }
        ++this._version;
        this._outerEnabled = true;
    }

    public void enableOuterBox() {
        ++this._version;
        this._outerEnabled = true;
    }

    public void disableOuterBox() {
        ++this._version;
        this._outerEnabled = false;
    }

    public boolean isInner(Node node) {
        Tet tet = node.tet();
        if (tet == null || this.isInner(tet)) {
            return true;
        }
        Tet[] tets = this.getTetNabors(node);
        int ntet = tets.length;
        for (int itet = 0; itet < ntet; ++itet) {
            if (!this.isInner(tets[itet])) continue;
            return true;
        }
        return false;
    }

    public boolean isOuter(Node node) {
        return !this.isInner(node);
    }

    public boolean isInner(Tet tet) {
        if (!this._outerEnabled) {
            return true;
        }
        if (!tet.isInner() && !tet.isOuter()) {
            this.markTetInnerOrOuter(tet);
        }
        return tet.isInner();
    }

    public boolean isOuter(Tet tet) {
        return !this.isInner(tet);
    }

    public boolean isInner(Edge edge) {
        Tet tet = edge.tet();
        if (tet == null) {
            tet = this.findTet(edge.nodeA(), edge.nodeB());
        }
        if (tet == null) {
            return false;
        }
        if (tet.isInner()) {
            return true;
        }
        Tet[] tets = this.getTetNabors(edge);
        int ntet = tets.length;
        for (int itet = 0; itet < ntet; ++itet) {
            if (!this.isInner(tets[itet])) continue;
            return true;
        }
        return false;
    }

    public boolean isOuter(Edge edge) {
        return !this.isInner(edge);
    }

    public boolean isInner(Face face) {
        Tet tetLeft = face.tetLeft();
        if (tetLeft != null && this.isInner(tetLeft)) {
            return true;
        }
        Tet tetRight = face.tetRight();
        return tetRight != null && this.isInner(tetRight);
    }

    public boolean isOuter(Face face) {
        return !this.isInner(face);
    }

    public final void mark(Node node) {
        node._mark = this._nodeMarkRed;
    }

    public final void markRed(Node node) {
        node._mark = this._nodeMarkRed;
    }

    public final void markBlue(Node node) {
        node._mark = this._nodeMarkBlue;
    }

    public final void unmark(Node node) {
        node._mark = this._nodeMarkRed - 1;
    }

    public final boolean isMarked(Node node) {
        return node._mark == this._nodeMarkRed;
    }

    public final boolean isMarkedRed(Node node) {
        return node._mark == this._nodeMarkRed;
    }

    public final boolean isMarkedBlue(Node node) {
        return node._mark == this._nodeMarkBlue;
    }

    public synchronized void clearNodeMarks() {
        if (this._nodeMarkRed == 0x7FFFFFFE) {
            Node node = this._nroot;
            do {
                node._mark = 0;
            } while ((node = node._next) != this._nroot);
            this._nodeMarkRed = 0;
            this._nodeMarkBlue = 0;
        }
        ++this._nodeMarkRed;
        --this._nodeMarkBlue;
    }

    public final void mark(Tet tet) {
        tet._mark = this._tetMarkRed;
    }

    public final void markRed(Tet tet) {
        tet._mark = this._tetMarkRed;
    }

    public final void markBlue(Tet tet) {
        tet._mark = this._tetMarkBlue;
    }

    public final void unmark(Tet tet) {
        tet._mark = this._tetMarkRed - 1;
    }

    public final boolean isMarked(Tet tet) {
        return tet._mark == this._tetMarkRed;
    }

    public final boolean isMarkedRed(Tet tet) {
        return tet._mark == this._tetMarkRed;
    }

    public final boolean isMarkedBlue(Tet tet) {
        return tet._mark == this._tetMarkBlue;
    }

    public synchronized void clearTetMarks() {
        if (this._tetMarkRed == 0x7FFFFFFE) {
            ++this._tetMarkRed;
            --this._tetMarkBlue;
            this.markAllTets(this._troot);
            this.zeroTetMarks(this._troot);
            this._tetMarkRed = 0;
            this._tetMarkBlue = 0;
        }
        ++this._tetMarkRed;
        --this._tetMarkBlue;
    }

    public synchronized NodePropertyMap getNodePropertyMap(String name) {
        NodePropertyMap map = this._nodePropertyMaps.get(name);
        if (map == null) {
            if (this._nnodeValues == this._lnodeValues) {
                this._lnodeValues = this._lnodeValues == 0 ? 4 : (this._lnodeValues *= 2);
                NodeIterator ni = this.getNodes();
                while (ni.hasNext()) {
                    Node node = ni.next();
                    Object[] valuesOld = node._values;
                    Object[] valuesNew = new Object[this._lnodeValues];
                    for (int i = 0; i < this._nnodeValues; ++i) {
                        valuesNew[i] = valuesOld[i];
                    }
                    Node.access$3502(node, valuesNew);
                }
            }
            int index = this._nnodeValues++;
            map = new NodePropertyMapInternal(index);
            this._nodePropertyMaps.put(name, map);
        }
        return map;
    }

    public synchronized boolean hasNodePropertyMap(String name) {
        return this._nodePropertyMaps.containsKey(name);
    }

    public synchronized String[] getNodePropertyMapNames() {
        Set<String> nameSet = this._nodePropertyMaps.keySet();
        String[] names = new String[nameSet.size()];
        return nameSet.toArray(names);
    }

    public synchronized void addNodeListener(NodeListener nl) {
        this._listeners.add(NodeListener.class, nl);
        ++this._nnodeListeners;
    }

    public synchronized void removeNodeListener(NodeListener nl) {
        this._listeners.remove(NodeListener.class, nl);
        --this._nnodeListeners;
    }

    public synchronized void addTetListener(TetListener tl) {
        this._listeners.add(TetListener.class, tl);
        ++this._ntetListeners;
    }

    public synchronized void removeTetListener(TetListener tl) {
        this._listeners.remove(TetListener.class, tl);
        --this._ntetListeners;
    }

    public synchronized void validate() {
        int nnode = 0;
        NodeIterator ni = this.getNodes();
        while (ni.hasNext()) {
            ++nnode;
            Node node = ni.next();
            this.validate(node);
        }
        Check.state(nnode == this._nnode, "nnode==_nnode");
        int ntet = 0;
        TetIterator ti = this.getTets();
        while (ti.hasNext()) {
            ++ntet;
            Tet tet = ti.next();
            this.validate(tet);
        }
        Check.state(ntet == this._ntet, "ntet==_ntet");
    }

    protected void init() {
        this._version = 0L;
        this._nnode = 0;
        this._ntet = 0;
        this._nroot = null;
        this._troot = null;
        this._sampledNodes = new HashSet(256);
        this._tetMarkRed = 0;
        this._tetMarkBlue = 0;
        this._nodeMarkRed = 0;
        this._nodeMarkBlue = 0;
        this._faceSet = new FaceSet(256, 0.25);
        this._edgeSet = new EdgeSet(256, 0.25);
        this._nodeList = new NodeList();
        this._nmin = null;
        this._dmin = 0.0;
        this._deadTets = new TetList();
        this._nnodeListeners = 0;
        this._ntetListeners = 0;
        this._listeners = new EventListenerList();
        this._outerEnabled = false;
        this._xminOuter = 0.0;
        this._yminOuter = 0.0;
        this._zminOuter = 0.0;
        this._xmaxOuter = 0.0;
        this._ymaxOuter = 0.0;
        this._zmaxOuter = 0.0;
        this._nnodeValues = 0;
        this._lnodeValues = 0;
        this._nodePropertyMaps = new HashMap<String, NodePropertyMap>();
    }

    private synchronized void updatePropertyValues(Node node) {
        if (this._lnodeValues == 0) {
            Node.access$3502(node, null);
        } else if (node._values == null) {
            Node.access$3502(node, new Object[this._lnodeValues]);
        } else if (node._values.length != this._lnodeValues) {
            Object[] valuesOld = node._values;
            Object[] valuesNew = new Object[this._lnodeValues];
            int n = MathPlus.min(valuesOld.length, valuesNew.length);
            for (int i = 0; i < n; ++i) {
                valuesNew[i] = valuesOld[i];
            }
            Node.access$3502(node, valuesNew);
        }
    }

    private TetIterator getTetsInternal() {
        return new TetIterator(){
            private ArrayList<Tet> _stack = new ArrayList(128);
            {
                TetMesh.this.clearTetMarks();
                this.stackTet(TetMesh.this._troot);
            }

            public final boolean hasNext() {
                return !this._stack.isEmpty();
            }

            public final Tet next() {
                int ntet = this._stack.size();
                if (ntet == 0) {
                    throw new NoSuchElementException();
                }
                Tet tet = this._stack.remove(ntet - 1);
                this.stackTet(tet._t0);
                this.stackTet(tet._t1);
                this.stackTet(tet._t2);
                this.stackTet(tet._t3);
                return tet;
            }

            private final void stackTet(Tet tet) {
                if (tet != null && !TetMesh.this.isMarked(tet)) {
                    TetMesh.this.mark(tet);
                    this._stack.add(tet);
                }
            }
        };
    }

    private final Tet makeTet(Node n0, Node n1, Node n2, Node n3) {
        ++this._ntet;
        int ndead = this._deadTets.ntet();
        if (ndead == 0) {
            this._troot = new Tet(n0, n1, n2, n3);
        } else {
            this._troot = this._deadTets.remove(ndead - 1);
            this._troot.init(n0, n1, n2, n3);
        }
        if (this._ntetListeners > 0) {
            this.fireTetAdded(this._troot);
        }
        return this._troot;
    }

    private final void killTet(Tet tet) {
        --this._ntet;
        this.fireTetRemoved(tet);
        int ndead = this._deadTets.ntet();
        if (ndead < 256) {
            this._deadTets.add(tet);
        }
    }

    private void unlinkNode(Node node) {
        this._nroot = node._next;
        this._nmin = node._next;
        if (this._nroot == node) {
            this._nroot = null;
            this._nmin = null;
        }
        node._prev._next = node._next;
        node._next._prev = node._prev;
        node._prev = null;
        node._next = null;
        node._tet = null;
        this._sampledNodes.remove(node);
        --this._nnode;
    }

    private static final double distanceSquared(Node node, double x, double y, double z) {
        double dx = x - node._x;
        double dy = y - node._y;
        double dz = z - node._z;
        return dx * dx + dy * dy + dz * dz;
    }

    private static final double distanceToPlaneSquared(Node node, double a, double b, double c, double d) {
        double dp = a * node._x + b * node._y + c * node._z + d;
        return dp * dp;
    }

    private static final boolean leftOfPlane(Node a, Node b, Node c, Node n) {
        return Geometry.leftOfPlane(a._x, a._y, a._z, b._x, b._y, b._z, c._x, c._y, c._z, n._x, n._y, n._z) > 0.0;
    }

    private static final boolean leftOfPlane(Node a, Node b, Node c, double x, double y, double z) {
        return Geometry.leftOfPlane(a._x, a._y, a._z, b._x, b._y, b._z, c._x, c._y, c._z, x, y, z) > 0.0;
    }

    private static final boolean inSphere(Node a, Node b, Node c, Node d, Node n) {
        return Geometry.inSphere(a._x, a._y, a._z, b._x, b._y, b._z, c._x, c._y, c._z, d._x, d._y, d._z, n._x, n._y, n._z) > 0.0;
    }

    private static final boolean inSphere(Node a, Node b, Node c, Node d, double x, double y, double z) {
        return Geometry.inSphere(a._x, a._y, a._z, b._x, b._y, b._z, c._x, c._y, c._z, d._x, d._y, d._z, x, y, z) > 0.0;
    }

    private void createFirstTet() {
        Check.state(this._nnode == 4, "exactly four nodes available for first tet");
        Node n0 = this._nroot;
        Node n1 = n0._next;
        Node n2 = n1._next;
        Node n3 = n2._next;
        double orient = Geometry.leftOfPlane(n0._x, n0._y, n0._z, n1._x, n1._y, n1._z, n2._x, n2._y, n2._z, n3._x, n3._y, n3._z);
        if (orient == 0.0) {
            TetMesh.trace("orient=" + orient);
            TetMesh.trace("n0=(" + n0._x + "," + n0._y + "," + n0._z + ")");
            TetMesh.trace("n1=(" + n1._x + "," + n1._y + "," + n1._z + ")");
            TetMesh.trace("n2=(" + n2._x + "," + n2._y + "," + n2._z + ")");
            TetMesh.trace("n3=(" + n3._x + "," + n3._y + "," + n3._z + ")");
        }
        Check.state(orient != 0.0, "four nodes for first tet are not co-planar");
        if (orient > 0.0) {
            this.makeTet(n0, n1, n2, n3);
        } else {
            this.makeTet(n0, n2, n1, n3);
        }
    }

    private void getNodeNabors(Node node, Tet tet, NodeList nabors) {
        this.mark(tet);
        Node n0 = tet._n0;
        Node n1 = tet._n1;
        Node n2 = tet._n2;
        Node n3 = tet._n3;
        Tet t0 = tet._t0;
        Tet t1 = tet._t1;
        Tet t2 = tet._t2;
        Tet t3 = tet._t3;
        if (node == n0) {
            if (!this.isMarked(n1)) {
                this.mark(n1);
                nabors.add(n1);
            }
            if (!this.isMarked(n2)) {
                this.mark(n2);
                nabors.add(n2);
            }
            if (!this.isMarked(n3)) {
                this.mark(n3);
                nabors.add(n3);
            }
            if (t1 != null && !this.isMarked(t1)) {
                this.getNodeNabors(node, t1, nabors);
            }
            if (t2 != null && !this.isMarked(t2)) {
                this.getNodeNabors(node, t2, nabors);
            }
            if (t3 != null && !this.isMarked(t3)) {
                this.getNodeNabors(node, t3, nabors);
            }
        } else if (node == n1) {
            if (!this.isMarked(n3)) {
                this.mark(n3);
                nabors.add(n3);
            }
            if (!this.isMarked(n2)) {
                this.mark(n2);
                nabors.add(n2);
            }
            if (!this.isMarked(n0)) {
                this.mark(n0);
                nabors.add(n0);
            }
            if (t3 != null && !this.isMarked(t3)) {
                this.getNodeNabors(node, t3, nabors);
            }
            if (t2 != null && !this.isMarked(t2)) {
                this.getNodeNabors(node, t2, nabors);
            }
            if (t0 != null && !this.isMarked(t0)) {
                this.getNodeNabors(node, t0, nabors);
            }
        } else if (node == n2) {
            if (!this.isMarked(n3)) {
                this.mark(n3);
                nabors.add(n3);
            }
            if (!this.isMarked(n0)) {
                this.mark(n0);
                nabors.add(n0);
            }
            if (!this.isMarked(n1)) {
                this.mark(n1);
                nabors.add(n1);
            }
            if (t3 != null && !this.isMarked(t3)) {
                this.getNodeNabors(node, t3, nabors);
            }
            if (t0 != null && !this.isMarked(t0)) {
                this.getNodeNabors(node, t0, nabors);
            }
            if (t1 != null && !this.isMarked(t1)) {
                this.getNodeNabors(node, t1, nabors);
            }
        } else if (node == n3) {
            if (!this.isMarked(n1)) {
                this.mark(n1);
                nabors.add(n1);
            }
            if (!this.isMarked(n0)) {
                this.mark(n0);
                nabors.add(n0);
            }
            if (!this.isMarked(n2)) {
                this.mark(n2);
                nabors.add(n2);
            }
            if (t1 != null && !this.isMarked(t1)) {
                this.getNodeNabors(node, t1, nabors);
            }
            if (t0 != null && !this.isMarked(t0)) {
                this.getNodeNabors(node, t0, nabors);
            }
            if (t2 != null && !this.isMarked(t2)) {
                this.getNodeNabors(node, t2, nabors);
            }
        } else assert (false) : "node is referenced by tet";
    }

    private void getNodeNabors(Node node, int step, NodeStepList list) {
        for (Tet tet : this.getTetNabors(node)) {
            Node n0 = tet._n0;
            Node n1 = tet._n1;
            Node n2 = tet._n2;
            Node n3 = tet._n3;
            if (node == n0) {
                if (!this.isMarked(n1)) {
                    this.mark(n1);
                    list.add(n1, step);
                }
                if (!this.isMarked(n2)) {
                    this.mark(n2);
                    list.add(n2, step);
                }
                if (this.isMarked(n3)) continue;
                this.mark(n3);
                list.add(n3, step);
                continue;
            }
            if (node == n1) {
                if (!this.isMarked(n0)) {
                    this.mark(n0);
                    list.add(n0, step);
                }
                if (!this.isMarked(n2)) {
                    this.mark(n2);
                    list.add(n2, step);
                }
                if (this.isMarked(n3)) continue;
                this.mark(n3);
                list.add(n3, step);
                continue;
            }
            if (node == n2) {
                if (!this.isMarked(n0)) {
                    this.mark(n0);
                    list.add(n0, step);
                }
                if (!this.isMarked(n1)) {
                    this.mark(n1);
                    list.add(n1, step);
                }
                if (this.isMarked(n3)) continue;
                this.mark(n3);
                list.add(n3, step);
                continue;
            }
            if (node != n3) continue;
            if (!this.isMarked(n0)) {
                this.mark(n0);
                list.add(n0, step);
            }
            if (!this.isMarked(n1)) {
                this.mark(n1);
                list.add(n1, step);
            }
            if (this.isMarked(n2)) continue;
            this.mark(n2);
            list.add(n2, step);
        }
    }

    private void getTetNabors(Node node, Tet tet, TetList nabors) {
        if (tet != null) {
            this.mark(tet);
            nabors.add(tet);
            Node n0 = tet._n0;
            Node n1 = tet._n1;
            Node n2 = tet._n2;
            Node n3 = tet._n3;
            Tet t0 = tet._t0;
            Tet t1 = tet._t1;
            Tet t2 = tet._t2;
            Tet t3 = tet._t3;
            if (node == n0) {
                if (t1 != null && !this.isMarked(t1)) {
                    this.getTetNabors(node, t1, nabors);
                }
                if (t2 != null && !this.isMarked(t2)) {
                    this.getTetNabors(node, t2, nabors);
                }
                if (t3 != null && !this.isMarked(t3)) {
                    this.getTetNabors(node, t3, nabors);
                }
            } else if (node == n1) {
                if (t3 != null && !this.isMarked(t3)) {
                    this.getTetNabors(node, t3, nabors);
                }
                if (t2 != null && !this.isMarked(t2)) {
                    this.getTetNabors(node, t2, nabors);
                }
                if (t0 != null && !this.isMarked(t0)) {
                    this.getTetNabors(node, t0, nabors);
                }
            } else if (node == n2) {
                if (t3 != null && !this.isMarked(t3)) {
                    this.getTetNabors(node, t3, nabors);
                }
                if (t0 != null && !this.isMarked(t0)) {
                    this.getTetNabors(node, t0, nabors);
                }
                if (t1 != null && !this.isMarked(t1)) {
                    this.getTetNabors(node, t1, nabors);
                }
            } else if (node == n3) {
                if (t1 != null && !this.isMarked(t1)) {
                    this.getTetNabors(node, t1, nabors);
                }
                if (t0 != null && !this.isMarked(t0)) {
                    this.getTetNabors(node, t0, nabors);
                }
                if (t2 != null && !this.isMarked(t2)) {
                    this.getTetNabors(node, t2, nabors);
                }
            } else assert (false) : "node is referenced by tet";
        }
    }

    private void getTetNabors(Node na, Node nb, Tet tet, TetList nabors) {
        if (tet != null) {
            this.mark(tet);
            nabors.add(tet);
            Node n0 = tet._n0;
            Node n1 = tet._n1;
            Node n2 = tet._n2;
            Node n3 = tet._n3;
            Tet t0 = tet._t0;
            Tet t1 = tet._t1;
            Tet t2 = tet._t2;
            Tet t3 = tet._t3;
            Tet tc = null;
            Tet td = null;
            if (na == n0) {
                if (nb == n1) {
                    tc = t2;
                    td = t3;
                } else if (nb == n2) {
                    tc = t1;
                    td = t3;
                } else if (nb == n3) {
                    tc = t1;
                    td = t2;
                } else assert (false) : "nodes na and nb are referenced by tet";
            } else if (na == n1) {
                if (nb == n0) {
                    tc = t2;
                    td = t3;
                } else if (nb == n2) {
                    tc = t0;
                    td = t3;
                } else if (nb == n3) {
                    tc = t0;
                    td = t2;
                } else assert (false) : "nodes na and nb are referenced by tet";
            } else if (na == n2) {
                if (nb == n0) {
                    tc = t1;
                    td = t3;
                } else if (nb == n1) {
                    tc = t0;
                    td = t3;
                } else if (nb == n3) {
                    tc = t0;
                    td = t1;
                } else assert (false) : "nodes na and nb are referenced by tet";
            } else if (na == n3) {
                if (nb == n0) {
                    tc = t1;
                    td = t2;
                } else if (nb == n1) {
                    tc = t0;
                    td = t2;
                } else if (nb == n2) {
                    tc = t0;
                    td = t1;
                } else assert (false) : "nodes na and nb are referenced by tet";
            } else assert (false) : "node na is referenced by tet";
            if (tc != null && !this.isMarked(tc)) {
                this.getTetNabors(na, nb, tc, nabors);
            }
            if (td != null && !this.isMarked(td)) {
                this.getTetNabors(na, nb, td, nabors);
            }
        }
    }

    private Tet findTet(Tet tet, Node na, Node nb) {
        if (tet != null) {
            this.mark(tet);
            Node n0 = tet._n0;
            Node n1 = tet._n1;
            Node n2 = tet._n2;
            Node n3 = tet._n3;
            Tet t0 = tet._t0;
            Tet t1 = tet._t1;
            Tet t2 = tet._t2;
            Tet t3 = tet._t3;
            if (na == n0) {
                if (nb == n1 || nb == n2 || nb == n3 || t1 != null && !this.isMarked(t1) && (tet = this.findTet(t1, na, nb)) != null || t2 != null && !this.isMarked(t2) && (tet = this.findTet(t2, na, nb)) != null || t3 != null && !this.isMarked(t3) && (tet = this.findTet(t3, na, nb)) != null) {
                    return tet;
                }
            } else if (na == n1) {
                if (nb == n3 || nb == n2 || nb == n0 || t3 != null && !this.isMarked(t3) && (tet = this.findTet(t3, na, nb)) != null || t2 != null && !this.isMarked(t2) && (tet = this.findTet(t2, na, nb)) != null || t0 != null && !this.isMarked(t0) && (tet = this.findTet(t0, na, nb)) != null) {
                    return tet;
                }
            } else if (na == n2) {
                if (nb == n3 || nb == n0 || nb == n1 || t3 != null && !this.isMarked(t3) && (tet = this.findTet(t3, na, nb)) != null || t0 != null && !this.isMarked(t0) && (tet = this.findTet(t0, na, nb)) != null || t1 != null && !this.isMarked(t1) && (tet = this.findTet(t1, na, nb)) != null) {
                    return tet;
                }
            } else if (na == n3) {
                if (nb == n1 || nb == n0 || nb == n2 || t1 != null && !this.isMarked(t1) && (tet = this.findTet(t1, na, nb)) != null || t0 != null && !this.isMarked(t0) && (tet = this.findTet(t0, na, nb)) != null || t2 != null && !this.isMarked(t2) && (tet = this.findTet(t2, na, nb)) != null) {
                    return tet;
                }
            } else assert (false) : "node na is referenced by tet";
        }
        return null;
    }

    private Tet findTet(Tet tet, Node na, Node nb, Node nc) {
        if (tet != null) {
            this.mark(tet);
            Node n0 = tet._n0;
            Node n1 = tet._n1;
            Node n2 = tet._n2;
            Node n3 = tet._n3;
            Tet t0 = tet._t0;
            Tet t1 = tet._t1;
            Tet t2 = tet._t2;
            Tet t3 = tet._t3;
            if (na == n0) {
                if (nb == n1) {
                    if (nc == n2 || nc == n3 || t2 != null && !this.isMarked(t2) && (tet = this.findTet(t2, na, nb, nc)) != null || t3 != null && !this.isMarked(t3) && (tet = this.findTet(t3, na, nb, nc)) != null) {
                        return tet;
                    }
                } else if (nb == n2) {
                    if (nc == n1 || nc == n3 || t1 != null && !this.isMarked(t1) && (tet = this.findTet(t1, na, nb, nc)) != null || t3 != null && !this.isMarked(t3) && (tet = this.findTet(t3, na, nb, nc)) != null) {
                        return tet;
                    }
                } else if (nb == n3) {
                    if (nc == n1 || nc == n2 || t1 != null && !this.isMarked(t1) && (tet = this.findTet(t1, na, nb, nc)) != null || t2 != null && !this.isMarked(t2) && (tet = this.findTet(t2, na, nb, nc)) != null) {
                        return tet;
                    }
                } else assert (false) : "node nb is referenced by tet";
            } else if (na == n1) {
                if (nb == n0) {
                    if (nc == n2 || nc == n3 || t2 != null && !this.isMarked(t2) && (tet = this.findTet(t2, na, nb, nc)) != null || t3 != null && !this.isMarked(t3) && (tet = this.findTet(t3, na, nb, nc)) != null) {
                        return tet;
                    }
                } else if (nb == n2) {
                    if (nc == n0 || nc == n3 || t0 != null && !this.isMarked(t0) && (tet = this.findTet(t0, na, nb, nc)) != null || t3 != null && !this.isMarked(t3) && (tet = this.findTet(t3, na, nb, nc)) != null) {
                        return tet;
                    }
                } else if (nb == n3) {
                    if (nc == n0 || nc == n2 || t0 != null && !this.isMarked(t0) && (tet = this.findTet(t0, na, nb, nc)) != null || t2 != null && !this.isMarked(t2) && (tet = this.findTet(t2, na, nb, nc)) != null) {
                        return tet;
                    }
                } else assert (false) : "node nb is referenced by tet";
            } else if (na == n2) {
                if (nb == n0) {
                    if (nc == n1 || nc == n3 || t1 != null && !this.isMarked(t1) && (tet = this.findTet(t1, na, nb, nc)) != null || t3 != null && !this.isMarked(t3) && (tet = this.findTet(t3, na, nb, nc)) != null) {
                        return tet;
                    }
                } else if (nb == n1) {
                    if (nc == n0 || nc == n3 || t0 != null && !this.isMarked(t0) && (tet = this.findTet(t0, na, nb, nc)) != null || t3 != null && !this.isMarked(t3) && (tet = this.findTet(t3, na, nb, nc)) != null) {
                        return tet;
                    }
                } else if (nb == n3) {
                    if (nc == n0 || nc == n1 || t0 != null && !this.isMarked(t0) && (tet = this.findTet(t0, na, nb, nc)) != null || t1 != null && !this.isMarked(t1) && (tet = this.findTet(t1, na, nb, nc)) != null) {
                        return tet;
                    }
                } else assert (false) : "node nb is referenced by tet";
            } else if (na == n3) {
                if (nb == n0) {
                    if (nc == n1 || nc == n2 || t1 != null && !this.isMarked(t1) && (tet = this.findTet(t1, na, nb, nc)) != null || t2 != null && !this.isMarked(t2) && (tet = this.findTet(t2, na, nb, nc)) != null) {
                        return tet;
                    }
                } else if (nb == n1) {
                    if (nc == n0 || nc == n2 || t0 != null && !this.isMarked(t0) && (tet = this.findTet(t0, na, nb, nc)) != null || t2 != null && !this.isMarked(t2) && (tet = this.findTet(t2, na, nb, nc)) != null) {
                        return tet;
                    }
                } else if (nb == n2) {
                    if (nc == n0 || nc == n1 || t0 != null && !this.isMarked(t0) && (tet = this.findTet(t0, na, nb, nc)) != null || t1 != null && !this.isMarked(t1) && (tet = this.findTet(t1, na, nb, nc)) != null) {
                        return tet;
                    }
                } else assert (false) : "node nb is referenced by tet";
            } else assert (false) : "node na is referenced by tet";
        }
        return null;
    }

    private Tet findTet(Tet tet, Node na, Node nb, Node nc, Node nd) {
        if (tet != null) {
            this.mark(tet);
            Node n0 = tet._n0;
            Node n1 = tet._n1;
            Node n2 = tet._n2;
            Node n3 = tet._n3;
            Tet t0 = tet._t0;
            Tet t1 = tet._t1;
            Tet t2 = tet._t2;
            Tet t3 = tet._t3;
            if (na == n0) {
                if (nb == n1) {
                    if (nc == n2) {
                        if (nd == n3 || t3 != null && !this.isMarked(t3) && (tet = this.findTet(t3, na, nb, nc, nd)) != null) {
                            return tet;
                        }
                    } else if (nc == n3) {
                        if (nd == n2 || t2 != null && !this.isMarked(t2) && (tet = this.findTet(t2, na, nb, nc, nd)) != null) {
                            return tet;
                        }
                    } else assert (false) : "node nc is referenced by tet";
                } else if (nb == n2) {
                    if (nc == n1) {
                        if (nd == n3 || t3 != null && !this.isMarked(t3) && (tet = this.findTet(t3, na, nb, nc, nd)) != null) {
                            return tet;
                        }
                    } else if (nc == n3) {
                        if (nd == n1 || t1 != null && !this.isMarked(t1) && (tet = this.findTet(t1, na, nb, nc, nd)) != null) {
                            return tet;
                        }
                    } else assert (false) : "node nc is referenced by tet";
                } else if (nb == n3) {
                    if (nc == n1) {
                        if (nd == n2 || t2 != null && !this.isMarked(t2) && (tet = this.findTet(t2, na, nb, nc, nd)) != null) {
                            return tet;
                        }
                    } else if (nc == n2) {
                        if (nd == n1 || t1 != null && !this.isMarked(t1) && (tet = this.findTet(t1, na, nb, nc, nd)) != null) {
                            return tet;
                        }
                    } else assert (false) : "node nc is referenced by tet";
                } else assert (false) : "node nb is referenced by tet";
            } else if (na == n1) {
                if (nb == n0) {
                    if (nc == n2) {
                        if (nd == n3 || t3 != null && !this.isMarked(t3) && (tet = this.findTet(t3, na, nb, nc, nd)) != null) {
                            return tet;
                        }
                    } else if (nc == n3) {
                        if (nd == n2 || t2 != null && !this.isMarked(t2) && (tet = this.findTet(t2, na, nb, nc, nd)) != null) {
                            return tet;
                        }
                    } else assert (false) : "node nc is referenced by tet";
                } else if (nb == n2) {
                    if (nc == n0) {
                        if (nd == n3 || t3 != null && !this.isMarked(t3) && (tet = this.findTet(t3, na, nb, nc, nd)) != null) {
                            return tet;
                        }
                    } else if (nc == n3) {
                        if (nd == n0 || t0 != null && !this.isMarked(t0) && (tet = this.findTet(t0, na, nb, nc, nd)) != null) {
                            return tet;
                        }
                    } else assert (false) : "node nc is referenced by tet";
                } else if (nb == n3) {
                    if (nc == n0) {
                        if (nd == n2 || t2 != null && !this.isMarked(t2) && (tet = this.findTet(t2, na, nb, nc, nd)) != null) {
                            return tet;
                        }
                    } else if (nc == n2) {
                        if (nd == n0 || t0 != null && !this.isMarked(t0) && (tet = this.findTet(t0, na, nb, nc, nd)) != null) {
                            return tet;
                        }
                    } else assert (false) : "node nc is referenced by tet";
                } else assert (false) : "node nb is referenced by tet";
            } else if (na == n2) {
                if (nb == n0) {
                    if (nc == n1) {
                        if (nd == n3 || t3 != null && !this.isMarked(t3) && (tet = this.findTet(t3, na, nb, nc, nd)) != null) {
                            return tet;
                        }
                    } else if (nc == n3) {
                        if (nd == n1 || t1 != null && !this.isMarked(t1) && (tet = this.findTet(t1, na, nb, nc, nd)) != null) {
                            return tet;
                        }
                    } else assert (false) : "node nc is referenced by tet";
                } else if (nb == n1) {
                    if (nc == n0) {
                        if (nd == n3 || t3 != null && !this.isMarked(t3) && (tet = this.findTet(t3, na, nb, nc, nd)) != null) {
                            return tet;
                        }
                    } else if (nc == n3) {
                        if (nd == n0 || t0 != null && !this.isMarked(t0) && (tet = this.findTet(t0, na, nb, nc, nd)) != null) {
                            return tet;
                        }
                    } else assert (false) : "node nc is referenced by tet";
                } else if (nb == n3) {
                    if (nc == n0) {
                        if (nd == n1 || t1 != null && !this.isMarked(t1) && (tet = this.findTet(t1, na, nb, nc, nd)) != null) {
                            return tet;
                        }
                    } else if (nc == n1) {
                        if (nd == n0 || t0 != null && !this.isMarked(t0) && (tet = this.findTet(t0, na, nb, nc, nd)) != null) {
                            return tet;
                        }
                    } else assert (false) : "node nc is referenced by tet";
                } else assert (false) : "node nb is referenced by tet";
            } else if (na == n3) {
                if (nb == n0) {
                    if (nc == n1) {
                        if (nd == n2 || t2 != null && !this.isMarked(t2) && (tet = this.findTet(t2, na, nb, nc, nd)) != null) {
                            return tet;
                        }
                    } else if (nc == n2) {
                        if (nd == n1 || t1 != null && !this.isMarked(t1) && (tet = this.findTet(t1, na, nb, nc, nd)) != null) {
                            return tet;
                        }
                    } else assert (false) : "node nc is referenced by tet";
                } else if (nb == n1) {
                    if (nc == n0) {
                        if (nd == n2 || t2 != null && !this.isMarked(t2) && (tet = this.findTet(t2, na, nb, nc, nd)) != null) {
                            return tet;
                        }
                    } else if (nc == n2) {
                        if (nd == n0 || t0 != null && !this.isMarked(t0) && (tet = this.findTet(t0, na, nb, nc, nd)) != null) {
                            return tet;
                        }
                    } else assert (false) : "node nc is referenced by tet";
                } else if (nb == n2) {
                    if (nc == n0) {
                        if (nd == n1 || t1 != null && !this.isMarked(t1) && (tet = this.findTet(t1, na, nb, nc, nd)) != null) {
                            return tet;
                        }
                    } else if (nc == n1) {
                        if (nd == n0 || t0 != null && !this.isMarked(t0) && (tet = this.findTet(t0, na, nb, nc, nd)) != null) {
                            return tet;
                        }
                    } else assert (false) : "node nc is referenced by tet";
                } else assert (false) : "node nb is referenced by tet";
            } else assert (false) : "node na is referenced by tet";
        }
        return null;
    }

    private Node findNodeNearest(double x, double y, double z) {
        double dmin;
        if (this._nnode == 0) {
            return null;
        }
        if (this._nnode < 20) {
            this._nmin = this._nroot;
            this._dmin = TetMesh.distanceSquared(this._nmin, x, y, z);
            NodeIterator ni = this.getNodes();
            while (ni.hasNext()) {
                Node n = ni.next();
                double d = TetMesh.distanceSquared(n, x, y, z);
                if (!(d < this._dmin)) continue;
                this._dmin = d;
                this._nmin = n;
            }
            return this._nmin;
        }
        this._nmin = this._nroot;
        this._dmin = TetMesh.distanceSquared(this._nmin, x, y, z);
        for (Node n : this._sampledNodes) {
            double d = TetMesh.distanceSquared(n, x, y, z);
            if (!(d < this._dmin)) continue;
            this._dmin = d;
            this._nmin = n;
        }
        this.clearNodeMarks();
        do {
            this.clearTetMarks();
            dmin = this._dmin;
            this.findNodeNaborNearest(x, y, z, this._nmin, this._nmin._tet);
        } while (this._dmin < dmin);
        return this._nmin;
    }

    private void findNodeNaborNearest(double x, double y, double z, Node node, Tet tet) {
        this.mark(tet);
        Node n0 = tet._n0;
        Node n1 = tet._n1;
        Node n2 = tet._n2;
        Node n3 = tet._n3;
        Tet t0 = tet._t0;
        Tet t1 = tet._t1;
        Tet t2 = tet._t2;
        Tet t3 = tet._t3;
        if (node == n0) {
            this.findNodeNaborNearest(x, y, z, node, n1, n2, n3, t1, t2, t3);
        } else if (node == n1) {
            this.findNodeNaborNearest(x, y, z, node, n3, n2, n0, t3, t2, t0);
        } else if (node == n2) {
            this.findNodeNaborNearest(x, y, z, node, n3, n0, n1, t3, t0, t1);
        } else if (node == n3) {
            this.findNodeNaborNearest(x, y, z, node, n1, n0, n2, t1, t0, t2);
        } else assert (false) : "node is referenced by tet";
    }

    private void findNodeNaborNearest(double x, double y, double z, Node node, Node na, Node nb, Node nc, Tet ta, Tet tb, Tet tc) {
        if (!this.isMarked(na)) {
            this.mark(na);
            double da = TetMesh.distanceSquared(na, x, y, z);
            if (da < this._dmin) {
                this._dmin = da;
                this._nmin = na;
            }
        }
        if (!this.isMarked(nb)) {
            this.mark(nb);
            double db = TetMesh.distanceSquared(nb, x, y, z);
            if (db < this._dmin) {
                this._dmin = db;
                this._nmin = nb;
            }
        }
        if (!this.isMarked(nc)) {
            this.mark(nc);
            double dc = TetMesh.distanceSquared(nc, x, y, z);
            if (dc < this._dmin) {
                this._dmin = dc;
                this._nmin = nc;
            }
        }
        if (ta != null && !this.isMarked(ta)) {
            this.findNodeNaborNearest(x, y, z, node, ta);
        }
        if (tb != null && !this.isMarked(tb)) {
            this.findNodeNaborNearest(x, y, z, node, tb);
        }
        if (tc != null && !this.isMarked(tc)) {
            this.findNodeNaborNearest(x, y, z, node, tc);
        }
    }

    private Node findNodeNearestPlane(double a, double b, double c, double d) {
        double dmin;
        this._nmin = this._nroot;
        this._dmin = TetMesh.distanceToPlaneSquared(this._nmin, a, b, c, d);
        for (Node n : this._sampledNodes) {
            double dp = TetMesh.distanceToPlaneSquared(n, a, b, c, d);
            if (!(dp < this._dmin)) continue;
            this._dmin = dp;
            this._nmin = n;
        }
        this.clearNodeMarks();
        do {
            this.clearTetMarks();
            dmin = this._dmin;
            this.findNodeNaborNearestPlane(a, b, c, d, this._nmin, this._nmin._tet);
        } while (this._dmin < dmin);
        return this._nmin;
    }

    private void findNodeNaborNearestPlane(double a, double b, double c, double d, Node node, Tet tet) {
        this.mark(tet);
        Node n0 = tet._n0;
        Node n1 = tet._n1;
        Node n2 = tet._n2;
        Node n3 = tet._n3;
        Tet t0 = tet._t0;
        Tet t1 = tet._t1;
        Tet t2 = tet._t2;
        Tet t3 = tet._t3;
        if (node == n0) {
            this.findNodeNaborNearestPlane(a, b, c, d, node, n1, n2, n3, t1, t2, t3);
        } else if (node == n1) {
            this.findNodeNaborNearestPlane(a, b, c, d, node, n3, n2, n0, t3, t2, t0);
        } else if (node == n2) {
            this.findNodeNaborNearestPlane(a, b, c, d, node, n3, n0, n1, t3, t0, t1);
        } else if (node == n3) {
            this.findNodeNaborNearestPlane(a, b, c, d, node, n1, n0, n2, t1, t0, t2);
        } else assert (false) : "node is referenced by tet";
    }

    private void findNodeNaborNearestPlane(double a, double b, double c, double d, Node node, Node na, Node nb, Node nc, Tet ta, Tet tb, Tet tc) {
        if (!this.isMarked(na)) {
            this.mark(na);
            double da = TetMesh.distanceToPlaneSquared(na, a, b, c, d);
            if (da < this._dmin) {
                this._dmin = da;
                this._nmin = na;
            }
        }
        if (!this.isMarked(nb)) {
            this.mark(nb);
            double db = TetMesh.distanceToPlaneSquared(nb, a, b, c, d);
            if (db < this._dmin) {
                this._dmin = db;
                this._nmin = nb;
            }
        }
        if (!this.isMarked(nc)) {
            this.mark(nc);
            double dc = TetMesh.distanceToPlaneSquared(nc, a, b, c, d);
            if (dc < this._dmin) {
                this._dmin = dc;
                this._nmin = nc;
            }
        }
        if (ta != null && !this.isMarked(ta)) {
            this.findNodeNaborNearestPlane(a, b, c, d, node, ta);
        }
        if (tb != null && !this.isMarked(tb)) {
            this.findNodeNaborNearestPlane(a, b, c, d, node, tb);
        }
        if (tc != null && !this.isMarked(tc)) {
            this.findNodeNaborNearestPlane(a, b, c, d, node, tc);
        }
    }

    private PointLocation locatePoint(double x, double y, double z) {
        if (this._troot == null) {
            if (this._nroot != null) {
                Node node = this._nroot;
                do {
                    if (x != (double)node.x() || y != (double)node.y() || z != (double)node.z()) continue;
                    return new PointLocation(node);
                } while ((node = node._next) != this._nroot);
            }
            return new PointLocation(null, false);
        }
        Node nmin = this._nroot;
        double dmin = TetMesh.distanceSquared(nmin, x, y, z);
        for (Node n : this._sampledNodes) {
            double d = TetMesh.distanceSquared(n, x, y, z);
            if (!(d < dmin)) continue;
            dmin = d;
            nmin = n;
        }
        Tet tet = nmin._tet;
        return this.locatePoint(tet, x, y, z);
    }

    private PointLocation locatePoint(Tet tet, double x, double y, double z) {
        this._troot = tet;
        Node n0 = tet._n0;
        Node n1 = tet._n1;
        Node n2 = tet._n2;
        Node n3 = tet._n3;
        double x0 = n0._x;
        double y0 = n0._y;
        double z0 = n0._z;
        double x1 = n1._x;
        double y1 = n1._y;
        double z1 = n1._z;
        double x2 = n2._x;
        double y2 = n2._y;
        double z2 = n2._z;
        double x3 = n3._x;
        double y3 = n3._y;
        double z3 = n3._z;
        if (x == x0 && y == y0 && z == z0) {
            return new PointLocation(n0);
        }
        if (x == x1 && y == y1 && z == z1) {
            return new PointLocation(n1);
        }
        if (x == x2 && y == y2 && z == z2) {
            return new PointLocation(n2);
        }
        if (x == x3 && y == y3 && z == z3) {
            return new PointLocation(n3);
        }
        double d0 = Geometry.leftOfPlane(x1, y1, z1, x2, y2, z2, x3, y3, z3, x, y, z);
        if (d0 > 0.0) {
            Tet tetNabor = tet.tetNabor(n0);
            if (tetNabor != null) {
                return this.locatePoint(tetNabor, x, y, z);
            }
            return new PointLocation(tet, false);
        }
        double d1 = Geometry.leftOfPlane(x3, y3, z3, x2, y2, z2, x0, y0, z0, x, y, z);
        if (d1 > 0.0) {
            Tet tetNabor = tet.tetNabor(n1);
            if (tetNabor != null) {
                return this.locatePoint(tetNabor, x, y, z);
            }
            return new PointLocation(tet, false);
        }
        double d2 = Geometry.leftOfPlane(x3, y3, z3, x0, y0, z0, x1, y1, z1, x, y, z);
        if (d2 > 0.0) {
            Tet tetNabor = tet.tetNabor(n2);
            if (tetNabor != null) {
                return this.locatePoint(tetNabor, x, y, z);
            }
            return new PointLocation(tet, false);
        }
        double d3 = Geometry.leftOfPlane(x0, y0, z0, x2, y2, z2, x1, y1, z1, x, y, z);
        if (d3 > 0.0) {
            Tet tetNabor = tet.tetNabor(n3);
            if (tetNabor != null) {
                return this.locatePoint(tetNabor, x, y, z);
            }
            return new PointLocation(tet, false);
        }
        if (d0 < 0.0 && d1 < 0.0 && d2 < 0.0 && d3 < 0.0) {
            return new PointLocation(tet);
        }
        if (d0 == 0.0 && d1 == 0.0) {
            return new PointLocation(new Edge(tet, n2, n3));
        }
        if (d0 == 0.0 && d2 == 0.0) {
            return new PointLocation(new Edge(tet, n3, n1));
        }
        if (d0 == 0.0 && d3 == 0.0) {
            return new PointLocation(new Edge(tet, n1, n2));
        }
        if (d1 == 0.0 && d2 == 0.0) {
            return new PointLocation(new Edge(tet, n0, n3));
        }
        if (d1 == 0.0 && d3 == 0.0) {
            return new PointLocation(new Edge(tet, n2, n0));
        }
        if (d2 == 0.0 && d3 == 0.0) {
            return new PointLocation(new Edge(tet, n0, n1));
        }
        if (d0 == 0.0) {
            return new PointLocation(new Face(tet, n0));
        }
        if (d1 == 0.0) {
            return new PointLocation(new Face(tet, n1));
        }
        if (d2 == 0.0) {
            return new PointLocation(new Face(tet, n2));
        }
        if (d3 == 0.0) {
            return new PointLocation(new Face(tet, n3));
        }
        assert (false) : "successfully located the point";
        return null;
    }

    private void getDelaunayFacesInside(Node node, Tet tet) {
        if (tet != null && !this.isMarked(tet)) {
            this.mark(tet);
            Node n0 = tet._n0;
            Node n1 = tet._n1;
            Node n2 = tet._n2;
            Node n3 = tet._n3;
            if (TetMesh.inSphere(n0, n1, n2, n3, node)) {
                this.killTet(tet);
                Tet t0 = tet._t0;
                Tet t1 = tet._t1;
                Tet t2 = tet._t2;
                Tet t3 = tet._t3;
                this._faceSet.addMate(tet, n0);
                this._faceSet.addMate(tet, n1);
                this._faceSet.addMate(tet, n2);
                this._faceSet.addMate(tet, n3);
                this.getDelaunayFacesInside(node, t0);
                this.getDelaunayFacesInside(node, t1);
                this.getDelaunayFacesInside(node, t2);
                this.getDelaunayFacesInside(node, t3);
            }
        }
    }

    private void getDelaunayFacesOutside(Node node, Tet tet) {
        if (tet != null && !this.isMarked(tet)) {
            this.mark(tet);
            Node n0 = tet._n0;
            Node n1 = tet._n1;
            Node n2 = tet._n2;
            Node n3 = tet._n3;
            Tet t0 = tet._t0;
            Tet t1 = tet._t1;
            Tet t2 = tet._t2;
            Tet t3 = tet._t3;
            if (t0 == null && TetMesh.leftOfPlane(n1, n2, n3, node)) {
                this._faceSet.add(tet, n0);
                this.getDelaunayFacesOutside(node, this.getNextTetOnHull(tet, n1, n0));
                this.getDelaunayFacesOutside(node, this.getNextTetOnHull(tet, n2, n0));
                this.getDelaunayFacesOutside(node, this.getNextTetOnHull(tet, n3, n0));
            }
            if (t1 == null && TetMesh.leftOfPlane(n3, n2, n0, node)) {
                this._faceSet.add(tet, n1);
                this.getDelaunayFacesOutside(node, this.getNextTetOnHull(tet, n3, n1));
                this.getDelaunayFacesOutside(node, this.getNextTetOnHull(tet, n2, n1));
                this.getDelaunayFacesOutside(node, this.getNextTetOnHull(tet, n0, n1));
            }
            if (t2 == null && TetMesh.leftOfPlane(n3, n0, n1, node)) {
                this._faceSet.add(tet, n2);
                this.getDelaunayFacesOutside(node, this.getNextTetOnHull(tet, n3, n2));
                this.getDelaunayFacesOutside(node, this.getNextTetOnHull(tet, n0, n2));
                this.getDelaunayFacesOutside(node, this.getNextTetOnHull(tet, n1, n2));
            }
            if (t3 == null && TetMesh.leftOfPlane(n1, n0, n2, node)) {
                this._faceSet.add(tet, n3);
                this.getDelaunayFacesOutside(node, this.getNextTetOnHull(tet, n1, n3));
                this.getDelaunayFacesOutside(node, this.getNextTetOnHull(tet, n0, n3));
                this.getDelaunayFacesOutside(node, this.getNextTetOnHull(tet, n2, n3));
            }
            if (TetMesh.inSphere(n0, n1, n2, n3, node)) {
                this.killTet(tet);
                this._faceSet.addMate(tet, n0);
                this._faceSet.addMate(tet, n1);
                this._faceSet.addMate(tet, n2);
                this._faceSet.addMate(tet, n3);
                this.getDelaunayFacesOutside(node, t0);
                this.getDelaunayFacesOutside(node, t1);
                this.getDelaunayFacesOutside(node, t2);
                this.getDelaunayFacesOutside(node, t3);
            }
        }
    }

    private void getDelaunayFacesOpposite(Node node, Tet tet) {
        if (tet != null && !this.isMarked(tet)) {
            this.mark(tet);
            this.killTet(tet);
            Node n0 = tet._n0;
            Node n1 = tet._n1;
            Node n2 = tet._n2;
            Node n3 = tet._n3;
            Tet t0 = tet._t0;
            Tet t1 = tet._t1;
            Tet t2 = tet._t2;
            Tet t3 = tet._t3;
            if (node == n0) {
                this._faceSet.addMate(tet, n0);
                this.getDelaunayFacesOpposite(node, n1, n2, n3, t1, t2, t3);
            } else if (node == n1) {
                this._faceSet.addMate(tet, n1);
                this.getDelaunayFacesOpposite(node, n3, n2, n0, t3, t2, t0);
            } else if (node == n2) {
                this._faceSet.addMate(tet, n2);
                this.getDelaunayFacesOpposite(node, n3, n0, n1, t3, t0, t1);
            } else if (node == n3) {
                this._faceSet.addMate(tet, n3);
                this.getDelaunayFacesOpposite(node, n1, n0, n2, t1, t0, t2);
            } else assert (false) : "node is referenced by tet";
        }
    }

    private void getDelaunayFacesOpposite(Node node, Node na, Node nb, Node nc, Tet ta, Tet tb, Tet tc) {
        if (!this.isMarked(na)) {
            this.mark(na);
            this._nodeList.add(na);
        }
        if (!this.isMarked(nb)) {
            this.mark(nb);
            this._nodeList.add(nb);
        }
        if (!this.isMarked(nc)) {
            this.mark(nc);
            this._nodeList.add(nc);
        }
        this.getDelaunayFacesOpposite(node, ta);
        this.getDelaunayFacesOpposite(node, tb);
        this.getDelaunayFacesOpposite(node, tc);
    }

    private Tet getNextTetOnHull(Tet tet, Node node, Node nodeOther) {
        Tet tnext = tet.tetNabor(node);
        while (tnext != null) {
            node = nodeOther;
            nodeOther = tet.nodeNabor(tnext);
            tet = tnext;
            tnext = tet.tetNabor(node);
        }
        return tet;
    }

    public Node findNodeNearestSlow(float x, float y, float z) {
        this.clearTetMarks();
        this.clearNodeMarks();
        this._dmin = Double.MAX_VALUE;
        this._nmin = null;
        if (this._troot == null) {
            if (this._nroot != null) {
                Node node = this._nroot;
                do {
                    this.updateNodeNearest(x, y, z, node);
                } while ((node = node._next) != this._nroot);
            }
            assert (this._nmin != null);
            return this._nmin;
        }
        PointLocation pl = this.locatePoint(x, y, z);
        if (pl.isOnNode()) {
            this.updateNodeNearest(x, y, z, pl.node());
            return this._nmin;
        }
        if (pl.isInside()) {
            this.findNodeNearestInside(x, y, z, pl.tet());
        } else {
            this.findNodeNearestOutside(x, y, z, pl.tet());
        }
        return this._nmin;
    }

    private void findNodeNearestInside(double x, double y, double z, Tet tet) {
        if (tet != null && !this.isMarked(tet)) {
            this.mark(tet);
            Node n0 = tet._n0;
            Node n1 = tet._n1;
            Node n2 = tet._n2;
            Node n3 = tet._n3;
            this.updateNodeNearest(x, y, z, n0);
            this.updateNodeNearest(x, y, z, n1);
            this.updateNodeNearest(x, y, z, n2);
            this.updateNodeNearest(x, y, z, n3);
            if (TetMesh.inSphere(n0, n1, n2, n3, x, y, z)) {
                Tet t0 = tet._t0;
                Tet t1 = tet._t1;
                Tet t2 = tet._t2;
                Tet t3 = tet._t3;
                this.findNodeNearestInside(x, y, z, t0);
                this.findNodeNearestInside(x, y, z, t1);
                this.findNodeNearestInside(x, y, z, t2);
                this.findNodeNearestInside(x, y, z, t3);
            }
        }
    }

    private void findNodeNearestOutside(double x, double y, double z, Tet tet) {
        if (tet != null && !this.isMarked(tet)) {
            this.mark(tet);
            Node n0 = tet._n0;
            Node n1 = tet._n1;
            Node n2 = tet._n2;
            Node n3 = tet._n3;
            this.updateNodeNearest(x, y, z, n0);
            this.updateNodeNearest(x, y, z, n1);
            this.updateNodeNearest(x, y, z, n2);
            this.updateNodeNearest(x, y, z, n3);
            Tet t0 = tet._t0;
            Tet t1 = tet._t1;
            Tet t2 = tet._t2;
            Tet t3 = tet._t3;
            if (t0 == null && TetMesh.leftOfPlane(n1, n2, n3, x, y, z)) {
                this.findNodeNearestOutside(x, y, z, this.getNextTetOnHull(tet, n1, n0));
                this.findNodeNearestOutside(x, y, z, this.getNextTetOnHull(tet, n2, n0));
                this.findNodeNearestOutside(x, y, z, this.getNextTetOnHull(tet, n3, n0));
            }
            if (t1 == null && TetMesh.leftOfPlane(n3, n2, n0, x, y, z)) {
                this.findNodeNearestOutside(x, y, z, this.getNextTetOnHull(tet, n3, n1));
                this.findNodeNearestOutside(x, y, z, this.getNextTetOnHull(tet, n2, n1));
                this.findNodeNearestOutside(x, y, z, this.getNextTetOnHull(tet, n0, n1));
            }
            if (t2 == null && TetMesh.leftOfPlane(n3, n0, n1, x, y, z)) {
                this.findNodeNearestOutside(x, y, z, this.getNextTetOnHull(tet, n3, n2));
                this.findNodeNearestOutside(x, y, z, this.getNextTetOnHull(tet, n0, n2));
                this.findNodeNearestOutside(x, y, z, this.getNextTetOnHull(tet, n1, n2));
            }
            if (t3 == null && TetMesh.leftOfPlane(n1, n0, n2, x, y, z)) {
                this.findNodeNearestOutside(x, y, z, this.getNextTetOnHull(tet, n1, n3));
                this.findNodeNearestOutside(x, y, z, this.getNextTetOnHull(tet, n0, n3));
                this.findNodeNearestOutside(x, y, z, this.getNextTetOnHull(tet, n2, n3));
            }
            if (TetMesh.inSphere(n0, n1, n2, n3, x, y, z)) {
                this.findNodeNearestOutside(x, y, z, t0);
                this.findNodeNearestOutside(x, y, z, t1);
                this.findNodeNearestOutside(x, y, z, t2);
                this.findNodeNearestOutside(x, y, z, t3);
            }
        }
    }

    private void updateNodeNearest(double x, double y, double z, Node n) {
        if (!this.isMarked(n)) {
            this.mark(n);
            double d = TetMesh.distanceSquared(n, x, y, z);
            if (d < this._dmin) {
                this._dmin = d;
                this._nmin = n;
                this._nroot = n;
            }
        }
    }

    private void linkTets(Tet tet, Node node, Tet tetNabor, Node nodeNabor) {
        if (tet != null) {
            if (node == tet._n0) {
                tet._t0 = tetNabor;
            } else if (node == tet._n1) {
                tet._t1 = tetNabor;
            } else if (node == tet._n2) {
                tet._t2 = tetNabor;
            } else if (node == tet._n3) {
                tet._t3 = tetNabor;
            } else assert (false) : "node referenced by tet";
        }
        if (tetNabor != null) {
            if (nodeNabor == tetNabor._n0) {
                tetNabor._t0 = tet;
            } else if (nodeNabor == tetNabor._n1) {
                tetNabor._t1 = tet;
            } else if (nodeNabor == tetNabor._n2) {
                tetNabor._t2 = tet;
            } else if (nodeNabor == tetNabor._n3) {
                tetNabor._t3 = tet;
            } else assert (false) : "nodeNabor referenced by tetNabor";
        }
    }

    private void markAllTets(Tet tet) {
        Tet t3;
        Tet t2;
        Tet t1;
        tet._mark = this._tetMarkRed;
        Tet t0 = tet._t0;
        if (t0 != null && t0._mark != this._tetMarkRed) {
            this.markAllTets(t0);
        }
        if ((t1 = tet._t1) != null && t1._mark != this._tetMarkRed) {
            this.markAllTets(t1);
        }
        if ((t2 = tet._t2) != null && t2._mark != this._tetMarkRed) {
            this.markAllTets(t2);
        }
        if ((t3 = tet._t3) != null && t3._mark != this._tetMarkRed) {
            this.markAllTets(t3);
        }
    }

    private void zeroTetMarks(Tet tet) {
        Tet t3;
        Tet t2;
        Tet t1;
        tet._mark = 0;
        Tet t0 = tet._t0;
        if (t0 != null && t0._mark != 0) {
            this.zeroTetMarks(t0);
        }
        if ((t1 = tet._t1) != null && t1._mark != 0) {
            this.zeroTetMarks(t1);
        }
        if ((t2 = tet._t2) != null && t2._mark != 0) {
            this.zeroTetMarks(t2);
        }
        if ((t3 = tet._t3) != null && t3._mark != 0) {
            this.zeroTetMarks(t3);
        }
    }

    private Face getFaceOnHull(Tet tet) {
        ArrayList<Tet> stack = new ArrayList<Tet>(128);
        stack.add(tet);
        while (!stack.isEmpty()) {
            Tet t = (Tet)stack.remove(stack.size() - 1);
            this.mark(t);
            if (t._t0 == null) {
                return new Face(t, t._n0);
            }
            if (t._t1 == null) {
                return new Face(t, t._n1);
            }
            if (t._t2 == null) {
                return new Face(t, t._n2);
            }
            if (t._t3 == null) {
                return new Face(t, t._n3);
            }
            if (!this.isMarked(t._t0)) {
                stack.add(t._t0);
            }
            if (!this.isMarked(t._t1)) {
                stack.add(t._t1);
            }
            if (!this.isMarked(t._t2)) {
                stack.add(t._t2);
            }
            if (this.isMarked(t._t3)) continue;
            stack.add(t._t3);
        }
        return null;
    }

    private void getFacesOnHull(Face face, HashSet<Face> faces) {
        if (!faces.contains(face)) {
            faces.add(face);
            this.getFacesOnHull(this.getNextFaceOnHull(face.nodeA(), face), faces);
            this.getFacesOnHull(this.getNextFaceOnHull(face.nodeB(), face), faces);
            this.getFacesOnHull(this.getNextFaceOnHull(face.nodeC(), face), faces);
        }
    }

    private Face getNextFaceOnHull(Node node, Face face) {
        Tet tet = face.tetLeft();
        Node next = face.nodeLeft();
        Tet tnext = tet.tetNabor(node);
        while (tnext != null) {
            node = next;
            next = tet.nodeNabor(tnext);
            tet = tnext;
            tnext = tet.tetNabor(node);
        }
        return new Face(tet, node);
    }

    private static Edge edgeOfTet(Tet tet, Node na, Node nb) {
        Node n0 = tet._n0;
        Node n1 = tet._n1;
        Node n2 = tet._n2;
        Node n3 = tet._n3;
        if (na == n0) {
            if (nb == n1) {
                return new Edge(tet, n0, n1);
            }
            if (nb == n2) {
                return new Edge(tet, n0, n2);
            }
            if (nb == n3) {
                return new Edge(tet, n0, n3);
            }
            return null;
        }
        if (na == n1) {
            if (nb == n0) {
                return new Edge(tet, n0, n1);
            }
            if (nb == n2) {
                return new Edge(tet, n1, n2);
            }
            if (nb == n3) {
                return new Edge(tet, n1, n3);
            }
            return null;
        }
        if (na == n2) {
            if (nb == n0) {
                return new Edge(tet, n0, n2);
            }
            if (nb == n1) {
                return new Edge(tet, n1, n2);
            }
            if (nb == n3) {
                return new Edge(tet, n2, n3);
            }
            return null;
        }
        if (na == n3) {
            if (nb == n0) {
                return new Edge(tet, n0, n3);
            }
            if (nb == n1) {
                return new Edge(tet, n1, n3);
            }
            if (nb == n2) {
                return new Edge(tet, n2, n3);
            }
            return null;
        }
        return null;
    }

    private static Face faceOfTet(Tet tet, Node na, Node nb, Node nc) {
        Node n0 = tet._n0;
        Node n1 = tet._n1;
        Node n2 = tet._n2;
        Node n3 = tet._n3;
        if (na == n0) {
            if (nb == n1) {
                if (nc == n2) {
                    return new Face(tet, n3);
                }
                if (nc == n3) {
                    return new Face(tet, n2);
                }
                return null;
            }
            if (nb == n2) {
                if (nc == n1) {
                    return new Face(tet, n3);
                }
                if (nc == n3) {
                    return new Face(tet, n1);
                }
                return null;
            }
            if (nb == n3) {
                if (nc == n1) {
                    return new Face(tet, n2);
                }
                if (nc == n2) {
                    return new Face(tet, n1);
                }
                return null;
            }
            return null;
        }
        if (na == n1) {
            if (nb == n0) {
                if (nc == n2) {
                    return new Face(tet, n3);
                }
                if (nc == n3) {
                    return new Face(tet, n2);
                }
                return null;
            }
            if (nb == n2) {
                if (nc == n0) {
                    return new Face(tet, n3);
                }
                if (nc == n3) {
                    return new Face(tet, n0);
                }
                return null;
            }
            if (nb == n3) {
                if (nc == n0) {
                    return new Face(tet, n2);
                }
                if (nc == n2) {
                    return new Face(tet, n0);
                }
                return null;
            }
            return null;
        }
        if (na == n2) {
            if (nb == n0) {
                if (nc == n1) {
                    return new Face(tet, n3);
                }
                if (nc == n3) {
                    return new Face(tet, n1);
                }
                return null;
            }
            if (nb == n1) {
                if (nc == n0) {
                    return new Face(tet, n3);
                }
                if (nc == n3) {
                    return new Face(tet, n0);
                }
                return null;
            }
            if (nb == n3) {
                if (nc == n0) {
                    return new Face(tet, n1);
                }
                if (nc == n1) {
                    return new Face(tet, n0);
                }
                return null;
            }
            return null;
        }
        if (na == n3) {
            if (nb == n0) {
                if (nc == n1) {
                    return new Face(tet, n2);
                }
                if (nc == n2) {
                    return new Face(tet, n1);
                }
                return null;
            }
            if (nb == n1) {
                if (nc == n0) {
                    return new Face(tet, n2);
                }
                if (nc == n2) {
                    return new Face(tet, n0);
                }
                return null;
            }
            if (nb == n2) {
                if (nc == n0) {
                    return new Face(tet, n1);
                }
                if (nc == n1) {
                    return new Face(tet, n0);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private static boolean nodesInOrder(Tet tet, Node na, Node nb, Node nc, Node nd) {
        Node n0 = tet._n0;
        Node n1 = tet._n1;
        Node n2 = tet._n2;
        Node n3 = tet._n3;
        if (na == n0) {
            return nb == n1 && nc == n2 && nd == n3 || nb == n2 && nc == n3 && nd == n1 || nb == n3 && nc == n1 && nd == n2;
        }
        if (na == n1) {
            return nb == n2 && nc == n0 && nd == n3 || nb == n3 && nc == n2 && nd == n0 || nb == n0 && nc == n3 && nd == n2;
        }
        if (na == n2) {
            return nb == n3 && nc == n0 && nd == n1 || nb == n0 && nc == n1 && nd == n3 || nb == n1 && nc == n3 && nd == n0;
        }
        if (na == n3) {
            return nb == n0 && nc == n2 && nd == n1 || nb == n1 && nc == n0 && nd == n2 || nb == n2 && nc == n1 && nd == n0;
        }
        assert (false) : "tet references na";
        return false;
    }

    private static Node otherNode(Tet tet, Node na, Node nb, Node nc) {
        Node n0 = tet._n0;
        Node n1 = tet._n1;
        Node n2 = tet._n2;
        Node n3 = tet._n3;
        if (na == n0) {
            if (nb == n1) {
                if (nc == n2) {
                    return n3;
                }
                if (nc == n3) {
                    return n2;
                }
                return null;
            }
            if (nb == n2) {
                if (nc == n1) {
                    return n3;
                }
                if (nc == n3) {
                    return n1;
                }
                return null;
            }
            if (nb == n3) {
                if (nc == n1) {
                    return n2;
                }
                if (nc == n2) {
                    return n1;
                }
                return null;
            }
            return null;
        }
        if (na == n1) {
            if (nb == n0) {
                if (nc == n2) {
                    return n3;
                }
                if (nc == n3) {
                    return n2;
                }
                return null;
            }
            if (nb == n2) {
                if (nc == n0) {
                    return n3;
                }
                if (nc == n3) {
                    return n0;
                }
                return null;
            }
            if (nb == n3) {
                if (nc == n0) {
                    return n2;
                }
                if (nc == n2) {
                    return n0;
                }
                return null;
            }
            return null;
        }
        if (na == n2) {
            if (nb == n0) {
                if (nc == n1) {
                    return n3;
                }
                if (nc == n3) {
                    return n1;
                }
                return null;
            }
            if (nb == n1) {
                if (nc == n0) {
                    return n3;
                }
                if (nc == n3) {
                    return n0;
                }
                return null;
            }
            if (nb == n3) {
                if (nc == n0) {
                    return n1;
                }
                if (nc == n1) {
                    return n0;
                }
                return null;
            }
            return null;
        }
        if (na == n3) {
            if (nb == n0) {
                if (nc == n1) {
                    return n2;
                }
                if (nc == n2) {
                    return n1;
                }
                return null;
            }
            if (nb == n1) {
                if (nc == n0) {
                    return n2;
                }
                if (nc == n2) {
                    return n0;
                }
                return null;
            }
            if (nb == n2) {
                if (nc == n0) {
                    return n1;
                }
                if (nc == n1) {
                    return n0;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private synchronized void markTetInnerOrOuter(Tet tet) {
        assert (this._xminOuter < this._xmaxOuter) : "outer box is valid";
        assert (this._yminOuter < this._ymaxOuter) : "outer box is valid";
        assert (this._zminOuter < this._zmaxOuter) : "outer box is valid";
        double[] po = new double[]{0.0, 0.0, 0.0};
        double s = tet.centerSphere(po);
        double r = MathPlus.sqrt(s);
        double xo = po[0];
        double yo = po[1];
        double zo = po[2];
        if (xo - r >= this._xminOuter && yo - r >= this._yminOuter && zo - r >= this._zminOuter && xo + r <= this._xmaxOuter && yo + r <= this._ymaxOuter && zo + r <= this._zmaxOuter) {
            tet.setInner();
            tet.clearOuter();
        } else {
            tet.setOuter();
            tet.clearInner();
        }
    }

    private void fireNodeWillBeAdded(Node node) {
        ++this._version;
        if (this._nnodeListeners > 0) {
            Object[] list = this._listeners.getListenerList();
            for (int i = list.length - 2; i >= 0; i -= 2) {
                if (list[i] != NodeListener.class) continue;
                ((NodeListener)list[i + 1]).nodeWillBeAdded(this, node);
            }
        }
    }

    private void fireNodeAdded(Node node) {
        ++this._version;
        if (this._nnodeListeners > 0) {
            Object[] list = this._listeners.getListenerList();
            for (int i = list.length - 2; i >= 0; i -= 2) {
                if (list[i] != NodeListener.class) continue;
                ((NodeListener)list[i + 1]).nodeAdded(this, node);
            }
        }
    }

    private void fireNodeWillBeRemoved(Node node) {
        ++this._version;
        if (this._nnodeListeners > 0) {
            Object[] list = this._listeners.getListenerList();
            for (int i = list.length - 2; i >= 0; i -= 2) {
                if (list[i] != NodeListener.class) continue;
                ((NodeListener)list[i + 1]).nodeWillBeRemoved(this, node);
            }
        }
    }

    private void fireNodeRemoved(Node node) {
        ++this._version;
        if (this._nnodeListeners > 0) {
            Object[] list = this._listeners.getListenerList();
            for (int i = list.length - 2; i >= 0; i -= 2) {
                if (list[i] != NodeListener.class) continue;
                ((NodeListener)list[i + 1]).nodeRemoved(this, node);
            }
        }
    }

    private void fireTetAdded(Tet tet) {
        ++this._version;
        if (this._ntetListeners > 0) {
            Object[] list = this._listeners.getListenerList();
            for (int i = list.length - 2; i >= 0; i -= 2) {
                if (list[i] != TetListener.class) continue;
                ((TetListener)list[i + 1]).tetAdded(this, tet);
            }
        }
    }

    private void fireTetRemoved(Tet tet) {
        ++this._version;
        if (this._ntetListeners > 0) {
            Object[] list = this._listeners.getListenerList();
            for (int i = list.length - 2; i >= 0; i -= 2) {
                if (list[i] != TetListener.class) continue;
                ((TetListener)list[i + 1]).tetRemoved(this, tet);
            }
        }
    }

    private void validate(Node node) {
        Check.state(node == node._prev._next, "node==node._prev._next");
        Check.state(node == node._next._prev, "node==node._next._prev");
        Tet tet = node.tet();
        if (this._troot != null) {
            Check.state(tet != null, "tet!=null");
            Check.state(node == tet.nodeA() || node == tet.nodeB() || node == tet.nodeC() || node == tet.nodeD(), "node is one of tet nodes");
        }
    }

    private void validate(Tet tet) {
        Node nd;
        Node nc;
        Node nb;
        Node na = tet.nodeA();
        if (!TetMesh.leftOfPlane(na, nb = tet.nodeB(), nc = tet.nodeC(), nd = tet.nodeD())) {
            TetMesh.trace("xa=" + na._x + " ya=" + na._y + " za=" + na._z);
            TetMesh.trace("xb=" + nb._x + " yb=" + nb._y + " zb=" + nb._z);
            TetMesh.trace("xc=" + nc._x + " yc=" + nc._y + " zc=" + nc._z);
            TetMesh.trace("xd=" + nd._x + " yd=" + nd._y + " zd=" + nd._z);
        }
        Check.state(TetMesh.leftOfPlane(na, nb, nc, nd), "leftOfPlane(na,nb,nc,nd)");
        this.validate(na);
        this.validate(nb);
        this.validate(nc);
        this.validate(nd);
        Tet ta = tet.tetA();
        Tet tb = tet.tetB();
        Tet tc = tet.tetC();
        Tet td = tet.tetD();
        if (ta != null) {
            Check.state(ta.tetNabor(tet.nodeNabor(ta)) == tet, "a nabor ok");
        }
        if (tb != null) {
            Check.state(tb.tetNabor(tet.nodeNabor(tb)) == tet, "b nabor ok");
        }
        if (tc != null) {
            Check.state(tc.tetNabor(tet.nodeNabor(tc)) == tet, "c nabor ok");
        }
        if (td != null) {
            Check.state(td.tetNabor(tet.nodeNabor(td)) == tet, "d nabor ok");
        }
    }

    private static final void trace(String s) {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.init();
        int format = in.readInt();
        if (format == 1) {
            int itet;
            this._version = in.readLong();
            int nnode = this._nnode = in.readInt();
            Node[] nodes = new Node[nnode];
            for (int inode = 0; inode < nnode; ++inode) {
                Node node = nodes[inode] = (Node)in.readObject();
                node._x = in.readDouble();
                node._y = in.readDouble();
                node._z = in.readDouble();
                int nvalue = in.readInt();
                Node.access$3502(node, new Object[nvalue]);
                for (int ivalue = 0; ivalue < nvalue; ++ivalue) {
                    Object value;
                    ((Node)node)._values[ivalue] = value = in.readObject();
                }
            }
            int ntet = this._ntet = in.readInt();
            Tet[] tets = new Tet[ntet];
            for (itet = 0; itet < ntet; ++itet) {
                Tet tet = tets[itet] = (Tet)in.readObject();
                tet._quality = -1.0;
            }
            this._nroot = (Node)in.readObject();
            for (int inode = 0; inode < nnode; ++inode) {
                Node node = nodes[inode];
                node._prev = (Node)in.readObject();
                node._next = (Node)in.readObject();
                node._tet = (Tet)in.readObject();
            }
            this._troot = (Tet)in.readObject();
            for (itet = 0; itet < ntet; ++itet) {
                Tet tet = tets[itet];
                tet._n0 = (Node)in.readObject();
                tet._n1 = (Node)in.readObject();
                tet._n2 = (Node)in.readObject();
                tet._n3 = (Node)in.readObject();
                tet._t0 = (Tet)in.readObject();
                tet._t1 = (Tet)in.readObject();
                tet._t2 = (Tet)in.readObject();
                tet._t3 = (Tet)in.readObject();
            }
        } else {
            throw new InvalidClassException("invalid external format");
        }
        this._outerEnabled = in.readBoolean();
        this._xminOuter = in.readDouble();
        this._yminOuter = in.readDouble();
        this._zminOuter = in.readDouble();
        this._xmaxOuter = in.readDouble();
        this._ymaxOuter = in.readDouble();
        this._zmaxOuter = in.readDouble();
        this._nnodeValues = in.readInt();
        this._lnodeValues = in.readInt();
        this._nodePropertyMaps = (Map)in.readObject();
        this.sampleNodes();
        try {
            this.validate();
        }
        catch (IllegalStateException ise) {
            throw new IOException(ise.getMessage());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Tet tet;
        int itet;
        out.writeInt(1);
        out.writeLong(this._version);
        int nnode = this._nnode;
        out.writeInt(nnode);
        Node[] nodes = new Node[nnode];
        NodeIterator ni = this.getNodes();
        for (int inode = 0; inode < nnode; ++inode) {
            Node node = nodes[inode] = ni.next();
            out.writeObject(node);
            out.writeDouble(node._x);
            out.writeDouble(node._y);
            out.writeDouble(node._z);
            int nvalue = node._values.length;
            out.writeInt(nvalue);
            for (int ivalue = 0; ivalue < nvalue; ++ivalue) {
                Object value = node._values[ivalue];
                out.writeObject(value instanceof Serializable ? value : null);
            }
        }
        int ntet = this._ntet;
        out.writeInt(ntet);
        Tet[] tets = new Tet[ntet];
        TetIterator ti = this.getTets();
        for (itet = 0; itet < ntet; ++itet) {
            tet = tets[itet] = ti.next();
            out.writeObject(tet);
        }
        out.writeObject(this._nroot);
        for (int inode = 0; inode < nnode; ++inode) {
            Node node = nodes[inode];
            out.writeObject(node._prev);
            out.writeObject(node._next);
            out.writeObject(node._tet);
        }
        out.writeObject(this._troot);
        for (itet = 0; itet < ntet; ++itet) {
            tet = tets[itet];
            out.writeObject(tet._n0);
            out.writeObject(tet._n1);
            out.writeObject(tet._n2);
            out.writeObject(tet._n3);
            out.writeObject(tet._t0);
            out.writeObject(tet._t1);
            out.writeObject(tet._t2);
            out.writeObject(tet._t3);
        }
        out.writeBoolean(this._outerEnabled);
        out.writeDouble(this._xminOuter);
        out.writeDouble(this._yminOuter);
        out.writeDouble(this._zminOuter);
        out.writeDouble(this._xmaxOuter);
        out.writeDouble(this._ymaxOuter);
        out.writeDouble(this._zmaxOuter);
        out.writeInt(this._nnodeValues);
        out.writeInt(this._lnodeValues);
        out.writeObject(this._nodePropertyMaps);
    }

    private void sampleNodes() {
        Random random = new Random();
        this._sampledNodes.clear();
        int nsamp = 2 * (int)MathPlus.pow((double)this._nnode, 0.25);
        Node node = this._nroot;
        while (this._sampledNodes.size() < nsamp) {
            int nskip = 1 + random.nextInt(this._nnode / 2);
            while (--nskip > 0) {
                node = node._next;
            }
            this._sampledNodes.add(node);
        }
    }

    private static final class EdgeSet {
        Node a;
        Node b;
        Node c;
        Tet nabc;
        private static final int MAX_SHIFT = 30;
        private static final int MAX_CAPACITY = 0x40000000;
        private Node[] _a;
        private Node[] _b;
        private Node[] _c;
        private Tet[] _nabc;
        private boolean[] _filled;
        private int _nmax;
        private int _n;
        private double _factor;
        private int _shift;
        private int _mask;
        private int _index;

        EdgeSet(int capacity, double factor) {
            if (capacity > 0x40000000) {
                capacity = 0x40000000;
            }
            if (factor <= 0.0) {
                factor = 1.0E-4;
            }
            if (factor >= 1.0) {
                factor = 0.9999;
            }
            this._nmax = 2;
            this._shift = 30;
            while (this._nmax < capacity) {
                --this._shift;
                this._nmax *= 2;
            }
            this._n = 0;
            this._factor = factor;
            this._mask = this._nmax - 1;
            this._a = new Node[this._nmax];
            this._b = new Node[this._nmax];
            this._c = new Node[this._nmax];
            this._nabc = new Tet[this._nmax];
            this._filled = new boolean[this._nmax];
        }

        void clear() {
            this._n = 0;
            for (int i = 0; i < this._nmax; ++i) {
                this._filled[i] = false;
            }
        }

        boolean add(Node a, Node b, Node c, Tet nabc) {
            this._index = this.indexOfMate(a, b);
            if (this._filled[this._index]) {
                this.setCurrent();
                this.remove(this._index);
                return false;
            }
            this._a[this._index] = a;
            this._b[this._index] = b;
            this._c[this._index] = c;
            this._nabc[this._index] = nabc;
            this._filled[this._index] = true;
            ++this._n;
            if ((double)this._n > (double)this._nmax * this._factor && this._nmax < 0x40000000) {
                this.doubleCapacity();
            }
            this.setCurrent();
            return true;
        }

        int size() {
            return this._n;
        }

        private int hash(Node a, Node b) {
            int key = a._hash ^ b._hash;
            return 1327217885 * key >> this._shift & this._mask;
        }

        private int indexOfMate(Node a, Node b) {
            int i = this.hash(a, b);
            while (this._filled[i]) {
                if (a == this._b[i] && b == this._a[i]) {
                    return i;
                }
                i = i - 1 & this._mask;
            }
            return i;
        }

        private void setCurrent() {
            this.a = this._a[this._index];
            this.b = this._b[this._index];
            this.c = this._c[this._index];
            this.nabc = this._nabc[this._index];
        }

        private void remove(int i) {
            --this._n;
            while (true) {
                int r;
                this._filled[i] = false;
                int j = i;
                do {
                    if (this._filled[i = i - 1 & this._mask]) continue;
                    return;
                } while (i <= (r = this.hash(this._a[i], this._b[i])) && r < j || r < j && j < i || j < i && i <= r);
                this._a[j] = this._a[i];
                this._b[j] = this._b[i];
                this._c[j] = this._c[i];
                this._nabc[j] = this._nabc[i];
                this._filled[j] = this._filled[i];
            }
        }

        private void doubleCapacity() {
            EdgeSet set = new EdgeSet(2 * this._nmax, this._factor);
            if (this._n > 0) {
                for (int i = 0; i < this._nmax; ++i) {
                    if (!this._filled[i]) continue;
                    set.add(this._a[i], this._b[i], this._c[i], this._nabc[i]);
                }
            }
            this._a = set._a;
            this._b = set._b;
            this._c = set._c;
            this._nabc = set._nabc;
            this._filled = set._filled;
            this._nmax = set._nmax;
            this._n = set._n;
            this._factor = set._factor;
            this._shift = set._shift;
            this._mask = set._mask;
            this._index = set._index;
        }
    }

    private static final class FaceSet {
        Node a;
        Node b;
        Node c;
        Node d;
        Tet abcd;
        private static final int MAX_SHIFT = 30;
        private static final int MAX_CAPACITY = 0x40000000;
        private Node[] _a;
        private Node[] _b;
        private Node[] _c;
        private Node[] _d;
        private Tet[] _abcd;
        private boolean[] _filled;
        private int _nmax;
        private int _n;
        private double _factor;
        private int _shift;
        private int _mask;
        private int _index;

        FaceSet(int capacity, double factor) {
            if (capacity > 0x40000000) {
                capacity = 0x40000000;
            }
            if (factor <= 0.0) {
                factor = 1.0E-4;
            }
            if (factor >= 1.0) {
                factor = 0.9999;
            }
            this._nmax = 2;
            this._shift = 30;
            while (this._nmax < capacity) {
                --this._shift;
                this._nmax *= 2;
            }
            this._n = 0;
            this._factor = factor;
            this._mask = this._nmax - 1;
            this._a = new Node[this._nmax];
            this._b = new Node[this._nmax];
            this._c = new Node[this._nmax];
            this._d = new Node[this._nmax];
            this._abcd = new Tet[this._nmax];
            this._filled = new boolean[this._nmax];
        }

        void clear() {
            this._n = 0;
            for (int i = 0; i < this._nmax; ++i) {
                this._filled[i] = false;
            }
        }

        boolean add(Tet tet, Node node) {
            if (node == tet._n0) {
                return this.add(tet._n1, tet._n3, tet._n2, node, tet);
            }
            if (node == tet._n1) {
                return this.add(tet._n2, tet._n3, tet._n0, node, tet);
            }
            if (node == tet._n2) {
                return this.add(tet._n3, tet._n1, tet._n0, node, tet);
            }
            if (node == tet._n3) {
                return this.add(tet._n0, tet._n1, tet._n2, node, tet);
            }
            assert (false) : "node is referenced by tet";
            return false;
        }

        boolean addMate(Tet tet, Node node) {
            Node nodeNabor;
            Tet tetNabor = tet.tetNabor(node);
            Node node2 = nodeNabor = tetNabor != null ? tet.nodeNabor(tetNabor) : null;
            if (node == tet._n0) {
                return this.add(tet._n1, tet._n2, tet._n3, nodeNabor, tetNabor);
            }
            if (node == tet._n1) {
                return this.add(tet._n3, tet._n2, tet._n0, nodeNabor, tetNabor);
            }
            if (node == tet._n2) {
                return this.add(tet._n3, tet._n0, tet._n1, nodeNabor, tetNabor);
            }
            if (node == tet._n3) {
                return this.add(tet._n1, tet._n0, tet._n2, nodeNabor, tetNabor);
            }
            assert (false) : "node is referenced by tet";
            return false;
        }

        boolean remove() {
            if (this._n > 0) {
                int start = this._index;
                while (this._index < this._nmax) {
                    if (this._filled[this._index]) {
                        this.setCurrent();
                        this.remove(this._index);
                        return true;
                    }
                    ++this._index;
                }
                this._index = 0;
                while (this._index < start) {
                    if (this._filled[this._index]) {
                        this.setCurrent();
                        this.remove(this._index);
                        return true;
                    }
                    ++this._index;
                }
            }
            return false;
        }

        boolean isEmpty() {
            return this._n > 0;
        }

        boolean first() {
            this._index = -1;
            return this.next();
        }

        boolean next() {
            ++this._index;
            while (this._index < this._nmax) {
                if (this._filled[this._index]) {
                    this.setCurrent();
                    return true;
                }
                ++this._index;
            }
            return false;
        }

        private int hash(Node a, Node b, Node c) {
            int key = a._hash ^ b._hash ^ c._hash;
            return 1327217885 * key >> this._shift & this._mask;
        }

        private int indexOfMate(Node a, Node b, Node c) {
            int i = this.hash(a, b, c);
            while (this._filled[i]) {
                Node ai = this._a[i];
                Node bi = this._b[i];
                Node ci = this._c[i];
                if (a == ai && b == ci && c == bi || a == bi && b == ai && c == ci || a == ci && b == bi && c == ai) {
                    return i;
                }
                i = i - 1 & this._mask;
            }
            return i;
        }

        private void setCurrent() {
            this.a = this._a[this._index];
            this.b = this._b[this._index];
            this.c = this._c[this._index];
            this.d = this._d[this._index];
            this.abcd = this._abcd[this._index];
        }

        private boolean add(Node a, Node b, Node c, Node d, Tet abcd) {
            this._index = this.indexOfMate(a, b, c);
            if (this._filled[this._index]) {
                this.setCurrent();
                this.remove(this._index);
                return false;
            }
            this._a[this._index] = a;
            this._b[this._index] = b;
            this._c[this._index] = c;
            this._d[this._index] = d;
            this._abcd[this._index] = abcd;
            this._filled[this._index] = true;
            ++this._n;
            if ((double)this._n > (double)this._nmax * this._factor && this._nmax < 0x40000000) {
                this.doubleCapacity();
            }
            this.setCurrent();
            return true;
        }

        private void remove(int i) {
            --this._n;
            while (true) {
                int r;
                this._filled[i] = false;
                int j = i;
                do {
                    if (this._filled[i = i - 1 & this._mask]) continue;
                    return;
                } while (i <= (r = this.hash(this._a[i], this._b[i], this._c[i])) && r < j || r < j && j < i || j < i && i <= r);
                this._a[j] = this._a[i];
                this._b[j] = this._b[i];
                this._c[j] = this._c[i];
                this._d[j] = this._d[i];
                this._abcd[j] = this._abcd[i];
                this._filled[j] = this._filled[i];
            }
        }

        private void doubleCapacity() {
            FaceSet set = new FaceSet(2 * this._nmax, this._factor);
            if (this._n > 0) {
                for (int i = 0; i < this._nmax; ++i) {
                    if (!this._filled[i]) continue;
                    set.add(this._a[i], this._b[i], this._c[i], this._d[i], this._abcd[i]);
                }
            }
            this._a = set._a;
            this._b = set._b;
            this._c = set._c;
            this._d = set._d;
            this._abcd = set._abcd;
            this._filled = set._filled;
            this._nmax = set._nmax;
            this._n = set._n;
            this._factor = set._factor;
            this._shift = set._shift;
            this._mask = set._mask;
            this._index = set._index;
        }
    }

    private static class NodePropertyMapInternal
    implements NodePropertyMap {
        private int _index;

        public Object get(Node node) {
            Object[] values = node._values;
            return values[this._index];
        }

        public void put(Node node, Object value) {
            Object[] values = node._values;
            values[this._index] = value;
        }

        NodePropertyMapInternal(int index) {
            this._index = index;
        }
    }

    public static interface TetListener
    extends EventListener {
        public void tetAdded(TetMesh var1, Tet var2);

        public void tetRemoved(TetMesh var1, Tet var2);
    }

    public static interface NodeListener
    extends EventListener {
        public void nodeWillBeAdded(TetMesh var1, Node var2);

        public void nodeAdded(TetMesh var1, Node var2);

        public void nodeWillBeRemoved(TetMesh var1, Node var2);

        public void nodeRemoved(TetMesh var1, Node var2);
    }

    public static interface NodePropertyMap
    extends Serializable {
        public Object get(Node var1);

        public void put(Node var1, Object var2);
    }

    public static class PointLocation {
        private Node _node;
        private Edge _edge;
        private Face _face;
        private Tet _tet;
        private boolean _inside;

        public boolean isOnNode() {
            return this._node != null;
        }

        public boolean isOnEdge() {
            return this._edge != null;
        }

        public boolean isOnFace() {
            return this._face != null;
        }

        public boolean isInside() {
            return this._inside;
        }

        public boolean isOutside() {
            return !this._inside;
        }

        public Node node() {
            return this._node;
        }

        public Edge edge() {
            return this._edge;
        }

        public Face face() {
            return this._face;
        }

        public Tet tet() {
            return this._tet;
        }

        private PointLocation(Tet tet) {
            this._tet = tet;
            this._inside = true;
        }

        private PointLocation(Tet tet, boolean inside) {
            this._tet = tet;
            this._inside = inside;
        }

        private PointLocation(Node node) {
            this._tet = node._tet;
            this._node = node;
            this._inside = true;
        }

        private PointLocation(Face face) {
            this._tet = face._tetLeft;
            this._face = face;
            this._inside = true;
        }

        private PointLocation(Edge edge) {
            this._tet = edge._tet;
            this._edge = edge;
            this._inside = true;
        }
    }

    public static class NodeStepList {
        private int _n = 0;
        private Node[] _a = new Node[64];
        private int[] _b = new int[64];

        public final void add(Node node, int step) {
            if (this._n == this._a.length) {
                Node[] s = new Node[this._a.length * 2];
                int[] t = new int[this._a.length * 2];
                System.arraycopy(this._a, 0, s, 0, this._n);
                System.arraycopy(this._b, 0, t, 0, this._n);
                this._a = s;
                this._b = t;
            }
            this._a[this._n] = node;
            this._b[this._n] = step;
            ++this._n;
        }

        public final void trim() {
            if (this._n < this._a.length) {
                Node[] s = new Node[this._n];
                int[] t = new int[this._n];
                System.arraycopy(this._a, 0, s, 0, this._n);
                System.arraycopy(this._b, 0, t, 0, this._n);
                this._a = s;
                this._b = t;
            }
        }

        public final void clear() {
            this._n = 0;
        }

        public final int nnode() {
            return this._n;
        }

        public final Node[] nodes() {
            return this._a;
        }

        public final int[] steps() {
            return this._b;
        }
    }

    public static class FaceList {
        private int _n = 0;
        private Face[] _a = new Face[64];

        public final void add(Face face) {
            if (this._n == this._a.length) {
                Face[] t = new Face[this._a.length * 2];
                System.arraycopy(this._a, 0, t, 0, this._n);
                this._a = t;
            }
            this._a[this._n++] = face;
        }

        public final Face remove(int index) {
            Face face = this._a[index];
            --this._n;
            if (this._n > index) {
                System.arraycopy(this._a, index + 1, this._a, index, this._n - index);
            }
            return face;
        }

        public final Face[] trim() {
            if (this._n < this._a.length) {
                Face[] t = new Face[this._n];
                System.arraycopy(this._a, 0, t, 0, this._n);
                this._a = t;
            }
            return this._a;
        }

        public final void clear() {
            this._n = 0;
        }

        public final int nface() {
            return this._n;
        }

        public final Face[] faces() {
            return this._a;
        }
    }

    public static class EdgeList {
        private int _n = 0;
        private Edge[] _a = new Edge[64];

        public final void add(Edge edge) {
            if (this._n == this._a.length) {
                Edge[] t = new Edge[this._a.length * 2];
                System.arraycopy(this._a, 0, t, 0, this._n);
                this._a = t;
            }
            this._a[this._n++] = edge;
        }

        public final Edge remove(int index) {
            Edge edge = this._a[index];
            --this._n;
            if (this._n > index) {
                System.arraycopy(this._a, index + 1, this._a, index, this._n - index);
            }
            return edge;
        }

        public final Edge[] trim() {
            if (this._n < this._a.length) {
                Edge[] t = new Edge[this._n];
                System.arraycopy(this._a, 0, t, 0, this._n);
                this._a = t;
            }
            return this._a;
        }

        public final void clear() {
            this._n = 0;
        }

        public final int nedge() {
            return this._n;
        }

        public final Edge[] edges() {
            return this._a;
        }
    }

    public static class TetList {
        private int _n = 0;
        private Tet[] _a = new Tet[64];

        public final void add(Tet tet) {
            if (this._n == this._a.length) {
                Tet[] t = new Tet[this._a.length * 2];
                System.arraycopy(this._a, 0, t, 0, this._n);
                this._a = t;
            }
            this._a[this._n++] = tet;
        }

        public final Tet remove(int index) {
            Tet tet = this._a[index];
            --this._n;
            if (this._n > index) {
                System.arraycopy(this._a, index + 1, this._a, index, this._n - index);
            }
            return tet;
        }

        public final Tet[] trim() {
            if (this._n < this._a.length) {
                Tet[] t = new Tet[this._n];
                System.arraycopy(this._a, 0, t, 0, this._n);
                this._a = t;
            }
            return this._a;
        }

        public final void clear() {
            this._n = 0;
        }

        public final int ntet() {
            return this._n;
        }

        public final Tet[] tets() {
            return this._a;
        }
    }

    public static class NodeList {
        private int _n = 0;
        private Node[] _a = new Node[64];

        public final void add(Node node) {
            if (this._n == this._a.length) {
                Node[] t = new Node[this._a.length * 2];
                System.arraycopy(this._a, 0, t, 0, this._n);
                this._a = t;
            }
            this._a[this._n++] = node;
        }

        public final Node remove(int index) {
            Node node = this._a[index];
            --this._n;
            if (this._n > index) {
                System.arraycopy(this._a, index + 1, this._a, index, this._n - index);
            }
            return node;
        }

        public final Node[] trim() {
            if (this._n < this._a.length) {
                Node[] t = new Node[this._n];
                System.arraycopy(this._a, 0, t, 0, this._n);
                this._a = t;
            }
            return this._a;
        }

        public final void clear() {
            this._n = 0;
        }

        public final int nnode() {
            return this._n;
        }

        public final Node[] nodes() {
            return this._a;
        }
    }

    public static interface FaceIterator {
        public boolean hasNext();

        public Face next();
    }

    public static class Face {
        private Node _a;
        private Node _b;
        private Node _c;
        private Tet _tetLeft;
        private Tet _tetRight;
        private Node _nodeLeft;
        private Node _nodeRight;

        public Face(Node a, Node b, Node c) {
            this(a, b, c, null);
        }

        public Face(Node a, Node b, Node c, Tet abcd) {
            Node d = abcd != null ? TetMesh.otherNode(abcd, a, b, c) : null;
            Check.argument(abcd == null || d != null, "tet references nodes");
            this._a = a;
            this._b = b;
            this._c = c;
            if (d != null) {
                if (TetMesh.nodesInOrder(abcd, a, b, c, d)) {
                    this._tetLeft = abcd;
                    this._nodeLeft = d;
                    this._tetRight = abcd.tetNabor(d);
                    this._nodeRight = this._tetRight != null ? abcd.nodeNabor(this._tetRight) : null;
                } else {
                    this._tetRight = abcd;
                    this._nodeRight = d;
                    this._tetLeft = abcd.tetNabor(d);
                    this._nodeLeft = this._tetLeft != null ? abcd.nodeNabor(this._tetLeft) : null;
                }
            }
        }

        public final Node nodeA() {
            return this._a;
        }

        public final Node nodeB() {
            return this._b;
        }

        public final Node nodeC() {
            return this._c;
        }

        public Tet tetLeft() {
            return this._tetLeft;
        }

        public Tet tetRight() {
            return this._tetRight;
        }

        public Node nodeLeft() {
            return this._nodeLeft;
        }

        public Node nodeRight() {
            return this._nodeRight;
        }

        public Face mate() {
            return new Face(this._b, this._a, this._c, this._tetRight, this._nodeRight, this._tetLeft, this._nodeLeft);
        }

        public boolean isVisibleFromPoint(double x, double y, double z) {
            return Geometry.leftOfPlane(this._a._x, this._a._y, this._a._z, this._b._x, this._b._y, this._b._z, this._c._x, this._c._y, this._c._z, x, y, z) < 0.0;
        }

        public double centerCircle(double[] c) {
            double xa = this._a._x;
            double ya = this._a._y;
            double za = this._a._z;
            double xb = this._b._x;
            double yb = this._b._y;
            double zb = this._b._z;
            double xc = this._c._x;
            double yc = this._c._y;
            double zc = this._c._z;
            Geometry.centerCircle3D(xa, ya, za, xb, yb, zb, xc, yc, zc, c);
            double dx = c[0] - xc;
            double dy = c[1] - yc;
            double dz = c[2] - zc;
            return dx * dx + dy * dy + dz * dz;
        }

        public double[] centerCircle() {
            double[] c = new double[3];
            this.centerCircle(c);
            return c;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object != null && object.getClass() == this.getClass()) {
                Face face = (Face)object;
                return this._a == face._a && this._b == face._b && this._c == face._c || this._a == face._b && this._b == face._c && this._c == face._a || this._a == face._c && this._b == face._a && this._c == face._b;
            }
            return false;
        }

        public int hashCode() {
            return this._a._hash ^ this._b._hash ^ this._c._hash;
        }

        private Face(Node a, Node b, Node c, Tet tetLeft, Node nodeLeft, Tet tetRight, Node nodeRight) {
            this._a = a;
            this._b = b;
            this._c = c;
            this._tetLeft = tetLeft;
            this._tetRight = tetRight;
            this._nodeLeft = nodeLeft;
            this._nodeRight = nodeRight;
        }

        private Face(Tet tetLeft, Node nodeLeft) {
            this.initLeft(tetLeft, nodeLeft);
            this._tetLeft = tetLeft;
            this._nodeLeft = nodeLeft;
            this._tetRight = tetLeft.tetNabor(nodeLeft);
            this._nodeRight = this._tetRight != null ? this._tetLeft.nodeNabor(this._tetRight) : null;
        }

        private Face(Tet tetLeft, Node nodeLeft, Tet tetRight, Node nodeRight) {
            if (tetLeft != null) {
                this.initLeft(tetLeft, nodeLeft);
            } else if (tetRight != null) {
                this.initRight(tetRight, nodeRight);
            } else assert (false) : "either tetLeft or tetRight is not null";
            this._tetLeft = tetLeft;
            this._tetRight = tetRight;
            this._nodeLeft = nodeLeft;
            this._nodeRight = nodeRight;
        }

        private void initLeft(Tet tetLeft, Node nodeLeft) {
            if (nodeLeft == tetLeft._n0) {
                this._a = tetLeft._n1;
                this._b = tetLeft._n3;
                this._c = tetLeft._n2;
            } else if (nodeLeft == tetLeft._n1) {
                this._a = tetLeft._n2;
                this._b = tetLeft._n3;
                this._c = tetLeft._n0;
            } else if (nodeLeft == tetLeft._n2) {
                this._a = tetLeft._n3;
                this._b = tetLeft._n1;
                this._c = tetLeft._n0;
            } else if (nodeLeft == tetLeft._n3) {
                this._a = tetLeft._n0;
                this._b = tetLeft._n1;
                this._c = tetLeft._n2;
            } else assert (false) : "nodeLeft referenced by tetLeft";
        }

        private void initRight(Tet tetRight, Node nodeRight) {
            if (nodeRight == tetRight._n0) {
                this._a = tetRight._n1;
                this._b = tetRight._n2;
                this._c = tetRight._n3;
            } else if (nodeRight == tetRight._n1) {
                this._a = tetRight._n2;
                this._b = tetRight._n0;
                this._c = tetRight._n3;
            } else if (nodeRight == tetRight._n2) {
                this._a = tetRight._n3;
                this._b = tetRight._n0;
                this._c = tetRight._n1;
            } else if (nodeRight == tetRight._n3) {
                this._a = tetRight._n0;
                this._b = tetRight._n2;
                this._c = tetRight._n1;
            } else assert (false) : "nodeRight referenced by tetRight";
        }
    }

    public static interface EdgeIterator {
        public boolean hasNext();

        public Edge next();
    }

    public static class Edge {
        private Node _a;
        private Node _b;
        private Tet _tet;

        public Edge(Node a, Node b) {
            this(a, b, null);
        }

        public Edge(Node a, Node b, Tet abcd) {
            Check.argument(abcd == null || abcd.references(a, b), "tet references nodes");
            this._a = a;
            this._b = b;
            this._tet = abcd;
        }

        public Node nodeA() {
            return this._a;
        }

        public Node nodeB() {
            return this._b;
        }

        public Tet tet() {
            return this._tet;
        }

        public Edge mate() {
            return new Edge(this._b, this._a, this._tet);
        }

        public double midpoint(double[] c) {
            double xa = this._a._x;
            double ya = this._a._y;
            double za = this._a._z;
            double xb = this._b._x;
            double yb = this._b._y;
            double zb = this._b._z;
            c[0] = 0.5 * (xa + xb);
            c[1] = 0.5 * (ya + yb);
            c[2] = 0.5 * (za + zb);
            double dx = c[0] - xb;
            double dy = c[1] - yb;
            double dz = c[2] - zb;
            return dx * dx + dy * dy + dz * dz;
        }

        public double[] midpoint() {
            double[] c = new double[3];
            this.midpoint(c);
            return c;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object != null && object.getClass() == this.getClass()) {
                Edge edge = (Edge)object;
                return this._a == edge._a && this._b == edge._b;
            }
            return false;
        }

        public int hashCode() {
            return this._a._hash ^ this._b._hash;
        }

        private Edge(Tet abcd, Node a, Node b) {
            this._a = a;
            this._b = b;
            this._tet = abcd;
        }
    }

    public static interface TetIterator {
        public boolean hasNext();

        public Tet next();
    }

    public static class Tet
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int index;
        public Object data;
        private static final int INNER_BIT = 1;
        private static final int OUTER_BIT = 2;
        private static final int CENTER_BIT = 4;
        private transient Node _n0;
        private transient Node _n1;
        private transient Node _n2;
        private transient Node _n3;
        private transient Tet _t0;
        private transient Tet _t1;
        private transient Tet _t2;
        private transient Tet _t3;
        private transient int _mark = 0;
        private transient int _bits = 0;
        private transient double _quality = -1.0;
        private transient double _xc;
        private transient double _yc;
        private transient double _zc;
        private static double QUALITY_VOL_LONGEST_EDGE_FACTOR = 2.0 / MathPlus.sqrt(2.0);

        public final Node nodeA() {
            return this._n0;
        }

        public final Node nodeB() {
            return this._n1;
        }

        public final Node nodeC() {
            return this._n2;
        }

        public final Node nodeD() {
            return this._n3;
        }

        public final Tet tetA() {
            return this._t0;
        }

        public final Tet tetB() {
            return this._t1;
        }

        public final Tet tetC() {
            return this._t2;
        }

        public final Tet tetD() {
            return this._t3;
        }

        public final Node nodeNearest(float x, float y, float z) {
            double d0 = TetMesh.distanceSquared(this._n0, x, y, z);
            double d1 = TetMesh.distanceSquared(this._n1, x, y, z);
            double d2 = TetMesh.distanceSquared(this._n2, x, y, z);
            double d3 = TetMesh.distanceSquared(this._n3, x, y, z);
            double dmin = d0;
            Node nmin = this._n0;
            if (d1 < dmin) {
                dmin = d1;
                nmin = this._n1;
            }
            if (d2 < dmin) {
                dmin = d2;
                nmin = this._n2;
            }
            if (d3 < dmin) {
                dmin = d3;
                nmin = this._n3;
            }
            return nmin;
        }

        public final Tet tetNabor(Node node) {
            if (node == this._n0) {
                return this._t0;
            }
            if (node == this._n1) {
                return this._t1;
            }
            if (node == this._n2) {
                return this._t2;
            }
            if (node == this._n3) {
                return this._t3;
            }
            Check.argument(false, "node is referenced by tet");
            return null;
        }

        public final Node nodeNabor(Tet tetNabor) {
            if (tetNabor._t0 == this) {
                return tetNabor._n0;
            }
            if (tetNabor._t1 == this) {
                return tetNabor._n1;
            }
            if (tetNabor._t2 == this) {
                return tetNabor._n2;
            }
            if (tetNabor._t3 == this) {
                return tetNabor._n3;
            }
            Check.argument(false, "tetNabor is a nabor of tet");
            return null;
        }

        public final Node nodeNabor(Node node) {
            Tet tetNabor = this.tetNabor(node);
            return tetNabor != null ? this.nodeNabor(tetNabor) : null;
        }

        public double centerSphere(double[] c) {
            if (this.hasCenter()) {
                c[0] = this._xc;
                c[1] = this._yc;
                c[2] = this._zc;
            } else {
                double x0 = this._n0._x;
                double y0 = this._n0._y;
                double z0 = this._n0._z;
                double x1 = this._n1._x;
                double y1 = this._n1._y;
                double z1 = this._n1._z;
                double x2 = this._n2._x;
                double y2 = this._n2._y;
                double z2 = this._n2._z;
                double x3 = this._n3._x;
                double y3 = this._n3._y;
                double z3 = this._n3._z;
                Geometry.centerSphere(x0, y0, z0, x1, y1, z1, x2, y2, z2, x3, y3, z3, c);
                this.setCenter(c[0], c[1], c[2]);
            }
            double dx = this._xc - this._n3._x;
            double dy = this._yc - this._n3._y;
            double dz = this._zc - this._n3._z;
            return dx * dx + dy * dy + dz * dz;
        }

        public double[] centerSphere() {
            double[] c = new double[3];
            this.centerSphere(c);
            return c;
        }

        public double quality() {
            if (this._quality < 0.0) {
                this._quality = Tet.quality(this._n0, this._n1, this._n2, this._n3);
            }
            return this._quality;
        }

        public boolean references(Node node) {
            return node == this._n0 || node == this._n1 || node == this._n2 || node == this._n3;
        }

        public boolean references(Node na, Node nb) {
            if (na == this._n0) {
                return nb == this._n1 || nb == this._n2 || nb == this._n3;
            }
            if (na == this._n1) {
                return nb == this._n0 || nb == this._n2 || nb == this._n3;
            }
            if (na == this._n2) {
                return nb == this._n0 || nb == this._n1 || nb == this._n3;
            }
            if (na == this._n3) {
                return nb == this._n0 || nb == this._n1 || nb == this._n2;
            }
            return false;
        }

        public boolean references(Node na, Node nb, Node nc) {
            if (na == this._n0) {
                if (nb == this._n1) {
                    return nc == this._n2 || nc == this._n3;
                }
                if (nb == this._n2) {
                    return nc == this._n1 || nc == this._n3;
                }
                if (nb == this._n3) {
                    return nc == this._n1 || nc == this._n2;
                }
                return false;
            }
            if (na == this._n1) {
                if (nb == this._n0) {
                    return nc == this._n2 || nc == this._n3;
                }
                if (nb == this._n2) {
                    return nc == this._n0 || nc == this._n3;
                }
                if (nb == this._n3) {
                    return nc == this._n0 || nc == this._n2;
                }
                return false;
            }
            if (na == this._n2) {
                if (nb == this._n0) {
                    return nc == this._n1 || nc == this._n3;
                }
                if (nb == this._n1) {
                    return nc == this._n0 || nc == this._n3;
                }
                if (nb == this._n3) {
                    return nc == this._n0 || nc == this._n1;
                }
                return false;
            }
            if (na == this._n3) {
                if (nb == this._n0) {
                    return nc == this._n1 || nc == this._n2;
                }
                if (nb == this._n1) {
                    return nc == this._n0 || nc == this._n2;
                }
                if (nb == this._n2) {
                    return nc == this._n0 || nc == this._n1;
                }
                return false;
            }
            return false;
        }

        public boolean references(Node na, Node nb, Node nc, Node nd) {
            if (na == this._n0) {
                if (nb == this._n1) {
                    if (nc == this._n2) {
                        return nd == this._n3;
                    }
                    if (nc == this._n3) {
                        return nd == this._n2;
                    }
                    return false;
                }
                if (nb == this._n2) {
                    if (nc == this._n1) {
                        return nd == this._n3;
                    }
                    if (nc == this._n3) {
                        return nd == this._n1;
                    }
                    return false;
                }
                if (nb == this._n3) {
                    if (nc == this._n1) {
                        return nd == this._n2;
                    }
                    if (nc == this._n2) {
                        return nd == this._n1;
                    }
                    return false;
                }
                return false;
            }
            if (na == this._n1) {
                if (nb == this._n0) {
                    if (nc == this._n2) {
                        return nd == this._n3;
                    }
                    if (nc == this._n3) {
                        return nd == this._n2;
                    }
                    return false;
                }
                if (nb == this._n2) {
                    if (nc == this._n0) {
                        return nd == this._n3;
                    }
                    if (nc == this._n3) {
                        return nd == this._n0;
                    }
                    return false;
                }
                if (nb == this._n3) {
                    if (nc == this._n0) {
                        return nd == this._n2;
                    }
                    if (nc == this._n2) {
                        return nd == this._n0;
                    }
                    return false;
                }
                return false;
            }
            if (na == this._n2) {
                if (nb == this._n0) {
                    if (nc == this._n1) {
                        return nd == this._n3;
                    }
                    if (nc == this._n3) {
                        return nd == this._n1;
                    }
                    return false;
                }
                if (nb == this._n1) {
                    if (nc == this._n0) {
                        return nd == this._n3;
                    }
                    if (nc == this._n3) {
                        return nd == this._n0;
                    }
                    return false;
                }
                if (nb == this._n3) {
                    if (nc == this._n0) {
                        return nd == this._n1;
                    }
                    if (nc == this._n1) {
                        return nd == this._n0;
                    }
                    return false;
                }
                return false;
            }
            if (na == this._n3) {
                if (nb == this._n0) {
                    if (nc == this._n1) {
                        return nd == this._n2;
                    }
                    if (nc == this._n2) {
                        return nd == this._n1;
                    }
                    return false;
                }
                if (nb == this._n1) {
                    if (nc == this._n0) {
                        return nd == this._n2;
                    }
                    if (nc == this._n2) {
                        return nd == this._n0;
                    }
                    return false;
                }
                if (nb == this._n2) {
                    if (nc == this._n0) {
                        return nd == this._n1;
                    }
                    if (nc == this._n1) {
                        return nd == this._n0;
                    }
                    return false;
                }
                return false;
            }
            return false;
        }

        private Tet(Node n0, Node n1, Node n2, Node n3) {
            this.init(n0, n1, n2, n3);
        }

        private void init(Node n0, Node n1, Node n2, Node n3) {
            this._n0 = n0;
            this._n1 = n1;
            this._n2 = n2;
            this._n3 = n3;
            this._n0._tet = this;
            this._n1._tet = this;
            this._n2._tet = this;
            this._n3._tet = this;
            this._t0 = null;
            this._t1 = null;
            this._t2 = null;
            this._t3 = null;
            this._mark = 0;
            this._bits = 0;
            this._quality = -1.0;
        }

        private final void setInner() {
            this._bits |= 1;
        }

        private final void clearInner() {
            this._bits &= 0xFFFFFFFE;
        }

        private final boolean isInner() {
            return (this._bits & 1) != 0;
        }

        private final void setOuter() {
            this._bits |= 2;
        }

        private final void clearOuter() {
            this._bits &= 0xFFFFFFFD;
        }

        private final boolean isOuter() {
            return (this._bits & 2) != 0;
        }

        private final void setCenter(double xc, double yc, double zc) {
            this._xc = xc;
            this._yc = yc;
            this._zc = zc;
            this._bits |= 4;
        }

        private final boolean hasCenter() {
            return (this._bits & 4) != 0;
        }

        private boolean intersectsPlane(double a, double b, double c, double d) {
            double s3;
            double s2;
            double s1;
            int nn = 0;
            int np = 0;
            double s0 = a * this._n0._x + b * this._n0._y + c * this._n0._z + d;
            if (s0 < 0.0) {
                ++nn;
            }
            if (s0 > 0.0) {
                ++np;
            }
            if ((s1 = a * this._n1._x + b * this._n1._y + c * this._n1._z + d) < 0.0) {
                ++nn;
            }
            if (s1 > 0.0) {
                ++np;
            }
            if ((s2 = a * this._n2._x + b * this._n2._y + c * this._n2._z + d) < 0.0) {
                ++nn;
            }
            if (s2 > 0.0) {
                ++np;
            }
            if ((s3 = a * this._n3._x + b * this._n3._y + c * this._n3._z + d) < 0.0) {
                ++nn;
            }
            if (s3 > 0.0) {
                ++np;
            }
            return nn < 4 && np < 4;
        }

        private static double quality(Node na, Node nb, Node nc, Node nd) {
            return Tet.qualityVolumeOverLongestEdge(na, nb, nc, nd);
        }

        private static double qualityVolumeOverLongestEdge(Node na, Node nb, Node nc, Node nd) {
            double quality;
            double xa = na._x;
            double ya = na._y;
            double za = na._z;
            double xb = nb._x;
            double yb = nb._y;
            double zb = nb._z;
            double xc = nc._x;
            double yc = nc._y;
            double zc = nc._z;
            double xd = nd._x;
            double yd = nd._y;
            double zd = nd._z;
            double xab = xa - xb;
            double yab = ya - yb;
            double zab = za - zb;
            double xac = xa - xc;
            double yac = ya - yc;
            double zac = za - zc;
            double xbc = xb - xc;
            double ybc = yb - yc;
            double zbc = zb - zc;
            double xad = xa - xd;
            double yad = ya - yd;
            double zad = za - zd;
            double xbd = xb - xd;
            double ybd = yb - yd;
            double zbd = zb - zd;
            double xcd = xc - xd;
            double ycd = yc - yd;
            double zcd = zc - zd;
            double det = xad * (ybd * zcd - zbd * ycd) + xbd * (ycd * zad - zcd * yad) + xcd * (yad * zbd - zad * ybd);
            double dab = xab * xab + yab * yab + zab * zab;
            double dac = xac * xac + yac * yac + zac * zac;
            double dbc = xbc * xbc + ybc * ybc + zbc * zbc;
            double dad = xad * xad + yad * yad + zad * zad;
            double dbd = xbd * xbd + ybd * ybd + zbd * zbd;
            double dcd = xcd * xcd + ycd * ycd + zcd * zcd;
            double dmx = dab;
            if (dac > dmx) {
                dmx = dac;
            }
            if (dbc > dmx) {
                dmx = dbc;
            }
            if (dad > dmx) {
                dmx = dad;
            }
            if (dbd > dmx) {
                dmx = dbd;
            }
            if (dcd > dmx) {
                dmx = dcd;
            }
            if ((quality = QUALITY_VOL_LONGEST_EDGE_FACTOR * det / ((dmx = MathPlus.sqrt(dmx)) * dmx * dmx)) < 0.0) {
                quality = -quality;
            }
            if (quality > 1.0) {
                quality = 1.0;
            }
            return quality;
        }
    }

    public static interface NodeIterator {
        public boolean hasNext();

        public Node next();
    }

    public static class Node
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int index;
        public Object data;
        private transient double _x;
        private transient double _y;
        private transient double _z;
        private transient Node _prev = null;
        private transient Node _next = null;
        private transient Tet _tet = null;
        private transient int _mark = 0;
        private transient int _hash = System.identityHashCode(this);
        private transient Object[] _values;

        public Node(float x, float y, float z) {
            this.setPosition(x, y, z);
        }

        public final float x() {
            return (float)this._x;
        }

        public final float y() {
            return (float)this._y;
        }

        public final float z() {
            return (float)this._z;
        }

        public final Tet tet() {
            return this._tet;
        }

        public String toString() {
            return "(" + this.x() + "," + this.y() + "," + this.z() + ")";
        }

        private static double perturb(float x, float p) {
            int m = Integer.MAX_VALUE;
            int i = Float.floatToIntBits(p);
            int j = 0;
            int k = 0;
            while (k < 32) {
                j |= i & 1;
                ++k;
                i >>= 1;
                j <<= 1;
            }
            double xp = x != 0.0f ? (double)x : 1.4012984643248171E-46;
            assert ((float)(xp *= 1.0 + (double)j / 2.147483647E9 * 0.1 * 1.1920928955078125E-7) == x);
            return xp;
        }

        private void setPosition(float x, float y, float z) {
            assert (this._tet == null);
            this._x = Node.perturb(x, 0.450599f * y + 0.374507f * z);
            this._y = Node.perturb(y, 0.298721f * x + 0.983298f * z);
            this._z = Node.perturb(z, 0.653901f * x + 0.598723f * y);
        }

        static /* synthetic */ Object[] access$3502(Node x0, Object[] x1) {
            x0._values = x1;
            return x1;
        }
    }
}

