/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.lapack.test;

import edu.mines.jtk.lapack.DMatrix;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class DMatrixTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(DMatrixTest.class);
        TestRunner.run((Test)suite);
    }

    public void testConstruct() {
        int m = 3;
        int n = 4;
        DMatrix z1 = new DMatrix(m, n);
        DMatrix z2 = new DMatrix(m, n, 0.0);
        DMatrixTest.assertEqualExact(z1, z2);
        DMatrixTest.assertTrue((boolean)z1.equals(z2));
        DMatrixTest.assertFalse((boolean)z1.isSquare());
        DMatrixTest.assertFalse((boolean)z1.isSymmetric());
        DMatrix r1 = DMatrix.random(m, n);
        DMatrix r2 = new DMatrix(r1);
        DMatrixTest.assertEqualExact(r1, r2);
        DMatrixTest.assertTrue((boolean)r1.equals(r2));
        DMatrixTest.assertNotSame((Object)r1.getArray(), (Object)r2.getArray());
        DMatrix r3 = DMatrix.random(m, n);
        DMatrixTest.assertFalse((boolean)r1.equals(r3));
        DMatrix i1 = DMatrix.identity(m, n);
        DMatrix i2 = new DMatrix(new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}});
        DMatrixTest.assertTrue((boolean)z1.equals(z2));
        DMatrixTest.assertEqualExact(i1, i2);
    }

    public void testGetSet() {
        int j;
        int j2;
        int i;
        int m = 3;
        int n = 4;
        DMatrix s = new DMatrix(m, n);
        DMatrix r = DMatrix.random(m, n);
        DMatrixTest.assertEquals((int)m, (int)r.getM());
        DMatrixTest.assertEquals((int)n, (int)r.getN());
        DMatrixTest.assertEquals((int)m, (int)r.getRowCount());
        DMatrixTest.assertEquals((int)n, (int)r.getColumnCount());
        for (i = 0; i < m; ++i) {
            for (j2 = 0; j2 < n; ++j2) {
                s.set(i, j2, r.get(i, j2));
            }
        }
        DMatrixTest.assertEqualExact(r, s);
        for (i = 0; i < m; ++i) {
            s.set(i, null, r.get(i, null));
        }
        DMatrixTest.assertEqualExact(r, s);
        for (j = 0; j < n; ++j) {
            s.set(null, j, r.get(null, j));
        }
        DMatrixTest.assertEqualExact(r, s);
        for (i = 0; i < m - 1; ++i) {
            s.set(i, i + 1, null, r.get(i, i + 1, null));
        }
        DMatrixTest.assertEqualExact(r, s);
        for (j = 0; j < n - 1; ++j) {
            s.set(null, j, j + 1, r.get(null, j, j + 1));
        }
        DMatrixTest.assertEqualExact(r, s);
        for (i = 0; i < m - 1; ++i) {
            for (j2 = 0; j2 < n - 1; ++j2) {
                s.set(i, i + 1, j2, j2 + 1, r.get(i, i + 1, j2, j2 + 1));
            }
        }
        DMatrixTest.assertEqualExact(r, s);
        int[] jc = new int[]{n - 1, 1};
        for (int i2 = 0; i2 < m; ++i2) {
            s.set(i2, jc, r.get(i2, jc));
        }
        DMatrixTest.assertEqualExact(r, s);
        int[] ir = new int[]{m - 1, 1};
        for (int j3 = 0; j3 < n; ++j3) {
            s.set(ir, j3, r.get(ir, j3));
        }
        DMatrixTest.assertEqualExact(r, s);
        s.set(ir, jc, r.get(ir, jc));
        DMatrixTest.assertEqualExact(r, s);
        s.setPackedColumns(r.getPackedColumns());
        DMatrixTest.assertEqualExact(r, s);
        s.setPackedRows(r.getPackedRows());
        DMatrixTest.assertEqualExact(r, s);
    }

    public void testOther() {
        int m = 3;
        int n = 4;
        DMatrix r = DMatrix.random(m, n);
        DMatrix s = DMatrix.random(m, n);
        DMatrixTest.assertFalse((boolean)s.equals(r));
        DMatrixTest.assertEqualFuzzy(r, r.plus(s).minus(s));
        DMatrixTest.assertEqualFuzzy(r, r.times(2.0).times(0.5));
        DMatrix r0 = new DMatrix(r);
        DMatrixTest.assertEqualFuzzy(r0, r.negate().negate());
        DMatrixTest.assertEqualFuzzy(r0, r.transpose().transpose());
        DMatrixTest.assertEqualFuzzy(r0, r.plusEquals(s).minusEquals(s));
        DMatrixTest.assertEqualFuzzy(r0, r.timesEquals(2.0).timesEquals(0.5));
        DMatrixTest.assertEqualFuzzy(r0, r.arrayTimes(s).arrayRightDivide(s));
        DMatrixTest.assertEqualFuzzy(r0, r.arrayTimesEquals(s).arrayRightDivideEquals(s));
        DMatrixTest.assertEqualExact(r.arrayRightDivide(s), s.arrayLeftDivide(r));
        DMatrixTest.assertEqualFuzzy(r0, r.arrayLeftDivideEquals(s).arrayLeftDivideEquals(s));
        DMatrix t = DMatrix.random(n, n);
        DMatrixTest.assertTrue((boolean)t.isSquare());
        DMatrixTest.assertTrue((boolean)t.plus(t.transpose()).isSymmetric());
        DMatrixTest.assertEqualFuzzy(t.transposeTimes(t), t.transposeTimes(t).transpose());
        DMatrixTest.assertEqualFuzzy(t.timesTranspose(t), t.timesTranspose(t).transpose());
        n = t.getN();
        double[] a = t.getArray();
        double trace = 0.0;
        for (int i = 0; i < n; ++i) {
            trace += a[i + i * n];
        }
        DMatrixTest.assertTrue((trace == t.trace() ? 1 : 0) != 0);
    }

    static void assertEqualExact(double a, double b) {
        DMatrixTest.assertEquals((double)a, (double)b, (double)0.0);
    }

    static void assertEqualFuzzy(double a, double b) {
        double eps = Math.ulp(1.0);
        double tol = 100.0 * eps * (Math.abs(a) + Math.abs(b));
        DMatrixTest.assertEquals((double)a, (double)b, (double)tol);
    }

    static void assertEqualExact(DMatrix a, DMatrix b) {
        DMatrixTest.assertEquals((Object)a, (Object)b);
    }

    static void assertEqualFuzzy(DMatrix a, DMatrix b) {
        DMatrixTest.assertEquals((int)a.getM(), (int)b.getM());
        DMatrixTest.assertEquals((int)a.getN(), (int)b.getN());
        int m = a.getM();
        int n = a.getN();
        double eps = 1.0E-6 * Math.max(a.normF(), b.normF());
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                DMatrixTest.assertEquals((double)a.get(i, j), (double)b.get(i, j), (double)eps);
            }
        }
    }
}

