/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.lapack.test;

import edu.mines.jtk.lapack.DMatrix;
import edu.mines.jtk.lapack.DMatrixChd;
import edu.mines.jtk.lapack.test.DMatrixTest;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class DMatrixChdTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(DMatrixChdTest.class);
        TestRunner.run((Test)suite);
    }

    public void testSimple() {
        DMatrix a = new DMatrix(new double[][]{{1.0, 1.0}, {1.0, 4.0}});
        this.test(a);
        DMatrixChd chd = new DMatrixChd(a);
        DMatrixTest.assertEqualFuzzy(3.0, chd.det());
    }

    public void testSimple2() {
        DMatrix a = new DMatrix(new double[][]{{4.0, 1.0, 1.0}, {1.0, 2.0, 3.0}, {1.0, 3.0, 6.0}});
        this.test(a);
    }

    public void testNotPositiveDefinite() {
        DMatrix a = new DMatrix(new double[][]{{0.0, 1.0, 1.0}, {0.0, 2.0, 3.0}, {0.0, 3.0, 6.0}});
        DMatrixChd chd = new DMatrixChd(a);
        DMatrixChdTest.assertFalse((boolean)chd.isPositiveDefinite());
        DMatrixTest.assertEqualExact(0.0, chd.det());
    }

    public void testRandom() {
        int n = 10;
        DMatrix a = DMatrix.random(n, n);
        a.plusEquals(a.transpose());
        DMatrix d = DMatrix.identity(n, n);
        d.timesEquals((double)n * a.norm1());
        a.plusEquals(d);
        this.test(a);
    }

    private void test(DMatrix a) {
        int m = a.getM();
        DMatrixChd chd = new DMatrixChd(a);
        DMatrixChdTest.assertTrue((boolean)chd.isPositiveDefinite());
        DMatrix l = chd.getL();
        DMatrix lt = l.transpose();
        DMatrix llt = l.times(lt);
        DMatrixTest.assertEqualFuzzy(a, llt);
        int nrhs = 10;
        DMatrix b = DMatrix.random(m, nrhs);
        DMatrix x = chd.solve(b);
        DMatrix ax = a.times(x);
        DMatrixTest.assertEqualFuzzy(ax, b);
    }
}

