/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.lapack;

import edu.mines.jtk.lapack.Blas;
import edu.mines.jtk.lapack.DMatrix;
import edu.mines.jtk.lapack.Lapack;
import edu.mines.jtk.util.Array;
import edu.mines.jtk.util.Check;

public class DMatrixQrd {
    int _m;
    int _n;
    int _k;
    double[] _qr;
    double[] _tau;
    double[] _work;
    int _lwork;

    public DMatrixQrd(DMatrix a) {
        Check.argument(a.getM() >= a.getN(), "m >= n");
        this._m = a.getM();
        this._n = a.getN();
        this._k = Math.min(this._m, this._n);
        this._qr = a.getPackedColumns();
        this._tau = new double[this._k];
        this._work = new double[1];
        Lapack.dgeqrf(this._m, this._n, this._qr, this._m, this._tau, this._work, -1);
        this._lwork = (int)this._work[0];
        this._work = new double[this._lwork];
        Lapack.dgeqrf(this._m, this._n, this._qr, this._m, this._tau, this._work, this._lwork);
    }

    public boolean isFullRank() {
        for (int j = 0; j < this._n; ++j) {
            if (this._qr[j + j * this._m] != 0.0) continue;
            return false;
        }
        return true;
    }

    public DMatrix getQ() {
        double[] q = Array.copy(this._qr);
        Lapack.dorgqr(this._m, this._n, this._k, q, this._m, this._tau, this._work, this._lwork);
        return new DMatrix(this._m, this._n, q);
    }

    public DMatrix getR() {
        double[] r = new double[this._n * this._n];
        for (int j = 0; j < this._n; ++j) {
            for (int i = 0; i <= j; ++i) {
                r[i + j * this._n] = this._qr[i + j * this._m];
            }
        }
        return new DMatrix(this._n, this._n, r);
    }

    public DMatrix solve(DMatrix b) {
        Check.argument(b.getM() == this._m, "A and B have the same number of rows");
        Check.state(this.isFullRank(), "A is of full rank");
        int nrhs = b.getN();
        DMatrix c = new DMatrix(b);
        double[] ca = c.getArray();
        Lapack.dormqr(141, 112, this._m, nrhs, this._k, this._qr, this._m, this._tau, ca, this._m, this._work, this._lwork);
        Blas.dtrsm(102, 141, 121, 111, 131, this._n, nrhs, 1.0, this._qr, this._m, ca, this._m);
        DMatrix x = c.get(0, this._n - 1, null);
        return x;
    }
}

