/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.lapack;

import edu.mines.jtk.lapack.DMatrix;
import edu.mines.jtk.lapack.Lapack;
import edu.mines.jtk.util.Array;
import edu.mines.jtk.util.Check;

public class DMatrixLud {
    private int _m;
    private int _n;
    private double[] _lu;
    private int _npiv;
    private int[] _ipiv;
    private int[] _p;
    private double _det;
    private boolean _singular;

    public DMatrixLud(DMatrix a) {
        int i;
        this._m = a.getM();
        this._n = a.getN();
        this._lu = a.getPackedColumns();
        this._npiv = Math.min(this._m, this._n);
        this._ipiv = new int[this._npiv];
        int info = Lapack.dgetrf(this._m, this._n, this._lu, this._m, this._ipiv);
        this._p = new int[this._m];
        for (i = 0; i < this._m; ++i) {
            this._p[i] = i;
        }
        this._det = 1.0;
        for (i = 0; i < this._m; ++i) {
            int j = i;
            if (i >= this._npiv) continue;
            j = this._ipiv[i] - 1;
            this._det *= this._lu[i + i * this._m];
            if (j == i) continue;
            int pi = this._p[i];
            this._p[i] = this._p[j];
            this._p[j] = pi;
            this._det = -this._det;
        }
        this._singular = info > 0;
    }

    public boolean isSingular() {
        return this._singular;
    }

    public DMatrix getL() {
        int m = this._m;
        int n = Math.min(this._m, this._n);
        double[] l = new double[m * n];
        for (int j = 0; j < n; ++j) {
            l[j + j * m] = 1.0;
            for (int i = j + 1; i < m; ++i) {
                l[i + j * m] = this._lu[i + j * this._m];
            }
        }
        return new DMatrix(m, n, l);
    }

    public DMatrix getU() {
        int m = Math.min(this._m, this._n);
        int n = this._n;
        double[] u = new double[m * n];
        for (int j = 0; j < n; ++j) {
            int imax = Math.min(m - 1, j);
            for (int i = 0; i <= imax; ++i) {
                u[i + j * m] = this._lu[i + j * this._m];
            }
        }
        return new DMatrix(m, n, u);
    }

    public DMatrix getP() {
        int m = this._m;
        int n = this._m;
        double[] p = new double[m * n];
        for (int i = 0; i < m; ++i) {
            p[this._p[i] + i * m] = 1.0;
        }
        return new DMatrix(m, n, p);
    }

    public int[] getPivotIndices() {
        return Array.copy(this._p);
    }

    public double det() {
        Check.argument(this._m == this._n, "A is square");
        return this._det;
    }

    public DMatrix solve(DMatrix b) {
        Check.argument(this._m == this._n, "A is square");
        Check.argument(this._m == b.getM(), "A and B have same number of rows");
        Check.state(!this._singular, "A is not singular");
        int n = this._n;
        int nrhs = b.getN();
        double[] aa = this._lu;
        int lda = this._m;
        int[] ipiv = this._ipiv;
        double[] ba = b.getPackedColumns();
        int ldb = this._m;
        Lapack.dgetrs(111, n, nrhs, aa, lda, ipiv, ba, ldb);
        return new DMatrix(this._m, nrhs, ba);
    }
}

