/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.lapack;

import edu.mines.jtk.lapack.DMatrix;
import edu.mines.jtk.lapack.Lapack;
import edu.mines.jtk.util.Array;
import edu.mines.jtk.util.Check;

public class DMatrixEvd {
    private int _n;
    private double[] _v;
    private double[] _d;
    private double[] _e;

    public DMatrixEvd(DMatrix a) {
        Check.argument(a.isSquare(), "A is square");
        this._n = a.getN();
        this._v = new double[this._n * this._n];
        this._d = new double[this._n];
        this._e = new double[this._n];
        double[] aa = a.getPackedColumns();
        if (a.isSymmetric()) {
            int[] m = new int[1];
            int[] isuppz = new int[2 * this._n];
            double[] work = new double[1];
            int[] iwork = new int[1];
            int info = Lapack.dsyevr(205, 301, 122, this._n, aa, this._n, 0.0, 0.0, 0, 0, 0.0, m, this._d, this._v, this._n, isuppz, work, -1, iwork, -1);
            if (info > 0) {
                throw new RuntimeException("internal error in LAPACK dsyevr");
            }
            int lwork = (int)work[0];
            int liwork = iwork[0];
            info = Lapack.dsyevr(205, 301, 122, this._n, aa, this._n, 0.0, 0.0, 0, 0, 0.0, m, this._d, this._v, this._n, isuppz, work = new double[lwork], lwork, iwork = new int[liwork], liwork);
            if (info > 0) {
                throw new RuntimeException("internal error in LAPACK dsyevr");
            }
        } else {
            double[] work = new double[1];
            int info = Lapack.dgeev(204, 205, this._n, aa, this._n, this._d, this._e, this._v, this._n, this._v, this._n, work, -1);
            int lwork = (int)work[0];
            info = Lapack.dgeev(204, 205, this._n, aa, this._n, this._d, this._e, this._v, this._n, this._v, this._n, work = new double[lwork], lwork);
            if (info > 0) {
                throw new RuntimeException("LAPACK dgeev failed to converge");
            }
        }
    }

    public DMatrix getV() {
        return new DMatrix(this._n, this._n, this._v);
    }

    public DMatrix getD() {
        double[] d = new double[this._n * this._n];
        for (int i = 0; i < this._n; ++i) {
            for (int j = 0; j < this._n; ++j) {
                d[i + j * this._n] = 0.0;
            }
            d[i + i * this._n] = this._d[i];
            if (this._e[i] > 0.0) {
                d[i + (i + 1) * this._n] = this._e[i];
                continue;
            }
            if (!(this._e[i] < 0.0)) continue;
            d[i + (i - 1) * this._n] = this._e[i];
        }
        return new DMatrix(this._n, this._n, d);
    }

    public double[] getRealEigenvalues() {
        return Array.copy(this._d);
    }

    public double[] getImagEigenvalues() {
        return Array.copy(this._e);
    }
}

