/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.lapack;

import edu.mines.jtk.lapack.DMatrix;
import edu.mines.jtk.lapack.Lapack;
import edu.mines.jtk.util.Array;
import edu.mines.jtk.util.Check;

public class DMatrixChd {
    private int _n;
    private double[] _l;
    private double _det;
    private boolean _pd;

    public DMatrixChd(DMatrix a) {
        int i;
        Check.argument(a.isSquare(), "A is square");
        this._n = a.getN();
        this._l = a.getPackedColumns();
        for (int j = 0; j < this._n; ++j) {
            for (i = 0; i < j; ++i) {
                this._l[i + j * this._n] = 0.0;
            }
        }
        int info = Lapack.dpotrf(122, this._n, this._l, this._n);
        this._pd = info == 0;
        this._det = 1.0;
        for (i = 0; i < this._n; ++i) {
            this._det *= this._l[i + i * this._n];
        }
        this._det *= this._det;
    }

    public boolean isPositiveDefinite() {
        return this._pd;
    }

    public DMatrix getL() {
        return new DMatrix(this._n, this._n, Array.copy(this._l));
    }

    public double det() {
        return this._det;
    }

    public DMatrix solve(DMatrix b) {
        Check.argument(this._n == b.getM(), "A and B have same number of rows");
        Check.state(this._pd, "A is positive-definite");
        int n = this._n;
        int nrhs = b.getN();
        double[] aa = this._l;
        int lda = this._n;
        double[] ba = b.getPackedColumns();
        int ldb = this._n;
        Lapack.dpotrs(122, n, nrhs, aa, lda, ba, ldb);
        return new DMatrix(this._n, nrhs, ba);
    }
}

