/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.la.test;

import edu.mines.jtk.la.DMatrix;
import edu.mines.jtk.la.DMatrixQrd;
import edu.mines.jtk.la.test.DMatrixTest;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class DMatrixQrdTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(DMatrixQrdTest.class);
        TestRunner.run((Test)suite);
    }

    public void testRankDeficient() {
        DMatrix a = new DMatrix(new double[][]{{0.0, 0.0}, {3.0, 4.0}});
        DMatrixQrd qrd = new DMatrixQrd(a);
        DMatrixQrdTest.assertFalse((boolean)qrd.isFullRank());
    }

    public void testSimple() {
        this.test(new DMatrix(new double[][]{{0.0, 2.0}, {3.0, 4.0}}));
        this.test(new DMatrix(new double[][]{{0.0, 2.0}, {3.0, 4.0}, {5.0, 6.0}}));
    }

    public void testRandom() {
        this.test(DMatrix.random(100, 100));
        this.test(DMatrix.random(101, 100));
    }

    private void test(DMatrix a) {
        int m = a.getM();
        int n = a.getN();
        DMatrixQrd qrd = new DMatrixQrd(a);
        DMatrix q = qrd.getQ();
        DMatrix r = qrd.getR();
        DMatrix qr = q.times(r);
        DMatrixTest.assertEqualFuzzy(a, qr);
        if (m == n) {
            int nrhs = 2;
            DMatrix b = DMatrix.random(m, nrhs);
            DMatrix x = qrd.solve(b);
            DMatrix ax = a.times(x);
            DMatrixTest.assertEqualFuzzy(ax, b);
        }
    }
}

