/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.la.test;

import edu.mines.jtk.la.DMatrix;
import edu.mines.jtk.la.DMatrixLud;
import edu.mines.jtk.la.test.DMatrixTest;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class DMatrixLudTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(DMatrixLudTest.class);
        TestRunner.run((Test)suite);
    }

    public void testSingular() {
        DMatrix a = new DMatrix(new double[][]{{0.0, 0.0}, {3.0, 4.0}});
        DMatrixLud lud = new DMatrixLud(a);
        DMatrixLudTest.assertTrue((boolean)lud.isSingular());
        DMatrixLudTest.assertFalse((boolean)lud.isNonSingular());
    }

    public void testSimple() {
        this.test(new DMatrix(new double[][]{{0.0, 2.0}, {3.0, 4.0}}));
        this.test(new DMatrix(new double[][]{{0.0, 2.0}, {3.0, 4.0}, {5.0, 6.0}}));
    }

    public void testRandom() {
        this.test(DMatrix.random(100, 100));
        this.test(DMatrix.random(101, 100));
    }

    private void test(DMatrix a) {
        int m = a.getM();
        int n = a.getN();
        DMatrixLud lud = new DMatrixLud(a);
        int[] piv = lud.getPivot();
        DMatrix l = lud.getL();
        DMatrix u = lud.getU();
        DMatrix lu = l.times(u);
        DMatrixTest.assertEqualFuzzy(a.get(piv, null), lu);
        if (m == n) {
            int nrhs = 2;
            DMatrix b = DMatrix.random(m, nrhs);
            DMatrix x = lud.solve(b);
            DMatrix ax = a.times(x);
            DMatrixTest.assertEqualFuzzy(ax, b);
        }
    }
}

