/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.la;

import edu.mines.jtk.util.Array;
import edu.mines.jtk.util.Check;

public class DMatrix {
    private int _m;
    private int _n;
    private double[][] _a;

    public DMatrix(int m, int n) {
        this._m = m;
        this._n = n;
        this._a = new double[m][n];
    }

    public DMatrix(int m, int n, double v) {
        this(m, n);
        Array.fill(v, this._a);
    }

    public DMatrix(double[][] a) {
        Check.argument(Array.isRegular(a), "array a is regular");
        this._m = a.length;
        this._n = a[0].length;
        this._a = a;
    }

    public DMatrix(DMatrix a) {
        this(a._m, a._n, Array.copy(a._a));
    }

    public int getM() {
        return this._m;
    }

    public int getRowCount() {
        return this._m;
    }

    public int getN() {
        return this._n;
    }

    public int getColumnCount() {
        return this._n;
    }

    public double[][] getArray() {
        return this._a;
    }

    public boolean isSquare() {
        return this._m == this._n;
    }

    public boolean isSymmetric() {
        if (!this.isSquare()) {
            return false;
        }
        for (int i = 0; i < this._n; ++i) {
            for (int j = i + 1; j < this._n; ++j) {
                if (this._a[i][j] == this._a[j][i]) continue;
                return false;
            }
        }
        return true;
    }

    public double[][] get() {
        return Array.copy(this._a);
    }

    public void get(double[][] a) {
        Array.copy(this._a, a);
    }

    public double get(int i, int j) {
        return this._a[i][j];
    }

    public DMatrix get(int i0, int i1, int j0, int j1) {
        this.checkI(i0, i1);
        this.checkJ(j0, j1);
        int m = i1 - i0 + 1;
        int n = j1 - j0 + 1;
        DMatrix x = new DMatrix(m, n);
        Array.copy(n, m, j0, i0, this._a, 0, 0, x._a);
        return x;
    }

    public DMatrix get(int[] r, int[] c) {
        if (r == null && c == null) {
            return new DMatrix(this._m, this._n, Array.copy(this._a));
        }
        int m = r != null ? r.length : this._m;
        int n = c != null ? c.length : this._n;
        double[][] b = new double[m][n];
        if (r == null) {
            for (int i = 0; i < m; ++i) {
                for (int j = 0; j < n; ++j) {
                    b[i][j] = this._a[i][c[j]];
                }
            }
        } else if (c == null) {
            for (int i = 0; i < m; ++i) {
                for (int j = 0; j < n; ++j) {
                    b[i][j] = this._a[r[i]][j];
                }
            }
        } else {
            for (int i = 0; i < m; ++i) {
                for (int j = 0; j < n; ++j) {
                    b[i][j] = this._a[r[i]][c[j]];
                }
            }
        }
        return new DMatrix(m, n, b);
    }

    public DMatrix get(int i, int[] c) {
        return this.get(i, i, c);
    }

    public DMatrix get(int[] r, int j) {
        return this.get(r, j, j);
    }

    public DMatrix get(int i0, int i1, int[] c) {
        this.checkI(i0, i1);
        if (c == null) {
            return this.get(i0, i1, 0, this._n - 1);
        }
        int m = i1 - i0 + 1;
        int n = c.length;
        double[][] b = new double[m][n];
        for (int i = i0; i <= i1; ++i) {
            for (int j = 0; j < n; ++j) {
                b[i - i0][j] = this._a[i][c[j]];
            }
        }
        return new DMatrix(m, n, b);
    }

    public DMatrix get(int[] r, int j0, int j1) {
        this.checkJ(j0, j1);
        if (r == null) {
            return this.get(0, this._m - 1, j0, j1);
        }
        int m = r.length;
        int n = j1 - j0 + 1;
        double[][] b = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = j0; j <= j1; ++j) {
                b[i][j - j0] = this._a[r[i]][j];
            }
        }
        return new DMatrix(m, n, b);
    }

    public double[] getPackedColumns() {
        double[] c = new double[this._m * this._n];
        for (int i = 0; i < this._m; ++i) {
            for (int j = 0; j < this._n; ++j) {
                c[i + j * this._m] = this._a[i][j];
            }
        }
        return c;
    }

    public double[] getPackedRows() {
        double[] r = new double[this._m * this._n];
        for (int i = 0; i < this._m; ++i) {
            for (int j = 0; j < this._n; ++j) {
                r[i * this._n + j] = this._a[i][j];
            }
        }
        return r;
    }

    public void set(double[][] a) {
        for (int i = 0; i < this._m; ++i) {
            for (int j = 0; j < this._n; ++j) {
                this._a[i][j] = a[i][j];
            }
        }
    }

    public void set(int i, int j, double v) {
        this._a[i][j] = v;
    }

    public void set(int i0, int i1, int j0, int j1, DMatrix x) {
        this.checkI(i0, i1);
        this.checkJ(j0, j1);
        int m = i1 - i0 + 1;
        int n = j1 - j0 + 1;
        Check.argument(m == x._m, "i1-i0+1 equals number of rows in x");
        Check.argument(n == x._n, "j1-j0+1 equals number of columns in x");
        Array.copy(n, m, 0, 0, x._a, j0, i0, this._a);
    }

    public void set(int[] r, int[] c, DMatrix x) {
        if (r == null) {
            Check.argument(this._m == x._m, "number of rows equal in this and x");
        } else {
            Check.argument(r.length == x._m, "r.length equals number of rows in x");
        }
        if (c == null) {
            Check.argument(this._n == x._n, "number of columns equal in this and x");
        } else {
            Check.argument(c.length == x._n, "c.length equals number of columns in x");
        }
        if (r == null && c == null) {
            Array.copy(x._a, this._a);
        } else {
            int m = r != null ? r.length : this._m;
            int n = c != null ? c.length : this._n;
            double[][] b = x._a;
            if (r == null) {
                for (int i = 0; i < m; ++i) {
                    for (int j = 0; j < n; ++j) {
                        this._a[i][c[j]] = b[i][j];
                    }
                }
            } else if (c == null) {
                for (int i = 0; i < m; ++i) {
                    for (int j = 0; j < n; ++j) {
                        this._a[r[i]][j] = b[i][j];
                    }
                }
            } else {
                for (int i = 0; i < m; ++i) {
                    for (int j = 0; j < n; ++j) {
                        this._a[r[i]][c[j]] = b[i][j];
                    }
                }
            }
        }
    }

    public void set(int i, int[] c, DMatrix x) {
        this.set(i, i, c, x);
    }

    public void set(int[] r, int j, DMatrix x) {
        this.set(r, j, j, x);
    }

    public void set(int i0, int i1, int[] c, DMatrix x) {
        this.checkI(i0, i1);
        Check.argument(i1 - i0 + 1 == x._m, "i1-i0+1 equals number of rows in x");
        if (c == null) {
            this.set(i0, i1, 0, this._n - 1, x);
        } else {
            int n = c.length;
            double[][] b = x._a;
            for (int i = i0; i <= i1; ++i) {
                for (int j = 0; j < n; ++j) {
                    this._a[i][c[j]] = b[i - i0][j];
                }
            }
        }
    }

    public void set(int[] r, int j0, int j1, DMatrix x) {
        this.checkJ(j0, j1);
        Check.argument(j1 - j0 + 1 == x._n, "j1-j0+1 equals number of columns in x");
        if (r == null) {
            this.set(0, this._m - 1, j0, j1, x);
        } else {
            int m = r.length;
            double[][] b = x._a;
            for (int i = 0; i < m; ++i) {
                for (int j = j0; j <= j1; ++j) {
                    this._a[r[i]][j] = b[i][j - j0];
                }
            }
        }
    }

    public void setPackedColumns(double[] c) {
        for (int i = 0; i < this._m; ++i) {
            for (int j = 0; j < this._n; ++j) {
                this._a[i][j] = c[i + j * this._m];
            }
        }
    }

    public void setPackedRows(double[] r) {
        for (int i = 0; i < this._m; ++i) {
            for (int j = 0; j < this._n; ++j) {
                this._a[i][j] = r[i * this._n + j];
            }
        }
    }

    public DMatrix transpose() {
        DMatrix x = new DMatrix(this._n, this._m);
        double[][] b = x._a;
        for (int i = 0; i < this._m; ++i) {
            for (int j = 0; j < this._n; ++j) {
                b[j][i] = this._a[i][j];
            }
        }
        return x;
    }

    public double norm1() {
        double f = 0.0;
        for (int j = 0; j < this._n; ++j) {
            double s = 0.0;
            for (int i = 0; i < this._m; ++i) {
                s += Math.abs(this._a[i][j]);
            }
            f = Math.max(f, s);
        }
        return f;
    }

    public double norm2() {
        return 1.0;
    }

    public double normI() {
        double f = 0.0;
        for (int i = 0; i < this._m; ++i) {
            double s = 0.0;
            for (int j = 0; j < this._n; ++j) {
                s += Math.abs(this._a[i][j]);
            }
            f = Math.max(f, s);
        }
        return f;
    }

    public double normF() {
        double f = 0.0;
        for (int i = 0; i < this._m; ++i) {
            for (int j = 0; j < this._n; ++j) {
                f = Math.hypot(f, this._a[i][j]);
            }
        }
        return f;
    }

    public DMatrix negate() {
        DMatrix c = new DMatrix(this._m, this._n);
        Array.neg(this._a, c._a);
        return c;
    }

    public DMatrix plus(DMatrix b) {
        DMatrix c = new DMatrix(this._m, this._n);
        Array.add(this._a, b._a, c._a);
        return c;
    }

    public DMatrix plusEquals(DMatrix b) {
        Array.add(this._a, b._a, this._a);
        return this;
    }

    public DMatrix minus(DMatrix b) {
        DMatrix c = new DMatrix(this._m, this._n);
        Array.sub(this._a, b._a, c._a);
        return c;
    }

    public DMatrix minusEquals(DMatrix b) {
        Array.sub(this._a, b._a, this._a);
        return this;
    }

    public DMatrix arrayTimes(DMatrix b) {
        DMatrix c = new DMatrix(this._m, this._n);
        Array.mul(this._a, b._a, c._a);
        return c;
    }

    public DMatrix arrayTimesEquals(DMatrix b) {
        Array.mul(this._a, b._a, this._a);
        return this;
    }

    public DMatrix arrayRightDivide(DMatrix b) {
        DMatrix c = new DMatrix(this._m, this._n);
        Array.div(this._a, b._a, c._a);
        return c;
    }

    public DMatrix arrayRightDivideEquals(DMatrix b) {
        Array.div(this._a, b._a, this._a);
        return this;
    }

    public DMatrix arrayLeftDivide(DMatrix b) {
        DMatrix c = new DMatrix(this._m, this._n);
        Array.div(b._a, this._a, c._a);
        return c;
    }

    public DMatrix arrayLeftDivideEquals(DMatrix b) {
        Array.div(b._a, this._a, this._a);
        return this;
    }

    public DMatrix times(double s) {
        DMatrix c = new DMatrix(this._m, this._n);
        Array.mul(this._a, s, c._a);
        return c;
    }

    public DMatrix timesEquals(double s) {
        Array.mul(this._a, s, this._a);
        return this;
    }

    public DMatrix times(DMatrix b) {
        Check.argument(this._n == b._m, "number of columns in A equals number of rows in B");
        DMatrix c = new DMatrix(this._m, b._n);
        double[][] aa = this._a;
        double[][] ba = b._a;
        double[][] ca = c._a;
        double[] bj = new double[this._n];
        for (int j = 0; j < b._n; ++j) {
            for (int k = 0; k < this._n; ++k) {
                bj[k] = ba[k][j];
            }
            for (int i = 0; i < this._m; ++i) {
                double[] ai = aa[i];
                double s = 0.0;
                for (int k = 0; k < this._n; ++k) {
                    s += ai[k] * bj[k];
                }
                ca[i][j] = s;
            }
        }
        return c;
    }

    public double trace() {
        int mn = Math.min(this._m, this._n);
        double t = 0.0;
        for (int i = 0; i < mn; ++i) {
            t += this._a[i][i];
        }
        return t;
    }

    public static DMatrix random(int m, int n) {
        DMatrix x = new DMatrix(m, n);
        Array.rand(x._a);
        return x;
    }

    public static DMatrix identity(int m, int n) {
        DMatrix x = new DMatrix(m, n);
        double[][] xa = x._a;
        int mn = Math.min(m, n);
        for (int i = 0; i < mn; ++i) {
            xa[i][i] = 1.0;
        }
        return x;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DMatrix that = (DMatrix)obj;
        if (this._m != that._m || this._n != that._n) {
            return false;
        }
        double[][] a = this._a;
        double[][] b = that._a;
        for (int i = 0; i < this._m; ++i) {
            for (int j = 0; j < this._n; ++j) {
                if (a[i][j] == b[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int h = this._m ^ this._n;
        for (int i = 0; i < this._m; ++i) {
            for (int j = 0; j < this._n; ++j) {
                long bits = Double.doubleToLongBits(this._a[i][j]);
                h ^= (int)(bits ^ bits >>> 32);
            }
        }
        return h;
    }

    public String toString() {
        String ls = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        String[][] s = DMatrix.format(this._a);
        int max = DMatrix.maxlen(s);
        String format = "%" + max + "s";
        sb.append("[[");
        int ncol = 77 / (max + 2);
        if (ncol >= 5) {
            ncol = ncol / 5 * 5;
        }
        for (int i = 0; i < this._m; ++i) {
            int nrow = 1 + (this._n - 1) / ncol;
            if (i > 0) {
                sb.append(" [");
            }
            int j = 0;
            for (int irow = 0; irow < nrow; ++irow) {
                for (int icol = 0; icol < ncol && j < this._n; ++icol, ++j) {
                    sb.append(String.format(format, s[i][j]));
                    if (j >= this._n - 1) continue;
                    sb.append(", ");
                }
                if (j < this._n) {
                    sb.append(ls);
                    sb.append("  ");
                    continue;
                }
                if (i < this._m - 1) {
                    sb.append("],");
                    sb.append(ls);
                    continue;
                }
                sb.append("]]");
                sb.append(ls);
            }
        }
        return sb.toString();
    }

    DMatrix(int m, int n, double[][] a) {
        this._m = m;
        this._n = n;
        this._a = a;
    }

    private void checkI(int i) {
        if (i < 0 || i >= this._m) {
            Check.argument(0 <= i && i < this._m, "row index i=" + i + " is in bounds");
        }
    }

    private void checkJ(int j) {
        if (j < 0 || j >= this._n) {
            Check.argument(0 <= j && j < this._n, "column index j=" + j + " is in bounds");
        }
    }

    private void checkI(int i0, int i1) {
        this.checkI(i0);
        this.checkI(i1);
        Check.argument(i0 <= i1, "i0<=i1");
    }

    private void checkJ(int j0, int j1) {
        this.checkJ(j0);
        this.checkJ(j1);
        Check.argument(j0 <= j1, "j0<=j1");
    }

    private static String[][] format(double[][] d) {
        String f;
        int m = d.length;
        int n = d[0].length;
        int pg = 6;
        String fg = "% ." + pg + "g";
        int pemax = -1;
        int pfmax = -1;
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                int pf;
                String s = String.format(fg, d[i][j]);
                s = DMatrix.clean(s);
                int ls = s.length();
                if (s.contains("e")) {
                    int pe;
                    int n2 = pe = ls > 7 ? ls - 7 : 0;
                    if (pemax >= pe) continue;
                    pemax = pe;
                    continue;
                }
                int ip = s.indexOf(46);
                int n3 = pf = ip >= 0 ? ls - 1 - ip : 0;
                if (pfmax >= pf) continue;
                pfmax = pf;
            }
        }
        String[][] s = new String[m][n];
        if (pemax >= 0) {
            if (pfmax > pg - 1) {
                pfmax = pg - 1;
            }
            int pe = pemax > pfmax ? pemax : pfmax;
            f = "% ." + pe + "e";
        } else {
            int pf = pfmax;
            f = "% ." + pf + "f";
        }
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                s[i][j] = String.format(f, d[i][j]);
            }
        }
        return s;
    }

    private static String clean(String s) {
        int ibeg;
        int len = s.length();
        int iend = s.indexOf(101);
        if (iend < 0) {
            iend = s.indexOf(69);
        }
        if (iend < 0) {
            iend = len;
        }
        if (s.indexOf(46) > 0) {
            for (ibeg = iend; ibeg > 0 && s.charAt(ibeg - 1) == '0'; --ibeg) {
            }
            if (ibeg > 0 && s.charAt(ibeg - 1) == '.') {
                --ibeg;
            }
        }
        if (ibeg < iend) {
            String sb = s.substring(0, ibeg);
            s = iend < len ? sb + s.substring(iend, len) : sb;
        }
        return s;
    }

    private static int maxlen(String[][] s) {
        int max = 0;
        int m = s.length;
        int n = s[0].length;
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                int len = s[i][j].length();
                if (max >= len) continue;
                max = len;
            }
        }
        return max;
    }
}

