/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.io.test;

import edu.mines.jtk.io.DataFile;
import edu.mines.jtk.util.Array;
import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class DataFileTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(DataFileTest.class);
        TestRunner.run((Test)suite);
    }

    public void testBigEndian() throws IOException {
        DataFileTest.test(DataFile.ByteOrder.BIG_ENDIAN);
    }

    public void testLittleEndian() throws IOException {
        DataFileTest.test(DataFile.ByteOrder.LITTLE_ENDIAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void test(DataFile.ByteOrder order) throws IOException {
        int n = 10000;
        File file = null;
        DataFile df = null;
        try {
            file = File.createTempFile("junk", "dat");
            df = new DataFile(file, "rw", order);
            DataFileTest.testFloat(df, n);
            DataFileTest.testDouble(df, n);
        }
        finally {
            if (df != null) {
                df.close();
            }
            if (file != null) {
                file.delete();
            }
        }
    }

    private static void testFloat(DataFile df, int n) throws IOException {
        int i;
        float[] a = Array.randfloat(n);
        float[] b = Array.zerofloat(n);
        df.seek(0L);
        df.writeFloats(a);
        df.seek(0L);
        df.readFloats(b);
        for (i = 0; i < n; ++i) {
            DataFileTest.assertEquals((Object)Float.valueOf(a[i]), (Object)Float.valueOf(b[i]));
        }
        Array.zero(b);
        df.seek(0L);
        for (i = 0; i < n; ++i) {
            df.writeFloat(a[i]);
        }
        df.seek(0L);
        for (i = 0; i < n; ++i) {
            b[i] = df.readFloat();
        }
        for (i = 0; i < n; ++i) {
            DataFileTest.assertEquals((Object)Float.valueOf(a[i]), (Object)Float.valueOf(b[i]));
        }
        df.seek(0L);
        for (i = 0; i < n; ++i) {
            DataFileTest.assertEquals((Object)Float.valueOf(a[i]), (Object)Float.valueOf(df.readFloat()));
        }
        df.seek(0L);
        for (i = 0; i < n; ++i) {
            df.writeFloat(a[i]);
        }
        Array.zero(b);
        df.seek(0L);
        df.readFloats(b);
        for (i = 0; i < n; ++i) {
            DataFileTest.assertEquals((Object)Float.valueOf(a[i]), (Object)Float.valueOf(b[i]));
        }
        int mw = 3141;
        df.seek(0L);
        for (int j = 0; j < n; j += mw) {
            df.writeFloats(a, j, Math.min(n - j, mw));
        }
        Array.zero(b);
        df.seek(0L);
        int mr = 2739;
        for (int j = 0; j < n; j += mr) {
            df.readFloats(b, j, Math.min(n - j, mr));
        }
        for (int i2 = 0; i2 < n; ++i2) {
            DataFileTest.assertEquals((Object)Float.valueOf(a[i2]), (Object)Float.valueOf(b[i2]));
        }
    }

    private static void testDouble(DataFile df, int n) throws IOException {
        int i;
        double[] a = Array.randdouble(n);
        double[] b = Array.zerodouble(n);
        df.seek(0L);
        df.writeDoubles(a);
        df.seek(0L);
        df.readDoubles(b);
        for (i = 0; i < n; ++i) {
            DataFileTest.assertEquals((Object)a[i], (Object)b[i]);
        }
        Array.zero(b);
        df.seek(0L);
        for (i = 0; i < n; ++i) {
            df.writeDouble(a[i]);
        }
        df.seek(0L);
        for (i = 0; i < n; ++i) {
            b[i] = df.readDouble();
        }
        for (i = 0; i < n; ++i) {
            DataFileTest.assertEquals((Object)a[i], (Object)b[i]);
        }
        df.seek(0L);
        for (i = 0; i < n; ++i) {
            DataFileTest.assertEquals((Object)a[i], (Object)df.readDouble());
        }
        df.seek(0L);
        for (i = 0; i < n; ++i) {
            df.writeDouble(a[i]);
        }
        Array.zero(b);
        df.seek(0L);
        df.readDoubles(b);
        for (i = 0; i < n; ++i) {
            DataFileTest.assertEquals((Object)a[i], (Object)b[i]);
        }
        int mw = 3141;
        df.seek(0L);
        for (int j = 0; j < n; j += mw) {
            df.writeDoubles(a, j, Math.min(n - j, mw));
        }
        Array.zero(b);
        df.seek(0L);
        int mr = 2739;
        for (int j = 0; j < n; j += mr) {
            df.readDoubles(b, j, Math.min(n - j, mr));
        }
        for (int i2 = 0; i2 < n; ++i2) {
            DataFileTest.assertEquals((Object)a[i2], (Object)b[i2]);
        }
    }
}

