/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.io.test;

import edu.mines.jtk.io.ArrayFile;
import edu.mines.jtk.util.Array;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ArrayFileTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(ArrayFileTest.class);
        TestRunner.run((Test)suite);
    }

    public void testBigEndian() throws IOException {
        ArrayFileTest.test(ByteOrder.BIG_ENDIAN);
    }

    public void testLittleEndian() throws IOException {
        ArrayFileTest.test(ByteOrder.LITTLE_ENDIAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void test(ByteOrder order) throws IOException {
        int n = 10000;
        File file = null;
        ArrayFile af = null;
        try {
            file = File.createTempFile("junk", "dat");
            af = new ArrayFile(file, "rw", order, order);
            ArrayFileTest.testFloat(af, n);
            ArrayFileTest.testDouble(af, n);
        }
        finally {
            if (af != null) {
                af.close();
            }
            if (file != null) {
                file.delete();
            }
        }
    }

    private static void testFloat(ArrayFile af, int n) throws IOException {
        int i;
        float[] a = Array.randfloat(n);
        float[] b = Array.zerofloat(n);
        af.seek(0L);
        af.writeFloats(a);
        af.seek(0L);
        af.readFloats(b);
        for (i = 0; i < n; ++i) {
            ArrayFileTest.assertEquals((Object)Float.valueOf(a[i]), (Object)Float.valueOf(b[i]));
        }
        Array.zero(b);
        af.seek(0L);
        for (i = 0; i < n; ++i) {
            af.writeFloat(a[i]);
        }
        af.seek(0L);
        for (i = 0; i < n; ++i) {
            b[i] = af.readFloat();
        }
        for (i = 0; i < n; ++i) {
            ArrayFileTest.assertEquals((Object)Float.valueOf(a[i]), (Object)Float.valueOf(b[i]));
        }
        af.seek(0L);
        for (i = 0; i < n; ++i) {
            ArrayFileTest.assertEquals((Object)Float.valueOf(a[i]), (Object)Float.valueOf(af.readFloat()));
        }
        af.seek(0L);
        for (i = 0; i < n; ++i) {
            af.writeFloat(a[i]);
        }
        Array.zero(b);
        af.seek(0L);
        af.readFloats(b);
        for (i = 0; i < n; ++i) {
            ArrayFileTest.assertEquals((Object)Float.valueOf(a[i]), (Object)Float.valueOf(b[i]));
        }
        int mw = 3141;
        af.seek(0L);
        for (int j = 0; j < n; j += mw) {
            af.writeFloats(a, j, Math.min(n - j, mw));
        }
        Array.zero(b);
        af.seek(0L);
        int mr = 2739;
        for (int j = 0; j < n; j += mr) {
            af.readFloats(b, j, Math.min(n - j, mr));
        }
        for (int i2 = 0; i2 < n; ++i2) {
            ArrayFileTest.assertEquals((Object)Float.valueOf(a[i2]), (Object)Float.valueOf(b[i2]));
        }
    }

    private static void testDouble(ArrayFile af, int n) throws IOException {
        int i;
        double[] a = Array.randdouble(n);
        double[] b = Array.zerodouble(n);
        af.seek(0L);
        af.writeDoubles(a);
        af.seek(0L);
        af.readDoubles(b);
        for (i = 0; i < n; ++i) {
            ArrayFileTest.assertEquals((Object)a[i], (Object)b[i]);
        }
        Array.zero(b);
        af.seek(0L);
        for (i = 0; i < n; ++i) {
            af.writeDouble(a[i]);
        }
        af.seek(0L);
        for (i = 0; i < n; ++i) {
            b[i] = af.readDouble();
        }
        for (i = 0; i < n; ++i) {
            ArrayFileTest.assertEquals((Object)a[i], (Object)b[i]);
        }
        af.seek(0L);
        for (i = 0; i < n; ++i) {
            ArrayFileTest.assertEquals((Object)a[i], (Object)af.readDouble());
        }
        af.seek(0L);
        for (i = 0; i < n; ++i) {
            af.writeDouble(a[i]);
        }
        Array.zero(b);
        af.seek(0L);
        af.readDoubles(b);
        for (i = 0; i < n; ++i) {
            ArrayFileTest.assertEquals((Object)a[i], (Object)b[i]);
        }
        int mw = 3141;
        af.seek(0L);
        for (int j = 0; j < n; j += mw) {
            af.writeDoubles(a, j, Math.min(n - j, mw));
        }
        Array.zero(b);
        af.seek(0L);
        int mr = 2739;
        for (int j = 0; j < n; j += mr) {
            af.readDoubles(b, j, Math.min(n - j, mr));
        }
        for (int i2 = 0; i2 < n; ++i2) {
            ArrayFileTest.assertEquals((Object)a[i2], (Object)b[i2]);
        }
    }
}

