/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.io;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;

public class DataFile
implements DataInput,
DataOutput,
Closeable {
    private RandomAccessFile _raf;
    private FileChannel _fc;
    private ByteOrder _bo;
    private ByteBuffer _bb;
    private CharBuffer _cb;
    private ShortBuffer _sb;
    private IntBuffer _ib;
    private LongBuffer _lb;
    private FloatBuffer _fb;
    private DoubleBuffer _db;

    public static ByteOrder nativeByteOrder() {
        if (java.nio.ByteOrder.nativeOrder() == java.nio.ByteOrder.BIG_ENDIAN) {
            return ByteOrder.BIG_ENDIAN;
        }
        return ByteOrder.LITTLE_ENDIAN;
    }

    public DataFile(String name, String mode) throws FileNotFoundException {
        this(name, mode, ByteOrder.BIG_ENDIAN);
    }

    public DataFile(File file, String mode) throws FileNotFoundException {
        this(file, mode, ByteOrder.BIG_ENDIAN);
    }

    public DataFile(String name, String mode, ByteOrder order) throws FileNotFoundException {
        this(name != null ? new File(name) : null, mode, order);
    }

    public DataFile(File file, String mode, ByteOrder order) throws FileNotFoundException {
        this._raf = new RandomAccessFile(file, mode);
        this._fc = this._raf.getChannel();
        this._bo = order;
        this._bb = ByteBuffer.allocateDirect(4096);
        if (order == ByteOrder.BIG_ENDIAN) {
            this._bb.order(java.nio.ByteOrder.BIG_ENDIAN);
        } else {
            this._bb.order(java.nio.ByteOrder.LITTLE_ENDIAN);
        }
        this._cb = this._bb.asCharBuffer();
        this._sb = this._bb.asShortBuffer();
        this._ib = this._bb.asIntBuffer();
        this._lb = this._bb.asLongBuffer();
        this._fb = this._bb.asFloatBuffer();
        this._db = this._bb.asDoubleBuffer();
    }

    public final FileDescriptor getFD() throws IOException {
        return this._raf.getFD();
    }

    public final FileChannel getChannel() {
        return this._raf.getChannel();
    }

    public ByteOrder getByteOrder() {
        return this._bo;
    }

    public int read() throws IOException {
        return this._raf.read();
    }

    public int read(byte[] b) throws IOException {
        return this._raf.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this._raf.read(b, off, len);
    }

    public void readFully(byte[] b) throws IOException {
        this._raf.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this._raf.readFully(b, off, len);
    }

    public int skipBytes(int n) throws IOException {
        return this._raf.skipBytes(n);
    }

    public void write(int b) throws IOException {
        this._raf.write(b);
    }

    public void write(byte[] b) throws IOException {
        this._raf.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this._raf.write(b, off, len);
    }

    public long getFilePointer() throws IOException {
        return this._raf.getFilePointer();
    }

    public void seek(long off) throws IOException {
        this._raf.seek(off);
    }

    public long length() throws IOException {
        return this._raf.length();
    }

    public void setLength(long newLength) throws IOException {
        this._raf.setLength(newLength);
    }

    public void close() throws IOException {
        this._raf.close();
        this._raf = null;
        this._fc = null;
        this._bb = null;
    }

    public final boolean readBoolean() throws IOException {
        return this._raf.readBoolean();
    }

    public final byte readByte() throws IOException {
        return this._raf.readByte();
    }

    public final int readUnsignedByte() throws IOException {
        return this._raf.readUnsignedByte();
    }

    public final short readShort() throws IOException {
        int b1 = this._raf.read();
        int b2 = this._raf.read();
        if (this._bo == ByteOrder.BIG_ENDIAN) {
            return (short)((b1 << 8) + b2);
        }
        return (short)((b2 << 8) + b1);
    }

    public final int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    public final char readChar() throws IOException {
        return (char)this.readShort();
    }

    public final int readInt() throws IOException {
        int b1 = this._raf.read();
        int b2 = this._raf.read();
        int b3 = this._raf.read();
        int b4 = this._raf.read();
        if (this._bo == ByteOrder.BIG_ENDIAN) {
            return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
        }
        return (b4 << 24) + (b3 << 16) + (b2 << 8) + b1;
    }

    public final long readLong() throws IOException {
        int i1 = this.readInt();
        int i2 = this.readInt();
        if (this._bo == ByteOrder.BIG_ENDIAN) {
            return ((long)i1 << 32) + ((long)i2 & 0xFFFFFFFFL);
        }
        return ((long)i2 << 32) + ((long)i1 & 0xFFFFFFFFL);
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final String readLine() throws IOException {
        return this._raf.readLine();
    }

    public final String readUTF() throws IOException {
        return this._raf.readUTF();
    }

    public void writeBoolean(boolean v) throws IOException {
        this._raf.writeBoolean(v);
    }

    public void writeByte(int v) throws IOException {
        this._raf.writeByte(v);
    }

    public void writeShort(int v) throws IOException {
        if (this._bo == ByteOrder.BIG_ENDIAN) {
            this._raf.write(v >>> 8 & 0xFF);
            this._raf.write(v & 0xFF);
        } else {
            this._raf.write(v & 0xFF);
            this._raf.write(v >>> 8 & 0xFF);
        }
    }

    public void writeChar(int v) throws IOException {
        this._raf.writeShort(v);
    }

    public void writeInt(int v) throws IOException {
        if (this._bo == ByteOrder.BIG_ENDIAN) {
            this._raf.write(v >>> 24 & 0xFF);
            this._raf.write(v >>> 16 & 0xFF);
            this._raf.write(v >>> 8 & 0xFF);
            this._raf.write(v & 0xFF);
        } else {
            this._raf.write(v & 0xFF);
            this._raf.write(v >>> 8 & 0xFF);
            this._raf.write(v >>> 16 & 0xFF);
            this._raf.write(v >>> 24 & 0xFF);
        }
    }

    public void writeLong(long v) throws IOException {
        if (this._bo == ByteOrder.BIG_ENDIAN) {
            this._raf.write((int)(v >>> 56) & 0xFF);
            this._raf.write((int)(v >>> 48) & 0xFF);
            this._raf.write((int)(v >>> 40) & 0xFF);
            this._raf.write((int)(v >>> 32) & 0xFF);
            this._raf.write((int)(v >>> 24) & 0xFF);
            this._raf.write((int)(v >>> 16) & 0xFF);
            this._raf.write((int)(v >>> 8) & 0xFF);
            this._raf.write((int)v & 0xFF);
        } else {
            this._raf.write((int)v & 0xFF);
            this._raf.write((int)(v >>> 8) & 0xFF);
            this._raf.write((int)(v >>> 16) & 0xFF);
            this._raf.write((int)(v >>> 24) & 0xFF);
            this._raf.write((int)(v >>> 32) & 0xFF);
            this._raf.write((int)(v >>> 40) & 0xFF);
            this._raf.write((int)(v >>> 48) & 0xFF);
            this._raf.write((int)(v >>> 56) & 0xFF);
        }
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeBytes(String s) throws IOException {
        this._raf.writeBytes(s);
    }

    public void writeChars(String s) throws IOException {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    public void writeUTF(String s) throws IOException {
        this._raf.writeUTF(s);
    }

    public void readBytes(byte[] v, int k, int n) throws IOException {
        this.readFully(v, k, n);
    }

    public void readBytes(byte[] v) throws IOException {
        this.readFully(v);
    }

    public void readBytes(byte[][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.readBytes(v[i]);
        }
    }

    public void readBytes(byte[][][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.readBytes(v[i]);
        }
    }

    public void readChars(char[] v, int k, int n) throws IOException {
        int m = this._cb.capacity();
        for (int j = 0; j < n; j += m) {
            int l = Math.min(n - j, m);
            this._bb.position(0).limit(l * 2);
            this._fc.read(this._bb);
            this._cb.position(0).limit(l);
            this._cb.get(v, k + j, l);
        }
    }

    public void readChars(char[] v) throws IOException {
        this.readChars(v, 0, v.length);
    }

    public void readChars(char[][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.readChars(v[i]);
        }
    }

    public void readChars(char[][][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.readChars(v[i]);
        }
    }

    public void readShorts(short[] v, int k, int n) throws IOException {
        int m = this._sb.capacity();
        for (int j = 0; j < n; j += m) {
            int l = Math.min(n - j, m);
            this._bb.position(0).limit(l * 2);
            this._fc.read(this._bb);
            this._sb.position(0).limit(l);
            this._sb.get(v, k + j, l);
        }
    }

    public void readShorts(short[] v) throws IOException {
        this.readShorts(v, 0, v.length);
    }

    public void readShorts(short[][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.readShorts(v[i]);
        }
    }

    public void readShorts(short[][][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.readShorts(v[i]);
        }
    }

    public void readInts(int[] v, int k, int n) throws IOException {
        int m = this._ib.capacity();
        for (int j = 0; j < n; j += m) {
            int l = Math.min(n - j, m);
            this._bb.position(0).limit(l * 4);
            this._fc.read(this._bb);
            this._ib.position(0).limit(l);
            this._ib.get(v, k + j, l);
        }
    }

    public void readInts(int[] v) throws IOException {
        this.readInts(v, 0, v.length);
    }

    public void readInts(int[][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.readInts(v[i]);
        }
    }

    public void readInts(int[][][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.readInts(v[i]);
        }
    }

    public void readLongs(long[] v, int k, int n) throws IOException {
        int m = this._lb.capacity();
        for (int j = 0; j < n; j += m) {
            int l = Math.min(n - j, m);
            this._bb.position(0).limit(l * 8);
            this._fc.read(this._bb);
            this._lb.position(0).limit(l);
            this._lb.get(v, k + j, l);
        }
    }

    public void readLongs(long[] v) throws IOException {
        this.readLongs(v, 0, v.length);
    }

    public void readLongs(long[][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.readLongs(v[i]);
        }
    }

    public void readLongs(long[][][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.readLongs(v[i]);
        }
    }

    public void readFloats(float[] v, int k, int n) throws IOException {
        int m = this._fb.capacity();
        for (int j = 0; j < n; j += m) {
            int l = Math.min(n - j, m);
            this._bb.position(0).limit(l * 4);
            this._fc.read(this._bb);
            this._fb.position(0).limit(l);
            this._fb.get(v, k + j, l);
        }
    }

    public void readFloats(float[] v) throws IOException {
        this.readFloats(v, 0, v.length);
    }

    public void readFloats(float[][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.readFloats(v[i]);
        }
    }

    public void readFloats(float[][][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.readFloats(v[i]);
        }
    }

    public void readDoubles(double[] v, int k, int n) throws IOException {
        int m = this._db.capacity();
        for (int j = 0; j < n; j += m) {
            int l = Math.min(n - j, m);
            this._bb.position(0).limit(l * 8);
            this._fc.read(this._bb);
            this._db.position(0).limit(l);
            this._db.get(v, k + j, l);
        }
    }

    public void readDoubles(double[] v) throws IOException {
        this.readDoubles(v, 0, v.length);
    }

    public void readDoubles(double[][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.readDoubles(v[i]);
        }
    }

    public void readDoubles(double[][][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.readDoubles(v[i]);
        }
    }

    public void writeBytes(byte[] v, int k, int n) throws IOException {
        this.write(v, k, n);
    }

    public void writeBytes(byte[] v) throws IOException {
        this.write(v);
    }

    public void writeBytes(byte[][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.writeBytes(v[i]);
        }
    }

    public void writeBytes(byte[][][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.writeBytes(v[i]);
        }
    }

    public void writeChars(char[] v, int k, int n) throws IOException {
        int m = this._cb.capacity();
        for (int j = 0; j < n; j += m) {
            int l = Math.min(n - j, m);
            this._cb.position(0).limit(l);
            this._cb.put(v, k + j, l);
            this._bb.position(0).limit(l * 2);
            this._fc.write(this._bb);
        }
    }

    public void writeChars(char[] v) throws IOException {
        this.writeChars(v, 0, v.length);
    }

    public void writeChars(char[][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.writeChars(v[i]);
        }
    }

    public void writeChars(char[][][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.writeChars(v[i]);
        }
    }

    public void writeShorts(short[] v, int k, int n) throws IOException {
        int m = this._sb.capacity();
        for (int j = 0; j < n; j += m) {
            int l = Math.min(n - j, m);
            this._sb.position(0).limit(l);
            this._sb.put(v, k + j, l);
            this._bb.position(0).limit(l * 2);
            this._fc.write(this._bb);
        }
    }

    public void writeShorts(short[] v) throws IOException {
        this.writeShorts(v, 0, v.length);
    }

    public void writeShorts(short[][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.writeShorts(v[i]);
        }
    }

    public void writeShorts(short[][][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.writeShorts(v[i]);
        }
    }

    public void writeInts(int[] v, int k, int n) throws IOException {
        int m = this._ib.capacity();
        for (int j = 0; j < n; j += m) {
            int l = Math.min(n - j, m);
            this._ib.position(0).limit(l);
            this._ib.put(v, k + j, l);
            this._bb.position(0).limit(l * 4);
            this._fc.write(this._bb);
        }
    }

    public void writeInts(int[] v) throws IOException {
        this.writeInts(v, 0, v.length);
    }

    public void writeInts(int[][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.writeInts(v[i]);
        }
    }

    public void writeInts(int[][][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.writeInts(v[i]);
        }
    }

    public void writeLongs(long[] v, int k, int n) throws IOException {
        int m = this._lb.capacity();
        for (int j = 0; j < n; j += m) {
            int l = Math.min(n - j, m);
            this._lb.position(0).limit(l);
            this._lb.put(v, k + j, l);
            this._bb.position(0).limit(l * 8);
            this._fc.write(this._bb);
        }
    }

    public void writeLongs(long[] v) throws IOException {
        this.writeLongs(v, 0, v.length);
    }

    public void writeLongs(long[][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.writeLongs(v[i]);
        }
    }

    public void writeLongs(long[][][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.writeLongs(v[i]);
        }
    }

    public void writeFloats(float[] v, int k, int n) throws IOException {
        int m = this._fb.capacity();
        for (int j = 0; j < n; j += m) {
            int l = Math.min(n - j, m);
            this._fb.position(0).limit(l);
            this._fb.put(v, k + j, l);
            this._bb.position(0).limit(l * 4);
            this._fc.write(this._bb);
        }
    }

    public void writeFloats(float[] v) throws IOException {
        this.writeFloats(v, 0, v.length);
    }

    public void writeFloats(float[][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.writeFloats(v[i]);
        }
    }

    public void writeFloats(float[][][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.writeFloats(v[i]);
        }
    }

    public void writeDoubles(double[] v, int k, int n) throws IOException {
        int m = this._db.capacity();
        for (int j = 0; j < n; j += m) {
            int l = Math.min(n - j, m);
            this._db.position(0).limit(l);
            this._db.put(v, k + j, l);
            this._bb.position(0).limit(l * 8);
            this._fc.write(this._bb);
        }
    }

    public void writeDoubles(double[] v) throws IOException {
        this.writeDoubles(v, 0, v.length);
    }

    public void writeDoubles(double[][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.writeDoubles(v[i]);
        }
    }

    public void writeDoubles(double[][][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.writeDoubles(v[i]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ByteOrder {
        BIG_ENDIAN,
        LITTLE_ENDIAN;

    }
}

