/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.io;

import edu.mines.jtk.io.ArrayOutput;
import edu.mines.jtk.io.ArrayOutputAdapter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;

public class ArrayOutputStream
extends FilterOutputStream
implements ArrayOutput {
    private ArrayOutput _ao;
    private ByteOrder _bo;

    public ArrayOutputStream(OutputStream os) {
        this(os, ByteOrder.BIG_ENDIAN);
    }

    public ArrayOutputStream(FileOutputStream fos) {
        this(fos, ByteOrder.BIG_ENDIAN);
    }

    public ArrayOutputStream(String name) throws FileNotFoundException {
        this(new FileOutputStream(name));
    }

    public ArrayOutputStream(File file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public ArrayOutputStream(OutputStream os, ByteOrder bo) {
        super(os);
        this._ao = new ArrayOutputAdapter(new DataOutputStream(os), bo);
        this._bo = bo;
    }

    public ArrayOutputStream(FileOutputStream fos, ByteOrder bo) {
        super(fos);
        this._ao = new ArrayOutputAdapter(fos.getChannel(), new DataOutputStream(fos), bo);
        this._bo = bo;
    }

    public ArrayOutputStream(String name, ByteOrder bo) throws FileNotFoundException {
        this(new FileOutputStream(name), bo);
    }

    public ArrayOutputStream(File file, ByteOrder bo) throws FileNotFoundException {
        this(new FileOutputStream(file), bo);
    }

    public ByteOrder getByteOrder() {
        return this._bo;
    }

    public void write(int b) throws IOException {
        this._ao.write(b);
    }

    public void write(byte[] b) throws IOException {
        this._ao.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this._ao.write(b, off, len);
    }

    public void writeBoolean(boolean v) throws IOException {
        this._ao.writeBoolean(v);
    }

    public void writeByte(int v) throws IOException {
        this._ao.writeByte(v);
    }

    public void writeShort(int v) throws IOException {
        this._ao.writeShort(v);
    }

    public void writeChar(int v) throws IOException {
        this._ao.writeChar(v);
    }

    public void writeInt(int v) throws IOException {
        this._ao.writeInt(v);
    }

    public void writeLong(long v) throws IOException {
        this._ao.writeLong(v);
    }

    public void writeFloat(float v) throws IOException {
        this._ao.writeFloat(v);
    }

    public void writeDouble(double v) throws IOException {
        this._ao.writeDouble(v);
    }

    public void writeBytes(String s) throws IOException {
        this._ao.writeBytes(s);
    }

    public void writeChars(String s) throws IOException {
        this._ao.writeChars(s);
    }

    public void writeUTF(String s) throws IOException {
        this._ao.writeUTF(s);
    }

    public void writeBytes(byte[] v, int k, int n) throws IOException {
        this._ao.writeBytes(v, k, n);
    }

    public void writeBytes(byte[] v) throws IOException {
        this._ao.writeBytes(v);
    }

    public void writeBytes(byte[][] v) throws IOException {
        this._ao.writeBytes(v);
    }

    public void writeBytes(byte[][][] v) throws IOException {
        this._ao.writeBytes(v);
    }

    public void writeChars(char[] v, int k, int n) throws IOException {
        this._ao.writeChars(v, k, n);
    }

    public void writeChars(char[] v) throws IOException {
        this._ao.writeChars(v);
    }

    public void writeChars(char[][] v) throws IOException {
        this._ao.writeChars(v);
    }

    public void writeChars(char[][][] v) throws IOException {
        this._ao.writeChars(v);
    }

    public void writeShorts(short[] v, int k, int n) throws IOException {
        this._ao.writeShorts(v, k, n);
    }

    public void writeShorts(short[] v) throws IOException {
        this._ao.writeShorts(v);
    }

    public void writeShorts(short[][] v) throws IOException {
        this._ao.writeShorts(v);
    }

    public void writeShorts(short[][][] v) throws IOException {
        this._ao.writeShorts(v);
    }

    public void writeInts(int[] v, int k, int n) throws IOException {
        this._ao.writeInts(v, k, n);
    }

    public void writeInts(int[] v) throws IOException {
        this._ao.writeInts(v);
    }

    public void writeInts(int[][] v) throws IOException {
        this._ao.writeInts(v);
    }

    public void writeInts(int[][][] v) throws IOException {
        this._ao.writeInts(v);
    }

    public void writeLongs(long[] v, int k, int n) throws IOException {
        this._ao.writeLongs(v, k, n);
    }

    public void writeLongs(long[] v) throws IOException {
        this._ao.writeLongs(v);
    }

    public void writeLongs(long[][] v) throws IOException {
        this._ao.writeLongs(v);
    }

    public void writeLongs(long[][][] v) throws IOException {
        this._ao.writeLongs(v);
    }

    public void writeFloats(float[] v, int k, int n) throws IOException {
        this._ao.writeFloats(v, k, n);
    }

    public void writeFloats(float[] v) throws IOException {
        this._ao.writeFloats(v);
    }

    public void writeFloats(float[][] v) throws IOException {
        this._ao.writeFloats(v);
    }

    public void writeFloats(float[][][] v) throws IOException {
        this._ao.writeFloats(v);
    }

    public void writeDoubles(double[] v, int k, int n) throws IOException {
        this._ao.writeDoubles(v, k, n);
    }

    public void writeDoubles(double[] v) throws IOException {
        this._ao.writeDoubles(v);
    }

    public void writeDoubles(double[][] v) throws IOException {
        this._ao.writeDoubles(v);
    }

    public void writeDoubles(double[][][] v) throws IOException {
        this._ao.writeDoubles(v);
    }
}

