/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.io;

import edu.mines.jtk.io.ArrayOutput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.WritableByteChannel;

public class ArrayOutputAdapter
implements ArrayOutput {
    private byte[] _buffer;
    private WritableByteChannel _wbc;
    private DataOutput _do;
    private ByteOrder _bo;
    private ByteBuffer _bb;
    private CharBuffer _cb;
    private ShortBuffer _sb;
    private IntBuffer _ib;
    private LongBuffer _lb;
    private FloatBuffer _fb;
    private DoubleBuffer _db;

    public ArrayOutputAdapter(DataOutput output) {
        this(output, ByteOrder.BIG_ENDIAN);
    }

    public ArrayOutputAdapter(RandomAccessFile file) {
        this(file, ByteOrder.BIG_ENDIAN);
    }

    public ArrayOutputAdapter(FileOutputStream stream) {
        this(stream, ByteOrder.BIG_ENDIAN);
    }

    public ArrayOutputAdapter(DataOutput output, ByteOrder order) {
        this(null, output, order);
    }

    public ArrayOutputAdapter(RandomAccessFile file, ByteOrder order) {
        this(file.getChannel(), file, order);
    }

    public ArrayOutputAdapter(FileOutputStream stream, ByteOrder order) {
        this(stream.getChannel(), new DataOutputStream(stream), order);
    }

    public ArrayOutputAdapter(WritableByteChannel channel, DataOutput output, ByteOrder order) {
        this._wbc = channel;
        this._do = output;
        this._bo = order;
        if (this._wbc != null) {
            this._bb = ByteBuffer.allocateDirect(4096);
        } else {
            this._buffer = new byte[4096];
            this._bb = ByteBuffer.wrap(this._buffer);
        }
        if (order == ByteOrder.BIG_ENDIAN) {
            this._bb.order(ByteOrder.BIG_ENDIAN);
        } else {
            this._bb.order(ByteOrder.LITTLE_ENDIAN);
        }
        this._cb = this._bb.asCharBuffer();
        this._sb = this._bb.asShortBuffer();
        this._ib = this._bb.asIntBuffer();
        this._lb = this._bb.asLongBuffer();
        this._fb = this._bb.asFloatBuffer();
        this._db = this._bb.asDoubleBuffer();
    }

    public ByteOrder getByteOrder() {
        return this._bo;
    }

    public void write(int b) throws IOException {
        this._do.write(b);
    }

    public void write(byte[] b) throws IOException {
        this._do.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this._do.write(b, off, len);
    }

    public void writeBoolean(boolean v) throws IOException {
        this._do.writeBoolean(v);
    }

    public void writeByte(int v) throws IOException {
        this._do.writeByte(v);
    }

    public void writeShort(int v) throws IOException {
        if (this._bo == ByteOrder.BIG_ENDIAN) {
            this._do.write(v >>> 8 & 0xFF);
            this._do.write(v & 0xFF);
        } else {
            this._do.write(v & 0xFF);
            this._do.write(v >>> 8 & 0xFF);
        }
    }

    public void writeChar(int v) throws IOException {
        this._do.writeShort(v);
    }

    public void writeInt(int v) throws IOException {
        if (this._bo == ByteOrder.BIG_ENDIAN) {
            this._do.write(v >>> 24 & 0xFF);
            this._do.write(v >>> 16 & 0xFF);
            this._do.write(v >>> 8 & 0xFF);
            this._do.write(v & 0xFF);
        } else {
            this._do.write(v & 0xFF);
            this._do.write(v >>> 8 & 0xFF);
            this._do.write(v >>> 16 & 0xFF);
            this._do.write(v >>> 24 & 0xFF);
        }
    }

    public void writeLong(long v) throws IOException {
        if (this._bo == ByteOrder.BIG_ENDIAN) {
            this._do.write((int)(v >>> 56) & 0xFF);
            this._do.write((int)(v >>> 48) & 0xFF);
            this._do.write((int)(v >>> 40) & 0xFF);
            this._do.write((int)(v >>> 32) & 0xFF);
            this._do.write((int)(v >>> 24) & 0xFF);
            this._do.write((int)(v >>> 16) & 0xFF);
            this._do.write((int)(v >>> 8) & 0xFF);
            this._do.write((int)v & 0xFF);
        } else {
            this._do.write((int)v & 0xFF);
            this._do.write((int)(v >>> 8) & 0xFF);
            this._do.write((int)(v >>> 16) & 0xFF);
            this._do.write((int)(v >>> 24) & 0xFF);
            this._do.write((int)(v >>> 32) & 0xFF);
            this._do.write((int)(v >>> 40) & 0xFF);
            this._do.write((int)(v >>> 48) & 0xFF);
            this._do.write((int)(v >>> 56) & 0xFF);
        }
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeBytes(String s) throws IOException {
        this._do.writeBytes(s);
    }

    public void writeChars(String s) throws IOException {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    public void writeUTF(String s) throws IOException {
        this._do.writeUTF(s);
    }

    public void writeBytes(byte[] v, int k, int n) throws IOException {
        this.write(v, k, n);
    }

    public void writeBytes(byte[] v) throws IOException {
        this.write(v);
    }

    public void writeBytes(byte[][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.writeBytes(v[i]);
        }
    }

    public void writeBytes(byte[][][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.writeBytes(v[i]);
        }
    }

    public void writeChars(char[] v, int k, int n) throws IOException {
        int m = this._cb.capacity();
        for (int j = 0; j < n; j += m) {
            int l = Math.min(n - j, m);
            this._cb.position(0).limit(l);
            this._cb.put(v, k + j, l);
            if (this._wbc != null) {
                this._bb.position(0).limit(l * 2);
                this._wbc.write(this._bb);
                continue;
            }
            this._do.write(this._buffer, 0, l * 2);
        }
    }

    public void writeChars(char[] v) throws IOException {
        this.writeChars(v, 0, v.length);
    }

    public void writeChars(char[][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.writeChars(v[i]);
        }
    }

    public void writeChars(char[][][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.writeChars(v[i]);
        }
    }

    public void writeShorts(short[] v, int k, int n) throws IOException {
        int m = this._sb.capacity();
        for (int j = 0; j < n; j += m) {
            int l = Math.min(n - j, m);
            this._sb.position(0).limit(l);
            this._sb.put(v, k + j, l);
            if (this._wbc != null) {
                this._bb.position(0).limit(l * 2);
                this._wbc.write(this._bb);
                continue;
            }
            this._do.write(this._buffer, 0, l * 2);
        }
    }

    public void writeShorts(short[] v) throws IOException {
        this.writeShorts(v, 0, v.length);
    }

    public void writeShorts(short[][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.writeShorts(v[i]);
        }
    }

    public void writeShorts(short[][][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.writeShorts(v[i]);
        }
    }

    public void writeInts(int[] v, int k, int n) throws IOException {
        int m = this._ib.capacity();
        for (int j = 0; j < n; j += m) {
            int l = Math.min(n - j, m);
            this._ib.position(0).limit(l);
            this._ib.put(v, k + j, l);
            if (this._wbc != null) {
                this._bb.position(0).limit(l * 4);
                this._wbc.write(this._bb);
                continue;
            }
            this._do.write(this._buffer, 0, l * 4);
        }
    }

    public void writeInts(int[] v) throws IOException {
        this.writeInts(v, 0, v.length);
    }

    public void writeInts(int[][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.writeInts(v[i]);
        }
    }

    public void writeInts(int[][][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.writeInts(v[i]);
        }
    }

    public void writeLongs(long[] v, int k, int n) throws IOException {
        int m = this._lb.capacity();
        for (int j = 0; j < n; j += m) {
            int l = Math.min(n - j, m);
            this._lb.position(0).limit(l);
            this._lb.put(v, k + j, l);
            if (this._wbc != null) {
                this._bb.position(0).limit(l * 8);
                this._wbc.write(this._bb);
                continue;
            }
            this._do.write(this._buffer, 0, l * 8);
        }
    }

    public void writeLongs(long[] v) throws IOException {
        this.writeLongs(v, 0, v.length);
    }

    public void writeLongs(long[][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.writeLongs(v[i]);
        }
    }

    public void writeLongs(long[][][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.writeLongs(v[i]);
        }
    }

    public void writeFloats(float[] v, int k, int n) throws IOException {
        int m = this._fb.capacity();
        for (int j = 0; j < n; j += m) {
            int l = Math.min(n - j, m);
            this._fb.position(0).limit(l);
            this._fb.put(v, k + j, l);
            if (this._wbc != null) {
                this._bb.position(0).limit(l * 4);
                this._wbc.write(this._bb);
                continue;
            }
            this._do.write(this._buffer, 0, l * 4);
        }
    }

    public void writeFloats(float[] v) throws IOException {
        this.writeFloats(v, 0, v.length);
    }

    public void writeFloats(float[][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.writeFloats(v[i]);
        }
    }

    public void writeFloats(float[][][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.writeFloats(v[i]);
        }
    }

    public void writeDoubles(double[] v, int k, int n) throws IOException {
        int m = this._db.capacity();
        for (int j = 0; j < n; j += m) {
            int l = Math.min(n - j, m);
            this._db.position(0).limit(l);
            this._db.put(v, k + j, l);
            if (this._wbc != null) {
                this._bb.position(0).limit(l * 8);
                this._wbc.write(this._bb);
                continue;
            }
            this._do.write(this._buffer, 0, l * 8);
        }
    }

    public void writeDoubles(double[] v) throws IOException {
        this.writeDoubles(v, 0, v.length);
    }

    public void writeDoubles(double[][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.writeDoubles(v[i]);
        }
    }

    public void writeDoubles(double[][][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.writeDoubles(v[i]);
        }
    }
}

