/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.io;

import edu.mines.jtk.io.ArrayInput;
import edu.mines.jtk.io.ArrayInputAdapter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;

public class ArrayInputStream
extends FilterInputStream
implements ArrayInput {
    private ArrayInput _ai;
    private ByteOrder _bo;

    public ArrayInputStream(InputStream is) {
        this(is, ByteOrder.BIG_ENDIAN);
    }

    public ArrayInputStream(FileInputStream fis) {
        this(fis, ByteOrder.BIG_ENDIAN);
    }

    public ArrayInputStream(String name) throws FileNotFoundException {
        this(new FileInputStream(name));
    }

    public ArrayInputStream(File file) throws FileNotFoundException {
        this(new FileInputStream(file));
    }

    public ArrayInputStream(InputStream is, ByteOrder bo) {
        super(is);
        this._ai = new ArrayInputAdapter(new DataInputStream(is), bo);
        this._bo = bo;
    }

    public ArrayInputStream(FileInputStream fis, ByteOrder bo) {
        super(fis);
        this._ai = new ArrayInputAdapter(fis.getChannel(), new DataInputStream(fis), bo);
        this._bo = bo;
    }

    public ArrayInputStream(String name, ByteOrder bo) throws FileNotFoundException {
        this(new FileInputStream(name), bo);
    }

    public ArrayInputStream(File file, ByteOrder bo) throws FileNotFoundException {
        this(new FileInputStream(file), bo);
    }

    public ByteOrder getByteOrder() {
        return this._bo;
    }

    public void readFully(byte[] b) throws IOException {
        this._ai.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this._ai.readFully(b, off, len);
    }

    public int skipBytes(int n) throws IOException {
        return this._ai.skipBytes(n);
    }

    public final boolean readBoolean() throws IOException {
        return this._ai.readBoolean();
    }

    public final byte readByte() throws IOException {
        return this._ai.readByte();
    }

    public final int readUnsignedByte() throws IOException {
        return this._ai.readUnsignedByte();
    }

    public final short readShort() throws IOException {
        return this._ai.readShort();
    }

    public final int readUnsignedShort() throws IOException {
        return this._ai.readUnsignedShort();
    }

    public final char readChar() throws IOException {
        return this._ai.readChar();
    }

    public final int readInt() throws IOException {
        return this._ai.readInt();
    }

    public final long readLong() throws IOException {
        return this._ai.readLong();
    }

    public final float readFloat() throws IOException {
        return this._ai.readFloat();
    }

    public final double readDouble() throws IOException {
        return this._ai.readDouble();
    }

    public final String readLine() throws IOException {
        return this._ai.readLine();
    }

    public final String readUTF() throws IOException {
        return this._ai.readUTF();
    }

    public void readBytes(byte[] v, int k, int n) throws IOException {
        this._ai.readBytes(v, k, n);
    }

    public void readBytes(byte[] v) throws IOException {
        this._ai.readBytes(v);
    }

    public void readBytes(byte[][] v) throws IOException {
        this._ai.readBytes(v);
    }

    public void readBytes(byte[][][] v) throws IOException {
        this._ai.readBytes(v);
    }

    public void readChars(char[] v, int k, int n) throws IOException {
        this._ai.readChars(v, k, n);
    }

    public void readChars(char[] v) throws IOException {
        this._ai.readChars(v);
    }

    public void readChars(char[][] v) throws IOException {
        this._ai.readChars(v);
    }

    public void readChars(char[][][] v) throws IOException {
        this._ai.readChars(v);
    }

    public void readShorts(short[] v, int k, int n) throws IOException {
        this._ai.readShorts(v, k, n);
    }

    public void readShorts(short[] v) throws IOException {
        this._ai.readShorts(v);
    }

    public void readShorts(short[][] v) throws IOException {
        this._ai.readShorts(v);
    }

    public void readShorts(short[][][] v) throws IOException {
        this._ai.readShorts(v);
    }

    public void readInts(int[] v, int k, int n) throws IOException {
        this._ai.readInts(v, k, n);
    }

    public void readInts(int[] v) throws IOException {
        this._ai.readInts(v);
    }

    public void readInts(int[][] v) throws IOException {
        this._ai.readInts(v);
    }

    public void readInts(int[][][] v) throws IOException {
        this._ai.readInts(v);
    }

    public void readLongs(long[] v, int k, int n) throws IOException {
        this._ai.readLongs(v, k, n);
    }

    public void readLongs(long[] v) throws IOException {
        this._ai.readLongs(v);
    }

    public void readLongs(long[][] v) throws IOException {
        this._ai.readLongs(v);
    }

    public void readLongs(long[][][] v) throws IOException {
        this._ai.readLongs(v);
    }

    public void readFloats(float[] v, int k, int n) throws IOException {
        this._ai.readFloats(v, k, n);
    }

    public void readFloats(float[] v) throws IOException {
        this._ai.readFloats(v);
    }

    public void readFloats(float[][] v) throws IOException {
        this._ai.readFloats(v);
    }

    public void readFloats(float[][][] v) throws IOException {
        this._ai.readFloats(v);
    }

    public void readDoubles(double[] v, int k, int n) throws IOException {
        this._ai.readDoubles(v, k, n);
    }

    public void readDoubles(double[] v) throws IOException {
        this._ai.readDoubles(v);
    }

    public void readDoubles(double[][] v) throws IOException {
        this._ai.readDoubles(v);
    }

    public void readDoubles(double[][][] v) throws IOException {
        this._ai.readDoubles(v);
    }
}

