/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.io;

import edu.mines.jtk.io.ArrayInput;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.ReadableByteChannel;

public class ArrayInputAdapter
implements ArrayInput {
    private byte[] _buffer;
    private ReadableByteChannel _rbc;
    private DataInput _di;
    private ByteOrder _bo;
    private ByteBuffer _bb;
    private CharBuffer _cb;
    private ShortBuffer _sb;
    private IntBuffer _ib;
    private LongBuffer _lb;
    private FloatBuffer _fb;
    private DoubleBuffer _db;

    public ArrayInputAdapter(DataInput input) {
        this(input, ByteOrder.BIG_ENDIAN);
    }

    public ArrayInputAdapter(RandomAccessFile file) {
        this(file, ByteOrder.BIG_ENDIAN);
    }

    public ArrayInputAdapter(FileInputStream stream) {
        this(stream, ByteOrder.BIG_ENDIAN);
    }

    public ArrayInputAdapter(DataInput input, ByteOrder order) {
        this(null, input, order);
    }

    public ArrayInputAdapter(RandomAccessFile file, ByteOrder order) {
        this(file.getChannel(), file, order);
    }

    public ArrayInputAdapter(FileInputStream stream, ByteOrder order) {
        this(stream.getChannel(), new DataInputStream(stream), order);
    }

    public ArrayInputAdapter(ReadableByteChannel channel, DataInput input, ByteOrder order) {
        this._rbc = channel;
        this._di = input;
        this._bo = order;
        if (this._rbc != null) {
            this._bb = ByteBuffer.allocateDirect(4096);
        } else {
            this._buffer = new byte[4096];
            this._bb = ByteBuffer.wrap(this._buffer);
        }
        if (order == ByteOrder.BIG_ENDIAN) {
            this._bb.order(ByteOrder.BIG_ENDIAN);
        } else {
            this._bb.order(ByteOrder.LITTLE_ENDIAN);
        }
        this._cb = this._bb.asCharBuffer();
        this._sb = this._bb.asShortBuffer();
        this._ib = this._bb.asIntBuffer();
        this._lb = this._bb.asLongBuffer();
        this._fb = this._bb.asFloatBuffer();
        this._db = this._bb.asDoubleBuffer();
    }

    public ByteOrder getByteOrder() {
        return this._bo;
    }

    public void readFully(byte[] b) throws IOException {
        this._di.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this._di.readFully(b, off, len);
    }

    public int skipBytes(int n) throws IOException {
        return this._di.skipBytes(n);
    }

    public final boolean readBoolean() throws IOException {
        return this._di.readBoolean();
    }

    public final byte readByte() throws IOException {
        return this._di.readByte();
    }

    public final int readUnsignedByte() throws IOException {
        return this._di.readUnsignedByte();
    }

    public final short readShort() throws IOException {
        int b1 = this._di.readUnsignedByte();
        int b2 = this._di.readUnsignedByte();
        if (this._bo == ByteOrder.BIG_ENDIAN) {
            return (short)((b1 << 8) + b2);
        }
        return (short)((b2 << 8) + b1);
    }

    public final int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    public final char readChar() throws IOException {
        return (char)this.readShort();
    }

    public final int readInt() throws IOException {
        int b1 = this._di.readUnsignedByte();
        int b2 = this._di.readUnsignedByte();
        int b3 = this._di.readUnsignedByte();
        int b4 = this._di.readUnsignedByte();
        if (this._bo == ByteOrder.BIG_ENDIAN) {
            return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
        }
        return (b4 << 24) + (b3 << 16) + (b2 << 8) + b1;
    }

    public final long readLong() throws IOException {
        int i1 = this.readInt();
        int i2 = this.readInt();
        if (this._bo == ByteOrder.BIG_ENDIAN) {
            return ((long)i1 << 32) + ((long)i2 & 0xFFFFFFFFL);
        }
        return ((long)i2 << 32) + ((long)i1 & 0xFFFFFFFFL);
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final String readLine() throws IOException {
        return this._di.readLine();
    }

    public final String readUTF() throws IOException {
        return this._di.readUTF();
    }

    public void readBytes(byte[] v, int k, int n) throws IOException {
        this.readFully(v, k, n);
    }

    public void readBytes(byte[] v) throws IOException {
        this.readFully(v);
    }

    public void readBytes(byte[][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.readBytes(v[i]);
        }
    }

    public void readBytes(byte[][][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.readBytes(v[i]);
        }
    }

    public void readChars(char[] v, int k, int n) throws IOException {
        int m = this._cb.capacity();
        for (int j = 0; j < n; j += m) {
            int l = Math.min(n - j, m);
            if (this._rbc != null) {
                this._bb.position(0).limit(l * 2);
                this._rbc.read(this._bb);
            } else {
                this._di.readFully(this._buffer, 0, l * 2);
            }
            this._cb.position(0).limit(l);
            this._cb.get(v, k + j, l);
        }
    }

    public void readChars(char[] v) throws IOException {
        this.readChars(v, 0, v.length);
    }

    public void readChars(char[][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.readChars(v[i]);
        }
    }

    public void readChars(char[][][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.readChars(v[i]);
        }
    }

    public void readShorts(short[] v, int k, int n) throws IOException {
        int m = this._sb.capacity();
        for (int j = 0; j < n; j += m) {
            int l = Math.min(n - j, m);
            if (this._rbc != null) {
                this._bb.position(0).limit(l * 2);
                this._rbc.read(this._bb);
            } else {
                this._di.readFully(this._buffer, 0, l * 2);
            }
            this._sb.position(0).limit(l);
            this._sb.get(v, k + j, l);
        }
    }

    public void readShorts(short[] v) throws IOException {
        this.readShorts(v, 0, v.length);
    }

    public void readShorts(short[][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.readShorts(v[i]);
        }
    }

    public void readShorts(short[][][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.readShorts(v[i]);
        }
    }

    public void readInts(int[] v, int k, int n) throws IOException {
        int m = this._ib.capacity();
        for (int j = 0; j < n; j += m) {
            int l = Math.min(n - j, m);
            if (this._rbc != null) {
                this._bb.position(0).limit(l * 4);
                this._rbc.read(this._bb);
            } else {
                this._di.readFully(this._buffer, 0, l * 4);
            }
            this._ib.position(0).limit(l);
            this._ib.get(v, k + j, l);
        }
    }

    public void readInts(int[] v) throws IOException {
        this.readInts(v, 0, v.length);
    }

    public void readInts(int[][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.readInts(v[i]);
        }
    }

    public void readInts(int[][][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.readInts(v[i]);
        }
    }

    public void readLongs(long[] v, int k, int n) throws IOException {
        int m = this._lb.capacity();
        for (int j = 0; j < n; j += m) {
            int l = Math.min(n - j, m);
            if (this._rbc != null) {
                this._bb.position(0).limit(l * 8);
                this._rbc.read(this._bb);
            } else {
                this._di.readFully(this._buffer, 0, l * 8);
            }
            this._lb.position(0).limit(l);
            this._lb.get(v, k + j, l);
        }
    }

    public void readLongs(long[] v) throws IOException {
        this.readLongs(v, 0, v.length);
    }

    public void readLongs(long[][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.readLongs(v[i]);
        }
    }

    public void readLongs(long[][][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.readLongs(v[i]);
        }
    }

    public void readFloats(float[] v, int k, int n) throws IOException {
        int m = this._fb.capacity();
        for (int j = 0; j < n; j += m) {
            int l = Math.min(n - j, m);
            if (this._rbc != null) {
                this._bb.position(0).limit(l * 4);
                this._rbc.read(this._bb);
            } else {
                this._di.readFully(this._buffer, 0, l * 4);
            }
            this._fb.position(0).limit(l);
            this._fb.get(v, k + j, l);
        }
    }

    public void readFloats(float[] v) throws IOException {
        this.readFloats(v, 0, v.length);
    }

    public void readFloats(float[][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.readFloats(v[i]);
        }
    }

    public void readFloats(float[][][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.readFloats(v[i]);
        }
    }

    public void readDoubles(double[] v, int k, int n) throws IOException {
        int m = this._db.capacity();
        for (int j = 0; j < n; j += m) {
            int l = Math.min(n - j, m);
            if (this._rbc != null) {
                this._bb.position(0).limit(l * 8);
                this._rbc.read(this._bb);
            } else {
                this._di.readFully(this._buffer, 0, l * 8);
            }
            this._db.position(0).limit(l);
            this._db.get(v, k + j, l);
        }
    }

    public void readDoubles(double[] v) throws IOException {
        this.readDoubles(v, 0, v.length);
    }

    public void readDoubles(double[][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.readDoubles(v[i]);
        }
    }

    public void readDoubles(double[][][] v) throws IOException {
        for (int i = 0; i < v.length; ++i) {
            this.readDoubles(v[i]);
        }
    }
}

