/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp.test;

import edu.mines.jtk.dsp.Recursive2ndOrderFilter;
import edu.mines.jtk.util.Array;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class Recursive2ndOrderFilterTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(Recursive2ndOrderFilterTest.class);
        TestRunner.run((Test)suite);
    }

    public void test1() {
        this.test1(2.0f, 0.0f, 0.0f, 0.9f, 0.0f);
        this.test1(2.0f, 4.0f, 0.0f, 0.9f, 0.0f);
        this.test1(2.0f, 4.0f, 0.0f, 1.8f, 0.81f);
        this.test1(0.0f, 4.0f, 2.0f, 1.8f, 0.81f);
        this.test1(2.0f, 4.0f, 2.0f, 1.8f, 0.81f);
    }

    public void test1(float b0, float b1, float b2, float a1, float a2) {
        int n = 100;
        float[] x = Array.randfloat(n);
        Recursive2ndOrderFilter rf = new Recursive2ndOrderFilter(b0, b1, b2, a1, a2);
        float[] y1 = Array.copy(x);
        rf.applyForward(y1, y1);
        float[] y2 = Array.reverse(x);
        rf.applyReverse(y2, y2);
        y2 = Array.reverse(y2);
        this.assertEqual(y1, y2);
        rf.accumulateForward(y1, y1);
        y2 = Array.reverse(y2);
        rf.accumulateReverse(y2, y2);
        y2 = Array.reverse(y2);
        this.assertEqual(y1, y2);
    }

    public void test2() {
        this.test2(2.0f, 0.0f, 0.0f, 0.9f, 0.0f);
        this.test2(2.0f, 4.0f, 0.0f, 0.9f, 0.0f);
        this.test2(2.0f, 4.0f, 0.0f, 1.8f, 0.81f);
        this.test2(0.0f, 4.0f, 2.0f, 1.8f, 0.81f);
        this.test2(2.0f, 4.0f, 2.0f, 1.8f, 0.81f);
    }

    public void test2(float b0, float b1, float b2, float a1, float a2) {
        int n = 20;
        float[][] x = Array.randfloat(n, n);
        Recursive2ndOrderFilter rf = new Recursive2ndOrderFilter(b0, b1, b2, a1, a2);
        float[][] y1 = Array.copy(x);
        rf.apply1Forward(y1, y1);
        rf.accumulate1Forward(y1, y1);
        float[][] y2 = Array.transpose(x);
        rf.apply2Forward(y2, y2);
        rf.accumulate2Forward(y2, y2);
        y2 = Array.transpose(y2);
        this.assertEqual(y1, y2);
        y1 = Array.copy(x);
        rf.apply1Reverse(y1, y1);
        rf.accumulate1Reverse(y1, y1);
        y2 = Array.transpose(x);
        rf.apply2Reverse(y2, y2);
        rf.accumulate2Reverse(y2, y2);
        y2 = Array.transpose(y2);
        this.assertEqual(y1, y2);
    }

    public void test3() {
        this.test3(2.0f, 0.0f, 0.0f, 0.9f, 0.0f);
        this.test3(2.0f, 4.0f, 0.0f, 0.9f, 0.0f);
        this.test3(2.0f, 4.0f, 0.0f, 1.8f, 0.81f);
        this.test3(0.0f, 4.0f, 2.0f, 1.8f, 0.81f);
        this.test3(2.0f, 4.0f, 2.0f, 1.8f, 0.81f);
    }

    public void test3(float b0, float b1, float b2, float a1, float a2) {
        int n = 20;
        float[][][] x = Array.randfloat(n, n, n);
        Recursive2ndOrderFilter rf = new Recursive2ndOrderFilter(b0, b1, b2, a1, a2);
        float[][][] y1 = Array.copy(x);
        rf.apply1Forward(y1, y1);
        rf.accumulate1Forward(y1, y1);
        float[][][] y2 = Recursive2ndOrderFilterTest.transpose12(x);
        rf.apply2Forward(y2, y2);
        rf.accumulate2Forward(y2, y2);
        y2 = Recursive2ndOrderFilterTest.transpose12(y2);
        this.assertEqual(y1, y2);
        y2 = Recursive2ndOrderFilterTest.transpose13(x);
        rf.apply3Forward(y2, y2);
        rf.accumulate3Forward(y2, y2);
        y2 = Recursive2ndOrderFilterTest.transpose13(y2);
        this.assertEqual(y1, y2);
        y1 = Array.copy(x);
        rf.apply1Reverse(y1, y1);
        rf.accumulate1Reverse(y1, y1);
        y2 = Recursive2ndOrderFilterTest.transpose12(x);
        rf.apply2Reverse(y2, y2);
        rf.accumulate2Reverse(y2, y2);
        y2 = Recursive2ndOrderFilterTest.transpose12(y2);
        this.assertEqual(y1, y2);
        y2 = Recursive2ndOrderFilterTest.transpose13(x);
        rf.apply3Reverse(y2, y2);
        rf.accumulate3Reverse(y2, y2);
        y2 = Recursive2ndOrderFilterTest.transpose13(y2);
        this.assertEqual(y1, y2);
    }

    private void assertEqual(float[] re, float[] ra) {
        int n = re.length;
        float tolerance = (float)n * 1.1920929E-7f;
        for (int i = 0; i < n; ++i) {
            Recursive2ndOrderFilterTest.assertEquals((float)re[i], (float)ra[i], (float)tolerance);
        }
    }

    private void assertEqual(float[][] re, float[][] ra) {
        int n2 = re.length;
        int n1 = re[0].length;
        float tolerance = (float)(n1 * n2) * 1.1920929E-7f;
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                Recursive2ndOrderFilterTest.assertEquals((float)re[i2][i1], (float)ra[i2][i1], (float)tolerance);
            }
        }
    }

    private void assertEqual(float[][][] re, float[][][] ra) {
        int n3 = re.length;
        int n2 = re[0].length;
        int n1 = re[0][0].length;
        float tolerance = (float)(n1 * n2 * n3) * 1.1920929E-7f;
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    Recursive2ndOrderFilterTest.assertEquals((float)re[i3][i2][i1], (float)ra[i3][i2][i1], (float)tolerance);
                }
            }
        }
    }

    private static float[][][] transpose12(float[][][] x) {
        int n3 = x.length;
        int n2 = x[0].length;
        int n1 = x[0][0].length;
        float[][][] y = new float[n3][n1][n2];
        for (int i3 = 0; i3 < n3; ++i3) {
            float[][] y3 = y[i3];
            for (int i2 = 0; i2 < n2; ++i2) {
                float[] x32 = x[i3][i2];
                for (int i1 = 0; i1 < n1; ++i1) {
                    y3[i1][i2] = x32[i1];
                }
            }
        }
        return y;
    }

    private static float[][][] transpose13(float[][][] x) {
        int n3 = x.length;
        int n2 = x[0].length;
        int n1 = x[0][0].length;
        float[][][] y = new float[n1][n2][n3];
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                float[] x32 = x[i3][i2];
                for (int i1 = 0; i1 < n1; ++i1) {
                    y[i1][i2][i3] = x32[i1];
                }
            }
        }
        return y;
    }
}

