/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp.test;

import edu.mines.jtk.dsp.FftComplex;
import edu.mines.jtk.dsp.FftReal;
import edu.mines.jtk.util.Array;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FftRealTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(FftRealTest.class);
        TestRunner.run((Test)suite);
    }

    public void test1() {
        int nmax = 1000;
        for (int n = 2; n < nmax; ++n) {
            float[] rx;
            float[] c1;
            int nfft = FftReal.nfftSmall(n);
            FftReal fft = new FftReal(nfft);
            int nw = nfft / 2 + 1;
            float[] r1 = c1 = Array.czerofloat(nw);
            r1[1] = 1.0f;
            float[] cx = rx = Array.ccopy(r1);
            fft.realToComplex(1, rx, cx);
            float ra = 0.0f;
            float rb = (float)Math.PI * 2 / (float)nfft;
            float[] amp = Array.fillfloat(1.0f, nw);
            float[] phs = Array.rampfloat(ra, rb, nw);
            float[] cc = Array.polar(amp, phs);
            this.assertComplexEqual(nw, cc, cx);
            fft.complexToReal(-1, cx, rx);
            fft.scale(nfft, rx);
            this.assertRealEqual(nfft, r1, rx);
        }
    }

    public void test12() {
        int n1max = 26;
        int n2max = 26;
        for (int n2 = 2; n2 < n2max; ++n2) {
            int n2fft = FftComplex.nfftSmall(n2);
            FftComplex fft2 = new FftComplex(n2fft);
            for (int n1 = 2; n1 < n1max; ++n1) {
                float[][] rx;
                float[][] c1;
                int n1fft = FftReal.nfftSmall(n1);
                FftReal fft1 = new FftReal(n1fft);
                int nw = n1fft / 2 + 1;
                float[][] r1 = c1 = Array.czerofloat(nw, n2fft);
                r1[1][1] = 1.0f;
                float[][] cx = rx = Array.ccopy(r1);
                fft1.realToComplex1(1, n2, rx, cx);
                fft2.complexToComplex2(1, nw, cx, cx);
                float ra = 0.0f;
                float rb1 = (float)Math.PI * 2 / (float)n1fft;
                float rb2 = (float)Math.PI * 2 / (float)n2fft;
                float[][] amp = Array.fillfloat(1.0f, nw, n2fft);
                float[][] phs = Array.rampfloat(ra, rb1, rb2, nw, n2fft);
                float[][] cc = Array.polar(amp, phs);
                this.assertComplexEqual(nw, n2fft, cc, cx);
                fft2.complexToComplex2(-1, nw, cx, cx);
                fft2.scale(nw, n2, cx);
                fft1.complexToReal1(-1, n2, cx, rx);
                fft1.scale(n1, n2, rx);
                this.assertRealEqual(n1, n2, r1, rx);
            }
        }
    }

    public void test21() {
        int n1max = 26;
        int n2max = 26;
        for (int n2 = 2; n2 < n2max; ++n2) {
            int n2fft = FftReal.nfftSmall(n2);
            FftReal fft2 = new FftReal(n2fft);
            int nw = n2fft / 2 + 1;
            for (int n1 = 2; n1 < n1max; ++n1) {
                float[][] rx;
                float[][] c1;
                int n1fft = FftComplex.nfftSmall(n1);
                FftComplex fft1 = new FftComplex(n1fft);
                float[][] r1 = c1 = Array.czerofloat(n1fft, n2fft);
                r1[1][1] = 1.0f;
                float[][] cx = rx = Array.ccopy(r1);
                fft2.realToComplex2(1, n1, rx, cx);
                fft1.complexToComplex1(1, nw, cx, cx);
                float ra = 0.0f;
                float rb1 = (float)Math.PI * 2 / (float)n1fft;
                float rb2 = (float)Math.PI * 2 / (float)n2fft;
                float[][] amp = Array.fillfloat(1.0f, n1fft, nw);
                float[][] phs = Array.rampfloat(ra, rb1, rb2, n1fft, nw);
                float[][] cc = Array.polar(amp, phs);
                this.assertComplexEqual(n1fft, nw, cc, cx);
                fft1.complexToComplex1(-1, nw, cx, cx);
                fft1.scale(n1, nw, cx);
                fft2.complexToReal2(-1, n1, cx, rx);
                fft2.scale(n1, n2, rx);
                this.assertRealEqual(n1, n2, r1, rx);
            }
        }
    }

    public void test1Random() {
        int nmax = 1000;
        for (int n = 2; n < nmax; ++n) {
            int nfft = FftReal.nfftSmall(n);
            FftReal fft = new FftReal(nfft);
            int nw = nfft / 2 + 1;
            float[] rr = Array.randfloat(nfft);
            float[] rx = Array.copy(rr);
            float[] cy = Array.czerofloat(nw);
            fft.realToComplex(1, rx, cy);
            fft.complexToReal(-1, cy, rx);
            fft.scale(nfft, rx);
            this.assertRealEqual(nfft, rr, rx);
        }
    }

    public void test12Random() {
        int n1max = 26;
        int n2max = 26;
        for (int n2 = 2; n2 < n2max; ++n2) {
            int n2fft = FftComplex.nfftSmall(n2);
            FftComplex fft2 = new FftComplex(n2fft);
            for (int n1 = 2; n1 < n1max; ++n1) {
                int n1fft = FftReal.nfftSmall(n1);
                FftReal fft1 = new FftReal(n1fft);
                int nw = n1fft / 2 + 1;
                float[][] rr = Array.randfloat(n1fft, n2);
                float[][] rx = Array.copy(rr);
                float[][] cy = Array.czerofloat(nw, n2fft);
                fft1.realToComplex1(1, n2, rx, cy);
                fft2.complexToComplex2(1, nw, cy, cy);
                fft2.complexToComplex2(-1, nw, cy, cy);
                fft2.scale(nw, n2, cy);
                fft1.complexToReal1(-1, n2, cy, rx);
                fft1.scale(n1, n2, rx);
                this.assertRealEqual(n1, n2, rr, rx);
            }
        }
    }

    public void test21Random() {
        int n1max = 26;
        int n2max = 26;
        for (int n2 = 2; n2 < n2max; ++n2) {
            int n2fft = FftReal.nfftSmall(n2);
            FftReal fft2 = new FftReal(n2fft);
            int nw = n2fft / 2 + 1;
            for (int n1 = 2; n1 < n1max; ++n1) {
                int n1fft = FftComplex.nfftSmall(n1);
                FftComplex fft1 = new FftComplex(n1fft);
                float[][] rr = Array.randfloat(n1, n2fft);
                float[][] rx = Array.copy(rr);
                float[][] cy = Array.czerofloat(n1fft, nw);
                fft2.realToComplex2(1, n1, rx, cy);
                fft1.complexToComplex1(1, nw, cy, cy);
                fft1.complexToComplex1(-1, nw, cy, cy);
                fft1.scale(n1, nw, cy);
                fft2.complexToReal2(-1, n1, cy, rx);
                fft2.scale(n1, n2, rx);
                this.assertRealEqual(n1, n2, rr, rx);
            }
        }
    }

    private void assertRealEqual(int n1, float[] re, float[] ra) {
        float tolerance = (float)n1 * 1.1920929E-7f;
        for (int i1 = 0; i1 < n1; ++i1) {
            FftRealTest.assertEquals((float)re[i1], (float)ra[i1], (float)tolerance);
        }
    }

    private void assertRealEqual(int n1, int n2, float[][] re, float[][] ra) {
        float tolerance = (float)(n1 + n2) * 1.1920929E-7f;
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                try {
                    FftRealTest.assertEquals((float)re[i2][i1], (float)ra[i2][i1], (float)tolerance);
                    continue;
                }
                catch (AssertionFailedError e) {
                    System.out.println("index i1=" + i1 + " i2=" + i2);
                    throw e;
                }
            }
        }
    }

    private void assertComplexEqual(int n1, float[] ce, float[] ca) {
        float tolerance = (float)n1 * 1.1920929E-7f;
        for (int i1 = 0; i1 < n1; ++i1) {
            FftRealTest.assertEquals((float)ce[2 * i1], (float)ca[2 * i1], (float)tolerance);
            FftRealTest.assertEquals((float)ce[2 * i1 + 1], (float)ca[2 * i1 + 1], (float)tolerance);
        }
    }

    private void assertComplexEqual(int n1, int n2, float[][] ce, float[][] ca) {
        float tolerance = (float)(n1 + n2) * 1.1920929E-7f;
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                try {
                    FftRealTest.assertEquals((float)ce[i2][2 * i1], (float)ca[i2][2 * i1], (float)tolerance);
                    FftRealTest.assertEquals((float)ce[i2][2 * i1 + 1], (float)ca[i2][2 * i1 + 1], (float)tolerance);
                    continue;
                }
                catch (AssertionFailedError e) {
                    System.out.println("index i1=" + i1 + " i2=" + i2);
                    throw e;
                }
            }
        }
    }
}

