/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp.test;

import edu.mines.jtk.dsp.Eigen;
import edu.mines.jtk.util.Array;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EigenTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(EigenTest.class);
        TestRunner.run((Test)suite);
    }

    public void testSymmetric22() {
        int nrand = 10;
        for (int irand = 0; irand < nrand; ++irand) {
            float[][] a = Array.randfloat(2, 2);
            a = Array.add(a, Array.transpose(a));
            float[][] v = new float[2][2];
            float[] d = new float[2];
            Eigen.solveSymmetric22(a, v, d);
            this.check(a, v, d);
        }
    }

    public void testSymmetric33() {
        int nrand = 10;
        for (int irand = 0; irand < nrand; ++irand) {
            float[][] a = Array.randfloat(3, 3);
            a = Array.add(a, Array.transpose(a));
            float[][] v = new float[3][3];
            float[] d = new float[3];
            Eigen.solveSymmetric33(a, v, d);
            this.check(a, v, d);
        }
    }

    private void check(float[][] a, float[][] v, float[] d) {
        int n = a.length;
        for (int k = 0; k < n; ++k) {
            EigenTest.assertTrue((k == 0 || d[k - 1] >= d[k] ? 1 : 0) != 0);
            for (int i = 0; i < n; ++i) {
                float av = 0.0f;
                for (int j = 0; j < n; ++j) {
                    av += a[i][j] * v[k][j];
                }
                float vd = v[k][i] * d[k];
                EigenTest.assertEquals((double)av, (double)vd, (double)0.001);
            }
        }
    }
}

