/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp.test;

import edu.mines.jtk.dsp.DifferenceFilter;
import edu.mines.jtk.util.Array;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class DifferenceFilterTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(DifferenceFilterTest.class);
        TestRunner.run((Test)suite);
    }

    public void test1Impulse() {
        float[] e = new float[]{0.0f, 0.0f, 0.0f, -1.0f, 2.0f, -1.0f, 0.0f, 0.0f, 0.0f};
        int n = e.length;
        float[] x = new float[n];
        float[] y = new float[n];
        float[] z = new float[n];
        x[(n - 1) / 2] = 1.0f;
        DifferenceFilter df = new DifferenceFilter();
        df.apply(x, y);
        df.applyInverse(y, z);
        DifferenceFilterTest.assertEqual(x, z, 1.1920929E-6f);
        df.applyTranspose(x, y);
        df.applyInverseTranspose(y, z);
        DifferenceFilterTest.assertEqual(x, z, 1.1920929E-6f);
        df.apply(x, y);
        df.applyTranspose(y, z);
        DifferenceFilterTest.assertEqual(e, z, 0.02f);
    }

    public void test2Impulse() {
        float[][] e = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, -1.0f, 4.0f, -1.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}};
        int n1 = e[0].length;
        int n2 = e.length;
        float[][] x = new float[n2][n1];
        float[][] y = new float[n2][n1];
        float[][] z = new float[n2][n1];
        x[(n2 - 1) / 2][(n1 - 1) / 2] = 1.0f;
        DifferenceFilter df = new DifferenceFilter();
        df.apply(x, y);
        df.applyInverse(y, z);
        DifferenceFilterTest.assertEqual(x, z, 1.1920929E-6f);
        df.applyTranspose(x, y);
        df.applyInverseTranspose(y, z);
        DifferenceFilterTest.assertEqual(x, z, 1.1920929E-6f);
        df.apply(x, y);
        df.applyTranspose(y, z);
        DifferenceFilterTest.assertEqual(e, z, 0.04f);
    }

    public void test3Impulse() {
        float[][][] e = new float[][][]{new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}}, new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}}, new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, -1.0f, 6.0f, -1.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}}, new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}}, new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}}};
        int n1 = e[0][0].length;
        int n2 = e[0].length;
        int n3 = e.length;
        float[][][] x = new float[n3][n2][n1];
        float[][][] y = new float[n3][n2][n1];
        float[][][] z = new float[n3][n2][n1];
        x[(n3 - 1) / 2][(n2 - 1) / 2][(n1 - 1) / 2] = 1.0f;
        DifferenceFilter df = new DifferenceFilter();
        df.apply(x, y);
        df.applyInverse(y, z);
        DifferenceFilterTest.assertEqual(x, z, 1.1920929E-6f);
        df.applyTranspose(x, y);
        df.applyInverseTranspose(y, z);
        DifferenceFilterTest.assertEqual(x, z, 1.1920929E-6f);
        df.apply(x, y);
        df.applyTranspose(y, z);
        DifferenceFilterTest.assertEqual(e, z, 0.06f);
    }

    public void test1Random() {
        DifferenceFilter df = new DifferenceFilter();
        int n = 100;
        float[] x = DifferenceFilterTest.randfloat(n);
        float[] y = DifferenceFilterTest.zerofloat(n);
        float[] z = DifferenceFilterTest.zerofloat(n);
        df.apply(x, y);
        df.applyInverse(y, z);
        DifferenceFilterTest.assertEqual(x, z);
        df.applyTranspose(x, y);
        df.applyInverseTranspose(y, z);
        DifferenceFilterTest.assertEqual(x, z);
        float tiny = (float)n * 10.0f * 1.1920929E-7f;
        x = DifferenceFilterTest.randfloat(n);
        y = DifferenceFilterTest.randfloat(n);
        z = DifferenceFilterTest.zerofloat(n);
        df.apply(x, z);
        float d1 = DifferenceFilterTest.dot(z, y);
        df.applyTranspose(y, z);
        float d2 = DifferenceFilterTest.dot(z, x);
        DifferenceFilterTest.assertEquals((float)d1, (float)d2, (float)tiny);
        df.applyInverse(x, z);
        d1 = DifferenceFilterTest.dot(z, y);
        df.applyInverseTranspose(y, z);
        d2 = DifferenceFilterTest.dot(z, x);
        DifferenceFilterTest.assertEquals((float)d1, (float)d2, (float)tiny);
    }

    public void test2Random() {
        DifferenceFilter df = new DifferenceFilter();
        int n1 = 19;
        int n2 = 21;
        float[][] x = DifferenceFilterTest.randfloat(n1, n2);
        float[][] y = DifferenceFilterTest.zerofloat(n1, n2);
        float[][] z = DifferenceFilterTest.zerofloat(n1, n2);
        df.apply(x, y);
        df.applyInverse(y, z);
        DifferenceFilterTest.assertEqual(x, z);
        df.applyTranspose(x, y);
        df.applyInverseTranspose(y, z);
        DifferenceFilterTest.assertEqual(x, z);
        float tiny = (float)(n1 * n2) * 10.0f * 1.1920929E-7f;
        x = DifferenceFilterTest.randfloat(n1, n2);
        y = DifferenceFilterTest.randfloat(n1, n2);
        z = DifferenceFilterTest.zerofloat(n1, n2);
        df.apply(x, z);
        float d1 = DifferenceFilterTest.dot(z, y);
        df.applyTranspose(y, z);
        float d2 = DifferenceFilterTest.dot(z, x);
        DifferenceFilterTest.assertEquals((float)d1, (float)d2, (float)tiny);
        df.applyInverse(x, z);
        d1 = DifferenceFilterTest.dot(z, y);
        df.applyInverseTranspose(y, z);
        d2 = DifferenceFilterTest.dot(z, x);
        DifferenceFilterTest.assertEquals((float)d1, (float)d2, (float)tiny);
    }

    public void test3Random() {
        DifferenceFilter df = new DifferenceFilter();
        int n1 = 11;
        int n2 = 13;
        int n3 = 12;
        float[][][] x = DifferenceFilterTest.randfloat(n1, n2, n3);
        float[][][] y = DifferenceFilterTest.zerofloat(n1, n2, n3);
        float[][][] z = DifferenceFilterTest.zerofloat(n1, n2, n3);
        df.apply(x, y);
        df.applyInverse(y, z);
        DifferenceFilterTest.assertEqual(x, z);
        df.applyTranspose(x, y);
        df.applyInverseTranspose(y, z);
        DifferenceFilterTest.assertEqual(x, z);
        float tiny = (float)(n1 * n2 * n3) * 10.0f * 1.1920929E-7f;
        x = DifferenceFilterTest.randfloat(n1, n2, n3);
        y = DifferenceFilterTest.randfloat(n1, n2, n3);
        z = DifferenceFilterTest.zerofloat(n1, n2, n3);
        df.apply(x, z);
        float d1 = DifferenceFilterTest.dot(z, y);
        df.applyTranspose(y, z);
        float d2 = DifferenceFilterTest.dot(z, x);
        DifferenceFilterTest.assertEquals((float)d1, (float)d2, (float)tiny);
        df.applyInverse(x, z);
        d1 = DifferenceFilterTest.dot(z, y);
        df.applyInverseTranspose(y, z);
        d2 = DifferenceFilterTest.dot(z, x);
        DifferenceFilterTest.assertEquals((float)d1, (float)d2, (float)tiny);
    }

    private static float[] randfloat(int n1) {
        return Array.sub(Array.randfloat(n1), 0.5f);
    }

    private static float[][] randfloat(int n1, int n2) {
        return Array.sub(Array.randfloat(n1, n2), 0.5f);
    }

    private static float[][][] randfloat(int n1, int n2, int n3) {
        return Array.sub(Array.randfloat(n1, n2, n3), 0.5f);
    }

    private static float[] zerofloat(int n1) {
        return Array.zerofloat(n1);
    }

    private static float[][] zerofloat(int n1, int n2) {
        return Array.zerofloat(n1, n2);
    }

    private static float[][][] zerofloat(int n1, int n2, int n3) {
        return Array.zerofloat(n1, n2, n3);
    }

    private static float dot(float[] x, float[] y) {
        return Array.sum(Array.mul(x, y));
    }

    private static float dot(float[][] x, float[][] y) {
        return Array.sum(Array.mul(x, y));
    }

    private static float dot(float[][][] x, float[][][] y) {
        return Array.sum(Array.mul(x, y));
    }

    private static void assertEqual(float[] re, float[] ra) {
        int n1 = re.length;
        float tol = (float)n1 * 1.1920929E-7f;
        DifferenceFilterTest.assertEqual(re, ra, tol);
    }

    private static void assertEqual(float[][] re, float[][] ra) {
        int n2 = re.length;
        int n1 = re[0].length;
        float tol = (float)(n1 * n2) * 1.1920929E-7f;
        DifferenceFilterTest.assertEqual(re, ra, tol);
    }

    private static void assertEqual(float[][][] re, float[][][] ra) {
        int n3 = re.length;
        int n2 = re[0].length;
        int n1 = re[0][0].length;
        float tol = (float)(n1 * n2 * n3) * 1.1920929E-7f;
        DifferenceFilterTest.assertEqual(re, ra, tol);
    }

    private static void assertEqual(float[] re, float[] ra, float tol) {
        int n = re.length;
        for (int i = 0; i < n; ++i) {
            DifferenceFilterTest.assertEquals((float)re[i], (float)ra[i], (float)tol);
        }
    }

    private static void assertEqual(float[][] re, float[][] ra, float tol) {
        int n2 = re.length;
        int n1 = re[0].length;
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                DifferenceFilterTest.assertEquals((float)re[i2][i1], (float)ra[i2][i1], (float)tol);
            }
        }
    }

    private static void assertEqual(float[][][] re, float[][][] ra, float tol) {
        int n3 = re.length;
        int n2 = re[0].length;
        int n1 = re[0][0].length;
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    DifferenceFilterTest.assertEquals((float)re[i3][i2][i1], (float)ra[i3][i2][i1], (float)tol);
                }
            }
        }
    }
}

