/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.KaiserWindow;
import edu.mines.jtk.opt.BrentMinFinder;
import edu.mines.jtk.util.Check;

public class SincInterpolator {
    private BrentMinFinder _maxFinder = new BrentMinFinder(new BrentMinFinder.Function(){

        public double evaluate(double x) {
            return -SincInterpolator.this.interpolate(x);
        }
    });
    private static final double EWIN_FRAC = 0.9;
    private static final int NTAB_MAX = 16385;
    private double _emax;
    private double _fmax;
    private int _lmax;
    private KaiserWindow _kwin;
    private Extrapolation _extrap = Extrapolation.ZERO;
    private int _nxu;
    private double _dxu;
    private double _fxu;
    private double _xf;
    private double _xs;
    private double _xb;
    private int _nxum;
    private float[] _yu;
    private int _nx1u;
    private int _nx2u;
    private int _nx3u;
    private double _x1f;
    private double _x2f;
    private double _x3f;
    private double _x1s;
    private double _x2s;
    private double _x3s;
    private double _x1b;
    private double _x2b;
    private double _x3b;
    private int _nx1um;
    private int _nx2um;
    private int _nx3um;
    private float[][] _yyu;
    private float[][][] _yyyu;
    private int _lsinc;
    private int _nsinc;
    private double _dsinc;
    private float[][] _asinc;
    private double _nsincm1;
    private int _ib;

    public static SincInterpolator fromErrorAndLength(double emax, int lmax) {
        return new SincInterpolator(emax, 0.0, lmax);
    }

    public static SincInterpolator fromErrorAndFrequency(double emax, double fmax) {
        return new SincInterpolator(emax, fmax, 0);
    }

    public static SincInterpolator fromFrequencyAndLength(double fmax, int lmax) {
        return new SincInterpolator(0.0, fmax, lmax);
    }

    public static SincInterpolator fromKenLarner(int lmax) {
        return new SincInterpolator(lmax);
    }

    private SincInterpolator(int lmax) {
        Check.argument(lmax % 2 == 0, "lmax is even");
        Check.argument(lmax >= 8, "lmax>=8");
        Check.argument(lmax <= 16, "lmax<=16");
        this._emax = 0.01;
        this._fmax = 0.033 + 0.132 * Math.log(lmax);
        this._lmax = lmax;
        this._nsinc = 2049;
        this._dsinc = 1.0 / (double)(this._nsinc - 1);
        this._lsinc = lmax;
        this.makeTableKenLarner();
    }

    public SincInterpolator() {
        this(0.0, 0.3, 8);
    }

    public double getMaximumError() {
        return this._emax;
    }

    public double getMaximumFrequency() {
        return this._fmax;
    }

    public int getMaximumLength() {
        return this._lmax;
    }

    public long getTableBytes() {
        long nbytes = 4L;
        nbytes *= (long)this._lsinc;
        return nbytes *= (long)this._nsinc;
    }

    public Extrapolation getExtrapolation() {
        return this._extrap;
    }

    public void setExtrapolation(Extrapolation extrap) {
        this._extrap = extrap;
    }

    public void setUniformSampling(int nxu, double dxu, double fxu) {
        if (this._asinc == null) {
            this.makeTable();
        }
        this._nxu = nxu;
        this._dxu = dxu;
        this._fxu = fxu;
        this._xf = fxu;
        this._xs = 1.0 / dxu;
        this._xb = (double)this._lsinc - this._xf * this._xs;
        this._nxum = nxu - this._lsinc;
    }

    public void setUniformSamples(float[] yu) {
        this._yu = yu;
    }

    public void setUniform(int nxu, double dxu, double fxu, float[] yu) {
        this.setUniformSampling(nxu, dxu, fxu);
        this.setUniformSamples(yu);
    }

    public float interpolate(double x) {
        float yr;
        block6: {
            float[] asinc;
            int kyu;
            block7: {
                block5: {
                    double xn = this._xb + x * this._xs;
                    int ixn = (int)xn;
                    kyu = this._ib + ixn;
                    double frac = xn - (double)ixn;
                    if (frac < 0.0) {
                        frac += 1.0;
                    }
                    int ksinc = (int)(frac * this._nsincm1 + 0.5);
                    asinc = this._asinc[ksinc];
                    yr = 0.0f;
                    if (kyu < 0 || kyu > this._nxum) break block5;
                    int isinc = 0;
                    while (isinc < this._lsinc) {
                        yr += this._yu[kyu] * asinc[isinc];
                        ++isinc;
                        ++kyu;
                    }
                    break block6;
                }
                if (this._extrap != Extrapolation.ZERO) break block7;
                int isinc = 0;
                while (isinc < this._lsinc) {
                    if (0 <= kyu && kyu < this._nxu) {
                        yr += this._yu[kyu] * asinc[isinc];
                    }
                    ++isinc;
                    ++kyu;
                }
                break block6;
            }
            if (this._extrap != Extrapolation.CONSTANT) break block6;
            int isinc = 0;
            while (isinc < this._lsinc) {
                int jyu = kyu < 0 ? 0 : (this._nxu <= kyu ? this._nxu - 1 : kyu);
                yr += this._yu[jyu] * asinc[isinc];
                ++isinc;
                ++kyu;
            }
        }
        return yr;
    }

    public void interpolate(int nx, float[] x, float[] y) {
        for (int ix = 0; ix < nx; ++ix) {
            y[ix] = this.interpolate(x[ix]);
        }
    }

    public void interpolate(int nx, double dx, double fx, float[] y) {
        if (dx == this._dxu) {
            this.shift(nx, fx, y);
        } else {
            for (int ix = 0; ix < nx; ++ix) {
                y[ix] = this.interpolate(fx + (double)ix * dx);
            }
        }
    }

    public void interpolateComplex(int nx, float[] x, float[] y) {
        for (int ix = 0; ix < nx; ++ix) {
            this.interpolateComplex(ix, x[ix], y);
        }
    }

    public void interpolateComplex(int nx, double dx, double fx, float[] y) {
        for (int ix = 0; ix < nx; ++ix) {
            this.interpolateComplex(ix, fx + (double)ix * dx, y);
        }
    }

    public double findMax(double x) {
        double a = x - 0.5 * this._dxu;
        double b = x + 0.5 * this._dxu;
        double tol = this._dsinc * this._dxu;
        return this._maxFinder.findMin(a, b, tol);
    }

    public void setUniformSampling(int nx1u, double dx1u, double fx1u, int nx2u, double dx2u, double fx2u) {
        if (this._asinc == null) {
            this.makeTable();
        }
        this._nx1u = nx1u;
        this._x1f = fx1u;
        this._x1s = 1.0 / dx1u;
        this._x1b = (double)this._lsinc - this._x1f * this._x1s;
        this._nx1um = nx1u - this._lsinc;
        this._nx2u = nx2u;
        this._x2f = fx2u;
        this._x2s = 1.0 / dx2u;
        this._x2b = (double)this._lsinc - this._x2f * this._x2s;
        this._nx2um = nx2u - this._lsinc;
    }

    public void setUniformSamples(float[][] yu) {
        this._yyu = yu;
    }

    public void setUniform(int nx1u, double dx1u, double fx1u, int nx2u, double dx2u, double fx2u, float[][] yu) {
        this.setUniformSampling(nx1u, dx1u, fx1u, nx2u, dx2u, fx2u);
        this.setUniformSamples(yu);
    }

    public float interpolate(double x1, double x2) {
        float yr;
        block11: {
            float[] asinc2;
            float[] asinc1;
            int ky2u;
            int ky1u;
            block12: {
                block10: {
                    double x1n = this._x1b + x1 * this._x1s;
                    double x2n = this._x2b + x2 * this._x2s;
                    int ix1n = (int)x1n;
                    int ix2n = (int)x2n;
                    ky1u = this._ib + ix1n;
                    ky2u = this._ib + ix2n;
                    double frac1 = x1n - (double)ix1n;
                    double frac2 = x2n - (double)ix2n;
                    if (frac1 < 0.0) {
                        frac1 += 1.0;
                    }
                    if (frac2 < 0.0) {
                        frac2 += 1.0;
                    }
                    int ksinc1 = (int)(frac1 * this._nsincm1 + 0.5);
                    int ksinc2 = (int)(frac2 * this._nsincm1 + 0.5);
                    asinc1 = this._asinc[ksinc1];
                    asinc2 = this._asinc[ksinc2];
                    yr = 0.0f;
                    if (ky1u < 0 || ky1u > this._nx1um || ky2u < 0 || ky2u > this._nx2um) break block10;
                    int i2sinc = 0;
                    while (i2sinc < this._lsinc) {
                        float asinc22 = asinc2[i2sinc];
                        float[] yyuk2 = this._yyu[ky2u];
                        float yr2 = 0.0f;
                        int i1sinc = 0;
                        int my1u = ky1u;
                        while (i1sinc < this._lsinc) {
                            yr2 += yyuk2[my1u] * asinc1[i1sinc];
                            ++i1sinc;
                            ++my1u;
                        }
                        yr += asinc22 * yr2;
                        ++i2sinc;
                        ++ky2u;
                    }
                    break block11;
                }
                if (this._extrap != Extrapolation.ZERO) break block12;
                int i2sinc = 0;
                while (i2sinc < this._lsinc) {
                    if (0 <= ky2u && ky2u < this._nx2u) {
                        int i1sinc = 0;
                        int my1u = ky1u;
                        while (i1sinc < this._lsinc) {
                            if (0 <= my1u && my1u < this._nx1u) {
                                yr += this._yyu[ky2u][my1u] * asinc2[i2sinc] * asinc1[i1sinc];
                            }
                            ++i1sinc;
                            ++my1u;
                        }
                    }
                    ++i2sinc;
                    ++ky2u;
                }
                break block11;
            }
            if (this._extrap != Extrapolation.CONSTANT) break block11;
            int i2sinc = 0;
            while (i2sinc < this._lsinc) {
                int jy2u = ky2u < 0 ? 0 : (this._nx2u <= ky2u ? this._nx2u - 2 : ky2u);
                int i1sinc = 0;
                int my1u = ky1u;
                while (i1sinc < this._lsinc) {
                    int jy1u = my1u < 0 ? 0 : (this._nx1u <= my1u ? this._nx1u - 1 : my1u);
                    yr += this._yyu[jy2u][jy1u] * asinc2[i2sinc] * asinc1[i1sinc];
                    ++i1sinc;
                    ++my1u;
                }
                ++i2sinc;
                ++ky2u;
            }
        }
        return yr;
    }

    public void setUniformSampling(int nx1u, double dx1u, double fx1u, int nx2u, double dx2u, double fx2u, int nx3u, double dx3u, double fx3u) {
        if (this._asinc == null) {
            this.makeTable();
        }
        this._nx1u = nx1u;
        this._x1f = fx1u;
        this._x1s = 1.0 / dx1u;
        this._x1b = (double)this._lsinc - this._x1f * this._x1s;
        this._nx1um = nx1u - this._lsinc;
        this._nx2u = nx2u;
        this._x2f = fx2u;
        this._x2s = 1.0 / dx2u;
        this._x2b = (double)this._lsinc - this._x2f * this._x2s;
        this._nx2um = nx2u - this._lsinc;
        this._nx3u = nx3u;
        this._x3f = fx3u;
        this._x3s = 1.0 / dx3u;
        this._x3b = (double)this._lsinc - this._x3f * this._x3s;
        this._nx3um = nx3u - this._lsinc;
    }

    public void setUniformSamples(float[][][] yu) {
        this._yyyu = yu;
    }

    public void setUniform(int nx1u, double dx1u, double fx1u, int nx2u, double dx2u, double fx2u, int nx3u, double dx3u, double fx3u, float[][][] yu) {
        this.setUniformSampling(nx1u, dx1u, fx1u, nx2u, dx2u, fx2u, nx3u, dx3u, fx3u);
        this.setUniformSamples(yu);
    }

    public float interpolate(double x1, double x2, double x3) {
        float yr;
        block16: {
            float[] asinc3;
            float[] asinc2;
            float[] asinc1;
            int ky3u;
            int ky2u;
            int ky1u;
            block17: {
                block15: {
                    double x1n = this._x1b + x1 * this._x1s;
                    double x2n = this._x2b + x2 * this._x2s;
                    double x3n = this._x3b + x3 * this._x3s;
                    int ix1n = (int)x1n;
                    int ix2n = (int)x2n;
                    int ix3n = (int)x3n;
                    ky1u = this._ib + ix1n;
                    ky2u = this._ib + ix2n;
                    ky3u = this._ib + ix3n;
                    double frac1 = x1n - (double)ix1n;
                    double frac2 = x2n - (double)ix2n;
                    double frac3 = x3n - (double)ix3n;
                    if (frac1 < 0.0) {
                        frac1 += 1.0;
                    }
                    if (frac2 < 0.0) {
                        frac2 += 1.0;
                    }
                    if (frac3 < 0.0) {
                        frac3 += 1.0;
                    }
                    int ksinc1 = (int)(frac1 * this._nsincm1 + 0.5);
                    int ksinc2 = (int)(frac2 * this._nsincm1 + 0.5);
                    int ksinc3 = (int)(frac3 * this._nsincm1 + 0.5);
                    asinc1 = this._asinc[ksinc1];
                    asinc2 = this._asinc[ksinc2];
                    asinc3 = this._asinc[ksinc3];
                    yr = 0.0f;
                    if (ky1u < 0 || ky1u > this._nx1um || ky2u < 0 || ky2u > this._nx2um || ky3u < 0 || ky3u > this._nx3um) break block15;
                    int i3sinc = 0;
                    while (i3sinc < this._lsinc) {
                        float asinc33 = asinc3[i3sinc];
                        float[][] yyy3 = this._yyyu[ky3u];
                        float yr2 = 0.0f;
                        int i2sinc = 0;
                        int my2u = ky2u;
                        while (i2sinc < this._lsinc) {
                            float asinc22 = asinc2[i2sinc];
                            float[] yyy32 = yyy3[my2u];
                            float yr1 = 0.0f;
                            int i1sinc = 0;
                            int my1u = ky1u;
                            while (i1sinc < this._lsinc) {
                                yr1 += yyy32[my1u] * asinc1[i1sinc];
                                ++i1sinc;
                                ++my1u;
                            }
                            yr2 += asinc22 * yr1;
                            ++i2sinc;
                            ++my2u;
                        }
                        yr += asinc33 * yr2;
                        ++i3sinc;
                        ++ky3u;
                    }
                    break block16;
                }
                if (this._extrap != Extrapolation.ZERO) break block17;
                int i3sinc = 0;
                while (i3sinc < this._lsinc) {
                    if (0 <= ky3u && ky3u < this._nx3u) {
                        int i2sinc = 0;
                        int my2u = ky2u;
                        while (i2sinc < this._lsinc) {
                            if (0 <= my2u && my2u < this._nx2u) {
                                int i1sinc = 0;
                                int my1u = ky1u;
                                while (i1sinc < this._lsinc) {
                                    if (0 <= my1u && my1u < this._nx1u) {
                                        yr += this._yyyu[ky3u][my2u][my1u] * asinc3[i3sinc] * asinc2[i2sinc] * asinc1[i1sinc];
                                    }
                                    ++i1sinc;
                                    ++my1u;
                                }
                            }
                            ++i2sinc;
                            ++my2u;
                        }
                    }
                    ++i3sinc;
                    ++ky3u;
                }
                break block16;
            }
            if (this._extrap != Extrapolation.CONSTANT) break block16;
            int i3sinc = 0;
            while (i3sinc < this._lsinc) {
                int jy3u = ky3u < 0 ? 0 : (this._nx3u <= ky3u ? this._nx3u - 2 : ky3u);
                int i2sinc = 0;
                int my2u = ky2u;
                while (i2sinc < this._lsinc) {
                    int jy2u = my2u < 0 ? 0 : (this._nx2u <= my2u ? this._nx2u - 2 : my2u);
                    int i1sinc = 0;
                    int my1u = ky1u;
                    while (i1sinc < this._lsinc) {
                        int jy1u = my1u < 0 ? 0 : (this._nx1u <= my1u ? this._nx1u - 1 : my1u);
                        yr += this._yyyu[jy3u][jy2u][jy1u] * asinc3[i3sinc] * asinc2[i2sinc] * asinc1[i1sinc];
                        ++i1sinc;
                        ++my1u;
                    }
                    ++i2sinc;
                    ++my2u;
                }
                ++i3sinc;
                ++ky3u;
            }
        }
        return yr;
    }

    public void accumulate(double x, float y) {
        block6: {
            float[] asinc;
            int kyu;
            block7: {
                block5: {
                    double xn = this._xb + x * this._xs;
                    int ixn = (int)xn;
                    kyu = this._ib + ixn;
                    double frac = xn - (double)ixn;
                    if (frac < 0.0) {
                        frac += 1.0;
                    }
                    int ksinc = (int)(frac * this._nsincm1 + 0.5);
                    asinc = this._asinc[ksinc];
                    if (kyu < 0 || kyu > this._nxum) break block5;
                    for (int isinc = 0; isinc < this._lsinc; ++isinc) {
                        int n = kyu++;
                        this._yu[n] = this._yu[n] + y * asinc[isinc];
                    }
                    break block6;
                }
                if (this._extrap != Extrapolation.ZERO) break block7;
                int isinc = 0;
                while (isinc < this._lsinc) {
                    if (0 <= kyu && kyu < this._nxu) {
                        int n = kyu;
                        this._yu[n] = this._yu[n] + y * asinc[isinc];
                    }
                    ++isinc;
                    ++kyu;
                }
                break block6;
            }
            if (this._extrap != Extrapolation.CONSTANT) break block6;
            int isinc = 0;
            while (isinc < this._lsinc) {
                int jyu;
                int n = jyu = kyu < 0 ? 0 : (this._nxu <= kyu ? this._nxu - 1 : kyu);
                this._yu[n] = this._yu[n] + y * asinc[isinc];
                ++isinc;
                ++kyu;
            }
        }
    }

    public void accumulate(int nx, float[] x, float[] y) {
        for (int ix = 0; ix < nx; ++ix) {
            this.accumulate(x[ix], y[ix]);
        }
    }

    private SincInterpolator(double emax, double fmax, int lmax) {
        Check.argument(emax == 0.0 && fmax != 0.0 && lmax != 0 || emax != 0.0 && fmax == 0.0 && lmax != 0 || emax != 0.0 && fmax != 0.0 && lmax == 0, "exactly one of emax, fmax, and lmax is zero");
        if (emax == 0.0) {
            Check.argument(fmax < 0.5, "fmax<0.5");
            Check.argument(lmax >= 8, "lmax>=8");
            Check.argument(lmax % 2 == 0, "lmax is even");
            Check.argument((1.0 - 2.0 * fmax) * (double)lmax > 1.0, "(1.0-2.0*fmax)*lmax>1.0");
        } else if (fmax == 0.0) {
            Check.argument(emax <= 0.1, "emax<=0.1");
            Check.argument(lmax >= 8, "lmax>=8");
            Check.argument(lmax % 2 == 0, "lmax is even");
        } else if (lmax == 0) {
            Check.argument(emax <= 0.1, "emax<=0.1");
            Check.argument(fmax < 0.5, "fmax<0.5");
        }
        double wwin = 2.0 * (0.5 - fmax);
        double ewin = emax * 0.9;
        KaiserWindow kwin = null;
        if (emax == 0.0) {
            double etabMin;
            double emaxMin;
            kwin = KaiserWindow.fromWidthAndLength(wwin, lmax);
            ewin = 3.0 * kwin.getError();
            emax = ewin / 0.9;
            if (emax < (emaxMin = (etabMin = 3.455751918948773 * fmax / 16384.0) / 0.09999999999999998)) {
                emax = emaxMin;
                ewin = emax * 0.9;
            }
        } else if (fmax == 0.0) {
            kwin = KaiserWindow.fromErrorAndLength(ewin / 3.0, lmax);
            fmax = Math.max(0.0, 0.5 - 0.5 * kwin.getWidth());
        } else {
            kwin = KaiserWindow.fromErrorAndWidth(ewin / 3.0, wwin);
            double lwin = kwin.getLength();
            for (lmax = (int)lwin; (double)lmax < lwin || lmax < 8 || lmax % 2 == 1; ++lmax) {
            }
            kwin = KaiserWindow.fromErrorAndLength(ewin / 3.0, lmax);
        }
        double etab = emax - ewin;
        this._dsinc = fmax > 0.0 ? etab / (Math.PI * fmax) : 1.0;
        int nsincMin = 1 + (int)Math.ceil(1.0 / this._dsinc);
        this._nsinc = 2;
        while (this._nsinc < nsincMin) {
            this._nsinc *= 2;
        }
        ++this._nsinc;
        this._dsinc = 1.0 / (double)(this._nsinc - 1);
        this._lsinc = lmax;
        this._emax = emax;
        this._fmax = fmax;
        this._lmax = lmax;
        this._kwin = kwin;
    }

    private void makeTable() {
        this._asinc = new float[this._nsinc][this._lsinc];
        this._nsincm1 = this._nsinc - 1;
        this._ib = -this._lsinc - this._lsinc / 2 + 1;
        for (int j = 0; j < this._lsinc; ++j) {
            this._asinc[0][j] = 0.0f;
            this._asinc[this._nsinc - 1][j] = 0.0f;
        }
        this._asinc[0][this._lsinc / 2 - 1] = 1.0f;
        this._asinc[this._nsinc - 1][this._lsinc / 2] = 1.0f;
        for (int isinc = 1; isinc < this._nsinc - 1; ++isinc) {
            double x = (double)(-this._lsinc / 2 + 1) - this._dsinc * (double)isinc;
            int i = 0;
            while (i < this._lsinc) {
                this._asinc[isinc][i] = (float)(SincInterpolator.sinc(x) * this._kwin.evaluate(x));
                ++i;
                x += 1.0;
            }
        }
    }

    private static double sinc(double x) {
        return x != 0.0 ? Math.sin(Math.PI * x) / (Math.PI * x) : 1.0;
    }

    private void interpolateComplex(int ix, double x, float[] y) {
        int isinc;
        double xn = this._xb + x * this._xs;
        int ixn = (int)xn;
        int kyu = this._ib + ixn;
        double frac = xn - (double)ixn;
        if (frac < 0.0) {
            frac += 1.0;
        }
        int ksinc = (int)(frac * this._nsincm1 + 0.5);
        float[] asinc = this._asinc[ksinc];
        float yr = 0.0f;
        float yi = 0.0f;
        if (kyu >= 0 && kyu <= this._nxum) {
            isinc = 0;
            while (isinc < this._lsinc) {
                int jyu = 2 * kyu;
                float asinci = asinc[isinc];
                yr += this._yu[jyu] * asinci;
                yi += this._yu[jyu + 1] * asinci;
                ++isinc;
                ++kyu;
            }
        } else if (this._extrap == Extrapolation.ZERO) {
            isinc = 0;
            while (isinc < this._lsinc) {
                if (0 <= kyu && kyu < this._nxu) {
                    int jyu = 2 * kyu;
                    float asinci = asinc[isinc];
                    yr += this._yu[jyu] * asinci;
                    yi += this._yu[jyu + 1] * asinci;
                }
                ++isinc;
                ++kyu;
            }
        } else if (this._extrap == Extrapolation.CONSTANT) {
            isinc = 0;
            while (isinc < this._lsinc) {
                int jyu = kyu < 0 ? 0 : (this._nxu <= kyu ? 2 * this._nxu - 2 : 2 * kyu);
                float asinci = asinc[isinc];
                yr += this._yu[jyu] * asinci;
                yi += this._yu[jyu + 1] * asinci;
                ++isinc;
                ++kyu;
            }
        }
        int jx = 2 * ix;
        y[jx] = yr;
        y[jx + 1] = yi;
    }

    private void shift(int nx, double fx, float[] y) {
        double x;
        int ix;
        int nxu = this._nxu;
        double dxu = this._dxu;
        double fxu = this._fxu;
        double lxu = fxu + (double)(nxu - 1) * dxu;
        double dx = dxu;
        double x1 = fxu + dxu * (double)this._lsinc / 2.0;
        double x2 = lxu - dxu * (double)this._lsinc / 2.0;
        double x1n = (x1 - fx) / dx;
        double x2n = (x2 - fx) / dx;
        int ix1 = Math.max(0, Math.min(nx, (int)x1n) + 1);
        int ix2 = Math.max(0, Math.min(nx, (int)x2n) - 1);
        for (ix = 0; ix < ix1; ++ix) {
            x = fx + (double)ix * dx;
            y[ix] = this.interpolate(x);
        }
        for (ix = ix2; ix < nx; ++ix) {
            x = fx + (double)ix * dx;
            y[ix] = this.interpolate(x);
        }
        double xn = this._xb + (fx + (double)ix1 * dx) * this._xs;
        int ixn = (int)xn;
        int kyu = this._ib + ixn;
        double frac = xn - (double)ixn;
        if (frac < 0.0) {
            frac += 1.0;
        }
        int ksinc = (int)(frac * this._nsincm1 + 0.5);
        float[] asinc = this._asinc[ksinc];
        int ix3 = ix1;
        while (ix3 < ix2) {
            float yr = 0.0f;
            int isinc = 0;
            int jyu = kyu;
            while (isinc < this._lsinc) {
                yr += this._yu[jyu] * asinc[isinc];
                ++isinc;
                ++jyu;
            }
            y[ix3] = yr;
            ++ix3;
            ++kyu;
        }
    }

    private void makeTableKenLarner() {
        this._asinc = new float[this._nsinc][this._lsinc];
        this._nsincm1 = this._nsinc - 1;
        this._ib = -this._lsinc - this._lsinc / 2 + 1;
        for (int j = 0; j < this._lsinc; ++j) {
            this._asinc[0][j] = 0.0f;
            this._asinc[this._nsinc - 1][j] = 0.0f;
        }
        this._asinc[0][this._lsinc / 2 - 1] = 1.0f;
        this._asinc[this._nsinc - 1][this._lsinc / 2] = 1.0f;
        for (int isinc = 1; isinc < this._nsinc - 1; ++isinc) {
            double frac = (double)isinc / (double)(this._nsinc - 1);
            SincInterpolator.mksinc(frac, this._lsinc, this._asinc[isinc]);
        }
    }

    private static void mksinc(double d, int lsinc, float[] sinc) {
        int j;
        double[] s = new double[lsinc];
        double[] a = new double[lsinc];
        double[] c = new double[lsinc];
        double[] w = new double[lsinc];
        double fmax = 0.033 + 0.132 * Math.log(lsinc);
        if (fmax > 0.5) {
            fmax = 0.5;
        }
        for (j = 0; j < lsinc; ++j) {
            a[j] = SincInterpolator.sinc(2.0 * fmax * (double)j);
            c[j] = SincInterpolator.sinc(2.0 * fmax * ((double)(lsinc / 2 - j - 1) + d));
        }
        SincInterpolator.stoepd(lsinc, a, c, s, w);
        for (j = 0; j < lsinc; ++j) {
            sinc[j] = (float)s[j];
        }
    }

    private static void stoepd(int n, double[] r, double[] g, double[] f, double[] a) {
        if (r[0] == 0.0) {
            return;
        }
        a[0] = 1.0;
        double v = r[0];
        f[0] = g[0] / r[0];
        for (int j = 1; j < n; ++j) {
            int i;
            a[j] = 0.0;
            f[j] = 0.0;
            double e = 0.0;
            for (int i2 = 0; i2 < j; ++i2) {
                e += a[i2] * r[j - i2];
            }
            double c = e / v;
            v -= c * e;
            for (int i3 = 0; i3 <= j / 2; ++i3) {
                double bot = a[j - i3] - c * a[i3];
                int n2 = i3;
                a[n2] = a[n2] - c * a[j - i3];
                a[j - i3] = bot;
            }
            double w = 0.0;
            for (i = 0; i < j; ++i) {
                w += f[i] * r[j - i];
            }
            c = (w - g[j]) / v;
            for (i = 0; i <= j; ++i) {
                int n3 = i;
                f[n3] = f[n3] - c * a[j - i];
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Extrapolation {
        ZERO,
        CONSTANT;

    }
}

