/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.Recursive2ndOrderFilter;
import edu.mines.jtk.util.Cdouble;
import edu.mines.jtk.util.Check;
import edu.mines.jtk.util.MathPlus;

public class RecursiveCascadeFilter {
    private int _n1;
    private Recursive2ndOrderFilter[] _f1;

    public RecursiveCascadeFilter(Cdouble[] poles, Cdouble[] zeros, double gain) {
        this.init(poles, zeros, gain);
    }

    public void applyForward(float[] x, float[] y) {
        this._f1[0].applyForward(x, y);
        for (int i1 = 1; i1 < this._n1; ++i1) {
            this._f1[i1].applyForward(y, y);
        }
    }

    public void applyReverse(float[] x, float[] y) {
        this._f1[0].applyReverse(x, y);
        for (int i1 = 1; i1 < this._n1; ++i1) {
            this._f1[i1].applyReverse(y, y);
        }
    }

    public void applyForwardReverse(float[] x, float[] y) {
        this._f1[0].applyForward(x, y);
        this._f1[0].applyReverse(y, y);
        for (int i1 = 1; i1 < this._n1; ++i1) {
            this._f1[i1].applyForward(y, y);
            this._f1[i1].applyReverse(y, y);
        }
    }

    public void apply1Forward(float[][] x, float[][] y) {
        this._f1[0].apply1Forward(x, y);
        for (int i1 = 1; i1 < this._n1; ++i1) {
            this._f1[i1].apply1Forward(y, y);
        }
    }

    public void apply1Reverse(float[][] x, float[][] y) {
        this._f1[0].apply1Reverse(x, y);
        for (int i1 = 1; i1 < this._n1; ++i1) {
            this._f1[i1].apply1Reverse(y, y);
        }
    }

    public void apply1ForwardReverse(float[][] x, float[][] y) {
        this._f1[0].apply1Forward(x, y);
        this._f1[0].apply1Reverse(y, y);
        for (int i1 = 1; i1 < this._n1; ++i1) {
            this._f1[i1].apply1Forward(y, y);
            this._f1[i1].apply1Reverse(y, y);
        }
    }

    public void apply2Forward(float[][] x, float[][] y) {
        this._f1[0].apply2Forward(x, y);
        for (int i1 = 1; i1 < this._n1; ++i1) {
            this._f1[i1].apply2Forward(y, y);
        }
    }

    public void apply2Reverse(float[][] x, float[][] y) {
        this._f1[0].apply2Reverse(x, y);
        for (int i1 = 1; i1 < this._n1; ++i1) {
            this._f1[i1].apply2Reverse(y, y);
        }
    }

    public void apply2ForwardReverse(float[][] x, float[][] y) {
        this._f1[0].apply2Forward(x, y);
        this._f1[0].apply2Reverse(y, y);
        for (int i1 = 1; i1 < this._n1; ++i1) {
            this._f1[i1].apply2Forward(y, y);
            this._f1[i1].apply2Reverse(y, y);
        }
    }

    public void apply1Forward(float[][][] x, float[][][] y) {
        this._f1[0].apply1Forward(x, y);
        for (int i1 = 1; i1 < this._n1; ++i1) {
            this._f1[i1].apply1Forward(y, y);
        }
    }

    public void apply1Reverse(float[][][] x, float[][][] y) {
        this._f1[0].apply1Reverse(x, y);
        for (int i1 = 1; i1 < this._n1; ++i1) {
            this._f1[i1].apply1Reverse(y, y);
        }
    }

    public void apply1ForwardReverse(float[][][] x, float[][][] y) {
        this._f1[0].apply1Forward(x, y);
        this._f1[0].apply1Reverse(y, y);
        for (int i1 = 1; i1 < this._n1; ++i1) {
            this._f1[i1].apply1Forward(y, y);
            this._f1[i1].apply1Reverse(y, y);
        }
    }

    public void apply2Forward(float[][][] x, float[][][] y) {
        this._f1[0].apply2Forward(x, y);
        for (int i1 = 1; i1 < this._n1; ++i1) {
            this._f1[i1].apply2Forward(y, y);
        }
    }

    public void apply2Reverse(float[][][] x, float[][][] y) {
        this._f1[0].apply2Reverse(x, y);
        for (int i1 = 1; i1 < this._n1; ++i1) {
            this._f1[i1].apply2Reverse(y, y);
        }
    }

    public void apply2ForwardReverse(float[][][] x, float[][][] y) {
        this._f1[0].apply2Forward(x, y);
        this._f1[0].apply2Reverse(y, y);
        for (int i1 = 1; i1 < this._n1; ++i1) {
            this._f1[i1].apply2Forward(y, y);
            this._f1[i1].apply2Reverse(y, y);
        }
    }

    public void apply3Forward(float[][][] x, float[][][] y) {
        this._f1[0].apply3Forward(x, y);
        for (int i1 = 1; i1 < this._n1; ++i1) {
            this._f1[i1].apply3Forward(y, y);
        }
    }

    public void apply3Reverse(float[][][] x, float[][][] y) {
        this._f1[0].apply3Reverse(x, y);
        for (int i1 = 1; i1 < this._n1; ++i1) {
            this._f1[i1].apply3Reverse(y, y);
        }
    }

    public void apply3ForwardReverse(float[][][] x, float[][][] y) {
        this._f1[0].apply3Forward(x, y);
        this._f1[0].apply3Reverse(y, y);
        for (int i1 = 1; i1 < this._n1; ++i1) {
            this._f1[i1].apply3Forward(y, y);
            this._f1[i1].apply3Reverse(y, y);
        }
    }

    protected RecursiveCascadeFilter() {
    }

    protected void init(Cdouble[] poles, Cdouble[] zeros, double gain) {
        Check.argument(poles.length > 0 || zeros.length > 0, "at least one pole or zero is specified");
        poles = RecursiveCascadeFilter.sortPolesOrZeros(poles);
        zeros = RecursiveCascadeFilter.sortPolesOrZeros(zeros);
        int np = poles.length;
        int nz = zeros.length;
        this._n1 = MathPlus.max((np + 1) / 2, (nz + 1) / 2);
        this._f1 = new Recursive2ndOrderFilter[this._n1];
        gain = MathPlus.pow(gain, 1.0 / (double)this._n1);
        Cdouble c0 = new Cdouble(0.0, 0.0);
        int ip = 0;
        int iz = 0;
        for (int i1 = 0; i1 < this._n1; ++i1) {
            Cdouble pole1 = ip < np ? poles[ip++] : c0;
            Cdouble pole2 = ip < np ? poles[ip++] : c0;
            Cdouble zero1 = iz < nz ? zeros[iz++] : c0;
            Cdouble zero2 = iz < nz ? zeros[iz++] : c0;
            this._f1[i1] = new Recursive2ndOrderFilter(pole1, pole2, zero1, zero2, gain);
        }
    }

    private static Cdouble[] sortPolesOrZeros(Cdouble[] c) {
        int i;
        c = (Cdouble[])c.clone();
        int n = c.length;
        Cdouble[] cs = new Cdouble[n];
        int ns = 0;
        for (i = 0; i < n; ++i) {
            int j;
            if (c[i] == null || c[i].isReal()) continue;
            Cdouble cc = c[i].conj();
            for (j = i + 1; j < n && !cc.equals(c[j]); ++j) {
            }
            Check.argument(j < n, "complex " + c[i] + " has a conjugate mate");
            cs[ns++] = c[i];
            cs[ns++] = c[j];
            c[i] = null;
            c[j] = null;
        }
        for (i = 0; i < n; ++i) {
            if (c[i] == null || !c[i].isReal()) continue;
            cs[ns++] = c[i];
        }
        return cs;
    }
}

