/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.Conv;
import edu.mines.jtk.dsp.FftReal;
import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.util.Array;
import edu.mines.jtk.util.Check;
import edu.mines.jtk.util.MathPlus;

public class Real1 {
    Sampling _s;
    float[] _v;
    private static Binary _add = new Binary(){

        public void apply(int n, float[] a, int ia, float[] b, int ib, float[] c, int ic) {
            while (--n >= 0) {
                c[ic++] = a[ia++] + b[ib++];
            }
        }

        public void apply(int n, float a, float[] b, int ib, float[] c, int ic) {
            while (--n >= 0) {
                c[ic++] = a + b[ib++];
            }
        }

        public void apply(int n, float[] a, int ia, float b, float[] c, int ic) {
            while (--n >= 0) {
                c[ic++] = a[ia++] + b;
            }
        }
    };
    private static Binary _sub = new Binary(){

        public void apply(int n, float[] a, int ia, float[] b, int ib, float[] c, int ic) {
            while (--n >= 0) {
                c[ic++] = a[ia++] - b[ib++];
            }
        }

        public void apply(int n, float a, float[] b, int ib, float[] c, int ic) {
            while (--n >= 0) {
                c[ic++] = a - b[ib++];
            }
        }

        public void apply(int n, float[] a, int ia, float b, float[] c, int ic) {
            while (--n >= 0) {
                c[ic++] = a[ia++] - b;
            }
        }
    };
    private static Binary _mul = new Binary(){

        public void apply(int n, float[] a, int ia, float[] b, int ib, float[] c, int ic) {
            while (--n >= 0) {
                c[ic++] = a[ia++] * b[ib++];
            }
        }

        public void apply(int n, float a, float[] b, int ib, float[] c, int ic) {
            while (--n >= 0) {
                c[ic++] = a * b[ib++];
            }
        }

        public void apply(int n, float[] a, int ia, float b, float[] c, int ic) {
            while (--n >= 0) {
                c[ic++] = a[ia++] * b;
            }
        }
    };
    private static Binary _div = new Binary(){

        public void apply(int n, float[] a, int ia, float[] b, int ib, float[] c, int ic) {
            while (--n >= 0) {
                c[ic++] = a[ia++] / b[ib++];
            }
        }

        public void apply(int n, float a, float[] b, int ib, float[] c, int ic) {
            while (--n >= 0) {
                c[ic++] = a / b[ib++];
            }
        }

        public void apply(int n, float[] a, int ia, float b, float[] c, int ic) {
            while (--n >= 0) {
                c[ic++] = a[ia++] / b;
            }
        }
    };

    public Real1(Sampling s) {
        this._s = s;
        this._v = new float[s.getCount()];
    }

    public Real1(float[] v) {
        this._s = new Sampling(v.length, 1.0, 0.0);
        this._v = v;
    }

    public Real1(Sampling s, float[] v) {
        Check.argument(s.getCount() == v.length, "v.length equals the number of samples in s");
        this._s = s;
        this._v = v;
    }

    public Real1(int n, double d, double f) {
        this(new Sampling(n, d, f));
    }

    public Real1(int n, double d, double f, float[] v) {
        this(new Sampling(n, d, f), v);
    }

    public Real1(Real1 r) {
        this(r._s, Array.copy(r._v));
    }

    public Sampling getSampling() {
        return this._s;
    }

    public float[] getValues() {
        return this._v;
    }

    public Real1 resample(Sampling s) {
        Sampling t = this._s;
        int[] overlap = t.overlapWith(s);
        if (overlap != null) {
            int ni = overlap[0];
            int it = overlap[1];
            int is = overlap[2];
            Real1 rt = this;
            Real1 rs = new Real1(s);
            float[] xt = rt.getValues();
            float[] xs = rs.getValues();
            while (--ni >= 0) {
                xs[is++] = xt[it++];
            }
            return rs;
        }
        throw new UnsupportedOperationException("no interpolation, yet");
    }

    public Real1 plus(Real1 ra) {
        return Real1.add(this, ra);
    }

    public Real1 plus(float ar) {
        return Real1.add(this, ar);
    }

    public Real1 convolve(Real1 ra) {
        Real1 rx = this;
        Real1 ry = ra;
        Sampling sx = rx.getSampling();
        Sampling sy = ry.getSampling();
        double dx = sx.getDelta();
        double dy = sy.getDelta();
        Check.state(sx.isUniform(), "sampling is uniform");
        Check.argument(sy.isUniform(), "sampling is uniform");
        Check.argument(dx == dy, "sampling intervals are equal");
        int lx = sx.getCount();
        int ly = sy.getCount();
        double fx = sx.getFirst();
        double fy = sy.getFirst();
        float[] x = rx.getValues();
        float[] y = ry.getValues();
        int lz = lx + ly - 1;
        double dz = dx;
        double fz = fx + fy;
        float[] z = new float[lz];
        Conv.conv(lx, 0, x, ly, 0, y, lz, 0, z);
        return new Real1(lz, dz, fz, z);
    }

    public Sampling getFourierSampling(int nmin) {
        int nt = this._s.getCount();
        double dt = this._s.getDelta();
        int nfft = FftReal.nfftSmall(MathPlus.max(nmin, nt));
        int nf = nfft / 2 + 1;
        double df = 1.0 / ((double)nfft * dt);
        double ff = 0.0;
        return new Sampling(nf, df, ff);
    }

    public static Real1 zero(int n) {
        return new Real1(new Sampling(n));
    }

    public static Real1 zero(Sampling s) {
        return new Real1(s);
    }

    public static Real1 fill(double ar, int n) {
        return Real1.fill(ar, new Sampling(n));
    }

    public static Real1 fill(double ar, Sampling s) {
        int n = s.getCount();
        return new Real1(s, Array.fillfloat((float)ar, n));
    }

    public static Real1 ramp(double fv, double dv, int nv) {
        return Real1.ramp(fv, dv, new Sampling(nv));
    }

    public static Real1 ramp(double fv, double dv, Sampling s) {
        int n = s.getCount();
        double d = s.getDelta();
        double f = s.getFirst();
        return new Real1(s, Array.rampfloat((float)(fv - f * dv), (float)(d * dv), n));
    }

    public static Real1 add(Real1 ra, Real1 rb) {
        return Real1.binaryOp(ra, rb, _add);
    }

    public static Real1 add(float ar, Real1 rb) {
        return Real1.binaryOp(ar, rb, _add);
    }

    public static Real1 add(Real1 ra, float br) {
        return Real1.binaryOp(ra, br, _add);
    }

    public static Real1 sub(Real1 ra, Real1 rb) {
        return Real1.binaryOp(ra, rb, _sub);
    }

    public static Real1 sub(float ar, Real1 rb) {
        return Real1.binaryOp(ar, rb, _sub);
    }

    public static Real1 sub(Real1 ra, float br) {
        return Real1.binaryOp(ra, br, _sub);
    }

    public static Real1 mul(Real1 ra, Real1 rb) {
        return Real1.binaryOp(ra, rb, _mul);
    }

    public static Real1 mul(float ar, Real1 rb) {
        return Real1.binaryOp(ar, rb, _mul);
    }

    public static Real1 mul(Real1 ra, float br) {
        return Real1.binaryOp(ra, br, _mul);
    }

    public static Real1 div(Real1 ra, Real1 rb) {
        return Real1.binaryOp(ra, rb, _div);
    }

    public static Real1 div(float ar, Real1 rb) {
        return Real1.binaryOp(ar, rb, _div);
    }

    public static Real1 div(Real1 ra, float br) {
        return Real1.binaryOp(ra, br, _div);
    }

    private static Real1 binaryOp(Real1 ra, Real1 rb, Binary ab) {
        Sampling sa = ra.getSampling();
        Sampling sb = rb.getSampling();
        Check.argument(sa.isEquivalentTo(sb), "samplings equivalent");
        Sampling sc = sa;
        Real1 rc = new Real1(sc);
        float[] va = ra.getValues();
        float[] vb = rb.getValues();
        float[] vc = rc.getValues();
        ab.apply(vc.length, va, 0, vb, 0, vc, 0);
        return rc;
    }

    private static Real1 binaryOp(float ar, Real1 rb, Binary ab) {
        Sampling sb;
        Sampling sc = sb = rb.getSampling();
        Real1 rc = new Real1(sc);
        float[] vb = rb.getValues();
        float[] vc = rc.getValues();
        ab.apply(vc.length, ar, vb, 0, vc, 0);
        return rc;
    }

    private static Real1 binaryOp(Real1 ra, float br, Binary ab) {
        Sampling sa;
        Sampling sc = sa = ra.getSampling();
        Real1 rc = new Real1(sc);
        float[] va = ra.getValues();
        float[] vc = rc.getValues();
        ab.apply(vc.length, va, 0, br, vc, 0);
        return rc;
    }

    private static interface Binary {
        public void apply(int var1, float[] var2, int var3, float[] var4, int var5, float[] var6, int var7);

        public void apply(int var1, float var2, float[] var3, int var4, float[] var5, int var6);

        public void apply(int var1, float[] var2, int var3, float var4, float[] var5, int var6);
    }
}

