/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.util.Array;
import edu.mines.jtk.util.Check;

class Pfacc {
    private static final float P120 = 0.12053668f;
    private static final float P142 = 0.14231484f;
    private static final float P173 = 0.17364818f;
    private static final float P222 = 0.22252093f;
    private static final float P239 = 0.23931566f;
    private static final float P281 = 0.28173256f;
    private static final float P342 = 0.34202015f;
    private static final float P354 = 0.3546049f;
    private static final float P382 = 0.38268343f;
    private static final float P415 = 0.41541502f;
    private static final float P433 = 0.43388373f;
    private static final float P464 = 0.46472317f;
    private static final float P540 = 0.54064083f;
    private static final float P559 = 0.559017f;
    private static final float P568 = 0.56806475f;
    private static final float P587 = 0.58778524f;
    private static final float P623 = 0.6234898f;
    private static final float P642 = 0.64278764f;
    private static final float P654 = 0.65486073f;
    private static final float P663 = 0.66312265f;
    private static final float P707 = 0.70710677f;
    private static final float P748 = 0.7485107f;
    private static final float P755 = 0.7557496f;
    private static final float P766 = 0.76604444f;
    private static final float P781 = 0.7818315f;
    private static final float P822 = 0.82298386f;
    private static final float P841 = 0.8412535f;
    private static final float P866 = 0.8660254f;
    private static final float P885 = 0.885456f;
    private static final float P900 = 0.90096885f;
    private static final float P909 = 0.90963197f;
    private static final float P923 = 0.9238795f;
    private static final float P935 = 0.9350162f;
    private static final float P939 = 0.9396926f;
    private static final float P951 = 0.95105654f;
    private static final float P959 = 0.959493f;
    private static final float P970 = 0.97094184f;
    private static final float P974 = 0.9749279f;
    private static final float P984 = 0.9848077f;
    private static final float P989 = 0.98982143f;
    private static final float P992 = 0.99270886f;
    private static final float PONE = 1.0f;
    private static final int NFAC = 10;
    private static final int[] _kfac = new int[]{16, 13, 11, 9, 8, 7, 5, 4, 3, 2};
    private static final int NTABLE = 240;
    private static final int[] _ntable = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 20, 21, 22, 24, 26, 28, 30, 33, 35, 36, 39, 40, 42, 44, 45, 48, 52, 55, 56, 60, 63, 65, 66, 70, 72, 77, 78, 80, 84, 88, 90, 91, 99, 104, 105, 110, 112, 117, 120, 126, 130, 132, 140, 143, 144, 154, 156, 165, 168, 176, 180, 182, 195, 198, 208, 210, 220, 231, 234, 240, 252, 260, 264, 273, 280, 286, 308, 312, 315, 330, 336, 360, 364, 385, 390, 396, 420, 429, 440, 455, 462, 468, 495, 504, 520, 528, 546, 560, 572, 585, 616, 624, 630, 660, 693, 715, 720, 728, 770, 780, 792, 819, 840, 858, 880, 910, 924, 936, 990, 1001, 1008, 1040, 1092, 1144, 1155, 1170, 1232, 1260, 1287, 1320, 1365, 1386, 1430, 1456, 1540, 1560, 1584, 1638, 1680, 1716, 1820, 1848, 1872, 1980, 2002, 2145, 2184, 2288, 2310, 2340, 2520, 2574, 2640, 2730, 2772, 2860, 3003, 3080, 3120, 3276, 3432, 3465, 3640, 3696, 3960, 4004, 4095, 4290, 4368, 4620, 4680, 5005, 5040, 5148, 5460, 5544, 5720, 6006, 6160, 6435, 6552, 6864, 6930, 7280, 7920, 8008, 8190, 8580, 9009, 9240, 9360, 10010, 10296, 10920, 11088, 11440, 12012, 12870, 13104, 13860, 15015, 16016, 16380, 17160, 18018, 18480, 20020, 20592, 21840, 24024, 25740, 27720, 30030, 32760, 34320, 36036, 40040, 45045, 48048, 51480, 55440, 60060, 65520, 72072, 80080, 90090, 102960, 120120, 144144, 180180, 240240, 360360, 720720};
    private static final double[] _ctable = new double[]{1.54844595E-6, 1.60858985E-6, 1.73777398E-6, 1.78300246E-6, 1.86692603E-6, 2.02796424E-6, 2.05593203E-6, 2.03027471E-6, 2.13199871E-6, 2.23464061E-6, 2.45504197E-6, 2.24507775E-6, 2.77484785E-6, 2.71335681E-6, 2.60084271E-6, 2.66712117E-6, 2.77849063E-6, 2.84002694E-6, 3.17837121E-6, 3.73373597E-6, 3.15791133E-6, 4.24124687E-6, 3.58681599E-6, 3.74904075E-6, 4.74708669E-6, 4.38838644E-6, 4.01250829E-6, 5.62735292E-6, 4.3411639E-6, 5.17084182E-6, 5.52020262E-6, 4.98530294E-6, 5.2024893E-6, 6.81986102E-6, 7.10553295E-6, 5.93798174E-6, 5.87481339E-6, 7.01743322E-6, 8.61901953E-6, 8.32813604E-6, 7.91730898E-6, 6.8840368E-6, 1.002803645E-5, 1.02678457E-5, 8.19893573E-6, 8.28260941E-6, 1.014724144E-5, 9.34954606E-6, 1.232645727E-5, 1.214189591E-5, 1.269497208E-5, 1.102202755E-5, 1.388176589E-5, 1.172641106E-5, 1.503375461E-5, 1.113972204E-5, 1.364655225E-5, 1.703912278E-5, 1.477596306E-5, 1.424973677E-5, 2.127456187E-5, 1.398938399E-5, 2.00864429E-5, 1.869909587E-5, 1.986433148E-5, 1.651781665E-5, 2.092824006E-5, 1.702478496E-5, 2.499906394E-5, 2.500343282E-5, 2.465807389E-5, 2.632305568E-5, 2.308853872E-5, 2.566435179E-5, 2.996843066E-5, 3.179869821E-5, 2.372351388E-5, 2.578195392E-5, 3.236648622E-5, 3.062192175E-5, 3.688562326E-5, 2.903319322E-5, 4.464405117E-5, 3.835181037E-5, 3.890755813E-5, 3.489790229E-5, 4.193095941E-5, 3.661590772E-5, 3.585050946E-5, 4.948000296E-5, 5.19463679E-5, 5.316664012E-5, 4.831628715E-5, 4.470982143E-5, 6.71179171E-5, 5.416880764E-5, 6.503589644E-5, 6.376341005E-5, 6.060697752E-5, 6.481361636E-5, 5.49474666E-5, 6.84295036E-5, 6.725764749E-5, 7.9550419E-5, 6.51735139E-5, 8.783546746E-5, 8.145918907E-5, 8.208007212E-5, 8.453260181E-5, 7.714824943E-5, 8.332986646E-5, 9.686623465E-5, 1.1742291007E-4, 8.016979016E-5, 1.0372863801E-4, 1.1169975463E-4, 1.0527145635E-4, 1.0259693695E-4, 1.2171112596E-4, 9.645574497E-5, 1.4179527113E-4, 1.1871442125E-4, 1.4121545403E-4, 1.2558781115E-4, 1.2962723272E-4, 1.4012872534E-4, 1.7282139776E-4, 1.2333743842E-4, 1.5017243965E-4, 1.5933147632E-4, 1.8467637839E-4, 1.6783978549E-4, 1.7760241178E-4, 1.8111945022E-4, 1.5790303508E-4, 2.1759913091E-4, 1.7785473273E-4, 2.1290391156E-4, 2.1022786937E-4, 2.5198138131E-4, 2.2553766468E-4, 2.2349921892E-4, 2.2576645627E-4, 2.2422478451E-4, 2.6572035023E-4, 2.1417878529E-4, 2.8409252164E-4, 2.8290960452E-4, 2.6774495388E-4, 2.8504340401E-4, 2.8006152125E-4, 3.7010347376E-4, 3.7949981053E-4, 3.3613022319E-4, 4.0431974162E-4, 3.6459661264E-4, 3.535121779E-4, 3.3107438017E-4, 4.668997669E-4, 3.9452432539E-4, 4.564721969E-4, 4.2150673401E-4, 5.0466112371E-4, 5.5797101449E-4, 4.7941598851E-4, 4.9189587426E-4, 5.2933403805E-4, 6.056849108E-4, 5.6200897868E-4, 6.0222489477E-4, 5.884253819E-4, 6.0084033613E-4, 7.4850523169E-4, 7.0305370305E-4, 8.1422764228E-4, 7.3423753666E-4, 7.3504587156E-4, 7.5785092698E-4, 9.8138167565E-4, 7.3504587156E-4, 9.3946503989E-4, 9.1880733945E-4, 9.0674513354E-4, 0.00105810882198, 0.0012059000602, 0.00104322916667, 0.00124255583127, 0.00113291855204, 0.00130338541667, 0.00122432762836, 0.00130234070221, 0.0013344437042, 0.00158214849921, 0.00153958493467, 0.00166694421316, 0.00183424908425, 0.00157344854674, 0.00164180327869, 0.00210620399579, 0.00198316831683, 0.00195414634146, 0.00197145669291, 0.00228132118451, 0.00241495778046, 0.00264248021108, 0.00243970767357, 0.00246068796069, 0.00314937106918, 0.00341226575809, 0.00304407294833, 0.00342979452055, 0.00391780821918, 0.00339491525424, 0.00423467230444, 0.00427991452991, 0.00422573839662, 0.0051358974359, 0.00532712765957, 0.00522976501305, 0.00671812080537, 0.00644051446945, 0.00747388059701, 0.00785490196078, 0.00890222222222, 0.01032474226804, 0.01088586956522, 0.01131638418079, 0.01125280898876, 0.01371232876712, 0.01390972222222, 0.01663636363636, 0.01917142857143, 0.02201098901099, 0.02425301204819, 0.02849295774648, 0.03531578947368, 0.04575, 0.06190909090909, 0.10542105263158, 0.24033333333333};

    Pfacc() {
    }

    static boolean nfftValid(int nfft) {
        return Array.binarySearch(_ntable, nfft) >= 0;
    }

    static int nfftSmall(int n) {
        Check.argument(n <= 720720, "n does not exceed 720720");
        int itable = Array.binarySearch(_ntable, n);
        if (itable < 0) {
            itable = -(itable + 1);
        }
        return _ntable[itable];
    }

    static int nfftFast(int n) {
        Check.argument(n <= 720720, "n does not exceed 720720");
        int ifast = Array.binarySearch(_ntable, n);
        if (ifast < 0) {
            ifast = -(ifast + 1);
        }
        int nfast = _ntable[ifast];
        int nstop = 2 * nfast;
        double cfast = _ctable[ifast];
        for (int i = ifast + 1; i < 240 && _ntable[i] < nstop; ++i) {
            if (!(_ctable[i] < cfast)) continue;
            cfast = _ctable[i];
            nfast = _ntable[i];
        }
        return nfast;
    }

    static void transform(int sign, int nfft, float[] z) {
        int nleft = nfft;
        for (int jfac = 0; jfac < 10; ++jfac) {
            int ifac = _kfac[jfac];
            int ndiv = nleft / ifac;
            if (ndiv * ifac != nleft) continue;
            nleft = ndiv;
            int m = nfft / ifac;
            int mu = 0;
            int mm = 0;
            for (int kfac = 1; kfac <= ifac && mm % ifac != 1; ++kfac) {
                mu = kfac;
                mm = kfac * m;
            }
            if (sign < 0) {
                mu = ifac - mu;
            }
            int jinc = 2 * mm;
            int jmax = 2 * nfft;
            int j0 = 0;
            int j1 = j0 + jinc;
            if (ifac == 2) {
                Pfacc.pfa2(z, mu, m, j0, j1);
                continue;
            }
            int j2 = (j1 + jinc) % jmax;
            if (ifac == 3) {
                Pfacc.pfa3(z, mu, m, j0, j1, j2);
                continue;
            }
            int j3 = (j2 + jinc) % jmax;
            if (ifac == 4) {
                Pfacc.pfa4(z, mu, m, j0, j1, j2, j3);
                continue;
            }
            int j4 = (j3 + jinc) % jmax;
            if (ifac == 5) {
                Pfacc.pfa5(z, mu, m, j0, j1, j2, j3, j4);
                continue;
            }
            int j5 = (j4 + jinc) % jmax;
            int j6 = (j5 + jinc) % jmax;
            if (ifac == 7) {
                Pfacc.pfa7(z, mu, m, j0, j1, j2, j3, j4, j5, j6);
                continue;
            }
            int j7 = (j6 + jinc) % jmax;
            if (ifac == 8) {
                Pfacc.pfa8(z, mu, m, j0, j1, j2, j3, j4, j5, j6, j7);
                continue;
            }
            int j8 = (j7 + jinc) % jmax;
            if (ifac == 9) {
                Pfacc.pfa9(z, mu, m, j0, j1, j2, j3, j4, j5, j6, j7, j8);
                continue;
            }
            int j9 = (j8 + jinc) % jmax;
            int j10 = (j9 + jinc) % jmax;
            if (ifac == 11) {
                Pfacc.pfa11(z, mu, m, j0, j1, j2, j3, j4, j5, j6, j7, j8, j9, j10);
                continue;
            }
            int j11 = (j10 + jinc) % jmax;
            int j12 = (j11 + jinc) % jmax;
            if (ifac == 13) {
                Pfacc.pfa13(z, mu, m, j0, j1, j2, j3, j4, j5, j6, j7, j8, j9, j10, j11, j12);
                continue;
            }
            int j13 = (j12 + jinc) % jmax;
            int j14 = (j13 + jinc) % jmax;
            int j15 = (j14 + jinc) % jmax;
            if (ifac != 16) continue;
            Pfacc.pfa16(z, mu, m, j0, j1, j2, j3, j4, j5, j6, j7, j8, j9, j10, j11, j12, j13, j14, j15);
        }
    }

    private static void pfa2(float[] z, int mu, int m, int j0, int j1) {
        for (int i = 0; i < m; ++i) {
            float t1r = z[j0] - z[j1];
            float t1i = z[j0 + 1] - z[j1 + 1];
            z[j0] = z[j0] + z[j1];
            z[j0 + 1] = z[j0 + 1] + z[j1 + 1];
            z[j1] = t1r;
            z[j1 + 1] = t1i;
            int jt = j1 + 2;
            j1 = j0 + 2;
            j0 = jt;
        }
    }

    private static void pfa3(float[] z, int mu, int m, int j0, int j1, int j2) {
        float c1 = mu == 1 ? 0.8660254f : -0.8660254f;
        for (int i = 0; i < m; ++i) {
            float t1r = z[j1] + z[j2];
            float t1i = z[j1 + 1] + z[j2 + 1];
            float y1r = z[j0] - 0.5f * t1r;
            float y1i = z[j0 + 1] - 0.5f * t1i;
            float y2r = c1 * (z[j1] - z[j2]);
            float y2i = c1 * (z[j1 + 1] - z[j2 + 1]);
            z[j0] = z[j0] + t1r;
            z[j0 + 1] = z[j0 + 1] + t1i;
            z[j1] = y1r - y2i;
            z[j1 + 1] = y1i + y2r;
            z[j2] = y1r + y2i;
            z[j2 + 1] = y1i - y2r;
            int jt = j2 + 2;
            j2 = j1 + 2;
            j1 = j0 + 2;
            j0 = jt;
        }
    }

    private static void pfa4(float[] z, int mu, int m, int j0, int j1, int j2, int j3) {
        float c1 = mu == 1 ? 1.0f : -1.0f;
        for (int i = 0; i < m; ++i) {
            float t1r = z[j0] + z[j2];
            float t1i = z[j0 + 1] + z[j2 + 1];
            float t2r = z[j1] + z[j3];
            float t2i = z[j1 + 1] + z[j3 + 1];
            float y1r = z[j0] - z[j2];
            float y1i = z[j0 + 1] - z[j2 + 1];
            float y3r = c1 * (z[j1] - z[j3]);
            float y3i = c1 * (z[j1 + 1] - z[j3 + 1]);
            z[j0] = t1r + t2r;
            z[j0 + 1] = t1i + t2i;
            z[j1] = y1r - y3i;
            z[j1 + 1] = y1i + y3r;
            z[j2] = t1r - t2r;
            z[j2 + 1] = t1i - t2i;
            z[j3] = y1r + y3i;
            z[j3 + 1] = y1i - y3r;
            int jt = j3 + 2;
            j3 = j2 + 2;
            j2 = j1 + 2;
            j1 = j0 + 2;
            j0 = jt;
        }
    }

    private static void pfa5(float[] z, int mu, int m, int j0, int j1, int j2, int j3, int j4) {
        float c3;
        float c2;
        float c1;
        if (mu == 1) {
            c1 = 0.559017f;
            c2 = 0.95105654f;
            c3 = 0.58778524f;
        } else if (mu == 2) {
            c1 = -0.559017f;
            c2 = 0.58778524f;
            c3 = -0.95105654f;
        } else if (mu == 3) {
            c1 = -0.559017f;
            c2 = -0.58778524f;
            c3 = 0.95105654f;
        } else {
            c1 = 0.559017f;
            c2 = -0.95105654f;
            c3 = -0.58778524f;
        }
        for (int i = 0; i < m; ++i) {
            float t1r = z[j1] + z[j4];
            float t1i = z[j1 + 1] + z[j4 + 1];
            float t2r = z[j2] + z[j3];
            float t2i = z[j2 + 1] + z[j3 + 1];
            float t3r = z[j1] - z[j4];
            float t3i = z[j1 + 1] - z[j4 + 1];
            float t4r = z[j2] - z[j3];
            float t4i = z[j2 + 1] - z[j3 + 1];
            float t5r = t1r + t2r;
            float t5i = t1i + t2i;
            float t6r = c1 * (t1r - t2r);
            float t6i = c1 * (t1i - t2i);
            float t7r = z[j0] - 0.25f * t5r;
            float t7i = z[j0 + 1] - 0.25f * t5i;
            float y1r = t7r + t6r;
            float y1i = t7i + t6i;
            float y2r = t7r - t6r;
            float y2i = t7i - t6i;
            float y3r = c3 * t3r - c2 * t4r;
            float y3i = c3 * t3i - c2 * t4i;
            float y4r = c2 * t3r + c3 * t4r;
            float y4i = c2 * t3i + c3 * t4i;
            z[j0] = z[j0] + t5r;
            z[j0 + 1] = z[j0 + 1] + t5i;
            z[j1] = y1r - y4i;
            z[j1 + 1] = y1i + y4r;
            z[j2] = y2r - y3i;
            z[j2 + 1] = y2i + y3r;
            z[j3] = y2r + y3i;
            z[j3 + 1] = y2i - y3r;
            z[j4] = y1r + y4i;
            z[j4 + 1] = y1i - y4r;
            int jt = j4 + 2;
            j4 = j3 + 2;
            j3 = j2 + 2;
            j2 = j1 + 2;
            j1 = j0 + 2;
            j0 = jt;
        }
    }

    private static void pfa7(float[] z, int mu, int m, int j0, int j1, int j2, int j3, int j4, int j5, int j6) {
        float c6;
        float c5;
        float c4;
        float c3;
        float c2;
        float c1;
        if (mu == 1) {
            c1 = 0.6234898f;
            c2 = -0.22252093f;
            c3 = -0.90096885f;
            c4 = 0.7818315f;
            c5 = 0.9749279f;
            c6 = 0.43388373f;
        } else if (mu == 2) {
            c1 = -0.22252093f;
            c2 = -0.90096885f;
            c3 = 0.6234898f;
            c4 = 0.9749279f;
            c5 = -0.43388373f;
            c6 = -0.7818315f;
        } else if (mu == 3) {
            c1 = -0.90096885f;
            c2 = 0.6234898f;
            c3 = -0.22252093f;
            c4 = 0.43388373f;
            c5 = -0.7818315f;
            c6 = 0.9749279f;
        } else if (mu == 4) {
            c1 = -0.90096885f;
            c2 = 0.6234898f;
            c3 = -0.22252093f;
            c4 = -0.43388373f;
            c5 = 0.7818315f;
            c6 = -0.9749279f;
        } else if (mu == 5) {
            c1 = -0.22252093f;
            c2 = -0.90096885f;
            c3 = 0.6234898f;
            c4 = -0.9749279f;
            c5 = 0.43388373f;
            c6 = 0.7818315f;
        } else {
            c1 = 0.6234898f;
            c2 = -0.22252093f;
            c3 = -0.90096885f;
            c4 = -0.7818315f;
            c5 = -0.9749279f;
            c6 = -0.43388373f;
        }
        for (int i = 0; i < m; ++i) {
            float t1r = z[j1] + z[j6];
            float t1i = z[j1 + 1] + z[j6 + 1];
            float t2r = z[j2] + z[j5];
            float t2i = z[j2 + 1] + z[j5 + 1];
            float t3r = z[j3] + z[j4];
            float t3i = z[j3 + 1] + z[j4 + 1];
            float t4r = z[j1] - z[j6];
            float t4i = z[j1 + 1] - z[j6 + 1];
            float t5r = z[j2] - z[j5];
            float t5i = z[j2 + 1] - z[j5 + 1];
            float t6r = z[j3] - z[j4];
            float t6i = z[j3 + 1] - z[j4 + 1];
            float t7r = z[j0] - 0.5f * t3r;
            float t7i = z[j0 + 1] - 0.5f * t3i;
            float t8r = t1r - t3r;
            float t8i = t1i - t3i;
            float t9r = t2r - t3r;
            float t9i = t2i - t3i;
            float y1r = t7r + c1 * t8r + c2 * t9r;
            float y1i = t7i + c1 * t8i + c2 * t9i;
            float y2r = t7r + c2 * t8r + c3 * t9r;
            float y2i = t7i + c2 * t8i + c3 * t9i;
            float y3r = t7r + c3 * t8r + c1 * t9r;
            float y3i = t7i + c3 * t8i + c1 * t9i;
            float y4r = c6 * t4r - c4 * t5r + c5 * t6r;
            float y4i = c6 * t4i - c4 * t5i + c5 * t6i;
            float y5r = c5 * t4r - c6 * t5r - c4 * t6r;
            float y5i = c5 * t4i - c6 * t5i - c4 * t6i;
            float y6r = c4 * t4r + c5 * t5r + c6 * t6r;
            float y6i = c4 * t4i + c5 * t5i + c6 * t6i;
            z[j0] = z[j0] + t1r + t2r + t3r;
            z[j0 + 1] = z[j0 + 1] + t1i + t2i + t3i;
            z[j1] = y1r - y6i;
            z[j1 + 1] = y1i + y6r;
            z[j2] = y2r - y5i;
            z[j2 + 1] = y2i + y5r;
            z[j3] = y3r - y4i;
            z[j3 + 1] = y3i + y4r;
            z[j4] = y3r + y4i;
            z[j4 + 1] = y3i - y4r;
            z[j5] = y2r + y5i;
            z[j5 + 1] = y2i - y5r;
            z[j6] = y1r + y6i;
            z[j6 + 1] = y1i - y6r;
            int jt = j6 + 2;
            j6 = j5 + 2;
            j5 = j4 + 2;
            j4 = j3 + 2;
            j3 = j2 + 2;
            j2 = j1 + 2;
            j1 = j0 + 2;
            j0 = jt;
        }
    }

    private static void pfa8(float[] z, int mu, int m, int j0, int j1, int j2, int j3, int j4, int j5, int j6, int j7) {
        float c2;
        float c1;
        if (mu == 1) {
            c1 = 1.0f;
            c2 = 0.70710677f;
        } else if (mu == 3) {
            c1 = -1.0f;
            c2 = -0.70710677f;
        } else if (mu == 5) {
            c1 = 1.0f;
            c2 = -0.70710677f;
        } else {
            c1 = -1.0f;
            c2 = 0.70710677f;
        }
        float c3 = c1 * c2;
        for (int i = 0; i < m; ++i) {
            float t1r = z[j0] + z[j4];
            float t1i = z[j0 + 1] + z[j4 + 1];
            float t2r = z[j0] - z[j4];
            float t2i = z[j0 + 1] - z[j4 + 1];
            float t3r = z[j1] + z[j5];
            float t3i = z[j1 + 1] + z[j5 + 1];
            float t4r = z[j1] - z[j5];
            float t4i = z[j1 + 1] - z[j5 + 1];
            float t5r = z[j2] + z[j6];
            float t5i = z[j2 + 1] + z[j6 + 1];
            float t6r = c1 * (z[j2] - z[j6]);
            float t6i = c1 * (z[j2 + 1] - z[j6 + 1]);
            float t7r = z[j3] + z[j7];
            float t7i = z[j3 + 1] + z[j7 + 1];
            float t8r = z[j3] - z[j7];
            float t8i = z[j3 + 1] - z[j7 + 1];
            float t9r = t1r + t5r;
            float t9i = t1i + t5i;
            float t10r = t3r + t7r;
            float t10i = t3i + t7i;
            float t11r = c2 * (t4r - t8r);
            float t11i = c2 * (t4i - t8i);
            float t12r = c3 * (t4r + t8r);
            float t12i = c3 * (t4i + t8i);
            float y1r = t2r + t11r;
            float y1i = t2i + t11i;
            float y2r = t1r - t5r;
            float y2i = t1i - t5i;
            float y3r = t2r - t11r;
            float y3i = t2i - t11i;
            float y5r = t12r - t6r;
            float y5i = t12i - t6i;
            float y6r = c1 * (t3r - t7r);
            float y6i = c1 * (t3i - t7i);
            float y7r = t12r + t6r;
            float y7i = t12i + t6i;
            z[j0] = t9r + t10r;
            z[j0 + 1] = t9i + t10i;
            z[j1] = y1r - y7i;
            z[j1 + 1] = y1i + y7r;
            z[j2] = y2r - y6i;
            z[j2 + 1] = y2i + y6r;
            z[j3] = y3r - y5i;
            z[j3 + 1] = y3i + y5r;
            z[j4] = t9r - t10r;
            z[j4 + 1] = t9i - t10i;
            z[j5] = y3r + y5i;
            z[j5 + 1] = y3i - y5r;
            z[j6] = y2r + y6i;
            z[j6 + 1] = y2i - y6r;
            z[j7] = y1r + y7i;
            z[j7 + 1] = y1i - y7r;
            int jt = j7 + 2;
            j7 = j6 + 2;
            j6 = j5 + 2;
            j5 = j4 + 2;
            j4 = j3 + 2;
            j3 = j2 + 2;
            j2 = j1 + 2;
            j1 = j0 + 2;
            j0 = jt;
        }
    }

    private static void pfa9(float[] z, int mu, int m, int j0, int j1, int j2, int j3, int j4, int j5, int j6, int j7, int j8) {
        float c5;
        float c4;
        float c3;
        float c2;
        float c1;
        if (mu == 1) {
            c1 = 0.8660254f;
            c2 = 0.76604444f;
            c3 = 0.64278764f;
            c4 = 0.17364818f;
            c5 = 0.9848077f;
        } else if (mu == 2) {
            c1 = -0.8660254f;
            c2 = 0.17364818f;
            c3 = 0.9848077f;
            c4 = -0.9396926f;
            c5 = 0.34202015f;
        } else if (mu == 4) {
            c1 = 0.8660254f;
            c2 = -0.9396926f;
            c3 = 0.34202015f;
            c4 = 0.76604444f;
            c5 = -0.64278764f;
        } else if (mu == 5) {
            c1 = -0.8660254f;
            c2 = -0.9396926f;
            c3 = -0.34202015f;
            c4 = 0.76604444f;
            c5 = 0.64278764f;
        } else if (mu == 7) {
            c1 = 0.8660254f;
            c2 = 0.17364818f;
            c3 = -0.9848077f;
            c4 = -0.9396926f;
            c5 = -0.34202015f;
        } else {
            c1 = -0.8660254f;
            c2 = 0.76604444f;
            c3 = -0.64278764f;
            c4 = 0.17364818f;
            c5 = -0.9848077f;
        }
        float c6 = c1 * c2;
        float c7 = c1 * c3;
        float c8 = c1 * c4;
        float c9 = c1 * c5;
        for (int i = 0; i < m; ++i) {
            float t1r = z[j3] + z[j6];
            float t1i = z[j3 + 1] + z[j6 + 1];
            float t2r = z[j0] - 0.5f * t1r;
            float t2i = z[j0 + 1] - 0.5f * t1i;
            float t3r = c1 * (z[j3] - z[j6]);
            float t3i = c1 * (z[j3 + 1] - z[j6 + 1]);
            float t4r = z[j0] + t1r;
            float t4i = z[j0 + 1] + t1i;
            float t5r = z[j4] + z[j7];
            float t5i = z[j4 + 1] + z[j7 + 1];
            float t6r = z[j1] - 0.5f * t5r;
            float t6i = z[j1 + 1] - 0.5f * t5i;
            float t7r = z[j4] - z[j7];
            float t7i = z[j4 + 1] - z[j7 + 1];
            float t8r = z[j1] + t5r;
            float t8i = z[j1 + 1] + t5i;
            float t9r = z[j2] + z[j5];
            float t9i = z[j2 + 1] + z[j5 + 1];
            float t10r = z[j8] - 0.5f * t9r;
            float t10i = z[j8 + 1] - 0.5f * t9i;
            float t11r = z[j2] - z[j5];
            float t11i = z[j2 + 1] - z[j5 + 1];
            float t12r = z[j8] + t9r;
            float t12i = z[j8 + 1] + t9i;
            float t13r = t8r + t12r;
            float t13i = t8i + t12i;
            float t14r = t6r + t10r;
            float t14i = t6i + t10i;
            float t15r = t6r - t10r;
            float t15i = t6i - t10i;
            float t16r = t7r + t11r;
            float t16i = t7i + t11i;
            float t17r = t7r - t11r;
            float t17i = t7i - t11i;
            float t18r = c2 * t14r - c7 * t17r;
            float t18i = c2 * t14i - c7 * t17i;
            float t19r = c4 * t14r + c9 * t17r;
            float t19i = c4 * t14i + c9 * t17i;
            float t20r = c3 * t15r + c6 * t16r;
            float t20i = c3 * t15i + c6 * t16i;
            float t21r = c5 * t15r - c8 * t16r;
            float t21i = c5 * t15i - c8 * t16i;
            float t22r = t18r + t19r;
            float t22i = t18i + t19i;
            float t23r = t20r - t21r;
            float t23i = t20i - t21i;
            float y1r = t2r + t18r;
            float y1i = t2i + t18i;
            float y2r = t2r + t19r;
            float y2i = t2i + t19i;
            float y3r = t4r - 0.5f * t13r;
            float y3i = t4i - 0.5f * t13i;
            float y4r = t2r - t22r;
            float y4i = t2i - t22i;
            float y5r = t3r - t23r;
            float y5i = t3i - t23i;
            float y6r = c1 * (t8r - t12r);
            float y6i = c1 * (t8i - t12i);
            float y7r = t21r - t3r;
            float y7i = t21i - t3i;
            float y8r = t3r + t20r;
            float y8i = t3i + t20i;
            z[j0] = t4r + t13r;
            z[j0 + 1] = t4i + t13i;
            z[j1] = y1r - y8i;
            z[j1 + 1] = y1i + y8r;
            z[j2] = y2r - y7i;
            z[j2 + 1] = y2i + y7r;
            z[j3] = y3r - y6i;
            z[j3 + 1] = y3i + y6r;
            z[j4] = y4r - y5i;
            z[j4 + 1] = y4i + y5r;
            z[j5] = y4r + y5i;
            z[j5 + 1] = y4i - y5r;
            z[j6] = y3r + y6i;
            z[j6 + 1] = y3i - y6r;
            z[j7] = y2r + y7i;
            z[j7 + 1] = y2i - y7r;
            z[j8] = y1r + y8i;
            z[j8 + 1] = y1i - y8r;
            int jt = j8 + 2;
            j8 = j7 + 2;
            j7 = j6 + 2;
            j6 = j5 + 2;
            j5 = j4 + 2;
            j4 = j3 + 2;
            j3 = j2 + 2;
            j2 = j1 + 2;
            j1 = j0 + 2;
            j0 = jt;
        }
    }

    private static void pfa11(float[] z, int mu, int m, int j0, int j1, int j2, int j3, int j4, int j5, int j6, int j7, int j8, int j9, int j10) {
        float c10;
        float c9;
        float c8;
        float c7;
        float c6;
        float c5;
        float c4;
        float c3;
        float c2;
        float c1;
        if (mu == 1) {
            c1 = 0.8412535f;
            c2 = 0.41541502f;
            c3 = -0.14231484f;
            c4 = -0.65486073f;
            c5 = -0.959493f;
            c6 = 0.54064083f;
            c7 = 0.90963197f;
            c8 = 0.98982143f;
            c9 = 0.7557496f;
            c10 = 0.28173256f;
        } else if (mu == 2) {
            c1 = 0.41541502f;
            c2 = -0.65486073f;
            c3 = -0.959493f;
            c4 = -0.14231484f;
            c5 = 0.8412535f;
            c6 = 0.90963197f;
            c7 = 0.7557496f;
            c8 = -0.28173256f;
            c9 = -0.98982143f;
            c10 = -0.54064083f;
        } else if (mu == 3) {
            c1 = -0.14231484f;
            c2 = -0.959493f;
            c3 = 0.41541502f;
            c4 = 0.8412535f;
            c5 = -0.65486073f;
            c6 = 0.98982143f;
            c7 = -0.28173256f;
            c8 = -0.90963197f;
            c9 = 0.54064083f;
            c10 = 0.7557496f;
        } else if (mu == 4) {
            c1 = -0.65486073f;
            c2 = -0.14231484f;
            c3 = 0.8412535f;
            c4 = -0.959493f;
            c5 = 0.41541502f;
            c6 = 0.7557496f;
            c7 = -0.98982143f;
            c8 = 0.54064083f;
            c9 = 0.28173256f;
            c10 = -0.90963197f;
        } else if (mu == 5) {
            c1 = -0.959493f;
            c2 = 0.8412535f;
            c3 = -0.65486073f;
            c4 = 0.41541502f;
            c5 = -0.14231484f;
            c6 = 0.28173256f;
            c7 = -0.54064083f;
            c8 = 0.7557496f;
            c9 = -0.90963197f;
            c10 = 0.98982143f;
        } else if (mu == 6) {
            c1 = -0.959493f;
            c2 = 0.8412535f;
            c3 = -0.65486073f;
            c4 = 0.41541502f;
            c5 = -0.14231484f;
            c6 = -0.28173256f;
            c7 = 0.54064083f;
            c8 = -0.7557496f;
            c9 = 0.90963197f;
            c10 = -0.98982143f;
        } else if (mu == 7) {
            c1 = -0.65486073f;
            c2 = -0.14231484f;
            c3 = 0.8412535f;
            c4 = -0.959493f;
            c5 = 0.41541502f;
            c6 = -0.7557496f;
            c7 = 0.98982143f;
            c8 = -0.54064083f;
            c9 = -0.28173256f;
            c10 = 0.90963197f;
        } else if (mu == 8) {
            c1 = -0.14231484f;
            c2 = -0.959493f;
            c3 = 0.41541502f;
            c4 = 0.8412535f;
            c5 = -0.65486073f;
            c6 = -0.98982143f;
            c7 = 0.28173256f;
            c8 = 0.90963197f;
            c9 = -0.54064083f;
            c10 = -0.7557496f;
        } else if (mu == 9) {
            c1 = 0.41541502f;
            c2 = -0.65486073f;
            c3 = -0.959493f;
            c4 = -0.14231484f;
            c5 = 0.8412535f;
            c6 = -0.90963197f;
            c7 = -0.7557496f;
            c8 = 0.28173256f;
            c9 = 0.98982143f;
            c10 = 0.54064083f;
        } else {
            c1 = 0.8412535f;
            c2 = 0.41541502f;
            c3 = -0.14231484f;
            c4 = -0.65486073f;
            c5 = -0.959493f;
            c6 = -0.54064083f;
            c7 = -0.90963197f;
            c8 = -0.98982143f;
            c9 = -0.7557496f;
            c10 = -0.28173256f;
        }
        for (int i = 0; i < m; ++i) {
            float t1r = z[j1] + z[j10];
            float t1i = z[j1 + 1] + z[j10 + 1];
            float t2r = z[j2] + z[j9];
            float t2i = z[j2 + 1] + z[j9 + 1];
            float t3r = z[j3] + z[j8];
            float t3i = z[j3 + 1] + z[j8 + 1];
            float t4r = z[j4] + z[j7];
            float t4i = z[j4 + 1] + z[j7 + 1];
            float t5r = z[j5] + z[j6];
            float t5i = z[j5 + 1] + z[j6 + 1];
            float t6r = z[j1] - z[j10];
            float t6i = z[j1 + 1] - z[j10 + 1];
            float t7r = z[j2] - z[j9];
            float t7i = z[j2 + 1] - z[j9 + 1];
            float t8r = z[j3] - z[j8];
            float t8i = z[j3 + 1] - z[j8 + 1];
            float t9r = z[j4] - z[j7];
            float t9i = z[j4 + 1] - z[j7 + 1];
            float t10r = z[j5] - z[j6];
            float t10i = z[j5 + 1] - z[j6 + 1];
            float t11r = z[j0] - 0.5f * t5r;
            float t11i = z[j0 + 1] - 0.5f * t5i;
            float t12r = t1r - t5r;
            float t12i = t1i - t5i;
            float t13r = t2r - t5r;
            float t13i = t2i - t5i;
            float t14r = t3r - t5r;
            float t14i = t3i - t5i;
            float t15r = t4r - t5r;
            float t15i = t4i - t5i;
            float y1r = t11r + c1 * t12r + c2 * t13r + c3 * t14r + c4 * t15r;
            float y1i = t11i + c1 * t12i + c2 * t13i + c3 * t14i + c4 * t15i;
            float y2r = t11r + c2 * t12r + c4 * t13r + c5 * t14r + c3 * t15r;
            float y2i = t11i + c2 * t12i + c4 * t13i + c5 * t14i + c3 * t15i;
            float y3r = t11r + c3 * t12r + c5 * t13r + c2 * t14r + c1 * t15r;
            float y3i = t11i + c3 * t12i + c5 * t13i + c2 * t14i + c1 * t15i;
            float y4r = t11r + c4 * t12r + c3 * t13r + c1 * t14r + c5 * t15r;
            float y4i = t11i + c4 * t12i + c3 * t13i + c1 * t14i + c5 * t15i;
            float y5r = t11r + c5 * t12r + c1 * t13r + c4 * t14r + c2 * t15r;
            float y5i = t11i + c5 * t12i + c1 * t13i + c4 * t14i + c2 * t15i;
            float y6r = c10 * t6r - c6 * t7r + c9 * t8r - c7 * t9r + c8 * t10r;
            float y6i = c10 * t6i - c6 * t7i + c9 * t8i - c7 * t9i + c8 * t10i;
            float y7r = c9 * t6r - c8 * t7r + c6 * t8r + c10 * t9r - c7 * t10r;
            float y7i = c9 * t6i - c8 * t7i + c6 * t8i + c10 * t9i - c7 * t10i;
            float y8r = c8 * t6r - c10 * t7r - c7 * t8r + c6 * t9r + c9 * t10r;
            float y8i = c8 * t6i - c10 * t7i - c7 * t8i + c6 * t9i + c9 * t10i;
            float y9r = c7 * t6r + c9 * t7r - c10 * t8r - c8 * t9r - c6 * t10r;
            float y9i = c7 * t6i + c9 * t7i - c10 * t8i - c8 * t9i - c6 * t10i;
            float y10r = c6 * t6r + c7 * t7r + c8 * t8r + c9 * t9r + c10 * t10r;
            float y10i = c6 * t6i + c7 * t7i + c8 * t8i + c9 * t9i + c10 * t10i;
            z[j0] = z[j0] + t1r + t2r + t3r + t4r + t5r;
            z[j0 + 1] = z[j0 + 1] + t1i + t2i + t3i + t4i + t5i;
            z[j1] = y1r - y10i;
            z[j1 + 1] = y1i + y10r;
            z[j2] = y2r - y9i;
            z[j2 + 1] = y2i + y9r;
            z[j3] = y3r - y8i;
            z[j3 + 1] = y3i + y8r;
            z[j4] = y4r - y7i;
            z[j4 + 1] = y4i + y7r;
            z[j5] = y5r - y6i;
            z[j5 + 1] = y5i + y6r;
            z[j6] = y5r + y6i;
            z[j6 + 1] = y5i - y6r;
            z[j7] = y4r + y7i;
            z[j7 + 1] = y4i - y7r;
            z[j8] = y3r + y8i;
            z[j8 + 1] = y3i - y8r;
            z[j9] = y2r + y9i;
            z[j9 + 1] = y2i - y9r;
            z[j10] = y1r + y10i;
            z[j10 + 1] = y1i - y10r;
            int jt = j10 + 2;
            j10 = j9 + 2;
            j9 = j8 + 2;
            j8 = j7 + 2;
            j7 = j6 + 2;
            j6 = j5 + 2;
            j5 = j4 + 2;
            j4 = j3 + 2;
            j3 = j2 + 2;
            j2 = j1 + 2;
            j1 = j0 + 2;
            j0 = jt;
        }
    }

    private static void pfa13(float[] z, int mu, int m, int j0, int j1, int j2, int j3, int j4, int j5, int j6, int j7, int j8, int j9, int j10, int j11, int j12) {
        float c12;
        float c11;
        float c10;
        float c9;
        float c8;
        float c7;
        float c6;
        float c5;
        float c4;
        float c3;
        float c2;
        float c1;
        if (mu == 1) {
            c1 = 0.885456f;
            c2 = 0.56806475f;
            c3 = 0.12053668f;
            c4 = -0.3546049f;
            c5 = -0.7485107f;
            c6 = -0.97094184f;
            c7 = 0.46472317f;
            c8 = 0.82298386f;
            c9 = 0.99270886f;
            c10 = 0.9350162f;
            c11 = 0.66312265f;
            c12 = 0.23931566f;
        } else if (mu == 2) {
            c1 = 0.56806475f;
            c2 = -0.3546049f;
            c3 = -0.97094184f;
            c4 = -0.7485107f;
            c5 = 0.12053668f;
            c6 = 0.885456f;
            c7 = 0.82298386f;
            c8 = 0.9350162f;
            c9 = 0.23931566f;
            c10 = -0.66312265f;
            c11 = -0.99270886f;
            c12 = -0.46472317f;
        } else if (mu == 3) {
            c1 = 0.12053668f;
            c2 = -0.97094184f;
            c3 = -0.3546049f;
            c4 = 0.885456f;
            c5 = 0.56806475f;
            c6 = -0.7485107f;
            c7 = 0.99270886f;
            c8 = 0.23931566f;
            c9 = -0.9350162f;
            c10 = -0.46472317f;
            c11 = 0.82298386f;
            c12 = 0.66312265f;
        } else if (mu == 4) {
            c1 = -0.3546049f;
            c2 = -0.7485107f;
            c3 = 0.885456f;
            c4 = 0.12053668f;
            c5 = -0.97094184f;
            c6 = 0.56806475f;
            c7 = 0.9350162f;
            c8 = -0.66312265f;
            c9 = -0.46472317f;
            c10 = 0.99270886f;
            c11 = -0.23931566f;
            c12 = -0.82298386f;
        } else if (mu == 5) {
            c1 = -0.7485107f;
            c2 = 0.12053668f;
            c3 = 0.56806475f;
            c4 = -0.97094184f;
            c5 = 0.885456f;
            c6 = -0.3546049f;
            c7 = 0.66312265f;
            c8 = -0.99270886f;
            c9 = 0.82298386f;
            c10 = -0.23931566f;
            c11 = -0.46472317f;
            c12 = 0.9350162f;
        } else if (mu == 6) {
            c1 = -0.97094184f;
            c2 = 0.885456f;
            c3 = -0.7485107f;
            c4 = 0.56806475f;
            c5 = -0.3546049f;
            c6 = 0.12053668f;
            c7 = 0.23931566f;
            c8 = -0.46472317f;
            c9 = 0.66312265f;
            c10 = -0.82298386f;
            c11 = 0.9350162f;
            c12 = -0.99270886f;
        } else if (mu == 7) {
            c1 = -0.97094184f;
            c2 = 0.885456f;
            c3 = -0.7485107f;
            c4 = 0.56806475f;
            c5 = -0.3546049f;
            c6 = 0.12053668f;
            c7 = -0.23931566f;
            c8 = 0.46472317f;
            c9 = -0.66312265f;
            c10 = 0.82298386f;
            c11 = -0.9350162f;
            c12 = 0.99270886f;
        } else if (mu == 8) {
            c1 = -0.7485107f;
            c2 = 0.12053668f;
            c3 = 0.56806475f;
            c4 = -0.97094184f;
            c5 = 0.885456f;
            c6 = -0.3546049f;
            c7 = -0.66312265f;
            c8 = 0.99270886f;
            c9 = -0.82298386f;
            c10 = 0.23931566f;
            c11 = 0.46472317f;
            c12 = -0.9350162f;
        } else if (mu == 9) {
            c1 = -0.3546049f;
            c2 = -0.7485107f;
            c3 = 0.885456f;
            c4 = 0.12053668f;
            c5 = -0.97094184f;
            c6 = 0.56806475f;
            c7 = -0.9350162f;
            c8 = 0.66312265f;
            c9 = 0.46472317f;
            c10 = -0.99270886f;
            c11 = 0.23931566f;
            c12 = 0.82298386f;
        } else if (mu == 10) {
            c1 = 0.12053668f;
            c2 = -0.97094184f;
            c3 = -0.3546049f;
            c4 = 0.885456f;
            c5 = 0.56806475f;
            c6 = -0.7485107f;
            c7 = -0.99270886f;
            c8 = -0.23931566f;
            c9 = 0.9350162f;
            c10 = 0.46472317f;
            c11 = -0.82298386f;
            c12 = -0.66312265f;
        } else if (mu == 11) {
            c1 = 0.56806475f;
            c2 = -0.3546049f;
            c3 = -0.97094184f;
            c4 = -0.7485107f;
            c5 = 0.12053668f;
            c6 = 0.885456f;
            c7 = -0.82298386f;
            c8 = -0.9350162f;
            c9 = -0.23931566f;
            c10 = 0.66312265f;
            c11 = 0.99270886f;
            c12 = 0.46472317f;
        } else {
            c1 = 0.885456f;
            c2 = 0.56806475f;
            c3 = 0.12053668f;
            c4 = -0.3546049f;
            c5 = -0.7485107f;
            c6 = -0.97094184f;
            c7 = -0.46472317f;
            c8 = -0.82298386f;
            c9 = -0.99270886f;
            c10 = -0.9350162f;
            c11 = -0.66312265f;
            c12 = -0.23931566f;
        }
        for (int i = 0; i < m; ++i) {
            float t1r = z[j1] + z[j12];
            float t1i = z[j1 + 1] + z[j12 + 1];
            float t2r = z[j2] + z[j11];
            float t2i = z[j2 + 1] + z[j11 + 1];
            float t3r = z[j3] + z[j10];
            float t3i = z[j3 + 1] + z[j10 + 1];
            float t4r = z[j4] + z[j9];
            float t4i = z[j4 + 1] + z[j9 + 1];
            float t5r = z[j5] + z[j8];
            float t5i = z[j5 + 1] + z[j8 + 1];
            float t6r = z[j6] + z[j7];
            float t6i = z[j6 + 1] + z[j7 + 1];
            float t7r = z[j1] - z[j12];
            float t7i = z[j1 + 1] - z[j12 + 1];
            float t8r = z[j2] - z[j11];
            float t8i = z[j2 + 1] - z[j11 + 1];
            float t9r = z[j3] - z[j10];
            float t9i = z[j3 + 1] - z[j10 + 1];
            float t10r = z[j4] - z[j9];
            float t10i = z[j4 + 1] - z[j9 + 1];
            float t11r = z[j5] - z[j8];
            float t11i = z[j5 + 1] - z[j8 + 1];
            float t12r = z[j6] - z[j7];
            float t12i = z[j6 + 1] - z[j7 + 1];
            float t13r = z[j0] - 0.5f * t6r;
            float t13i = z[j0 + 1] - 0.5f * t6i;
            float t14r = t1r - t6r;
            float t14i = t1i - t6i;
            float t15r = t2r - t6r;
            float t15i = t2i - t6i;
            float t16r = t3r - t6r;
            float t16i = t3i - t6i;
            float t17r = t4r - t6r;
            float t17i = t4i - t6i;
            float t18r = t5r - t6r;
            float t18i = t5i - t6i;
            float y1r = t13r + c1 * t14r + c2 * t15r + c3 * t16r + c4 * t17r + c5 * t18r;
            float y1i = t13i + c1 * t14i + c2 * t15i + c3 * t16i + c4 * t17i + c5 * t18i;
            float y2r = t13r + c2 * t14r + c4 * t15r + c6 * t16r + c5 * t17r + c3 * t18r;
            float y2i = t13i + c2 * t14i + c4 * t15i + c6 * t16i + c5 * t17i + c3 * t18i;
            float y3r = t13r + c3 * t14r + c6 * t15r + c4 * t16r + c1 * t17r + c2 * t18r;
            float y3i = t13i + c3 * t14i + c6 * t15i + c4 * t16i + c1 * t17i + c2 * t18i;
            float y4r = t13r + c4 * t14r + c5 * t15r + c1 * t16r + c3 * t17r + c6 * t18r;
            float y4i = t13i + c4 * t14i + c5 * t15i + c1 * t16i + c3 * t17i + c6 * t18i;
            float y5r = t13r + c5 * t14r + c3 * t15r + c2 * t16r + c6 * t17r + c1 * t18r;
            float y5i = t13i + c5 * t14i + c3 * t15i + c2 * t16i + c6 * t17i + c1 * t18i;
            float y6r = t13r + c6 * t14r + c1 * t15r + c5 * t16r + c2 * t17r + c4 * t18r;
            float y6i = t13i + c6 * t14i + c1 * t15i + c5 * t16i + c2 * t17i + c4 * t18i;
            float y7r = c12 * t7r - c7 * t8r + c11 * t9r - c8 * t10r + c10 * t11r - c9 * t12r;
            float y7i = c12 * t7i - c7 * t8i + c11 * t9i - c8 * t10i + c10 * t11i - c9 * t12i;
            float y8r = c11 * t7r - c9 * t8r + c8 * t9r - c12 * t10r - c7 * t11r + c10 * t12r;
            float y8i = c11 * t7i - c9 * t8i + c8 * t9i - c12 * t10i - c7 * t11i + c10 * t12i;
            float y9r = c10 * t7r - c11 * t8r - c7 * t9r + c9 * t10r - c12 * t11r - c8 * t12r;
            float y9i = c10 * t7i - c11 * t8i - c7 * t9i + c9 * t10i - c12 * t11i - c8 * t12i;
            float y10r = c9 * t7r + c12 * t8r - c10 * t9r - c7 * t10r + c8 * t11r + c11 * t12r;
            float y10i = c9 * t7i + c12 * t8i - c10 * t9i - c7 * t10i + c8 * t11i + c11 * t12i;
            float y11r = c8 * t7r + c10 * t8r + c12 * t9r - c11 * t10r - c9 * t11r - c7 * t12r;
            float y11i = c8 * t7i + c10 * t8i + c12 * t9i - c11 * t10i - c9 * t11i - c7 * t12i;
            float y12r = c7 * t7r + c8 * t8r + c9 * t9r + c10 * t10r + c11 * t11r + c12 * t12r;
            float y12i = c7 * t7i + c8 * t8i + c9 * t9i + c10 * t10i + c11 * t11i + c12 * t12i;
            z[j0] = z[j0] + t1r + t2r + t3r + t4r + t5r + t6r;
            z[j0 + 1] = z[j0 + 1] + t1i + t2i + t3i + t4i + t5i + t6i;
            z[j1] = y1r - y12i;
            z[j1 + 1] = y1i + y12r;
            z[j2] = y2r - y11i;
            z[j2 + 1] = y2i + y11r;
            z[j3] = y3r - y10i;
            z[j3 + 1] = y3i + y10r;
            z[j4] = y4r - y9i;
            z[j4 + 1] = y4i + y9r;
            z[j5] = y5r - y8i;
            z[j5 + 1] = y5i + y8r;
            z[j6] = y6r - y7i;
            z[j6 + 1] = y6i + y7r;
            z[j7] = y6r + y7i;
            z[j7 + 1] = y6i - y7r;
            z[j8] = y5r + y8i;
            z[j8 + 1] = y5i - y8r;
            z[j9] = y4r + y9i;
            z[j9 + 1] = y4i - y9r;
            z[j10] = y3r + y10i;
            z[j10 + 1] = y3i - y10r;
            z[j11] = y2r + y11i;
            z[j11 + 1] = y2i - y11r;
            z[j12] = y1r + y12i;
            z[j12 + 1] = y1i - y12r;
            int jt = j12 + 2;
            j12 = j11 + 2;
            j11 = j10 + 2;
            j10 = j9 + 2;
            j9 = j8 + 2;
            j8 = j7 + 2;
            j7 = j6 + 2;
            j6 = j5 + 2;
            j5 = j4 + 2;
            j4 = j3 + 2;
            j3 = j2 + 2;
            j2 = j1 + 2;
            j1 = j0 + 2;
            j0 = jt;
        }
    }

    private static void pfa16(float[] z, int mu, int m, int j0, int j1, int j2, int j3, int j4, int j5, int j6, int j7, int j8, int j9, int j10, int j11, int j12, int j13, int j14, int j15) {
        float c4;
        float c3;
        float c2;
        float c1;
        if (mu == 1) {
            c1 = 1.0f;
            c2 = 0.9238795f;
            c3 = 0.38268343f;
            c4 = 0.70710677f;
        } else if (mu == 3) {
            c1 = -1.0f;
            c2 = 0.38268343f;
            c3 = 0.9238795f;
            c4 = -0.70710677f;
        } else if (mu == 5) {
            c1 = 1.0f;
            c2 = -0.38268343f;
            c3 = 0.9238795f;
            c4 = -0.70710677f;
        } else if (mu == 7) {
            c1 = -1.0f;
            c2 = -0.9238795f;
            c3 = 0.38268343f;
            c4 = 0.70710677f;
        } else if (mu == 9) {
            c1 = 1.0f;
            c2 = -0.9238795f;
            c3 = -0.38268343f;
            c4 = 0.70710677f;
        } else if (mu == 11) {
            c1 = -1.0f;
            c2 = -0.38268343f;
            c3 = -0.9238795f;
            c4 = -0.70710677f;
        } else if (mu == 13) {
            c1 = 1.0f;
            c2 = 0.38268343f;
            c3 = -0.9238795f;
            c4 = -0.70710677f;
        } else {
            c1 = -1.0f;
            c2 = 0.9238795f;
            c3 = -0.38268343f;
            c4 = 0.70710677f;
        }
        float c5 = c1 * c4;
        float c6 = c1 * c3;
        float c7 = c1 * c2;
        for (int i = 0; i < m; ++i) {
            float t1r = z[j0] + z[j8];
            float t1i = z[j0 + 1] + z[j8 + 1];
            float t2r = z[j4] + z[j12];
            float t2i = z[j4 + 1] + z[j12 + 1];
            float t3r = z[j0] - z[j8];
            float t3i = z[j0 + 1] - z[j8 + 1];
            float t4r = c1 * (z[j4] - z[j12]);
            float t4i = c1 * (z[j4 + 1] - z[j12 + 1]);
            float t5r = t1r + t2r;
            float t5i = t1i + t2i;
            float t6r = t1r - t2r;
            float t6i = t1i - t2i;
            float t7r = z[j1] + z[j9];
            float t7i = z[j1 + 1] + z[j9 + 1];
            float t8r = z[j5] + z[j13];
            float t8i = z[j5 + 1] + z[j13 + 1];
            float t9r = z[j1] - z[j9];
            float t9i = z[j1 + 1] - z[j9 + 1];
            float t10r = z[j5] - z[j13];
            float t10i = z[j5 + 1] - z[j13 + 1];
            float t11r = t7r + t8r;
            float t11i = t7i + t8i;
            float t12r = t7r - t8r;
            float t12i = t7i - t8i;
            float t13r = z[j2] + z[j10];
            float t13i = z[j2 + 1] + z[j10 + 1];
            float t14r = z[j6] + z[j14];
            float t14i = z[j6 + 1] + z[j14 + 1];
            float t15r = z[j2] - z[j10];
            float t15i = z[j2 + 1] - z[j10 + 1];
            float t16r = z[j6] - z[j14];
            float t16i = z[j6 + 1] - z[j14 + 1];
            float t17r = t13r + t14r;
            float t17i = t13i + t14i;
            float t18r = c4 * (t15r - t16r);
            float t18i = c4 * (t15i - t16i);
            float t19r = c5 * (t15r + t16r);
            float t19i = c5 * (t15i + t16i);
            float t20r = c1 * (t13r - t14r);
            float t20i = c1 * (t13i - t14i);
            float t21r = z[j3] + z[j11];
            float t21i = z[j3 + 1] + z[j11 + 1];
            float t22r = z[j7] + z[j15];
            float t22i = z[j7 + 1] + z[j15 + 1];
            float t23r = z[j3] - z[j11];
            float t23i = z[j3 + 1] - z[j11 + 1];
            float t24r = z[j7] - z[j15];
            float t24i = z[j7 + 1] - z[j15 + 1];
            float t25r = t21r + t22r;
            float t25i = t21i + t22i;
            float t26r = t21r - t22r;
            float t26i = t21i - t22i;
            float t27r = t9r + t24r;
            float t27i = t9i + t24i;
            float t28r = t10r + t23r;
            float t28i = t10i + t23i;
            float t29r = t9r - t24r;
            float t29i = t9i - t24i;
            float t30r = t10r - t23r;
            float t30i = t10i - t23i;
            float t31r = t5r + t17r;
            float t31i = t5i + t17i;
            float t32r = t11r + t25r;
            float t32i = t11i + t25i;
            float t33r = t3r + t18r;
            float t33i = t3i + t18i;
            float t34r = c2 * t29r - c6 * t30r;
            float t34i = c2 * t29i - c6 * t30i;
            float t35r = t3r - t18r;
            float t35i = t3i - t18i;
            float t36r = c7 * t27r - c3 * t28r;
            float t36i = c7 * t27i - c3 * t28i;
            float t37r = t4r + t19r;
            float t37i = t4i + t19i;
            float t38r = c3 * t27r + c7 * t28r;
            float t38i = c3 * t27i + c7 * t28i;
            float t39r = t4r - t19r;
            float t39i = t4i - t19i;
            float t40r = c6 * t29r + c2 * t30r;
            float t40i = c6 * t29i + c2 * t30i;
            float t41r = c4 * (t12r - t26r);
            float t41i = c4 * (t12i - t26i);
            float t42r = c5 * (t12r + t26r);
            float t42i = c5 * (t12i + t26i);
            float y1r = t33r + t34r;
            float y1i = t33i + t34i;
            float y2r = t6r + t41r;
            float y2i = t6i + t41i;
            float y3r = t35r + t40r;
            float y3i = t35i + t40i;
            float y4r = t5r - t17r;
            float y4i = t5i - t17i;
            float y5r = t35r - t40r;
            float y5i = t35i - t40i;
            float y6r = t6r - t41r;
            float y6i = t6i - t41i;
            float y7r = t33r - t34r;
            float y7i = t33i - t34i;
            float y9r = t38r - t37r;
            float y9i = t38i - t37i;
            float y10r = t42r - t20r;
            float y10i = t42i - t20i;
            float y11r = t36r + t39r;
            float y11i = t36i + t39i;
            float y12r = c1 * (t11r - t25r);
            float y12i = c1 * (t11i - t25i);
            float y13r = t36r - t39r;
            float y13i = t36i - t39i;
            float y14r = t42r + t20r;
            float y14i = t42i + t20i;
            float y15r = t38r + t37r;
            float y15i = t38i + t37i;
            z[j0] = t31r + t32r;
            z[j0 + 1] = t31i + t32i;
            z[j1] = y1r - y15i;
            z[j1 + 1] = y1i + y15r;
            z[j2] = y2r - y14i;
            z[j2 + 1] = y2i + y14r;
            z[j3] = y3r - y13i;
            z[j3 + 1] = y3i + y13r;
            z[j4] = y4r - y12i;
            z[j4 + 1] = y4i + y12r;
            z[j5] = y5r - y11i;
            z[j5 + 1] = y5i + y11r;
            z[j6] = y6r - y10i;
            z[j6 + 1] = y6i + y10r;
            z[j7] = y7r - y9i;
            z[j7 + 1] = y7i + y9r;
            z[j8] = t31r - t32r;
            z[j8 + 1] = t31i - t32i;
            z[j9] = y7r + y9i;
            z[j9 + 1] = y7i - y9r;
            z[j10] = y6r + y10i;
            z[j10 + 1] = y6i - y10r;
            z[j11] = y5r + y11i;
            z[j11 + 1] = y5i - y11r;
            z[j12] = y4r + y12i;
            z[j12 + 1] = y4i - y12r;
            z[j13] = y3r + y13i;
            z[j13 + 1] = y3i - y13r;
            z[j14] = y2r + y14i;
            z[j14 + 1] = y2i - y14r;
            z[j15] = y1r + y15i;
            z[j15 + 1] = y1i - y15r;
            int jt = j15 + 2;
            j15 = j14 + 2;
            j14 = j13 + 2;
            j13 = j12 + 2;
            j12 = j11 + 2;
            j11 = j10 + 2;
            j10 = j9 + 2;
            j9 = j8 + 2;
            j8 = j7 + 2;
            j7 = j6 + 2;
            j6 = j5 + 2;
            j5 = j4 + 2;
            j4 = j3 + 2;
            j3 = j2 + 2;
            j2 = j1 + 2;
            j1 = j0 + 2;
            j0 = jt;
        }
    }

    static void transform2a(int sign, int n1, int nfft, float[][] z) {
        int nleft = nfft;
        for (int jfac = 0; jfac < 10; ++jfac) {
            int ifac = _kfac[jfac];
            int ndiv = nleft / ifac;
            if (ndiv * ifac != nleft) continue;
            nleft = ndiv;
            int m = nfft / ifac;
            int mu = 0;
            int mm = 0;
            for (int kfac = 1; kfac <= ifac && mm % ifac != 1; ++kfac) {
                mu = kfac;
                mm = kfac * m;
            }
            if (sign < 0) {
                mu = ifac - mu;
            }
            int jinc = mm;
            int jmax = nfft;
            int j0 = 0;
            int j1 = j0 + jinc;
            if (ifac == 2) {
                Pfacc.pfa2a(n1, z, mu, m, j0, j1);
                continue;
            }
            int j2 = (j1 + jinc) % jmax;
            if (ifac == 3) {
                Pfacc.pfa3a(n1, z, mu, m, j0, j1, j2);
                continue;
            }
            int j3 = (j2 + jinc) % jmax;
            if (ifac == 4) {
                Pfacc.pfa4a(n1, z, mu, m, j0, j1, j2, j3);
                continue;
            }
            int j4 = (j3 + jinc) % jmax;
            if (ifac == 5) {
                Pfacc.pfa5a(n1, z, mu, m, j0, j1, j2, j3, j4);
                continue;
            }
            int j5 = (j4 + jinc) % jmax;
            int j6 = (j5 + jinc) % jmax;
            if (ifac == 7) {
                Pfacc.pfa7a(n1, z, mu, m, j0, j1, j2, j3, j4, j5, j6);
                continue;
            }
            int j7 = (j6 + jinc) % jmax;
            if (ifac == 8) {
                Pfacc.pfa8a(n1, z, mu, m, j0, j1, j2, j3, j4, j5, j6, j7);
                continue;
            }
            int j8 = (j7 + jinc) % jmax;
            if (ifac == 9) {
                Pfacc.pfa9a(n1, z, mu, m, j0, j1, j2, j3, j4, j5, j6, j7, j8);
                continue;
            }
            int j9 = (j8 + jinc) % jmax;
            int j10 = (j9 + jinc) % jmax;
            if (ifac == 11) {
                Pfacc.pfa11a(n1, z, mu, m, j0, j1, j2, j3, j4, j5, j6, j7, j8, j9, j10);
                continue;
            }
            int j11 = (j10 + jinc) % jmax;
            int j12 = (j11 + jinc) % jmax;
            if (ifac == 13) {
                Pfacc.pfa13a(n1, z, mu, m, j0, j1, j2, j3, j4, j5, j6, j7, j8, j9, j10, j11, j12);
                continue;
            }
            int j13 = (j12 + jinc) % jmax;
            int j14 = (j13 + jinc) % jmax;
            int j15 = (j14 + jinc) % jmax;
            if (ifac != 16) continue;
            Pfacc.pfa16a(n1, z, mu, m, j0, j1, j2, j3, j4, j5, j6, j7, j8, j9, j10, j11, j12, j13, j14, j15);
        }
    }

    private static void pfa2a(int n1, float[][] z, int mu, int m, int j0, int j1) {
        int m1 = 2 * n1;
        for (int i = 0; i < m; ++i) {
            float[] zj0 = z[j0];
            float[] zj1 = z[j1];
            for (int i1 = 0; i1 < m1; i1 += 2) {
                float t1r = zj0[i1] - zj1[i1];
                float t1i = zj0[i1 + 1] - zj1[i1 + 1];
                zj0[i1] = zj0[i1] + zj1[i1];
                zj0[i1 + 1] = zj0[i1 + 1] + zj1[i1 + 1];
                zj1[i1] = t1r;
                zj1[i1 + 1] = t1i;
            }
            int jt = j1 + 1;
            j1 = j0 + 1;
            j0 = jt;
        }
    }

    private static void pfa3a(int n1, float[][] z, int mu, int m, int j0, int j1, int j2) {
        int m1 = 2 * n1;
        float c1 = mu == 1 ? 0.8660254f : -0.8660254f;
        for (int i = 0; i < m; ++i) {
            float[] zj0 = z[j0];
            float[] zj1 = z[j1];
            float[] zj2 = z[j2];
            for (int i1 = 0; i1 < m1; i1 += 2) {
                float t1r = zj1[i1] + zj2[i1];
                float t1i = zj1[i1 + 1] + zj2[i1 + 1];
                float y1r = zj0[i1] - 0.5f * t1r;
                float y1i = zj0[i1 + 1] - 0.5f * t1i;
                float y2r = c1 * (zj1[i1] - zj2[i1]);
                float y2i = c1 * (zj1[i1 + 1] - zj2[i1 + 1]);
                zj0[i1] = zj0[i1] + t1r;
                zj0[i1 + 1] = zj0[i1 + 1] + t1i;
                zj1[i1] = y1r - y2i;
                zj1[i1 + 1] = y1i + y2r;
                zj2[i1] = y1r + y2i;
                zj2[i1 + 1] = y1i - y2r;
            }
            int jt = j2 + 1;
            j2 = j1 + 1;
            j1 = j0 + 1;
            j0 = jt;
        }
    }

    private static void pfa4a(int n1, float[][] z, int mu, int m, int j0, int j1, int j2, int j3) {
        int m1 = 2 * n1;
        float c1 = mu == 1 ? 1.0f : -1.0f;
        for (int i = 0; i < m; ++i) {
            float[] zj0 = z[j0];
            float[] zj1 = z[j1];
            float[] zj2 = z[j2];
            float[] zj3 = z[j3];
            for (int i1 = 0; i1 < m1; i1 += 2) {
                float t1r = zj0[i1] + zj2[i1];
                float t1i = zj0[i1 + 1] + zj2[i1 + 1];
                float t2r = zj1[i1] + zj3[i1];
                float t2i = zj1[i1 + 1] + zj3[i1 + 1];
                float y1r = zj0[i1] - zj2[i1];
                float y1i = zj0[i1 + 1] - zj2[i1 + 1];
                float y3r = c1 * (zj1[i1] - zj3[i1]);
                float y3i = c1 * (zj1[i1 + 1] - zj3[i1 + 1]);
                zj0[i1] = t1r + t2r;
                zj0[i1 + 1] = t1i + t2i;
                zj1[i1] = y1r - y3i;
                zj1[i1 + 1] = y1i + y3r;
                zj2[i1] = t1r - t2r;
                zj2[i1 + 1] = t1i - t2i;
                zj3[i1] = y1r + y3i;
                zj3[i1 + 1] = y1i - y3r;
            }
            int jt = j3 + 1;
            j3 = j2 + 1;
            j2 = j1 + 1;
            j1 = j0 + 1;
            j0 = jt;
        }
    }

    private static void pfa5a(int n1, float[][] z, int mu, int m, int j0, int j1, int j2, int j3, int j4) {
        float c3;
        float c2;
        float c1;
        int m1 = 2 * n1;
        if (mu == 1) {
            c1 = 0.559017f;
            c2 = 0.95105654f;
            c3 = 0.58778524f;
        } else if (mu == 2) {
            c1 = -0.559017f;
            c2 = 0.58778524f;
            c3 = -0.95105654f;
        } else if (mu == 3) {
            c1 = -0.559017f;
            c2 = -0.58778524f;
            c3 = 0.95105654f;
        } else {
            c1 = 0.559017f;
            c2 = -0.95105654f;
            c3 = -0.58778524f;
        }
        for (int i = 0; i < m; ++i) {
            float[] zj0 = z[j0];
            float[] zj1 = z[j1];
            float[] zj2 = z[j2];
            float[] zj3 = z[j3];
            float[] zj4 = z[j4];
            for (int i1 = 0; i1 < m1; i1 += 2) {
                float t1r = zj1[i1] + zj4[i1];
                float t1i = zj1[i1 + 1] + zj4[i1 + 1];
                float t2r = zj2[i1] + zj3[i1];
                float t2i = zj2[i1 + 1] + zj3[i1 + 1];
                float t3r = zj1[i1] - zj4[i1];
                float t3i = zj1[i1 + 1] - zj4[i1 + 1];
                float t4r = zj2[i1] - zj3[i1];
                float t4i = zj2[i1 + 1] - zj3[i1 + 1];
                float t5r = t1r + t2r;
                float t5i = t1i + t2i;
                float t6r = c1 * (t1r - t2r);
                float t6i = c1 * (t1i - t2i);
                float t7r = zj0[i1] - 0.25f * t5r;
                float t7i = zj0[i1 + 1] - 0.25f * t5i;
                float y1r = t7r + t6r;
                float y1i = t7i + t6i;
                float y2r = t7r - t6r;
                float y2i = t7i - t6i;
                float y3r = c3 * t3r - c2 * t4r;
                float y3i = c3 * t3i - c2 * t4i;
                float y4r = c2 * t3r + c3 * t4r;
                float y4i = c2 * t3i + c3 * t4i;
                zj0[i1] = zj0[i1] + t5r;
                zj0[i1 + 1] = zj0[i1 + 1] + t5i;
                zj1[i1] = y1r - y4i;
                zj1[i1 + 1] = y1i + y4r;
                zj2[i1] = y2r - y3i;
                zj2[i1 + 1] = y2i + y3r;
                zj3[i1] = y2r + y3i;
                zj3[i1 + 1] = y2i - y3r;
                zj4[i1] = y1r + y4i;
                zj4[i1 + 1] = y1i - y4r;
            }
            int jt = j4 + 1;
            j4 = j3 + 1;
            j3 = j2 + 1;
            j2 = j1 + 1;
            j1 = j0 + 1;
            j0 = jt;
        }
    }

    private static void pfa7a(int n1, float[][] z, int mu, int m, int j0, int j1, int j2, int j3, int j4, int j5, int j6) {
        float c6;
        float c5;
        float c4;
        float c3;
        float c2;
        float c1;
        int m1 = 2 * n1;
        if (mu == 1) {
            c1 = 0.6234898f;
            c2 = -0.22252093f;
            c3 = -0.90096885f;
            c4 = 0.7818315f;
            c5 = 0.9749279f;
            c6 = 0.43388373f;
        } else if (mu == 2) {
            c1 = -0.22252093f;
            c2 = -0.90096885f;
            c3 = 0.6234898f;
            c4 = 0.9749279f;
            c5 = -0.43388373f;
            c6 = -0.7818315f;
        } else if (mu == 3) {
            c1 = -0.90096885f;
            c2 = 0.6234898f;
            c3 = -0.22252093f;
            c4 = 0.43388373f;
            c5 = -0.7818315f;
            c6 = 0.9749279f;
        } else if (mu == 4) {
            c1 = -0.90096885f;
            c2 = 0.6234898f;
            c3 = -0.22252093f;
            c4 = -0.43388373f;
            c5 = 0.7818315f;
            c6 = -0.9749279f;
        } else if (mu == 5) {
            c1 = -0.22252093f;
            c2 = -0.90096885f;
            c3 = 0.6234898f;
            c4 = -0.9749279f;
            c5 = 0.43388373f;
            c6 = 0.7818315f;
        } else {
            c1 = 0.6234898f;
            c2 = -0.22252093f;
            c3 = -0.90096885f;
            c4 = -0.7818315f;
            c5 = -0.9749279f;
            c6 = -0.43388373f;
        }
        for (int i = 0; i < m; ++i) {
            float[] zj0 = z[j0];
            float[] zj1 = z[j1];
            float[] zj2 = z[j2];
            float[] zj3 = z[j3];
            float[] zj4 = z[j4];
            float[] zj5 = z[j5];
            float[] zj6 = z[j6];
            for (int i1 = 0; i1 < m1; i1 += 2) {
                float t1r = zj1[i1] + zj6[i1];
                float t1i = zj1[i1 + 1] + zj6[i1 + 1];
                float t2r = zj2[i1] + zj5[i1];
                float t2i = zj2[i1 + 1] + zj5[i1 + 1];
                float t3r = zj3[i1] + zj4[i1];
                float t3i = zj3[i1 + 1] + zj4[i1 + 1];
                float t4r = zj1[i1] - zj6[i1];
                float t4i = zj1[i1 + 1] - zj6[i1 + 1];
                float t5r = zj2[i1] - zj5[i1];
                float t5i = zj2[i1 + 1] - zj5[i1 + 1];
                float t6r = zj3[i1] - zj4[i1];
                float t6i = zj3[i1 + 1] - zj4[i1 + 1];
                float t7r = zj0[i1] - 0.5f * t3r;
                float t7i = zj0[i1 + 1] - 0.5f * t3i;
                float t8r = t1r - t3r;
                float t8i = t1i - t3i;
                float t9r = t2r - t3r;
                float t9i = t2i - t3i;
                float y1r = t7r + c1 * t8r + c2 * t9r;
                float y1i = t7i + c1 * t8i + c2 * t9i;
                float y2r = t7r + c2 * t8r + c3 * t9r;
                float y2i = t7i + c2 * t8i + c3 * t9i;
                float y3r = t7r + c3 * t8r + c1 * t9r;
                float y3i = t7i + c3 * t8i + c1 * t9i;
                float y4r = c6 * t4r - c4 * t5r + c5 * t6r;
                float y4i = c6 * t4i - c4 * t5i + c5 * t6i;
                float y5r = c5 * t4r - c6 * t5r - c4 * t6r;
                float y5i = c5 * t4i - c6 * t5i - c4 * t6i;
                float y6r = c4 * t4r + c5 * t5r + c6 * t6r;
                float y6i = c4 * t4i + c5 * t5i + c6 * t6i;
                zj0[i1] = zj0[i1] + t1r + t2r + t3r;
                zj0[i1 + 1] = zj0[i1 + 1] + t1i + t2i + t3i;
                zj1[i1] = y1r - y6i;
                zj1[i1 + 1] = y1i + y6r;
                zj2[i1] = y2r - y5i;
                zj2[i1 + 1] = y2i + y5r;
                zj3[i1] = y3r - y4i;
                zj3[i1 + 1] = y3i + y4r;
                zj4[i1] = y3r + y4i;
                zj4[i1 + 1] = y3i - y4r;
                zj5[i1] = y2r + y5i;
                zj5[i1 + 1] = y2i - y5r;
                zj6[i1] = y1r + y6i;
                zj6[i1 + 1] = y1i - y6r;
            }
            int jt = j6 + 1;
            j6 = j5 + 1;
            j5 = j4 + 1;
            j4 = j3 + 1;
            j3 = j2 + 1;
            j2 = j1 + 1;
            j1 = j0 + 1;
            j0 = jt;
        }
    }

    private static void pfa8a(int n1, float[][] z, int mu, int m, int j0, int j1, int j2, int j3, int j4, int j5, int j6, int j7) {
        float c2;
        float c1;
        int m1 = 2 * n1;
        if (mu == 1) {
            c1 = 1.0f;
            c2 = 0.70710677f;
        } else if (mu == 3) {
            c1 = -1.0f;
            c2 = -0.70710677f;
        } else if (mu == 5) {
            c1 = 1.0f;
            c2 = -0.70710677f;
        } else {
            c1 = -1.0f;
            c2 = 0.70710677f;
        }
        float c3 = c1 * c2;
        for (int i = 0; i < m; ++i) {
            float[] zj0 = z[j0];
            float[] zj1 = z[j1];
            float[] zj2 = z[j2];
            float[] zj3 = z[j3];
            float[] zj4 = z[j4];
            float[] zj5 = z[j5];
            float[] zj6 = z[j6];
            float[] zj7 = z[j7];
            for (int i1 = 0; i1 < m1; i1 += 2) {
                float t1r = zj0[i1] + zj4[i1];
                float t1i = zj0[i1 + 1] + zj4[i1 + 1];
                float t2r = zj0[i1] - zj4[i1];
                float t2i = zj0[i1 + 1] - zj4[i1 + 1];
                float t3r = zj1[i1] + zj5[i1];
                float t3i = zj1[i1 + 1] + zj5[i1 + 1];
                float t4r = zj1[i1] - zj5[i1];
                float t4i = zj1[i1 + 1] - zj5[i1 + 1];
                float t5r = zj2[i1] + zj6[i1];
                float t5i = zj2[i1 + 1] + zj6[i1 + 1];
                float t6r = c1 * (zj2[i1] - zj6[i1]);
                float t6i = c1 * (zj2[i1 + 1] - zj6[i1 + 1]);
                float t7r = zj3[i1] + zj7[i1];
                float t7i = zj3[i1 + 1] + zj7[i1 + 1];
                float t8r = zj3[i1] - zj7[i1];
                float t8i = zj3[i1 + 1] - zj7[i1 + 1];
                float t9r = t1r + t5r;
                float t9i = t1i + t5i;
                float t10r = t3r + t7r;
                float t10i = t3i + t7i;
                float t11r = c2 * (t4r - t8r);
                float t11i = c2 * (t4i - t8i);
                float t12r = c3 * (t4r + t8r);
                float t12i = c3 * (t4i + t8i);
                float y1r = t2r + t11r;
                float y1i = t2i + t11i;
                float y2r = t1r - t5r;
                float y2i = t1i - t5i;
                float y3r = t2r - t11r;
                float y3i = t2i - t11i;
                float y5r = t12r - t6r;
                float y5i = t12i - t6i;
                float y6r = c1 * (t3r - t7r);
                float y6i = c1 * (t3i - t7i);
                float y7r = t12r + t6r;
                float y7i = t12i + t6i;
                zj0[i1] = t9r + t10r;
                zj0[i1 + 1] = t9i + t10i;
                zj1[i1] = y1r - y7i;
                zj1[i1 + 1] = y1i + y7r;
                zj2[i1] = y2r - y6i;
                zj2[i1 + 1] = y2i + y6r;
                zj3[i1] = y3r - y5i;
                zj3[i1 + 1] = y3i + y5r;
                zj4[i1] = t9r - t10r;
                zj4[i1 + 1] = t9i - t10i;
                zj5[i1] = y3r + y5i;
                zj5[i1 + 1] = y3i - y5r;
                zj6[i1] = y2r + y6i;
                zj6[i1 + 1] = y2i - y6r;
                zj7[i1] = y1r + y7i;
                zj7[i1 + 1] = y1i - y7r;
            }
            int jt = j7 + 1;
            j7 = j6 + 1;
            j6 = j5 + 1;
            j5 = j4 + 1;
            j4 = j3 + 1;
            j3 = j2 + 1;
            j2 = j1 + 1;
            j1 = j0 + 1;
            j0 = jt;
        }
    }

    private static void pfa9a(int n1, float[][] z, int mu, int m, int j0, int j1, int j2, int j3, int j4, int j5, int j6, int j7, int j8) {
        float c5;
        float c4;
        float c3;
        float c2;
        float c1;
        int m1 = 2 * n1;
        if (mu == 1) {
            c1 = 0.8660254f;
            c2 = 0.76604444f;
            c3 = 0.64278764f;
            c4 = 0.17364818f;
            c5 = 0.9848077f;
        } else if (mu == 2) {
            c1 = -0.8660254f;
            c2 = 0.17364818f;
            c3 = 0.9848077f;
            c4 = -0.9396926f;
            c5 = 0.34202015f;
        } else if (mu == 4) {
            c1 = 0.8660254f;
            c2 = -0.9396926f;
            c3 = 0.34202015f;
            c4 = 0.76604444f;
            c5 = -0.64278764f;
        } else if (mu == 5) {
            c1 = -0.8660254f;
            c2 = -0.9396926f;
            c3 = -0.34202015f;
            c4 = 0.76604444f;
            c5 = 0.64278764f;
        } else if (mu == 7) {
            c1 = 0.8660254f;
            c2 = 0.17364818f;
            c3 = -0.9848077f;
            c4 = -0.9396926f;
            c5 = -0.34202015f;
        } else {
            c1 = -0.8660254f;
            c2 = 0.76604444f;
            c3 = -0.64278764f;
            c4 = 0.17364818f;
            c5 = -0.9848077f;
        }
        float c6 = c1 * c2;
        float c7 = c1 * c3;
        float c8 = c1 * c4;
        float c9 = c1 * c5;
        for (int i = 0; i < m; ++i) {
            float[] zj0 = z[j0];
            float[] zj1 = z[j1];
            float[] zj2 = z[j2];
            float[] zj3 = z[j3];
            float[] zj4 = z[j4];
            float[] zj5 = z[j5];
            float[] zj6 = z[j6];
            float[] zj7 = z[j7];
            float[] zj8 = z[j8];
            for (int i1 = 0; i1 < m1; i1 += 2) {
                float t1r = zj3[i1] + zj6[i1];
                float t1i = zj3[i1 + 1] + zj6[i1 + 1];
                float t2r = zj0[i1] - 0.5f * t1r;
                float t2i = zj0[i1 + 1] - 0.5f * t1i;
                float t3r = c1 * (zj3[i1] - zj6[i1]);
                float t3i = c1 * (zj3[i1 + 1] - zj6[i1 + 1]);
                float t4r = zj0[i1] + t1r;
                float t4i = zj0[i1 + 1] + t1i;
                float t5r = zj4[i1] + zj7[i1];
                float t5i = zj4[i1 + 1] + zj7[i1 + 1];
                float t6r = zj1[i1] - 0.5f * t5r;
                float t6i = zj1[i1 + 1] - 0.5f * t5i;
                float t7r = zj4[i1] - zj7[i1];
                float t7i = zj4[i1 + 1] - zj7[i1 + 1];
                float t8r = zj1[i1] + t5r;
                float t8i = zj1[i1 + 1] + t5i;
                float t9r = zj2[i1] + zj5[i1];
                float t9i = zj2[i1 + 1] + zj5[i1 + 1];
                float t10r = zj8[i1] - 0.5f * t9r;
                float t10i = zj8[i1 + 1] - 0.5f * t9i;
                float t11r = zj2[i1] - zj5[i1];
                float t11i = zj2[i1 + 1] - zj5[i1 + 1];
                float t12r = zj8[i1] + t9r;
                float t12i = zj8[i1 + 1] + t9i;
                float t13r = t8r + t12r;
                float t13i = t8i + t12i;
                float t14r = t6r + t10r;
                float t14i = t6i + t10i;
                float t15r = t6r - t10r;
                float t15i = t6i - t10i;
                float t16r = t7r + t11r;
                float t16i = t7i + t11i;
                float t17r = t7r - t11r;
                float t17i = t7i - t11i;
                float t18r = c2 * t14r - c7 * t17r;
                float t18i = c2 * t14i - c7 * t17i;
                float t19r = c4 * t14r + c9 * t17r;
                float t19i = c4 * t14i + c9 * t17i;
                float t20r = c3 * t15r + c6 * t16r;
                float t20i = c3 * t15i + c6 * t16i;
                float t21r = c5 * t15r - c8 * t16r;
                float t21i = c5 * t15i - c8 * t16i;
                float t22r = t18r + t19r;
                float t22i = t18i + t19i;
                float t23r = t20r - t21r;
                float t23i = t20i - t21i;
                float y1r = t2r + t18r;
                float y1i = t2i + t18i;
                float y2r = t2r + t19r;
                float y2i = t2i + t19i;
                float y3r = t4r - 0.5f * t13r;
                float y3i = t4i - 0.5f * t13i;
                float y4r = t2r - t22r;
                float y4i = t2i - t22i;
                float y5r = t3r - t23r;
                float y5i = t3i - t23i;
                float y6r = c1 * (t8r - t12r);
                float y6i = c1 * (t8i - t12i);
                float y7r = t21r - t3r;
                float y7i = t21i - t3i;
                float y8r = t3r + t20r;
                float y8i = t3i + t20i;
                zj0[i1] = t4r + t13r;
                zj0[i1 + 1] = t4i + t13i;
                zj1[i1] = y1r - y8i;
                zj1[i1 + 1] = y1i + y8r;
                zj2[i1] = y2r - y7i;
                zj2[i1 + 1] = y2i + y7r;
                zj3[i1] = y3r - y6i;
                zj3[i1 + 1] = y3i + y6r;
                zj4[i1] = y4r - y5i;
                zj4[i1 + 1] = y4i + y5r;
                zj5[i1] = y4r + y5i;
                zj5[i1 + 1] = y4i - y5r;
                zj6[i1] = y3r + y6i;
                zj6[i1 + 1] = y3i - y6r;
                zj7[i1] = y2r + y7i;
                zj7[i1 + 1] = y2i - y7r;
                zj8[i1] = y1r + y8i;
                zj8[i1 + 1] = y1i - y8r;
            }
            int jt = j8 + 1;
            j8 = j7 + 1;
            j7 = j6 + 1;
            j6 = j5 + 1;
            j5 = j4 + 1;
            j4 = j3 + 1;
            j3 = j2 + 1;
            j2 = j1 + 1;
            j1 = j0 + 1;
            j0 = jt;
        }
    }

    private static void pfa11a(int n1, float[][] z, int mu, int m, int j0, int j1, int j2, int j3, int j4, int j5, int j6, int j7, int j8, int j9, int j10) {
        float c10;
        float c9;
        float c8;
        float c7;
        float c6;
        float c5;
        float c4;
        float c3;
        float c2;
        float c1;
        int m1 = 2 * n1;
        if (mu == 1) {
            c1 = 0.8412535f;
            c2 = 0.41541502f;
            c3 = -0.14231484f;
            c4 = -0.65486073f;
            c5 = -0.959493f;
            c6 = 0.54064083f;
            c7 = 0.90963197f;
            c8 = 0.98982143f;
            c9 = 0.7557496f;
            c10 = 0.28173256f;
        } else if (mu == 2) {
            c1 = 0.41541502f;
            c2 = -0.65486073f;
            c3 = -0.959493f;
            c4 = -0.14231484f;
            c5 = 0.8412535f;
            c6 = 0.90963197f;
            c7 = 0.7557496f;
            c8 = -0.28173256f;
            c9 = -0.98982143f;
            c10 = -0.54064083f;
        } else if (mu == 3) {
            c1 = -0.14231484f;
            c2 = -0.959493f;
            c3 = 0.41541502f;
            c4 = 0.8412535f;
            c5 = -0.65486073f;
            c6 = 0.98982143f;
            c7 = -0.28173256f;
            c8 = -0.90963197f;
            c9 = 0.54064083f;
            c10 = 0.7557496f;
        } else if (mu == 4) {
            c1 = -0.65486073f;
            c2 = -0.14231484f;
            c3 = 0.8412535f;
            c4 = -0.959493f;
            c5 = 0.41541502f;
            c6 = 0.7557496f;
            c7 = -0.98982143f;
            c8 = 0.54064083f;
            c9 = 0.28173256f;
            c10 = -0.90963197f;
        } else if (mu == 5) {
            c1 = -0.959493f;
            c2 = 0.8412535f;
            c3 = -0.65486073f;
            c4 = 0.41541502f;
            c5 = -0.14231484f;
            c6 = 0.28173256f;
            c7 = -0.54064083f;
            c8 = 0.7557496f;
            c9 = -0.90963197f;
            c10 = 0.98982143f;
        } else if (mu == 6) {
            c1 = -0.959493f;
            c2 = 0.8412535f;
            c3 = -0.65486073f;
            c4 = 0.41541502f;
            c5 = -0.14231484f;
            c6 = -0.28173256f;
            c7 = 0.54064083f;
            c8 = -0.7557496f;
            c9 = 0.90963197f;
            c10 = -0.98982143f;
        } else if (mu == 7) {
            c1 = -0.65486073f;
            c2 = -0.14231484f;
            c3 = 0.8412535f;
            c4 = -0.959493f;
            c5 = 0.41541502f;
            c6 = -0.7557496f;
            c7 = 0.98982143f;
            c8 = -0.54064083f;
            c9 = -0.28173256f;
            c10 = 0.90963197f;
        } else if (mu == 8) {
            c1 = -0.14231484f;
            c2 = -0.959493f;
            c3 = 0.41541502f;
            c4 = 0.8412535f;
            c5 = -0.65486073f;
            c6 = -0.98982143f;
            c7 = 0.28173256f;
            c8 = 0.90963197f;
            c9 = -0.54064083f;
            c10 = -0.7557496f;
        } else if (mu == 9) {
            c1 = 0.41541502f;
            c2 = -0.65486073f;
            c3 = -0.959493f;
            c4 = -0.14231484f;
            c5 = 0.8412535f;
            c6 = -0.90963197f;
            c7 = -0.7557496f;
            c8 = 0.28173256f;
            c9 = 0.98982143f;
            c10 = 0.54064083f;
        } else {
            c1 = 0.8412535f;
            c2 = 0.41541502f;
            c3 = -0.14231484f;
            c4 = -0.65486073f;
            c5 = -0.959493f;
            c6 = -0.54064083f;
            c7 = -0.90963197f;
            c8 = -0.98982143f;
            c9 = -0.7557496f;
            c10 = -0.28173256f;
        }
        for (int i = 0; i < m; ++i) {
            float[] zj0 = z[j0];
            float[] zj1 = z[j1];
            float[] zj2 = z[j2];
            float[] zj3 = z[j3];
            float[] zj4 = z[j4];
            float[] zj5 = z[j5];
            float[] zj6 = z[j6];
            float[] zj7 = z[j7];
            float[] zj8 = z[j8];
            float[] zj9 = z[j9];
            float[] zj10 = z[j10];
            for (int i1 = 0; i1 < m1; i1 += 2) {
                float t1r = zj1[i1] + zj10[i1];
                float t1i = zj1[i1 + 1] + zj10[i1 + 1];
                float t2r = zj2[i1] + zj9[i1];
                float t2i = zj2[i1 + 1] + zj9[i1 + 1];
                float t3r = zj3[i1] + zj8[i1];
                float t3i = zj3[i1 + 1] + zj8[i1 + 1];
                float t4r = zj4[i1] + zj7[i1];
                float t4i = zj4[i1 + 1] + zj7[i1 + 1];
                float t5r = zj5[i1] + zj6[i1];
                float t5i = zj5[i1 + 1] + zj6[i1 + 1];
                float t6r = zj1[i1] - zj10[i1];
                float t6i = zj1[i1 + 1] - zj10[i1 + 1];
                float t7r = zj2[i1] - zj9[i1];
                float t7i = zj2[i1 + 1] - zj9[i1 + 1];
                float t8r = zj3[i1] - zj8[i1];
                float t8i = zj3[i1 + 1] - zj8[i1 + 1];
                float t9r = zj4[i1] - zj7[i1];
                float t9i = zj4[i1 + 1] - zj7[i1 + 1];
                float t10r = zj5[i1] - zj6[i1];
                float t10i = zj5[i1 + 1] - zj6[i1 + 1];
                float t11r = zj0[i1] - 0.5f * t5r;
                float t11i = zj0[i1 + 1] - 0.5f * t5i;
                float t12r = t1r - t5r;
                float t12i = t1i - t5i;
                float t13r = t2r - t5r;
                float t13i = t2i - t5i;
                float t14r = t3r - t5r;
                float t14i = t3i - t5i;
                float t15r = t4r - t5r;
                float t15i = t4i - t5i;
                float y1r = t11r + c1 * t12r + c2 * t13r + c3 * t14r + c4 * t15r;
                float y1i = t11i + c1 * t12i + c2 * t13i + c3 * t14i + c4 * t15i;
                float y2r = t11r + c2 * t12r + c4 * t13r + c5 * t14r + c3 * t15r;
                float y2i = t11i + c2 * t12i + c4 * t13i + c5 * t14i + c3 * t15i;
                float y3r = t11r + c3 * t12r + c5 * t13r + c2 * t14r + c1 * t15r;
                float y3i = t11i + c3 * t12i + c5 * t13i + c2 * t14i + c1 * t15i;
                float y4r = t11r + c4 * t12r + c3 * t13r + c1 * t14r + c5 * t15r;
                float y4i = t11i + c4 * t12i + c3 * t13i + c1 * t14i + c5 * t15i;
                float y5r = t11r + c5 * t12r + c1 * t13r + c4 * t14r + c2 * t15r;
                float y5i = t11i + c5 * t12i + c1 * t13i + c4 * t14i + c2 * t15i;
                float y6r = c10 * t6r - c6 * t7r + c9 * t8r - c7 * t9r + c8 * t10r;
                float y6i = c10 * t6i - c6 * t7i + c9 * t8i - c7 * t9i + c8 * t10i;
                float y7r = c9 * t6r - c8 * t7r + c6 * t8r + c10 * t9r - c7 * t10r;
                float y7i = c9 * t6i - c8 * t7i + c6 * t8i + c10 * t9i - c7 * t10i;
                float y8r = c8 * t6r - c10 * t7r - c7 * t8r + c6 * t9r + c9 * t10r;
                float y8i = c8 * t6i - c10 * t7i - c7 * t8i + c6 * t9i + c9 * t10i;
                float y9r = c7 * t6r + c9 * t7r - c10 * t8r - c8 * t9r - c6 * t10r;
                float y9i = c7 * t6i + c9 * t7i - c10 * t8i - c8 * t9i - c6 * t10i;
                float y10r = c6 * t6r + c7 * t7r + c8 * t8r + c9 * t9r + c10 * t10r;
                float y10i = c6 * t6i + c7 * t7i + c8 * t8i + c9 * t9i + c10 * t10i;
                zj0[i1] = zj0[i1] + t1r + t2r + t3r + t4r + t5r;
                zj0[i1 + 1] = zj0[i1 + 1] + t1i + t2i + t3i + t4i + t5i;
                zj1[i1] = y1r - y10i;
                zj1[i1 + 1] = y1i + y10r;
                zj2[i1] = y2r - y9i;
                zj2[i1 + 1] = y2i + y9r;
                zj3[i1] = y3r - y8i;
                zj3[i1 + 1] = y3i + y8r;
                zj4[i1] = y4r - y7i;
                zj4[i1 + 1] = y4i + y7r;
                zj5[i1] = y5r - y6i;
                zj5[i1 + 1] = y5i + y6r;
                zj6[i1] = y5r + y6i;
                zj6[i1 + 1] = y5i - y6r;
                zj7[i1] = y4r + y7i;
                zj7[i1 + 1] = y4i - y7r;
                zj8[i1] = y3r + y8i;
                zj8[i1 + 1] = y3i - y8r;
                zj9[i1] = y2r + y9i;
                zj9[i1 + 1] = y2i - y9r;
                zj10[i1] = y1r + y10i;
                zj10[i1 + 1] = y1i - y10r;
            }
            int jt = j10 + 1;
            j10 = j9 + 1;
            j9 = j8 + 1;
            j8 = j7 + 1;
            j7 = j6 + 1;
            j6 = j5 + 1;
            j5 = j4 + 1;
            j4 = j3 + 1;
            j3 = j2 + 1;
            j2 = j1 + 1;
            j1 = j0 + 1;
            j0 = jt;
        }
    }

    private static void pfa13a(int n1, float[][] z, int mu, int m, int j0, int j1, int j2, int j3, int j4, int j5, int j6, int j7, int j8, int j9, int j10, int j11, int j12) {
        float c12;
        float c11;
        float c10;
        float c9;
        float c8;
        float c7;
        float c6;
        float c5;
        float c4;
        float c3;
        float c2;
        float c1;
        int m1 = 2 * n1;
        if (mu == 1) {
            c1 = 0.885456f;
            c2 = 0.56806475f;
            c3 = 0.12053668f;
            c4 = -0.3546049f;
            c5 = -0.7485107f;
            c6 = -0.97094184f;
            c7 = 0.46472317f;
            c8 = 0.82298386f;
            c9 = 0.99270886f;
            c10 = 0.9350162f;
            c11 = 0.66312265f;
            c12 = 0.23931566f;
        } else if (mu == 2) {
            c1 = 0.56806475f;
            c2 = -0.3546049f;
            c3 = -0.97094184f;
            c4 = -0.7485107f;
            c5 = 0.12053668f;
            c6 = 0.885456f;
            c7 = 0.82298386f;
            c8 = 0.9350162f;
            c9 = 0.23931566f;
            c10 = -0.66312265f;
            c11 = -0.99270886f;
            c12 = -0.46472317f;
        } else if (mu == 3) {
            c1 = 0.12053668f;
            c2 = -0.97094184f;
            c3 = -0.3546049f;
            c4 = 0.885456f;
            c5 = 0.56806475f;
            c6 = -0.7485107f;
            c7 = 0.99270886f;
            c8 = 0.23931566f;
            c9 = -0.9350162f;
            c10 = -0.46472317f;
            c11 = 0.82298386f;
            c12 = 0.66312265f;
        } else if (mu == 4) {
            c1 = -0.3546049f;
            c2 = -0.7485107f;
            c3 = 0.885456f;
            c4 = 0.12053668f;
            c5 = -0.97094184f;
            c6 = 0.56806475f;
            c7 = 0.9350162f;
            c8 = -0.66312265f;
            c9 = -0.46472317f;
            c10 = 0.99270886f;
            c11 = -0.23931566f;
            c12 = -0.82298386f;
        } else if (mu == 5) {
            c1 = -0.7485107f;
            c2 = 0.12053668f;
            c3 = 0.56806475f;
            c4 = -0.97094184f;
            c5 = 0.885456f;
            c6 = -0.3546049f;
            c7 = 0.66312265f;
            c8 = -0.99270886f;
            c9 = 0.82298386f;
            c10 = -0.23931566f;
            c11 = -0.46472317f;
            c12 = 0.9350162f;
        } else if (mu == 6) {
            c1 = -0.97094184f;
            c2 = 0.885456f;
            c3 = -0.7485107f;
            c4 = 0.56806475f;
            c5 = -0.3546049f;
            c6 = 0.12053668f;
            c7 = 0.23931566f;
            c8 = -0.46472317f;
            c9 = 0.66312265f;
            c10 = -0.82298386f;
            c11 = 0.9350162f;
            c12 = -0.99270886f;
        } else if (mu == 7) {
            c1 = -0.97094184f;
            c2 = 0.885456f;
            c3 = -0.7485107f;
            c4 = 0.56806475f;
            c5 = -0.3546049f;
            c6 = 0.12053668f;
            c7 = -0.23931566f;
            c8 = 0.46472317f;
            c9 = -0.66312265f;
            c10 = 0.82298386f;
            c11 = -0.9350162f;
            c12 = 0.99270886f;
        } else if (mu == 8) {
            c1 = -0.7485107f;
            c2 = 0.12053668f;
            c3 = 0.56806475f;
            c4 = -0.97094184f;
            c5 = 0.885456f;
            c6 = -0.3546049f;
            c7 = -0.66312265f;
            c8 = 0.99270886f;
            c9 = -0.82298386f;
            c10 = 0.23931566f;
            c11 = 0.46472317f;
            c12 = -0.9350162f;
        } else if (mu == 9) {
            c1 = -0.3546049f;
            c2 = -0.7485107f;
            c3 = 0.885456f;
            c4 = 0.12053668f;
            c5 = -0.97094184f;
            c6 = 0.56806475f;
            c7 = -0.9350162f;
            c8 = 0.66312265f;
            c9 = 0.46472317f;
            c10 = -0.99270886f;
            c11 = 0.23931566f;
            c12 = 0.82298386f;
        } else if (mu == 10) {
            c1 = 0.12053668f;
            c2 = -0.97094184f;
            c3 = -0.3546049f;
            c4 = 0.885456f;
            c5 = 0.56806475f;
            c6 = -0.7485107f;
            c7 = -0.99270886f;
            c8 = -0.23931566f;
            c9 = 0.9350162f;
            c10 = 0.46472317f;
            c11 = -0.82298386f;
            c12 = -0.66312265f;
        } else if (mu == 11) {
            c1 = 0.56806475f;
            c2 = -0.3546049f;
            c3 = -0.97094184f;
            c4 = -0.7485107f;
            c5 = 0.12053668f;
            c6 = 0.885456f;
            c7 = -0.82298386f;
            c8 = -0.9350162f;
            c9 = -0.23931566f;
            c10 = 0.66312265f;
            c11 = 0.99270886f;
            c12 = 0.46472317f;
        } else {
            c1 = 0.885456f;
            c2 = 0.56806475f;
            c3 = 0.12053668f;
            c4 = -0.3546049f;
            c5 = -0.7485107f;
            c6 = -0.97094184f;
            c7 = -0.46472317f;
            c8 = -0.82298386f;
            c9 = -0.99270886f;
            c10 = -0.9350162f;
            c11 = -0.66312265f;
            c12 = -0.23931566f;
        }
        for (int i = 0; i < m; ++i) {
            float[] zj0 = z[j0];
            float[] zj1 = z[j1];
            float[] zj2 = z[j2];
            float[] zj3 = z[j3];
            float[] zj4 = z[j4];
            float[] zj5 = z[j5];
            float[] zj6 = z[j6];
            float[] zj7 = z[j7];
            float[] zj8 = z[j8];
            float[] zj9 = z[j9];
            float[] zj10 = z[j10];
            float[] zj11 = z[j11];
            float[] zj12 = z[j12];
            for (int i1 = 0; i1 < m1; i1 += 2) {
                float t1r = zj1[i1] + zj12[i1];
                float t1i = zj1[i1 + 1] + zj12[i1 + 1];
                float t2r = zj2[i1] + zj11[i1];
                float t2i = zj2[i1 + 1] + zj11[i1 + 1];
                float t3r = zj3[i1] + zj10[i1];
                float t3i = zj3[i1 + 1] + zj10[i1 + 1];
                float t4r = zj4[i1] + zj9[i1];
                float t4i = zj4[i1 + 1] + zj9[i1 + 1];
                float t5r = zj5[i1] + zj8[i1];
                float t5i = zj5[i1 + 1] + zj8[i1 + 1];
                float t6r = zj6[i1] + zj7[i1];
                float t6i = zj6[i1 + 1] + zj7[i1 + 1];
                float t7r = zj1[i1] - zj12[i1];
                float t7i = zj1[i1 + 1] - zj12[i1 + 1];
                float t8r = zj2[i1] - zj11[i1];
                float t8i = zj2[i1 + 1] - zj11[i1 + 1];
                float t9r = zj3[i1] - zj10[i1];
                float t9i = zj3[i1 + 1] - zj10[i1 + 1];
                float t10r = zj4[i1] - zj9[i1];
                float t10i = zj4[i1 + 1] - zj9[i1 + 1];
                float t11r = zj5[i1] - zj8[i1];
                float t11i = zj5[i1 + 1] - zj8[i1 + 1];
                float t12r = zj6[i1] - zj7[i1];
                float t12i = zj6[i1 + 1] - zj7[i1 + 1];
                float t13r = zj0[i1] - 0.5f * t6r;
                float t13i = zj0[i1 + 1] - 0.5f * t6i;
                float t14r = t1r - t6r;
                float t14i = t1i - t6i;
                float t15r = t2r - t6r;
                float t15i = t2i - t6i;
                float t16r = t3r - t6r;
                float t16i = t3i - t6i;
                float t17r = t4r - t6r;
                float t17i = t4i - t6i;
                float t18r = t5r - t6r;
                float t18i = t5i - t6i;
                float y1r = t13r + c1 * t14r + c2 * t15r + c3 * t16r + c4 * t17r + c5 * t18r;
                float y1i = t13i + c1 * t14i + c2 * t15i + c3 * t16i + c4 * t17i + c5 * t18i;
                float y2r = t13r + c2 * t14r + c4 * t15r + c6 * t16r + c5 * t17r + c3 * t18r;
                float y2i = t13i + c2 * t14i + c4 * t15i + c6 * t16i + c5 * t17i + c3 * t18i;
                float y3r = t13r + c3 * t14r + c6 * t15r + c4 * t16r + c1 * t17r + c2 * t18r;
                float y3i = t13i + c3 * t14i + c6 * t15i + c4 * t16i + c1 * t17i + c2 * t18i;
                float y4r = t13r + c4 * t14r + c5 * t15r + c1 * t16r + c3 * t17r + c6 * t18r;
                float y4i = t13i + c4 * t14i + c5 * t15i + c1 * t16i + c3 * t17i + c6 * t18i;
                float y5r = t13r + c5 * t14r + c3 * t15r + c2 * t16r + c6 * t17r + c1 * t18r;
                float y5i = t13i + c5 * t14i + c3 * t15i + c2 * t16i + c6 * t17i + c1 * t18i;
                float y6r = t13r + c6 * t14r + c1 * t15r + c5 * t16r + c2 * t17r + c4 * t18r;
                float y6i = t13i + c6 * t14i + c1 * t15i + c5 * t16i + c2 * t17i + c4 * t18i;
                float y7r = c12 * t7r - c7 * t8r + c11 * t9r - c8 * t10r + c10 * t11r - c9 * t12r;
                float y7i = c12 * t7i - c7 * t8i + c11 * t9i - c8 * t10i + c10 * t11i - c9 * t12i;
                float y8r = c11 * t7r - c9 * t8r + c8 * t9r - c12 * t10r - c7 * t11r + c10 * t12r;
                float y8i = c11 * t7i - c9 * t8i + c8 * t9i - c12 * t10i - c7 * t11i + c10 * t12i;
                float y9r = c10 * t7r - c11 * t8r - c7 * t9r + c9 * t10r - c12 * t11r - c8 * t12r;
                float y9i = c10 * t7i - c11 * t8i - c7 * t9i + c9 * t10i - c12 * t11i - c8 * t12i;
                float y10r = c9 * t7r + c12 * t8r - c10 * t9r - c7 * t10r + c8 * t11r + c11 * t12r;
                float y10i = c9 * t7i + c12 * t8i - c10 * t9i - c7 * t10i + c8 * t11i + c11 * t12i;
                float y11r = c8 * t7r + c10 * t8r + c12 * t9r - c11 * t10r - c9 * t11r - c7 * t12r;
                float y11i = c8 * t7i + c10 * t8i + c12 * t9i - c11 * t10i - c9 * t11i - c7 * t12i;
                float y12r = c7 * t7r + c8 * t8r + c9 * t9r + c10 * t10r + c11 * t11r + c12 * t12r;
                float y12i = c7 * t7i + c8 * t8i + c9 * t9i + c10 * t10i + c11 * t11i + c12 * t12i;
                zj0[i1] = zj0[i1] + t1r + t2r + t3r + t4r + t5r + t6r;
                zj0[i1 + 1] = zj0[i1 + 1] + t1i + t2i + t3i + t4i + t5i + t6i;
                zj1[i1] = y1r - y12i;
                zj1[i1 + 1] = y1i + y12r;
                zj2[i1] = y2r - y11i;
                zj2[i1 + 1] = y2i + y11r;
                zj3[i1] = y3r - y10i;
                zj3[i1 + 1] = y3i + y10r;
                zj4[i1] = y4r - y9i;
                zj4[i1 + 1] = y4i + y9r;
                zj5[i1] = y5r - y8i;
                zj5[i1 + 1] = y5i + y8r;
                zj6[i1] = y6r - y7i;
                zj6[i1 + 1] = y6i + y7r;
                zj7[i1] = y6r + y7i;
                zj7[i1 + 1] = y6i - y7r;
                zj8[i1] = y5r + y8i;
                zj8[i1 + 1] = y5i - y8r;
                zj9[i1] = y4r + y9i;
                zj9[i1 + 1] = y4i - y9r;
                zj10[i1] = y3r + y10i;
                zj10[i1 + 1] = y3i - y10r;
                zj11[i1] = y2r + y11i;
                zj11[i1 + 1] = y2i - y11r;
                zj12[i1] = y1r + y12i;
                zj12[i1 + 1] = y1i - y12r;
            }
            int jt = j12 + 1;
            j12 = j11 + 1;
            j11 = j10 + 1;
            j10 = j9 + 1;
            j9 = j8 + 1;
            j8 = j7 + 1;
            j7 = j6 + 1;
            j6 = j5 + 1;
            j5 = j4 + 1;
            j4 = j3 + 1;
            j3 = j2 + 1;
            j2 = j1 + 1;
            j1 = j0 + 1;
            j0 = jt;
        }
    }

    private static void pfa16a(int n1, float[][] z, int mu, int m, int j0, int j1, int j2, int j3, int j4, int j5, int j6, int j7, int j8, int j9, int j10, int j11, int j12, int j13, int j14, int j15) {
        float c4;
        float c3;
        float c2;
        float c1;
        int m1 = 2 * n1;
        if (mu == 1) {
            c1 = 1.0f;
            c2 = 0.9238795f;
            c3 = 0.38268343f;
            c4 = 0.70710677f;
        } else if (mu == 3) {
            c1 = -1.0f;
            c2 = 0.38268343f;
            c3 = 0.9238795f;
            c4 = -0.70710677f;
        } else if (mu == 5) {
            c1 = 1.0f;
            c2 = -0.38268343f;
            c3 = 0.9238795f;
            c4 = -0.70710677f;
        } else if (mu == 7) {
            c1 = -1.0f;
            c2 = -0.9238795f;
            c3 = 0.38268343f;
            c4 = 0.70710677f;
        } else if (mu == 9) {
            c1 = 1.0f;
            c2 = -0.9238795f;
            c3 = -0.38268343f;
            c4 = 0.70710677f;
        } else if (mu == 11) {
            c1 = -1.0f;
            c2 = -0.38268343f;
            c3 = -0.9238795f;
            c4 = -0.70710677f;
        } else if (mu == 13) {
            c1 = 1.0f;
            c2 = 0.38268343f;
            c3 = -0.9238795f;
            c4 = -0.70710677f;
        } else {
            c1 = -1.0f;
            c2 = 0.9238795f;
            c3 = -0.38268343f;
            c4 = 0.70710677f;
        }
        float c5 = c1 * c4;
        float c6 = c1 * c3;
        float c7 = c1 * c2;
        for (int i = 0; i < m; ++i) {
            float[] zj0 = z[j0];
            float[] zj1 = z[j1];
            float[] zj2 = z[j2];
            float[] zj3 = z[j3];
            float[] zj4 = z[j4];
            float[] zj5 = z[j5];
            float[] zj6 = z[j6];
            float[] zj7 = z[j7];
            float[] zj8 = z[j8];
            float[] zj9 = z[j9];
            float[] zj10 = z[j10];
            float[] zj11 = z[j11];
            float[] zj12 = z[j12];
            float[] zj13 = z[j13];
            float[] zj14 = z[j14];
            float[] zj15 = z[j15];
            for (int i1 = 0; i1 < m1; i1 += 2) {
                float t1r = zj0[i1] + zj8[i1];
                float t1i = zj0[i1 + 1] + zj8[i1 + 1];
                float t2r = zj4[i1] + zj12[i1];
                float t2i = zj4[i1 + 1] + zj12[i1 + 1];
                float t3r = zj0[i1] - zj8[i1];
                float t3i = zj0[i1 + 1] - zj8[i1 + 1];
                float t4r = c1 * (zj4[i1] - zj12[i1]);
                float t4i = c1 * (zj4[i1 + 1] - zj12[i1 + 1]);
                float t5r = t1r + t2r;
                float t5i = t1i + t2i;
                float t6r = t1r - t2r;
                float t6i = t1i - t2i;
                float t7r = zj1[i1] + zj9[i1];
                float t7i = zj1[i1 + 1] + zj9[i1 + 1];
                float t8r = zj5[i1] + zj13[i1];
                float t8i = zj5[i1 + 1] + zj13[i1 + 1];
                float t9r = zj1[i1] - zj9[i1];
                float t9i = zj1[i1 + 1] - zj9[i1 + 1];
                float t10r = zj5[i1] - zj13[i1];
                float t10i = zj5[i1 + 1] - zj13[i1 + 1];
                float t11r = t7r + t8r;
                float t11i = t7i + t8i;
                float t12r = t7r - t8r;
                float t12i = t7i - t8i;
                float t13r = zj2[i1] + zj10[i1];
                float t13i = zj2[i1 + 1] + zj10[i1 + 1];
                float t14r = zj6[i1] + zj14[i1];
                float t14i = zj6[i1 + 1] + zj14[i1 + 1];
                float t15r = zj2[i1] - zj10[i1];
                float t15i = zj2[i1 + 1] - zj10[i1 + 1];
                float t16r = zj6[i1] - zj14[i1];
                float t16i = zj6[i1 + 1] - zj14[i1 + 1];
                float t17r = t13r + t14r;
                float t17i = t13i + t14i;
                float t18r = c4 * (t15r - t16r);
                float t18i = c4 * (t15i - t16i);
                float t19r = c5 * (t15r + t16r);
                float t19i = c5 * (t15i + t16i);
                float t20r = c1 * (t13r - t14r);
                float t20i = c1 * (t13i - t14i);
                float t21r = zj3[i1] + zj11[i1];
                float t21i = zj3[i1 + 1] + zj11[i1 + 1];
                float t22r = zj7[i1] + zj15[i1];
                float t22i = zj7[i1 + 1] + zj15[i1 + 1];
                float t23r = zj3[i1] - zj11[i1];
                float t23i = zj3[i1 + 1] - zj11[i1 + 1];
                float t24r = zj7[i1] - zj15[i1];
                float t24i = zj7[i1 + 1] - zj15[i1 + 1];
                float t25r = t21r + t22r;
                float t25i = t21i + t22i;
                float t26r = t21r - t22r;
                float t26i = t21i - t22i;
                float t27r = t9r + t24r;
                float t27i = t9i + t24i;
                float t28r = t10r + t23r;
                float t28i = t10i + t23i;
                float t29r = t9r - t24r;
                float t29i = t9i - t24i;
                float t30r = t10r - t23r;
                float t30i = t10i - t23i;
                float t31r = t5r + t17r;
                float t31i = t5i + t17i;
                float t32r = t11r + t25r;
                float t32i = t11i + t25i;
                float t33r = t3r + t18r;
                float t33i = t3i + t18i;
                float t34r = c2 * t29r - c6 * t30r;
                float t34i = c2 * t29i - c6 * t30i;
                float t35r = t3r - t18r;
                float t35i = t3i - t18i;
                float t36r = c7 * t27r - c3 * t28r;
                float t36i = c7 * t27i - c3 * t28i;
                float t37r = t4r + t19r;
                float t37i = t4i + t19i;
                float t38r = c3 * t27r + c7 * t28r;
                float t38i = c3 * t27i + c7 * t28i;
                float t39r = t4r - t19r;
                float t39i = t4i - t19i;
                float t40r = c6 * t29r + c2 * t30r;
                float t40i = c6 * t29i + c2 * t30i;
                float t41r = c4 * (t12r - t26r);
                float t41i = c4 * (t12i - t26i);
                float t42r = c5 * (t12r + t26r);
                float t42i = c5 * (t12i + t26i);
                float y1r = t33r + t34r;
                float y1i = t33i + t34i;
                float y2r = t6r + t41r;
                float y2i = t6i + t41i;
                float y3r = t35r + t40r;
                float y3i = t35i + t40i;
                float y4r = t5r - t17r;
                float y4i = t5i - t17i;
                float y5r = t35r - t40r;
                float y5i = t35i - t40i;
                float y6r = t6r - t41r;
                float y6i = t6i - t41i;
                float y7r = t33r - t34r;
                float y7i = t33i - t34i;
                float y9r = t38r - t37r;
                float y9i = t38i - t37i;
                float y10r = t42r - t20r;
                float y10i = t42i - t20i;
                float y11r = t36r + t39r;
                float y11i = t36i + t39i;
                float y12r = c1 * (t11r - t25r);
                float y12i = c1 * (t11i - t25i);
                float y13r = t36r - t39r;
                float y13i = t36i - t39i;
                float y14r = t42r + t20r;
                float y14i = t42i + t20i;
                float y15r = t38r + t37r;
                float y15i = t38i + t37i;
                zj0[i1] = t31r + t32r;
                zj0[i1 + 1] = t31i + t32i;
                zj1[i1] = y1r - y15i;
                zj1[i1 + 1] = y1i + y15r;
                zj2[i1] = y2r - y14i;
                zj2[i1 + 1] = y2i + y14r;
                zj3[i1] = y3r - y13i;
                zj3[i1 + 1] = y3i + y13r;
                zj4[i1] = y4r - y12i;
                zj4[i1 + 1] = y4i + y12r;
                zj5[i1] = y5r - y11i;
                zj5[i1 + 1] = y5i + y11r;
                zj6[i1] = y6r - y10i;
                zj6[i1 + 1] = y6i + y10r;
                zj7[i1] = y7r - y9i;
                zj7[i1 + 1] = y7i + y9r;
                zj8[i1] = t31r - t32r;
                zj8[i1 + 1] = t31i - t32i;
                zj9[i1] = y7r + y9i;
                zj9[i1 + 1] = y7i - y9r;
                zj10[i1] = y6r + y10i;
                zj10[i1 + 1] = y6i - y10r;
                zj11[i1] = y5r + y11i;
                zj11[i1 + 1] = y5i - y11r;
                zj12[i1] = y4r + y12i;
                zj12[i1 + 1] = y4i - y12r;
                zj13[i1] = y3r + y13i;
                zj13[i1 + 1] = y3i - y13r;
                zj14[i1] = y2r + y14i;
                zj14[i1 + 1] = y2i - y14r;
                zj15[i1] = y1r + y15i;
                zj15[i1 + 1] = y1i - y15r;
            }
            int jt = j15 + 1;
            j15 = j14 + 1;
            j14 = j13 + 1;
            j13 = j12 + 1;
            j12 = j11 + 1;
            j11 = j10 + 1;
            j10 = j9 + 1;
            j9 = j8 + 1;
            j8 = j7 + 1;
            j7 = j6 + 1;
            j6 = j5 + 1;
            j5 = j4 + 1;
            j4 = j3 + 1;
            j3 = j2 + 1;
            j2 = j1 + 1;
            j1 = j0 + 1;
            j0 = jt;
        }
    }

    static void transform2b(int sign, int n1, int nfft, float[][] z) {
        int nleft = nfft;
        for (int jfac = 0; jfac < 10; ++jfac) {
            int ifac = _kfac[jfac];
            int ndiv = nleft / ifac;
            if (ndiv * ifac != nleft) continue;
            nleft = ndiv;
            int m = nfft / ifac;
            int mu = 0;
            int mm = 0;
            for (int kfac = 1; kfac <= ifac && mm % ifac != 1; ++kfac) {
                mu = kfac;
                mm = kfac * m;
            }
            if (sign < 0) {
                mu = ifac - mu;
            }
            int jinc = 2 * mm;
            int jmax = 2 * nfft;
            int j0 = 0;
            int j1 = j0 + jinc;
            if (ifac == 2) {
                Pfacc.pfa2b(n1, z, mu, m, j0, j1);
                continue;
            }
            int j2 = (j1 + jinc) % jmax;
            if (ifac == 3) {
                Pfacc.pfa3b(n1, z, mu, m, j0, j1, j2);
                continue;
            }
            int j3 = (j2 + jinc) % jmax;
            if (ifac == 4) {
                Pfacc.pfa4b(n1, z, mu, m, j0, j1, j2, j3);
                continue;
            }
            int j4 = (j3 + jinc) % jmax;
            if (ifac == 5) {
                Pfacc.pfa5b(n1, z, mu, m, j0, j1, j2, j3, j4);
                continue;
            }
            int j5 = (j4 + jinc) % jmax;
            int j6 = (j5 + jinc) % jmax;
            if (ifac == 7) {
                Pfacc.pfa7b(n1, z, mu, m, j0, j1, j2, j3, j4, j5, j6);
                continue;
            }
            int j7 = (j6 + jinc) % jmax;
            if (ifac == 8) {
                Pfacc.pfa8b(n1, z, mu, m, j0, j1, j2, j3, j4, j5, j6, j7);
                continue;
            }
            int j8 = (j7 + jinc) % jmax;
            if (ifac == 9) {
                Pfacc.pfa9b(n1, z, mu, m, j0, j1, j2, j3, j4, j5, j6, j7, j8);
                continue;
            }
            int j9 = (j8 + jinc) % jmax;
            int j10 = (j9 + jinc) % jmax;
            if (ifac == 11) {
                Pfacc.pfa11b(n1, z, mu, m, j0, j1, j2, j3, j4, j5, j6, j7, j8, j9, j10);
                continue;
            }
            int j11 = (j10 + jinc) % jmax;
            int j12 = (j11 + jinc) % jmax;
            if (ifac == 13) {
                Pfacc.pfa13b(n1, z, mu, m, j0, j1, j2, j3, j4, j5, j6, j7, j8, j9, j10, j11, j12);
                continue;
            }
            int j13 = (j12 + jinc) % jmax;
            int j14 = (j13 + jinc) % jmax;
            int j15 = (j14 + jinc) % jmax;
            if (ifac != 16) continue;
            Pfacc.pfa16b(n1, z, mu, m, j0, j1, j2, j3, j4, j5, j6, j7, j8, j9, j10, j11, j12, j13, j14, j15);
        }
    }

    private static void pfa2b(int n1, float[][] z, int mu, int m, int j0, int j1) {
        for (int i = 0; i < m; ++i) {
            float[] zj0r = z[j0];
            float[] zj0i = z[j0 + 1];
            float[] zj1r = z[j1];
            float[] zj1i = z[j1 + 1];
            for (int i1 = 0; i1 < n1; ++i1) {
                float t1r = zj0r[i1] - zj1r[i1];
                float t1i = zj0i[i1] - zj1i[i1];
                zj0r[i1] = zj0r[i1] + zj1r[i1];
                zj0i[i1] = zj0i[i1] + zj1i[i1];
                zj1r[i1] = t1r;
                zj1i[i1] = t1i;
            }
            int jt = j1 + 2;
            j1 = j0 + 2;
            j0 = jt;
        }
    }

    private static void pfa3b(int n1, float[][] z, int mu, int m, int j0, int j1, int j2) {
        float c1 = mu == 1 ? 0.8660254f : -0.8660254f;
        for (int i = 0; i < m; ++i) {
            float[] zj0r = z[j0];
            float[] zj0i = z[j0 + 1];
            float[] zj1r = z[j1];
            float[] zj1i = z[j1 + 1];
            float[] zj2r = z[j2];
            float[] zj2i = z[j2 + 1];
            for (int i1 = 0; i1 < n1; ++i1) {
                float t1r = zj1r[i1] + zj2r[i1];
                float t1i = zj1i[i1] + zj2i[i1];
                float y1r = zj0r[i1] - 0.5f * t1r;
                float y1i = zj0i[i1] - 0.5f * t1i;
                float y2r = c1 * (zj1r[i1] - zj2r[i1]);
                float y2i = c1 * (zj1i[i1] - zj2i[i1]);
                zj0r[i1] = zj0r[i1] + t1r;
                zj0i[i1] = zj0i[i1] + t1i;
                zj1r[i1] = y1r - y2i;
                zj1i[i1] = y1i + y2r;
                zj2r[i1] = y1r + y2i;
                zj2i[i1] = y1i - y2r;
            }
            int jt = j2 + 2;
            j2 = j1 + 2;
            j1 = j0 + 2;
            j0 = jt;
        }
    }

    private static void pfa4b(int n1, float[][] z, int mu, int m, int j0, int j1, int j2, int j3) {
        float c1 = mu == 1 ? 1.0f : -1.0f;
        for (int i = 0; i < m; ++i) {
            float[] zj0r = z[j0];
            float[] zj0i = z[j0 + 1];
            float[] zj1r = z[j1];
            float[] zj1i = z[j1 + 1];
            float[] zj2r = z[j2];
            float[] zj2i = z[j2 + 1];
            float[] zj3r = z[j3];
            float[] zj3i = z[j3 + 1];
            for (int i1 = 0; i1 < n1; ++i1) {
                float t1r = zj0r[i1] + zj2r[i1];
                float t1i = zj0i[i1] + zj2i[i1];
                float t2r = zj1r[i1] + zj3r[i1];
                float t2i = zj1i[i1] + zj3i[i1];
                float y1r = zj0r[i1] - zj2r[i1];
                float y1i = zj0i[i1] - zj2i[i1];
                float y3r = c1 * (zj1r[i1] - zj3r[i1]);
                float y3i = c1 * (zj1i[i1] - zj3i[i1]);
                zj0r[i1] = t1r + t2r;
                zj0i[i1] = t1i + t2i;
                zj1r[i1] = y1r - y3i;
                zj1i[i1] = y1i + y3r;
                zj2r[i1] = t1r - t2r;
                zj2i[i1] = t1i - t2i;
                zj3r[i1] = y1r + y3i;
                zj3i[i1] = y1i - y3r;
            }
            int jt = j3 + 2;
            j3 = j2 + 2;
            j2 = j1 + 2;
            j1 = j0 + 2;
            j0 = jt;
        }
    }

    private static void pfa5b(int n1, float[][] z, int mu, int m, int j0, int j1, int j2, int j3, int j4) {
        float c3;
        float c2;
        float c1;
        if (mu == 1) {
            c1 = 0.559017f;
            c2 = 0.95105654f;
            c3 = 0.58778524f;
        } else if (mu == 2) {
            c1 = -0.559017f;
            c2 = 0.58778524f;
            c3 = -0.95105654f;
        } else if (mu == 3) {
            c1 = -0.559017f;
            c2 = -0.58778524f;
            c3 = 0.95105654f;
        } else {
            c1 = 0.559017f;
            c2 = -0.95105654f;
            c3 = -0.58778524f;
        }
        for (int i = 0; i < m; ++i) {
            float[] zj0r = z[j0];
            float[] zj0i = z[j0 + 1];
            float[] zj1r = z[j1];
            float[] zj1i = z[j1 + 1];
            float[] zj2r = z[j2];
            float[] zj2i = z[j2 + 1];
            float[] zj3r = z[j3];
            float[] zj3i = z[j3 + 1];
            float[] zj4r = z[j4];
            float[] zj4i = z[j4 + 1];
            for (int i1 = 0; i1 < n1; ++i1) {
                float t1r = zj1r[i1] + zj4r[i1];
                float t1i = zj1i[i1] + zj4i[i1];
                float t2r = zj2r[i1] + zj3r[i1];
                float t2i = zj2i[i1] + zj3i[i1];
                float t3r = zj1r[i1] - zj4r[i1];
                float t3i = zj1i[i1] - zj4i[i1];
                float t4r = zj2r[i1] - zj3r[i1];
                float t4i = zj2i[i1] - zj3i[i1];
                float t5r = t1r + t2r;
                float t5i = t1i + t2i;
                float t6r = c1 * (t1r - t2r);
                float t6i = c1 * (t1i - t2i);
                float t7r = zj0r[i1] - 0.25f * t5r;
                float t7i = zj0i[i1] - 0.25f * t5i;
                float y1r = t7r + t6r;
                float y1i = t7i + t6i;
                float y2r = t7r - t6r;
                float y2i = t7i - t6i;
                float y3r = c3 * t3r - c2 * t4r;
                float y3i = c3 * t3i - c2 * t4i;
                float y4r = c2 * t3r + c3 * t4r;
                float y4i = c2 * t3i + c3 * t4i;
                zj0r[i1] = zj0r[i1] + t5r;
                zj0i[i1] = zj0i[i1] + t5i;
                zj1r[i1] = y1r - y4i;
                zj1i[i1] = y1i + y4r;
                zj2r[i1] = y2r - y3i;
                zj2i[i1] = y2i + y3r;
                zj3r[i1] = y2r + y3i;
                zj3i[i1] = y2i - y3r;
                zj4r[i1] = y1r + y4i;
                zj4i[i1] = y1i - y4r;
            }
            int jt = j4 + 2;
            j4 = j3 + 2;
            j3 = j2 + 2;
            j2 = j1 + 2;
            j1 = j0 + 2;
            j0 = jt;
        }
    }

    private static void pfa7b(int n1, float[][] z, int mu, int m, int j0, int j1, int j2, int j3, int j4, int j5, int j6) {
        float c6;
        float c5;
        float c4;
        float c3;
        float c2;
        float c1;
        if (mu == 1) {
            c1 = 0.6234898f;
            c2 = -0.22252093f;
            c3 = -0.90096885f;
            c4 = 0.7818315f;
            c5 = 0.9749279f;
            c6 = 0.43388373f;
        } else if (mu == 2) {
            c1 = -0.22252093f;
            c2 = -0.90096885f;
            c3 = 0.6234898f;
            c4 = 0.9749279f;
            c5 = -0.43388373f;
            c6 = -0.7818315f;
        } else if (mu == 3) {
            c1 = -0.90096885f;
            c2 = 0.6234898f;
            c3 = -0.22252093f;
            c4 = 0.43388373f;
            c5 = -0.7818315f;
            c6 = 0.9749279f;
        } else if (mu == 4) {
            c1 = -0.90096885f;
            c2 = 0.6234898f;
            c3 = -0.22252093f;
            c4 = -0.43388373f;
            c5 = 0.7818315f;
            c6 = -0.9749279f;
        } else if (mu == 5) {
            c1 = -0.22252093f;
            c2 = -0.90096885f;
            c3 = 0.6234898f;
            c4 = -0.9749279f;
            c5 = 0.43388373f;
            c6 = 0.7818315f;
        } else {
            c1 = 0.6234898f;
            c2 = -0.22252093f;
            c3 = -0.90096885f;
            c4 = -0.7818315f;
            c5 = -0.9749279f;
            c6 = -0.43388373f;
        }
        for (int i = 0; i < m; ++i) {
            float[] zj0r = z[j0];
            float[] zj0i = z[j0 + 1];
            float[] zj1r = z[j1];
            float[] zj1i = z[j1 + 1];
            float[] zj2r = z[j2];
            float[] zj2i = z[j2 + 1];
            float[] zj3r = z[j3];
            float[] zj3i = z[j3 + 1];
            float[] zj4r = z[j4];
            float[] zj4i = z[j4 + 1];
            float[] zj5r = z[j5];
            float[] zj5i = z[j5 + 1];
            float[] zj6r = z[j6];
            float[] zj6i = z[j6 + 1];
            for (int i1 = 0; i1 < n1; ++i1) {
                float t1r = zj1r[i1] + zj6r[i1];
                float t1i = zj1i[i1] + zj6i[i1];
                float t2r = zj2r[i1] + zj5r[i1];
                float t2i = zj2i[i1] + zj5i[i1];
                float t3r = zj3r[i1] + zj4r[i1];
                float t3i = zj3i[i1] + zj4i[i1];
                float t4r = zj1r[i1] - zj6r[i1];
                float t4i = zj1i[i1] - zj6i[i1];
                float t5r = zj2r[i1] - zj5r[i1];
                float t5i = zj2i[i1] - zj5i[i1];
                float t6r = zj3r[i1] - zj4r[i1];
                float t6i = zj3i[i1] - zj4i[i1];
                float t7r = zj0r[i1] - 0.5f * t3r;
                float t7i = zj0i[i1] - 0.5f * t3i;
                float t8r = t1r - t3r;
                float t8i = t1i - t3i;
                float t9r = t2r - t3r;
                float t9i = t2i - t3i;
                float y1r = t7r + c1 * t8r + c2 * t9r;
                float y1i = t7i + c1 * t8i + c2 * t9i;
                float y2r = t7r + c2 * t8r + c3 * t9r;
                float y2i = t7i + c2 * t8i + c3 * t9i;
                float y3r = t7r + c3 * t8r + c1 * t9r;
                float y3i = t7i + c3 * t8i + c1 * t9i;
                float y4r = c6 * t4r - c4 * t5r + c5 * t6r;
                float y4i = c6 * t4i - c4 * t5i + c5 * t6i;
                float y5r = c5 * t4r - c6 * t5r - c4 * t6r;
                float y5i = c5 * t4i - c6 * t5i - c4 * t6i;
                float y6r = c4 * t4r + c5 * t5r + c6 * t6r;
                float y6i = c4 * t4i + c5 * t5i + c6 * t6i;
                zj0r[i1] = zj0r[i1] + t1r + t2r + t3r;
                zj0i[i1] = zj0i[i1] + t1i + t2i + t3i;
                zj1r[i1] = y1r - y6i;
                zj1i[i1] = y1i + y6r;
                zj2r[i1] = y2r - y5i;
                zj2i[i1] = y2i + y5r;
                zj3r[i1] = y3r - y4i;
                zj3i[i1] = y3i + y4r;
                zj4r[i1] = y3r + y4i;
                zj4i[i1] = y3i - y4r;
                zj5r[i1] = y2r + y5i;
                zj5i[i1] = y2i - y5r;
                zj6r[i1] = y1r + y6i;
                zj6i[i1] = y1i - y6r;
            }
            int jt = j6 + 2;
            j6 = j5 + 2;
            j5 = j4 + 2;
            j4 = j3 + 2;
            j3 = j2 + 2;
            j2 = j1 + 2;
            j1 = j0 + 2;
            j0 = jt;
        }
    }

    private static void pfa8b(int n1, float[][] z, int mu, int m, int j0, int j1, int j2, int j3, int j4, int j5, int j6, int j7) {
        float c2;
        float c1;
        if (mu == 1) {
            c1 = 1.0f;
            c2 = 0.70710677f;
        } else if (mu == 3) {
            c1 = -1.0f;
            c2 = -0.70710677f;
        } else if (mu == 5) {
            c1 = 1.0f;
            c2 = -0.70710677f;
        } else {
            c1 = -1.0f;
            c2 = 0.70710677f;
        }
        float c3 = c1 * c2;
        for (int i = 0; i < m; ++i) {
            float[] zj0r = z[j0];
            float[] zj0i = z[j0 + 1];
            float[] zj1r = z[j1];
            float[] zj1i = z[j1 + 1];
            float[] zj2r = z[j2];
            float[] zj2i = z[j2 + 1];
            float[] zj3r = z[j3];
            float[] zj3i = z[j3 + 1];
            float[] zj4r = z[j4];
            float[] zj4i = z[j4 + 1];
            float[] zj5r = z[j5];
            float[] zj5i = z[j5 + 1];
            float[] zj6r = z[j6];
            float[] zj6i = z[j6 + 1];
            float[] zj7r = z[j7];
            float[] zj7i = z[j7 + 1];
            for (int i1 = 0; i1 < n1; ++i1) {
                float t1r = zj0r[i1] + zj4r[i1];
                float t1i = zj0i[i1] + zj4i[i1];
                float t2r = zj0r[i1] - zj4r[i1];
                float t2i = zj0i[i1] - zj4i[i1];
                float t3r = zj1r[i1] + zj5r[i1];
                float t3i = zj1i[i1] + zj5i[i1];
                float t4r = zj1r[i1] - zj5r[i1];
                float t4i = zj1i[i1] - zj5i[i1];
                float t5r = zj2r[i1] + zj6r[i1];
                float t5i = zj2i[i1] + zj6i[i1];
                float t6r = c1 * (zj2r[i1] - zj6r[i1]);
                float t6i = c1 * (zj2i[i1] - zj6i[i1]);
                float t7r = zj3r[i1] + zj7r[i1];
                float t7i = zj3i[i1] + zj7i[i1];
                float t8r = zj3r[i1] - zj7r[i1];
                float t8i = zj3i[i1] - zj7i[i1];
                float t9r = t1r + t5r;
                float t9i = t1i + t5i;
                float t10r = t3r + t7r;
                float t10i = t3i + t7i;
                float t11r = c2 * (t4r - t8r);
                float t11i = c2 * (t4i - t8i);
                float t12r = c3 * (t4r + t8r);
                float t12i = c3 * (t4i + t8i);
                float y1r = t2r + t11r;
                float y1i = t2i + t11i;
                float y2r = t1r - t5r;
                float y2i = t1i - t5i;
                float y3r = t2r - t11r;
                float y3i = t2i - t11i;
                float y5r = t12r - t6r;
                float y5i = t12i - t6i;
                float y6r = c1 * (t3r - t7r);
                float y6i = c1 * (t3i - t7i);
                float y7r = t12r + t6r;
                float y7i = t12i + t6i;
                zj0r[i1] = t9r + t10r;
                zj0i[i1] = t9i + t10i;
                zj1r[i1] = y1r - y7i;
                zj1i[i1] = y1i + y7r;
                zj2r[i1] = y2r - y6i;
                zj2i[i1] = y2i + y6r;
                zj3r[i1] = y3r - y5i;
                zj3i[i1] = y3i + y5r;
                zj4r[i1] = t9r - t10r;
                zj4i[i1] = t9i - t10i;
                zj5r[i1] = y3r + y5i;
                zj5i[i1] = y3i - y5r;
                zj6r[i1] = y2r + y6i;
                zj6i[i1] = y2i - y6r;
                zj7r[i1] = y1r + y7i;
                zj7i[i1] = y1i - y7r;
            }
            int jt = j7 + 2;
            j7 = j6 + 2;
            j6 = j5 + 2;
            j5 = j4 + 2;
            j4 = j3 + 2;
            j3 = j2 + 2;
            j2 = j1 + 2;
            j1 = j0 + 2;
            j0 = jt;
        }
    }

    private static void pfa9b(int n1, float[][] z, int mu, int m, int j0, int j1, int j2, int j3, int j4, int j5, int j6, int j7, int j8) {
        float c5;
        float c4;
        float c3;
        float c2;
        float c1;
        if (mu == 1) {
            c1 = 0.8660254f;
            c2 = 0.76604444f;
            c3 = 0.64278764f;
            c4 = 0.17364818f;
            c5 = 0.9848077f;
        } else if (mu == 2) {
            c1 = -0.8660254f;
            c2 = 0.17364818f;
            c3 = 0.9848077f;
            c4 = -0.9396926f;
            c5 = 0.34202015f;
        } else if (mu == 4) {
            c1 = 0.8660254f;
            c2 = -0.9396926f;
            c3 = 0.34202015f;
            c4 = 0.76604444f;
            c5 = -0.64278764f;
        } else if (mu == 5) {
            c1 = -0.8660254f;
            c2 = -0.9396926f;
            c3 = -0.34202015f;
            c4 = 0.76604444f;
            c5 = 0.64278764f;
        } else if (mu == 7) {
            c1 = 0.8660254f;
            c2 = 0.17364818f;
            c3 = -0.9848077f;
            c4 = -0.9396926f;
            c5 = -0.34202015f;
        } else {
            c1 = -0.8660254f;
            c2 = 0.76604444f;
            c3 = -0.64278764f;
            c4 = 0.17364818f;
            c5 = -0.9848077f;
        }
        float c6 = c1 * c2;
        float c7 = c1 * c3;
        float c8 = c1 * c4;
        float c9 = c1 * c5;
        for (int i = 0; i < m; ++i) {
            float[] zj0r = z[j0];
            float[] zj0i = z[j0 + 1];
            float[] zj1r = z[j1];
            float[] zj1i = z[j1 + 1];
            float[] zj2r = z[j2];
            float[] zj2i = z[j2 + 1];
            float[] zj3r = z[j3];
            float[] zj3i = z[j3 + 1];
            float[] zj4r = z[j4];
            float[] zj4i = z[j4 + 1];
            float[] zj5r = z[j5];
            float[] zj5i = z[j5 + 1];
            float[] zj6r = z[j6];
            float[] zj6i = z[j6 + 1];
            float[] zj7r = z[j7];
            float[] zj7i = z[j7 + 1];
            float[] zj8r = z[j8];
            float[] zj8i = z[j8 + 1];
            for (int i1 = 0; i1 < n1; ++i1) {
                float t1r = zj3r[i1] + zj6r[i1];
                float t1i = zj3i[i1] + zj6i[i1];
                float t2r = zj0r[i1] - 0.5f * t1r;
                float t2i = zj0i[i1] - 0.5f * t1i;
                float t3r = c1 * (zj3r[i1] - zj6r[i1]);
                float t3i = c1 * (zj3i[i1] - zj6i[i1]);
                float t4r = zj0r[i1] + t1r;
                float t4i = zj0i[i1] + t1i;
                float t5r = zj4r[i1] + zj7r[i1];
                float t5i = zj4i[i1] + zj7i[i1];
                float t6r = zj1r[i1] - 0.5f * t5r;
                float t6i = zj1i[i1] - 0.5f * t5i;
                float t7r = zj4r[i1] - zj7r[i1];
                float t7i = zj4i[i1] - zj7i[i1];
                float t8r = zj1r[i1] + t5r;
                float t8i = zj1i[i1] + t5i;
                float t9r = zj2r[i1] + zj5r[i1];
                float t9i = zj2i[i1] + zj5i[i1];
                float t10r = zj8r[i1] - 0.5f * t9r;
                float t10i = zj8i[i1] - 0.5f * t9i;
                float t11r = zj2r[i1] - zj5r[i1];
                float t11i = zj2i[i1] - zj5i[i1];
                float t12r = zj8r[i1] + t9r;
                float t12i = zj8i[i1] + t9i;
                float t13r = t8r + t12r;
                float t13i = t8i + t12i;
                float t14r = t6r + t10r;
                float t14i = t6i + t10i;
                float t15r = t6r - t10r;
                float t15i = t6i - t10i;
                float t16r = t7r + t11r;
                float t16i = t7i + t11i;
                float t17r = t7r - t11r;
                float t17i = t7i - t11i;
                float t18r = c2 * t14r - c7 * t17r;
                float t18i = c2 * t14i - c7 * t17i;
                float t19r = c4 * t14r + c9 * t17r;
                float t19i = c4 * t14i + c9 * t17i;
                float t20r = c3 * t15r + c6 * t16r;
                float t20i = c3 * t15i + c6 * t16i;
                float t21r = c5 * t15r - c8 * t16r;
                float t21i = c5 * t15i - c8 * t16i;
                float t22r = t18r + t19r;
                float t22i = t18i + t19i;
                float t23r = t20r - t21r;
                float t23i = t20i - t21i;
                float y1r = t2r + t18r;
                float y1i = t2i + t18i;
                float y2r = t2r + t19r;
                float y2i = t2i + t19i;
                float y3r = t4r - 0.5f * t13r;
                float y3i = t4i - 0.5f * t13i;
                float y4r = t2r - t22r;
                float y4i = t2i - t22i;
                float y5r = t3r - t23r;
                float y5i = t3i - t23i;
                float y6r = c1 * (t8r - t12r);
                float y6i = c1 * (t8i - t12i);
                float y7r = t21r - t3r;
                float y7i = t21i - t3i;
                float y8r = t3r + t20r;
                float y8i = t3i + t20i;
                zj0r[i1] = t4r + t13r;
                zj0i[i1] = t4i + t13i;
                zj1r[i1] = y1r - y8i;
                zj1i[i1] = y1i + y8r;
                zj2r[i1] = y2r - y7i;
                zj2i[i1] = y2i + y7r;
                zj3r[i1] = y3r - y6i;
                zj3i[i1] = y3i + y6r;
                zj4r[i1] = y4r - y5i;
                zj4i[i1] = y4i + y5r;
                zj5r[i1] = y4r + y5i;
                zj5i[i1] = y4i - y5r;
                zj6r[i1] = y3r + y6i;
                zj6i[i1] = y3i - y6r;
                zj7r[i1] = y2r + y7i;
                zj7i[i1] = y2i - y7r;
                zj8r[i1] = y1r + y8i;
                zj8i[i1] = y1i - y8r;
            }
            int jt = j8 + 2;
            j8 = j7 + 2;
            j7 = j6 + 2;
            j6 = j5 + 2;
            j5 = j4 + 2;
            j4 = j3 + 2;
            j3 = j2 + 2;
            j2 = j1 + 2;
            j1 = j0 + 2;
            j0 = jt;
        }
    }

    private static void pfa11b(int n1, float[][] z, int mu, int m, int j0, int j1, int j2, int j3, int j4, int j5, int j6, int j7, int j8, int j9, int j10) {
        float c10;
        float c9;
        float c8;
        float c7;
        float c6;
        float c5;
        float c4;
        float c3;
        float c2;
        float c1;
        if (mu == 1) {
            c1 = 0.8412535f;
            c2 = 0.41541502f;
            c3 = -0.14231484f;
            c4 = -0.65486073f;
            c5 = -0.959493f;
            c6 = 0.54064083f;
            c7 = 0.90963197f;
            c8 = 0.98982143f;
            c9 = 0.7557496f;
            c10 = 0.28173256f;
        } else if (mu == 2) {
            c1 = 0.41541502f;
            c2 = -0.65486073f;
            c3 = -0.959493f;
            c4 = -0.14231484f;
            c5 = 0.8412535f;
            c6 = 0.90963197f;
            c7 = 0.7557496f;
            c8 = -0.28173256f;
            c9 = -0.98982143f;
            c10 = -0.54064083f;
        } else if (mu == 3) {
            c1 = -0.14231484f;
            c2 = -0.959493f;
            c3 = 0.41541502f;
            c4 = 0.8412535f;
            c5 = -0.65486073f;
            c6 = 0.98982143f;
            c7 = -0.28173256f;
            c8 = -0.90963197f;
            c9 = 0.54064083f;
            c10 = 0.7557496f;
        } else if (mu == 4) {
            c1 = -0.65486073f;
            c2 = -0.14231484f;
            c3 = 0.8412535f;
            c4 = -0.959493f;
            c5 = 0.41541502f;
            c6 = 0.7557496f;
            c7 = -0.98982143f;
            c8 = 0.54064083f;
            c9 = 0.28173256f;
            c10 = -0.90963197f;
        } else if (mu == 5) {
            c1 = -0.959493f;
            c2 = 0.8412535f;
            c3 = -0.65486073f;
            c4 = 0.41541502f;
            c5 = -0.14231484f;
            c6 = 0.28173256f;
            c7 = -0.54064083f;
            c8 = 0.7557496f;
            c9 = -0.90963197f;
            c10 = 0.98982143f;
        } else if (mu == 6) {
            c1 = -0.959493f;
            c2 = 0.8412535f;
            c3 = -0.65486073f;
            c4 = 0.41541502f;
            c5 = -0.14231484f;
            c6 = -0.28173256f;
            c7 = 0.54064083f;
            c8 = -0.7557496f;
            c9 = 0.90963197f;
            c10 = -0.98982143f;
        } else if (mu == 7) {
            c1 = -0.65486073f;
            c2 = -0.14231484f;
            c3 = 0.8412535f;
            c4 = -0.959493f;
            c5 = 0.41541502f;
            c6 = -0.7557496f;
            c7 = 0.98982143f;
            c8 = -0.54064083f;
            c9 = -0.28173256f;
            c10 = 0.90963197f;
        } else if (mu == 8) {
            c1 = -0.14231484f;
            c2 = -0.959493f;
            c3 = 0.41541502f;
            c4 = 0.8412535f;
            c5 = -0.65486073f;
            c6 = -0.98982143f;
            c7 = 0.28173256f;
            c8 = 0.90963197f;
            c9 = -0.54064083f;
            c10 = -0.7557496f;
        } else if (mu == 9) {
            c1 = 0.41541502f;
            c2 = -0.65486073f;
            c3 = -0.959493f;
            c4 = -0.14231484f;
            c5 = 0.8412535f;
            c6 = -0.90963197f;
            c7 = -0.7557496f;
            c8 = 0.28173256f;
            c9 = 0.98982143f;
            c10 = 0.54064083f;
        } else {
            c1 = 0.8412535f;
            c2 = 0.41541502f;
            c3 = -0.14231484f;
            c4 = -0.65486073f;
            c5 = -0.959493f;
            c6 = -0.54064083f;
            c7 = -0.90963197f;
            c8 = -0.98982143f;
            c9 = -0.7557496f;
            c10 = -0.28173256f;
        }
        for (int i = 0; i < m; ++i) {
            float[] zj0r = z[j0];
            float[] zj0i = z[j0 + 1];
            float[] zj1r = z[j1];
            float[] zj1i = z[j1 + 1];
            float[] zj2r = z[j2];
            float[] zj2i = z[j2 + 1];
            float[] zj3r = z[j3];
            float[] zj3i = z[j3 + 1];
            float[] zj4r = z[j4];
            float[] zj4i = z[j4 + 1];
            float[] zj5r = z[j5];
            float[] zj5i = z[j5 + 1];
            float[] zj6r = z[j6];
            float[] zj6i = z[j6 + 1];
            float[] zj7r = z[j7];
            float[] zj7i = z[j7 + 1];
            float[] zj8r = z[j8];
            float[] zj8i = z[j8 + 1];
            float[] zj9r = z[j9];
            float[] zj9i = z[j9 + 1];
            float[] zj10r = z[j10];
            float[] zj10i = z[j10 + 1];
            for (int i1 = 0; i1 < n1; ++i1) {
                float t1r = zj1r[i1] + zj10r[i1];
                float t1i = zj1i[i1] + zj10i[i1];
                float t2r = zj2r[i1] + zj9r[i1];
                float t2i = zj2i[i1] + zj9i[i1];
                float t3r = zj3r[i1] + zj8r[i1];
                float t3i = zj3i[i1] + zj8i[i1];
                float t4r = zj4r[i1] + zj7r[i1];
                float t4i = zj4i[i1] + zj7i[i1];
                float t5r = zj5r[i1] + zj6r[i1];
                float t5i = zj5i[i1] + zj6i[i1];
                float t6r = zj1r[i1] - zj10r[i1];
                float t6i = zj1i[i1] - zj10i[i1];
                float t7r = zj2r[i1] - zj9r[i1];
                float t7i = zj2i[i1] - zj9i[i1];
                float t8r = zj3r[i1] - zj8r[i1];
                float t8i = zj3i[i1] - zj8i[i1];
                float t9r = zj4r[i1] - zj7r[i1];
                float t9i = zj4i[i1] - zj7i[i1];
                float t10r = zj5r[i1] - zj6r[i1];
                float t10i = zj5i[i1] - zj6i[i1];
                float t11r = zj0r[i1] - 0.5f * t5r;
                float t11i = zj0i[i1] - 0.5f * t5i;
                float t12r = t1r - t5r;
                float t12i = t1i - t5i;
                float t13r = t2r - t5r;
                float t13i = t2i - t5i;
                float t14r = t3r - t5r;
                float t14i = t3i - t5i;
                float t15r = t4r - t5r;
                float t15i = t4i - t5i;
                float y1r = t11r + c1 * t12r + c2 * t13r + c3 * t14r + c4 * t15r;
                float y1i = t11i + c1 * t12i + c2 * t13i + c3 * t14i + c4 * t15i;
                float y2r = t11r + c2 * t12r + c4 * t13r + c5 * t14r + c3 * t15r;
                float y2i = t11i + c2 * t12i + c4 * t13i + c5 * t14i + c3 * t15i;
                float y3r = t11r + c3 * t12r + c5 * t13r + c2 * t14r + c1 * t15r;
                float y3i = t11i + c3 * t12i + c5 * t13i + c2 * t14i + c1 * t15i;
                float y4r = t11r + c4 * t12r + c3 * t13r + c1 * t14r + c5 * t15r;
                float y4i = t11i + c4 * t12i + c3 * t13i + c1 * t14i + c5 * t15i;
                float y5r = t11r + c5 * t12r + c1 * t13r + c4 * t14r + c2 * t15r;
                float y5i = t11i + c5 * t12i + c1 * t13i + c4 * t14i + c2 * t15i;
                float y6r = c10 * t6r - c6 * t7r + c9 * t8r - c7 * t9r + c8 * t10r;
                float y6i = c10 * t6i - c6 * t7i + c9 * t8i - c7 * t9i + c8 * t10i;
                float y7r = c9 * t6r - c8 * t7r + c6 * t8r + c10 * t9r - c7 * t10r;
                float y7i = c9 * t6i - c8 * t7i + c6 * t8i + c10 * t9i - c7 * t10i;
                float y8r = c8 * t6r - c10 * t7r - c7 * t8r + c6 * t9r + c9 * t10r;
                float y8i = c8 * t6i - c10 * t7i - c7 * t8i + c6 * t9i + c9 * t10i;
                float y9r = c7 * t6r + c9 * t7r - c10 * t8r - c8 * t9r - c6 * t10r;
                float y9i = c7 * t6i + c9 * t7i - c10 * t8i - c8 * t9i - c6 * t10i;
                float y10r = c6 * t6r + c7 * t7r + c8 * t8r + c9 * t9r + c10 * t10r;
                float y10i = c6 * t6i + c7 * t7i + c8 * t8i + c9 * t9i + c10 * t10i;
                zj0r[i1] = zj0r[i1] + t1r + t2r + t3r + t4r + t5r;
                zj0i[i1] = zj0i[i1] + t1i + t2i + t3i + t4i + t5i;
                zj1r[i1] = y1r - y10i;
                zj1i[i1] = y1i + y10r;
                zj2r[i1] = y2r - y9i;
                zj2i[i1] = y2i + y9r;
                zj3r[i1] = y3r - y8i;
                zj3i[i1] = y3i + y8r;
                zj4r[i1] = y4r - y7i;
                zj4i[i1] = y4i + y7r;
                zj5r[i1] = y5r - y6i;
                zj5i[i1] = y5i + y6r;
                zj6r[i1] = y5r + y6i;
                zj6i[i1] = y5i - y6r;
                zj7r[i1] = y4r + y7i;
                zj7i[i1] = y4i - y7r;
                zj8r[i1] = y3r + y8i;
                zj8i[i1] = y3i - y8r;
                zj9r[i1] = y2r + y9i;
                zj9i[i1] = y2i - y9r;
                zj10r[i1] = y1r + y10i;
                zj10i[i1] = y1i - y10r;
            }
            int jt = j10 + 2;
            j10 = j9 + 2;
            j9 = j8 + 2;
            j8 = j7 + 2;
            j7 = j6 + 2;
            j6 = j5 + 2;
            j5 = j4 + 2;
            j4 = j3 + 2;
            j3 = j2 + 2;
            j2 = j1 + 2;
            j1 = j0 + 2;
            j0 = jt;
        }
    }

    private static void pfa13b(int n1, float[][] z, int mu, int m, int j0, int j1, int j2, int j3, int j4, int j5, int j6, int j7, int j8, int j9, int j10, int j11, int j12) {
        float c12;
        float c11;
        float c10;
        float c9;
        float c8;
        float c7;
        float c6;
        float c5;
        float c4;
        float c3;
        float c2;
        float c1;
        if (mu == 1) {
            c1 = 0.885456f;
            c2 = 0.56806475f;
            c3 = 0.12053668f;
            c4 = -0.3546049f;
            c5 = -0.7485107f;
            c6 = -0.97094184f;
            c7 = 0.46472317f;
            c8 = 0.82298386f;
            c9 = 0.99270886f;
            c10 = 0.9350162f;
            c11 = 0.66312265f;
            c12 = 0.23931566f;
        } else if (mu == 2) {
            c1 = 0.56806475f;
            c2 = -0.3546049f;
            c3 = -0.97094184f;
            c4 = -0.7485107f;
            c5 = 0.12053668f;
            c6 = 0.885456f;
            c7 = 0.82298386f;
            c8 = 0.9350162f;
            c9 = 0.23931566f;
            c10 = -0.66312265f;
            c11 = -0.99270886f;
            c12 = -0.46472317f;
        } else if (mu == 3) {
            c1 = 0.12053668f;
            c2 = -0.97094184f;
            c3 = -0.3546049f;
            c4 = 0.885456f;
            c5 = 0.56806475f;
            c6 = -0.7485107f;
            c7 = 0.99270886f;
            c8 = 0.23931566f;
            c9 = -0.9350162f;
            c10 = -0.46472317f;
            c11 = 0.82298386f;
            c12 = 0.66312265f;
        } else if (mu == 4) {
            c1 = -0.3546049f;
            c2 = -0.7485107f;
            c3 = 0.885456f;
            c4 = 0.12053668f;
            c5 = -0.97094184f;
            c6 = 0.56806475f;
            c7 = 0.9350162f;
            c8 = -0.66312265f;
            c9 = -0.46472317f;
            c10 = 0.99270886f;
            c11 = -0.23931566f;
            c12 = -0.82298386f;
        } else if (mu == 5) {
            c1 = -0.7485107f;
            c2 = 0.12053668f;
            c3 = 0.56806475f;
            c4 = -0.97094184f;
            c5 = 0.885456f;
            c6 = -0.3546049f;
            c7 = 0.66312265f;
            c8 = -0.99270886f;
            c9 = 0.82298386f;
            c10 = -0.23931566f;
            c11 = -0.46472317f;
            c12 = 0.9350162f;
        } else if (mu == 6) {
            c1 = -0.97094184f;
            c2 = 0.885456f;
            c3 = -0.7485107f;
            c4 = 0.56806475f;
            c5 = -0.3546049f;
            c6 = 0.12053668f;
            c7 = 0.23931566f;
            c8 = -0.46472317f;
            c9 = 0.66312265f;
            c10 = -0.82298386f;
            c11 = 0.9350162f;
            c12 = -0.99270886f;
        } else if (mu == 7) {
            c1 = -0.97094184f;
            c2 = 0.885456f;
            c3 = -0.7485107f;
            c4 = 0.56806475f;
            c5 = -0.3546049f;
            c6 = 0.12053668f;
            c7 = -0.23931566f;
            c8 = 0.46472317f;
            c9 = -0.66312265f;
            c10 = 0.82298386f;
            c11 = -0.9350162f;
            c12 = 0.99270886f;
        } else if (mu == 8) {
            c1 = -0.7485107f;
            c2 = 0.12053668f;
            c3 = 0.56806475f;
            c4 = -0.97094184f;
            c5 = 0.885456f;
            c6 = -0.3546049f;
            c7 = -0.66312265f;
            c8 = 0.99270886f;
            c9 = -0.82298386f;
            c10 = 0.23931566f;
            c11 = 0.46472317f;
            c12 = -0.9350162f;
        } else if (mu == 9) {
            c1 = -0.3546049f;
            c2 = -0.7485107f;
            c3 = 0.885456f;
            c4 = 0.12053668f;
            c5 = -0.97094184f;
            c6 = 0.56806475f;
            c7 = -0.9350162f;
            c8 = 0.66312265f;
            c9 = 0.46472317f;
            c10 = -0.99270886f;
            c11 = 0.23931566f;
            c12 = 0.82298386f;
        } else if (mu == 10) {
            c1 = 0.12053668f;
            c2 = -0.97094184f;
            c3 = -0.3546049f;
            c4 = 0.885456f;
            c5 = 0.56806475f;
            c6 = -0.7485107f;
            c7 = -0.99270886f;
            c8 = -0.23931566f;
            c9 = 0.9350162f;
            c10 = 0.46472317f;
            c11 = -0.82298386f;
            c12 = -0.66312265f;
        } else if (mu == 11) {
            c1 = 0.56806475f;
            c2 = -0.3546049f;
            c3 = -0.97094184f;
            c4 = -0.7485107f;
            c5 = 0.12053668f;
            c6 = 0.885456f;
            c7 = -0.82298386f;
            c8 = -0.9350162f;
            c9 = -0.23931566f;
            c10 = 0.66312265f;
            c11 = 0.99270886f;
            c12 = 0.46472317f;
        } else {
            c1 = 0.885456f;
            c2 = 0.56806475f;
            c3 = 0.12053668f;
            c4 = -0.3546049f;
            c5 = -0.7485107f;
            c6 = -0.97094184f;
            c7 = -0.46472317f;
            c8 = -0.82298386f;
            c9 = -0.99270886f;
            c10 = -0.9350162f;
            c11 = -0.66312265f;
            c12 = -0.23931566f;
        }
        for (int i = 0; i < m; ++i) {
            float[] zj0r = z[j0];
            float[] zj0i = z[j0 + 1];
            float[] zj1r = z[j1];
            float[] zj1i = z[j1 + 1];
            float[] zj2r = z[j2];
            float[] zj2i = z[j2 + 1];
            float[] zj3r = z[j3];
            float[] zj3i = z[j3 + 1];
            float[] zj4r = z[j4];
            float[] zj4i = z[j4 + 1];
            float[] zj5r = z[j5];
            float[] zj5i = z[j5 + 1];
            float[] zj6r = z[j6];
            float[] zj6i = z[j6 + 1];
            float[] zj7r = z[j7];
            float[] zj7i = z[j7 + 1];
            float[] zj8r = z[j8];
            float[] zj8i = z[j8 + 1];
            float[] zj9r = z[j9];
            float[] zj9i = z[j9 + 1];
            float[] zj10r = z[j10];
            float[] zj10i = z[j10 + 1];
            float[] zj11r = z[j11];
            float[] zj11i = z[j11 + 1];
            float[] zj12r = z[j12];
            float[] zj12i = z[j12 + 1];
            for (int i1 = 0; i1 < n1; ++i1) {
                float t1r = zj1r[i1] + zj12r[i1];
                float t1i = zj1i[i1] + zj12i[i1];
                float t2r = zj2r[i1] + zj11r[i1];
                float t2i = zj2i[i1] + zj11i[i1];
                float t3r = zj3r[i1] + zj10r[i1];
                float t3i = zj3i[i1] + zj10i[i1];
                float t4r = zj4r[i1] + zj9r[i1];
                float t4i = zj4i[i1] + zj9i[i1];
                float t5r = zj5r[i1] + zj8r[i1];
                float t5i = zj5i[i1] + zj8i[i1];
                float t6r = zj6r[i1] + zj7r[i1];
                float t6i = zj6i[i1] + zj7i[i1];
                float t7r = zj1r[i1] - zj12r[i1];
                float t7i = zj1i[i1] - zj12i[i1];
                float t8r = zj2r[i1] - zj11r[i1];
                float t8i = zj2i[i1] - zj11i[i1];
                float t9r = zj3r[i1] - zj10r[i1];
                float t9i = zj3i[i1] - zj10i[i1];
                float t10r = zj4r[i1] - zj9r[i1];
                float t10i = zj4i[i1] - zj9i[i1];
                float t11r = zj5r[i1] - zj8r[i1];
                float t11i = zj5i[i1] - zj8i[i1];
                float t12r = zj6r[i1] - zj7r[i1];
                float t12i = zj6i[i1] - zj7i[i1];
                float t13r = zj0r[i1] - 0.5f * t6r;
                float t13i = zj0i[i1] - 0.5f * t6i;
                float t14r = t1r - t6r;
                float t14i = t1i - t6i;
                float t15r = t2r - t6r;
                float t15i = t2i - t6i;
                float t16r = t3r - t6r;
                float t16i = t3i - t6i;
                float t17r = t4r - t6r;
                float t17i = t4i - t6i;
                float t18r = t5r - t6r;
                float t18i = t5i - t6i;
                float y1r = t13r + c1 * t14r + c2 * t15r + c3 * t16r + c4 * t17r + c5 * t18r;
                float y1i = t13i + c1 * t14i + c2 * t15i + c3 * t16i + c4 * t17i + c5 * t18i;
                float y2r = t13r + c2 * t14r + c4 * t15r + c6 * t16r + c5 * t17r + c3 * t18r;
                float y2i = t13i + c2 * t14i + c4 * t15i + c6 * t16i + c5 * t17i + c3 * t18i;
                float y3r = t13r + c3 * t14r + c6 * t15r + c4 * t16r + c1 * t17r + c2 * t18r;
                float y3i = t13i + c3 * t14i + c6 * t15i + c4 * t16i + c1 * t17i + c2 * t18i;
                float y4r = t13r + c4 * t14r + c5 * t15r + c1 * t16r + c3 * t17r + c6 * t18r;
                float y4i = t13i + c4 * t14i + c5 * t15i + c1 * t16i + c3 * t17i + c6 * t18i;
                float y5r = t13r + c5 * t14r + c3 * t15r + c2 * t16r + c6 * t17r + c1 * t18r;
                float y5i = t13i + c5 * t14i + c3 * t15i + c2 * t16i + c6 * t17i + c1 * t18i;
                float y6r = t13r + c6 * t14r + c1 * t15r + c5 * t16r + c2 * t17r + c4 * t18r;
                float y6i = t13i + c6 * t14i + c1 * t15i + c5 * t16i + c2 * t17i + c4 * t18i;
                float y7r = c12 * t7r - c7 * t8r + c11 * t9r - c8 * t10r + c10 * t11r - c9 * t12r;
                float y7i = c12 * t7i - c7 * t8i + c11 * t9i - c8 * t10i + c10 * t11i - c9 * t12i;
                float y8r = c11 * t7r - c9 * t8r + c8 * t9r - c12 * t10r - c7 * t11r + c10 * t12r;
                float y8i = c11 * t7i - c9 * t8i + c8 * t9i - c12 * t10i - c7 * t11i + c10 * t12i;
                float y9r = c10 * t7r - c11 * t8r - c7 * t9r + c9 * t10r - c12 * t11r - c8 * t12r;
                float y9i = c10 * t7i - c11 * t8i - c7 * t9i + c9 * t10i - c12 * t11i - c8 * t12i;
                float y10r = c9 * t7r + c12 * t8r - c10 * t9r - c7 * t10r + c8 * t11r + c11 * t12r;
                float y10i = c9 * t7i + c12 * t8i - c10 * t9i - c7 * t10i + c8 * t11i + c11 * t12i;
                float y11r = c8 * t7r + c10 * t8r + c12 * t9r - c11 * t10r - c9 * t11r - c7 * t12r;
                float y11i = c8 * t7i + c10 * t8i + c12 * t9i - c11 * t10i - c9 * t11i - c7 * t12i;
                float y12r = c7 * t7r + c8 * t8r + c9 * t9r + c10 * t10r + c11 * t11r + c12 * t12r;
                float y12i = c7 * t7i + c8 * t8i + c9 * t9i + c10 * t10i + c11 * t11i + c12 * t12i;
                zj0r[i1] = zj0r[i1] + t1r + t2r + t3r + t4r + t5r + t6r;
                zj0i[i1] = zj0i[i1] + t1i + t2i + t3i + t4i + t5i + t6i;
                zj1r[i1] = y1r - y12i;
                zj1i[i1] = y1i + y12r;
                zj2r[i1] = y2r - y11i;
                zj2i[i1] = y2i + y11r;
                zj3r[i1] = y3r - y10i;
                zj3i[i1] = y3i + y10r;
                zj4r[i1] = y4r - y9i;
                zj4i[i1] = y4i + y9r;
                zj5r[i1] = y5r - y8i;
                zj5i[i1] = y5i + y8r;
                zj6r[i1] = y6r - y7i;
                zj6i[i1] = y6i + y7r;
                zj7r[i1] = y6r + y7i;
                zj7i[i1] = y6i - y7r;
                zj8r[i1] = y5r + y8i;
                zj8i[i1] = y5i - y8r;
                zj9r[i1] = y4r + y9i;
                zj9i[i1] = y4i - y9r;
                zj10r[i1] = y3r + y10i;
                zj10i[i1] = y3i - y10r;
                zj11r[i1] = y2r + y11i;
                zj11i[i1] = y2i - y11r;
                zj12r[i1] = y1r + y12i;
                zj12i[i1] = y1i - y12r;
            }
            int jt = j12 + 2;
            j12 = j11 + 2;
            j11 = j10 + 2;
            j10 = j9 + 2;
            j9 = j8 + 2;
            j8 = j7 + 2;
            j7 = j6 + 2;
            j6 = j5 + 2;
            j5 = j4 + 2;
            j4 = j3 + 2;
            j3 = j2 + 2;
            j2 = j1 + 2;
            j1 = j0 + 2;
            j0 = jt;
        }
    }

    private static void pfa16b(int n1, float[][] z, int mu, int m, int j0, int j1, int j2, int j3, int j4, int j5, int j6, int j7, int j8, int j9, int j10, int j11, int j12, int j13, int j14, int j15) {
        float c4;
        float c3;
        float c2;
        float c1;
        if (mu == 1) {
            c1 = 1.0f;
            c2 = 0.9238795f;
            c3 = 0.38268343f;
            c4 = 0.70710677f;
        } else if (mu == 3) {
            c1 = -1.0f;
            c2 = 0.38268343f;
            c3 = 0.9238795f;
            c4 = -0.70710677f;
        } else if (mu == 5) {
            c1 = 1.0f;
            c2 = -0.38268343f;
            c3 = 0.9238795f;
            c4 = -0.70710677f;
        } else if (mu == 7) {
            c1 = -1.0f;
            c2 = -0.9238795f;
            c3 = 0.38268343f;
            c4 = 0.70710677f;
        } else if (mu == 9) {
            c1 = 1.0f;
            c2 = -0.9238795f;
            c3 = -0.38268343f;
            c4 = 0.70710677f;
        } else if (mu == 11) {
            c1 = -1.0f;
            c2 = -0.38268343f;
            c3 = -0.9238795f;
            c4 = -0.70710677f;
        } else if (mu == 13) {
            c1 = 1.0f;
            c2 = 0.38268343f;
            c3 = -0.9238795f;
            c4 = -0.70710677f;
        } else {
            c1 = -1.0f;
            c2 = 0.9238795f;
            c3 = -0.38268343f;
            c4 = 0.70710677f;
        }
        float c5 = c1 * c4;
        float c6 = c1 * c3;
        float c7 = c1 * c2;
        for (int i = 0; i < m; ++i) {
            float[] zj0r = z[j0];
            float[] zj0i = z[j0 + 1];
            float[] zj1r = z[j1];
            float[] zj1i = z[j1 + 1];
            float[] zj2r = z[j2];
            float[] zj2i = z[j2 + 1];
            float[] zj3r = z[j3];
            float[] zj3i = z[j3 + 1];
            float[] zj4r = z[j4];
            float[] zj4i = z[j4 + 1];
            float[] zj5r = z[j5];
            float[] zj5i = z[j5 + 1];
            float[] zj6r = z[j6];
            float[] zj6i = z[j6 + 1];
            float[] zj7r = z[j7];
            float[] zj7i = z[j7 + 1];
            float[] zj8r = z[j8];
            float[] zj8i = z[j8 + 1];
            float[] zj9r = z[j9];
            float[] zj9i = z[j9 + 1];
            float[] zj10r = z[j10];
            float[] zj10i = z[j10 + 1];
            float[] zj11r = z[j11];
            float[] zj11i = z[j11 + 1];
            float[] zj12r = z[j12];
            float[] zj12i = z[j12 + 1];
            float[] zj13r = z[j13];
            float[] zj13i = z[j13 + 1];
            float[] zj14r = z[j14];
            float[] zj14i = z[j14 + 1];
            float[] zj15r = z[j15];
            float[] zj15i = z[j15 + 1];
            for (int i1 = 0; i1 < n1; ++i1) {
                float t1r = zj0r[i1] + zj8r[i1];
                float t1i = zj0i[i1] + zj8i[i1];
                float t2r = zj4r[i1] + zj12r[i1];
                float t2i = zj4i[i1] + zj12i[i1];
                float t3r = zj0r[i1] - zj8r[i1];
                float t3i = zj0i[i1] - zj8i[i1];
                float t4r = c1 * (zj4r[i1] - zj12r[i1]);
                float t4i = c1 * (zj4i[i1] - zj12i[i1]);
                float t5r = t1r + t2r;
                float t5i = t1i + t2i;
                float t6r = t1r - t2r;
                float t6i = t1i - t2i;
                float t7r = zj1r[i1] + zj9r[i1];
                float t7i = zj1i[i1] + zj9i[i1];
                float t8r = zj5r[i1] + zj13r[i1];
                float t8i = zj5i[i1] + zj13i[i1];
                float t9r = zj1r[i1] - zj9r[i1];
                float t9i = zj1i[i1] - zj9i[i1];
                float t10r = zj5r[i1] - zj13r[i1];
                float t10i = zj5i[i1] - zj13i[i1];
                float t11r = t7r + t8r;
                float t11i = t7i + t8i;
                float t12r = t7r - t8r;
                float t12i = t7i - t8i;
                float t13r = zj2r[i1] + zj10r[i1];
                float t13i = zj2i[i1] + zj10i[i1];
                float t14r = zj6r[i1] + zj14r[i1];
                float t14i = zj6i[i1] + zj14i[i1];
                float t15r = zj2r[i1] - zj10r[i1];
                float t15i = zj2i[i1] - zj10i[i1];
                float t16r = zj6r[i1] - zj14r[i1];
                float t16i = zj6i[i1] - zj14i[i1];
                float t17r = t13r + t14r;
                float t17i = t13i + t14i;
                float t18r = c4 * (t15r - t16r);
                float t18i = c4 * (t15i - t16i);
                float t19r = c5 * (t15r + t16r);
                float t19i = c5 * (t15i + t16i);
                float t20r = c1 * (t13r - t14r);
                float t20i = c1 * (t13i - t14i);
                float t21r = zj3r[i1] + zj11r[i1];
                float t21i = zj3i[i1] + zj11i[i1];
                float t22r = zj7r[i1] + zj15r[i1];
                float t22i = zj7i[i1] + zj15i[i1];
                float t23r = zj3r[i1] - zj11r[i1];
                float t23i = zj3i[i1] - zj11i[i1];
                float t24r = zj7r[i1] - zj15r[i1];
                float t24i = zj7i[i1] - zj15i[i1];
                float t25r = t21r + t22r;
                float t25i = t21i + t22i;
                float t26r = t21r - t22r;
                float t26i = t21i - t22i;
                float t27r = t9r + t24r;
                float t27i = t9i + t24i;
                float t28r = t10r + t23r;
                float t28i = t10i + t23i;
                float t29r = t9r - t24r;
                float t29i = t9i - t24i;
                float t30r = t10r - t23r;
                float t30i = t10i - t23i;
                float t31r = t5r + t17r;
                float t31i = t5i + t17i;
                float t32r = t11r + t25r;
                float t32i = t11i + t25i;
                float t33r = t3r + t18r;
                float t33i = t3i + t18i;
                float t34r = c2 * t29r - c6 * t30r;
                float t34i = c2 * t29i - c6 * t30i;
                float t35r = t3r - t18r;
                float t35i = t3i - t18i;
                float t36r = c7 * t27r - c3 * t28r;
                float t36i = c7 * t27i - c3 * t28i;
                float t37r = t4r + t19r;
                float t37i = t4i + t19i;
                float t38r = c3 * t27r + c7 * t28r;
                float t38i = c3 * t27i + c7 * t28i;
                float t39r = t4r - t19r;
                float t39i = t4i - t19i;
                float t40r = c6 * t29r + c2 * t30r;
                float t40i = c6 * t29i + c2 * t30i;
                float t41r = c4 * (t12r - t26r);
                float t41i = c4 * (t12i - t26i);
                float t42r = c5 * (t12r + t26r);
                float t42i = c5 * (t12i + t26i);
                float y1r = t33r + t34r;
                float y1i = t33i + t34i;
                float y2r = t6r + t41r;
                float y2i = t6i + t41i;
                float y3r = t35r + t40r;
                float y3i = t35i + t40i;
                float y4r = t5r - t17r;
                float y4i = t5i - t17i;
                float y5r = t35r - t40r;
                float y5i = t35i - t40i;
                float y6r = t6r - t41r;
                float y6i = t6i - t41i;
                float y7r = t33r - t34r;
                float y7i = t33i - t34i;
                float y9r = t38r - t37r;
                float y9i = t38i - t37i;
                float y10r = t42r - t20r;
                float y10i = t42i - t20i;
                float y11r = t36r + t39r;
                float y11i = t36i + t39i;
                float y12r = c1 * (t11r - t25r);
                float y12i = c1 * (t11i - t25i);
                float y13r = t36r - t39r;
                float y13i = t36i - t39i;
                float y14r = t42r + t20r;
                float y14i = t42i + t20i;
                float y15r = t38r + t37r;
                float y15i = t38i + t37i;
                zj0r[i1] = t31r + t32r;
                zj0i[i1] = t31i + t32i;
                zj1r[i1] = y1r - y15i;
                zj1i[i1] = y1i + y15r;
                zj2r[i1] = y2r - y14i;
                zj2i[i1] = y2i + y14r;
                zj3r[i1] = y3r - y13i;
                zj3i[i1] = y3i + y13r;
                zj4r[i1] = y4r - y12i;
                zj4i[i1] = y4i + y12r;
                zj5r[i1] = y5r - y11i;
                zj5i[i1] = y5i + y11r;
                zj6r[i1] = y6r - y10i;
                zj6i[i1] = y6i + y10r;
                zj7r[i1] = y7r - y9i;
                zj7i[i1] = y7i + y9r;
                zj8r[i1] = t31r - t32r;
                zj8i[i1] = t31i - t32i;
                zj9r[i1] = y7r + y9i;
                zj9i[i1] = y7i - y9r;
                zj10r[i1] = y6r + y10i;
                zj10i[i1] = y6i - y10r;
                zj11r[i1] = y5r + y11i;
                zj11i[i1] = y5i - y11r;
                zj12r[i1] = y4r + y12i;
                zj12i[i1] = y4i - y12r;
                zj13r[i1] = y3r + y13i;
                zj13i[i1] = y3i - y13r;
                zj14r[i1] = y2r + y14i;
                zj14i[i1] = y2i - y14r;
                zj15r[i1] = y1r + y15i;
                zj15i[i1] = y1i - y15r;
            }
            int jt = j15 + 2;
            j15 = j14 + 2;
            j14 = j13 + 2;
            j13 = j12 + 2;
            j12 = j11 + 2;
            j11 = j10 + 2;
            j10 = j9 + 2;
            j9 = j8 + 2;
            j8 = j7 + 2;
            j7 = j6 + 2;
            j6 = j5 + 2;
            j5 = j4 + 2;
            j4 = j3 + 2;
            j3 = j2 + 2;
            j2 = j1 + 2;
            j1 = j0 + 2;
            j0 = jt;
        }
    }
}

