/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.Eigen;
import edu.mines.jtk.dsp.RecursiveGaussianFilter;
import edu.mines.jtk.util.Array;
import edu.mines.jtk.util.MathPlus;

public class LocalOrientFilter {
    private double _sigma;
    private RecursiveGaussianFilter _rgfGradient;
    private RecursiveGaussianFilter _rgfSmoother;

    public LocalOrientFilter(double sigma) {
        this._sigma = sigma;
        this._rgfGradient = new RecursiveGaussianFilter(1.0);
        this._rgfSmoother = new RecursiveGaussianFilter(sigma);
    }

    public void applyForTheta(float[][] x, float[][] theta) {
        this.apply(x, theta, null, null, null, null, null, null, null);
    }

    public void applyForNormal(float[][] x, float[][] u1, float[][] u2) {
        this.apply(x, null, u1, u2, null, null, null, null, null);
    }

    public void applyForNormalLinear(float[][] x, float[][] u1, float[][] u2, float[][] el) {
        this.apply(x, null, u1, u2, null, null, null, null, el);
    }

    public void apply(float[][] x, float[][] theta, float[][] u1, float[][] u2, float[][] v1, float[][] v2, float[][] eu, float[][] ev, float[][] el) {
        float[][][] gs;
        float[][][] t = new float[8][][];
        int nt = 0;
        if (theta != null) {
            t[nt++] = theta;
        }
        if (u1 != null) {
            t[nt++] = u1;
        }
        if (u2 != null) {
            t[nt++] = u2;
        }
        if (v1 != null) {
            t[nt++] = v1;
        }
        if (v2 != null) {
            t[nt++] = v2;
        }
        if (eu != null) {
            t[nt++] = eu;
        }
        if (ev != null) {
            t[nt++] = ev;
        }
        if (el != null) {
            t[nt++] = el;
        }
        int n1 = x[0].length;
        int n2 = x.length;
        float[][] g1 = nt > 0 ? t[0] : new float[n2][n1];
        float[][] g2 = nt > 1 ? t[1] : new float[n2][n1];
        this._rgfGradient.apply1X(x, g1);
        this._rgfGradient.applyX1(x, g2);
        float[][] g11 = g1;
        float[][] g22 = g2;
        float[][] g12 = nt > 2 ? t[2] : new float[n2][n1];
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                float g1i = g1[i2][i1];
                float g2i = g2[i2][i1];
                g11[i2][i1] = g1i * g1i;
                g22[i2][i1] = g2i * g2i;
                g12[i2][i1] = g1i * g2i;
            }
        }
        float[][] h = nt > 3 ? t[3] : new float[n2][n1];
        for (float[][] g : gs = new float[][][]{g11, g22, g12}) {
            this._rgfSmoother.apply0X(g, h);
            this._rgfSmoother.applyX0(h, g);
        }
        float[][] a = new float[2][2];
        float[][] z = new float[2][2];
        float[] e = new float[2];
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                a[0][0] = g11[i2][i1];
                a[0][1] = g12[i2][i1];
                a[1][0] = g12[i2][i1];
                a[1][1] = g22[i2][i1];
                Eigen.solveSymmetric22(a, z, e);
                float u1i = z[0][0];
                float u2i = z[0][1];
                if (u1i < 0.0f) {
                    u1i = -u1i;
                    u2i = -u2i;
                }
                float v1i = -u2i;
                float v2i = u1i;
                float eui = e[0];
                float evi = e[1];
                if (theta != null) {
                    theta[i2][i1] = MathPlus.asin(u2i);
                }
                if (u1 != null) {
                    u1[i2][i1] = u1i;
                }
                if (u2 != null) {
                    u2[i2][i1] = u2i;
                }
                if (v1 != null) {
                    v1[i2][i1] = v1i;
                }
                if (v2 != null) {
                    v2[i2][i1] = v2i;
                }
                if (eu != null) {
                    eu[i2][i1] = eui;
                }
                if (ev != null) {
                    ev[i2][i1] = evi;
                }
                if (el == null) continue;
                el[i2][i1] = (eui - evi) / (eui + evi);
            }
        }
    }

    public void applyForThetaPhi(float[][][] x, float[][][] theta, float[][][] phi) {
        this.apply(x, theta, phi, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public void applyForNormal(float[][][] x, float[][][] u1, float[][][] u2, float[][][] u3) {
        this.apply(x, null, null, u1, u2, u3, null, null, null, null, null, null, null, null, null, null, null);
    }

    public void applyForNormalPlanar(float[][][] x, float[][][] u1, float[][][] u2, float[][][] u3, float[][][] ep) {
        this.apply(x, null, null, u1, u2, u3, null, null, null, null, null, null, null, null, null, ep, null);
    }

    public void applyForInline(float[][][] x, float[][][] w1, float[][][] w2, float[][][] w3) {
        this.apply(x, null, null, null, null, null, null, null, null, w1, w2, w3, null, null, null, null, null);
    }

    public void applyForInlineLinear(float[][][] x, float[][][] w1, float[][][] w2, float[][][] w3, float[][][] el) {
        this.apply(x, null, null, null, null, null, null, null, null, w1, w2, w3, null, null, null, null, el);
    }

    public void apply(float[][][] x, float[][][] theta, float[][][] phi, float[][][] u1, float[][][] u2, float[][][] u3, float[][][] v1, float[][][] v2, float[][][] v3, float[][][] w1, float[][][] w2, float[][][] w3, float[][][] eu, float[][][] ev, float[][][] ew, float[][][] ep, float[][][] el) {
        float[][][][] gs;
        float[][][][] t = new float[16][][][];
        int nt = 0;
        if (theta != null) {
            t[nt++] = theta;
        }
        if (phi != null) {
            t[nt++] = phi;
        }
        if (u1 != null) {
            t[nt++] = u1;
        }
        if (u2 != null) {
            t[nt++] = u2;
        }
        if (u3 != null) {
            t[nt++] = u3;
        }
        if (v1 != null) {
            t[nt++] = v1;
        }
        if (v2 != null) {
            t[nt++] = v2;
        }
        if (v3 != null) {
            t[nt++] = v3;
        }
        if (w1 != null) {
            t[nt++] = w1;
        }
        if (w2 != null) {
            t[nt++] = w2;
        }
        if (w3 != null) {
            t[nt++] = w3;
        }
        if (eu != null) {
            t[nt++] = eu;
        }
        if (ev != null) {
            t[nt++] = ev;
        }
        if (ew != null) {
            t[nt++] = ew;
        }
        if (ep != null) {
            t[nt++] = ep;
        }
        if (el != null) {
            t[nt++] = el;
        }
        int n1 = x[0][0].length;
        int n2 = x[0].length;
        int n3 = x.length;
        float[][][] g1 = nt > 0 ? t[0] : new float[n3][n2][n1];
        float[][][] g2 = nt > 1 ? t[1] : new float[n3][n2][n1];
        float[][][] g3 = nt > 2 ? t[2] : new float[n3][n2][n1];
        this._rgfGradient.apply1XX(x, g1);
        this._rgfGradient.applyX1X(x, g2);
        this._rgfGradient.applyXX1(x, g3);
        float[][][] g11 = g1;
        float[][][] g22 = g2;
        float[][][] g33 = g3;
        float[][][] g12 = nt > 3 ? t[3] : new float[n3][n2][n1];
        float[][][] g13 = nt > 4 ? t[4] : new float[n3][n2][n1];
        float[][][] g23 = nt > 5 ? t[5] : new float[n3][n2][n1];
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    float g1i = g1[i3][i2][i1];
                    float g2i = g2[i3][i2][i1];
                    float g3i = g3[i3][i2][i1];
                    g11[i3][i2][i1] = g1i * g1i;
                    g22[i3][i2][i1] = g2i * g2i;
                    g33[i3][i2][i1] = g3i * g3i;
                    g12[i3][i2][i1] = g1i * g2i;
                    g13[i3][i2][i1] = g1i * g3i;
                    g23[i3][i2][i1] = g2i * g3i;
                }
            }
        }
        float[][][] h = nt > 6 ? t[6] : new float[n3][n2][n1];
        for (float[][][] g : gs = new float[][][][]{g11, g22, g33, g12, g13, g23}) {
            this._rgfSmoother.apply0XX(g, h);
            this._rgfSmoother.applyX0X(h, g);
            this._rgfSmoother.applyXX0(g, h);
            Array.copy(h, g);
        }
        float[][] a = new float[3][3];
        float[][] z = new float[3][3];
        float[] e = new float[3];
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    a[0][0] = g11[i3][i2][i1];
                    a[0][1] = g12[i3][i2][i1];
                    a[0][2] = g13[i3][i2][i1];
                    a[1][0] = g12[i3][i2][i1];
                    a[1][1] = g22[i3][i2][i1];
                    a[1][2] = g23[i3][i2][i1];
                    a[2][0] = g13[i3][i2][i1];
                    a[2][1] = g23[i3][i2][i1];
                    a[2][2] = g33[i3][i2][i1];
                    Eigen.solveSymmetric33(a, z, e);
                    float u1i = z[0][0];
                    float u2i = z[0][1];
                    float u3i = z[0][2];
                    float v1i = z[1][0];
                    float v2i = z[1][1];
                    float v3i = z[1][2];
                    if (u1i < 0.0f) {
                        u1i = -u1i;
                        u2i = -u2i;
                        u3i = -u3i;
                    }
                    if (v2i < 0.0f) {
                        v1i = -v1i;
                        v2i = -v2i;
                        v3i = -v3i;
                    }
                    float w1i = u2i * v3i - u3i * v2i;
                    float w2i = u3i * v1i - u1i * v3i;
                    float w3i = u1i * v2i - u2i * v1i;
                    float eui = e[0];
                    float evi = e[1];
                    float ewi = e[2];
                    if (theta != null) {
                        theta[i3][i2][i1] = MathPlus.acos(u1i);
                    }
                    if (phi != null) {
                        phi[i3][i2][i1] = MathPlus.atan2(u3i, u2i);
                    }
                    if (u1 != null) {
                        u1[i3][i2][i1] = u1i;
                    }
                    if (u2 != null) {
                        u2[i3][i2][i1] = u2i;
                    }
                    if (u3 != null) {
                        u3[i3][i2][i1] = u3i;
                    }
                    if (v1 != null) {
                        v1[i3][i2][i1] = v1i;
                    }
                    if (v2 != null) {
                        v2[i3][i2][i1] = v2i;
                    }
                    if (v3 != null) {
                        v3[i3][i2][i1] = v3i;
                    }
                    if (w1 != null) {
                        w1[i3][i2][i1] = w1i;
                    }
                    if (w2 != null) {
                        w2[i3][i2][i1] = w2i;
                    }
                    if (w3 != null) {
                        w3[i3][i2][i1] = w3i;
                    }
                    if (eu != null) {
                        eu[i3][i2][i1] = eui;
                    }
                    if (ev != null) {
                        ev[i3][i2][i1] = evi;
                    }
                    if (ew != null) {
                        ew[i3][i2][i1] = ewi;
                    }
                    if (ep == null && el == null) continue;
                    float esi = 1.0f / (eui + ewi);
                    if (ep != null) {
                        ep[i3][i2][i1] = (eui - evi) * esi;
                    }
                    if (el == null) continue;
                    el[i3][i2][i1] = (evi - ewi) * esi;
                }
            }
        }
    }
}

