/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.RecursiveGaussianFilter;
import edu.mines.jtk.util.Array;
import edu.mines.jtk.util.Check;
import edu.mines.jtk.util.MathPlus;
import java.util.concurrent.atomic.AtomicInteger;

public class LocalCorrelationFilter {
    private static final float C00 = 0.0f;
    private static final float C11 = 1.0f;
    private static final float C12 = 0.5f;
    private static final float C13 = 0.33333334f;
    private static final float C14 = 0.25f;
    private static final float C16 = 0.16666667f;
    private static final float C19 = 0.11111111f;
    private static final float C29 = 0.22222222f;
    private static final float C59 = 0.5555556f;
    private static final float C000 = 0.0f;
    private static final float C109 = 0.11111111f;
    private static final float C112 = 0.083333336f;
    private static final float C118 = 0.055555556f;
    private static final float C127 = 0.037037037f;
    private static final float C227 = 0.074074075f;
    private static final float C427 = 0.14814815f;
    private static final float C727 = 0.25925925f;
    private static final float[][] C1 = new float[][]{{0.0f, -0.5f, 0.5f}, {1.0f, 0.0f, -1.0f}, {0.0f, 0.5f, 0.5f}};
    private static final float[][] C2 = new float[][]{{-0.11111111f, -0.16666667f, -0.16666667f, 0.25f, 0.16666667f, 0.16666667f}, {0.22222222f, 0.0f, -0.16666667f, 0.0f, -0.33333334f, 0.16666667f}, {-0.11111111f, 0.16666667f, -0.16666667f, -0.25f, 0.16666667f, 0.16666667f}, {0.22222222f, -0.16666667f, 0.0f, 0.0f, 0.16666667f, -0.33333334f}, {0.5555556f, 0.0f, 0.0f, 0.0f, -0.33333334f, -0.33333334f}, {0.22222222f, 0.16666667f, 0.0f, 0.0f, 0.16666667f, -0.33333334f}, {-0.11111111f, -0.16666667f, 0.16666667f, -0.25f, 0.16666667f, 0.16666667f}, {0.22222222f, 0.0f, 0.16666667f, 0.0f, -0.33333334f, 0.16666667f}, {-0.11111111f, 0.16666667f, 0.16666667f, 0.25f, 0.16666667f, 0.16666667f}};
    private static final float[][] C3 = new float[][]{{-0.074074075f, -0.055555556f, -0.055555556f, -0.055555556f, 0.083333336f, 0.083333336f, 0.083333336f, 0.055555556f, 0.055555556f, 0.055555556f}, {0.037037037f, 0.0f, -0.055555556f, -0.055555556f, 0.0f, 0.0f, 0.083333336f, -0.11111111f, 0.055555556f, 0.055555556f}, {-0.074074075f, 0.055555556f, -0.055555556f, -0.055555556f, -0.083333336f, -0.083333336f, 0.083333336f, 0.055555556f, 0.055555556f, 0.055555556f}, {0.037037037f, -0.055555556f, 0.0f, -0.055555556f, 0.0f, 0.083333336f, 0.0f, 0.055555556f, -0.11111111f, 0.055555556f}, {0.14814815f, 0.0f, 0.0f, -0.055555556f, 0.0f, 0.0f, 0.0f, -0.11111111f, -0.11111111f, 0.055555556f}, {0.037037037f, 0.055555556f, 0.0f, -0.055555556f, 0.0f, -0.083333336f, 0.0f, 0.055555556f, -0.11111111f, 0.055555556f}, {-0.074074075f, -0.055555556f, 0.055555556f, -0.055555556f, -0.083333336f, 0.083333336f, -0.083333336f, 0.055555556f, 0.055555556f, 0.055555556f}, {0.037037037f, 0.0f, 0.055555556f, -0.055555556f, 0.0f, 0.0f, -0.083333336f, -0.11111111f, 0.055555556f, 0.055555556f}, {-0.074074075f, 0.055555556f, 0.055555556f, -0.055555556f, 0.083333336f, -0.083333336f, -0.083333336f, 0.055555556f, 0.055555556f, 0.055555556f}, {0.037037037f, -0.055555556f, -0.055555556f, 0.0f, 0.083333336f, 0.0f, 0.0f, 0.055555556f, 0.055555556f, -0.11111111f}, {0.14814815f, 0.0f, -0.055555556f, 0.0f, 0.0f, 0.0f, 0.0f, -0.11111111f, 0.055555556f, -0.11111111f}, {0.037037037f, 0.055555556f, -0.055555556f, 0.0f, -0.083333336f, 0.0f, 0.0f, 0.055555556f, 0.055555556f, -0.11111111f}, {0.14814815f, -0.055555556f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.055555556f, -0.11111111f, -0.11111111f}, {0.25925925f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -0.11111111f, -0.11111111f, -0.11111111f}, {0.14814815f, 0.055555556f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.055555556f, -0.11111111f, -0.11111111f}, {0.037037037f, -0.055555556f, 0.055555556f, 0.0f, -0.083333336f, 0.0f, 0.0f, 0.055555556f, 0.055555556f, -0.11111111f}, {0.14814815f, 0.0f, 0.055555556f, 0.0f, 0.0f, 0.0f, 0.0f, -0.11111111f, 0.055555556f, -0.11111111f}, {0.037037037f, 0.055555556f, 0.055555556f, 0.0f, 0.083333336f, 0.0f, 0.0f, 0.055555556f, 0.055555556f, -0.11111111f}, {-0.074074075f, -0.055555556f, -0.055555556f, 0.055555556f, 0.083333336f, -0.083333336f, -0.083333336f, 0.055555556f, 0.055555556f, 0.055555556f}, {0.037037037f, 0.0f, -0.055555556f, 0.055555556f, 0.0f, 0.0f, -0.083333336f, -0.11111111f, 0.055555556f, 0.055555556f}, {-0.074074075f, 0.055555556f, -0.055555556f, 0.055555556f, -0.083333336f, 0.083333336f, -0.083333336f, 0.055555556f, 0.055555556f, 0.055555556f}, {0.037037037f, -0.055555556f, 0.0f, 0.055555556f, 0.0f, -0.083333336f, 0.0f, 0.055555556f, -0.11111111f, 0.055555556f}, {0.14814815f, 0.0f, 0.0f, 0.055555556f, 0.0f, 0.0f, 0.0f, -0.11111111f, -0.11111111f, 0.055555556f}, {0.037037037f, 0.055555556f, 0.0f, 0.055555556f, 0.0f, 0.083333336f, 0.0f, 0.055555556f, -0.11111111f, 0.055555556f}, {-0.074074075f, -0.055555556f, 0.055555556f, 0.055555556f, -0.083333336f, -0.083333336f, 0.083333336f, 0.055555556f, 0.055555556f, 0.055555556f}, {0.037037037f, 0.0f, 0.055555556f, 0.055555556f, 0.0f, 0.0f, 0.083333336f, -0.11111111f, 0.055555556f, 0.055555556f}, {-0.074074075f, 0.055555556f, 0.055555556f, 0.055555556f, 0.083333336f, 0.083333336f, 0.083333336f, 0.055555556f, 0.055555556f, 0.055555556f}};
    private double _sigma1;
    private double _sigma2;
    private double _sigma3;
    private RecursiveGaussianFilter _rgf1;
    private RecursiveGaussianFilter _rgf2;
    private RecursiveGaussianFilter _rgf3;
    private static float S1 = 0.615728f;
    private static float S2 = -0.1558022f;
    private static float S3 = 0.0509014f;
    private static float S4 = -0.0115417f;
    private static float[] S = new float[]{S4, S3, S2, S1, S1, S2, S3, S4};

    public LocalCorrelationFilter(double sigma) {
        this(sigma, sigma, sigma);
    }

    public LocalCorrelationFilter(double sigma1, double sigma2) {
        this(sigma1, sigma2, sigma2);
    }

    public LocalCorrelationFilter(double sigma1, double sigma2, double sigma3) {
        Check.argument(sigma1 >= 1.0, "sigma1>=1.0");
        Check.argument(sigma2 >= 1.0, "sigma2>=1.0");
        Check.argument(sigma3 >= 1.0, "sigma3>=1.0");
        this._sigma1 = sigma1;
        this._sigma2 = sigma2;
        this._sigma3 = sigma3;
        this._rgf1 = new RecursiveGaussianFilter(sigma1 / MathPlus.sqrt(2.0));
        this._rgf2 = new RecursiveGaussianFilter(sigma2 / MathPlus.sqrt(2.0));
        this._rgf3 = new RecursiveGaussianFilter(sigma3 / MathPlus.sqrt(2.0));
    }

    public void apply(int lag, float[] f, float[] g, float[] c) {
        Check.argument(f != c, "f!=c");
        Check.argument(g != c, "g!=c");
        int n1 = f.length;
        int l1 = lag;
        int l1f = l1 >= 0 ? (l1 + 0) / 2 : (l1 - 1) / 2;
        int l1g = l1 >= 0 ? (l1 + 1) / 2 : (l1 + 0) / 2;
        double scale1 = MathPlus.sqrt(Math.PI) * this._sigma1 * MathPlus.exp(-0.25 * (double)l1 * (double)l1 / (this._sigma1 * this._sigma1));
        float scale = (float)scale1;
        int i1min = MathPlus.max(MathPlus.abs(l1f), MathPlus.abs(l1g));
        int i1max = n1 - i1min;
        float[] h = new float[n1];
        for (int i1 = i1min; i1 < i1max; ++i1) {
            c[i1] = scale * f[i1 - l1f] * g[i1 + l1g];
        }
        if (l1f != l1g) {
            LocalCorrelationFilter.shift(c, h);
        } else {
            Array.copy(c, h);
        }
        this._rgf1.apply0(h, c);
    }

    public void apply(int lag1, int lag2, float[][] f, float[][] g, float[][] c) {
        Check.argument(f != c, "f!=c");
        Check.argument(g != c, "g!=c");
        int n1 = f[0].length;
        int l1 = lag1;
        int l1f = l1 >= 0 ? (l1 + 0) / 2 : (l1 - 1) / 2;
        int l1g = l1 >= 0 ? (l1 + 1) / 2 : (l1 + 0) / 2;
        int n2 = f.length;
        int l2 = lag2;
        int l2f = l2 >= 0 ? (l2 + 0) / 2 : (l2 - 1) / 2;
        int l2g = l2 >= 0 ? (l2 + 1) / 2 : (l2 + 0) / 2;
        double scale1 = MathPlus.sqrt(Math.PI) * this._sigma1 * MathPlus.exp(-0.25 * (double)l1 * (double)l1 / (this._sigma1 * this._sigma1));
        double scale2 = MathPlus.sqrt(Math.PI) * this._sigma2 * MathPlus.exp(-0.25 * (double)l2 * (double)l2 / (this._sigma2 * this._sigma2));
        float scale = (float)(scale1 * scale2);
        int i1min = MathPlus.max(MathPlus.abs(l1f), MathPlus.abs(l1g));
        int i1max = n1 - i1min;
        int i2min = MathPlus.max(MathPlus.abs(l2f), MathPlus.abs(l2g));
        int i2max = n2 - i2min;
        float[][] h = new float[n2][n1];
        for (int i2 = i2min; i2 < i2max; ++i2) {
            float[] f2 = f[i2 - l2f];
            float[] g2 = g[i2 + l2g];
            float[] c2 = c[i2];
            for (int i1 = i1min; i1 < i1max; ++i1) {
                c2[i1] = scale * f2[i1 - l1f] * g2[i1 + l1g];
            }
        }
        if (l1f != l1g) {
            LocalCorrelationFilter.shift1(c, h);
        } else {
            Array.copy(c, h);
        }
        if (l2f != l2g) {
            LocalCorrelationFilter.shift2(h, c);
        } else {
            Array.copy(h, c);
        }
        this._rgf1.apply0X(c, h);
        this._rgf2.applyX0(h, c);
    }

    public void apply(int lag1, int lag2, int lag3, float[][][] f, float[][][] g, float[][][] c) {
        Check.argument(f != c, "f!=c");
        Check.argument(g != c, "g!=c");
        int n1 = f[0][0].length;
        int l1 = lag1;
        int l1f = l1 >= 0 ? (l1 + 0) / 2 : (l1 - 1) / 2;
        int l1g = l1 >= 0 ? (l1 + 1) / 2 : (l1 + 0) / 2;
        int n2 = f[0].length;
        int l2 = lag2;
        int l2f = l2 >= 0 ? (l2 + 0) / 2 : (l2 - 1) / 2;
        int l2g = l2 >= 0 ? (l2 + 1) / 2 : (l2 + 0) / 2;
        int n3 = f.length;
        int l3 = lag3;
        int l3f = l3 >= 0 ? (l3 + 0) / 2 : (l3 - 1) / 2;
        int l3g = l3 >= 0 ? (l3 + 1) / 2 : (l3 + 0) / 2;
        double scale1 = MathPlus.sqrt(Math.PI) * this._sigma1 * MathPlus.exp(-0.25 * (double)l1 * (double)l1 / (this._sigma1 * this._sigma1));
        double scale2 = MathPlus.sqrt(Math.PI) * this._sigma2 * MathPlus.exp(-0.25 * (double)l2 * (double)l2 / (this._sigma2 * this._sigma2));
        double scale3 = MathPlus.sqrt(Math.PI) * this._sigma3 * MathPlus.exp(-0.25 * (double)l3 * (double)l3 / (this._sigma3 * this._sigma3));
        float scale = (float)(scale1 * scale2 * scale3);
        int i1min = MathPlus.max(MathPlus.abs(l1f), MathPlus.abs(l1g));
        int i1max = n1 - i1min;
        int i2min = MathPlus.max(MathPlus.abs(l2f), MathPlus.abs(l2g));
        int i2max = n2 - i2min;
        int i3min = MathPlus.max(MathPlus.abs(l3f), MathPlus.abs(l3g));
        int i3max = n3 - i3min;
        float[][][] h = new float[n3][n2][n1];
        for (int i3 = i3min; i3 < i3max; ++i3) {
            for (int i2 = i2min; i2 < i2max; ++i2) {
                float[] f32 = f[i3 - l3f][i2 - l2f];
                float[] g32 = g[i3 + l3g][i2 + l2g];
                float[] c32 = c[i3][i2];
                for (int i1 = i1min; i1 < i1max; ++i1) {
                    c32[i1] = scale * f32[i1 - l1f] * g32[i1 + l1g];
                }
            }
        }
        if (l1f != l1g) {
            LocalCorrelationFilter.shift1(c, h);
        } else {
            Array.copy(c, h);
        }
        if (l2f != l2g) {
            LocalCorrelationFilter.shift2(h, c);
        } else {
            Array.copy(h, c);
        }
        if (l3f != l3g) {
            LocalCorrelationFilter.shift3(c, h);
        } else {
            Array.copy(c, h);
        }
        this._rgf1.apply0XX(h, c);
        this._rgf2.applyX0X(c, h);
        this._rgf3.applyXX0(h, c);
    }

    public void apply(int l1min, int l1max, int j1c, int k1c, float[] f, float[] g, float[][] c) {
        int n1f = f.length;
        int n1c = c.length;
        float[] t = new float[n1f];
        for (int l1 = l1min; l1 <= l1max; ++l1) {
            this.apply(l1, f, g, t);
            for (int i1c = 0; i1c < n1c; ++i1c) {
                c[i1c][l1 - l1min] = t[j1c + i1c * k1c];
            }
        }
    }

    public void findMaxLags(float[] f, float[] g, int min, int max, byte[] lag) {
        int n = f.length;
        for (int i = 0; i < n; ++i) {
            lag[i] = 0;
        }
        float[] c = new float[n];
        float[] cmax = new float[n];
        for (int i = 0; i < n; ++i) {
            cmax[i] = -3.4028235E38f;
        }
        Lags lags = new Lags(min, max);
        int l = (min + max) / 2;
        boolean done = false;
        while (!done) {
            int[] ls;
            this.apply(l, f, g, c);
            lags.markLag(l);
            boolean foundMax = false;
            for (int i = 0; i < n; ++i) {
                float ci = c[i];
                if (!(ci > cmax[i])) continue;
                cmax[i] = ci;
                lag[i] = (byte)l;
                foundMax = true;
            }
            if (foundMax) {
                lags.markMax(l);
            }
            if ((ls = lags.nextLag()) == null) {
                done = true;
                continue;
            }
            l = ls[0];
        }
    }

    public void findMaxLags(float[][] f, float[][] g, int min1, int max1, int min2, int max2, byte[][] lag1, byte[][] lag2) {
        int n1 = f[0].length;
        int n2 = f.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                lag1[i2][i1] = 0;
                lag2[i2][i1] = 0;
            }
        }
        float[][] c = new float[n2][n1];
        float[][] cmax = new float[n2][n1];
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                cmax[i2][i1] = -3.4028235E38f;
            }
        }
        Lags lags = new Lags(min1, max1, min2, max2);
        int l1 = (min1 + max1) / 2;
        int l2 = (min2 + max2) / 2;
        boolean done = false;
        while (!done) {
            int[] ls;
            this.apply(l1, l2, f, g, c);
            lags.markLag(l1, l2);
            boolean foundMax = false;
            for (int i2 = 0; i2 < n2; ++i2) {
                float[] c2 = c[i2];
                float[] cmax2 = cmax[i2];
                for (int i1 = 0; i1 < n1; ++i1) {
                    float ci = c2[i1];
                    if (!(ci > cmax2[i1])) continue;
                    cmax[i2][i1] = ci;
                    lag1[i2][i1] = (byte)l1;
                    lag2[i2][i1] = (byte)l2;
                    foundMax = true;
                }
            }
            if (foundMax) {
                lags.markMax(l1, l2);
            }
            if ((ls = lags.nextLag()) == null) {
                done = true;
                continue;
            }
            l1 = ls[0];
            l2 = ls[1];
        }
    }

    public void findMaxLags(float[][][] f, float[][][] g, int min1, int max1, int min2, int max2, int min3, int max3, byte[][][] lag1, byte[][][] lag2, byte[][][] lag3) {
        int n1 = f[0][0].length;
        int n2 = f[0].length;
        int n3 = f.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    lag1[i3][i2][i1] = 0;
                    lag2[i3][i2][i1] = 0;
                    lag3[i3][i2][i1] = 0;
                }
            }
        }
        float[][][] c = new float[n3][n2][n1];
        float[][][] cmax = new float[n3][n2][n1];
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    cmax[i3][i2][i1] = -3.4028235E38f;
                }
            }
        }
        Lags lags = new Lags(min1, max1, min2, max2, min3, max3);
        int l1 = (min1 + max1) / 2;
        int l2 = (min2 + max2) / 2;
        int l3 = (min3 + max3) / 2;
        boolean done = false;
        while (!done) {
            int[] ls;
            System.out.println("findMaxLags: l1=" + l1 + " l2=" + l2 + " l3=" + l3);
            this.apply(l1, l2, l3, f, g, c);
            lags.markLag(l1, l2, l3);
            boolean foundMax = false;
            for (int i3 = 0; i3 < n3; ++i3) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    float[] c32 = c[i3][i2];
                    float[] cmax32 = cmax[i3][i2];
                    byte[] lag132 = lag1[i3][i2];
                    byte[] lag232 = lag2[i3][i2];
                    byte[] lag332 = lag3[i3][i2];
                    for (int i1 = 0; i1 < n1; ++i1) {
                        float ci = c32[i1];
                        if (!(ci > cmax32[i1])) continue;
                        cmax32[i1] = ci;
                        lag132[i1] = (byte)l1;
                        lag232[i1] = (byte)l2;
                        lag332[i1] = (byte)l3;
                        foundMax = true;
                    }
                }
            }
            if (foundMax) {
                lags.markMax(l1, l2, l3);
            }
            if ((ls = lags.nextLag()) == null) {
                done = true;
                continue;
            }
            l1 = ls[0];
            l2 = ls[1];
            l3 = ls[2];
        }
    }

    public void refineLags(float[] f, float[] g, byte[] l, float[] u) {
        int n = f.length;
        byte min = l[0];
        byte max = l[0];
        for (int i = 1; i < n; ++i) {
            byte lag = l[i];
            if (lag < min) {
                min = lag;
            }
            if (lag <= max) continue;
            max = lag;
        }
        System.out.println("refineLags:");
        System.out.println("  min=" + min + " max=" + max);
        float[] c = new float[n];
        float[] a1 = new float[n];
        float[] a2 = new float[n];
        for (int lag = min - 1; lag <= max + 1; ++lag) {
            this.apply(lag, f, g, c);
            for (int i = 0; i < n; ++i) {
                int k = lag - l[i];
                if (-1 > k || k > 1) continue;
                float[] ck = C1[++k];
                float ci = c[i];
                int n2 = i;
                a1[n2] = a1[n2] + ck[1] * ci;
                int n3 = i;
                a2[n3] = a2[n3] + ck[2] * ci;
            }
        }
        for (int i = 0; i < n; ++i) {
            float a1i = a1[i];
            float a2i = a2[i];
            float w = 0.0f;
            if ((double)a2i < 0.0) {
                w = -0.5f * a1i / a2i;
            }
            if (w < -1.0f) {
                w = -1.0f;
            } else if (w > 1.0f) {
                w = 1.0f;
            }
            u[i] = w + (float)l[i];
        }
    }

    public void refineLags(float[][] f, float[][] g, byte[][] l1, byte[][] l2, float[][] u1, float[][] u2) {
        int n1 = f[0].length;
        int n2 = f.length;
        byte min1 = l1[0][0];
        byte max1 = l1[0][0];
        byte min2 = l2[0][0];
        byte max2 = l2[0][0];
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                byte lag1 = l1[i2][i1];
                byte lag2 = l2[i2][i1];
                if (lag1 < min1) {
                    min1 = lag1;
                }
                if (lag1 > max1) {
                    max1 = lag1;
                }
                if (lag2 < min2) {
                    min2 = lag2;
                }
                if (lag2 <= max2) continue;
                max2 = lag2;
            }
        }
        System.out.println("refineLags:");
        System.out.println("  min1=" + min1 + " max1=" + max1);
        System.out.println("  min2=" + min2 + " max2=" + max2);
        float[][] c = new float[n2][n1];
        float[][] a1 = new float[n2][n1];
        float[][] a2 = new float[n2][n1];
        float[][] a3 = new float[n2][n1];
        float[][] a4 = new float[n2][n1];
        float[][] a5 = new float[n2][n1];
        for (int lag2 = min2 - 1; lag2 <= max2 + 1; ++lag2) {
            for (int lag1 = min1 - 1; lag1 <= max1 + 1; ++lag1) {
                this.apply(lag1, lag2, f, g, c);
                for (int i2 = 0; i2 < n2; ++i2) {
                    for (int i1 = 0; i1 < n1; ++i1) {
                        int k1 = lag1 - l1[i2][i1];
                        int k2 = lag2 - l2[i2][i1];
                        if (-1 > k1 || k1 > 1 || -1 > k2 || k2 > 1) continue;
                        int k = k1 + 1 + 3 * (k2 + 1);
                        float[] ck = C2[k];
                        float ci = c[i2][i1];
                        float[] fArray = a1[i2];
                        int n = i1;
                        fArray[n] = fArray[n] + ck[1] * ci;
                        float[] fArray2 = a2[i2];
                        int n3 = i1;
                        fArray2[n3] = fArray2[n3] + ck[2] * ci;
                        float[] fArray3 = a3[i2];
                        int n4 = i1;
                        fArray3[n4] = fArray3[n4] + ck[3] * ci;
                        float[] fArray4 = a4[i2];
                        int n5 = i1;
                        fArray4[n5] = fArray4[n5] + ck[4] * ci;
                        float[] fArray5 = a5[i2];
                        int n6 = i1;
                        fArray5[n6] = fArray5[n6] + ck[5] * ci;
                    }
                }
            }
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                double l11;
                double l21;
                double d22;
                double w1 = 0.0;
                double w2 = 0.0;
                double b1 = a1[i2][i1];
                double b2 = a2[i2][i1];
                double a21 = -a3[i2][i1];
                double a11 = -2.0 * (double)a4[i2][i1];
                double a22 = -2.0 * (double)a5[i2][i1];
                double d11 = a11;
                if (d11 > 0.0 && (d22 = a22 - (l21 = a21 / (l11 = MathPlus.sqrt(d11))) * l21) > 0.0) {
                    double v1 = b1 / l11;
                    double l22 = MathPlus.sqrt(d22);
                    double v2 = (b2 - l21 * v1) / l22;
                    w2 = v2 / l22;
                    w1 = (v1 - l21 * w2) / l11;
                    if (w1 < -1.0) {
                        w1 = -1.0;
                    } else if (w1 > 1.0) {
                        w1 = 1.0;
                    }
                    if (w2 < -1.0) {
                        w2 = -1.0;
                    } else if (w2 > 1.0) {
                        w2 = 1.0;
                    }
                }
                u1[i2][i1] = (float)(w1 + (double)l1[i2][i1]);
                u2[i2][i1] = (float)(w2 + (double)l2[i2][i1]);
            }
        }
    }

    public void refineLags(float[][][] f, float[][][] g, byte[][][] l1, byte[][][] l2, byte[][][] l3, float[][][] u1, float[][][] u2, float[][][] u3) {
        int n1 = f[0][0].length;
        int n2 = f[0].length;
        int n3 = f.length;
        byte min1 = l1[0][0][0];
        byte max1 = l1[0][0][0];
        byte min2 = l2[0][0][0];
        byte max2 = l2[0][0][0];
        byte min3 = l3[0][0][0];
        byte max3 = l3[0][0][0];
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    byte lag1 = l1[i3][i2][i1];
                    byte lag2 = l2[i3][i2][i1];
                    byte lag3 = l3[i3][i2][i1];
                    if (lag1 < min1) {
                        min1 = lag1;
                    }
                    if (lag1 > max1) {
                        max1 = lag1;
                    }
                    if (lag2 < min2) {
                        min2 = lag2;
                    }
                    if (lag2 > max2) {
                        max2 = lag2;
                    }
                    if (lag3 < min3) {
                        min3 = lag3;
                    }
                    if (lag3 <= max3) continue;
                    max3 = lag3;
                }
            }
        }
        System.out.println("refineLags:");
        System.out.println("  min1=" + min1 + " max1=" + max1);
        System.out.println("  min2=" + min2 + " max2=" + max2);
        System.out.println("  min3=" + min3 + " max3=" + max3);
        float[][][] c = new float[n3][n2][n1];
        float[][][] a1 = new float[n3][n2][n1];
        float[][][] a2 = new float[n3][n2][n1];
        float[][][] a3 = new float[n3][n2][n1];
        float[][][] a4 = new float[n3][n2][n1];
        float[][][] a5 = new float[n3][n2][n1];
        float[][][] a6 = new float[n3][n2][n1];
        float[][][] a7 = new float[n3][n2][n1];
        float[][][] a8 = new float[n3][n2][n1];
        float[][][] a9 = new float[n3][n2][n1];
        for (int lag3 = min3 - 1; lag3 <= max3 + 1; ++lag3) {
            for (int lag2 = min2 - 1; lag2 <= max2 + 1; ++lag2) {
                for (int lag1 = min1 - 1; lag1 <= max1 + 1; ++lag1) {
                    System.out.println("(" + lag1 + "," + lag2 + "," + lag3 + ")");
                    this.apply(lag1, lag2, lag3, f, g, c);
                    for (int i3 = 0; i3 < n3; ++i3) {
                        for (int i2 = 0; i2 < n2; ++i2) {
                            for (int i1 = 0; i1 < n1; ++i1) {
                                int k1 = lag1 - l1[i3][i2][i1];
                                int k2 = lag2 - l2[i3][i2][i1];
                                int k3 = lag3 - l3[i3][i2][i1];
                                if (-1 > k1 || k1 > 1 || -1 > k2 || k2 > 1 || -1 > k3 || k3 > 1) continue;
                                int k = k1 + 1 + 3 * (k2 + 1) + 9 * (k3 + 1);
                                float[] ck = C3[k];
                                float ci = c[i3][i2][i1];
                                float[] fArray = a1[i3][i2];
                                int n = i1;
                                fArray[n] = fArray[n] + ck[1] * ci;
                                float[] fArray2 = a2[i3][i2];
                                int n4 = i1;
                                fArray2[n4] = fArray2[n4] + ck[2] * ci;
                                float[] fArray3 = a3[i3][i2];
                                int n5 = i1;
                                fArray3[n5] = fArray3[n5] + ck[3] * ci;
                                float[] fArray4 = a4[i3][i2];
                                int n6 = i1;
                                fArray4[n6] = fArray4[n6] + ck[4] * ci;
                                float[] fArray5 = a5[i3][i2];
                                int n7 = i1;
                                fArray5[n7] = fArray5[n7] + ck[5] * ci;
                                float[] fArray6 = a6[i3][i2];
                                int n8 = i1;
                                fArray6[n8] = fArray6[n8] + ck[6] * ci;
                                float[] fArray7 = a7[i3][i2];
                                int n9 = i1;
                                fArray7[n9] = fArray7[n9] + ck[7] * ci;
                                float[] fArray8 = a8[i3][i2];
                                int n10 = i1;
                                fArray8[n10] = fArray8[n10] + ck[8] * ci;
                                float[] fArray9 = a9[i3][i2];
                                int n11 = i1;
                                fArray9[n11] = fArray9[n11] + ck[9] * ci;
                            }
                        }
                    }
                }
            }
        }
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    double w1 = 0.0;
                    double w2 = 0.0;
                    double w3 = 0.0;
                    double b1 = a1[i3][i2][i1];
                    double b2 = a2[i3][i2][i1];
                    double b3 = a3[i3][i2][i1];
                    double a21 = -a4[i3][i2][i1];
                    double a31 = -a5[i3][i2][i1];
                    double a32 = -a6[i3][i2][i1];
                    double a11 = -2.0 * (double)a7[i3][i2][i1];
                    double a22 = -2.0 * (double)a8[i3][i2][i1];
                    double a33 = -2.0 * (double)a9[i3][i2][i1];
                    double d11 = a11;
                    if (d11 > 0.0) {
                        double l22;
                        double l32;
                        double d33;
                        double l11 = MathPlus.sqrt(d11);
                        double l21 = a21 / l11;
                        double l31 = a31 / l11;
                        double d22 = a22 - l21 * l21;
                        if (d22 > 0.0 && (d33 = a33 - l31 * l31 - (l32 = (a32 - l31 * l21) / (l22 = MathPlus.sqrt(d22))) * l32) > 0.0) {
                            double v1 = b1 / l11;
                            double v2 = (b2 - l21 * v1) / l22;
                            double l33 = MathPlus.sqrt(d33);
                            double v3 = (b3 - l31 * v1 - l32 * v2) / l33;
                            w3 = v3 / l33;
                            w2 = (v2 - l32 * w3) / l22;
                            w1 = (v1 - l21 * w2 - l31 * w3) / l11;
                            if (w1 < -1.0) {
                                w1 = -1.0;
                            } else if (w1 > 1.0) {
                                w1 = 1.0;
                            }
                            if (w2 < -1.0) {
                                w2 = -1.0;
                            } else if (w2 > 1.0) {
                                w2 = 1.0;
                            }
                            if (w3 < -1.0) {
                                w3 = -1.0;
                            } else if (w3 > 1.0) {
                                w3 = 1.0;
                            }
                        }
                    }
                    u1[i3][i2][i1] = (float)(w1 + (double)l1[i3][i2][i1]);
                    u2[i3][i2][i1] = (float)(w2 + (double)l2[i3][i2][i1]);
                    u3[i3][i2][i1] = (float)(w3 + (double)l3[i3][i2][i1]);
                }
            }
        }
    }

    public void applyWindow(int jf, float[] f, int jg, float[] g) {
        float[] w1 = LocalCorrelationFilter.makeGaussianWindow(this._sigma1);
        LocalCorrelationFilter.applyWindow(w1, jf, f, jg, g);
    }

    public void applyWindow(int j1f, int j2f, float[][] f, int j1g, int j2g, float[][] g) {
        float[] w1 = LocalCorrelationFilter.makeGaussianWindow(this._sigma1);
        float[] w2 = LocalCorrelationFilter.makeGaussianWindow(this._sigma2);
        LocalCorrelationFilter.applyWindow(w1, w2, j1f, j2f, f, j1g, j2g, g);
    }

    public void applyWindow(int j1f, int j2f, int j3f, float[][][] f, int j1g, int j2g, int j3g, float[][][] g) {
        float[] w1 = LocalCorrelationFilter.makeGaussianWindow(this._sigma1);
        float[] w2 = LocalCorrelationFilter.makeGaussianWindow(this._sigma2);
        float[] w3 = LocalCorrelationFilter.makeGaussianWindow(this._sigma3);
        LocalCorrelationFilter.applyWindow(w1, w2, w3, j1f, j2f, j3f, f, j1g, j2g, j3g, g);
    }

    private static void shift(float[] f, float[] g) {
        int i;
        int ie;
        int ib;
        int i1;
        int n1 = f.length;
        int i1b = 0;
        int i1e = MathPlus.min(4, n1);
        for (i1 = i1b; i1 < i1e; ++i1) {
            ib = MathPlus.max(0, 4 - i1);
            ie = MathPlus.min(8, 4 - i1 + n1);
            g[i1] = 0.0f;
            for (i = ib; i < ie; ++i) {
                int n = i1;
                g[n] = g[n] + S[i] * f[i1 + i - 4];
            }
        }
        i1b = 4;
        i1e = n1 - 3;
        for (i1 = i1b; i1 < i1e; ++i1) {
            g[i1] = S4 * (f[i1 - 4] + f[i1 + 3]) + S3 * (f[i1 - 3] + f[i1 + 2]) + S2 * (f[i1 - 2] + f[i1 + 1]) + S1 * (f[i1 - 1] + f[i1]);
        }
        i1b = MathPlus.max(0, n1 - 3);
        i1e = n1;
        for (i1 = i1b; i1 < i1e; ++i1) {
            ib = MathPlus.max(0, 4 - i1);
            ie = MathPlus.min(8, 4 - i1 + n1);
            g[i1] = 0.0f;
            for (i = ib; i < ie; ++i) {
                int n = i1;
                g[n] = g[n] + S[i] * f[i1 + i - 4];
            }
        }
    }

    private static void shift1(float[][] f, float[][] g) {
        int n2 = f.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            LocalCorrelationFilter.shift(f[i2], g[i2]);
        }
    }

    private static void shift2(float[][] f, float[][] g) {
        int i2;
        int n2 = f.length;
        int n1 = f[0].length;
        int i2b = 0;
        int i2e = MathPlus.min(4, n2);
        for (i2 = i2b; i2 < i2e; ++i2) {
            int ib = MathPlus.max(0, 4 - i2);
            int ie = MathPlus.min(8, 4 - i2 + n2);
            for (int i1 = 0; i1 < n1; ++i1) {
                g[i2][i1] = 0.0f;
            }
            for (int i = ib; i < ie; ++i) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    float[] fArray = g[i2];
                    int n = i1;
                    fArray[n] = fArray[n] + S[i] * f[i2 + i - 4][i1];
                }
            }
        }
        i2b = 4;
        i2e = n2 - 3;
        for (i2 = i2b; i2 < i2e; ++i2) {
            float[] g2 = g[i2];
            float[] fm4 = f[i2 - 4];
            float[] fm3 = f[i2 - 3];
            float[] fm2 = f[i2 - 2];
            float[] fm1 = f[i2 - 1];
            float[] fp0 = f[i2];
            float[] fp1 = f[i2 + 1];
            float[] fp2 = f[i2 + 2];
            float[] fp3 = f[i2 + 3];
            for (int i1 = 0; i1 < n1; ++i1) {
                g2[i1] = S4 * (fm4[i1] + fp3[i1]) + S3 * (fm3[i1] + fp2[i1]) + S2 * (fm2[i1] + fp1[i1]) + S1 * (fm1[i1] + fp0[i1]);
            }
        }
        i2b = MathPlus.max(0, n2 - 3);
        i2e = n2;
        for (i2 = i2b; i2 < i2e; ++i2) {
            int ib = MathPlus.max(0, 4 - i2);
            int ie = MathPlus.min(8, 4 - i2 + n2);
            for (int i1 = 0; i1 < n1; ++i1) {
                g[i2][i1] = 0.0f;
            }
            for (int i = ib; i < ie; ++i) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    float[] fArray = g[i2];
                    int n = i1;
                    fArray[n] = fArray[n] + S[i] * f[i2 + i - 4][i1];
                }
            }
        }
    }

    private static void shift1(final float[][][] f, final float[][][] g) {
        final int n3 = f.length;
        final AtomicInteger ai = new AtomicInteger();
        Thread[] threads = LocalCorrelationFilter.newThreads();
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                public void run() {
                    int i3 = ai.getAndIncrement();
                    while (i3 < n3) {
                        LocalCorrelationFilter.shift1(f[i3], g[i3]);
                        i3 = ai.getAndIncrement();
                    }
                }
            });
        }
        LocalCorrelationFilter.startAndJoin(threads);
    }

    private static void shift2(final float[][][] f, final float[][][] g) {
        final int n3 = f.length;
        final AtomicInteger ai = new AtomicInteger();
        Thread[] threads = LocalCorrelationFilter.newThreads();
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                public void run() {
                    int i3 = ai.getAndIncrement();
                    while (i3 < n3) {
                        LocalCorrelationFilter.shift2(f[i3], g[i3]);
                        i3 = ai.getAndIncrement();
                    }
                }
            });
        }
        LocalCorrelationFilter.startAndJoin(threads);
    }

    private static void shift3(final float[][][] f, final float[][][] g) {
        final int n3 = f.length;
        final int n2 = f[0].length;
        final AtomicInteger ai = new AtomicInteger();
        Thread[] threads = LocalCorrelationFilter.newThreads();
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                public void run() {
                    float[][] f2 = new float[n3][];
                    float[][] g2 = new float[n3][];
                    int i2 = ai.getAndIncrement();
                    while (i2 < n2) {
                        for (int i3 = 0; i3 < n3; ++i3) {
                            f2[i3] = f[i3][i2];
                            g2[i3] = g[i3][i2];
                        }
                        LocalCorrelationFilter.shift2(f2, g2);
                        i2 = ai.getAndIncrement();
                    }
                }
            });
        }
        LocalCorrelationFilter.startAndJoin(threads);
    }

    private static Thread[] newThreads() {
        int nthread = Runtime.getRuntime().availableProcessors();
        return new Thread[nthread];
    }

    private static void startAndJoin(Thread[] threads) {
        int ithread;
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread].start();
        }
        try {
            for (ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread].join();
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    private static float[] makeGaussianWindow(double sigma) {
        int m = 1 + 2 * (int)(4.0 * sigma);
        int j = (m - 1) / 2;
        float[] w = new float[m];
        double s = -0.5 / (sigma * sigma);
        for (int i = 0; i < m; ++i) {
            double x = i - j;
            w[i] = (float)MathPlus.exp(s * x * x);
        }
        return w;
    }

    private static void applyWindow(float[] w, int jf, float[] f, int jg, float[] g) {
        int nf = f.length;
        int ng = g.length;
        int nw = w.length;
        int imin = MathPlus.max(0, -(jf -= (nw - 1) / 2), -(jg -= (nw - 1) / 2));
        int imax = MathPlus.min(nw, nf - jf, ng - jg);
        for (int i = imin; i < imax; ++i) {
            g[jg + i] = w[i] * f[jf + i];
        }
    }

    private static void applyWindow(float[] w1, float[] w2, int j1f, int j2f, float[][] f, int j1g, int j2g, float[][] g) {
        int n1f = f[0].length;
        int n1g = g[0].length;
        int n1w = w1.length;
        int i1min = MathPlus.max(0, -(j1f -= (n1w - 1) / 2), -(j1g -= (n1w - 1) / 2));
        int i1max = MathPlus.min(n1w, n1f - j1f, n1g - j1g);
        int n2f = f.length;
        int n2g = g.length;
        int n2w = w2.length;
        int i2min = MathPlus.max(0, -(j2f -= (n2w - 1) / 2), -(j2g -= (n2w - 1) / 2));
        int i2max = MathPlus.min(n2w, n2f - j2f, n2g - j2g);
        for (int i2 = i2min; i2 < i2max; ++i2) {
            float w2i = w2[i2];
            float[] f2 = f[j2f + i2];
            float[] g2 = g[j2g + i2];
            for (int i1 = i1min; i1 < i1max; ++i1) {
                g2[j1g + i1] = w2i * w1[i1] * f2[j1f + i1];
            }
        }
    }

    private static void applyWindow(float[] w1, float[] w2, float[] w3, int j1f, int j2f, int j3f, float[][][] f, int j1g, int j2g, int j3g, float[][][] g) {
        int n1f = f[0].length;
        int n1g = g[0].length;
        int n1w = w1.length;
        int i1min = MathPlus.max(0, -(j1f -= (n1w - 1) / 2), -(j1g -= (n1w - 1) / 2));
        int i1max = MathPlus.min(n1w, n1f - j1f, n1g - j1g);
        int n2f = f.length;
        int n2g = g.length;
        int n2w = w2.length;
        int i2min = MathPlus.max(0, -(j2f -= (n2w - 1) / 2), -(j2g -= (n2w - 1) / 2));
        int i2max = MathPlus.min(n2w, n2f - j2f, n2g - j2g);
        int n3f = f.length;
        int n3g = g.length;
        int n3w = w3.length;
        int i3min = MathPlus.max(0, -(j3f -= (n3w - 1) / 2), -(j3g -= (n3w - 1) / 2));
        int i3max = MathPlus.min(n3w, n3f - j3f, n3g - j3g);
        for (int i3 = i3min; i3 < i3max; ++i3) {
            float w3i = w3[i3];
            float[][] f3 = f[j3f + i3];
            float[][] g3 = g[j3g + i3];
            for (int i2 = i2min; i2 < i2max; ++i2) {
                float w32i = w3i * w2[i2];
                float[] f32 = f3[j2f + i2];
                float[] g32 = g3[j2g + i2];
                for (int i1 = i1min; i1 < i1max; ++i1) {
                    g32[j1g + i1] = w32i * w1[i1] * f32[j1f + i1];
                }
            }
        }
    }

    private static class Lags {
        int _min1;
        int _max1;
        int _min2;
        int _max2;
        int _min3;
        int _max3;
        byte[][][] _mark;

        Lags(int min1, int max1) {
            this(min1, max1, 0, 0, 0, 0);
        }

        Lags(int min1, int max1, int min2, int max2) {
            this(min1, max1, min2, max2, 0, 0);
        }

        Lags(int min1, int max1, int min2, int max2, int min3, int max3) {
            int nl1 = 1 + max1 - min1;
            int nl2 = 1 + max2 - min2;
            int nl3 = 1 + max3 - min3;
            this._min1 = min1;
            this._max1 = max1;
            this._min2 = min2;
            this._max2 = max2;
            this._min3 = min3;
            this._max3 = max3;
            this._mark = new byte[nl3][nl2][nl1];
        }

        void markLag(int l1) {
            this.markLag(l1, 0, 0);
        }

        void markLag(int l1, int l2) {
            this.markLag(l1, l2, 0);
        }

        void markLag(int l1, int l2, int l3) {
            this._mark[l3 - this._min3][l2 - this._min2][l1 - this._min1] = -1;
        }

        void markMax(int l1) {
            this.markMax(l1, 0, 0);
        }

        void markMax(int l1, int l2) {
            this.markMax(l1, l2, 0);
        }

        void markMax(int l1, int l2, int l3) {
            this._mark[l3 - this._min3][l2 - this._min2][l1 - this._min1] = 1;
        }

        boolean isMarkedLag(int l1) {
            return this.isMarkedLag(l1, 0, 0);
        }

        boolean isMarkedLag(int l1, int l2) {
            return this.isMarkedLag(l1, l2, 0);
        }

        boolean isMarkedLag(int l1, int l2, int l3) {
            return !this.inBounds(l1, l2, l3) || this._mark[l3 - this._min3][l2 - this._min2][l1 - this._min1] != 0;
        }

        boolean isMarkedMax(int l1) {
            return this.isMarkedMax(l1, 0, 0);
        }

        boolean isMarkedMax(int l1, int l2) {
            return this.isMarkedMax(l1, l2, 0);
        }

        boolean isMarkedMax(int l1, int l2, int l3) {
            return this.inBounds(l1, l2, l3) && this._mark[l3 - this._min3][l2 - this._min2][l1 - this._min1] == 1;
        }

        boolean inBounds(int l1, int l2, int l3) {
            return l1 >= this._min1 && l1 <= this._max1 && l2 >= this._min2 && l2 <= this._max2 && l3 >= this._min3 && l3 <= this._max3;
        }

        int[] nextLag() {
            for (int l3 = this._min3; l3 <= this._max3; ++l3) {
                for (int l2 = this._min2; l2 <= this._max2; ++l2) {
                    for (int l1 = this._min1; l1 <= this._max1; ++l1) {
                        if (!this.isMarkedMax(l1, l2, l3)) continue;
                        for (int k3 = l3 - 1; k3 <= l3 + 1; ++k3) {
                            for (int k2 = l2 - 1; k2 <= l2 + 1; ++k2) {
                                for (int k1 = l1 - 1; k1 <= l1 + 1; ++k1) {
                                    if (this.isMarkedLag(k1, k2, k3)) continue;
                                    return new int[]{k1, k2, k3};
                                }
                            }
                        }
                    }
                }
            }
            return null;
        }
    }
}

