/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.util.Array;
import edu.mines.jtk.util.Check;
import edu.mines.jtk.util.MathPlus;

public class LocalCausalFilter {
    private int _m;
    private int _min1;
    private int _max1;
    private int _min2;
    private int _max2;
    private int _min3;
    private int _max3;
    private int[] _lag1;
    private int[] _lag2;
    private int[] _lag3;

    public LocalCausalFilter(int[] lag1) {
        this.initLags(lag1);
    }

    public LocalCausalFilter(int[] lag1, int[] lag2) {
        this.initLags(lag1, lag2);
    }

    public LocalCausalFilter(int[] lag1, int[] lag2, int[] lag3) {
        this.initLags(lag1, lag2, lag3);
    }

    public int[] getLag1() {
        return Array.copy(this._lag1);
    }

    public int[] getLag2() {
        return Array.copy(this._lag2);
    }

    public int[] getLag3() {
        return Array.copy(this._lag3);
    }

    public void apply(A1 a1, float[] x, float[] y) {
        int k1;
        int j;
        float yi;
        int i1;
        float[] a = new float[this._m];
        int n1 = x.length;
        int i1lo = MathPlus.min(this._max1, n1);
        for (i1 = n1 - 1; i1 >= i1lo; --i1) {
            a1.get(i1, a);
            yi = a[0] * x[i1];
            for (j = 1; j < this._m; ++j) {
                k1 = i1 - this._lag1[j];
                yi += a[j] * x[k1];
            }
            y[i1] = yi;
        }
        for (i1 = i1lo - 1; i1 >= 0; --i1) {
            a1.get(i1, a);
            yi = a[0] * x[i1];
            for (j = 1; j < this._m; ++j) {
                k1 = i1 - this._lag1[j];
                if (0 > k1) continue;
                yi += a[j] * x[k1];
            }
            y[i1] = yi;
        }
    }

    public void applyTranspose(A1 a1, float[] x, float[] y) {
        int k1;
        int j;
        float xi;
        int i1;
        float[] a = new float[this._m];
        int n1 = x.length;
        int i1lo = MathPlus.min(this._max1, n1);
        for (i1 = 0; i1 < i1lo; ++i1) {
            a1.get(i1, a);
            xi = x[i1];
            y[i1] = a[0] * xi;
            for (j = 1; j < this._m; ++j) {
                k1 = i1 - this._lag1[j];
                if (0 > k1) continue;
                int n = k1;
                y[n] = y[n] + a[j] * xi;
            }
        }
        for (i1 = i1lo; i1 < n1; ++i1) {
            a1.get(i1, a);
            xi = x[i1];
            y[i1] = a[0] * xi;
            for (j = 1; j < this._m; ++j) {
                int n = k1 = i1 - this._lag1[j];
                y[n] = y[n] + a[j] * xi;
            }
        }
    }

    public void applyInverse(A1 a1, float[] y, float[] x) {
        int k1;
        int j;
        float xi;
        int i1;
        float[] a = new float[this._m];
        int n1 = y.length;
        int i1lo = MathPlus.min(this._max1, n1);
        for (i1 = 0; i1 < i1lo; ++i1) {
            a1.get(i1, a);
            xi = 0.0f;
            for (j = 1; j < this._m; ++j) {
                k1 = i1 - this._lag1[j];
                if (0 > k1) continue;
                xi += a[j] * x[k1];
            }
            x[i1] = (y[i1] - xi) / a[0];
        }
        for (i1 = i1lo; i1 < n1; ++i1) {
            a1.get(i1, a);
            xi = 0.0f;
            for (j = 1; j < this._m; ++j) {
                k1 = i1 - this._lag1[j];
                xi += a[j] * x[k1];
            }
            x[i1] = (y[i1] - xi) / a[0];
        }
    }

    public void applyInverseTranspose(A1 a1, float[] y, float[] x) {
        int k1;
        int j;
        float xi;
        int i1;
        Check.argument(x != y, "x!=y");
        Array.zero(x);
        float[] a = new float[this._m];
        int n1 = y.length;
        int i1lo = MathPlus.min(this._max1, n1);
        for (i1 = n1 - 1; i1 >= i1lo; --i1) {
            a1.get(i1, a);
            xi = x[i1] = (y[i1] - x[i1]) / a[0];
            for (j = 1; j < this._m; ++j) {
                int n = k1 = i1 - this._lag1[j];
                x[n] = x[n] + a[j] * xi;
            }
        }
        for (i1 = i1lo - 1; i1 >= 0; --i1) {
            a1.get(i1, a);
            xi = x[i1] = (y[i1] - x[i1]) / a[0];
            for (j = 1; j < this._m; ++j) {
                k1 = i1 - this._lag1[j];
                if (0 > k1) continue;
                int n = k1;
                x[n] = x[n] + a[j] * xi;
            }
        }
    }

    public void apply(A2 a2, float[][] x, float[][] y) {
        int k2;
        int k1;
        int j;
        float yi;
        int i1;
        int i2;
        int i1hi;
        float[] a = new float[this._m];
        int n1 = x[0].length;
        int n2 = x.length;
        int i1lo = MathPlus.max(0, this._max1);
        int i2lo = i1lo <= (i1hi = MathPlus.min(n1, n1 + this._min1)) ? MathPlus.min(this._max2, n2) : n2;
        for (i2 = n2 - 1; i2 >= i2lo; --i2) {
            for (i1 = n1 - 1; i1 >= i1hi; --i1) {
                a2.get(i1, i2, a);
                yi = a[0] * x[i2][i1];
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 - this._lag1[j];
                    k2 = i2 - this._lag2[j];
                    if (k1 >= n1) continue;
                    yi += a[j] * x[k2][k1];
                }
                y[i2][i1] = yi;
            }
            for (i1 = i1hi - 1; i1 >= i1lo; --i1) {
                a2.get(i1, i2, a);
                yi = a[0] * x[i2][i1];
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 - this._lag1[j];
                    k2 = i2 - this._lag2[j];
                    yi += a[j] * x[k2][k1];
                }
                y[i2][i1] = yi;
            }
            for (i1 = i1lo - 1; i1 >= 0; --i1) {
                a2.get(i1, i2, a);
                yi = a[0] * x[i2][i1];
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 - this._lag1[j];
                    k2 = i2 - this._lag2[j];
                    if (0 > k1) continue;
                    yi += a[j] * x[k2][k1];
                }
                y[i2][i1] = yi;
            }
        }
        for (i2 = i2lo - 1; i2 >= 0; --i2) {
            for (i1 = n1 - 1; i1 >= 0; --i1) {
                a2.get(i1, i2, a);
                yi = a[0] * x[i2][i1];
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 - this._lag1[j];
                    k2 = i2 - this._lag2[j];
                    if (0 > k1 || k1 >= n1 || 0 > k2) continue;
                    yi += a[j] * x[k2][k1];
                }
                y[i2][i1] = yi;
            }
        }
    }

    public void applyTranspose(A2 a2, float[][] x, float[][] y) {
        int k2;
        int k1;
        int j;
        float xi;
        int i1;
        int i2;
        int i1hi;
        float[] a = new float[this._m];
        int n1 = x[0].length;
        int n2 = x.length;
        int i1lo = MathPlus.max(0, this._max1);
        int i2lo = i1lo <= (i1hi = MathPlus.min(n1, n1 + this._min1)) ? MathPlus.min(this._max2, n2) : n2;
        for (i2 = 0; i2 < i2lo; ++i2) {
            for (i1 = 0; i1 < n1; ++i1) {
                a2.get(i1, i2, a);
                xi = x[i2][i1];
                y[i2][i1] = a[0] * xi;
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 - this._lag1[j];
                    k2 = i2 - this._lag2[j];
                    if (0 > k1 || k1 >= n1 || 0 > k2) continue;
                    float[] fArray = y[k2];
                    int n = k1;
                    fArray[n] = fArray[n] + a[j] * xi;
                }
            }
        }
        for (i2 = i2lo; i2 < n2; ++i2) {
            for (i1 = 0; i1 < i1lo; ++i1) {
                a2.get(i1, i2, a);
                xi = x[i2][i1];
                y[i2][i1] = a[0] * xi;
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 - this._lag1[j];
                    k2 = i2 - this._lag2[j];
                    if (0 > k1) continue;
                    float[] fArray = y[k2];
                    int n = k1;
                    fArray[n] = fArray[n] + a[j] * xi;
                }
            }
            for (i1 = i1lo; i1 < i1hi; ++i1) {
                a2.get(i1, i2, a);
                xi = x[i2][i1];
                y[i2][i1] = a[0] * xi;
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 - this._lag1[j];
                    k2 = i2 - this._lag2[j];
                    float[] fArray = y[k2];
                    int n = k1;
                    fArray[n] = fArray[n] + a[j] * xi;
                }
            }
            for (i1 = i1hi; i1 < n1; ++i1) {
                a2.get(i1, i2, a);
                xi = x[i2][i1];
                y[i2][i1] = a[0] * xi;
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 - this._lag1[j];
                    k2 = i2 - this._lag2[j];
                    if (k1 >= n1) continue;
                    float[] fArray = y[k2];
                    int n = k1;
                    fArray[n] = fArray[n] + a[j] * xi;
                }
            }
        }
    }

    public void applyInverse(A2 a2, float[][] y, float[][] x) {
        int k2;
        int k1;
        int j;
        float xi;
        int i1;
        int i2;
        int i1hi;
        float[] a = new float[this._m];
        int n1 = y[0].length;
        int n2 = y.length;
        int i1lo = MathPlus.min(this._max1, n1);
        int i2lo = i1lo <= (i1hi = MathPlus.min(n1, n1 + this._min1)) ? MathPlus.min(this._max2, n2) : n2;
        for (i2 = 0; i2 < i2lo; ++i2) {
            for (i1 = 0; i1 < n1; ++i1) {
                a2.get(i1, i2, a);
                xi = 0.0f;
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 - this._lag1[j];
                    k2 = i2 - this._lag2[j];
                    if (0 > k1 || k1 >= n1 || 0 > k2) continue;
                    xi += a[j] * x[k2][k1];
                }
                x[i2][i1] = (y[i2][i1] - xi) / a[0];
            }
        }
        for (i2 = i2lo; i2 < n2; ++i2) {
            for (i1 = 0; i1 < i1lo; ++i1) {
                a2.get(i1, i2, a);
                xi = 0.0f;
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 - this._lag1[j];
                    k2 = i2 - this._lag2[j];
                    if (0 > k1) continue;
                    xi += a[j] * x[k2][k1];
                }
                x[i2][i1] = (y[i2][i1] - xi) / a[0];
            }
            for (i1 = i1lo; i1 < i1hi; ++i1) {
                a2.get(i1, i2, a);
                xi = 0.0f;
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 - this._lag1[j];
                    k2 = i2 - this._lag2[j];
                    xi += a[j] * x[k2][k1];
                }
                x[i2][i1] = (y[i2][i1] - xi) / a[0];
            }
            for (i1 = i1hi; i1 < n1; ++i1) {
                a2.get(i1, i2, a);
                xi = 0.0f;
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 - this._lag1[j];
                    k2 = i2 - this._lag2[j];
                    if (k1 >= n1) continue;
                    xi += a[j] * x[k2][k1];
                }
                x[i2][i1] = (y[i2][i1] - xi) / a[0];
            }
        }
    }

    public void applyInverseTranspose(A2 a2, float[][] y, float[][] x) {
        int k2;
        int k1;
        int j;
        float xi;
        int i1;
        int i2;
        Check.argument(x != y, "x!=y");
        Array.zero(x);
        float[] a = new float[this._m];
        int n1 = y[0].length;
        int n2 = y.length;
        int i1lo = MathPlus.min(this._max1, n1);
        int i1hi = MathPlus.min(n1, n1 + this._min1);
        int i2lo = i1lo <= i1hi ? MathPlus.min(this._max2, n2) : n2;
        for (i2 = n2 - 1; i2 >= i2lo; --i2) {
            for (i1 = n1 - 1; i1 >= i1hi; --i1) {
                a2.get(i1, i2, a);
                float f = (y[i2][i1] - x[i2][i1]) / a[0];
                x[i2][i1] = f;
                xi = f;
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 - this._lag1[j];
                    k2 = i2 - this._lag2[j];
                    if (k1 >= n1) continue;
                    float[] fArray = x[k2];
                    int n = k1;
                    fArray[n] = fArray[n] + a[j] * xi;
                }
            }
            for (i1 = i1hi - 1; i1 >= i1lo; --i1) {
                a2.get(i1, i2, a);
                float f = (y[i2][i1] - x[i2][i1]) / a[0];
                x[i2][i1] = f;
                xi = f;
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 - this._lag1[j];
                    k2 = i2 - this._lag2[j];
                    float[] fArray = x[k2];
                    int n = k1;
                    fArray[n] = fArray[n] + a[j] * xi;
                }
            }
            for (i1 = i1lo - 1; i1 >= 0; --i1) {
                a2.get(i1, i2, a);
                float f = (y[i2][i1] - x[i2][i1]) / a[0];
                x[i2][i1] = f;
                xi = f;
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 - this._lag1[j];
                    k2 = i2 - this._lag2[j];
                    if (0 > k1) continue;
                    float[] fArray = x[k2];
                    int n = k1;
                    fArray[n] = fArray[n] + a[j] * xi;
                }
            }
        }
        for (i2 = i2lo - 1; i2 >= 0; --i2) {
            for (i1 = n1 - 1; i1 >= 0; --i1) {
                a2.get(i1, i2, a);
                float f = (y[i2][i1] - x[i2][i1]) / a[0];
                x[i2][i1] = f;
                xi = f;
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 - this._lag1[j];
                    k2 = i2 - this._lag2[j];
                    if (0 > k1 || k1 >= n1 || 0 > k2) continue;
                    float[] fArray = x[k2];
                    int n = k1;
                    fArray[n] = fArray[n] + a[j] * xi;
                }
            }
        }
    }

    public void apply(A3 a3, float[][][] x, float[][][] y) {
        int k3;
        int k2;
        int k1;
        int j;
        float yi;
        int i1;
        int i2;
        int i3;
        float[] a = new float[this._m];
        int n1 = x[0][0].length;
        int n2 = x[0].length;
        int n3 = x.length;
        int i1lo = MathPlus.max(0, this._max1);
        int i1hi = MathPlus.min(n1, n1 + this._min1);
        int i2lo = MathPlus.max(0, this._max2);
        int i2hi = MathPlus.min(n2, n2 + this._min2);
        int i3lo = i1lo <= i1hi && i2lo <= i2hi ? MathPlus.min(this._max3, n3) : n3;
        for (i3 = n3 - 1; i3 >= i3lo; --i3) {
            for (i2 = n2 - 1; i2 >= i2hi; --i2) {
                for (i1 = n1 - 1; i1 >= 0; --i1) {
                    a3.get(i1, i2, i3, a);
                    yi = a[0] * x[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (0 > k1 || k1 >= n1 || k2 >= n2) continue;
                        yi += a[j] * x[k3][k2][k1];
                    }
                    y[i3][i2][i1] = yi;
                }
            }
            for (i2 = i2hi - 1; i2 >= i2lo; --i2) {
                for (i1 = n1 - 1; i1 >= i1hi; --i1) {
                    a3.get(i1, i2, i3, a);
                    yi = a[0] * x[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (k1 >= n1) continue;
                        yi += a[j] * x[k3][k2][k1];
                    }
                    y[i3][i2][i1] = yi;
                }
                for (i1 = i1hi - 1; i1 >= i1lo; --i1) {
                    a3.get(i1, i2, i3, a);
                    yi = a[0] * x[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        yi += a[j] * x[k3][k2][k1];
                    }
                    y[i3][i2][i1] = yi;
                }
                for (i1 = i1lo - 1; i1 >= 0; --i1) {
                    a3.get(i1, i2, i3, a);
                    yi = a[0] * x[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (0 > k1) continue;
                        yi += a[j] * x[k3][k2][k1];
                    }
                    y[i3][i2][i1] = yi;
                }
            }
            for (i2 = i2lo - 1; i2 >= 0; --i2) {
                for (i1 = n1 - 1; i1 >= 0; --i1) {
                    a3.get(i1, i2, i3, a);
                    yi = a[0] * x[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (0 > k1 || k1 >= n1 || 0 > k2) continue;
                        yi += a[j] * x[k3][k2][k1];
                    }
                    y[i3][i2][i1] = yi;
                }
            }
        }
        for (i3 = i3lo - 1; i3 >= 0; --i3) {
            for (i2 = n2 - 1; i2 >= 0; --i2) {
                for (i1 = n1 - 1; i1 >= 0; --i1) {
                    a3.get(i1, i2, i3, a);
                    yi = a[0] * x[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (0 > k1 || k1 >= n1 || 0 > k2 || k2 >= n2 || 0 > k3) continue;
                        yi += a[j] * x[k3][k2][k1];
                    }
                    y[i3][i2][i1] = yi;
                }
            }
        }
    }

    public void applyTranspose(A3 a3, float[][][] x, float[][][] y) {
        int k3;
        int k2;
        int k1;
        int j;
        float xi;
        int i1;
        int i2;
        int i3;
        float[] a = new float[this._m];
        int n1 = x[0][0].length;
        int n2 = x[0].length;
        int n3 = x.length;
        int i1lo = MathPlus.max(0, this._max1);
        int i1hi = MathPlus.min(n1, n1 + this._min1);
        int i2lo = MathPlus.max(0, this._max2);
        int i2hi = MathPlus.min(n2, n2 + this._min2);
        int i3lo = i1lo <= i1hi && i2lo <= i2hi ? MathPlus.min(this._max3, n3) : n3;
        for (i3 = 0; i3 < i3lo; ++i3) {
            for (i2 = 0; i2 < n2; ++i2) {
                for (i1 = 0; i1 < n1; ++i1) {
                    a3.get(i1, i2, i3, a);
                    xi = x[i3][i2][i1];
                    y[i3][i2][i1] = a[0] * xi;
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (0 > k1 || k1 >= n1 || 0 > k2 || k2 >= n2 || 0 > k3) continue;
                        float[] fArray = y[k3][k2];
                        int n = k1;
                        fArray[n] = fArray[n] + a[j] * xi;
                    }
                }
            }
        }
        for (i3 = i3lo; i3 < n3; ++i3) {
            for (i2 = 0; i2 < i2lo; ++i2) {
                for (i1 = 0; i1 < n1; ++i1) {
                    a3.get(i1, i2, i3, a);
                    xi = x[i3][i2][i1];
                    y[i3][i2][i1] = a[0] * xi;
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (0 > k1 || k1 >= n1 || 0 > k2) continue;
                        float[] fArray = y[k3][k2];
                        int n = k1;
                        fArray[n] = fArray[n] + a[j] * xi;
                    }
                }
            }
            for (i2 = i2lo; i2 < i2hi; ++i2) {
                for (i1 = 0; i1 < i1lo; ++i1) {
                    a3.get(i1, i2, i3, a);
                    xi = x[i3][i2][i1];
                    y[i3][i2][i1] = a[0] * xi;
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (0 > k1) continue;
                        float[] fArray = y[k3][k2];
                        int n = k1;
                        fArray[n] = fArray[n] + a[j] * xi;
                    }
                }
                for (i1 = i1lo; i1 < i1hi; ++i1) {
                    a3.get(i1, i2, i3, a);
                    xi = x[i3][i2][i1];
                    y[i3][i2][i1] = a[0] * xi;
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        float[] fArray = y[k3][k2];
                        int n = k1;
                        fArray[n] = fArray[n] + a[j] * xi;
                    }
                }
                for (i1 = i1hi; i1 < n1; ++i1) {
                    a3.get(i1, i2, i3, a);
                    xi = x[i3][i2][i1];
                    y[i3][i2][i1] = a[0] * xi;
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (k1 >= n1) continue;
                        float[] fArray = y[k3][k2];
                        int n = k1;
                        fArray[n] = fArray[n] + a[j] * xi;
                    }
                }
            }
            for (i2 = i2hi; i2 < n2; ++i2) {
                for (i1 = 0; i1 < n1; ++i1) {
                    a3.get(i1, i2, i3, a);
                    xi = x[i3][i2][i1];
                    y[i3][i2][i1] = a[0] * xi;
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (0 > k1 || k1 >= n1 || k2 >= n2) continue;
                        float[] fArray = y[k3][k2];
                        int n = k1;
                        fArray[n] = fArray[n] + a[j] * xi;
                    }
                }
            }
        }
    }

    public void applyInverse(A3 a3, float[][][] y, float[][][] x) {
        int k3;
        int k2;
        int k1;
        int j;
        float xi;
        int i1;
        int i2;
        int i3;
        float[] a = new float[this._m];
        int n1 = y[0][0].length;
        int n2 = y[0].length;
        int n3 = y.length;
        int i1lo = MathPlus.max(0, this._max1);
        int i1hi = MathPlus.min(n1, n1 + this._min1);
        int i2lo = MathPlus.max(0, this._max2);
        int i2hi = MathPlus.min(n2, n2 + this._min2);
        int i3lo = i1lo <= i1hi && i2lo <= i2hi ? MathPlus.min(this._max3, n3) : n3;
        for (i3 = 0; i3 < i3lo; ++i3) {
            for (i2 = 0; i2 < n2; ++i2) {
                for (i1 = 0; i1 < n1; ++i1) {
                    a3.get(i1, i2, i3, a);
                    xi = 0.0f;
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (0 > k1 || k1 >= n1 || 0 > k2 || k2 >= n2 || 0 > k3) continue;
                        xi += a[j] * x[k3][k2][k1];
                    }
                    x[i3][i2][i1] = (y[i3][i2][i1] - xi) / a[0];
                }
            }
        }
        for (i3 = i3lo; i3 < n3; ++i3) {
            for (i2 = 0; i2 < i2lo; ++i2) {
                for (i1 = 0; i1 < n1; ++i1) {
                    a3.get(i1, i2, i3, a);
                    xi = 0.0f;
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (0 > k1 || k1 >= n1 || 0 > k2) continue;
                        xi += a[j] * x[k3][k2][k1];
                    }
                    x[i3][i2][i1] = (y[i3][i2][i1] - xi) / a[0];
                }
            }
            for (i2 = i2lo; i2 < i2hi; ++i2) {
                for (i1 = 0; i1 < i1lo; ++i1) {
                    a3.get(i1, i2, i3, a);
                    xi = 0.0f;
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (0 > k1) continue;
                        xi += a[j] * x[k3][k2][k1];
                    }
                    x[i3][i2][i1] = (y[i3][i2][i1] - xi) / a[0];
                }
                for (i1 = i1lo; i1 < i1hi; ++i1) {
                    a3.get(i1, i2, i3, a);
                    xi = 0.0f;
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        xi += a[j] * x[k3][k2][k1];
                    }
                    x[i3][i2][i1] = (y[i3][i2][i1] - xi) / a[0];
                }
                for (i1 = i1hi; i1 < n1; ++i1) {
                    a3.get(i1, i2, i3, a);
                    xi = 0.0f;
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (k1 >= n1) continue;
                        xi += a[j] * x[k3][k2][k1];
                    }
                    x[i3][i2][i1] = (y[i3][i2][i1] - xi) / a[0];
                }
            }
            for (i2 = i2hi; i2 < n2; ++i2) {
                for (i1 = 0; i1 < n1; ++i1) {
                    a3.get(i1, i2, i3, a);
                    xi = 0.0f;
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (0 > k1 || k1 >= n1 || k2 >= n2) continue;
                        xi += a[j] * x[k3][k2][k1];
                    }
                    x[i3][i2][i1] = (y[i3][i2][i1] - xi) / a[0];
                }
            }
        }
    }

    public void applyInverseTranspose(A3 a3, float[][][] y, float[][][] x) {
        int k3;
        int k2;
        int k1;
        int j;
        float xi;
        int i1;
        int i2;
        int i3;
        Check.argument(x != y, "x!=y");
        Array.zero(x);
        float[] a = new float[this._m];
        int n1 = y[0][0].length;
        int n2 = y[0].length;
        int n3 = y.length;
        int i1lo = MathPlus.max(0, this._max1);
        int i1hi = MathPlus.min(n1, n1 + this._min1);
        int i2lo = MathPlus.max(0, this._max2);
        int i2hi = MathPlus.min(n2, n2 + this._min2);
        int i3lo = i1lo <= i1hi && i2lo <= i2hi ? MathPlus.min(this._max3, n3) : n3;
        for (i3 = n3 - 1; i3 >= i3lo; --i3) {
            for (i2 = n2 - 1; i2 >= i2hi; --i2) {
                for (i1 = n1 - 1; i1 >= 0; --i1) {
                    a3.get(i1, i2, i3, a);
                    float f = (y[i3][i2][i1] - x[i3][i2][i1]) / a[0];
                    x[i3][i2][i1] = f;
                    xi = f;
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (0 > k1 || k1 >= n1 || k2 >= n2) continue;
                        float[] fArray = x[k3][k2];
                        int n = k1;
                        fArray[n] = fArray[n] + a[j] * xi;
                    }
                }
            }
            for (i2 = i2hi - 1; i2 >= i2lo; --i2) {
                for (i1 = n1 - 1; i1 >= i1hi; --i1) {
                    a3.get(i1, i2, i3, a);
                    float f = (y[i3][i2][i1] - x[i3][i2][i1]) / a[0];
                    x[i3][i2][i1] = f;
                    xi = f;
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (k1 >= n1) continue;
                        float[] fArray = x[k3][k2];
                        int n = k1;
                        fArray[n] = fArray[n] + a[j] * xi;
                    }
                }
                for (i1 = i1hi - 1; i1 >= i1lo; --i1) {
                    a3.get(i1, i2, i3, a);
                    float f = (y[i3][i2][i1] - x[i3][i2][i1]) / a[0];
                    x[i3][i2][i1] = f;
                    xi = f;
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        float[] fArray = x[k3][k2];
                        int n = k1;
                        fArray[n] = fArray[n] + a[j] * xi;
                    }
                }
                for (i1 = i1lo - 1; i1 >= 0; --i1) {
                    a3.get(i1, i2, i3, a);
                    float f = (y[i3][i2][i1] - x[i3][i2][i1]) / a[0];
                    x[i3][i2][i1] = f;
                    xi = f;
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (0 > k1) continue;
                        float[] fArray = x[k3][k2];
                        int n = k1;
                        fArray[n] = fArray[n] + a[j] * xi;
                    }
                }
            }
            for (i2 = i2lo - 1; i2 >= 0; --i2) {
                for (i1 = n1 - 1; i1 >= 0; --i1) {
                    a3.get(i1, i2, i3, a);
                    float f = (y[i3][i2][i1] - x[i3][i2][i1]) / a[0];
                    x[i3][i2][i1] = f;
                    xi = f;
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (0 > k1 || k1 >= n1 || 0 > k2) continue;
                        float[] fArray = x[k3][k2];
                        int n = k1;
                        fArray[n] = fArray[n] + a[j] * xi;
                    }
                }
            }
        }
        for (i3 = i3lo - 1; i3 >= 0; --i3) {
            for (i2 = n2 - 1; i2 >= 0; --i2) {
                for (i1 = n1 - 1; i1 >= 0; --i1) {
                    a3.get(i1, i2, i3, a);
                    float f = (y[i3][i2][i1] - x[i3][i2][i1]) / a[0];
                    x[i3][i2][i1] = f;
                    xi = f;
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (0 > k1 || k1 >= n1 || 0 > k2 || k2 >= n2 || 0 > k3) continue;
                        float[] fArray = x[k3][k2];
                        int n = k1;
                        fArray[n] = fArray[n] + a[j] * xi;
                    }
                }
            }
        }
    }

    private void initLags(int[] lag1) {
        Check.argument(lag1.length > 0, "lag1.length>0");
        Check.argument(lag1[0] == 0, "lag1[0]==0");
        for (int j = 1; j < lag1.length; ++j) {
            Check.argument(lag1[j] > 0, "lag1[" + j + "]>0");
        }
        this._m = lag1.length;
        this._lag1 = Array.copy(lag1);
        this._lag2 = Array.zeroint(this._m);
        this._lag3 = Array.zeroint(this._m);
        this._min1 = Array.min(lag1);
        this._max1 = Array.max(lag1);
    }

    private void initLags(int[] lag1, int[] lag2) {
        Check.argument(lag1.length > 0, "lag1.length>0");
        Check.argument(lag1[0] == 0, "lag1[0]==0");
        Check.argument(lag2[0] == 0, "lag2[0]==0");
        for (int j = 1; j < lag1.length; ++j) {
            Check.argument(lag2[j] >= 0, "lag2[" + j + "]>=0");
            if (lag2[j] != 0) continue;
            Check.argument(lag1[j] > 0, "if lag2==0, lag1[" + j + "]>0");
        }
        this._m = lag1.length;
        this._lag1 = Array.copy(lag1);
        this._lag2 = Array.copy(lag2);
        this._lag3 = Array.zeroint(this._m);
        this._min1 = Array.min(lag1);
        this._min2 = Array.min(lag2);
        this._max1 = Array.max(lag1);
        this._max2 = Array.max(lag2);
    }

    private void initLags(int[] lag1, int[] lag2, int[] lag3) {
        Check.argument(lag1.length > 0, "lag1.length>0");
        Check.argument(lag1[0] == 0, "lag1[0]==0");
        Check.argument(lag2[0] == 0, "lag2[0]==0");
        Check.argument(lag3[0] == 0, "lag3[0]==0");
        for (int j = 1; j < lag1.length; ++j) {
            Check.argument(lag3[j] >= 0, "lag3[" + j + "]>=0");
            if (lag3[j] != 0) continue;
            Check.argument(lag2[j] >= 0, "if lag3==0, lag2[" + j + "]>=0");
            if (lag2[j] != 0) continue;
            Check.argument(lag1[j] > 0, "if lag3==0 && lag2==0, lag1[" + j + "]>0");
        }
        this._m = lag1.length;
        this._lag1 = Array.copy(lag1);
        this._lag2 = Array.copy(lag2);
        this._lag3 = Array.copy(lag3);
        this._min1 = Array.min(lag1);
        this._min2 = Array.min(lag2);
        this._min3 = Array.min(lag3);
        this._max1 = Array.max(lag1);
        this._max2 = Array.max(lag2);
        this._max3 = Array.max(lag3);
    }

    public static interface A3 {
        public void get(int var1, int var2, int var3, float[] var4);
    }

    public static interface A2 {
        public void get(int var1, int var2, float[] var3);
    }

    public static interface A1 {
        public void get(int var1, float[] var2);
    }
}

