/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.Pfacc;
import edu.mines.jtk.util.Array;
import edu.mines.jtk.util.Check;

public class FftComplex {
    private int _nfft;

    public FftComplex(int nfft) {
        Check.argument(Pfacc.nfftValid(nfft), "nfft=" + nfft + " is valid FFT length");
        this._nfft = nfft;
    }

    public static int nfftSmall(int n) {
        Check.argument(n <= 720720, "n does not exceed 720720");
        return Pfacc.nfftSmall(n);
    }

    public static int nfftFast(int n) {
        Check.argument(n <= 720720, "n does not exceed 720720");
        return Pfacc.nfftFast(n);
    }

    public int getNfft() {
        return this._nfft;
    }

    public void complexToComplex(int sign, float[] cx, float[] cy) {
        FftComplex.checkSign(sign);
        FftComplex.checkArray(2 * this._nfft, cx, "cx");
        FftComplex.checkArray(2 * this._nfft, cy, "cy");
        if (cx != cy) {
            Array.ccopy(this._nfft, cx, cy);
        }
        Pfacc.transform(sign, this._nfft, cy);
    }

    public void complexToComplex1(int sign, int n2, float[][] cx, float[][] cy) {
        FftComplex.checkSign(sign);
        FftComplex.checkArray(2 * this._nfft, n2, cx, "cx");
        FftComplex.checkArray(2 * this._nfft, n2, cy, "cy");
        for (int i2 = 0; i2 < n2; ++i2) {
            this.complexToComplex(sign, cx[i2], cy[i2]);
        }
    }

    public void complexToComplex2(int sign, int n1, float[][] cx, float[][] cy) {
        FftComplex.checkSign(sign);
        FftComplex.checkArray(2 * n1, this._nfft, cx, "cx");
        FftComplex.checkArray(2 * n1, this._nfft, cy, "cy");
        if (cx != cy) {
            Array.ccopy(n1, this._nfft, cx, cy);
        }
        Pfacc.transform2a(sign, n1, this._nfft, cy);
    }

    public void complexToComplex1(int sign, int n2, int n3, float[][][] cx, float[][][] cy) {
        FftComplex.checkSign(sign);
        FftComplex.checkArray(2 * this._nfft, n2, n3, cx, "cx");
        FftComplex.checkArray(2 * this._nfft, n2, n3, cy, "cy");
        for (int i3 = 0; i3 < n3; ++i3) {
            this.complexToComplex1(sign, n2, cx[i3], cy[i3]);
        }
    }

    public void complexToComplex2(int sign, int n1, int n3, float[][][] cx, float[][][] cy) {
        FftComplex.checkSign(sign);
        FftComplex.checkArray(2 * n1, this._nfft, n3, cx, "cx");
        FftComplex.checkArray(2 * n1, this._nfft, n3, cy, "cy");
        for (int i3 = 0; i3 < n3; ++i3) {
            this.complexToComplex2(sign, n1, cx[i3], cy[i3]);
        }
    }

    public void complexToComplex3(int sign, int n1, int n2, float[][][] cx, float[][][] cy) {
        FftComplex.checkSign(sign);
        FftComplex.checkArray(2 * n1, n2, this._nfft, cx, "cx");
        FftComplex.checkArray(2 * n1, n2, this._nfft, cy, "cy");
        float[][] cxi2 = new float[this._nfft][];
        float[][] cyi2 = new float[this._nfft][];
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < this._nfft; ++i3) {
                cxi2[i3] = cx[i3][i2];
                cyi2[i3] = cy[i3][i2];
            }
            this.complexToComplex2(sign, n1, cxi2, cyi2);
        }
    }

    public void scale(int n1, float[] cx) {
        float s = 1.0f / (float)this._nfft;
        int n = 2 * n1;
        while (--n >= 0) {
            int n2 = n;
            cx[n2] = cx[n2] * s;
        }
    }

    public void scale(int n1, int n2, float[][] cx) {
        for (int i2 = 0; i2 < n2; ++i2) {
            this.scale(n1, cx[i2]);
        }
    }

    public void scale(int n1, int n2, int n3, float[][][] cx) {
        for (int i3 = 0; i3 < n3; ++i3) {
            this.scale(n1, n2, cx[i3]);
        }
    }

    private static void checkSign(int sign) {
        Check.argument(sign == 1 || sign == -1, "sign equals 1 or -1");
    }

    private static void checkArray(int n, float[] a, String name) {
        Check.argument(a.length >= n, "dimensions of " + name + " are valid");
    }

    private static void checkArray(int n1, int n2, float[][] a, String name) {
        boolean ok = a.length >= n2;
        for (int i2 = 0; i2 < n2 && ok; ++i2) {
            ok = a[i2].length >= n1;
        }
        Check.argument(ok, "dimensions of " + name + " are valid");
    }

    private static void checkArray(int n1, int n2, int n3, float[][][] a, String name) {
        boolean ok = a.length >= n3;
        for (int i3 = 0; i3 < n3 && ok; ++i3) {
            ok = a[i3].length >= n2;
            for (int i2 = 0; i2 < n2 && ok; ++i2) {
                ok = a[i3][i2].length >= n1;
            }
        }
        Check.argument(ok, "dimensions of " + name + " are valid");
    }
}

