/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.util.Check;
import edu.mines.jtk.util.MathPlus;

public class Eigen {
    public static void solveSymmetric22(float[][] a, float[][] v, float[] d) {
        float a00 = a[0][0];
        float a01 = a[0][1];
        float a11 = a[1][1];
        float v00 = 1.0f;
        float v01 = 0.0f;
        float v10 = 0.0f;
        float v11 = 1.0f;
        if (a01 != 0.0f) {
            float r;
            float tiny = 0.1f * MathPlus.sqrt(1.1920929E-7f);
            float u = a11 - a00;
            float t = MathPlus.abs(a01) < tiny * MathPlus.abs(u) ? a01 / u : ((r = 0.5f * u / a01) >= 0.0f ? 1.0f / (r + MathPlus.sqrt(1.0f + r * r)) : 1.0f / (r - MathPlus.sqrt(1.0f + r * r)));
            float c = 1.0f / MathPlus.sqrt(1.0f + t * t);
            float s = t * c;
            u = s / (1.0f + c);
            r = t * a01;
            a00 -= r;
            a11 += r;
            a01 = 0.0f;
            float vpr = v00;
            float vqr = v10;
            v00 = vpr - s * (vqr + vpr * u);
            v10 = vqr + s * (vpr - vqr * u);
            vpr = v01;
            vqr = v11;
            v01 = vpr - s * (vqr + vpr * u);
            v11 = vqr + s * (vpr - vqr * u);
        }
        d[0] = a00;
        d[1] = a11;
        v[0][0] = v00;
        v[0][1] = v01;
        v[1][0] = v10;
        v[1][1] = v11;
        if (d[0] < d[1]) {
            float dt = d[1];
            d[1] = d[0];
            d[0] = dt;
            float[] vt = v[1];
            v[1] = v[0];
            v[0] = vt;
        }
    }

    public static void solveSymmetric22(double[][] a, double[][] v, double[] d) {
        double a00 = a[0][0];
        double a01 = a[0][1];
        double a11 = a[1][1];
        double v00 = 1.0;
        double v01 = 0.0;
        double v10 = 0.0;
        double v11 = 1.0;
        if (a01 != 0.0) {
            double r;
            double tiny = (double)0.1f * MathPlus.sqrt(2.220446049250313E-16);
            double u = a11 - a00;
            double t = MathPlus.abs(a01) < tiny * MathPlus.abs(u) ? a01 / u : ((r = 0.5 * u / a01) >= 0.0 ? 1.0 / (r + MathPlus.sqrt(1.0 + r * r)) : 1.0 / (r - MathPlus.sqrt(1.0 + r * r)));
            double c = 1.0 / MathPlus.sqrt(1.0 + t * t);
            double s = t * c;
            u = s / (1.0 + c);
            r = t * a01;
            a00 -= r;
            a11 += r;
            a01 = 0.0;
            double vpr = v00;
            double vqr = v10;
            v00 = vpr - s * (vqr + vpr * u);
            v10 = vqr + s * (vpr - vqr * u);
            vpr = v01;
            vqr = v11;
            v01 = vpr - s * (vqr + vpr * u);
            v11 = vqr + s * (vpr - vqr * u);
        }
        d[0] = a00;
        d[1] = a11;
        v[0][0] = v00;
        v[0][1] = v01;
        v[1][0] = v10;
        v[1][1] = v11;
        if (d[0] < d[1]) {
            double dt = d[1];
            d[1] = d[0];
            d[0] = dt;
            double[] vt = v[1];
            v[1] = v[0];
            v[0] = vt;
        }
    }

    public static void solveSymmetric33(float[][] a, float[][] v, float[] d) {
        float a00 = a[0][0];
        float a01 = a[0][1];
        float a11 = a[1][1];
        float a02 = a[0][2];
        float a12 = a[1][2];
        float a22 = a[2][2];
        float v00 = 1.0f;
        float v01 = 0.0f;
        float v02 = 0.0f;
        float v10 = 0.0f;
        float v11 = 1.0f;
        float v12 = 0.0f;
        float v20 = 0.0f;
        float v21 = 0.0f;
        float v22 = 1.0f;
        float tiny = 0.1f * MathPlus.sqrt(1.1920929E-7f);
        float aa01 = MathPlus.abs(a01);
        float aa02 = MathPlus.abs(a02);
        float aa12 = MathPlus.abs(a12);
        int nrot = 0;
        while (aa01 + aa02 + aa12 > 0.0f) {
            float vqr;
            float vpr;
            float aqr;
            float apr;
            float s;
            float c;
            float t;
            float r;
            float u;
            Check.state(nrot < 100, "number of Jacobi rotations is less than 100");
            if (aa01 >= aa02 && aa01 >= aa12) {
                u = a11 - a00;
                t = MathPlus.abs(a01) < tiny * MathPlus.abs(u) ? a01 / u : ((r = 0.5f * u / a01) >= 0.0f ? 1.0f / (r + MathPlus.sqrt(1.0f + r * r)) : 1.0f / (r - MathPlus.sqrt(1.0f + r * r)));
                c = 1.0f / MathPlus.sqrt(1.0f + t * t);
                s = t * c;
                u = s / (1.0f + c);
                r = t * a01;
                a00 -= r;
                a11 += r;
                a01 = 0.0f;
                apr = a02;
                aqr = a12;
                a02 = apr - s * (aqr + apr * u);
                a12 = aqr + s * (apr - aqr * u);
                vpr = v00;
                vqr = v10;
                v00 = vpr - s * (vqr + vpr * u);
                v10 = vqr + s * (vpr - vqr * u);
                vpr = v01;
                vqr = v11;
                v01 = vpr - s * (vqr + vpr * u);
                v11 = vqr + s * (vpr - vqr * u);
                vpr = v02;
                vqr = v12;
                v02 = vpr - s * (vqr + vpr * u);
                v12 = vqr + s * (vpr - vqr * u);
            } else if (aa02 >= aa01 && aa02 >= aa12) {
                u = a22 - a00;
                t = MathPlus.abs(a02) < tiny * MathPlus.abs(u) ? a02 / u : ((r = 0.5f * u / a02) >= 0.0f ? 1.0f / (r + MathPlus.sqrt(1.0f + r * r)) : 1.0f / (r - MathPlus.sqrt(1.0f + r * r)));
                c = 1.0f / MathPlus.sqrt(1.0f + t * t);
                s = t * c;
                u = s / (1.0f + c);
                r = t * a02;
                a00 -= r;
                a22 += r;
                a02 = 0.0f;
                apr = a01;
                aqr = a12;
                a01 = apr - s * (aqr + apr * u);
                a12 = aqr + s * (apr - aqr * u);
                vpr = v00;
                vqr = v20;
                v00 = vpr - s * (vqr + vpr * u);
                v20 = vqr + s * (vpr - vqr * u);
                vpr = v01;
                vqr = v21;
                v01 = vpr - s * (vqr + vpr * u);
                v21 = vqr + s * (vpr - vqr * u);
                vpr = v02;
                vqr = v22;
                v02 = vpr - s * (vqr + vpr * u);
                v22 = vqr + s * (vpr - vqr * u);
            } else {
                u = a22 - a11;
                t = MathPlus.abs(a12) < tiny * MathPlus.abs(u) ? a12 / u : ((r = 0.5f * u / a12) >= 0.0f ? 1.0f / (r + MathPlus.sqrt(1.0f + r * r)) : 1.0f / (r - MathPlus.sqrt(1.0f + r * r)));
                c = 1.0f / MathPlus.sqrt(1.0f + t * t);
                s = t * c;
                u = s / (1.0f + c);
                r = t * a12;
                a11 -= r;
                a22 += r;
                a12 = 0.0f;
                apr = a01;
                aqr = a02;
                a01 = apr - s * (aqr + apr * u);
                a02 = aqr + s * (apr - aqr * u);
                vpr = v10;
                vqr = v20;
                v10 = vpr - s * (vqr + vpr * u);
                v20 = vqr + s * (vpr - vqr * u);
                vpr = v11;
                vqr = v21;
                v11 = vpr - s * (vqr + vpr * u);
                v21 = vqr + s * (vpr - vqr * u);
                vpr = v12;
                vqr = v22;
                v12 = vpr - s * (vqr + vpr * u);
                v22 = vqr + s * (vpr - vqr * u);
            }
            aa01 = MathPlus.abs(a01);
            aa02 = MathPlus.abs(a02);
            aa12 = MathPlus.abs(a12);
            ++nrot;
        }
        d[0] = a00;
        d[1] = a11;
        d[2] = a22;
        v[0][0] = v00;
        v[0][1] = v01;
        v[0][2] = v02;
        v[1][0] = v10;
        v[1][1] = v11;
        v[1][2] = v12;
        v[2][0] = v20;
        v[2][1] = v21;
        v[2][2] = v22;
        for (int i = 0; i < 3; ++i) {
            for (int j = i; j > 0 && d[j - 1] < d[j]; --j) {
                float dj = d[j];
                d[j] = d[j - 1];
                d[j - 1] = dj;
                float[] vj = v[j];
                v[j] = v[j - 1];
                v[j - 1] = vj;
            }
        }
    }
}

