/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

public class DifferenceFilter {
    private static final float AP1 = -0.999f;
    private static final float A0P0 = 1.7954845f;
    private static final float A0P1 = -0.64490664f;
    private static final float A0P2 = -0.03850411f;
    private static final float A0P3 = -0.01793403f;
    private static final float A0P4 = -0.00708972f;
    private static final float APM0 = -0.5565992f;
    private static final float APM1 = -0.20031442f;
    private static final float APM2 = -0.08457147f;
    private static final float APM3 = -0.04141619f;
    private static final float APM4 = -0.02290331f;
    private static final float AIP0 = 0.5569527f;
    private static final float A00P0 = 2.3110454f;
    private static final float A00P1 = -0.4805547f;
    private static final float A00P2 = -0.0143204f;
    private static final float A0PM2 = -0.0291793f;
    private static final float A0PM1 = -0.1057476f;
    private static final float A0PP0 = -0.4572746f;
    private static final float A0PP1 = -0.0115732f;
    private static final float A0PP2 = -0.0047283f;
    private static final float APMM2 = -0.0149963f;
    private static final float APMM1 = -0.0408317f;
    private static final float APMP0 = -0.0945958f;
    private static final float APMP1 = -0.0223166f;
    private static final float APMP2 = -0.0062781f;
    private static final float AP0M2 = -0.0213786f;
    private static final float AP0M1 = -0.0898909f;
    private static final float AP0P0 = -0.4322719f;
    private static final float AI0P0 = 0.4327046f;

    public void apply(float[] x, float[] y) {
        int n = y.length;
        y[0] = x[0];
        for (int i = 1; i < n; ++i) {
            y[i] = x[i] + -0.999f * x[i - 1];
        }
    }

    public void apply(float[][] x, float[][] y) {
        int n1 = x[0].length;
        int n2 = x.length;
        float xm4 = 0.0f;
        float xm3 = 0.0f;
        float xm2 = 0.0f;
        float xm1 = 0.0f;
        float xm0 = 0.0f;
        for (int i1 = 0; i1 < n1; ++i1) {
            xm4 = xm3;
            xm3 = xm2;
            xm2 = xm1;
            xm1 = xm0;
            xm0 = x[0][i1];
            y[0][i1] = 1.7954845f * xm0 + -0.64490664f * xm1 + -0.03850411f * xm2 + -0.01793403f * xm3 + -0.00708972f * xm4;
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            xm4 = 0.0f;
            xm3 = 0.0f;
            xm2 = 0.0f;
            xm1 = 0.0f;
            xm0 = 0.0f;
            float xp4 = 0.0f;
            float xp3 = 0.0f;
            float xp2 = 0.0f;
            float xp1 = 0.0f;
            float xp0 = 0.0f;
            if (n1 >= 4) {
                xp4 = x[i2 - 1][3];
            }
            if (n1 >= 3) {
                xp3 = x[i2 - 1][2];
            }
            if (n1 >= 2) {
                xp2 = x[i2 - 1][1];
            }
            if (n1 >= 1) {
                xp1 = x[i2 - 1][0];
            }
            for (int i1 = 0; i1 < n1 - 4; ++i1) {
                xm4 = xm3;
                xm3 = xm2;
                xm2 = xm1;
                xm1 = xm0;
                xm0 = x[i2][i1];
                xp0 = xp1;
                xp1 = xp2;
                xp2 = xp3;
                xp3 = xp4;
                xp4 = x[i2 - 1][i1 + 4];
                y[i2][i1] = 1.7954845f * xm0 + -0.64490664f * xm1 + -0.03850411f * xm2 + -0.01793403f * xm3 + -0.00708972f * xm4 + -0.5565992f * xp0 + -0.20031442f * xp1 + -0.08457147f * xp2 + -0.04141619f * xp3 + -0.02290331f * xp4;
            }
            if (n1 >= 4) {
                xm4 = xm3;
                xm3 = xm2;
                xm2 = xm1;
                xm1 = xm0;
                xm0 = x[i2][n1 - 4];
                xp0 = xp1;
                xp1 = xp2;
                xp2 = xp3;
                xp3 = xp4;
                y[i2][n1 - 4] = 1.7954845f * xm0 + -0.64490664f * xm1 + -0.03850411f * xm2 + -0.01793403f * xm3 + -0.00708972f * xm4 + -0.5565992f * xp0 + -0.20031442f * xp1 + -0.08457147f * xp2 + -0.04141619f * xp3;
            }
            if (n1 >= 3) {
                xm4 = xm3;
                xm3 = xm2;
                xm2 = xm1;
                xm1 = xm0;
                xm0 = x[i2][n1 - 3];
                xp0 = xp1;
                xp1 = xp2;
                xp2 = xp3;
                y[i2][n1 - 3] = 1.7954845f * xm0 + -0.64490664f * xm1 + -0.03850411f * xm2 + -0.01793403f * xm3 + -0.00708972f * xm4 + -0.5565992f * xp0 + -0.20031442f * xp1 + -0.08457147f * xp2;
            }
            if (n1 >= 2) {
                xm4 = xm3;
                xm3 = xm2;
                xm2 = xm1;
                xm1 = xm0;
                xm0 = x[i2][n1 - 2];
                xp0 = xp1;
                xp1 = xp2;
                y[i2][n1 - 2] = 1.7954845f * xm0 + -0.64490664f * xm1 + -0.03850411f * xm2 + -0.01793403f * xm3 + -0.00708972f * xm4 + -0.5565992f * xp0 + -0.20031442f * xp1;
            }
            if (n1 < 1) continue;
            xm4 = xm3;
            xm3 = xm2;
            xm2 = xm1;
            xm1 = xm0;
            xm0 = x[i2][n1 - 1];
            xp0 = xp1;
            y[i2][n1 - 1] = 1.7954845f * xm0 + -0.64490664f * xm1 + -0.03850411f * xm2 + -0.01793403f * xm3 + -0.00708972f * xm4 + -0.5565992f * xp0;
        }
    }

    public void apply(float[][][] x, float[][][] y) {
        int n1 = x[0][0].length;
        int n2 = x[0].length;
        int n3 = x.length;
        int n2m1 = n2 - 1;
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                float x0mm2 = 0.0f;
                float x0mm1 = 0.0f;
                float x0mm0 = 0.0f;
                float x0mp1 = 0.0f;
                float x0mp2 = 0.0f;
                float x00m2 = 0.0f;
                float x00m1 = 0.0f;
                float x00m0 = 0.0f;
                float xm0m0 = 0.0f;
                float xm0p1 = 0.0f;
                float xm0p2 = 0.0f;
                float xmpm2 = 0.0f;
                float xmpm1 = 0.0f;
                float xmpm0 = 0.0f;
                float xmpp1 = 0.0f;
                float xmpp2 = 0.0f;
                if (n1 > 0) {
                    if (i2 > 0) {
                        x0mp1 = x[i3][i2 - 1][0];
                    }
                    if (i3 > 0) {
                        xm0p1 = x[i3 - 1][i2][0];
                        if (i2 < n2m1) {
                            xmpp1 = x[i3 - 1][i2 + 1][0];
                        }
                    }
                }
                if (n1 > 1) {
                    if (i2 > 0) {
                        x0mp2 = x[i3][i2 - 1][1];
                    }
                    if (i3 > 0) {
                        xm0p2 = x[i3 - 1][i2][1];
                        if (i2 < n2m1) {
                            xmpp2 = x[i3 - 1][i2 + 1][1];
                        }
                    }
                }
                for (int i1 = 0; i1 < n1 - 2; ++i1) {
                    x00m2 = x00m1;
                    x00m1 = x00m0;
                    x00m0 = x[i3][i2][i1];
                    if (i2 > 0) {
                        x0mm2 = x0mm1;
                        x0mm1 = x0mm0;
                        x0mm0 = x0mp1;
                        x0mp1 = x0mp2;
                        x0mp2 = x[i3][i2 - 1][i1 + 2];
                    }
                    if (i3 > 0) {
                        if (i2 < n2m1) {
                            xmpm2 = xmpm1;
                            xmpm1 = xmpm0;
                            xmpm0 = xmpp1;
                            xmpp1 = xmpp2;
                            xmpp2 = x[i3 - 1][i2 + 1][i1 + 2];
                        }
                        xm0m0 = xm0p1;
                        xm0p1 = xm0p2;
                        xm0p2 = x[i3 - 1][i2][i1 + 2];
                    }
                    y[i3][i2][i1] = 2.3110454f * x00m0 + -0.4805547f * x00m1 + -0.0143204f * x00m2 + -0.0291793f * x0mp2 + -0.1057476f * x0mp1 + -0.4572746f * x0mm0 + -0.0115732f * x0mm1 + -0.0047283f * x0mm2 + -0.0149963f * xmpp2 + -0.0408317f * xmpp1 + -0.0945958f * xmpm0 + -0.0223166f * xmpm1 + -0.0062781f * xmpm2 + -0.0213786f * xm0p2 + -0.0898909f * xm0p1 + -0.4322719f * xm0m0;
                }
                if (n1 > 1) {
                    x00m2 = x00m1;
                    x00m1 = x00m0;
                    x00m0 = x[i3][i2][n1 - 2];
                    x0mm2 = x0mm1;
                    x0mm1 = x0mm0;
                    x0mm0 = x0mp1;
                    x0mp1 = x0mp2;
                    xmpm2 = xmpm1;
                    xmpm1 = xmpm0;
                    xmpm0 = xmpp1;
                    xmpp1 = xmpp2;
                    xm0m0 = xm0p1;
                    xm0p1 = xm0p2;
                    y[i3][i2][n1 - 2] = 2.3110454f * x00m0 + -0.4805547f * x00m1 + -0.0143204f * x00m2 + -0.1057476f * x0mp1 + -0.4572746f * x0mm0 + -0.0115732f * x0mm1 + -0.0047283f * x0mm2 + -0.0408317f * xmpp1 + -0.0945958f * xmpm0 + -0.0223166f * xmpm1 + -0.0062781f * xmpm2 + -0.0898909f * xm0p1 + -0.4322719f * xm0m0;
                }
                if (n1 <= 0) continue;
                x00m2 = x00m1;
                x00m1 = x00m0;
                x00m0 = x[i3][i2][n1 - 1];
                x0mm2 = x0mm1;
                x0mm1 = x0mm0;
                x0mm0 = x0mp1;
                xmpm2 = xmpm1;
                xmpm1 = xmpm0;
                xmpm0 = xmpp1;
                xm0m0 = xm0p1;
                y[i3][i2][n1 - 1] = 2.3110454f * x00m0 + -0.4805547f * x00m1 + -0.0143204f * x00m2 + -0.4572746f * x0mm0 + -0.0115732f * x0mm1 + -0.0047283f * x0mm2 + -0.0945958f * xmpm0 + -0.0223166f * xmpm1 + -0.0062781f * xmpm2 + -0.4322719f * xm0m0;
            }
        }
    }

    public void applyTranspose(float[] x, float[] y) {
        int n = y.length;
        y[n - 1] = x[n - 1];
        for (int i = n - 2; i >= 0; --i) {
            y[i] = x[i] + -0.999f * x[i + 1];
        }
    }

    public void applyTranspose(float[][] x, float[][] y) {
        int n1 = x[0].length;
        int n2 = x.length;
        float xp4 = 0.0f;
        float xp3 = 0.0f;
        float xp2 = 0.0f;
        float xp1 = 0.0f;
        float xp0 = 0.0f;
        for (int i1 = n1 - 1; i1 >= 0; --i1) {
            xp4 = xp3;
            xp3 = xp2;
            xp2 = xp1;
            xp1 = xp0;
            xp0 = x[n2 - 1][i1];
            y[n2 - 1][i1] = 1.7954845f * xp0 + -0.64490664f * xp1 + -0.03850411f * xp2 + -0.01793403f * xp3 + -0.00708972f * xp4;
        }
        for (int i2 = n2 - 2; i2 >= 0; --i2) {
            float xm4 = 0.0f;
            float xm3 = 0.0f;
            float xm2 = 0.0f;
            float xm1 = 0.0f;
            float xm0 = 0.0f;
            xp4 = 0.0f;
            xp3 = 0.0f;
            xp2 = 0.0f;
            xp1 = 0.0f;
            xp0 = 0.0f;
            if (n1 >= 4) {
                xm4 = x[i2 + 1][n1 - 4];
            }
            if (n1 >= 3) {
                xm3 = x[i2 + 1][n1 - 3];
            }
            if (n1 >= 2) {
                xm2 = x[i2 + 1][n1 - 2];
            }
            if (n1 >= 1) {
                xm1 = x[i2 + 1][n1 - 1];
            }
            for (int i1 = n1 - 1; i1 >= 4; --i1) {
                xp4 = xp3;
                xp3 = xp2;
                xp2 = xp1;
                xp1 = xp0;
                xp0 = x[i2][i1];
                xm0 = xm1;
                xm1 = xm2;
                xm2 = xm3;
                xm3 = xm4;
                xm4 = x[i2 + 1][i1 - 4];
                y[i2][i1] = 1.7954845f * xp0 + -0.64490664f * xp1 + -0.03850411f * xp2 + -0.01793403f * xp3 + -0.00708972f * xp4 + -0.5565992f * xm0 + -0.20031442f * xm1 + -0.08457147f * xm2 + -0.04141619f * xm3 + -0.02290331f * xm4;
            }
            if (n1 > 3) {
                xp4 = xp3;
                xp3 = xp2;
                xp2 = xp1;
                xp1 = xp0;
                xp0 = x[i2][3];
                xm0 = xm1;
                xm1 = xm2;
                xm2 = xm3;
                xm3 = xm4;
                y[i2][3] = 1.7954845f * xp0 + -0.64490664f * xp1 + -0.03850411f * xp2 + -0.01793403f * xp3 + -0.00708972f * xp4 + -0.5565992f * xm0 + -0.20031442f * xm1 + -0.08457147f * xm2 + -0.04141619f * xm3;
            }
            if (n1 > 2) {
                xp4 = xp3;
                xp3 = xp2;
                xp2 = xp1;
                xp1 = xp0;
                xp0 = x[i2][2];
                xm0 = xm1;
                xm1 = xm2;
                xm2 = xm3;
                y[i2][2] = 1.7954845f * xp0 + -0.64490664f * xp1 + -0.03850411f * xp2 + -0.01793403f * xp3 + -0.00708972f * xp4 + -0.5565992f * xm0 + -0.20031442f * xm1 + -0.08457147f * xm2;
            }
            if (n1 > 1) {
                xp4 = xp3;
                xp3 = xp2;
                xp2 = xp1;
                xp1 = xp0;
                xp0 = x[i2][1];
                xm0 = xm1;
                xm1 = xm2;
                y[i2][1] = 1.7954845f * xp0 + -0.64490664f * xp1 + -0.03850411f * xp2 + -0.01793403f * xp3 + -0.00708972f * xp4 + -0.5565992f * xm0 + -0.20031442f * xm1;
            }
            if (n1 <= 0) continue;
            xp4 = xp3;
            xp3 = xp2;
            xp2 = xp1;
            xp1 = xp0;
            xp0 = x[i2][0];
            xm0 = xm1;
            y[i2][0] = 1.7954845f * xp0 + -0.64490664f * xp1 + -0.03850411f * xp2 + -0.01793403f * xp3 + -0.00708972f * xp4 + -0.5565992f * xm0;
        }
    }

    public void applyTranspose(float[][][] x, float[][][] y) {
        int n3m1;
        int n1 = x[0][0].length;
        int n2 = x[0].length;
        int n3 = x.length;
        int n1m1 = n1 - 1;
        int n2m1 = n2 - 1;
        for (int i3 = n3m1 = n3 - 1; i3 >= 0; --i3) {
            for (int i2 = n2m1; i2 >= 0; --i2) {
                float x0mm2 = 0.0f;
                float x0mm1 = 0.0f;
                float x0mm0 = 0.0f;
                float x0mp1 = 0.0f;
                float x0mp2 = 0.0f;
                float x00m2 = 0.0f;
                float x00m1 = 0.0f;
                float x00m0 = 0.0f;
                float xm0m0 = 0.0f;
                float xm0p1 = 0.0f;
                float xm0p2 = 0.0f;
                float xmpm2 = 0.0f;
                float xmpm1 = 0.0f;
                float xmpm0 = 0.0f;
                float xmpp1 = 0.0f;
                float xmpp2 = 0.0f;
                if (n1 > 0) {
                    if (i2 < n2m1) {
                        x0mp1 = x[i3][i2 + 1][n1 - 1];
                    }
                    if (i3 < n3m1) {
                        xm0p1 = x[i3 + 1][i2][n1 - 1];
                        if (i2 > 0) {
                            xmpp1 = x[i3 + 1][i2 - 1][n1 - 1];
                        }
                    }
                }
                if (n1 > 1) {
                    if (i2 < n2m1) {
                        x0mp2 = x[i3][i2 + 1][n1 - 2];
                    }
                    if (i3 < n3m1) {
                        xm0p2 = x[i3 + 1][i2][n1 - 2];
                        if (i2 > 0) {
                            xmpp2 = x[i3 + 1][i2 - 1][n1 - 2];
                        }
                    }
                }
                for (int i1 = n1m1; i1 >= 2; --i1) {
                    x00m2 = x00m1;
                    x00m1 = x00m0;
                    x00m0 = x[i3][i2][i1];
                    if (i2 < n2m1) {
                        x0mm2 = x0mm1;
                        x0mm1 = x0mm0;
                        x0mm0 = x0mp1;
                        x0mp1 = x0mp2;
                        x0mp2 = x[i3][i2 + 1][i1 - 2];
                    }
                    if (i3 < n3m1) {
                        if (i2 > 0) {
                            xmpm2 = xmpm1;
                            xmpm1 = xmpm0;
                            xmpm0 = xmpp1;
                            xmpp1 = xmpp2;
                            xmpp2 = x[i3 + 1][i2 - 1][i1 - 2];
                        }
                        xm0m0 = xm0p1;
                        xm0p1 = xm0p2;
                        xm0p2 = x[i3 + 1][i2][i1 - 2];
                    }
                    y[i3][i2][i1] = 2.3110454f * x00m0 + -0.4805547f * x00m1 + -0.0143204f * x00m2 + -0.0291793f * x0mp2 + -0.1057476f * x0mp1 + -0.4572746f * x0mm0 + -0.0115732f * x0mm1 + -0.0047283f * x0mm2 + -0.0149963f * xmpp2 + -0.0408317f * xmpp1 + -0.0945958f * xmpm0 + -0.0223166f * xmpm1 + -0.0062781f * xmpm2 + -0.0213786f * xm0p2 + -0.0898909f * xm0p1 + -0.4322719f * xm0m0;
                }
                if (n1 > 1) {
                    x00m2 = x00m1;
                    x00m1 = x00m0;
                    x00m0 = x[i3][i2][1];
                    x0mm2 = x0mm1;
                    x0mm1 = x0mm0;
                    x0mm0 = x0mp1;
                    x0mp1 = x0mp2;
                    xmpm2 = xmpm1;
                    xmpm1 = xmpm0;
                    xmpm0 = xmpp1;
                    xmpp1 = xmpp2;
                    xm0m0 = xm0p1;
                    xm0p1 = xm0p2;
                    y[i3][i2][1] = 2.3110454f * x00m0 + -0.4805547f * x00m1 + -0.0143204f * x00m2 + -0.1057476f * x0mp1 + -0.4572746f * x0mm0 + -0.0115732f * x0mm1 + -0.0047283f * x0mm2 + -0.0408317f * xmpp1 + -0.0945958f * xmpm0 + -0.0223166f * xmpm1 + -0.0062781f * xmpm2 + -0.0898909f * xm0p1 + -0.4322719f * xm0m0;
                }
                if (n1 <= 0) continue;
                x00m2 = x00m1;
                x00m1 = x00m0;
                x00m0 = x[i3][i2][0];
                x0mm2 = x0mm1;
                x0mm1 = x0mm0;
                x0mm0 = x0mp1;
                xmpm2 = xmpm1;
                xmpm1 = xmpm0;
                xmpm0 = xmpp1;
                xm0m0 = xm0p1;
                y[i3][i2][0] = 2.3110454f * x00m0 + -0.4805547f * x00m1 + -0.0143204f * x00m2 + -0.4572746f * x0mm0 + -0.0115732f * x0mm1 + -0.0047283f * x0mm2 + -0.0945958f * xmpm0 + -0.0223166f * xmpm1 + -0.0062781f * xmpm2 + -0.4322719f * xm0m0;
            }
        }
    }

    public void applyInverse(float[] x, float[] y) {
        int n = y.length;
        y[0] = x[0];
        for (int i = 1; i < n; ++i) {
            y[i] = x[i] - -0.999f * y[i - 1];
        }
    }

    public void applyInverse(float[][] x, float[][] y) {
        float xm0;
        int n1 = x[0].length;
        int n2 = x.length;
        float ym4 = 0.0f;
        float ym3 = 0.0f;
        float ym2 = 0.0f;
        float ym1 = 0.0f;
        float ym0 = 0.0f;
        for (int i1 = 0; i1 < n1; ++i1) {
            ym4 = ym3;
            ym3 = ym2;
            ym2 = ym1;
            ym1 = ym0;
            xm0 = x[0][i1];
            y[0][i1] = ym0 = 0.5569527f * (xm0 - -0.64490664f * ym1 - -0.03850411f * ym2 - -0.01793403f * ym3 - -0.00708972f * ym4);
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            ym4 = 0.0f;
            ym3 = 0.0f;
            ym2 = 0.0f;
            ym1 = 0.0f;
            ym0 = 0.0f;
            float yp4 = 0.0f;
            float yp3 = 0.0f;
            float yp2 = 0.0f;
            float yp1 = 0.0f;
            float yp0 = 0.0f;
            if (n1 >= 4) {
                yp4 = y[i2 - 1][3];
            }
            if (n1 >= 3) {
                yp3 = y[i2 - 1][2];
            }
            if (n1 >= 2) {
                yp2 = y[i2 - 1][1];
            }
            if (n1 >= 1) {
                yp1 = y[i2 - 1][0];
            }
            for (int i1 = 0; i1 < n1 - 4; ++i1) {
                ym4 = ym3;
                ym3 = ym2;
                ym2 = ym1;
                ym1 = ym0;
                xm0 = x[i2][i1];
                yp0 = yp1;
                yp1 = yp2;
                yp2 = yp3;
                yp3 = yp4;
                yp4 = y[i2 - 1][i1 + 4];
                y[i2][i1] = ym0 = 0.5569527f * (xm0 - -0.64490664f * ym1 - -0.03850411f * ym2 - -0.01793403f * ym3 - -0.00708972f * ym4 - -0.5565992f * yp0 - -0.20031442f * yp1 - -0.08457147f * yp2 - -0.04141619f * yp3 - -0.02290331f * yp4);
            }
            if (n1 >= 4) {
                ym4 = ym3;
                ym3 = ym2;
                ym2 = ym1;
                ym1 = ym0;
                xm0 = x[i2][n1 - 4];
                yp0 = yp1;
                yp1 = yp2;
                yp2 = yp3;
                yp3 = yp4;
                y[i2][n1 - 4] = ym0 = 0.5569527f * (xm0 - -0.64490664f * ym1 - -0.03850411f * ym2 - -0.01793403f * ym3 - -0.00708972f * ym4 - -0.5565992f * yp0 - -0.20031442f * yp1 - -0.08457147f * yp2 - -0.04141619f * yp3);
            }
            if (n1 >= 3) {
                ym4 = ym3;
                ym3 = ym2;
                ym2 = ym1;
                ym1 = ym0;
                xm0 = x[i2][n1 - 3];
                yp0 = yp1;
                yp1 = yp2;
                yp2 = yp3;
                y[i2][n1 - 3] = ym0 = 0.5569527f * (xm0 - -0.64490664f * ym1 - -0.03850411f * ym2 - -0.01793403f * ym3 - -0.00708972f * ym4 - -0.5565992f * yp0 - -0.20031442f * yp1 - -0.08457147f * yp2);
            }
            if (n1 >= 2) {
                ym4 = ym3;
                ym3 = ym2;
                ym2 = ym1;
                ym1 = ym0;
                xm0 = x[i2][n1 - 2];
                yp0 = yp1;
                yp1 = yp2;
                y[i2][n1 - 2] = ym0 = 0.5569527f * (xm0 - -0.64490664f * ym1 - -0.03850411f * ym2 - -0.01793403f * ym3 - -0.00708972f * ym4 - -0.5565992f * yp0 - -0.20031442f * yp1);
            }
            if (n1 < 1) continue;
            ym4 = ym3;
            ym3 = ym2;
            ym2 = ym1;
            ym1 = ym0;
            xm0 = x[i2][n1 - 1];
            yp0 = yp1;
            y[i2][n1 - 1] = ym0 = 0.5569527f * (xm0 - -0.64490664f * ym1 - -0.03850411f * ym2 - -0.01793403f * ym3 - -0.00708972f * ym4 - -0.5565992f * yp0);
        }
    }

    public void applyInverse(float[][][] x, float[][][] y) {
        int n1 = x[0][0].length;
        int n2 = x[0].length;
        int n3 = x.length;
        int n2m1 = n2 - 1;
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                float x00m0;
                float y0mm2 = 0.0f;
                float y0mm1 = 0.0f;
                float y0mm0 = 0.0f;
                float y0mp1 = 0.0f;
                float y0mp2 = 0.0f;
                float y00m2 = 0.0f;
                float y00m1 = 0.0f;
                float y00m0 = 0.0f;
                float ym0m0 = 0.0f;
                float ym0p1 = 0.0f;
                float ym0p2 = 0.0f;
                float ympm2 = 0.0f;
                float ympm1 = 0.0f;
                float ympm0 = 0.0f;
                float ympp1 = 0.0f;
                float ympp2 = 0.0f;
                if (n1 > 0) {
                    if (i2 > 0) {
                        y0mp1 = y[i3][i2 - 1][0];
                    }
                    if (i3 > 0) {
                        ym0p1 = y[i3 - 1][i2][0];
                        if (i2 < n2m1) {
                            ympp1 = y[i3 - 1][i2 + 1][0];
                        }
                    }
                }
                if (n1 > 1) {
                    if (i2 > 0) {
                        y0mp2 = y[i3][i2 - 1][1];
                    }
                    if (i3 > 0) {
                        ym0p2 = y[i3 - 1][i2][1];
                        if (i2 < n2m1) {
                            ympp2 = y[i3 - 1][i2 + 1][1];
                        }
                    }
                }
                for (int i1 = 0; i1 < n1 - 2; ++i1) {
                    x00m0 = x[i3][i2][i1];
                    y00m2 = y00m1;
                    y00m1 = y00m0;
                    if (i2 > 0) {
                        y0mm2 = y0mm1;
                        y0mm1 = y0mm0;
                        y0mm0 = y0mp1;
                        y0mp1 = y0mp2;
                        y0mp2 = y[i3][i2 - 1][i1 + 2];
                    }
                    if (i3 > 0) {
                        if (i2 < n2m1) {
                            ympm2 = ympm1;
                            ympm1 = ympm0;
                            ympm0 = ympp1;
                            ympp1 = ympp2;
                            ympp2 = y[i3 - 1][i2 + 1][i1 + 2];
                        }
                        ym0m0 = ym0p1;
                        ym0p1 = ym0p2;
                        ym0p2 = y[i3 - 1][i2][i1 + 2];
                    }
                    y[i3][i2][i1] = y00m0 = 0.4327046f * (x00m0 - -0.4805547f * y00m1 - -0.0143204f * y00m2 - -0.0291793f * y0mp2 - -0.1057476f * y0mp1 - -0.4572746f * y0mm0 - -0.0115732f * y0mm1 - -0.0047283f * y0mm2 - -0.0149963f * ympp2 - -0.0408317f * ympp1 - -0.0945958f * ympm0 - -0.0223166f * ympm1 - -0.0062781f * ympm2 - -0.0213786f * ym0p2 - -0.0898909f * ym0p1 - -0.4322719f * ym0m0);
                }
                if (n1 > 1) {
                    x00m0 = x[i3][i2][n1 - 2];
                    y00m2 = y00m1;
                    y00m1 = y00m0;
                    y0mm2 = y0mm1;
                    y0mm1 = y0mm0;
                    y0mm0 = y0mp1;
                    y0mp1 = y0mp2;
                    ympm2 = ympm1;
                    ympm1 = ympm0;
                    ympm0 = ympp1;
                    ympp1 = ympp2;
                    ym0m0 = ym0p1;
                    ym0p1 = ym0p2;
                    y[i3][i2][n1 - 2] = y00m0 = 0.4327046f * (x00m0 - -0.4805547f * y00m1 - -0.0143204f * y00m2 - -0.1057476f * y0mp1 - -0.4572746f * y0mm0 - -0.0115732f * y0mm1 - -0.0047283f * y0mm2 - -0.0408317f * ympp1 - -0.0945958f * ympm0 - -0.0223166f * ympm1 - -0.0062781f * ympm2 - -0.0898909f * ym0p1 - -0.4322719f * ym0m0);
                }
                if (n1 <= 0) continue;
                x00m0 = x[i3][i2][n1 - 1];
                y00m2 = y00m1;
                y00m1 = y00m0;
                y0mm2 = y0mm1;
                y0mm1 = y0mm0;
                y0mm0 = y0mp1;
                ympm2 = ympm1;
                ympm1 = ympm0;
                ympm0 = ympp1;
                ym0m0 = ym0p1;
                y[i3][i2][n1 - 1] = y00m0 = 0.4327046f * (x00m0 - -0.4805547f * y00m1 - -0.0143204f * y00m2 - -0.4572746f * y0mm0 - -0.0115732f * y0mm1 - -0.0047283f * y0mm2 - -0.0945958f * ympm0 - -0.0223166f * ympm1 - -0.0062781f * ympm2 - -0.4322719f * ym0m0);
            }
        }
    }

    public void applyInverseTranspose(float[] x, float[] y) {
        int n = y.length;
        y[n - 1] = x[n - 1];
        for (int i = n - 2; i >= 0; --i) {
            y[i] = x[i] - -0.999f * y[i + 1];
        }
    }

    public void applyInverseTranspose(float[][] x, float[][] y) {
        float xp0;
        int n1 = x[0].length;
        int n2 = x.length;
        float yp4 = 0.0f;
        float yp3 = 0.0f;
        float yp2 = 0.0f;
        float yp1 = 0.0f;
        float yp0 = 0.0f;
        for (int i1 = n1 - 1; i1 >= 0; --i1) {
            yp4 = yp3;
            yp3 = yp2;
            yp2 = yp1;
            yp1 = yp0;
            xp0 = x[n2 - 1][i1];
            y[n2 - 1][i1] = yp0 = 0.5569527f * (xp0 - -0.64490664f * yp1 - -0.03850411f * yp2 - -0.01793403f * yp3 - -0.00708972f * yp4);
        }
        for (int i2 = n2 - 2; i2 >= 0; --i2) {
            float ym4 = 0.0f;
            float ym3 = 0.0f;
            float ym2 = 0.0f;
            float ym1 = 0.0f;
            float ym0 = 0.0f;
            yp4 = 0.0f;
            yp3 = 0.0f;
            yp2 = 0.0f;
            yp1 = 0.0f;
            yp0 = 0.0f;
            if (n1 >= 4) {
                ym4 = y[i2 + 1][n1 - 4];
            }
            if (n1 >= 3) {
                ym3 = y[i2 + 1][n1 - 3];
            }
            if (n1 >= 2) {
                ym2 = y[i2 + 1][n1 - 2];
            }
            if (n1 >= 1) {
                ym1 = y[i2 + 1][n1 - 1];
            }
            for (int i1 = n1 - 1; i1 >= 4; --i1) {
                yp4 = yp3;
                yp3 = yp2;
                yp2 = yp1;
                yp1 = yp0;
                xp0 = x[i2][i1];
                ym0 = ym1;
                ym1 = ym2;
                ym2 = ym3;
                ym3 = ym4;
                ym4 = y[i2 + 1][i1 - 4];
                y[i2][i1] = yp0 = 0.5569527f * (xp0 - -0.64490664f * yp1 - -0.03850411f * yp2 - -0.01793403f * yp3 - -0.00708972f * yp4 - -0.5565992f * ym0 - -0.20031442f * ym1 - -0.08457147f * ym2 - -0.04141619f * ym3 - -0.02290331f * ym4);
            }
            if (n1 > 3) {
                yp4 = yp3;
                yp3 = yp2;
                yp2 = yp1;
                yp1 = yp0;
                xp0 = x[i2][3];
                ym0 = ym1;
                ym1 = ym2;
                ym2 = ym3;
                ym3 = ym4;
                y[i2][3] = yp0 = 0.5569527f * (xp0 - -0.64490664f * yp1 - -0.03850411f * yp2 - -0.01793403f * yp3 - -0.00708972f * yp4 - -0.5565992f * ym0 - -0.20031442f * ym1 - -0.08457147f * ym2 - -0.04141619f * ym3);
            }
            if (n1 > 2) {
                yp4 = yp3;
                yp3 = yp2;
                yp2 = yp1;
                yp1 = yp0;
                xp0 = x[i2][2];
                ym0 = ym1;
                ym1 = ym2;
                ym2 = ym3;
                y[i2][2] = yp0 = 0.5569527f * (xp0 - -0.64490664f * yp1 - -0.03850411f * yp2 - -0.01793403f * yp3 - -0.00708972f * yp4 - -0.5565992f * ym0 - -0.20031442f * ym1 - -0.08457147f * ym2);
            }
            if (n1 > 1) {
                yp4 = yp3;
                yp3 = yp2;
                yp2 = yp1;
                yp1 = yp0;
                xp0 = x[i2][1];
                ym0 = ym1;
                ym1 = ym2;
                y[i2][1] = yp0 = 0.5569527f * (xp0 - -0.64490664f * yp1 - -0.03850411f * yp2 - -0.01793403f * yp3 - -0.00708972f * yp4 - -0.5565992f * ym0 - -0.20031442f * ym1);
            }
            if (n1 <= 0) continue;
            yp4 = yp3;
            yp3 = yp2;
            yp2 = yp1;
            yp1 = yp0;
            xp0 = x[i2][0];
            ym0 = ym1;
            y[i2][0] = yp0 = 0.5569527f * (xp0 - -0.64490664f * yp1 - -0.03850411f * yp2 - -0.01793403f * yp3 - -0.00708972f * yp4 - -0.5565992f * ym0);
        }
    }

    public void applyInverseTranspose(float[][][] x, float[][][] y) {
        int n3m1;
        int n1 = x[0][0].length;
        int n2 = x[0].length;
        int n3 = x.length;
        int n1m1 = n1 - 1;
        int n2m1 = n2 - 1;
        for (int i3 = n3m1 = n3 - 1; i3 >= 0; --i3) {
            for (int i2 = n2m1; i2 >= 0; --i2) {
                float x00m0;
                float y0mm2 = 0.0f;
                float y0mm1 = 0.0f;
                float y0mm0 = 0.0f;
                float y0mp1 = 0.0f;
                float y0mp2 = 0.0f;
                float y00m2 = 0.0f;
                float y00m1 = 0.0f;
                float y00m0 = 0.0f;
                float ym0m0 = 0.0f;
                float ym0p1 = 0.0f;
                float ym0p2 = 0.0f;
                float ympm2 = 0.0f;
                float ympm1 = 0.0f;
                float ympm0 = 0.0f;
                float ympp1 = 0.0f;
                float ympp2 = 0.0f;
                if (n1 > 0) {
                    if (i2 < n2m1) {
                        y0mp1 = y[i3][i2 + 1][n1 - 1];
                    }
                    if (i3 < n3m1) {
                        ym0p1 = y[i3 + 1][i2][n1 - 1];
                        if (i2 > 0) {
                            ympp1 = y[i3 + 1][i2 - 1][n1 - 1];
                        }
                    }
                }
                if (n1 > 1) {
                    if (i2 < n2m1) {
                        y0mp2 = y[i3][i2 + 1][n1 - 2];
                    }
                    if (i3 < n3m1) {
                        ym0p2 = y[i3 + 1][i2][n1 - 2];
                        if (i2 > 0) {
                            ympp2 = y[i3 + 1][i2 - 1][n1 - 2];
                        }
                    }
                }
                for (int i1 = n1m1; i1 >= 2; --i1) {
                    x00m0 = x[i3][i2][i1];
                    y00m2 = y00m1;
                    y00m1 = y00m0;
                    if (i2 < n2m1) {
                        y0mm2 = y0mm1;
                        y0mm1 = y0mm0;
                        y0mm0 = y0mp1;
                        y0mp1 = y0mp2;
                        y0mp2 = y[i3][i2 + 1][i1 - 2];
                    }
                    if (i3 < n3m1) {
                        if (i2 > 0) {
                            ympm2 = ympm1;
                            ympm1 = ympm0;
                            ympm0 = ympp1;
                            ympp1 = ympp2;
                            ympp2 = y[i3 + 1][i2 - 1][i1 - 2];
                        }
                        ym0m0 = ym0p1;
                        ym0p1 = ym0p2;
                        ym0p2 = y[i3 + 1][i2][i1 - 2];
                    }
                    y[i3][i2][i1] = y00m0 = 0.4327046f * (x00m0 - -0.4805547f * y00m1 - -0.0143204f * y00m2 - -0.0291793f * y0mp2 - -0.1057476f * y0mp1 - -0.4572746f * y0mm0 - -0.0115732f * y0mm1 - -0.0047283f * y0mm2 - -0.0149963f * ympp2 - -0.0408317f * ympp1 - -0.0945958f * ympm0 - -0.0223166f * ympm1 - -0.0062781f * ympm2 - -0.0213786f * ym0p2 - -0.0898909f * ym0p1 - -0.4322719f * ym0m0);
                }
                if (n1 > 1) {
                    x00m0 = x[i3][i2][1];
                    y00m2 = y00m1;
                    y00m1 = y00m0;
                    y0mm2 = y0mm1;
                    y0mm1 = y0mm0;
                    y0mm0 = y0mp1;
                    y0mp1 = y0mp2;
                    ympm2 = ympm1;
                    ympm1 = ympm0;
                    ympm0 = ympp1;
                    ympp1 = ympp2;
                    ym0m0 = ym0p1;
                    ym0p1 = ym0p2;
                    y[i3][i2][1] = y00m0 = 0.4327046f * (x00m0 - -0.4805547f * y00m1 - -0.0143204f * y00m2 - -0.1057476f * y0mp1 - -0.4572746f * y0mm0 - -0.0115732f * y0mm1 - -0.0047283f * y0mm2 - -0.0408317f * ympp1 - -0.0945958f * ympm0 - -0.0223166f * ympm1 - -0.0062781f * ympm2 - -0.0898909f * ym0p1 - -0.4322719f * ym0m0);
                }
                if (n1 <= 0) continue;
                x00m0 = x[i3][i2][0];
                y00m2 = y00m1;
                y00m1 = y00m0;
                y0mm2 = y0mm1;
                y0mm1 = y0mm0;
                y0mm0 = y0mp1;
                ympm2 = ympm1;
                ympm1 = ympm0;
                ympm0 = ympp1;
                ym0m0 = ym0p1;
                y[i3][i2][0] = y00m0 = 0.4327046f * (x00m0 - -0.4805547f * y00m1 - -0.0143204f * y00m2 - -0.4572746f * y0mm0 - -0.0115732f * y0mm1 - -0.0047283f * y0mm2 - -0.0945958f * ympm0 - -0.0223166f * ympm1 - -0.0062781f * ympm2 - -0.4322719f * ym0m0);
            }
        }
    }
}

