/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

public class Conv {
    public static void conv(int lx, int kx, float[] x, int ly, int ky, float[] y, int lz, int kz, float[] z) {
        Conv.convFast(lx, kx, x, ly, ky, y, lz, kz, z);
    }

    public static void conv(int lx1, int lx2, int kx1, int kx2, float[][] x, int ly1, int ly2, int ky1, int ky2, float[][] y, int lz1, int lz2, int kz1, int kz2, float[][] z) {
        Conv.zero(lz1, lz2, z);
        int ilo2 = kz2 - kx2 - ky2;
        int ihi2 = ilo2 + lz2 - 1;
        for (int i2 = ilo2; i2 <= ihi2; ++i2) {
            int jlo2 = Math.max(0, i2 - ly2 + 1);
            int jhi2 = Math.min(lx2 - 1, i2);
            for (int j2 = jlo2; j2 <= jhi2; ++j2) {
                Conv.convSum(lx1, kx1, x[j2], ly1, ky1, y[i2 - j2], lz1, kz1, z[i2 - ilo2]);
            }
        }
    }

    public static void conv(int lx1, int lx2, int lx3, int kx1, int kx2, int kx3, float[][][] x, int ly1, int ly2, int ly3, int ky1, int ky2, int ky3, float[][][] y, int lz1, int lz2, int lz3, int kz1, int kz2, int kz3, float[][][] z) {
        Conv.zero(lz1, lz2, lz3, z);
        int ilo2 = kz2 - kx2 - ky2;
        int ilo3 = kz3 - kx3 - ky3;
        int ihi2 = ilo2 + lz2 - 1;
        int ihi3 = ilo3 + lz3 - 1;
        for (int i3 = ilo3; i3 <= ihi3; ++i3) {
            int jlo3 = Math.max(0, i3 - ly3 + 1);
            int jhi3 = Math.min(lx3 - 1, i3);
            for (int j3 = jlo3; j3 <= jhi3; ++j3) {
                for (int i2 = ilo2; i2 <= ihi2; ++i2) {
                    int jlo2 = Math.max(0, i2 - ly2 + 1);
                    int jhi2 = Math.min(lx2 - 1, i2);
                    for (int j2 = jlo2; j2 <= jhi2; ++j2) {
                        Conv.convSum(lx1, kx1, x[j3][j2], ly1, ky1, y[i3 - j3][i2 - j2], lz1, kz1, z[i3 - ilo3][i2 - ilo2]);
                    }
                }
            }
        }
    }

    public static void xcor(int lx, int kx, float[] x, int ly, int ky, float[] y, int lz, int kz, float[] z) {
        Conv.reverse(lx, x);
        kx = 1 - kx - lx;
        Conv.conv(lx, kx, x, ly, ky, y, lz, kz, z);
        Conv.reverse(lx, x);
    }

    public static void xcor(int lx1, int lx2, int kx1, int kx2, float[][] x, int ly1, int ly2, int ky1, int ky2, float[][] y, int lz1, int lz2, int kz1, int kz2, float[][] z) {
        Conv.reverse(lx1, lx2, x);
        kx1 = 1 - kx1 - lx1;
        kx2 = 1 - kx2 - lx2;
        Conv.conv(lx1, lx2, kx1, kx2, x, ly1, ly2, ky1, ky2, y, lz1, lz2, kz1, kz2, z);
        Conv.reverse(lx1, lx2, x);
    }

    public static void xcor(int lx1, int lx2, int lx3, int kx1, int kx2, int kx3, float[][][] x, int ly1, int ly2, int ly3, int ky1, int ky2, int ky3, float[][][] y, int lz1, int lz2, int lz3, int kz1, int kz2, int kz3, float[][][] z) {
        Conv.reverse(lx1, lx2, lx3, x);
        kx1 = 1 - kx1 - lx1;
        kx2 = 1 - kx2 - lx2;
        kx3 = 1 - kx3 - lx3;
        Conv.conv(lx1, lx2, lx3, kx1, kx2, kx3, x, ly1, ly2, ly3, ky1, ky2, ky3, y, lz1, lz2, lz3, kz1, kz2, kz3, z);
        Conv.reverse(lx1, lx2, lx3, x);
    }

    private static void convFast(int lx, int kx, float[] x, int ly, int ky, float[] y, int lz, int kz, float[] z) {
        float xb;
        float ya;
        float xa;
        int j;
        float yb;
        float sb;
        float sa;
        if (lx > ly) {
            int lt = lx;
            lx = ly;
            ly = lt;
            int kt = kx;
            kx = ky;
            ky = kt;
            float[] t = x;
            x = y;
            y = t;
        }
        int imin = kz - kx - ky;
        int imax = imin + lz - 1;
        int ilo = imin;
        int ihi = Math.min(-1, imax);
        int i = ilo;
        int iz = i - imin;
        while (i <= ihi) {
            z[iz] = 0.0f;
            ++i;
            ++iz;
        }
        ilo = Math.max(0, imin);
        ihi = Math.min(lx - 2, imax);
        int jlo = 0;
        int jhi = ilo;
        i = ilo;
        iz = i - imin;
        while (i < ihi) {
            sa = 0.0f;
            sb = 0.0f;
            yb = y[i - jlo + 1];
            for (j = jlo; j < jhi; j += 2) {
                xa = x[j];
                sb += xa * yb;
                ya = y[i - j];
                sa += xa * ya;
                xb = x[j + 1];
                sb += xb * ya;
                yb = y[i - j - 1];
                sa += xb * yb;
            }
            xa = x[j];
            sb += xa * yb;
            if (j == jhi) {
                ya = y[i - j];
                sa += xa * ya;
                xb = x[j + 1];
                sb += xb * ya;
            }
            z[iz] = sa;
            z[iz + 1] = sb;
            i += 2;
            iz += 2;
            jhi += 2;
        }
        if (i == ihi) {
            jlo = 0;
            jhi = i;
            sa = 0.0f;
            for (j = jlo; j <= jhi; ++j) {
                sa += x[j] * y[i - j];
            }
            z[iz] = sa;
        }
        ilo = Math.max(lx - 1, imin);
        ihi = Math.min(ly - 1, imax);
        jlo = 0;
        jhi = lx - 1;
        i = ilo;
        iz = i - imin;
        while (i < ihi) {
            sa = 0.0f;
            sb = 0.0f;
            yb = y[i - jlo + 1];
            for (j = jlo; j < jhi; j += 2) {
                xa = x[j];
                sb += xa * yb;
                ya = y[i - j];
                sa += xa * ya;
                xb = x[j + 1];
                sb += xb * ya;
                yb = y[i - j - 1];
                sa += xb * yb;
            }
            if (j == jhi) {
                xa = x[j];
                sb += xa * yb;
                ya = y[i - j];
                sa += xa * ya;
            }
            z[iz] = sa;
            z[iz + 1] = sb;
            i += 2;
            iz += 2;
        }
        if (i == ihi) {
            sa = 0.0f;
            for (j = jlo; j <= jhi; ++j) {
                sa += x[j] * y[i - j];
            }
            z[iz] = sa;
        }
        ilo = Math.max(ly, imin);
        ihi = Math.min(lx + ly - 2, imax);
        jlo = ihi - ly + 1;
        jhi = lx - 1;
        i = ihi;
        iz = i - imin;
        while (i > ilo) {
            sa = 0.0f;
            sb = 0.0f;
            yb = y[i - jhi - 1];
            for (j = jhi; j > jlo; j -= 2) {
                xa = x[j];
                sb += xa * yb;
                ya = y[i - j];
                sa += xa * ya;
                xb = x[j - 1];
                sb += xb * ya;
                yb = y[i - j + 1];
                sa += xb * yb;
            }
            xa = x[j];
            sb += xa * yb;
            if (j == jlo) {
                ya = y[i - j];
                sa += xa * ya;
                xb = x[j - 1];
                sb += xb * ya;
            }
            z[iz] = sa;
            z[iz - 1] = sb;
            i -= 2;
            iz -= 2;
            jlo -= 2;
        }
        if (i == ilo) {
            jlo = i - ly + 1;
            jhi = lx - 1;
            sa = 0.0f;
            for (j = jhi; j >= jlo; --j) {
                sa += x[j] * y[i - j];
            }
            z[iz] = sa;
        }
        ilo = Math.max(lx + ly - 1, imin);
        ihi = imax;
        i = ilo;
        iz = i - imin;
        while (i <= ihi) {
            z[iz] = 0.0f;
            ++i;
            ++iz;
        }
    }

    private static void convSum(int lx, int kx, float[] x, int ly, int ky, float[] y, int lz, int kz, float[] z) {
        float xb;
        float ya;
        float xa;
        int j;
        float yb;
        float sb;
        float sa;
        if (lx > ly) {
            int lt = lx;
            lx = ly;
            ly = lt;
            int kt = kx;
            kx = ky;
            ky = kt;
            float[] t = x;
            x = y;
            y = t;
        }
        int imin = kz - kx - ky;
        int imax = imin + lz - 1;
        int ilo = Math.max(0, imin);
        int ihi = Math.min(lx - 2, imax);
        int jlo = 0;
        int jhi = ilo;
        int i = ilo;
        int iz = i - imin;
        while (i < ihi) {
            sa = z[iz];
            sb = z[iz + 1];
            yb = y[i - jlo + 1];
            for (j = jlo; j < jhi; j += 2) {
                xa = x[j];
                sb += xa * yb;
                ya = y[i - j];
                sa += xa * ya;
                xb = x[j + 1];
                sb += xb * ya;
                yb = y[i - j - 1];
                sa += xb * yb;
            }
            xa = x[j];
            sb += xa * yb;
            if (j == jhi) {
                ya = y[i - j];
                sa += xa * ya;
                xb = x[j + 1];
                sb += xb * ya;
            }
            z[iz] = sa;
            z[iz + 1] = sb;
            i += 2;
            iz += 2;
            jhi += 2;
        }
        if (i == ihi) {
            jlo = 0;
            jhi = i;
            sa = z[iz];
            for (j = jlo; j <= jhi; ++j) {
                sa += x[j] * y[i - j];
            }
            z[iz] = sa;
        }
        ilo = Math.max(lx - 1, imin);
        ihi = Math.min(ly - 1, imax);
        jlo = 0;
        jhi = lx - 1;
        i = ilo;
        iz = i - imin;
        while (i < ihi) {
            sa = z[iz];
            sb = z[iz + 1];
            yb = y[i - jlo + 1];
            for (j = jlo; j < jhi; j += 2) {
                xa = x[j];
                sb += xa * yb;
                ya = y[i - j];
                sa += xa * ya;
                xb = x[j + 1];
                sb += xb * ya;
                yb = y[i - j - 1];
                sa += xb * yb;
            }
            if (j == jhi) {
                xa = x[j];
                sb += xa * yb;
                ya = y[i - j];
                sa += xa * ya;
            }
            z[iz] = sa;
            z[iz + 1] = sb;
            i += 2;
            iz += 2;
        }
        if (i == ihi) {
            sa = z[iz];
            for (j = jlo; j <= jhi; ++j) {
                sa += x[j] * y[i - j];
            }
            z[iz] = sa;
        }
        ilo = Math.max(ly, imin);
        ihi = Math.min(lx + ly - 2, imax);
        jlo = ihi - ly + 1;
        jhi = lx - 1;
        i = ihi;
        iz = i - imin;
        while (i > ilo) {
            sa = z[iz];
            sb = z[iz - 1];
            yb = y[i - jhi - 1];
            for (j = jhi; j > jlo; j -= 2) {
                xa = x[j];
                sb += xa * yb;
                ya = y[i - j];
                sa += xa * ya;
                xb = x[j - 1];
                sb += xb * ya;
                yb = y[i - j + 1];
                sa += xb * yb;
            }
            xa = x[j];
            sb += xa * yb;
            if (j == jlo) {
                ya = y[i - j];
                sa += xa * ya;
                xb = x[j - 1];
                sb += xb * ya;
            }
            z[iz] = sa;
            z[iz - 1] = sb;
            i -= 2;
            iz -= 2;
            jlo -= 2;
        }
        if (i == ilo) {
            jlo = i - ly + 1;
            jhi = lx - 1;
            sa = z[iz];
            for (j = jhi; j >= jlo; --j) {
                sa += x[j] * y[i - j];
            }
            z[iz] = sa;
        }
    }

    private static void zero(int n1, float[] z) {
        for (int i1 = 0; i1 < n1; ++i1) {
            z[i1] = 0.0f;
        }
    }

    private static void zero(int n1, int n2, float[][] z) {
        for (int i2 = 0; i2 < n2; ++i2) {
            Conv.zero(n1, z[i2]);
        }
    }

    private static void zero(int n1, int n2, int n3, float[][][] z) {
        for (int i3 = 0; i3 < n3; ++i3) {
            Conv.zero(n1, n2, z[i3]);
        }
    }

    private static void reverse(int n1, float[] z) {
        int i1 = 0;
        for (int j1 = n1 - 1; i1 < j1; ++i1, --j1) {
            float zt = z[i1];
            z[i1] = z[j1];
            z[j1] = zt;
        }
    }

    private static void reverse(int n1, int n2, float[][] z) {
        int i2 = 0;
        for (int j2 = n2 - 1; i2 < j2; ++i2, --j2) {
            float[] zt = z[i2];
            z[i2] = z[j2];
            z[j2] = zt;
        }
        for (i2 = 0; i2 < n2; ++i2) {
            Conv.reverse(n1, z[i2]);
        }
    }

    private static void reverse(int n1, int n2, int n3, float[][][] z) {
        int i3 = 0;
        for (int j3 = n3 - 1; i3 < j3; ++i3, --j3) {
            float[][] zt = z[i3];
            z[i3] = z[j3];
            z[j3] = zt;
        }
        for (i3 = 0; i3 < n3; ++i3) {
            Conv.reverse(n1, n2, z[i3]);
        }
    }
}

