/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.util.Array;
import edu.mines.jtk.util.Check;
import edu.mines.jtk.util.MathPlus;

public class CausalFilter {
    private int _m;
    private int _min1;
    private int _max1;
    private int _min2;
    private int _max2;
    private int _min3;
    private int _max3;
    private int[] _lag1;
    private int[] _lag2;
    private int[] _lag3;
    private float[] _a;
    private float _a0;
    private float _a0i;

    public CausalFilter(int[] lag1) {
        this(lag1, CausalFilter.impulse(lag1.length));
    }

    public CausalFilter(int[] lag1, int[] lag2) {
        this(lag1, lag2, CausalFilter.impulse(lag1.length));
    }

    public CausalFilter(int[] lag1, int[] lag2, int[] lag3) {
        this(lag1, lag2, lag3, CausalFilter.impulse(lag1.length));
    }

    public CausalFilter(int[] lag1, float[] a) {
        this.initLags(lag1, a);
        this.initA(a);
    }

    public CausalFilter(int[] lag1, int[] lag2, float[] a) {
        this.initLags(lag1, lag2, a);
        this.initA(a);
    }

    public CausalFilter(int[] lag1, int[] lag2, int[] lag3, float[] a) {
        this.initLags(lag1, lag2, lag3, a);
        this.initA(a);
    }

    public int[] getLag1() {
        return Array.copy(this._lag1);
    }

    public int[] getLag2() {
        return Array.copy(this._lag2);
    }

    public int[] getLag3() {
        return Array.copy(this._lag3);
    }

    public float[] getA() {
        return Array.copy(this._a);
    }

    public void factorWilsonBurg(int maxiter, float epsilon, float[] r) {
        Check.argument(r.length % 2 == 1, "r.length is odd");
        int m1 = this._max1 - this._min1;
        int n1 = r.length + 10 * m1;
        int l1 = (r.length - 1) / 2;
        int k1 = n1 - 1 - this._max1;
        float[] s = new float[n1];
        float[] t = new float[n1];
        float[] u = new float[n1];
        Array.copy(r.length, 0, r, k1 - l1, s);
        Array.zero(this._a);
        this._a[0] = MathPlus.sqrt(s[k1]);
        this._a0 = this._a[0];
        this._a0i = 1.0f / this._a[0];
        boolean converged = false;
        float eemax = s[k1] * epsilon;
        for (int niter = 0; niter < maxiter && !converged; ++niter) {
            this.applyInverseTranspose(s, t);
            this.applyInverse(t, u);
            int n = k1;
            u[n] = u[n] + 1.0f;
            int n2 = k1;
            u[n2] = u[n2] * 0.5f;
            for (int i1 = 0; i1 < k1; ++i1) {
                u[i1] = 0.0f;
            }
            this.apply(u, t);
            converged = true;
            for (int j = 0; j < this._m; ++j) {
                int j1 = k1 + this._lag1[j];
                if (0 > j1 || j1 >= n1) continue;
                float aj = t[j1];
                if (converged) {
                    float e = this._a[j] - aj;
                    converged = e * e <= eemax;
                }
                this._a[j] = aj;
            }
            this._a0 = this._a[0];
            this._a0i = 1.0f / this._a[0];
        }
        Check.state(converged, "Wilson-Burg iterations converged");
    }

    public void factorWilsonBurg(int maxiter, float epsilon, float[][] r) {
        Check.argument(r[0].length % 2 == 1, "r[0].length is odd");
        Check.argument(r.length % 2 == 1, "r.length is odd");
        int m1 = this._max1 - this._min1;
        int m2 = this._max2 - this._min2;
        int n1 = r[0].length + 10 * m1;
        int n2 = r.length + 10 * m2;
        int l1 = (r[0].length - 1) / 2;
        int l2 = (r.length - 1) / 2;
        int k1 = n1 - 1 - this._max1;
        int k2 = n2 - 1 - this._max2;
        float[][] s = new float[n2][n1];
        float[][] t = new float[n2][n1];
        float[][] u = new float[n2][n1];
        Array.copy(r[0].length, r.length, 0, 0, r, k1 - l1, k2 - l2, s);
        Array.zero(this._a);
        this._a[0] = MathPlus.sqrt(s[k2][k1]);
        this._a0 = this._a[0];
        this._a0i = 1.0f / this._a[0];
        boolean converged = false;
        float eemax = s[k2][k1] * epsilon;
        for (int niter = 0; niter < maxiter && !converged; ++niter) {
            this.applyInverseTranspose(s, t);
            this.applyInverse(t, u);
            float[] fArray = u[k2];
            int n = k1;
            fArray[n] = fArray[n] + 1.0f;
            float[] fArray2 = u[k2];
            int n3 = k1;
            fArray2[n3] = fArray2[n3] * 0.5f;
            for (int i2 = 0; i2 < k2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    u[i2][i1] = 0.0f;
                }
            }
            for (int i1 = 0; i1 < k1; ++i1) {
                u[k2][i1] = 0.0f;
            }
            this.apply(u, t);
            converged = true;
            for (int j = 0; j < this._m; ++j) {
                int j1 = k1 + this._lag1[j];
                int j2 = k2 + this._lag2[j];
                if (0 > j1 || j1 >= n1 || 0 > j2 || j2 >= n2) continue;
                float aj = t[j2][j1];
                if (converged) {
                    float e = this._a[j] - aj;
                    converged = e * e <= eemax;
                }
                this._a[j] = aj;
            }
            this._a0 = this._a[0];
            this._a0i = 1.0f / this._a[0];
        }
        Check.state(converged, "Wilson-Burg iterations converged");
    }

    public void factorWilsonBurg(int maxiter, float epsilon, float[][][] r) {
        Check.argument(r[0][0].length % 2 == 1, "r[0][0].length is odd");
        Check.argument(r[0].length % 2 == 1, "r[0].length is odd");
        Check.argument(r.length % 2 == 1, "r.length is odd");
        int m1 = this._max1 - this._min1;
        int m2 = this._max2 - this._min2;
        int m3 = this._max3 - this._min3;
        int n1 = r[0][0].length + 10 * m1;
        int n2 = r[0].length + 10 * m2;
        int n3 = r.length + 10 * m3;
        int l1 = (r[0][0].length - 1) / 2;
        int l2 = (r[0].length - 1) / 2;
        int l3 = (r.length - 1) / 2;
        int k1 = n1 - 1 - this._max1;
        int k2 = n2 - 1 - this._max2;
        int k3 = n3 - 1 - this._max3;
        float[][][] s = new float[n3][n2][n1];
        float[][][] t = new float[n3][n2][n1];
        float[][][] u = new float[n3][n2][n1];
        Array.copy(r[0][0].length, r[0].length, r.length, 0, 0, 0, r, k1 - l1, k2 - l2, k3 - l3, s);
        Array.zero(this._a);
        this._a[0] = MathPlus.sqrt(s[k3][k2][k1]);
        this._a0 = this._a[0];
        this._a0i = 1.0f / this._a[0];
        boolean converged = false;
        float eemax = s[k3][k2][k1] * epsilon;
        for (int niter = 0; niter < maxiter && !converged; ++niter) {
            this.applyInverseTranspose(s, t);
            this.applyInverse(t, u);
            float[] fArray = u[k3][k2];
            int n = k1;
            fArray[n] = fArray[n] + 1.0f;
            float[] fArray2 = u[k3][k2];
            int n4 = k1;
            fArray2[n4] = fArray2[n4] * 0.5f;
            for (int i3 = 0; i3 < k3; ++i3) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    for (int i1 = 0; i1 < n1; ++i1) {
                        u[i3][i2][i1] = 0.0f;
                    }
                }
            }
            for (int i2 = 0; i2 < k2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    u[k3][i2][i1] = 0.0f;
                }
            }
            for (int i1 = 0; i1 < k1; ++i1) {
                u[k3][k2][i1] = 0.0f;
            }
            this.apply(u, t);
            converged = true;
            for (int j = 0; j < this._m; ++j) {
                int j1 = k1 + this._lag1[j];
                int j2 = k2 + this._lag2[j];
                int j3 = k3 + this._lag3[j];
                if (0 > j1 || j1 >= n1 || 0 > j2 || j2 >= n2 || 0 > j3 || j3 >= n3) continue;
                float aj = t[j3][j2][j1];
                if (converged) {
                    float e = this._a[j] - aj;
                    converged = e * e <= eemax;
                }
                this._a[j] = aj;
            }
            this._a0 = this._a[0];
            this._a0i = 1.0f / this._a[0];
        }
        Check.state(converged, "Wilson-Burg iterations converged");
    }

    public void apply(float[] x, float[] y) {
        int k1;
        int j;
        float yi;
        int i1;
        int n1 = x.length;
        int i1lo = MathPlus.min(this._max1, n1);
        for (i1 = n1 - 1; i1 >= i1lo; --i1) {
            yi = this._a0 * x[i1];
            for (j = 1; j < this._m; ++j) {
                k1 = i1 - this._lag1[j];
                yi += this._a[j] * x[k1];
            }
            y[i1] = yi;
        }
        for (i1 = i1lo - 1; i1 >= 0; --i1) {
            yi = this._a0 * x[i1];
            for (j = 1; j < this._m; ++j) {
                k1 = i1 - this._lag1[j];
                if (0 > k1) continue;
                yi += this._a[j] * x[k1];
            }
            y[i1] = yi;
        }
    }

    public void applyTranspose(float[] x, float[] y) {
        int k1;
        int j;
        float yi;
        int i1;
        int n1 = x.length;
        int i1hi = MathPlus.max(n1 - this._max1, 0);
        for (i1 = 0; i1 < i1hi; ++i1) {
            yi = this._a0 * x[i1];
            for (j = 1; j < this._m; ++j) {
                k1 = i1 + this._lag1[j];
                yi += this._a[j] * x[k1];
            }
            y[i1] = yi;
        }
        for (i1 = i1hi; i1 < n1; ++i1) {
            yi = this._a0 * x[i1];
            for (j = 1; j < this._m; ++j) {
                k1 = i1 + this._lag1[j];
                if (k1 >= n1) continue;
                yi += this._a[j] * x[k1];
            }
            y[i1] = yi;
        }
    }

    public void applyInverse(float[] y, float[] x) {
        int k1;
        int j;
        float xi;
        int i1;
        int n1 = y.length;
        int i1lo = MathPlus.min(this._max1, n1);
        for (i1 = 0; i1 < i1lo; ++i1) {
            xi = y[i1];
            for (j = 1; j < this._m; ++j) {
                k1 = i1 - this._lag1[j];
                if (0 > k1) continue;
                xi -= this._a[j] * x[k1];
            }
            x[i1] = xi * this._a0i;
        }
        for (i1 = i1lo; i1 < n1; ++i1) {
            xi = y[i1];
            for (j = 1; j < this._m; ++j) {
                k1 = i1 - this._lag1[j];
                xi -= this._a[j] * x[k1];
            }
            x[i1] = xi * this._a0i;
        }
    }

    public void applyInverseTranspose(float[] y, float[] x) {
        int k1;
        int j;
        float xi;
        int i1;
        int n1 = y.length;
        int i1hi = MathPlus.max(n1 - this._max1, 0);
        for (i1 = n1 - 1; i1 >= i1hi; --i1) {
            xi = y[i1];
            for (j = 1; j < this._m; ++j) {
                k1 = i1 + this._lag1[j];
                if (k1 >= n1) continue;
                xi -= this._a[j] * x[k1];
            }
            x[i1] = xi * this._a0i;
        }
        for (i1 = i1hi - 1; i1 >= 0; --i1) {
            xi = y[i1];
            for (j = 1; j < this._m; ++j) {
                k1 = i1 + this._lag1[j];
                xi -= this._a[j] * x[k1];
            }
            x[i1] = xi * this._a0i;
        }
    }

    public void apply(float[][] x, float[][] y) {
        int k2;
        int k1;
        int j;
        float yi;
        int i1;
        int i2;
        int i1hi;
        int n1 = x[0].length;
        int n2 = x.length;
        int i1lo = MathPlus.max(0, this._max1);
        int i2lo = i1lo <= (i1hi = MathPlus.min(n1, n1 + this._min1)) ? MathPlus.min(this._max2, n2) : n2;
        for (i2 = n2 - 1; i2 >= i2lo; --i2) {
            for (i1 = n1 - 1; i1 >= i1hi; --i1) {
                yi = this._a0 * x[i2][i1];
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 - this._lag1[j];
                    k2 = i2 - this._lag2[j];
                    if (k1 >= n1) continue;
                    yi += this._a[j] * x[k2][k1];
                }
                y[i2][i1] = yi;
            }
            for (i1 = i1hi - 1; i1 >= i1lo; --i1) {
                yi = this._a0 * x[i2][i1];
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 - this._lag1[j];
                    k2 = i2 - this._lag2[j];
                    yi += this._a[j] * x[k2][k1];
                }
                y[i2][i1] = yi;
            }
            for (i1 = i1lo - 1; i1 >= 0; --i1) {
                yi = this._a0 * x[i2][i1];
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 - this._lag1[j];
                    k2 = i2 - this._lag2[j];
                    if (0 > k1) continue;
                    yi += this._a[j] * x[k2][k1];
                }
                y[i2][i1] = yi;
            }
        }
        for (i2 = i2lo - 1; i2 >= 0; --i2) {
            for (i1 = n1 - 1; i1 >= 0; --i1) {
                yi = this._a0 * x[i2][i1];
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 - this._lag1[j];
                    k2 = i2 - this._lag2[j];
                    if (0 > k1 || k1 >= n1 || 0 > k2) continue;
                    yi += this._a[j] * x[k2][k1];
                }
                y[i2][i1] = yi;
            }
        }
    }

    public void applyTranspose(float[][] x, float[][] y) {
        int k2;
        int k1;
        int j;
        float yi;
        int i1;
        int i2;
        int i1hi;
        int n1 = x[0].length;
        int n2 = x.length;
        int i1lo = MathPlus.max(0, -this._min1);
        int i2hi = i1lo <= (i1hi = MathPlus.min(n1, n1 - this._max1)) ? MathPlus.max(n2 - this._max2, 0) : 0;
        for (i2 = 0; i2 < i2hi; ++i2) {
            for (i1 = 0; i1 < i1lo; ++i1) {
                yi = this._a0 * x[i2][i1];
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 + this._lag1[j];
                    k2 = i2 + this._lag2[j];
                    if (0 > k1) continue;
                    yi += this._a[j] * x[k2][k1];
                }
                y[i2][i1] = yi;
            }
            for (i1 = i1lo; i1 < i1hi; ++i1) {
                yi = this._a0 * x[i2][i1];
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 + this._lag1[j];
                    k2 = i2 + this._lag2[j];
                    yi += this._a[j] * x[k2][k1];
                }
                y[i2][i1] = yi;
            }
            for (i1 = i1hi; i1 < n1; ++i1) {
                yi = this._a0 * x[i2][i1];
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 + this._lag1[j];
                    k2 = i2 + this._lag2[j];
                    if (k1 >= n1) continue;
                    yi += this._a[j] * x[k2][k1];
                }
                y[i2][i1] = yi;
            }
        }
        for (i2 = i2hi; i2 < n2; ++i2) {
            for (i1 = 0; i1 < n1; ++i1) {
                yi = this._a0 * x[i2][i1];
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 + this._lag1[j];
                    k2 = i2 + this._lag2[j];
                    if (0 > k1 || k1 >= n1 || k2 >= n2) continue;
                    yi += this._a[j] * x[k2][k1];
                }
                y[i2][i1] = yi;
            }
        }
    }

    public void applyInverse(float[][] y, float[][] x) {
        int k2;
        int k1;
        int j;
        float xi;
        int i1;
        int i2;
        int i1hi;
        int n1 = y[0].length;
        int n2 = y.length;
        int i1lo = MathPlus.min(this._max1, n1);
        int i2lo = i1lo <= (i1hi = MathPlus.min(n1, n1 + this._min1)) ? MathPlus.min(this._max2, n2) : n2;
        for (i2 = 0; i2 < i2lo; ++i2) {
            for (i1 = 0; i1 < n1; ++i1) {
                xi = y[i2][i1];
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 - this._lag1[j];
                    k2 = i2 - this._lag2[j];
                    if (0 > k1 || k1 >= n1 || 0 > k2) continue;
                    xi -= this._a[j] * x[k2][k1];
                }
                x[i2][i1] = xi * this._a0i;
            }
        }
        for (i2 = i2lo; i2 < n2; ++i2) {
            for (i1 = 0; i1 < i1lo; ++i1) {
                xi = y[i2][i1];
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 - this._lag1[j];
                    k2 = i2 - this._lag2[j];
                    if (0 > k1) continue;
                    xi -= this._a[j] * x[k2][k1];
                }
                x[i2][i1] = xi * this._a0i;
            }
            for (i1 = i1lo; i1 < i1hi; ++i1) {
                xi = y[i2][i1];
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 - this._lag1[j];
                    k2 = i2 - this._lag2[j];
                    xi -= this._a[j] * x[k2][k1];
                }
                x[i2][i1] = xi * this._a0i;
            }
            for (i1 = i1hi; i1 < n1; ++i1) {
                xi = y[i2][i1];
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 - this._lag1[j];
                    k2 = i2 - this._lag2[j];
                    if (k1 >= n1) continue;
                    xi -= this._a[j] * x[k2][k1];
                }
                x[i2][i1] = xi * this._a0i;
            }
        }
    }

    public void applyInverseTranspose(float[][] y, float[][] x) {
        int k2;
        int k1;
        int j;
        float xi;
        int i1;
        int i2;
        int i1hi;
        int n1 = y[0].length;
        int n2 = y.length;
        int i1lo = MathPlus.max(0, -this._min1);
        int i2hi = i1lo <= (i1hi = MathPlus.min(n1, n1 - this._max1)) ? MathPlus.max(n2 - this._max2, 0) : 0;
        for (i2 = n2 - 1; i2 >= i2hi; --i2) {
            for (i1 = n1 - 1; i1 >= 0; --i1) {
                xi = y[i2][i1];
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 + this._lag1[j];
                    k2 = i2 + this._lag2[j];
                    if (0 > k1 || k1 >= n1 || k2 >= n2) continue;
                    xi -= this._a[j] * x[k2][k1];
                }
                x[i2][i1] = xi * this._a0i;
            }
        }
        for (i2 = i2hi - 1; i2 >= 0; --i2) {
            for (i1 = n1 - 1; i1 >= i1hi; --i1) {
                xi = y[i2][i1];
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 + this._lag1[j];
                    k2 = i2 + this._lag2[j];
                    if (k1 >= n1) continue;
                    xi -= this._a[j] * x[k2][k1];
                }
                x[i2][i1] = xi * this._a0i;
            }
            for (i1 = i1hi - 1; i1 >= i1lo; --i1) {
                xi = y[i2][i1];
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 + this._lag1[j];
                    k2 = i2 + this._lag2[j];
                    xi -= this._a[j] * x[k2][k1];
                }
                x[i2][i1] = xi * this._a0i;
            }
            for (i1 = i1lo - 1; i1 >= 0; --i1) {
                xi = y[i2][i1];
                for (j = 1; j < this._m; ++j) {
                    k1 = i1 + this._lag1[j];
                    k2 = i2 + this._lag2[j];
                    if (0 > k1) continue;
                    xi -= this._a[j] * x[k2][k1];
                }
                x[i2][i1] = xi * this._a0i;
            }
        }
    }

    public void apply(float[][][] x, float[][][] y) {
        int k3;
        int k2;
        int k1;
        int j;
        float yi;
        int i1;
        int i2;
        int i3;
        int n1 = x[0][0].length;
        int n2 = x[0].length;
        int n3 = x.length;
        int i1lo = MathPlus.max(0, this._max1);
        int i1hi = MathPlus.min(n1, n1 + this._min1);
        int i2lo = MathPlus.max(0, this._max2);
        int i2hi = MathPlus.min(n2, n2 + this._min2);
        int i3lo = i1lo <= i1hi && i2lo <= i2hi ? MathPlus.min(this._max3, n3) : n3;
        for (i3 = n3 - 1; i3 >= i3lo; --i3) {
            for (i2 = n2 - 1; i2 >= i2hi; --i2) {
                for (i1 = n1 - 1; i1 >= 0; --i1) {
                    yi = this._a0 * x[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (0 > k1 || k1 >= n1 || k2 >= n2) continue;
                        yi += this._a[j] * x[k3][k2][k1];
                    }
                    y[i3][i2][i1] = yi;
                }
            }
            for (i2 = i2hi - 1; i2 >= i2lo; --i2) {
                for (i1 = n1 - 1; i1 >= i1hi; --i1) {
                    yi = this._a0 * x[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (k1 >= n1) continue;
                        yi += this._a[j] * x[k3][k2][k1];
                    }
                    y[i3][i2][i1] = yi;
                }
                for (i1 = i1hi - 1; i1 >= i1lo; --i1) {
                    yi = this._a0 * x[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        yi += this._a[j] * x[k3][k2][k1];
                    }
                    y[i3][i2][i1] = yi;
                }
                for (i1 = i1lo - 1; i1 >= 0; --i1) {
                    yi = this._a0 * x[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (0 > k1) continue;
                        yi += this._a[j] * x[k3][k2][k1];
                    }
                    y[i3][i2][i1] = yi;
                }
            }
            for (i2 = i2lo - 1; i2 >= 0; --i2) {
                for (i1 = n1 - 1; i1 >= 0; --i1) {
                    yi = this._a0 * x[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (0 > k1 || k1 >= n1 || 0 > k2) continue;
                        yi += this._a[j] * x[k3][k2][k1];
                    }
                    y[i3][i2][i1] = yi;
                }
            }
        }
        for (i3 = i3lo - 1; i3 >= 0; --i3) {
            for (i2 = n2 - 1; i2 >= 0; --i2) {
                for (i1 = n1 - 1; i1 >= 0; --i1) {
                    yi = this._a0 * x[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (0 > k1 || k1 >= n1 || 0 > k2 || k2 >= n2 || 0 > k3) continue;
                        yi += this._a[j] * x[k3][k2][k1];
                    }
                    y[i3][i2][i1] = yi;
                }
            }
        }
    }

    public void applyTranspose(float[][][] x, float[][][] y) {
        int k3;
        int k2;
        int k1;
        int j;
        float yi;
        int i1;
        int i2;
        int i3;
        int n1 = x[0][0].length;
        int n2 = x[0].length;
        int n3 = x.length;
        int i1lo = MathPlus.max(0, -this._min1);
        int i1hi = MathPlus.min(n1, n1 - this._max1);
        int i2lo = MathPlus.max(0, -this._min2);
        int i2hi = MathPlus.min(n2, n2 - this._max2);
        int i3hi = i1lo <= i1hi && i2lo <= i2hi ? MathPlus.max(n3 - this._max3, 0) : 0;
        for (i3 = 0; i3 < i3hi; ++i3) {
            for (i2 = 0; i2 < i2lo; ++i2) {
                for (i1 = 0; i1 < n1; ++i1) {
                    yi = this._a0 * x[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 + this._lag1[j];
                        k2 = i2 + this._lag2[j];
                        k3 = i3 + this._lag3[j];
                        if (0 > k1 || k1 >= n1 || 0 > k2) continue;
                        yi += this._a[j] * x[k3][k2][k1];
                    }
                    y[i3][i2][i1] = yi;
                }
            }
            for (i2 = i2lo; i2 < i2hi; ++i2) {
                for (i1 = 0; i1 < i1lo; ++i1) {
                    yi = this._a0 * x[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 + this._lag1[j];
                        k2 = i2 + this._lag2[j];
                        k3 = i3 + this._lag3[j];
                        if (0 > k1) continue;
                        yi += this._a[j] * x[k3][k2][k1];
                    }
                    y[i3][i2][i1] = yi;
                }
                for (i1 = i1lo; i1 < i1hi; ++i1) {
                    yi = this._a0 * x[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 + this._lag1[j];
                        k2 = i2 + this._lag2[j];
                        k3 = i3 + this._lag3[j];
                        yi += this._a[j] * x[k3][k2][k1];
                    }
                    y[i3][i2][i1] = yi;
                }
                for (i1 = i1hi; i1 < n1; ++i1) {
                    yi = this._a0 * x[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 + this._lag1[j];
                        k2 = i2 + this._lag2[j];
                        k3 = i3 + this._lag3[j];
                        if (k1 >= n1) continue;
                        yi += this._a[j] * x[k3][k2][k1];
                    }
                    y[i3][i2][i1] = yi;
                }
            }
            for (i2 = i2hi; i2 < n2; ++i2) {
                for (i1 = 0; i1 < n1; ++i1) {
                    yi = this._a0 * x[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 + this._lag1[j];
                        k2 = i2 + this._lag2[j];
                        k3 = i3 + this._lag3[j];
                        if (0 > k1 || k1 >= n1 || k2 >= n2) continue;
                        yi += this._a[j] * x[k3][k2][k1];
                    }
                    y[i3][i2][i1] = yi;
                }
            }
        }
        for (i3 = i3hi; i3 < n3; ++i3) {
            for (i2 = 0; i2 < n2; ++i2) {
                for (i1 = 0; i1 < n1; ++i1) {
                    yi = this._a0 * x[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 + this._lag1[j];
                        k2 = i2 + this._lag2[j];
                        k3 = i3 + this._lag3[j];
                        if (0 > k1 || k1 >= n1 || 0 > k2 || k2 >= n2 || k3 >= n3) continue;
                        yi += this._a[j] * x[k3][k2][k1];
                    }
                    y[i3][i2][i1] = yi;
                }
            }
        }
    }

    public void applyInverse(float[][][] y, float[][][] x) {
        int k3;
        int k2;
        int k1;
        int j;
        float xi;
        int i1;
        int i2;
        int i3;
        int n1 = y[0][0].length;
        int n2 = y[0].length;
        int n3 = y.length;
        int i1lo = MathPlus.max(0, this._max1);
        int i1hi = MathPlus.min(n1, n1 + this._min1);
        int i2lo = MathPlus.max(0, this._max2);
        int i2hi = MathPlus.min(n2, n2 + this._min2);
        int i3lo = i1lo <= i1hi && i2lo <= i2hi ? MathPlus.min(this._max3, n3) : n3;
        for (i3 = 0; i3 < i3lo; ++i3) {
            for (i2 = 0; i2 < n2; ++i2) {
                for (i1 = 0; i1 < n1; ++i1) {
                    xi = y[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (0 > k1 || k1 >= n1 || 0 > k2 || k2 >= n2 || 0 > k3) continue;
                        xi -= this._a[j] * x[k3][k2][k1];
                    }
                    x[i3][i2][i1] = xi * this._a0i;
                }
            }
        }
        for (i3 = i3lo; i3 < n3; ++i3) {
            for (i2 = 0; i2 < i2lo; ++i2) {
                for (i1 = 0; i1 < n1; ++i1) {
                    xi = y[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (0 > k1 || k1 >= n1 || 0 > k2) continue;
                        xi -= this._a[j] * x[k3][k2][k1];
                    }
                    x[i3][i2][i1] = xi * this._a0i;
                }
            }
            for (i2 = i2lo; i2 < i2hi; ++i2) {
                for (i1 = 0; i1 < i1lo; ++i1) {
                    xi = y[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (0 > k1) continue;
                        xi -= this._a[j] * x[k3][k2][k1];
                    }
                    x[i3][i2][i1] = xi * this._a0i;
                }
                for (i1 = i1lo; i1 < i1hi; ++i1) {
                    xi = y[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        xi -= this._a[j] * x[k3][k2][k1];
                    }
                    x[i3][i2][i1] = xi * this._a0i;
                }
                for (i1 = i1hi; i1 < n1; ++i1) {
                    xi = y[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (k1 >= n1) continue;
                        xi -= this._a[j] * x[k3][k2][k1];
                    }
                    x[i3][i2][i1] = xi * this._a0i;
                }
            }
            for (i2 = i2hi; i2 < n2; ++i2) {
                for (i1 = 0; i1 < n1; ++i1) {
                    xi = y[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 - this._lag1[j];
                        k2 = i2 - this._lag2[j];
                        k3 = i3 - this._lag3[j];
                        if (0 > k1 || k1 >= n1 || k2 >= n2) continue;
                        xi -= this._a[j] * x[k3][k2][k1];
                    }
                    x[i3][i2][i1] = xi * this._a0i;
                }
            }
        }
    }

    public void applyInverseTranspose(float[][][] y, float[][][] x) {
        int k3;
        int k2;
        int k1;
        int j;
        float xi;
        int i1;
        int i2;
        int i3;
        int n1 = y[0][0].length;
        int n2 = y[0].length;
        int n3 = y.length;
        int i1lo = MathPlus.max(0, -this._min1);
        int i1hi = MathPlus.min(n1, n1 - this._max1);
        int i2lo = MathPlus.max(0, -this._min2);
        int i2hi = MathPlus.min(n2, n2 - this._max2);
        int i3hi = i1lo <= i1hi && i2lo <= i2hi ? MathPlus.max(n3 - this._max3, 0) : 0;
        for (i3 = n3 - 1; i3 >= i3hi; --i3) {
            for (i2 = n2 - 1; i2 >= 0; --i2) {
                for (i1 = n1 - 1; i1 >= 0; --i1) {
                    xi = y[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 + this._lag1[j];
                        k2 = i2 + this._lag2[j];
                        k3 = i3 + this._lag3[j];
                        if (0 > k1 || k1 >= n1 || 0 > k2 || k2 >= n2 || k3 >= n3) continue;
                        xi -= this._a[j] * x[k3][k2][k1];
                    }
                    x[i3][i2][i1] = xi * this._a0i;
                }
            }
        }
        for (i3 = i3hi - 1; i3 >= 0; --i3) {
            for (i2 = n2 - 1; i2 >= i2hi; --i2) {
                for (i1 = n1 - 1; i1 >= 0; --i1) {
                    xi = y[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 + this._lag1[j];
                        k2 = i2 + this._lag2[j];
                        k3 = i3 + this._lag3[j];
                        if (0 > k1 || k1 >= n1 || k2 >= n2) continue;
                        xi -= this._a[j] * x[k3][k2][k1];
                    }
                    x[i3][i2][i1] = xi * this._a0i;
                }
            }
            for (i2 = i2hi - 1; i2 >= i2lo; --i2) {
                for (i1 = n1 - 1; i1 >= i1hi; --i1) {
                    xi = y[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 + this._lag1[j];
                        k2 = i2 + this._lag2[j];
                        k3 = i3 + this._lag3[j];
                        if (k1 >= n1) continue;
                        xi -= this._a[j] * x[k3][k2][k1];
                    }
                    x[i3][i2][i1] = xi * this._a0i;
                }
                for (i1 = i1hi - 1; i1 >= i1lo; --i1) {
                    xi = y[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 + this._lag1[j];
                        k2 = i2 + this._lag2[j];
                        k3 = i3 + this._lag3[j];
                        xi -= this._a[j] * x[k3][k2][k1];
                    }
                    x[i3][i2][i1] = xi * this._a0i;
                }
                for (i1 = i1lo - 1; i1 >= 0; --i1) {
                    xi = y[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 + this._lag1[j];
                        k2 = i2 + this._lag2[j];
                        k3 = i3 + this._lag3[j];
                        if (0 > k1) continue;
                        xi -= this._a[j] * x[k3][k2][k1];
                    }
                    x[i3][i2][i1] = xi * this._a0i;
                }
            }
            for (i2 = i2lo - 1; i2 >= 0; --i2) {
                for (i1 = n1 - 1; i1 >= 0; --i1) {
                    xi = y[i3][i2][i1];
                    for (j = 1; j < this._m; ++j) {
                        k1 = i1 + this._lag1[j];
                        k2 = i2 + this._lag2[j];
                        k3 = i3 + this._lag3[j];
                        if (0 > k1 || k1 >= n1 || 0 > k2) continue;
                        xi -= this._a[j] * x[k3][k2][k1];
                    }
                    x[i3][i2][i1] = xi * this._a0i;
                }
            }
        }
    }

    private static float[] impulse(int nlag) {
        float[] a = new float[nlag];
        a[0] = 1.0f;
        return a;
    }

    private void initLags(int[] lag1, float[] a) {
        Check.argument(lag1.length > 0, "lag1.length>0");
        Check.argument(lag1.length == a.length, "lag1.length==a.length");
        Check.argument(lag1[0] == 0, "lag1[0]==0");
        for (int j = 1; j < a.length; ++j) {
            Check.argument(lag1[j] > 0, "lag1[" + j + "]>0");
        }
        this._m = lag1.length;
        this._lag1 = Array.copy(lag1);
        this._lag2 = Array.zeroint(this._m);
        this._lag3 = Array.zeroint(this._m);
        this._min1 = Array.min(lag1);
        this._max1 = Array.max(lag1);
    }

    private void initLags(int[] lag1, int[] lag2, float[] a) {
        Check.argument(lag1.length > 0, "lag1.length>0");
        Check.argument(lag1.length == a.length, "lag1.length==a.length");
        Check.argument(lag2.length == a.length, "lag2.length==a.length");
        Check.argument(lag1[0] == 0, "lag1[0]==0");
        Check.argument(lag2[0] == 0, "lag2[0]==0");
        for (int j = 1; j < a.length; ++j) {
            Check.argument(lag2[j] >= 0, "lag2[" + j + "]>=0");
            if (lag2[j] != 0) continue;
            Check.argument(lag1[j] > 0, "if lag2==0, lag1[" + j + "]>0");
        }
        this._m = lag1.length;
        this._lag1 = Array.copy(lag1);
        this._lag2 = Array.copy(lag2);
        this._lag3 = Array.zeroint(this._m);
        this._min1 = Array.min(lag1);
        this._min2 = Array.min(lag2);
        this._max1 = Array.max(lag1);
        this._max2 = Array.max(lag2);
    }

    private void initLags(int[] lag1, int[] lag2, int[] lag3, float[] a) {
        Check.argument(lag1.length > 0, "lag1.length>0");
        Check.argument(lag1.length == a.length, "lag1.length==a.length");
        Check.argument(lag2.length == a.length, "lag2.length==a.length");
        Check.argument(lag3.length == a.length, "lag3.length==a.length");
        Check.argument(lag1[0] == 0, "lag1[0]==0");
        Check.argument(lag2[0] == 0, "lag2[0]==0");
        Check.argument(lag3[0] == 0, "lag3[0]==0");
        for (int j = 1; j < a.length; ++j) {
            Check.argument(lag3[j] >= 0, "lag3[" + j + "]>=0");
            if (lag3[j] != 0) continue;
            Check.argument(lag2[j] >= 0, "if lag3==0, lag2[" + j + "]>=0");
            if (lag2[j] != 0) continue;
            Check.argument(lag1[j] > 0, "if lag3==0 && lag2==0, lag1[" + j + "]>0");
        }
        this._m = a.length;
        this._lag1 = Array.copy(lag1);
        this._lag2 = Array.copy(lag2);
        this._lag3 = Array.copy(lag3);
        this._min1 = Array.min(lag1);
        this._min2 = Array.min(lag2);
        this._min3 = Array.min(lag3);
        this._max1 = Array.max(lag1);
        this._max2 = Array.max(lag2);
        this._max3 = Array.max(lag3);
    }

    private void initA(float[] a) {
        this._a = Array.copy(a);
        this._a0 = a[0];
        this._a0i = 1.0f / a[0];
    }
}

