/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.RecursiveCascadeFilter;
import edu.mines.jtk.util.Cdouble;
import edu.mines.jtk.util.Check;
import edu.mines.jtk.util.MathPlus;

public class ButterworthFilter
extends RecursiveCascadeFilter {
    private Cdouble[] _poles;
    private Cdouble[] _zeros;
    private double _gain;

    public ButterworthFilter(double fl, double al, double fh, double ah) {
        Check.argument(0.0 < fl, "0.0<fl");
        Check.argument(fl < fh, "fl<fh");
        Check.argument(fh < 0.5, "fh<0.5");
        Check.argument(0.0 < al, "0.0<al");
        Check.argument(al < 1.0, "al<1.0");
        Check.argument(al != ah, "al!=ah");
        Check.argument(0.0 < ah, "0.0<ah");
        Check.argument(ah < 1.0, "ah<1.0");
        double wl = Math.PI * 2 * fl;
        double wh = Math.PI * 2 * fh;
        double xl = 2.0 * MathPlus.tan(wl / 2.0);
        double xh = 2.0 * MathPlus.tan(wh / 2.0);
        double pl = al * al;
        double ph = ah * ah;
        if (al >= ah) {
            int np = (int)MathPlus.ceil(0.5 * MathPlus.log(pl * (1.0 - ph) / (ph * (1.0 - pl))) / MathPlus.log(xh / xl));
            double xc = xl * MathPlus.pow(pl / (1.0 - pl), 0.5 / (double)np);
            double wc = 2.0 * MathPlus.atan(xc / 2.0);
            double fc = 0.5 * wc / Math.PI;
            this.makePolesZerosGain(fc, np, Type.LOW_PASS);
        } else {
            int np = (int)MathPlus.ceil(0.5 * MathPlus.log(ph * (1.0 - pl) / (pl * (1.0 - ph))) / MathPlus.log(xh / xl));
            double xc = xh * MathPlus.pow((1.0 - ph) / ph, 0.5 / (double)np);
            double wc = 2.0 * MathPlus.atan(xc / 2.0);
            double fc = 0.5 * wc / Math.PI;
            this.makePolesZerosGain(fc, np, Type.HIGH_PASS);
        }
        this.init(this._poles, this._zeros, this._gain);
    }

    public ButterworthFilter(double fc, int np, Type type) {
        Check.argument(0.0 < fc, "0.0<fc");
        Check.argument(fc < 0.5, "fc<0.5");
        Check.argument(np > 0, "np>0");
        this.makePolesZerosGain(fc, np, type);
        this.init(this._poles, this._zeros, this._gain);
    }

    private void makePolesZerosGain(double fc, int np, Type type) {
        boolean lowpass = type == Type.LOW_PASS;
        double omegac = 2.0 * MathPlus.tan(Math.PI * fc);
        double dtheta = Math.PI / (double)np;
        double ftheta = 0.5 * dtheta * (double)(np + 1);
        this._poles = new Cdouble[np];
        this._zeros = new Cdouble[np];
        Cdouble c1 = new Cdouble(1.0, 0.0);
        Cdouble c2 = new Cdouble(2.0, 0.0);
        Cdouble zj = lowpass ? c1.neg() : c1;
        Cdouble gain = new Cdouble(c1);
        int j = 0;
        int k = np - 1;
        while (j < np) {
            double theta = ftheta + (double)j * dtheta;
            Cdouble sj = Cdouble.polar(omegac, theta);
            this._zeros[j] = zj;
            if (j == k) {
                this._poles[j] = c2.plus(sj).over(c2.minus(sj));
                this._poles[j].i = 0.0;
            } else if (j < k) {
                this._poles[j] = c2.plus(sj).over(c2.minus(sj));
                this._poles[k] = this._poles[j].conj();
            }
            if (lowpass) {
                gain.timesEquals(sj.over(sj.minus(c2)));
            } else {
                gain.timesEquals(c2.over(c2.minus(sj)));
            }
            ++j;
            --k;
        }
        this._gain = gain.r;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        LOW_PASS,
        HIGH_PASS;

    }
}

